#ifdef ASCEND
#define	ASCEND_H

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

/*
 *
 *      Copyright (c) 1996 Ascend Communications, Inc.
 *      All rights reserved.
 *
 *	Permission to copy all or part of this material for any purpose is
 *	granted provided that the above copyright notice and this paragraph
 *	are duplicated in all copies.  THIS SOFTWARE IS PROVIDED ``AS IS''
 *	AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 *	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE.
 *
 */

/*
 *	static char     rcsid[] = "$Id: ascend.h,v 1.2 1998/06/11 18:40:17 web Exp $";
 */

#define	VC_ASCEND			123	/* Vendor Code */

/*	Ascend Specific Packet Types (codes) */

#define	PW_TERMINATE_SESSION		31
#define	PW_PASSWORD_EXPIRED		32
#define	PW_ASCEND_EVENT_REQUEST		33
#define	PW_ASCEND_EVENT_RESPONSE	34

#define	PW_ASCEND_RADIPA_ALLOCATE	50
#define	PW_ASCEND_RADIPA_RELEASE	51

/*	Ascend Specific Attributes */

#define	ASCEND_ASSIGN_IP_CLIENT		144	/* ipaddr */
#define	ASCEND_ASSIGN_IP_SERVER		145	/* ipaddr */
#define	ASCEND_ASSIGN_IP_GLOBAL_POOL	146	/* string */

#define	PW_ASCEND_ARADES		181	/* string */

#define	CI_ASCEND_TOKEN_IDLE		199	/* integer */
#define	CI_ASCEND_TOKEN_EXPIRY		204	/* integer */

#define	CI_ASCEND_PW_WARNING		207	/* integer */
#define	CI_ASCEND_PW_LIFETIME		208	/* integer */

#define	ASCEND_IP_POOL_DEFINITION	217	/* string */

#ifdef ASCEND_SECRET
/*
 * The name/number of the string attribute that will be encoded in response
 * packets.  The encoding is similar to the way PAP secrets are encoded in
 * request packets.
 */
#define	ASCEND_SEND_SECRET		214	/* string */
#define	ASCEND_RECV_SECRET		215	/* string */
#endif	/* ASCEND_SECRET */

/*	Ascend Specific Attribute Values */

#define	ASCEND_ARA			255	/* Ascend extension */

/*	Miscellaneous Ascend definitions */

typedef UINT4   ipaddr_t;

typedef struct address_chunk
{
	ipaddr_t        base_address;
	long            count;	/* number of contiguous addresses from base */
} ADDRESS_CHUNK;

#ifndef RADIPA_HOSTS
#define	RADIPA_HOSTS		"radipa-hosts"
#endif

#define	MAX_CLIENT_ADDRESSES	256
#define	MAX_ADDRESS_CHUNKS	128
#define	RADIPA_ALLOCATE		1
#define	RADIPA_RELEASE		2
#define	RADIPA_POLL_ROUTERS	3

typedef struct radipa_packet
{
	char            rp_code;
	char            rp_pad;
	short           rp_count;
	void           *rp_handle;
	ipaddr_t        rp_router_address;
	ipaddr_t        rp_ip_address;
	union
	{
		ADDRESS_CHUNK   u_chunks[MAX_ADDRESS_CHUNKS];
		ipaddr_t        u_client_addresses[MAX_CLIENT_ADDRESSES];
	} rp_u;
} RADIPA_PACKET;

#define	RP_CHUNKS		rp_u.u_chunks
#define	SIZEOF_RADIPA		(sizeof (RADIPA_PACKET) \
				 - sizeof ((RADIPA_PACKET *) 0)->RP_CHUNKS)
#define	SIZEOF_RADIPA_ALLOCATE(count) (SIZEOF_RADIPA \
				       + sizeof (ADDRESS_CHUNK) * (count))

#define	RADIPA_STARTUP_PORT	9990
#define	RADIPA_STARTUP_PROTO	"tcp"
#define	RADIPA_STARTUP_NAME	"radipa-startup"

#define	RADIPA_SERVICE_PORT	9992
#define	RADIPA_SERVICE_PROTO	"udp"
#define	RADIPA_SERVICE_NAME	"radipa-service"

#ifndef INADDR_ANY
#define	INADDR_ANY ((unsigned long) 0)
#endif

#ifndef INADDR_NONE
#define	INADDR_NONE ((UINT4) 0xffffffff)
#endif

#ifndef INADDR_BROADCAST
#define	INADDR_BROADCAST ((UINT4) 0xffffffff)
#endif

#define	CALLOC(t, n) ((t *) calloc (sizeof (t), (n)))
#define	CALLOC(t, n) ((t *) calloc (sizeof (t), (n)))
#define	MALLOC(t, n) ((t *) malloc (sizeof (t) * (n)))
#define	REALLOC(o, t, n) ((t *) realloc ((o), sizeof (t) * (n)))

#endif	/* ASCEND */
