/*
 * RADIUS -- Remote Authentication Dial In User Service
 *
 *
 * Livingston Enterprises, Inc. 6920 Koll Center Parkway Pleasanton, CA   94566
 *
 * Copyright 1992 Livingston Enterprises, Inc.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose and without fee is hereby granted, provided that this copyright
 * and permission notice appear on all copies and supporting documentation,
 * the name of Livingston Enterprises, Inc. not be used in advertising or
 * publicity pertaining to distribution of the program without specific
 * prior permission, and notice be given in supporting documentation that
 * copying and distribution is by permission of Livingston Enterprises, Inc.
 *
 * Livingston Enterprises, Inc. makes no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 */

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation
 * for any purpose and without fee is hereby granted, provided:
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof,
 *
 * 2) that both the copyright notice and this permission and disclaimer notice
 *    appear in all supporting documentation, and
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

/*
 *
 * Public entry points in this file:
 *
 * ack_action
 * add_dns_nbns
 * add_string
 * add_string_dump
 * attribute_out
 * attribute_pw_out
 * authtype_toa
 * auth_vectortoa
 * avpair_add
 * avpair_add_attr_tag
 * avpair_add_tag
 * avpair_add_vend
 * avpair_add_vend_tag
 * avpair_assign
 * avpair_assign_tag
 * avpair_comp
 * avpair_del
 * avpair_del_ci
 * avpair_dup
 * avpair_free
 * avpair_get
 * avpair_get_tag
 * avpair_get_vend
 * avpair_get_vend_tag
 * avpair_out
 * avpair_string_mod
 * avpair_vtoa
 * build_header
 * build_packet
 * build_reply_mic
 * build_request_mic
 * check_mic
 * compress_file
 * debug_list
 * debug_pair
 * dumpit
 * fdcmp
 * free_linklist
 * fprint_attr_val
 * fprint_attr_val_sws
 * gen_valpairs
 * get_errmsg
 * get_ipaddr
 * get_last_vp
 * get_last_vp_vend
 * get_memory
 * get_next_word
 * get_passwd
 * get_realm_name
 * get_vp
 * get_vp_ci
 * get_vp_vend
 * get_word_list
 * good_ipaddr
 * hex_dump
 * insert_vp
 * list_cat
 * list_copy
 * list_free
 * lockfile
 * logfmt_accounting
 * _logit
 * logit
 * mf_ent_toa
 * missing_attribute
 * missing_attribute_vend
 * new_stringn
 * packet_log
 * parse_realm
 * parse_realm2
 * prune_pairs
 * rad_fork
 * rad_ptitle
 * rad_vptitle
 * rad_sleep
 * rad_strncpy
 * _rad_strdup
 * rad_time
 * radius_dbfile
 * _reply_message
 * reply_sprintf
 * reset_attr_flag
 * reset_stderr
 * reset_vp_attr_flags_list
 * reset_vp_flag
 * reset_vp_flags_list
 * safe_free
 * set_attr_flag
 * set_vp_attr_flags_list
 * set_vp_flag
 * set_vp_flags_list
 * set_realm_name
 * setup_logfile
 * setupsock
 * switch_by_name
 * type_string
 * xget_word_list
 *
 */

static char     rcsid[] = "$Id: funcs.c,v 1.24 1998/07/27 20:53:38 web Exp $";

#include	<sys/types.h>
#include	<sys/param.h>

#ifdef sys5
#include	<sys/sysmacros.h>
#endif	/* sys5 */

#include	<sys/socket.h>
#include	<sys/time.h>

#if defined(aix) || defined(ultrix)
#include	<fcntl.h>
#else	/* aix */
#include	<sys/fcntl.h>
#endif	/* aix */

#include	<sys/file.h>
#include	<sys/stat.h>
#include	<sys/wait.h>
#include	<net/if.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<ctype.h>
#include	<errno.h>
#include	<dirent.h>
#include	<memory.h>
#include	<syslog.h>
#include	<unistd.h>

#include	"radius.h"

/* Seconds from 1/1/1900 to 1/1/1970 (1900 wasn't a leap year) */
/* (((365 * 70) + (70/4)) * 24 * 60 * 60) = 2208988800 */

#ifdef __STDC__
#define	NTP_TIME_DIFF		(2208988800UL)
#else
#define	NTP_TIME_DIFF		((UINT4)2208988800)
#endif

#ifndef LIST_COPY_LIMIT
#define	LIST_COPY_LIMIT		512   /* Limit number of items we will copy. */
#endif

#ifndef AVPAIR_LIST_LENGTH_MAX
#define	AVPAIR_LIST_LENGTH_MAX	(LIST_COPY_LIMIT*40) /* Should be big enough */
#endif

extern int       debug_flag;
extern int       doing_init;
extern int       dumpcore;
extern int       file_logging;
extern int       spawn_flag;
extern int       zap_logfile;

#if !defined(__FreeBSD__) && !defined(_BSDI_VERSION) && !defined(__NetBSD__)
extern int       sys_nerr;
extern char     *sys_errlist[];
#endif	/* __FreeBSD__ */

extern FILE     *ddt;
extern FILE     *msgfd;
extern char     *radius_dir;
extern AATVPTR   rad_authen_aatv;
extern time_t    birthdate;
extern char      ourhostname[MAXHOSTNAMELEN];
extern char    **environ;			/* provided by the system */

/* allow logit() function to be overridden */
static int _logit PROTO((int, int, CONST char *, ...));
int (*logit) PROTO((int, int, CONST char *, ...)) = _logit;

int	packet_log_switch = 0x03;	/*
					 * 0x00 / Don't search!
					 * 0x01 / Search original request
					 * 0x02 / Search current request
					 * 0x04 / Compare original and current
					 * 0x08 / Core dump if original doesn't
					 *		match current.
					 */

/* radius_child == 1 means we're a child and can modify process title */
int              radius_child = 0;

/* Simple linked list of similarily hased entries */
typedef struct add_string_string_struct
{
	struct add_string_string_struct *next;		/* case-sensitive */
	char                             buff[1];	/* allocated string */
} ADD_STRING_STRING;

static UINT4 add_string_news = 0;
static ADD_STRING_STRING *add_string_table[ADD_STRING_HASH_SIZE];

static int add_string_hash PROTO((char *));
static int add_string_hash_lowercase PROTO((char *));
static char * add_string_insert PROTO((char *, int, AS_CONVERT));
static int add_string_qlen PROTO((ADD_STRING_STRING *));
static UINT4 add_string_qstrlen PROTO((ADD_STRING_STRING *));
static int add_string_strlowercmp PROTO((char *, ADD_STRING_STRING *));
static int avpair_list_length PROTO((VALUE_PAIR *));
static void avpair_string_free PROTO((char *));

#ifdef BINARY_FILTERS
static char * binary_vtoa PROTO((radfilter *));
#endif	/* BINARY_FILTERS */

static int generate26 PROTO((VALUE_PAIR ***, u_char *, long, UINT4));
static int gen_wrap PROTO((int, UINT4, UINT4, int, u_char *, u_char *,
				VALUE_PAIR *, VALUE_PAIR ***, UINT4, int));
static int insert_attribute PROTO((DICT_ATTR *, AUTH_HDR *, UINT4, void *, int,
				int, VENDOR_LIST *, int));
static char *packet_log_validate PROTO((AUTH_REQ *, int, UINT4, int *, int));

static int      active_vpstrings = 0;
MF_ENT          vp_mf = { 0, 0 };		/* For value pair allocation */

char           *radius_log_fmt = RADIUS_LOG_FMT;
char          **radius_argv = (char **) NULL;	/* Original argv[] in main. */
char          **radius_envp = (char **) NULL;	/* Will hold environ pointer. */
int             radius_argc = -1;		/* Original argc in main. */
u_short         list_copy_limit = LIST_COPY_LIMIT;

/*
 *	Enable logfile switching based on time of day, etc.
 */

typedef struct
{
	struct stat	stat;			/* Result of stat() call. */
	int		errcode;		/* Zero ==> OK, else errno. */
	char		name[MAXPATHLEN];	/* Full file name. */
} logfile_info;

/*
 * Define a dummy client entry for status-servers requests from unknown clients
 */

CLIENT_ENTRY dummy_status_server_client =
{
	NULL,			/* *next */
	NULL,			/* *ipaddress */
	MGMT_POLL_SECRET,	/* *secret */
	"",			/* *prefix */
	"",			/* *hostname */
	NULL,			/* *names */
	(VENDOR_LIST *) NULL,	/* *veps */
	(EVENT_ENT *) NULL,     /* *event_q */
	0,			/* expire_time */
	0,			/* auth_port */
	0,			/* acct_port */
	IP_DNS,			/* type */
	CE_DUMMY,		/* client_type */
	CLEANUP_DELAY,		/* reply_holdtime */
	0,			/* version */
	CLIENT_NO_TS,		/* flags */

#ifdef USR_CCA
	0			/* state */
#endif	/* USR_CCA */

};


static int     backoff_logfile PROTO((logfile_info *, u_int));
static int     stat_logfile_info PROTO((logfile_info *));

static AATV     ack_aatv = DEF_AATV_DIRECT_TYPE("ACK", AA_ALLOW, ack_action);

AATVPTR  rad_ack_aatv = & ack_aatv;

/*************************************************************************
 *
 *	Function: ack_action
 *
 *	Purpose: Utility AATV which always responds positively.
 *
 *************************************************************************/

int
ack_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char     *func = "ack_action";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	return EV_ACK;
} /* end of ack_action () */

#ifdef USR_CCA

/******************************************************************************
 *
 *	Function: add_dns_nbns
 *
 *	Purpose: Adds the Primary and Secondary DNS, NBNS server IP addresses
 *		 to the list of avpairs, if not already present.
 *
 *****************************************************************************/

int
add_dns_nbns (authreq, auth_ent)

AUTH_REQ      *authreq;
AUTH_ENTRY    *auth_ent;

{
	IP_ADDRESS      *pdns = (IP_ADDRESS *) NULL;
	char            *func = "add_dns_nbns";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (auth_ent->dns_info != (IP_ADDRESS *) NULL &&
		get_vp_vend (authreq->cur_request, PW_PRIMARY_DNS_SERVER,
							VC_USR) == NULL_VP)
	{
		pdns = auth_ent->dns_info;
		if (avpair_add_vend (&authreq->cur_request,
				     PW_PRIMARY_DNS_SERVER,
				     &pdns->ipaddr.s_addr, sizeof (UINT4),
				     VC_USR) == NULL_VP)
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: Problem adding Primary DNS Server", func);
			return 1;
		}
	}

	if (pdns != (IP_ADDRESS *) NULL &&
		get_vp_vend (authreq->cur_request, PW_SECONDARY_DNS_SERVER,
							VC_USR) == NULL_VP)
	{
		pdns = pdns->next;
		if (pdns != (IP_ADDRESS *) NULL)
		{
			if (avpair_add_vend (&authreq->cur_request,
				       PW_SECONDARY_DNS_SERVER,
				       &pdns->ipaddr.s_addr, sizeof (UINT4),
				       VC_USR) == NULL_VP)
			{
				logit (LOG_DAEMON, LOG_ERR,
				      "%s: Problem adding Secondary DNS Server",
					func);
				return 1;
			}
		}
	}

	if (auth_ent->nbns_info != (IP_ADDRESS *) NULL &&
		get_vp_vend (authreq->cur_request, PW_PRIMARY_NBNS_SERVER,
							VC_USR) == NULL_VP)
	{
		pdns = auth_ent->nbns_info;
		if (avpair_add_vend (&authreq->cur_request,
				PW_PRIMARY_NBNS_SERVER, &pdns->ipaddr.s_addr,
				sizeof (UINT4), VC_USR) == NULL_VP)
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: Problem adding Primary NBNS Server", func);
			return 1;
		}
	}

	if (pdns != (IP_ADDRESS *) NULL &&
	get_vp_vend (authreq->cur_request, PW_SECONDARY_NBNS_SERVER, VC_USR)
								== NULL_VP)
	{
		pdns = pdns->next;
		if (pdns != (IP_ADDRESS *) NULL)
		{
			if (avpair_add_vend (&authreq->cur_request,
				PW_SECONDARY_NBNS_SERVER, &pdns->ipaddr.s_addr,
				sizeof (UINT4), VC_USR) == NULL_VP)
			{
				logit (LOG_DAEMON, LOG_ERR,
				     "%s: Problem adding Secondary NBNS Server",
					func);
				return 1;
			}
		}
	}
	return 0;
} /* end of add_dns_nbns () */

#endif /* USR_CCA */

/*************************************************************************
 *
 *	Function: add_string
 *
 *	Purpose: Maintain single copies of configuration strings.
 *
 *	Remarks: This version is implemented to maintain a hash table
 *		 for faster string lookup.
 *
 *************************************************************************/

char *
add_string (string, convert)

char          *string;
AS_CONVERT     convert;

{
	int                index;	/* hash value */
	ADD_STRING_STRING *find;	/* list we found in the hash table */
	static char       *func = "add_string";

	dprintf(5, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((!doing_init) && (convert & (ASSTATIC | FINDONLY)) == 0)
	{
		logit (LOG_DAEMON, LOG_ALERT, "%s: FATAL Non-init time call",
			func);
		dumpcore = 1;	/* Force a core dump to find out why */
		abort ();
	}

	if (!string)
	{
		string = "";	/* Convert NULL pointer to null string */
	}

	if (convert & ASLC)	/* Do lowercase lookup. */
	{
		index = add_string_hash_lowercase (string);
		if (index < 0)
		{
			logit (LOG_DAEMON, LOG_ERR,
			   "%s: FATAL: unable to determine index_case for '%s'",
				func, string);
			dumpcore = 1;
			abort ();
		}

		find = add_string_table[index];
		for ( ; find; find = find->next)
		{
			if (add_string_strlowercmp (string, find) == 0)
			{
				return (find->buff);
			}
		}
	}
	else
	{
		index = add_string_hash (string);
		if (index < 0)
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: FATAL: unable to determine index for '%s'",
				func, string);
			dumpcore = 1;
			abort ();
		}
		find = add_string_table[index];
		for ( ; find; find = find->next)
		{
			if (strcmp (string, find->buff) == 0)
			{
				return (find->buff);
			}
		}
	}

	/* Check to see if this is an existence test... */
	if (convert & FINDONLY)
        {
		return (NULL);
	}

	/* Insert it now (or fail) */
	return add_string_insert (string, index, convert);

} /* end of add_string () */

/******************************************************************************
 *
 *	Function: add_string_dump
 *
 *	Purpose: Report on utilization of add_string hash table.
 *
 *	Note: Only generates report if debugging is on.
 *
 *****************************************************************************/

void
add_string_dump ()

{
	int                i;
	int                len;
	static char       *func = "add_string_dump";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (debug_flag <= 0)
	{
		return;
	}

	logit (LOG_DAEMON, LOG_DEBUG, "%s: %d strings added",
		func, add_string_news);

	for (i = 0; i < ADD_STRING_HASH_SIZE; i++)
	{
		len = add_string_qlen (add_string_table[i]);

		if (len > 0)
		{
			logit (LOG_DAEMON, LOG_DEBUG,
				"%s: %5d -> %3d (%lu bytes)",
				func, i, len,
				add_string_qstrlen (add_string_table[i]));
		}
	}

} /* end of add_string_dump () */

/******************************************************************************
 *
 *	Function: add_string_hash
 *
 *	Purpose: Produce a hash value between 0 and ADD_STRING_HASH_SIZE
 *		 based on an ASCII string.
 *
 *	Returns: hash value ( 0 <= value < ADD_STRING_HASH_SIZE )
 *		 -1 indicates a NULL string
 *		 -2 indicates a non-ASCII string.
 *
 *****************************************************************************/

static int
add_string_hash (str)

char *str;

{
	int                result = 0;		/* Returned value. */
	int                value;		/* Intermediate value. */
	static char       *func = "add_string_hash";

	dprintf(5, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (str == (char *) NULL)
	{
		logit (LOG_ERR, LOG_DAEMON, "%s: NULL parameter", func);
		return -1;
	}

	for ( ; *str ; str++ )
	{
	        /* Allow only ASCII values in here. */
		if ((value = (u_char) *str) < 0x01)
		{
			logit (LOG_ERR, LOG_DAEMON,
				"%s: Non-ASCII value, 0x%2.2x", func, *str);
			return (-2);
		}

		value -= (u_char) 0x01;
		result += value + 1;	/* Include length of string in hash. */
	}

	/* Normalize this to the hash table size. */
	result = (result % ADD_STRING_HASH_SIZE);

	return (result);	/* Return calculated hash value. */
} /* end of add_string_hash () */

/******************************************************************************
 *
 *	Function: add_string_hash_lowercase
 *
 *	Purpose: Produce a hash value between 0 and ADD_STRING_HASH_SIZE
 *		 based on an ASCII string.  Make the hash case-insensitive.
 *
 *	Returns: hash value ( 0 <= value < ADD_STRING_HASH_SIZE )
 *		 -1 indicates a NULL string
 *		 -2 indicates a non-ASCII string.
 *
 *****************************************************************************/

static int
add_string_hash_lowercase (str)

char *str;

{
	int                result = 0;		/* Returned value. */
	int                value;		/* Intermediate value. */
	static char       *func = "add_string_hash_lowercase";

	dprintf(5, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (str == (char *) NULL)
	{
		logit (LOG_ERR, LOG_DAEMON, "%s: NULL parameter", func);
		return -1;
	}

	for ( ; *str ; str++)
	{
		/* Allow only ASCII values in here. */
		if ((value = (u_char) *str) < 0x01)
		{
			logit (LOG_ERR, LOG_DAEMON,
				"%s: Non-ASCII value, 0x%2.2x", func, *str);
			return (-2);
		}

		/* Make this lowercase, as necessary. */
		if (isupper(value))
		{
			value = tolower(value);
		}
		
		value -= (u_char) 0x01;
		result += value + 1;	/* Include length of string in hash. */
	}

	/* Normalize this to the hash table size. */
	result = (result % ADD_STRING_HASH_SIZE);

	return (result);	/* Return calculated hash value. */
} /* end of add_string_hash_lowercase () */

/******************************************************************************
 *
 *	Function: add_string_insert
 *
 *	Purpose: Allocate and insert a new string into the hashed
 *		 string tables.
 *
 *	Returns: A pointer to the string in the table.
 *
 *	Remarks: Uses pre-computed hash values, if available.
 *
 *****************************************************************************/

static char *
add_string_insert (str, index, convert)

char       *str;	/* Source string to copy and insert. */
int         index;	/* Hash index value, or -1 */
AS_CONVERT  convert;	/* Convert string to lowercase? */

{
	int                 changed = 0;	/* Was string changed? */
	int                 len;		/* Length of string. */
	char               *dest;		/* Copy character to here. */
	char               *from;		/* Copy character from here. */
	ADD_STRING_STRING  *new;		/* New string to insert. */
	ADD_STRING_STRING **put;		/* How we insert. */
	static char        *func = "add_string_insert";

	dprintf(5, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/* Use separate malloc() for every string.  Don't block for now. */
	len = sizeof (ADD_STRING_STRING) + strlen (str); /* buf[1] makes room */
	if ((new = (ADD_STRING_STRING *) malloc (len)) ==
						(ADD_STRING_STRING *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR, "%s: FATAL: malloc(%d) for '%s'",
			func, len, str);
		abort ();
	}
	new->next = (ADD_STRING_STRING *) NULL;
	add_string_news++;		/* Count number we allocate. */

	/* If lowercase conversion required, do it here. */
	if (convert & ASLC)
	{
		for (dest = new->buff, from = str;
			*from != '\0';
			dest++, from++)
		{
			if (isupper(*from))
			{
				changed = 1;	/* remember to change hash */
				*dest = tolower(*from);
			}
			else
			{
				*dest = *from;	/* simple copy */
			}
		}
		*dest = '\0';	/* Terminate string properly. */
	}
	else
	{
		strcpy (new->buff, str);	/* straight in */
	}

	/* If we changed the string to lowercase, recompute the hash. */
	if (changed > 0)
	{
		index = add_string_hash (new->buff);
	}

	/* Put it at the end of the hash-list. */
	for (put = &add_string_table[index]; *put; put = &((*put)->next))
	{
		;	/* continue */
	}

	*put = new;		/* Add it to the end of the list. */

	/* And return the string. */
	return (new->buff);

} /* end of add_string_insert () */

/******************************************************************************
 *
 *	Function: add_string_strlowercmp
 *
 *	Purpose: Compare a test string against a table entry like
 *		 strcmp()/strcasecmp().
 *
 *	Returns: 0 if the strings are equal
 *		-1 if the test string is "less" than the table entry.
 *		 1 if the test string is "more" than the table entry.
 *		-2 if there is a parameter error (and errno is set.)
 *
 *****************************************************************************/

static int
add_string_strlowercmp (test, list)

char           *test;		/* case insensitive test string */
ADD_STRING_STRING *list;	/* !!! case SENSITIVE comparison string */

{
	u_char             ch;		/* Copy here from test for lowering. */
	u_char            *pos;		/* Our position in list. */
	static char       *func = "add_string_strlowercmp";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((test == (char *) NULL) || (list == (ADD_STRING_STRING *) NULL))
	{
		errno = EINVAL;
		return (-2);		/* XXX: Should abort() here instead? */
	}

	for (pos = (u_char *) list->buff;
		(*test != '\0') && (*pos != '\0');
		test++, pos++)
	{
		ch = (u_char) *test;  /* Get test character to check. */
		if (isupper(ch))
		{
			ch = tolower(ch);	/* Force it to lowercase. */
		}

		if (ch != (u_char) *pos)
		{
			if (ch < (u_char) *pos)
			{
				return (-1);
			}

			/* fall through to else. */
			return (1);
		}
	}

	if ((*pos == '\0') && (*test == '\0'))
	{
		return (0);	/* equal strings! */
	}

	if (*test != '\0')
	{
		return (1);	/* If any of 'test' remains, it is greater! */
	}

	return (-1);		/* Otherwise... */
} /* end of add_string_strlowercmp () */

/******************************************************************************
 *
 *	Function: add_string_qlen
 *
 *	Purpose: Report the number of elements of the hash list.
 *
 *	Returns: Count of the number of elements in the hash list.
 *
 *****************************************************************************/

static int
add_string_qlen (list)

ADD_STRING_STRING *list;

{
	int                result = 0;
	static char       *func = "add_string_qlen";

	dprintf(5, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	for ( ; list != (ADD_STRING_STRING *) NULL; list = list->next)
	{
		result++;
	}
	return result;
} /* end of add_string_qlen () */

/******************************************************************************
 *
 *	Function: add_string_qstrlen
 *
 *	Purpose: Sum the lengths of all the strings in the hash list.
 *
 *	Returns: Sum of the lengths of all the strings in the hash list.
 *
 *****************************************************************************/

static UINT4
add_string_qstrlen (list)

ADD_STRING_STRING *list;

{
	UINT4              result = 0L;
	static char       *func = "add_string_qstrlen";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	for ( ; list != (ADD_STRING_STRING *) NULL; list = list->next)
	{
		result += strlen (list->buff);
	}

	return result;
} /* end of add_string_qstrlen () */

/******************************************************************************
 *
 *	Function: attribute_out
 *
 *	Purpose: Directly add an attribute (w/o an avpair) to the output buffer
 *
 *	Returns: length of packet (positive values),
 *		  0, error -- unable to insert attribute (general),
 *		 -1, fatal error ???,
 *		 -2, maxlen exceeded.
 *
 *****************************************************************************/

int
attribute_out (auth, maxlen, attribute, vendor_id, valptr, len, av_flags, veps)

AUTH_HDR       *auth;          /* packet buffer */
UINT4           maxlen;
int             attribute;
UINT4           vendor_id;
void           *valptr;
int             len;
int             av_flags;
VENDOR_LIST    *veps;		/* Do vendor specific mapping, if present */

{
	int              ret;
	DICT_ATTR       *attr;
	static char     *func = "attribute_out";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((attr = dict_attrget (attribute, vendor_id)) == (DICT_ATTR *) NULL)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: FATAL: Couldn't find attr %d(%ld)",
			func, attribute, vendor_id);
		dumpcore = 1;		/* Force a core dump to find out why */
		abort ();
	}

	/* This code doesn't support tags. */
	if (attr->type == PW_TYPE_TAG_STR)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: Doesn't support tag-str data type for %s",
			func, attr->name);
		return (0);
	}
	else if (attr->type == PW_TYPE_TAG_INT)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: Doesn't support tag-int data type for %s",
			func, attr->name);
		return (0);
	}

	if ((attr->flags & ATTR_ENCAPS) != 0)
	{
		av_flags |= VPF_ENCAPS;
	}

	ret = insert_attribute (attr, auth, maxlen, valptr,
				len, av_flags, veps, 0);	/* tag == 0 */

	if (ret <= 0)
	{
		logit (LOG_DAEMON, LOG_ALERT,
	"%s: insert_attribute(%s(%d), ..., %d, 0x%p, %d, 0x%x, %s) returns %d",
			func, attr->name, attribute, maxlen, valptr, len,
			av_flags, vendor_list_toa (veps), ret);
	}

	return ret;
} /* end of attribute_out () */

/******************************************************************************
 *
 *	Function: attribute_out_tag
 *
 *	Purpose: Directly add an attribute (w/o an avpair) to the output buffer
 *
 *	Returns: length of packet (positive values),
 *		  0, error -- unable to insert attribute (general),
 *		 -1, fatal error ???,
 *		 -2, maxlen exceeded.
 *
 *****************************************************************************/

int
attribute_out_tag (auth, max, attr, vendor_id, valptr, len, tag, av_flags, veps)

AUTH_HDR       *auth;		/* The packet buffer. */
UINT4           max;		/* Maximum output length. */
int             attr;		/* The attribute number. */
UINT4           vendor_id;
void           *valptr;
int             len;
int             tag;		/* The tag for tagged attributes. */
int             av_flags;
VENDOR_LIST    *veps;		/* Do vendor specific mapping, if present. */

{
	int              ret;
	DICT_ATTR       *attribute;
	static char     *func = "attribute_out_tag";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((attribute = dict_attrget (attr, vendor_id)) == (DICT_ATTR *) NULL)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: FATAL: Couldn't find attribute %d(%ld)",
			func, attr, vendor_id);
		dumpcore = 1;		/* Force a core dump to find out why */
		abort ();
	}

	if ((attribute->flags & ATTR_ENCAPS) != 0)
	{
		av_flags |= VPF_ENCAPS;
	}

	ret = insert_attribute (attribute, auth, max, valptr,
				len, av_flags, veps, tag);

	if (ret <= 0)
	{
		logit (LOG_DAEMON, LOG_ALERT,
	"%s: insert_attribute(%s(%d), ..., %d, 0x%p, %d, 0x%x, %s) returns %d",
			func, attribute->name, attr, max, valptr, len,
			av_flags, vendor_list_toa (veps), ret);
	}

	return ret;
} /* end of attribute_out_tag () */

/******************************************************************************
 *
 *	Function: attribute_pw_out
 *
 *	Purpose: Directly add a password attribute (w/o an avpair)
 *		 to the output buffer
 *
 *	Returns: Length of output buffer.
 *
 *****************************************************************************/

int
attribute_pw_out (auth, maxlen, passwd, secret)

AUTH_HDR     *auth;
UINT4         maxlen;
char         *passwd;
char         *secret;

{
	int             i;
	int             len;
	int             pass;
	int             passes;
	int             secretlen;
	u_char         *ptr;
	u_char         *vector_ptr;
	u_char          digest[AUTH_VECTOR_LEN];
	u_char          md5buf[MAX_SECRET_LENGTH + AUTH_VECTOR_LEN];
	u_char          passbuf[AUTH_PASS_LEN];
	static char    *func = "attribute_pw_out";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (auth->code == PW_EXTENDED_FORMAT)
	{
		vector_ptr = auth->vector;
	}
	else
	{
		vector_ptr = ((AUTH_HDR1 *) auth)->vector;
	}
		
	/* Encrypt the Password */
	len = strlen (passwd);
	if (len > AUTH_PASS_LEN)
	{
		len = AUTH_PASS_LEN;
	}

	memset ((char *) passbuf, '\0', AUTH_PASS_LEN);
	memcpy ((char *) passbuf, passwd, len);

	/* Calculate the MD5 Digest */
	secretlen = strlen (secret);
	strcpy ((char *) md5buf, secret);
	memcpy ((char *) md5buf + secretlen, vector_ptr, AUTH_VECTOR_LEN);

	/* Compute number of encryption passes needed */
	passes = MAX(1, (len + AUTH_VECTOR_LEN - 1) / AUTH_VECTOR_LEN);
	ptr = passbuf;
	for (pass = 0; pass < passes; pass++)
	{
		md5_calc (digest, md5buf, secretlen + AUTH_VECTOR_LEN);

		/* Xor the password into the MD5 digest */
		for (i = 0; i < AUTH_VECTOR_LEN; i++)
		{
			ptr[i] ^= digest[i];
		}
		memcpy ((char *) md5buf + secretlen, (char *) ptr,
							AUTH_VECTOR_LEN);
		ptr += AUTH_VECTOR_LEN;
	}

	memset (md5buf, 0, secretlen);
	pass = attribute_out (auth, maxlen, PW_USER_PASSWORD, 0, passbuf,
					ptr - passbuf, 0, (VENDOR_LIST *) NULL);
	if (pass <= 0)
	{
		logit (LOG_DAEMON, LOG_ALERT,
 "%s: attribute_out(..., %d, PW_USER_PASSWORD, 0, 0x%p, %d, NULL) returns %d)",
			func, maxlen, passbuf, (int) (ptr - passbuf), pass);
	}

	return pass;
} /* end of attribute_pw_out () */

/******************************************************************************
 *
 *	Function: authtype_toa
 *
 *	Purpose: Return a string representation of the authreq code.
 *
 *	Returns: pointer to static string.
 *
 *****************************************************************************/

char *
authtype_toa (code)

int             code;		/* code indicating authen, acct, etc. */

{
	static char      *typelist[] =
	{
		"invalid(0)",		/*  0 invalid */
		"access",		/*  1 PW_ACCESS_REQUEST */
		"accept",		/*  2 PW_ACCESS_ACCEPT */
		"reject",		/*  3 PW_ACCESS_REJECT */
		"acct-req",		/*  4 PW_ACCOUNTING_REQUEST */
		"acct-resp",		/*  5 PW_ACCOUNTING_RESPONSE */
		"acct-status",		/*  6 PW_ACCOUNTING_STATUS */
		"pw-request",		/*  7 PW_PASSWORD_REQUEST */
		"pw-ack",		/*  8 PW_PASSWORD_ACK */
		"pw-reject",		/*  9 PW_PASSWORD_REJECT */
		"acct-msg",		/* 10 PW_ACCOUNTING_MESSAGE */
		"access-challenge",	/* 11 PW_ACCESS_CHALLENGE */
		"status-server",	/* 12 PW_STATUS_SERVER */
		"status-client",	/* 13 PW_STATUS_CLIENT */
		"unknown(14)",		/* 14 *unknown* */
		"unknown(15)",		/* 15 *unknown* */
		"unknown(16)",		/* 16 *unknown* */
		"unknown(17)",		/* 17 *unknown* */
		"unknown(18)",		/* 18 *unknown* */
		"unknown(19)",		/* 19 *unknown* */
		"unknown(20)",		/* 20 *unknown* */
		"resource-free-req",	/* 21 PW_RESOURCE_FREE_REQ */
		"resource-free-resp",	/* 22 PW_RESOURCE_FREE_RESP */
		"resource-query-req",	/* 23 PW_RESOURCE_QUERY_REQ */
		"resource-query-resp",  /* 24 PW_RESOURCE_QUERY_RESP */
		"unknown(25)",		/* 25 *unknown* */
		"nas-reb-req",		/* 26 PW_NAS_REB_REQ */
		"nas-reb-resp",		/* 27 PW_NAS_REB_RESP */
		"unknown(28)",		/* 28 *unknown* */
		"unknown(29)",		/* 29 *unknown* */
		"unknown(30)",		/* 30 *unknown* */
		"ascend-term-sess",	/* 31 PW_TERMINATE_SESSION */
		"ascend-pw-exp",	/* 32 PW_PASSWORD_EXPIRED */
		"ascend-ev-req",	/* 33 PW_ASCEND_EVENT_REQUEST */
		"ascend-ev-resp",	/* 34 PW_ASCEND_EVENT_RESPONSE */
		"unknown(35)",		/* 35 *unknown* */
		"unknown(36)",		/* 36 *unknown* */
		"unknown(37)",		/* 37 *unknown* */
		"unknown(38)",		/* 38 *unknown* */
		"unknown(39)",		/* 39 *unknown* */
		"unknown(40)",		/* 40 *unknown* */
		"unknown(41)",		/* 41 *unknown* */
		"unknown(42)",		/* 42 *unknown* */
		"unknown(43)",		/* 43 *unknown* */
		"unknown(44)",		/* 44 *unknown* */
		"unknown(45)",		/* 45 *unknown* */
		"unknown(46)",		/* 46 *unknown* */
		"unknown(47)",		/* 47 *unknown* */
		"unknown(48)",		/* 48 *unknown* */
		"unknown(49)",		/* 49 *unknown* */
		"ascend-ip-alloc",	/* 50 PW_ASCEND_RADIPA_ALLOCATE */
		"ascend-ip-rel",	/* 51 PW_ASCEND_RADIPA_RELEASE */
	};

	static char      *v2_typelist[] =
	{
		"v2-unknown(256)",	/* 256 *unknown* */
		"v2-unknown(257)",	/* 257 *unknown* */
		"v2-unknown(258)",	/* 258 *unknown* */
		"v2-unknown(259)",	/* 259 *unknown* */
		"v2-unknown(260)",	/* 260 *unknown* */
		"v2-resource-free-req",	/* 261 PW_RESOURCE_FREE_REQ */
		"v2-resource-free-resp",/* 262 PW_RESOURCE_FREE_RESP */
		"v2-resource-query-req", /* 263 PW_RESOURCE_QUERY_REQ */
		"v2-resource-query-resp", /* 264 PW_RESOURCE_QUERY_RESP */
		"v2-resource-reclaim-req", /* 265 PW_RESOURCE_RECLAIM_REQ */
		"v2-resource-reclaim-resp", /* 266 PW_RESOURCE_RECLAIM_RESP */
		"v2-nas-reb-req",	/* 267 PW_NAS_REB_REQ */
		"v2-nas-reb-resp",	/* 268 PW_NAS_REB_RESP */
		"v2-change-filter-req",	/* 304 PW_CHANGE_FILTER_REQ */
		"v2-change-filter-ack",	/* 305 PW_CHANGE_FILTER_ACK */
		"v2-change-filter-nak",	/* 306 PW_CHANGE_FILTER_NAK */
		"v2-access-error",	/* 402 PW_ACCESS_ERROR */
		"v2-acct-error",	/* 405 PW_ACCOUNTING_ERROR */
	};


	static char      unknown[20];
	static char     *func = "authtype_toa";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((code <= 0) || ((sizeof (typelist) / sizeof (typelist[0])) <= code))
	{
		if (code == PW_FORWARDING)
		{
			return "forwarding";
		}
		else if (code >= 256)
		{
			if ((sizeof (v2_typelist) / sizeof (v2_typelist[0]))
								> (code - 256))
			{
				return v2_typelist[code-256];
			}
		}

		sprintf (unknown, "invalid(%d)", code);
		return unknown;
	}

	return typelist[code];
} /* end of authtype_toa () */

#define	AUTH_VECTORTOA_BUFS	20

/*************************************************************************
 *
 *	Function: auth_vectortoa
 *
 *	Purpose: Produce hexadecimal dump of authreq->vector.
 *
 *	Returns: pointer to auth_vector hex buffer.
 *
 *************************************************************************/

char *
auth_vectortoa (authvec, sws)

u_char         *authvec;
int             sws;

{
	int             i;
	static char     buffers[AUTH_VECTORTOA_BUFS][(3*AUTH_VECTOR_LEN)+1];
	static int      ndx = 0;
	char           *buffer = buffers[ndx];
	char           *put = buffer;

	ndx++;

	if (ndx >= AUTH_VECTORTOA_BUFS)
	{
		ndx = 0;
	}

	for (i = 0; i <= AUTH_VECTOR_LEN; i++)
	{
		if ((sws & 0x01) && ((i % 4) == 3))
		{
			*put = ' ';
			put++;
		}

		sprintf (put, "%2.2X", *authvec);
		authvec++;
		put += 2;
	}
	*put = '\0';

	return (buffer);
} /* end of auth_vectortoa () */

/******************************************************************************
 *
 *	Function: avpair_add
 *
 *	Purpose: Add an attribute-value pair to the given list.
 *
 *	Returns: pointer to added a/v pair upon success,
 *		 NULL pointer, upon failure.
 *
 *	Remarks: Always appends the new pair to the end of the list.
 *
 *****************************************************************************/

VALUE_PAIR *
avpair_add (list, attrid, pval, len)

VALUE_PAIR    **list;	/* A list of attribute-value pairs. */
int             attrid;	/* Attribute id number. */
void           *pval;	/* Pointer to value. */
int             len;	/* for strings: */
			/*    len < 0  ==> null-terminated ASCII string */
			/*    len == 0 ==> this is a zero length string (!) */
			/*    len > 0  ==> len is length of raw binary data */
			/* for non-strings: */
			/*    len == 0 ==> just plain data, just gets copied */
			/*    len > 0  ==> convert data from network ... */
			/*		   ... representation before copying */

{
	DICT_ATTR      *pda;
	static char    *func = "avpair_add";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((pda = dict_attrget (attrid, VC_RADIUS)) == (DICT_ATTR *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s: Unknown standard attribute %d", func, attrid);

		return NULL_VP;
	}

	if (pda->type == PW_TYPE_TAG_INT)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: Doesn't support type tag-int for %s",
			func, pda->name);
		return (NULL_VP);
	}
	else
	{
		if (pda->type == PW_TYPE_TAG_STR)
		{
			logit (LOG_DAEMON, LOG_ALERT,
				"%s: Doesn't support type tag-str for %s",
				func, pda->name);
			return (NULL_VP);
		}
	}

	return avpair_add_attr_tag (list, pda, pval, len, 0);
} /* end of avpair_add */

/******************************************************************************
 *
 *	Function: avpair_add_attr_tag
 *
 *	Purpose: Add a Vendor Specific attribute-value pair to the given list.
 *
 *	Returns: pointer to added a/v pair upon success,
 *		 NULL pointer, upon failure.
 *
 *	Remarks: Always appends the new pair to the end of the list.
 *
 *****************************************************************************/

VALUE_PAIR *
avpair_add_attr_tag (list, attr, pval, len, tag)

VALUE_PAIR    **list;	 /* A list of attribute-value pairs. */
DICT_ATTR      *attr;	 /* Dictionary entry for attribute */
void           *pval;	 /* Pointer to value. */
int             len;	 /* for strings: */
			 /*    len < 0  ==> null-terminated ASCII string */
			 /*    len == 0 ==> this is a zero length string (!) */
			 /*    len > 0  ==> len is length of raw binary data */
			 /* for non-strings: */
			 /*    len == 0 ==> just plain data, just gets copied */
			 /*    len > 0  ==> convert data from network ... */
			 /*		   ... representation before copying */
int             tag;	 /* The tag for tagged attributes */

{
	VALUE_PAIR     *vp;

#ifdef BINARY_FILTERS
	radgenfilter   *gen;
	radfilter      *last;
	radfilter      *this;
#endif	/* BINARY_FILTERS */

	static char    *func = "avpair_add_attr_tag";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

#ifdef PW_TYPE_FILTER_BINARY
	if (attr->value == PW_TYPE_FILTER_BINARY) /* do sanity checking */
	{
		this = (radfilter *) pval;
		if (this->type == FILTER_GENERIC_TYPE)
		{
			vp = get_last_vp_vend (*list, attr->value,
						attr->vendor_id);

			if (vp != NULL_VP)
			{
				last = (radfilter *) vp->strvalue;

				if ((last->type != FILTER_GENERIC_TYPE) ||
					(len <= 0) ||
					(last->input != this->input) ||
					(last->forward != this->forward))
				{
					gen = &last->u.generic;
					gen->more = FALSE;
					logit (LOG_DAEMON, LOG_ERR,
	"%s: 'more' of previous generic filter entry doesn't match this one %s",
						func, binary_vtoa (this));
				}
			}
		}
	}
#endif	/* PW_TYPE_FILTER_BINARY */

	vp = avpair_assign_tag (attr, pval, len, tag);

	if (debug_flag >= 2)
	{
		debug_pair (stdout, vp);
	}

	if (list != (VALUE_PAIR **) NULL && vp != NULL_VP)
	{
		insert_vp (list, NULL_VP, vp);
	}

	return vp;
} /* end of avpair_add_attr_tag () */

/******************************************************************************
 *
 *	Function: avpair_add_tag
 *
 *	Purpose: Add an attribute-value pair to the given list.
 *
 *	Returns: pointer to added a/v pair upon success,
 *		 NULL pointer, upon failure.
 *
 *	Remarks: Always appends the new pair to the end of the list.
 *
 *****************************************************************************/

VALUE_PAIR *
avpair_add_tag (list, attrid, pval, len, tag)

VALUE_PAIR    **list;	/* A list of attribute-value pairs. */
int             attrid;	/* Attribute id number. */
void           *pval;	/* Pointer to value. */
int             len;	/* for strings: */
			/*    len < 0  ==> null-terminated ASCII string */
			/*    len == 0 ==> this is a zero length string (!) */
			/*    len > 0  ==> len is length of raw binary data */
			/* for non-strings: */
			/*    len == 0 ==> just plain data, just gets copied */
			/*    len > 0  ==> convert data from network ... */
			/*		   ... representation before copying */
int             tag;	/* The tag for tagged attributes */

{
	DICT_ATTR      *pda;
	static char    *func = "avpair_add_tag";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((pda = dict_attrget (attrid, VC_RADIUS)) == (DICT_ATTR *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s: Unknown standard attribute %d", func, attrid);

		return NULL_VP;
	}

	return avpair_add_attr_tag (list, pda, pval, len, tag);
} /* end of avpair_add_tag */

/******************************************************************************
 *
 *	Function: avpair_add_vend
 *
 *	Purpose: Add a Vendor Specific attribute-value pair to the given list.
 *
 *	Returns: pointer to added a/v pair upon success,
 *		 NULL pointer, upon failure.
 *
 *	Remarks: Always appends the new pair to the end of the list.
 *
 *****************************************************************************/

VALUE_PAIR *
avpair_add_vend (list, attrid, pval, len, vend_id)

VALUE_PAIR    **list;	 /* A list of attribute-value pairs. */
int             attrid;	 /* Attribute id number. */
void           *pval;	 /* Pointer to value. */
int             len;	 /* for strings: */
			 /*    len < 0  ==> null-terminated ASCII string */
			 /*    len == 0 ==> this is a zero length string (!) */
			 /*    len > 0  ==> len is length of raw binary data */
			 /* for non-strings: */
			 /*    len == 0 ==> just plain data, just gets copied */
			 /*    len > 0  ==> convert data from network ... */
			 /*		   ... representation before copying */
UINT4           vend_id; /* Vendor ID */

{
	DICT_ATTR      *pda;
	static char    *func = "avpair_add_vend";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((pda = dict_attrget (attrid, vend_id)) == (DICT_ATTR *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s: Unknown vendor %ld attribute %d",
			func, vend_id, attrid);

		return NULL_VP;
	}

	if (pda->type == PW_TYPE_TAG_INT)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: Doesn't support type tag-int for %s",
			func, pda->name);
		return (NULL_VP);
	}
	else
	{
		if (pda->type == PW_TYPE_TAG_STR)
		{
			logit (LOG_DAEMON, LOG_ALERT,
				"%s: Doesn't support type tag-str for %s",
				func, pda->name);
			return (NULL_VP);
		}
	}

	return avpair_add_attr_tag (list, pda, pval, len, 0);
} /* end of avpair_add_vend () */

/******************************************************************************
 *
 *	Function: avpair_add_vend_tag
 *
 *	Purpose: Add a Vendor Specific attribute-value pair to the given list.
 *
 *	Returns: pointer to added a/v pair upon success,
 *		 NULL pointer, upon failure.
 *
 *	Remarks: Always appends the new pair to the end of the list.
 *
 *****************************************************************************/

VALUE_PAIR *
avpair_add_vend_tag (list, attrid, pval, len, vend_id, tag)

VALUE_PAIR    **list;	 /* A list of attribute-value pairs. */
int             attrid;	 /* Attribute id number. */
void           *pval;	 /* Pointer to value. */
int             len;	 /* for strings: */
			 /*    len < 0  ==> null-terminated ASCII string */
			 /*    len == 0 ==> this is a zero length string (!) */
			 /*    len > 0  ==> len is length of raw binary data */
			 /* for non-strings: */
			 /*    len == 0 ==> just plain data, just gets copied */
			 /*    len > 0  ==> convert data from network ... */
			 /*		   ... representation before copying */
UINT4           vend_id; /* Vendor ID */
int             tag;	 /* The tag for tagged attributes */

{
	DICT_ATTR      *pda;
	static char    *func = "avpair_add_vend_tag";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((pda = dict_attrget (attrid, vend_id)) == (DICT_ATTR *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s: Unknown vendor %ld attribute %d",
			func, vend_id, attrid);

		return NULL_VP;
	}

	return avpair_add_attr_tag (list, pda, pval, len, tag);
} /* end of avpair_add_vend_tag () */

/******************************************************************************
 *
 *	Function: avpair_assign
 *
 *	Purpose: Assign the given raw value to an attribute-value pair.
 *
 *	Returns: pointer to the value pair which was allocated,
 *		 or NULL on failure.
 *
 *****************************************************************************/

VALUE_PAIR *
avpair_assign (dp, pval, len)

DICT_ATTR      *dp;	/* Pointer to attribute dictionary entry */
void           *pval;	/* pointer to value to be assigned */
int             len;	/* for strings: */
			/*    len < 0  ==> null-terminated ASCII string */
			/*    len == 0 ==> this is a zero length string (!) */
			/*    len > 0  ==> len is length of raw binary data */
			/* for non-strings: */
			/*    len == 0 ==> just plain data, just gets copied */
			/*    len > 0  ==> convert data from network ... */
			/*		   ... representation before copying */

{
	static char    *func = "avpair_assign";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (dp->type == PW_TYPE_TAG_INT)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: Doesn't support type tag-int for %s",
			func, dp->name);
		return (NULL_VP);
	}
	else
	{
		if (dp->type == PW_TYPE_TAG_STR)
		{
			logit (LOG_DAEMON, LOG_ALERT,
				"%s: Doesn't support type tag-str for %s",
				func, dp->name);
			return (NULL_VP);
		}
	}

	return avpair_assign_tag (dp, pval, len, -1);
} /* end of avpair_assign () */

/******************************************************************************
 *
 *	Function: avpair_assign_tag
 *
 *	Purpose: Assign the given raw value to an attribute-value pair.
 *
 *	Returns: pointer to the value pair which was allocated,
 *		 or NULL, on failure.
 *
 *****************************************************************************/

VALUE_PAIR *
avpair_assign_tag (dp, pval, len, tag)

DICT_ATTR      *dp;	/* Pointer to attribute dictionary entry */
void           *pval;	/* pointer to value to be assigned */
int             len;	/* for strings: */
			/*    len < 0  ==> null-terminated ASCII string */
			/*    len == 0 ==> this is a zero length string (!) */
			/*    len > 0  ==> len is length of raw binary data */
			/* for non-strings: */
			/*    len == 0 ==> just plain data, just gets copied */
			/*    len > 0  ==> convert data from network ... */
			/*		   ... representation before copying */
int             tag;	/* The tag for tagged attributes */

{
	UINT2           temp_short;
	char           *dest;
	char           *ptr;
	VALUE_PAIR     *vp;
	VP_STRING      *vpstr;
	int             blen;
	static char    *func = "avpair_assign_tag";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (len > AUTH_STRING2_LEN)
	{
		logit (LOG_DAEMON, LOG_ERR, "%s: bad attribute length %d",
			func, len);

		return NULL_VP;
	}

	if ((vp = (VALUE_PAIR *) calloc (1, sizeof (VALUE_PAIR))) == NULL_VP)
	{
		logit (LOG_DAEMON, LOG_ALERT, "%s: FATAL out of memory", func);
		abort ();
	}
	vp_mf.m++;

	vp->attribute = dp->value;
	vp->ap = dp;

	/*
	 *	If the dictionary says to always
	 *	encapsulate, then always encapsulate!
	 */
	if ((dp->flags & ATTR_ENCAPS) != 0)
	{
		vp->flags |= VPF_ENCAPS;
	}

	vp->strsize = 0;
	if (tag >= 0)
	{
		vp->tag = tag;
	}
	else
	{
		vp->tag = 0;
	}
	vp->next = NULL_VP;
	ptr = pval;

	switch (dp->type)
	{

#ifdef PW_TYPE_FILTER_BINARY
	    case PW_TYPE_FILTER_BINARY:
		if (len <= 0)
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: bad binary filter length %d", func, len);
			free (vp);
			vp_mf.f++;

			return NULL_VP;
		}
		/***FALLTHROUGH***/

#endif	/* PW_TYPE_FILTER_BINARY */

	    case PW_TYPE_TAG_STR:
		if (tag == -1)
		{
			vp->tag = *ptr;
			ptr++;
			len--;
		}
		/***FALLTHROUGH***/

	    case PW_TYPE_OCTETS:
	    case PW_TYPE_VENDOR:
	    case PW_TYPE_STRING: /* Use lvalue field to store length. */
		if (ptr == (char *) NULL)
		{
			ptr = "";
		}

		if (len < 0)
		{
			len = strlen (ptr);
			if (doing_init)
			{
				vp->lvalue = len;
				vp->strvalue = add_string (ptr, ASIS);
				break;
			}
		}
		vp->lvalue = len;

		/* Allocate 2**x storage block for string */
		for (blen = VPSTR_MIN; blen <= len; blen += blen)
		{
			continue;
		}

		if ((vpstr = (VP_STRING *) calloc (1, blen + VPSTR_HDR_LEN))
							== (VP_STRING *) NULL)
		{
			logit (LOG_DAEMON, LOG_ALERT,
				"%s: FATAL out of memory", func);
			abort ();
		}
		active_vpstrings++;
		vpstr->usecnt = 1;
		vp->strvalue = vpstr->string;
		vp->strsize = blen;	/* Remember the length we determined. */
		memcpy (vp->strvalue, ptr, len);
		vp->strvalue[len] = 0;	/* For the case of string type. */
		break;

	    case PW_TYPE_OCTET:
		if (len == 1)		/* network value */
		{
			vp->lvalue = *(u_char *) pval;	/* Get the octet. */
		}
		else
		{
			if (len == 0)	/* internal value */
			{
				memcpy ((char *) &vp->lvalue, pval,
					sizeof (vp->lvalue));
			}
			else
			{
				logit (LOG_DAEMON, LOG_ERR,
			 "%s: Invalid len (%d) for PW_TYPE_OCTET attribute %s",
					func, len, dp->name);
				free (vp);
				vp_mf.f++;
				return NULL_VP;
			}
		}

		vp->strvalue = (char *) NULL;	/* Insure null string */

		break;

	    case PW_TYPE_SHORT:
		memcpy ((char *) &temp_short, pval, sizeof (temp_short));

		if (len == 2)		/* network value */
		{
			temp_short = ntohs(temp_short);
		}
		else
		{
			if (len != 0)	/* NOT internal value */
			{
				logit (LOG_DAEMON, LOG_ERR,
		      "%s: Invalid length (%d) for PW_TYPE_SHORT attribute %s",
					func, len, dp->name);
				free (vp);
				vp_mf.f++;

				return NULL_VP;
			}
		}

		vp->lvalue = temp_short;
		vp->strvalue = (char *) NULL;	/* Insure null string */

		break;

	    case PW_TYPE_TAG_INT:
		ptr = pval;
		vp->strvalue = (char *) NULL;	/* Insure null string */
		dest = (char *) &vp->lvalue;
		vp->lvalue = 0;			/* Initially nothing */

		if (tag == -1)
		{
			vp->tag = *((u_char *) pval);
			ptr++;
		}

		if (len > 0) /* need to convert the raw network value */
		{
			memcpy (dest + 1, ptr, sizeof (vp->lvalue) - 1);
			vp->lvalue = ntohl(vp->lvalue);
		}
		else
		{
			if (tag == -1)
			{
				logit (LOG_DAEMON, LOG_ERR,
				   "%s: FATAL ERROR, len=%d and tag=-1 for %s",
					func, len, dp->name);
				dumpcore = 1;
				abort ();
			}
			else
			{
				memcpy (dest, ptr, sizeof (vp->lvalue));
			}
		}

		break;

	    case PW_TYPE_DATE:
	    case PW_TYPE_INTEGER:
	    case PW_TYPE_IPADDR:
		memcpy ((char *) &vp->lvalue, pval, sizeof (vp->lvalue));

		if (len > 0) /* need to convert the raw network value */
		{
			vp->lvalue = ntohl(vp->lvalue);
		}
		vp->strvalue = (char *) NULL; /* Insure null string */

		break;

	    default:
		dprintf(1, (LOG_DAEMON, LOG_DEBUG,
			"%s: Unknown type %d", func, dp->type));

		free (vp);
		vp_mf.f++;

		return NULL_VP;

	} /* end of switch */

	return vp;
} /* end of avpair_assign_tag () */

/****************************************************************************
 *
 *	Function: avpair_comp
 *
 *	Purpose: Compare two attribute/value pairs and
 *		 return an integer describing what happened...
 *
 *	returns:
 *		-1   both attribute/value pairs are of the same type
 *			but the value of a < value of b.
 *		 0   both attribute/value pairs are of the same type
 *			the value of a == the value of b.
 *		 1   both attribute/value pairs are of the same type
 *			but the value of a > value of b.
 *		 2   the types of the two attribute/value pairs are different.
 *		 3   One or both of the attribute/value pairs is NULL.
 *
 ****************************************************************************/

int
avpair_comp (a, b)

VALUE_PAIR     *a;
VALUE_PAIR     *b;

{
	int             result;
	static char    *func = "avpair_comp";

	if ((a == NULL_VP) || (b == NULL_VP))
	{
		return (3);
	}

	/* Simple, short circut check. */
	if (a == b)
	{
		return (0);
	}

	/* Check to see if the types are the same. */
	if (a->ap->type != b->ap->type)
	{
		return (2);
	}

	switch (a->ap->type)
	{
		/* Integer types. */
	    case PW_TYPE_TAG_INT:
		if (a->tag == b->tag)
		{
			if (a->lvalue == b->lvalue)
			{
				return (0);	/* a == b */
			}

			if (a->lvalue > b->lvalue)
			{
				return (1);	/* a > b */
			}
			return (-1);		/* a < b */
		}

		if (a->tag > b->tag)
		{
			return (1);	/* a > b */
		}
		return (-1);		/* a < b */

	    case PW_TYPE_INTEGER:
	    case PW_TYPE_IPADDR:
	    case PW_TYPE_DATE:
	    case PW_TYPE_OCTET:
	    case PW_TYPE_SHORT:
		if (a->lvalue == b->lvalue)
		{
			return (0);	/* a == b */
		}

		if (a->lvalue > b->lvalue)
		{
			return (1);	/* a > b */
		}
		return (-1);		/* a < b */

		/* String types. */
	    case PW_TYPE_TAG_STR:
		if (a->tag == b->tag)
		{
			if (a->lvalue == b->lvalue)
			{
				return memcmp (a->strvalue, b->strvalue,
						a->lvalue);
			}

			if (a->lvalue < b->lvalue)
			{
				if ((result =
					memcmp (a->strvalue, b->strvalue,
						a->lvalue)) != 0)
				{
					return (result);
				}

				return (-1);  /* a < b */
			}

			if ((result =
				memcmp (a->strvalue, b->strvalue,
					b->lvalue)) != 0)
			{
				return (result);
			}

			return (1);  /* a > b */
		}

		if (a->tag > b->tag)
		{
			return (1);	/* a > b */
		}
		return (-1);		/* a < b */

	    case PW_TYPE_STRING:
	    case PW_TYPE_VENDOR:
	    case PW_TYPE_OCTETS:

#ifdef PW_TYPE_FILTER_BINARY
	    case PW_TYPE_FILTER_BINARY:
#endif	/* PW_TYPE_FILTER_BINARY */

		/*
		 *	If the string pointers are the same,
		 *	a pointer comparison will do.
		 */
		if (a->strvalue == b->strvalue)
		{
			return (0);
		}

		/* If the lengths are the same, a simple memcmp() will do */
		if (a->lvalue == b->lvalue)
		{
			return memcmp (a->strvalue, b->strvalue, a->lvalue);
		}

		if (a->lvalue < b->lvalue)
		{
			if ((result =
				memcmp (a->strvalue, b->strvalue,
					a->lvalue)) != 0)
			{
				return (result);
			}

			return (-1);  /* a < b */
		}

		if ((result =
			memcmp (a->strvalue, b->strvalue, b->lvalue)) != 0)
		{
			return (result);
		}

		return (1);  /* a > b */

	    default:
		logit (LOG_DAEMON, LOG_ERR,
			"%s: Warning -- Unknown type (%d) for %s or %s", func,
			a->ap->type, a->ap->name, b->ap->name);

		return (4);
	} /* end of switch */
} /* end of avpair_comp () */

/*************************************************************************
 *
 *	Function: avpair_del
 *
 *	Purpose: Remove the value pair with the given attribute
 *		 and Vendor ID.
 *
 *************************************************************************/

void
avpair_del (vp_list, attrid, vend_id)

VALUE_PAIR     **vp_list;
int              attrid;
UINT4            vend_id;

{

	VALUE_PAIR     **prev;
	VALUE_PAIR      *curr;
	static char     *func = "avpair_del";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

        prev = vp_list;
        curr = *prev;

	while (curr != NULL_VP)
        {
                if (curr->attribute == attrid &&
			curr->ap->vendor_id == vend_id &&
			!(curr->ap->flags & ATTR_CONFIG))
                {
                        *prev = curr->next;
                        avpair_free (curr);
                        curr = *prev;
                        continue;
                }
                prev = &curr->next;
                curr = curr->next;
        }
	return;
} /* end of avpair_del () */

/*************************************************************************
 *
 *	Function: avpair_del_ci
 *
 *	Purpose: Remove the configuration value pair with the given
 *		 attribute and Vendor ID.
 *
 *************************************************************************/

void
avpair_del_ci (vp_list, attrid, vend_id)

VALUE_PAIR     **vp_list;
int              attrid;
UINT4            vend_id;

{

	VALUE_PAIR      **prev;
	VALUE_PAIR       *curr;
	static char      *func = "avpair_del_ci";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

        prev = vp_list;
        curr = *prev;

	while (curr != NULL_VP)
        {
                if (curr->attribute == attrid &&
			curr->ap->vendor_id == vend_id &&
			(curr->ap->flags & ATTR_CONFIG))
                {
                        *prev = curr->next;
                        avpair_free (curr);
                        curr = *prev;
                        continue;
                }
                prev = &curr->next;
                curr = curr->next;
        }
	return;
} /* end of avpair_del_ci () */

/******************************************************************************
 *
 *	Function: avpair_dup
 *
 *	Purpose: Make a copy of the given attribute-value pair.
 *
 *	Returns: pointer to the new copy.
 *
 ******************************************************************************/

VALUE_PAIR *
avpair_dup (psrc)

VALUE_PAIR     *psrc;

{
	VALUE_PAIR     *pnew;
	VP_STRING      *vpstr;
	static char    *func = "avpair_dup";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((pnew = (VALUE_PAIR *) calloc (1, sizeof (VALUE_PAIR))) == NULL_VP)
	{
		logit (LOG_DAEMON, LOG_ALERT, "%s: FATAL out of memory", func);
		abort ();
	}
	vp_mf.m++;

	memcpy ((char *) pnew, (char *) psrc, sizeof (VALUE_PAIR));

	/* Copy the string, if not an add_string () */
	if (pnew->strvalue != (char *) NULL && pnew->strsize != 0)
	{
		/* Just bump the use count for the string */
		vpstr = (VP_STRING *) (pnew->strvalue - VPSTR_HDR_LEN);
		vpstr->usecnt++;
	}

	pnew->next = NULL_VP;

	return pnew;
} /* end of avpair_dup () */

/******************************************************************************
 *
 *	Function: avpair_free
 *
 *	Purpose: Frees the given avpair.  Free's any allocated string storage.
 *
 *
 *****************************************************************************/

void
avpair_free (vp)

VALUE_PAIR     *vp;

{
	static char     *func = "avpair_free";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (vp->strvalue != (char *) NULL && vp->strsize != 0)
	{
		avpair_string_free (vp->strvalue);
	}

	free (vp);
	vp_mf.f++;
	return;
} /* end of avpair_free () */

/*******************************************************************************
 *
 *	Function: avpair_get
 *
 *	Purpose: Find specified a/v pair from a list and return its value.
 *
 *	Returns: whatever avpair_get_vend() returns.
 *
 ******************************************************************************/

int
avpair_get (pval, vplist, attrid)

void           *pval;		/* OUT: buffer for returning value */
VALUE_PAIR     *vplist;		/* pointer to list of attribute-value pairs */
int             attrid;		/* attribute to find */

{
	static char       *func = "avpair_get";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	return avpair_get_vend (pval, vplist, attrid, 0);

} /* end of avpair_get () */

/*******************************************************************************
 *
 *	Function: avpair_get_vend
 *
 *	Purpose: Find specified vendor a/v pair from a list and return its
 *		 value.
 *
 *	Returns: type of the attribute, on success (look at PW_TYPE_*),
 *		 or -1, on failure.
 *
 *	Remarks: This function does not support PW_TYPE_TAG_INT, etc.
 *
 ******************************************************************************/

int
avpair_get_vend (pval, vplist, attrid, vendorid)

void           *pval;		/* OUT: buffer for returning value */
VALUE_PAIR     *vplist;		/* pointer to list of attribute-value pairs */
int             attrid;		/* attribute to find */
int             vendorid;	/* vendor id of attribute to find */

{
	VALUE_PAIR        *vp;
	static char       *func = "avpair_get_vend";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((vp = get_vp_vend (vplist, attrid, vendorid)) == NULL_VP)
	{
		return (-1);
	}

	switch (vp->ap->type)
	{

#ifdef BINARY_FILTERS
	    case PW_TYPE_FILTER_BINARY:
#endif	/* BINARY_FILTERS */

	    case PW_TYPE_OCTETS:
	    case PW_TYPE_VENDOR:
	    case PW_TYPE_STRING:
		memcpy ((char *) pval, vp->strvalue, vp->lvalue);
		break;

	    case PW_TYPE_OCTET:
		*((u_char *) pval) = vp->lvalue;
		break;

	    case PW_TYPE_SHORT:
		*((UINT2 *) pval) = vp->lvalue;
		break;

	    case PW_TYPE_DATE:
	    case PW_TYPE_INTEGER:
	    case PW_TYPE_IPADDR:
		*((UINT4 *) pval) = vp->lvalue;
		break;

	    default:
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: Unknown attribute %s type %d",
			func, vp->ap->name, vp->ap->type);
	}

	return vp->ap->type;

} /* end of avpair_get_vend () */

/*************************************************************************
 *
 *	Function: avpair_list_length
 *
 *	Purpose: Compute the length of a singly linked list.
 *
 *	Returns: list length,
 *		 or -1, if local "infinity" exceeded.
 *
 *************************************************************************/

static int
avpair_list_length (vp)

VALUE_PAIR     *vp;	/* list to calculate. */

{
	int              count = 0;		/* Start with nothing. */
	static char     *func = "avpair_list_length";

	for ( ; vp != NULL_VP; vp = vp->next)
	{
		count++;			/* Count it up. */
		if (count > AVPAIR_LIST_LENGTH_MAX)
		{
			return (-1);
		}
	}

	return count;
} /* end of avpair_list_length () */

/*************************************************************************
 *
 *	Function: avpair_out
 *
 *	Purpose: Puts avpair in output buffer, prefixing with vendor
 *		 specific code, if necessary.
 *
 *************************************************************************/

int
avpair_out (vp, auth, maxlen, veps)

VALUE_PAIR     *vp;
AUTH_HDR       *auth;
UINT4           maxlen;		/* Maximum length of output buffer */
VENDOR_LIST    *veps;		/* Do vendor specific mapping, if present */

{
	int              ret;
	static char     *func = "avpair_out";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	debug_pair (stdout, vp);

	switch (vp->ap->type)
	{

#ifdef PW_TYPE_FILTER_BINARY
	    case PW_TYPE_FILTER_BINARY:
#endif	/* PW_TYPE_FILTER_BINARY */

	    case PW_TYPE_OCTETS:
	    case PW_TYPE_VENDOR:
	    case PW_TYPE_STRING:
	    case PW_TYPE_TAG_STR:
		ret = insert_attribute (vp->ap, auth, maxlen, vp->strvalue,
					vp->lvalue, vp->flags, veps, vp->tag);
		if (ret <= 0)
		{
			logit (LOG_DAEMON, LOG_ALERT,
	"%s: insert_attribute(%s(%d), ..., %u, 0x%p, %d, 0x%x, %s) returns %d",
				func, vp->ap->name, vp->attribute, maxlen,
				vp->strvalue, vp->lvalue, vp->flags,
				vendor_list_toa (veps), ret);
		}
		return ret;

	    default:	/* Assume all others are represented in lvalue */
		ret = insert_attribute (vp->ap, auth, maxlen, &vp->lvalue, 4,
					vp->flags, veps, vp->tag);

		if (ret <= 0)
		{
			logit (LOG_DAEMON, LOG_ALERT,
     "%s: insert_attribute(%s(%d), ..., %d, 0x%p->%d, 0, 0x%x, %s) returns %d",
				func, vp->ap->name, vp->attribute, maxlen,
				&vp->lvalue, vp->lvalue, vp->flags,
				vendor_list_toa (veps), ret);
		}
		return ret;
	}
} /* end of avpair_out () */

/******************************************************************************
 *
 *	Function: avpair_string_free
 *
 *	Purpose: Decrements string use count and frees if 0.
 *
 *
 *****************************************************************************/

static void
avpair_string_free (string)

char            *string;

{
	VP_STRING       *vpstr;
	static char     *func = "avpair_string_free";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	vpstr = (VP_STRING *) (string - VPSTR_HDR_LEN);
	if (--vpstr->usecnt == 0)
	{
		active_vpstrings--;
		free (vpstr);
	}
	return;
} /* end of avpair_string_free () */

/*************************************************************************
 *
 *	Function: avpair_string_mod
 *
 *	Purpose: Modify strvalue in an a/v pair.
 *
 *************************************************************************/

void
avpair_string_mod (vp, string, len)

VALUE_PAIR    *vp;
char          *string;
int            len;

{
	int            blen;
	VP_STRING     *vpstr;
	static char   *func = "avpair_string_mod";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (len == -1)
	{
		len = strlen (string);
	}
	
	/* First see if we can just copy into existing region */
	if (vp->strvalue == NULL ||
		vp->strsize <= len ||
		((VP_STRING *) (vp->strvalue - VPSTR_HDR_LEN))->usecnt > 1)
	{
		/* If currently an add_string(), don't free it or mod it */
	
		if (vp->strsize != 0)
		{
			avpair_string_free (vp->strvalue);
		}

		for (blen = VPSTR_MIN; blen <= len; blen += blen)
		{
			continue;
		}
		vp->strsize = blen;

		if ((vpstr = (VP_STRING *) calloc (1, blen + VPSTR_HDR_LEN))
							== (VP_STRING *) NULL)
		{
			logit (LOG_DAEMON, LOG_ALERT,
				"%s: FATAL out of memory", func);
			abort ();
		}
		active_vpstrings++;
		vpstr->usecnt = 1;
		vp->strvalue = vpstr->string;
	}

	memcpy (vp->strvalue, string, len);
	vp->strvalue[len] = '\0';
	vp->lvalue = len;
} /* end of avpair_string_mod () */

#define	MAX_AVPAIR_VTOA 20

/*************************************************************************
 *
 *	Function: avpair_vtoa
 *
 *	Purpose: Produce a string representation of the value of a pair.
 *
 *************************************************************************/

char *
avpair_vtoa (vp, sws)

VALUE_PAIR     *vp;
int             sws;

{
	int             num;
	int             pos;
	char           *buff;
	char           *c;
	char           *fmt;
	char           *p;
	DICT_VALUE     *dval;

#ifdef BINARY_FILTERS
	radfilter      *filt;
#endif	/* BINARY_FILTERS */

	VENDOR         *vend_ptr;
	struct tm      *tm;
	struct in_addr  inad;
	char            tmp[10];
	static char     abuffers[MAX_AVPAIR_VTOA][AUTH_STRING2_LEN + 1];
	static int      andx = 0;
	static char    *func = "avpair_vtoa";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (vp == NULL_VP)
	{
		if ((sws & AVPAIR_VTOA_NULL) != 0)
		{
			return "";
		}
		return NULL;
	}

	buff = abuffers[andx];
	andx++;

	if (andx >= MAX_AVPAIR_VTOA)
	{
		andx = 0;
	}

	p = (char *) buff;	/* Assigned here for several cases below. */

	switch (vp->ap->type)
	{
	    case PW_TYPE_TAG_STR:
		sprintf (buff, ":%d:", vp->tag);
		p += strlen (buff);
		/***FALTHROUGH***/

	    case PW_TYPE_STRING:
		c = vp->strvalue;

		if ((sws & AVPAIR_VTOA_QUOTE) != 0)
		{
			*p++ = '\'';
		}
		else if ((sws & AVPAIR_VTOA_DQUOTE) != 0)
		{
			*p++ = '"';
		}

		for (pos = 0; pos < vp->lvalue; pos++)
		{
			switch (c[pos])
			{
			    case '\0':		/* NULL character */
				/* Hack for broken Ascend NAS firmware. */
				if ((pos + 1) < vp->lvalue)
				{
					*p++ = '\\';
					*p++ = '0';
				}
				break;

			    case '\b':		/* BACKSPACE */
				*p++ = '\\';
				*p++ = 'b';
				break;

			    case '\r':		/* Carriage Return */
				*p++ = '\\';
				*p++ = 'r';
				break;

			    case '\n':		/* Newline / Line feed */
				*p++ = '\\';
				*p++ = 'n';
				break;

			    case '\t':		/* Horizontal tab */
				*p++ = '\\';
				*p++ = 't';
				break;

			    case '\\':		/* Self-escape */
				*p++ = '\\';
				*p++ = '\\';
				break;

			    case '\'':		/* Quote-escape */
				*p++ = '\\';
				*p++ = '\'';
				break;

			    case '"':		/* Double-quote-escape */
				*p++ = '\\';
				*p++ = '"';
				break;

			    default:
				if ((' ' <= c[pos]) && (c[pos] < 0x7f))
				{
					*p++ = c[pos];
				}
				else
				{
					sprintf (tmp, "\\0x%2.2x",
							(u_char) c[pos]);
					strcpy (p, tmp);
					p += strlen (p);
				}
			} /* end of inner switch */
		}  /* for each character... */

		if ((sws & AVPAIR_VTOA_QUOTE) != 0)
		{
			*p++ = '\'';
		}
		else if ((sws & AVPAIR_VTOA_DQUOTE) != 0)
		{
			*p++ = '"';
		}

		*p = '\0';

		break;

#ifdef BINARY_FILTERS
	    case PW_TYPE_FILTER_BINARY:
		filt = (radfilter *) vp->strvalue;
		buff = binary_vtoa (filt);

		break;
#endif	/* BINARY_FILTERS */

	    case PW_TYPE_TAG_INT:
		sprintf (p, ":%d:", vp->tag);
		p += strlen (p);
		/***FALLTHROUGH***/

	    case PW_TYPE_INTEGER:
	    case PW_TYPE_SHORT:
	    case PW_TYPE_OCTET:
		dval = dict_find_value (vp->lvalue, vp->ap);

		if (dval != (DICT_VALUE *) NULL)
		{
			strcpy (p, dval->name);
		}
		else
		{

#if defined(__alpha)
			sprintf (p, "%d", vp->lvalue);
#else	/* defined(alpha) */
			sprintf (p, "%ld", vp->lvalue);
#endif	/* defined(alpha) */

		}
		break;

	    case PW_TYPE_IPADDR:
		inad.s_addr = htonl(vp->lvalue);
		strcpy (buff, inet_ntoa (inad));
		break;

	    case PW_TYPE_DATE:
		if ((sws & AVPAIR_VTOA_QUOTE) != 0)
		{
			*p++ = '\'';
		}
		else if ((sws & AVPAIR_VTOA_DQUOTE) != 0)
		{
			*p++ = '"';
		}
		*p = '\0';	/* Initialize/terminate. */

		if ((sws & AVPAIR_VTOA_DATE) != 0)
		{
			fmt = "%b %e %Y";
		}
		else
		{
			if ((sws & AVPAIR_VTOA_TIME) != 0)
			{
				fmt = "%T";
			}
			else
			{
				fmt = "%Y-%m-%D";
			}
		}

		/* Now, local time or gm time? */
		if ((sws & AVPAIR_VTOA_LCLTIME) != 0)
		{
			tm = localtime ((time_t *) &vp->lvalue);
		}
		else
		{
			tm = gmtime ((time_t *) &vp->lvalue);
		}

		strftime (p, sizeof (abuffers[1]) - strlen (p), fmt, tm);

		p += strlen (p);	/* Go to end of string. */

		if ((sws & AVPAIR_VTOA_QUOTE) != 0)
		{
			*p++ = '\'';
		}
		else if ((sws & AVPAIR_VTOA_DQUOTE) != 0)
		{
			*p++ = '"';
		}
		*p = '\0';	/* terminate. */

		break;

	    case PW_TYPE_OCTETS:
		strcpy (buff, "0x");
		p += strlen (buff);
		c = vp->strvalue;

		for (pos = 0; pos < vp->lvalue; pos++)
		{
			sprintf (tmp, "%2.2x", (u_char) c[pos]);
			strcpy (p, tmp);
			if (pos % 4 == 3)
			{
				strcat (p, ".");
			}
			p += strlen (p);
		}
		*p = '\0';
		break;

	    case PW_TYPE_VENDOR:
		c = vp->strvalue;

		if (*c != 0)
		{
			logit (LOG_DAEMON, LOG_ERR,
			    "%s: Invalid vendor-specific code, 0x%x", func, *c);

			if ((sws & AVPAIR_VTOA_NULL) != 0)
			{
				return "";
			}

			return NULL;
		}
		memcpy ((char *) &num, c, 4);
		pos = ntohl(num);

		if ((vend_ptr = find_vendor_by_id (pos)) == (VENDOR *) NULL)
		{
			sprintf (buff, "v%d-", pos);
		}
		else
		{
			sprintf (buff, "v%s-", vend_ptr->name);
		}

		p += strlen (p);

		for (pos = 4; pos < vp->lvalue; pos++)
		{
			sprintf (tmp, "%2.2x", (u_char) c[pos]);
			strcpy (p, tmp);
			p += strlen (p);
		}
		*p = '\0';
		break;

	    default:
		if (sws & AVPAIR_VTOA_NULL)
		{
			return "";
		}
		return NULL;
	} /* switch (vp) */

	return buff;

} /* end of avpair_vtoa () */

/*************************************************************************
 *
 *	Function: backoff_logfile
 *
 *	Purpose: Attempts to remove and/or rename the given file.
 *
 *************************************************************************/

static int
backoff_logfile (plf, max)

logfile_info   *plf;	/* Pointer to info stucture of file to backoff. */
u_int           max;	/* Number of times to try. */

{
	int              i;	/* Counter for backing off. */
	logfile_info     new;
	static char     *func = "backoff_logfile";

	if (plf == (logfile_info *) NULL)
	{
		return (-1);
	}

	if (plf->errcode != 0)
	{
		return plf->errcode;
	}

	if (plf->stat.st_nlink > 1)
	{
		if (unlink (plf->name) == 0)
		{
			plf->errcode = ENOENT;	/* Gone. */
			return plf->errcode;
		}
		/* else ??? */
	}
	
	for (i = 1; i <= max; i++)
	{
		sprintf (new.name, "%s.lost.%d", plf->name, i);
		stat_logfile_info (&new);

		/* Try renaming it... */
		if (new.errcode == ENOENT)
		{
			if (rename (plf->name, new.name) == 0)
			{
				plf->errcode = ENOENT;
				return plf->errcode;
			}
		}
	}

	return (-1);	/* failed */
} /* end of backoff_logfile () */

#ifdef BINARY_FILTERS

/*************************************************************************
 *
 *	Function: binary_vtoa
 *
 *	Purpose: Print the contents of an Ascend binary filter in ASCII.
 *
 *************************************************************************/

static char *
binary_vtoa (f)

radfilter      *f;

{
	int              i;
	int              j;
	char            *buf;
	char            *eol;
	struct protoent *protos;	/* contains protos->(char *) p_name */
	struct servent  *service;	/* contains service->(char *) s_name */
	static char      bbuffers[MAX_AVPAIR_VTOA][AUTH_STRING2_LEN + 1];
	static int       bndx = 0;
	static char     *func = "binary_vtoa";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	buf = bbuffers[bndx];
	bndx++;

	if (bndx >= MAX_AVPAIR_VTOA)
	{
		bndx = 0;
	}

	if (f->type == RAD_FILTER_GENERIC)
	{
		strcpy (buf, "generic ");
	}
	else
	{
		strcpy (buf, "ip ");
	}

	if (f->input == TRUE)
	{
		strcat (buf, "in ");
	}
	else
	{
		strcat (buf, "out ");
	}

	if (f->forward == TRUE)
	{
		strcat (buf, "forward ");
	}
	else
	{
		strcat (buf, "drop ");
	}

	if (f->type == RAD_FILTER_GENERIC)
	{
		eol = buf + strlen (buf);
		sprintf (eol, "%d ", ntohs(f->u.generic.offset));

		eol = buf + strlen (buf);
		j = MIN(ntohs(f->u.generic.len), RAD_MAX_FILTER_LEN);
		for (i = 0; i < j; i++)
		{
			sprintf (eol, "%02x", f->u.generic.mask[i]);
			eol = buf + strlen (buf);
		}
		strcat (buf, " ");

		eol = buf + strlen (buf);
		for (i = 0; i < j; i++)
		{
			sprintf (eol, "%02x", f->u.generic.value[i]);
			eol = buf + strlen (buf);
		}
		strcat (buf, " ");

		if (f->u.generic.compneq == TRUE)
		{
			strcat (buf, "!= ");
		}
		else
		{
			strcat (buf, "== ");
		}

		if (f->u.generic.more)
		{
			strcat (buf, "more ");
		}
	}
	else /* was RAD_FILTER_IP */
	{
		if (f->u.ip.dstip)
		{
			strcat (buf, "dstip ");
			strcat (buf, ip_hostname (ntohl(f->u.ip.dstip)));
			eol = buf + strlen (buf);
			sprintf (eol, "/%d ", f->u.ip.dstmask);
		}

		if (f->u.ip.srcip)
		{
			strcat (buf, "srcip ");
			strcat (buf, ip_hostname (ntohl(f->u.ip.srcip)));
			eol = buf + strlen (buf);
			sprintf (eol, "/%d ", f->u.ip.srcmask);
		}

		if (f->u.ip.proto)
		{
			protos = getprotobynumber (f->u.ip.proto);

			if (protos != (struct protoent *) NULL)
			{
				strcat (buf, protos->p_name);
			}
			else
			{
				eol = buf + strlen (buf);
				sprintf (eol, "%d", f->u.ip.proto);
			}
			strcat (buf, " ");

			if (f->u.ip.dstport)
			{
				if (f->u.ip.proto == IPPROTO_TCP)
				{
				    service = getservbyport (f->u.ip.dstport,
									"tcp");
				    strcat (buf, service->s_name);
				}
				else if (f->u.ip.proto == IPPROTO_UDP)
				{
				    service = getservbyport (f->u.ip.dstport,
									"udp");
				    strcat (buf, service->s_name);
				}
				else
				{
				    logit (LOG_DAEMON, LOG_ERR,
				  "%s: dstport %d, protocol %d must be TCP/UDP",
					   func, ntohs(f->u.ip.dstport),
					   f->u.ip.proto);
				    strcat (buf, "unknown");
				}
				strcat (buf, " ");
			}

			if (f->u.ip.srcport)
			{
				if (f->u.ip.proto == IPPROTO_TCP)
				{
				    service = getservbyport (f->u.ip.srcport,
									"tcp");
				    strcat (buf, service->s_name);
				}
				else if (f->u.ip.proto == IPPROTO_UDP)
				{
				    service = getservbyport (f->u.ip.srcport,
									"udp");
				    strcat (buf, service->s_name);
				}
				else
				{
				    logit (LOG_DAEMON, LOG_ERR,
				  "%s: srcport %d, protocol %d must be TCP/UDP",
					   func, ntohs(f->u.ip.srcport),
					   f->u.ip.proto);
				    strcat (buf, "unknown");
				}
				strcat (buf, " ");
			}

			if (f->u.ip.established)
			{
				if (f->u.ip.proto == IPPROTO_TCP)
				{
				    strcat (buf, "est ");
				}
				else
				{
				    logit (LOG_DAEMON, LOG_ERR,
					  "%s: est set for non-TCP protocol %d",
					   func, f->u.ip.proto);
				}
			}

		}
	}

	return buf;
} /* end of binary_vtoa () */

#endif	/* BINARY_FILTERS */

/******************************************************************************
 *
 *	Function: build_header
 *
 *	Purpose: Build a RADIUS packet header using the given AUTH_REQ.
 *
 *	Returns: Pointer to client secret,
 *		 or NULL, if failed to get client (no secret).
 *
 *****************************************************************************/

char *
build_header (flag_ver, vector, code, id, auth, ce)

u_int          flag_ver;	/* Flags and version number to send */
char          *vector;		/* Pointer to the random vector to use */
u_int          code;		/* packet type */
u_int          id;		/* The id value to use */
AUTH_HDR      *auth;		/* buffer */
CLIENT_ENTRY  *ce;		/* Client Entry for destination */

{
	u_short        temp;
	int            i;
	int            randno;
	int            vector_inx;
	int            version;
	AUTH_HDR1     *ah1;
	char          *vec_ptr;
	static time_t  fwdvec_seed = 0;
	static char   *func = "build_header";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	version = flag_ver & AUTH_HDR_VERSION_BITS;
	vector_inx = 0;
	/* Start to build the RADIUS protocol packet header */
	if (version == VER1)
	{
		ah1 = (AUTH_HDR1 *) auth;
		ah1->code = (u_char) code;
		ah1->id = id;
		ah1->length = AUTH_HDR1_LEN;
		vec_ptr = (char *) ah1->vector;
	}
	else
	{
		auth->code = PW_EXTENDED_FORMAT;
		temp = htons(code);
		auth->command = htons(code);
		auth->flag_ver = flag_ver;
		auth->id = htons(id);
		auth->length = AUTH_HDR_LEN;
		vec_ptr = (char *) auth->vector;

		/* Produce a Timestamp in vector unless client flag is set */
		if (ce == (CLIENT_ENTRY *) NULL || !(ce->flags & CLIENT_NO_TS))
		{
			*((UINT4 *) vec_ptr) =
			     (UINT4) htonl((UINT4) time (0) + NTP_TIME_DIFF);
			auth->flag_ver |= AUTH_HDR_TIMESTAMP;
			vector_inx = sizeof (time_t);
		}
	}
	/* Always make up a new vector, if not V1.  Make up V1 if not given */
	if (version != VER1 || vector == (char *) NULL)
	{
		if (fwdvec_seed == 0)
		{
			fwdvec_seed = time (NULL);
			srand (fwdvec_seed);
		}

		for (i = vector_inx; i < AUTH_VECTOR_LEN; i += sizeof (int))
		{
			randno = rand ();
			memcpy ((char *) &vec_ptr[i], (char *) &randno,
								sizeof (int));
		}
	}
	else
	{
		memcpy (vec_ptr, vector, AUTH_VECTOR_LEN);
	}
	return vec_ptr;
} /* end of build_header () */

/******************************************************************************
 *
 *	Function: build_packet
 *
 *	Purpose: Build a RADIUS packet using the given av-pair list.
 *
 *	Returns: length of the packet, if positive,
 *		 number of errors, if negative.
 *
 *****************************************************************************/

int
build_packet (list, auth, maxlen, ce)

VALUE_PAIR    *list;		/* list of av-pairs */
AUTH_HDR      *auth;		/* packet buffer */
UINT4          maxlen;		/* Maximum size of packet to send */
CLIENT_ENTRY  *ce;		/* What client is the target? */

{
	int              errors = 0;
	int              ret;
	VALUE_PAIR      *vp;
	static char     *func = "build_packet";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	for (vp = list; vp != NULL; vp = vp->next)
	{
		if (vp->attribute == PW_USER_PASSWORD &&
			vp->ap->vendor_id == 0)
		{
			/*
			 *	We don't do passwords.
			 *	They need to be re-encrypted
			 */
			continue;
		}

		if ((ret = avpair_out (vp, auth, maxlen, ce->veps)) <= 0)
		{
			logit (LOG_DAEMON, LOG_ERR,
			      "%s: avpair_out(%s(%d), ..., %d, %s) returns %d",
				func, vp->ap->name, vp->attribute,
				maxlen, vendor_list_toa (ce->veps), ret);

			errors++;

			if (ret < 0)
			{
				break;
			}
		}
	}

	if (errors > 0)
	{
		return (-errors);
	}

	if (auth->code == PW_EXTENDED_FORMAT)
	{
		return auth->length;
	}
	else
	{
		return ((AUTH_HDR1 *) auth)->length;
	}

} /* end of build_packet () */

/*****************************************************************************
 *
 *	Function: build_reply_mic
 *
 *	Purpose: Sign a RADIUS response packet with given secret.
 *
 ****************************************************************************/

int
build_reply_mic (auth, secret)

AUTH_HDR      *auth;
char          *secret;

{
	u_short      total_length;
	int          secretlen;
	AUTH_HDR1   *ah1;
	u_char       digest[AUTH_VECTOR_LEN];
	static char *func = "build_reply_mic";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (auth->code == PW_EXTENDED_FORMAT)
	{
		/* Just like a request mic */
		return build_request_mic (auth, secret);
	}
	
	/* Version 1 - Use the vector already in there */
	ah1 = (AUTH_HDR1 *) auth;
	total_length = ah1->length;
	ah1->length = htons(total_length);

	/* Append the secret and calculate the response digest */
	secretlen = strlen (secret);
	memcpy ((char *) auth + total_length, secret, secretlen);
	md5_calc (digest, (char *) auth, total_length + secretlen);
	memcpy ((char *) ah1->vector, (char *) digest, AUTH_VECTOR_LEN);
	memset ((char *) auth + total_length, '\0', secretlen);
	return total_length;
} /* end of build_reply_mic () */

/*****************************************************************************
 *
 *	Function: build_request_mic
 *
 *	Purpose: Sign a RADIUS response packet with given secret.
 *
 ****************************************************************************/

int
build_request_mic (auth, secret)

AUTH_HDR      *auth;
char          *secret;

{
	u_short      total_length;
	int          secretlen;
	u_char       digest[AUTH_VECTOR_LEN];
	AUTH_HDR1   *ah1;
	static char *func = "build_request_mic";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/* V1 doesn't have a MIC in requests (except for accounting-req) */
	if (auth->code != PW_EXTENDED_FORMAT)
	{
		ah1 = (AUTH_HDR1 *) auth;

		if (ah1->code == PW_ACCOUNTING_REQUEST)
		{
			/*
			 *	We need to generate a digest in these, using
			 *	a vector of zero.  Note that build_reply_mic()
			 *	is being used on a request here because it
			 *	does just what we need.
			 */
			memset ((char *) ah1->vector, 0 , AUTH_VECTOR_LEN);
			total_length = (u_short) build_reply_mic (auth, secret);
		}
		else
		{
			total_length = ah1->length;
			ah1->length = htons(total_length);
			if (ah1->code == PW_STATUS_SERVER)
			{
				secret = MGMT_POLL_SECRET;
			}
		}
	}
	else /* not V1 */
	{
		total_length = auth->length;
		auth->length = htons(total_length);

		/* Append the secret and calculate the request MIC */
		secretlen = strlen (secret);
		memset ((char *) auth->mic, 0, AUTH_VECTOR_LEN);
		memcpy ((char *) auth + total_length, secret, secretlen);
		md5_calc (digest, (char *) auth, total_length + secretlen);
		memcpy ((char *) auth->mic, (char *) digest, AUTH_VECTOR_LEN);
		memset ((char *) auth + total_length, '\0', secretlen);
	}
	return total_length;
} /* end of build_request_mic () */

/*************************************************************************
 *
 *	Function: check_mic
 *
 *	Purpose: Validate the Message Integrity Code (MIC) in a
 *		 received message (V2 request or reply)
 *
 *************************************************************************/

int
check_mic (auth, rcvlen, secret, ce)

AUTH_HDR       *auth;
u_int           rcvlen;
char           *secret;
CLIENT_ENTRY   *ce;

{
	int              secretlen = strlen (secret);
	time_t           curtime;
	time_t           ts;
	u_char           holdbuf[AUTH_VECTOR_LEN];
	u_char           reply_digest[AUTH_VECTOR_LEN];
	static char     *func = "check_mic";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (auth->flag_ver & AUTH_HDR_TIMESTAMP)
	{
		curtime = time (0);
		ts = * (time_t *) auth->vector;
		ts = (time_t) ntohl (ts) - NTP_TIME_DIFF;

		if ((curtime - ts) > RECV_TIME_WINDOW ||
			(ts - curtime) > RECV_TIME_WINDOW)
		{
			return 1;	
		}
	}
	else if (ce != (CLIENT_ENTRY *) NULL && !(ce->flags & CLIENT_NO_TS))
	{
		/* Remote doesn't seem to support timestamps */
		ce->flags |= CLIENT_NO_TS;
	}
	memcpy ((char *) holdbuf, (char *) auth->mic, AUTH_VECTOR_LEN);
	memset ((char *) auth->mic, 0, AUTH_VECTOR_LEN);
	memcpy ((char *) auth + rcvlen, secret, secretlen);
	md5_calc (reply_digest, (char *) auth, rcvlen + secretlen);
	memset ((char *) auth + rcvlen, 0, secretlen);
	if (memcmp ((char *) holdbuf, (char *) reply_digest, AUTH_VECTOR_LEN)
					 != 0)
	{
		return -1;
	}
	return 0;
} /* end of check_mic () */

/*************************************************************************
 *
 *	Function: compress_file
 *
 *	Purpose: Compress a file.
 *
 *************************************************************************/

void
compress_file (fname)

char           *fname;

{
	int             i;
	int             pid;
	static char    *compress_prog = RAD_COMPRESS;
	static char    *compress_args[] =
			{
				RAD_COMPRESS,	/* argv[0] program name */

#ifdef COMPRESS_ARGS
				COMPRESS_ARGS,	/* argv[1] arguments, if any */
#endif	/* COMPRESS_ARGS */

				NULL,		/* placeholder for filename */
				NULL		/* end of argument list. */
			};

	static char    *func = "compress_file";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (spawn_flag > 0) /* only compress if we won't block */
	{
		pid = (int) fork ();
		if (pid < 0) /* error */
		{
			logit (LOG_DAEMON, LOG_ALERT,
				"%s: fork: %s", func, get_errmsg ());
			exit (-5);
		}
		if (pid > 0) /* parent */
		{
			return;
		}
		else /* in child */
		{
			sleep (5);	/* Wait a while, then start up */

			for (i = 0; compress_args[i] != NULL; i++)
			{
				;	/* continue */
			}

			compress_args[i] = fname;

			/*
			 *	XXX: STDIN, STDOUT, STDERR may be incorrect.
			 *		STDIN and STDOUT may be a UDP socket
			 *		for the server, but may be a terminal
			 *		for radcheck, and the other programs.
			 *
			 *	This may cause problems if the compress
			 *	program checks standard input for data.
			 */
			execvp (compress_prog, compress_args);
			exit (errno);
		}
	}

	return;
} /* end of compress_file () */

/*************************************************************************
 *
 *	Function: debug_list
 *
 *	Purpose: Print the value pair list to the desired File.
 *
 *************************************************************************/

void
debug_list (fd, pair)

FILE           *fd;
VALUE_PAIR     *pair;

{
	VALUE_PAIR      *vp;
	static char     *func = "debug_list";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (debug_flag > 0)
	{
		if (ddt)
		{
			fd = ddt;
		}

		vp = pair;

		while (vp != NULL_VP)
		{
			debug_pair (fd, vp);
			vp = vp->next;
		}
	}
	return;
} /* end of debug_list () */

/*************************************************************************
 *
 *	Function: debug_pair
 *
 *	Purpose: Print the Attribute-value pair to the desired File.
 *
 *************************************************************************/

void
debug_pair (fd, pair)

FILE           *fd;
VALUE_PAIR     *pair;

{
	static char     *func = "debug_pair";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (debug_flag > 0)
	{
		if (ddt)
		{
			fd = ddt;
		}

		fputs ("    ", fd);
		fprint_attr_val (fd, pair);
		fprintf (fd," [flags = 0x%08X]", pair->ap->flags);
		fputs ("\n", fd);
	}
	return;
} /* end of debug_pair () */

/*************************************************************************
 *
 *	Function: dumpit
 *
 *	Purpose: Dump the memory area using logit()
 *
 *	Usage: dumpit (facility, level, ptr, ptrlen, offset, format, args, ...);
 *
 *		Where facility and level are found in syslog.h and the
 *		format is just a printf-style format string using the args.
 *
 *************************************************************************/

int

#if __STDC__ == 1
dumpit (int fac, int lev, void *p, UINT4 plen, UINT4 offset, char *format, ...)
#else
dumpit (va_alist) va_dcl
#endif

{
	va_list         pvar;
	int             done;
	char           *region;
	static char     buffer[MAXPATHLEN];	/* Work area. */

#if __STDC__ == 1
	va_start (pvar, format);
#else
	int             fac;	/* Logging facility, see dprintf() */
	int             lev;	/* Logging level, see dprintf() */
	u_int           plen;	/* Length of the region to dump. */
	u_int           offset;	/* Offset from "ptr" to where to start dump. */
	void           *p;	/* Pointer to start of dumping region. */
	char           *format;	/* An sprintf() like format string. */

	va_start (pvar);
	fac = va_arg (pvar, int);
	lev = va_arg (pvar, int);
	p = va_arg (pvar, void *);
	plen = va_arg (pvar, u_int);
	offset = va_arg (pvar, u_int);
	format = va_arg (pvar, char *);
#endif

#if defined(HAVE_VSNPRINTF)
	vsnprintf (buffer, MAXPATHLEN, format, pvar);
#else	/* HAVE_VSNPRINTF */
	vsprintf (buffer, format, pvar);
#endif	/* HAVE_VSNPRINTF */

	va_end (pvar);

	if (strlen (buffer) > 0)
	{
		logit (fac, lev, "%s", buffer);
	}

	logit (fac, lev, "Hex dump at 0x%p/%x for %d bytes", p, offset, plen);

	region = (char *) p;	/* type-cheating... */

	while (plen > 0)
	{
		done = hex_dump (buffer, region, plen, offset);
		plen -= done;
		offset += done;
		region += done;
		logit (fac, lev, "%s", buffer);
	}

	return 0;

} /* end of dumpit () */

/******************************************************************************
 *
 *	Function: fdcmp
 *
 *	Purpose: Compare two file descriptors to see if they're the same.
 *
 *	Returns: 0, if both file descriptors are the identical,
 *			or they both point to the same inode/device/etc,
 *		 1, if the file descriptors point to different things,
 *		 2, if fd1 is not assigned (fd2 not checked),
 *		 3, if fd2 is not assigned (but fd1 is assigned),
 *		-1, if either file descriptor is less than zero.
 *
 *****************************************************************************/

int
fdcmp (fd1, fd2)

int             fd1;
int             fd2;

{
	struct stat     stat1;
	struct stat     stat2;
	static char    *func = "fdcmp";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((fd1 < 0) || (fd2 < 0))
	{
		return (-1);
	}

	/* Check to see if fd1 is valid. */
	if (fstat (fd1, &stat1) != 0)
	{
		return (2);
	}

	/* Short circut test to see if they're the same. */
	if (fd1 == fd2)
	{
		return (0);
	}

	/* If fd2 isn't assigned, return error. */
	if (fstat (fd2, &stat2) != 0)
	{
		return (3);
	}

	/* If the devices don't match, it's different. */
	if ((stat1.st_dev != stat2.st_dev) ||
		(stat1.st_ino != stat2.st_ino) ||
		(stat1.st_mode != stat2.st_mode) ||
		(stat1.st_uid != stat2.st_uid) ||
		(stat1.st_nlink != stat2.st_nlink) ||
		(stat1.st_gid != stat2.st_gid) ||
		(stat1.st_rdev != stat2.st_rdev))
	{
		return (1);
	}

	/* XXX: What about other values?  Is it safe to use memcmp() here? */

	/* They must be the same. */
	return (0);
} /* end of fdcmp () */

/*************************************************************************
 *
 *	Function: fprint_attr_val
 *
 *	Purpose: Write a printable version of the a/v pair to the given file.
 *
 *************************************************************************/

void
fprint_attr_val (fd, pair)

FILE           *fd;
VALUE_PAIR     *pair;

{
	static char     *func = "fprint_attr_val";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	fprint_attr_val_sws (fd, pair, 0);

	return;

} /* end of fprint_attr_val () */

/*************************************************************************
 *
 *	Function: fprint_attr_val_sws
 *
 *	Purpose: Write a printable version of the a/v pair to the given file.
 *
 *	Remarks: Values for sws:
 *
 *		LF_ACCT_NO_MULTIPLE (0x08)
 *			Don't log the same attribute multiple times.
 *
 *		LF_ACCT_DICT_NOVALUE (0x10)
 *			Don't interpret dictionary integer values.
 *
 *		LF_ACCT_DICT_NONAME (0x20)
 *			Don't show the dictionary attribute name.
 *
 *		LF_NOT_EQUAL (0x40)
 *			Use '!=' instead of '='.
 *
 *************************************************************************/

void
fprint_attr_val_sws (fd, pair, sws)

FILE           *fd;
VALUE_PAIR     *pair;
int             sws;

{
	int              flags;
	char            *val;
	char            *eq = "=";
	static char     *func = "fprint_attr_val_sws";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (pair->ap->name[0] == '\0')
	{
		return;
	}

	if (sws & LF_NOT_EQUAL)
	{
		eq = "!=";
	}

	/* Indicate the attribute identification. */
	if (sws & LF_ACCT_DICT_NONAME)	/* attribute by vendor number */
	{
		fputc ('\t', fd);

		if (pair->ap->vendor_id != 0)
		{
			fprintf (fd, "%d.", pair->ap->vendor_id);
		}
		fprintf (fd, "%d", pair->attribute);
	}
	else	/* attribute by name */
	{
		fputs (pair->ap->name, fd);
	}

	flags = (AVPAIR_VTOA_DQUOTE | AVPAIR_VTOA_DATE);

	/* Now, show the value of the attribute. */
	if ((sws & LF_ACCT_DICT_NOVALUE) == 0)
	{
		if ((val = avpair_vtoa (pair, flags)) != (char *) NULL)
		{
			fprintf (fd, " %s %s", eq, val);
		}
		else
		{
			fputs (" is unknown", fd);
		}
	}
	else
	{
		switch (pair->ap->type)
		{
		    /* Don't explode the dictionary values for integer types. */
		    case PW_TYPE_INTEGER:
		    case PW_TYPE_SHORT:
		    case PW_TYPE_OCTET:
			fprintf (fd, " %s %d", eq, pair->lvalue);
			break;
		
		    default:
			if ((val = avpair_vtoa (pair, flags)) != (char *) NULL)
			{
				fprintf (fd, " %s %s", eq, val);
			}
			else
			{
				fputs (" is unknown", fd);
			}
		}
	}

	return;

} /* end of fprint_attr_val_sws () */

/******************************************************************************
 *
 *	Function: free_linklist
 *
 *	Purpose: Free a chained link list.
 *
 *	Remarks: The link must be the first item in an list entry.
 *		 The list pointer is set to NULL afterwards.
 *
 *****************************************************************************/

int
free_linklist (plist, fdestruct)

LINKLIST_ENT    **plist;
DESTRUCTOR        fdestruct;

{
	int              n = 0;
	LINKLIST_ENT    *list;
	LINKLIST_ENT    *pnext;
	void            *pent = NULL;
	static char     *func = "free_linklist";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	list = *plist;
	for (pnext = list; pnext != (LINKLIST_ENT *) NULL; /* nothing */ )
	{
		n++;
		pent = pnext;
		pnext = pnext->next;

		if (fdestruct != NODESTRUCTOR)
		{
			fdestruct (pent);
		}
		free (pent);

		/*
		 *	Check for a circularly linked list, and check if
		 *	the destructor was removed (pent) from the list.
		 */
		if (pnext == list || pnext == pent)
		{
			break;
		}
	}
	*plist = NULL;
	return n;
} /* end of free_linklist () */

/*************************************************************************
 *
 *	Function: gen_valpairs
 *
 *	Purpose: Takes attribute/value pairs from buffer and builds a
 *		 value pair list using allocated memory.
 *
 *************************************************************************/

VALUE_PAIR *
gen_valpairs (auth, packet_length, veps, sws)

AUTH_HDR       *auth;
u_int           packet_length;
VENDOR_LIST    *veps;
int             sws;		/* 2 => silent, 1 => encapsulate, 0 => drop */

{
	u_short         attr_temp;
	u_short         attribute;
	u_int           max_string_len;
	int             attr_hd_size;
	int             bad_packet = 0;	/* 0 == ALL okay */
					/* 1 == Unknown attribute (ignored) */
					/* 2 == Invalid attribute (error) */
	int             version;
	UINT4           vend_id;
	long            attrlen;
	long            len;
	u_char         *ptr;
	u_char         *mark;
	DICT_ATTR      *attr;
	ATTR_HDR       *ah;
	VALUE_PAIR     *pair;
	VALUE_PAIR     *vp;
	VALUE_PAIR    **vp_end;
	VENDOR_LIST    *each_veps;
	VENDOR         *vendor = (VENDOR *) NULL;
	VENDOR_MAP     *vmap = (VENDOR_MAP *) NULL;
	u_char          buf[AUTH_STRING2_LEN];	/* For encapsulating, etc. */
	static char    *func = "gen_valpairs";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/*
	 *	Extract attribute-value pairs
	 */
	if (auth->code == PW_EXTENDED_FORMAT)
	{
		version = VER2;
		ptr = auth->data;
		/* Get length of attributes */
		len = ntohs(auth->length) - AUTH_HDR_LEN;
		max_string_len = AUTH_STRING2_LEN;
	}
	else /* original RADIUS version */
	{
		version = VER1;
		ptr = ((AUTH_HDR1 *) auth)->data;
		/* Get length of attributes */
		len = ntohs(((AUTH_HDR1 *) auth)->length) - AUTH_HDR1_LEN;
		max_string_len = AUTH_STRING1_LEN;
		attr_hd_size = 2; /* Fixed attribute header size in V1 */
	}

	vp = NULL_VP;
	vp_end = &vp;

	vend_id = 0;	/* Initially, standard RADIUS. */

	while (len > 0)
	{
		/*
		 *	Determine the header length for the attribute:
		 *		(attr_hd_size)
		 *	Mark the start of the attribute:
		 *		(mark)
		 *	Point to the start of the data area:
		 *		(ptr)
		 *	Determine the length of the data area:
		 *		(attrlen)
		 */
		if (version == VER2)
		{
			ah = (ATTR_HDR *) ptr;
			memcpy ((char *) &attribute, (char *) ah->type,
							sizeof (ah->type));
			attribute = ntohs(attribute);
			memcpy ((char *) &attr_temp, (char *) ah->length,
							sizeof (ah->length));
			attrlen = ntohs(attr_temp);
			attr_hd_size = ATTR_HDR_LEN;
			if (ah->flags & ATTR_VEND_SP)
			{
				memcpy ((char *) &vend_id,
					(char *) ah->vendor_id,
					sizeof (ah->vendor_id));
				vend_id = ntohl(vend_id);
				attr_hd_size += sizeof (ah->vendor_id);
			}
			mark = ptr;
			ptr += attr_hd_size;
		}
		else /* original RADIUS version */
		{
			mark = ptr;
			attribute = *ptr++;
			attrlen = *ptr++;
		}

		/* Adjust for attribute header size. */
		attrlen -= attr_hd_size;

		/*
		 *	Sanity check:
		 *
		 *	-- protocol length too short:
		 *		(attrlen < 0)
		 *	-- protocol length far too long:
		 *		(attrlen > max_string_len)
		 *	-- protocol length exceeds remaining packet length:
		 *		(attrlen > len)
		 */
		if (attrlen < 0 || attrlen > max_string_len || attrlen > len)
		{
			dumpit (LOG_DAEMON, LOG_ERR, mark,
				len + attr_hd_size, 0,
			    "%s: Received attribute %d with invalid length %d",
				func, attribute, attrlen + attr_hd_size);

			ddumpx(1, (LOG_DAEMON, LOG_ERR, mark,
				len + attr_hd_size, 0,
			    "%s: Received attribute %d with invalid length %d",
				func, attribute, attrlen + attr_hd_size));

			bad_packet = 2;
			break;
		}

		/* See if we need to map input attribute numbers. */
		vmap = (VENDOR_MAP *) NULL;
		vendor = (VENDOR *) NULL;

		if ((vend_id == 0) && (version == VER1))
		{
			for (each_veps = veps;
				each_veps != (VENDOR_LIST *) NULL;
				each_veps = each_veps->next)
			{
				if ((each_veps->vep->map
						!= (VENDOR_MAP *) NULL) &&
				  (each_veps->vep->map->v_attr[attribute] != 0))
				{
					vendor = each_veps->vep;
					vmap = vendor->map;
					break;  /* Find FIRST match and exit. */
				}
			}
		}

		if (vmap != (VENDOR_MAP *) NULL)
		{
			dprintf(1, (LOG_DAEMON, LOG_DEBUG,
				"%s: Mapping received attribute %d to %d(%ld)",
				func, attribute, vmap->v_attr[attribute],
				vmap->vid));

			/*
			 *	Ensure that the vendor map does not
			 *	match a dictionary entry.
			 */
			if ((attr = dict_attrget (vmap->v_attr[attribute],
							vmap->vid)) == NULLDA)
			{
				logit (LOG_DAEMON, LOG_ERR,
		     "%s: Vendor map #%d attribute %d to %d not in dictionary",
					func, vmap->vid, attribute,
					vmap->v_attr[attribute]);
				/*
				 *	Try to wrap it up in the generic
				 *	Vendor-Specific attribute.
				 */
				bad_packet += gen_wrap (2, attribute, attrlen,
							attr_hd_size, buf, mark,
							pair, &vp_end,
							vmap->vid, version);

				attr = NULLDA;	/* Don't process later. */
			}
			else /* success. */
			{
				attribute = vmap->v_attr[attribute];
				vend_id = vmap->vid;	/* Reset vendor id. */
				/* FALL THROUGH TO BELOW TO ASSIGN ATTRIBUTE */
			}
		}
		else	/* No need to map attribute. */
		{
			/*
			 *	Check to see if the attribute is in the
			 *	dictionary.  If not, encapsulate the attribute.
			 */
			if ((attr = dict_attrget (attribute,
						  vend_id)) == NULLDA)
			{
				bad_packet = 1;

				/* Encapsulate it? */
				if ((sws & GVP_ENCAP) != GVP_ENCAP) /* No. */
				{
					if ((sws & GVP_SILENT) != GVP_SILENT)
					{
						logit (LOG_DAEMON, LOG_INFO,
		     "%s: Received unknown attribute %d of length %d, dropped",
							func, attribute,
							attrlen + attr_hd_size);

						ddumpx(1, (LOG_DAEMON,
							LOG_DEBUG, mark,
							attrlen + attr_hd_size,
							0,
		     "%s: Received unknown attribute %d of length %d, dropped",
							func, attribute,
							attrlen + attr_hd_size));
					}
				}
				else	/* Yes, encapsulate it. */
				{
					if (vendor != (VENDOR *) NULL)
					{
						/*
						 *	Try to wrap it up in
						 *	the generic vendor
						 *	specific attribute.
						 */
						bad_packet += gen_wrap (1,
							attribute, attrlen,
							attr_hd_size, buf,
							mark, pair, &vp_end,
							vendor->id, version);

					}
					else	/* No vendor, drop it. */
					{
						logit (LOG_DAEMON, LOG_INFO,
	  "%s: Received unknown attribute %d of length %d, dropped, no vendor",
							func, attribute,
							attrlen + attr_hd_size);

						ddumpx(1, (LOG_DAEMON,
							LOG_DEBUG, mark,
							attrlen + attr_hd_size,
							0,
	  "%s: Received unknown attribute %d of length %d, dropped, no vendor",
							func, attribute,
							attrlen + attr_hd_size));
					}
				}
			}
		} /* mapping/no mapping */

		/* Could fall through to here from TWO places! */
		/* check for PW_VENDOR_SPECIFIC attributes */
		if (attr != NULLDA)
		{
			if (auth->code != PW_EXTENDED_FORMAT &&
				attr->type == PW_TYPE_VENDOR &&
				!vend_id)
			{
				if (attrlen < 6)
				{
					dumpit (LOG_DAEMON, LOG_ALERT,
						(char *) mark,
						attrlen + attr_hd_size, 0,
			      "%s: Received %s attribute with length %d < six",
						func, attr->name, attrlen);

					ddumpx(1, (LOG_DAEMON, LOG_ALERT,
						(char *) mark,
						attrlen + attr_hd_size, 0,
			      "%s: Received %s attribute with length %d < six",
						func, attr->name, attrlen));

					bad_packet = 1;
					
				}
				else /* Pick up vendor code */
				{
					memcpy ((char *) &vend_id, ptr, 4);
					vend_id = ntohl(vend_id);
					if (generate26 (&vp_end, ptr + 4,
							attrlen - 4,
							vend_id) == -1)
					{
						vend_id = 0; /* forget this */
						pair = avpair_assign_tag (attr,
								      ptr,
								      attrlen,
								      -1);

						if (pair != NULL_VP)
						{
						    debug_pair (stdout, pair);
						    *vp_end = pair;
						    vp_end = &pair->next;
						    logit (LOG_DAEMON, LOG_ERR,
			 "%s: non-encapsulated vendor specific attribute %s=%s",
							   func, pair->ap->name,
							   avpair_vtoa (pair,
							   AVPAIR_VTOA_NULL));
						}
						else
						{
						    dumpit (LOG_DAEMON, LOG_ERR,
							mark,
							attrlen + attr_hd_size,
							0,
				     "%s: Received bad %s attribute %d octets",
							func, attr->name,
							attrlen);

						    ddumpx(1, (LOG_DAEMON,
							LOG_ERR, mark,
							attrlen + attr_hd_size,
							0,
				     "%s: Received bad %s attribute %d octets",
							func, attr->name,
							attrlen));

						    bad_packet = 1;
						}
					}
				}
			}
			else
			{
				if ((pair = avpair_assign_tag (attr, ptr,
						      attrlen, -1)) != NULL_VP)
				{
					debug_pair (stdout, pair);
					*vp_end = pair;
					vp_end = &pair->next;
				}
				else
				{
					dumpit (LOG_DAEMON, LOG_ERR, mark,
						attrlen + attr_hd_size, 0,
				   "%s: Received bad attribute %s length = %d",
						func, attr->name, attrlen);

					ddumpx(1, (LOG_DAEMON, LOG_DEBUG, mark,
						attrlen + attr_hd_size, 0,
				   "%s: Received bad attribute %s length = %d",
						func, attr->name, attrlen));

					bad_packet = 1;
				}
			}
		} /* end of if (attr != NULLDA) */

		vend_id = 0;		/* Reset to standard vendor map */
		vendor = (VENDOR *) NULL;
		vmap = (VENDOR_MAP *) NULL;
		ptr += attrlen;
		len -= attrlen + attr_hd_size;
	} /* end of while */

	if (bad_packet > 0)
	{
		ddumpx(1, (LOG_DAEMON, LOG_DEBUG, auth->data, packet_length, 0,
			"%s: Dump of entire bad packet id %u, type=%s",
			func, auth->id, authtype_toa (auth->code)));

		if (bad_packet > 1)
		{
			list_free (vp);	/* Toss the REALLY BAD list */
			vp = NULL_VP;
		}
	}

	return (vp);
} /* end of gen_valpairs () */

/*************************************************************************
 *
 *	Function: gen_wrap
 *
 *	Purpose: Wrap or encapsulate the attribute.
 *
 *	Returns: 0, upon success,
 *		 1, upon failure.
 *
 *************************************************************************/

static int
gen_wrap (how, attribute, attrlen, headr, buf, mark, pair, vp_list, vid, ver)

int             how;		/* 2, 1 ==> wrapped */
UINT4           attribute;
UINT4           attrlen;
int             headr;		/* Attribute header size. */
u_char         *buf;
u_char         *mark;
VALUE_PAIR     *pair;
VALUE_PAIR   ***vp_list;
UINT4           vid;		/* Vendor id. */
int             ver;		/* Version. */

{
	int             result;
	UINT4           vend_id;
	long            length;
	DICT_ATTR      *attr;
	VALUE_PAIR   ***vp_end;
	static char    *func = "gen_wrap";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (how != 2) /* How == 2 is special wrapped version without logging. */
	{
		logit (LOG_DAEMON, LOG_INFO,
		     "%s: Received unknown attribute %d of length %d, wrapped",
			func, attribute, attrlen);

		ddumpx(1, (LOG_DAEMON, LOG_DEBUG, mark, attrlen + headr, 0,
		     "%s: Received unknown attribute %d of length %d, wrapped",
			func, attribute, attrlen));
	}

	result = 0;

	if ((attr = dict_attrget (PW_VENDOR_SPECIFIC, 0)) == NULLDA)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: FATAL: Lost Vendor-Specific attribute", func);
		dumpcore = 1;
		abort ();
	}

	if (how > 0)	/* encapsulated */
	{
		memset ((char *) buf, 0, 4); /* Clear vendor id. */
	}

	/* Account for both header and data. */
	length = headr + attrlen;

	if (how == 0)	/* encapsulated */
	{
		memcpy ((char *) &buf[1], (char *) mark, length);
		buf[0] = ver;	/* Save which version. */
		length++;	/* Allow for version octet. */
	}
	else	/* wrapped or special wrapped */
	{
		memcpy ((char *) &buf[4], (char *) mark, length);
		vend_id = vid;
		vend_id = htonl(vend_id);
		memcpy ((char *) buf, (char *) &vend_id, 4);
		buf[0] = 0;	/* First octet zero, safety. */
		length += 4;	/* Allow for vendor id. */
	}

	vp_end = vp_list;

	if ((pair = avpair_assign_tag (attr, buf, length, -1)) != NULL_VP)
	{
		**vp_end = pair;
		*vp_end = &pair->next;
	}
	else
	{
		result = 1;
	}

	return result;
} /* end of gen_wrap () */

/*************************************************************************
 *
 *	Function: generate26
 *
 *	Purpose: Process vendor specific attribute(s) and add them to list.
 *
 *	Returns: zero, if successful,
 *		 -1, otherwise.
 *
 *	Remarks: Handles the oddball USR non-RFC conforming VSA format:
 *
 *	 0                   1                   2                   3
 *	 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 *
 *	+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *	|   Type == 26  |    Length     |    IANA Vendor Code == 429
 *	+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *	        (four octet field)      |    USR attribute Type value   |
 *	+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *	        (four octet field)      |  int/date/ipaddr/string payload ...
 *	+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
 *
 *      Note four (4) octet USR attribute value and lack of payload length.
 *
 *	Note: USR has stated there's only one USR VSA payload per attribute 26.
 *
 *************************************************************************/

static int
generate26 (pplist, pattr, length, vendor)

VALUE_PAIR   ***pplist;
u_char         *pattr;		/* This is the attribute 26 internal payload. */
long            length;		/* This is the attribute 26 payload length. */
UINT4           vendor;

{
	u_short          attribute;
	long             attrlen;
	long             len;
	UINT4            temp;
	UINT4            temp2;
	u_char          *ptr;
	u_char          *mark;
	DICT_ATTR       *attr;
	VALUE_PAIR      *pair;
	VALUE_PAIR    ***vp_end;
	static char     *func = "generate26";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	vp_end = pplist;
	ptr = pattr;	/* This is the attribute 26 internal payload. */
	len = length;	/* This is the attribute 26 payload length. */

	if (vendor == VC_USR)
	{
		memcpy ((char *) &temp, (char *) ptr, sizeof (UINT4));
		temp2 = ntohl(temp);
		attribute = (int) temp2; /* Assumes USR values fit in 15 bits */
		ptr = ptr + sizeof (UINT4);

		if ((attr = dict_attrget (attribute, vendor)) == NULLDA)
		{
			logit (LOG_DAEMON, LOG_INFO,
				"%s: USR attribute %d unknown",
				func, attribute);

			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: USR attribute %d unknown",
				func, attribute));

			return (-1);
		}

		attrlen = len - sizeof (UINT4);

		if (attrlen < 0 || attrlen > AUTH_STRING1_LEN)
		{
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: USR attribute %d bad length (%d)",
				func, attribute, attrlen));
			return (-1);
		}

		if ((pair = avpair_assign (attr, ptr, attrlen)) != NULL_VP)
		{
			pair->flags |= VPF_ENCAPS;	/* Force re-encaps. */
			debug_pair (stdout, pair);
			**vp_end = pair;
			*vp_end = &pair->next;
			return 0;
		}
	} /* end of if USR */

	while (len > 0)
	{
		mark = ptr;
		attribute = *ptr++;

		if ((attr = dict_attrget (attribute, vendor)) == NULLDA)
		{
			logit (LOG_DAEMON, LOG_INFO,
				"%s: Vendor %lu attribute %d unknown",
				func, vendor, attribute);

			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: Vendor %lu attribute %d unknown",
				func, vendor, attribute));

			return (-1);
		}

		attrlen = *ptr++;
		attrlen -= 2;	/* Assume Version One inside attribute 26. */

		if (attrlen < 0 ||
			attrlen > AUTH_STRING1_LEN ||
			attrlen > (len - 2))
		{
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: vendor %lu attribute %d bad length (%d)",
				func, vendor, attribute, attrlen));
			return (-1);
		}

		if ((pair = avpair_assign_tag (attr, ptr,
						attrlen, -1)) != NULL_VP)
		{
			pair->flags |= VPF_ENCAPS;	/* Force re-encaps. */
			debug_pair (stdout, pair);
			**vp_end = pair;
			*vp_end = &pair->next;
		}

		ptr += attrlen;
		len -= (attrlen + 2);
	} /* end of while */

	return 0;
} /* end of generate26 () */

/*************************************************************************
 *
 *	Function: get_errmsg
 *
 *	Purpose: Return pointer to static string which gives complete
 *		 filesystem error message.
 *
 *************************************************************************/

char *
get_errmsg ()

{
	static char      errmsg[80];
	static char     *func = "get_errmsg";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (errno < sys_nerr)
	{
		return (char *) sys_errlist[errno];
	}
	else
	{
		sprintf (errmsg, "Error %d", errno);
		return errmsg;
	}
} /* end of get_errmsg () */

/*************************************************************************
 *
 *	Function: get_ipaddr
 *
 *	Purpose: Return an IP address in host long notation from a host
 *		 name or address in dot notation.
 *
 *************************************************************************/

UINT4
get_ipaddr (host)

char           *host;

{
	struct hostent  *hp;
	static char     *func = "get_ipaddr";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (good_ipaddr (host) == 0)
	{
		return ntohl(inet_addr (host));
	}
	else if ((hp = gethostbyname (host)) == (struct hostent *) NULL)
	{
		return ((UINT4) 0);
	}
	return ntohl((*(UINT4 *) hp->h_addr));
} /* end of get_ipaddr () */

/*************************************************************************
 *
 *	Function: get_last_vp
 *
 *	Purpose: Find the last standard attribute value-pair (which matches
 *		 the specified attribute) from the given value-pair list.
 *
 *************************************************************************/

VALUE_PAIR *
get_last_vp (vp, attr)

VALUE_PAIR     *vp;
int             attr;

{
	static char     *func = "get_last_vp";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	return get_last_vp_vend (vp, attr, 0);

} /* end of get_last_vp () */

/*************************************************************************
 *
 *	Function: get_last_vp_vend
 *
 *	Purpose: Find the last vendor attribute value-pair (which matches
 *		 the specified attribute) from the given value-pair list.
 *
 *************************************************************************/

VALUE_PAIR *
get_last_vp_vend (vp, attr, vendorid)

VALUE_PAIR     *vp;
int             attr;
int             vendorid;

{
	VALUE_PAIR      *last_vp;
	static char     *func = "get_last_vp_vend";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/* Find the first matching value-pair. */	
	if ((vp = get_vp_vend (vp, attr, vendorid)) == NULL_VP)
	{
		/* If we run off the end of the list, return a NULL. */
		return NULL_VP;
	}

	/*
	 *	Scan the remainder of the list for a match.
	 *	If we found a match, return it.
	 */
	if ((last_vp = get_last_vp_vend (vp->next, attr, vendorid)) != NULL_VP)
	{
		return (last_vp);
	}

	/* If didn't find a match, return the one we found above. */
	return (vp);	

} /* end of get_last_vp_vend () */

/*******************************************************************************
 *
 *	Function: get_memory
 *
 *	Purpose: Allocate a block of memory and quit if failed.
 *
 ******************************************************************************/

char *
get_memory (siz, whatfunc, forwhat)

u_int        siz;		/* number of bytes */
char        *whatfunc;		/* name of the calling function */
char        *forwhat;		/* name of object for this invocation */

{
	char            *ptr;
	static char     *func = "get_memory";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((ptr = (char *) calloc (1, siz)) == (char *) NULL)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: FATAL - Out of memory for '%s'",
			whatfunc, forwhat);
		abort ();
	}

	return ptr;
} /* end of get_memory () */

/*******************************************************************************
 *
 *	Function: get_next_word
 *
 *	Purpose: Get next word in the given text buffer.
 *
 *	Remark: The text buffer is changed if a word is found not at the end
 *		of the buffer.
 *
 *	Returns: A pointer to beginning of the word.
 *
 ******************************************************************************/

char *
get_next_word (buf, delim, wlength)

char         *buf;		/* text buffer */
char         *delim;		/* list of word delimiters */
int          *wlength;		/* next character in buffer after the word */

{
	static char     *func = "get_next_word";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	buf += strspn (buf, delim);
	*wlength = strcspn (buf, delim);
	return buf;
} /* end of get_next_word () */

/******************************************************************************
 *
 *	Function: get_passwd
 *
 *	Purpose: Decrypts password contained in the PW_USER_PASSWORD or
 *		 CI_ENCRYPTED_PASSWORD value-pair in the AUTH_REQ queue
 *		 entry.  Tries to match one of these passwords against
 *		 the "user_secret", if the "user_secret" is not a NULL
 *		 pointer.  Will also perform a CHAP authentication check,
 *		 if the PW_CHAP_PASSWORD value-pair is found in the request
 *		 and "user_secret" is provided.
 *
 *	Returns: 2 to indicate CHAP failure,
 *		 1 to indicate PASSWORD match failure,
 *		 0 to indicate success,
 *		-1 if no PASSWORD or CHAP value-pair is present.
 *
 ******************************************************************************/

int
get_passwd (authreq, pw, user_secret, salt)

AUTH_REQ       *authreq;	/* Pointer to the authentication request.   */
char           *pw;		/* Receives decrypted password.             */
				/*  (If NULL, only CHAP is attempted.)      */
char           *user_secret;	/* Secret we share with this user or NULL.  */
				/*  If NULL, CHAP is not allowed and the    */
				/*  password match check is not performed.  */
char           *salt;		/* Encryption salt.  If this and the        */
				/*  user_secret are both non-NULL, then     */
				/*  crypt() is called to encrypt the        */
				/*  password before attempting to match the */
				/*  user_secret or the check CHAP reply.    */

{
	int             i;
	int             pass;
	int             passes;
	int             result;
	int             secretlen;
	CLIENT_ENTRY   *ce;
	VALUE_PAIR     *cc;
	VALUE_PAIR     *item;
	u_char         *ptr;
	u_char          buffer[256];	/* Should be big enough. */
	u_char          pwbuf[AUTH_PASS_LEN + 1];
	u_char          digest[CHAP_VALUE_LENGTH];
	int             pwbuf_len = sizeof (pwbuf);
	char           *crypt ();
	static char    *func = "get_passwd";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (user_secret != NULL)
	{
		memset ((char *) pwbuf, '\0', sizeof (pwbuf));
		strncpy ((char *) pwbuf, user_secret, sizeof (pwbuf));
		pwbuf_len = MIN(strlen ((char *) pwbuf), sizeof (pwbuf));
	}

	if (authreq->code == PW_STATUS_SERVER)
	{
		ce = &dummy_status_server_client;
	}
	else
	{
		ce = authreq->client;
	}

	if (pw != NULL &&
		(item = get_vp (authreq->request, PW_USER_PASSWORD)) != NULL_VP)
	{
		/* Compute encrypted length modulo sixteen. */
		passes = (item->lvalue + AUTH_VECTOR_LEN - 1) / AUTH_VECTOR_LEN;

		/* Use the secret to setup the decryption digest. */
		secretlen = strlen ((char *) ce->secret);
		strcpy ((char *) buffer, (char *) ce->secret);
		memcpy ((char *) buffer + secretlen, (char *) authreq->repvec,
							AUTH_VECTOR_LEN);
		memcpy ((char *) pw, item->strvalue, item->lvalue);
		ptr = (u_char *) pw;

		for (pass = 0; pass < passes; pass++)
		{
			md5_calc (digest, buffer, secretlen + AUTH_VECTOR_LEN);
			memcpy ((char *) buffer + secretlen, (char *) ptr,
							AUTH_VECTOR_LEN);
			for (i = 0; i < AUTH_VECTOR_LEN; i++)
			{
				ptr[i] ^= digest[i];
			}
			ptr += AUTH_VECTOR_LEN;
		}

		/*
		 *	Make sure a '\0' is on the end of "pw", even if
		 *	the client didn't pad the password with '\0'.
		 */
		pass = MIN(item->lvalue, AUTH_PASS_LEN); /* 16, 32, 48, etc. */
		pw[pass] = '\0';

		*ptr = '\0';	/* Thanks to billw@cisco.com */
		result = 0;	/* Assume the passwords do match. */

		/* Do a check, if the user-password is passed in. */
		if (user_secret != (char *) NULL)
		{
			/*
			 * If there's a "salt" for this, the user_secret is
			 * a crypt(3c) hashed password, so use the salt to
			 * hash the clear-text password in "pw" into a value
			 * we can compare later.
			 */
			if (salt != (char *) NULL)
			{
				/* UNIX style hashing of passwords. */
				pw = crypt (pw, salt);
				/* NOTE: strlen(pw) is constant! */
			}

			/*
			 * Get current length of password or password hash.
			 */
			pass = strlen (pw);

			if (pwbuf_len == pass) /* length ok, do compare */
			{
				if ((result = memcmp (pw, pwbuf,
							pwbuf_len)) != 0)
				{
					result = 1; /* Indicate pw mismatch. */
				}
			}
			else	/* If lengths don't match, passwords cannot. */
			{
				result = 1;	/* Indicate pw match failure. */
			}
		} /* if (user_secret != NULL) */
	}
	else if (user_secret != (char *) NULL &&
		(item = get_vp (authreq->request, PW_CHAP_PASSWORD)) != NULL_VP)
	{
		/* Use MD5 to verify CHAP */
		ptr = buffer;
		*ptr++ = *item->strvalue;
		strcpy ((char *) ptr, user_secret);

		/*
		 * Allow for CHAP using an encrypted password.  (The client
		 * encrypts the password before generating the CHAP challenge
		 * reply.)  This lets CHAP be used even when passwords are
		 * stored in an encrypted form.  No clients provide this
		 * capability yet, but they could start doing so now! :-)
		 */

		if (salt != (char *) NULL)
		{
			/*YYY get_passwd()
			 *YYY This code depends on crypt(3c) returning
			 *YYY a buffer we can append data to!
			 *YYY We believe that this code isn't being used.
			 */
			ptr = (u_char *) crypt ((char *) ptr, salt);
		}

		secretlen = strlen ((char *) ptr);
		ptr += secretlen;

		if ((cc = get_vp (authreq->request, PW_CHAP_CHALLENGE))
								!= NULL_VP)
		{
			memcpy ((char *) ptr, (char *) cc->strvalue,
				cc->lvalue);
			/*YYY get_passwd() suggest:
				secretlen += cc->lvalue;
			YYY*/
		}
		else
		{
			memcpy ((char *) ptr, (char *) authreq->repvec,
				AUTH_VECTOR_LEN);
			/*YYY get_passwd() suggest:
				secretlen += CHAP_VALUE_LENGTH;
			YYY*/
		}

		/*YYY get_passwd()
		 *YYY Should CHAP_VALUE_LENGTH be a constant only if
		 *YYY the CHAP challenge is taken from the reply vector?
		 */
		md5_calc (digest, buffer, 1 + CHAP_VALUE_LENGTH + secretlen);
		/*YYY get_passwd() suggest replacement:
			md5_calc (digest, buffer, 1 + secretlen);
		YYY*/

		/* Compare them */
		/*YYY get_passwd() suggest replacement:
			if ((result = memcp ((char *) digest,
						item->strvalue + 1,
						item->lvalue)) != 0)
		YYY*/
		if ((result = memcmp ((char *) digest, item->strvalue + 1,
					CHAP_VALUE_LENGTH)) != 0)
		{
			result = 2;	/* Indicate CHAP failure */
		}

	}
	else /* neither password nor CHAP password */
	{
		if (pw)
		{
			*pw = '\0';	/* Return null as pw */
		}
		result = -1;	/* -1 indicates no PW or CHAP vp in request */
	}
	return (result);
} /* end of get_passwd () */

/******************************************************************************
 *
 *	Function: get_realm_name
 *
 *	Purpose: Get realm name with a given string.
 *		 The string "NULL" means a null realm name ("").
 *
 *	Returns: Pointer to realm name.
 *
 *****************************************************************************/

char *
get_realm_name (rname)

char           *rname;

{
	return (strcasecmp (NULL_REALM, rname) != 0) ? rname : "";
} /* end of get_realm_name () */

/*************************************************************************
*
*	Function: get_vp
*
*	Purpose: Find the first attribute value-pair (which matches the given
*		 attribute) from the specified value-pair list.
*
*************************************************************************/

VALUE_PAIR *
get_vp (vp, attr)

VALUE_PAIR     *vp;
int             attr;

{
	return get_vp_vend (vp, attr, 0);
} /* end of get_vp () */

/*************************************************************************
*
*       Function: get_vp_ci
*
*       Purpose: Find the first configuration item on given list.
*
*************************************************************************/

VALUE_PAIR *
get_vp_ci (vp, attr, vend_id)

VALUE_PAIR     *vp;
int             attr;
UINT4           vend_id;

{
	for ( ; vp != NULL_VP ; vp = vp->next)
        {
		if (vp->attribute == attr &&
			vp->ap->vendor_id == vend_id &&
			(vp->ap->flags & ATTR_CONFIG))
		{
                        break;
                }
        }

        return (vp);
} /* end of get_vp_ci () */

/*************************************************************************
*
*       Function: get_vp_vend
*
*       Purpose: Find the first vendor specific attribute value-pair
*                (which matches the given attribute) from the specified
*                specified value-pair list.
*
*************************************************************************/

VALUE_PAIR *
get_vp_vend (vp, attr, vend_id)

VALUE_PAIR     *vp;
int             attr;
UINT4           vend_id;

{
	for ( ; vp != NULL_VP ; vp = vp->next)
        {
		if (vp->attribute == attr &&
			vp->ap->vendor_id == vend_id &&
			!(vp->ap->flags & ATTR_CONFIG))
		{
                        break;
                }
        }

        return (vp);
} /* end of get_vp_vend () */

/******************************************************************************
 *
 *	Function: get_word_list
 *
 *	Purpose: Parse a white-space delimited text line and return the words.
 *
 *	Returns: Number of words found.
 *
 *****************************************************************************/

int
get_word_list (buf, wv, nwv)

char          *buf;
char          *wv[];
int            nwv;

{
	return xget_word_list (buf, wv, nwv, WHITESPACES);
} /* end of get_word_list () */

/*************************************************************************
 *
 *	Function: good_ipaddr
 *
 *	Purpose: Check for valid IP address in standard dot notation.
 *
 *	Returns:  0 when successful,
 *		 -1 otherwise.
 *
 *************************************************************************/

int
good_ipaddr (addr)

char           *addr;

{
	int             dot_count;
	int             digit_count;

	if (addr == (char *) NULL)
	{
		return (-1);
	}

	dot_count = 0;
	digit_count = 0;

	while (*addr != '\0' && *addr != ' ')
	{
		if (*addr == '.')
		{
			dot_count++;
			digit_count = 0;
		}
		else if (!isdigit(*addr))
		{
			dot_count = 5;
		}
		else
		{
			digit_count++;
			if (digit_count > 3)
			{
				dot_count = 5;
			}
		}
		addr++;
	}

	if (dot_count != 3)
	{
		return (-1);
	}
	else
	{
		return (0);
	}
} /* end of good_ipaddr () */

/*************************************************************************
 *
 *	Function: hex_dump
 *
 *	Purpose: Format a region of octets into a formatted string
 *		 suitable for displaying that region of memory.
 *
 *************************************************************************/

int
hex_dump (buffer, data, len, offset)

char         *buffer;
char         *data;
int           len;
int           offset;

{
	int              i = 0;
	int              j = 0;
	int              size = 0;
	int              wlen = 0;
	u_char          *start = (u_char *) data;
	char             hex[3];  /* a hex string placeholder. */
	static char     *func = "hex_dump";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((!buffer) || (!data) || (len <= 0))
	{
		return -1;
	}

	sprintf (buffer, "0x%p:", data);

	buffer += strlen (buffer);
	if (offset >= 0)
	{
		sprintf (buffer, " 0x%4.4x|", offset);
		buffer += strlen (buffer);
	}

	if (len > 16)
	{
		len = 16;
	}

	/* Dump the data in hexadecimal. */

	for (i = 0; i < len; i += 4)
	{
		wlen = i + 4;
		if (wlen > len)
		{
			wlen = len;
		}

		strcat (buffer, " ");
		buffer++;
		for (j = i; j < wlen; j++)
		{
			sprintf (hex, "%2.2X", *start++);
			strcat (buffer, hex);
			buffer += 2;
			size++;
		}

		for ( ; j < (i + 4) ; j++)
		{
			strcat (buffer, "..");
			buffer += 2;
		}
	}

	for ( ; i < 16 ; i += 4)
	{
		strcat (buffer, " ........");
		buffer += 9;
	}

	/* Dump the data in ASCII. */

	strcat (buffer, "| |");
	buffer += strlen (buffer);
	for (i = 0; i < len; i++)
	{
		if ((' ' <= *data) && (*data < 0x7f))
		{
			*buffer++ = *data;
		}
		else
		{
			*buffer++ = '.';
		}
		data++;
	}

	for ( ; i < 16 ; i++)
	{
		*buffer++ = '|';
	}

	*buffer++ = '|';
	*buffer = '\0';  /* Terminate the string. */

	return size;

} /* end of hex_dump () */

/*************************************************************************
 *
 *	Function: insert_attribute
 *
 *	Purpose: Low level attribute output routine.
 *		 Outputs either V1 or V2 attribute format.
 *
 *	Returns: length of packet (positive values),
 *		 zero, error, unable to insert attribute (general),
 *		 -1, fatal error ???,
 *		 -2, maxlen exceeded.
 *
 *************************************************************************/

static int
insert_attribute (attr, auth, maxlen, valptr, len, av_flags, veps, tag)

DICT_ATTR      *attr;			/* Dictionary entry and type of data */
AUTH_HDR       *auth;			/* Output buffer */
UINT4           maxlen;			/* Size of output buffer */
void           *valptr;			/* Pointer to data passed in */
int             len;			/* Length of data passed in or zero */
int             av_flags;
VENDOR_LIST    *veps;			/* Destination vendor information */
int             tag;

{
	u_char          flags = attr->flags;     /* Dictionary flags */
	u_short         attribute = attr->value; /* Dictionary attr number */
	u_short         length;
	UINT2           temp_short;
	int             errors = 0;
	int             fatal = 0;
	int             outlen;		/* length of data produced */
	int             overflow = 0;
	int             type = attr->type;	/* PW_TYPE_STRING, etc. */
	int             version;	/* RADIUS (1) or DIAMETER (2) */
	UINT4           temp;
	UINT4           vendor_id = attr->vendor_id;	/* Dictionary vendor */
	UINT4           usr_attr;
	UINT4           usr_value;
	u_char         *data;
	u_char         *ptr;
	u_char         *tmp;
	u_short        *len_ptr;
	ATTR_HDR       *ah;
	VENDOR_LIST    *each_veps;
	VENDOR         *vendor;
	VENDOR_MAP     *vmap;
	u_char          dummy_data[255]; /* For USR mapping. */
	static char    *func = "insert_attribute";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	data = (u_char *) valptr;

	/*
	 *	If the length passed in is zero,
	 *	calculate the length for attribute
	 *	types where the length can be determined.
	 */
	if (len == 0)
	{
		switch (type)
		{
		    case PW_TYPE_TAG_INT:
		    case PW_TYPE_INTEGER:
		    case PW_TYPE_IPADDR:
		    case PW_TYPE_DATE:
			len = 4;
			break;

		    case PW_TYPE_SHORT:
			len = 2;
			break;

		    case PW_TYPE_OCTET:
			len = 1;
			break;

		    default:
			logit (LOG_DAEMON, LOG_ERR,
			   "%s: Invalid attribute %s (%d), type %d, vendor %d",
				func, attr->name, attribute, type, vendor_id);
			return (0);	/* non-fatal error return */
		}
	}
	else
	{
		if (len < 0)
		{
			logit (LOG_DAEMON, LOG_ALERT,
 "%s: Invalid (negative) length, %d for attribute %s (%d), type %d, vendor %d",
				func, len, attr->name, attribute, type,
				vendor_id);
			return (0);	/* non-fatal error return */
		}
	}

	/* Determine the version based on the header. */
	if (auth->code == PW_EXTENDED_FORMAT)
	{
		len_ptr = &auth->length;
		version = VER2;
	}
	else
	{
		len_ptr = &((AUTH_HDR1 *) auth)->length;
		version = VER1;
	}

	/* Determine output length */
	switch (type)
	{
	   case PW_TYPE_OCTET:
		outlen = 1;
		break;

	   case PW_TYPE_SHORT:
		outlen = 2;
		break;

	   case PW_TYPE_TAG_STR:
		if (version != VER1)
		{
			logit (LOG_DAEMON, LOG_ERR,
		 "%s: Type tag-str not supported for version %d, attribute %s",
				func, version, attr->name);
			return (0);	/* non-fatal error return */
		}

		/* Version 1 (RADIUS) protocol */
		outlen = len + 1;  /* Account for tag in string */
		break;

	   default:
		outlen = len;
	} /* end of switch to determine the output length */

	ptr = (u_char *) auth + *len_ptr;

	/*
	 *	If unknown attribute, unencapsulate the raw attribute
	 *	which was captured earlier.
	 */
	switch (vendor_id)
	{
	    case VC_RADIUS:		/* Standard RADIUS, vendor zero. */
		switch (attribute)
		{
		    default:
			break;

		    case PW_VENDOR_SPECIFIC:
			/*
			 *	Get the vendor ID out of the data
			 *	part of the payload.
			 */
			memcpy ((char *) &vendor_id, data, 4);
			vendor_id = ntohl(vendor_id);

			/*
			 *	Do special vendor-id work.
			 *	USR does not follow the RFC
			 *	suggestion of VSA encoding.
			 */
			switch (vendor_id)
			{
			    case VC_USR:
				 if (version == VER1)
				 {
					/* Leave encapsulated */
					vendor_id = VC_RADIUS;
					break;
				 }
				 /***FALLTHROUGH***/

			    default: /* assume encapsulation */
				 /*
				  *	If the Vendor-Specific (26) attribute
				  *	contains an attribute specific to a
				  *	particular vendor, try to unwrap it
				  *	and send it out "plain" on the wire.
				  *
				  *	Check to make sure the payload
				  *	format satisfies an encapsulated
				  *	V1 RADIUS Vendor-Specific attribute.
				  */

				 /*
				  *	NOTE:
				  *	This code does NOT handle multiple
				  *	instances of vendor specific attribute
				  *	within a single attribute 26 payload.
				  */
				 if (data[5] == (outlen - 4))
				 {
					type = PW_TYPE_OCTETS;
					attribute = data[4];
					outlen = data[5];  /* get new length */

					/* Subtract V1 header. */
					outlen = outlen - 2;
					flags = 0;

					/* Point to new payload. */
					data = data + 6;

					dprintf(2, (LOG_DAEMON, LOG_DEBUG,
	   "%s: unwrapping encapsulated attribute, vendor id %d, attribute %d",
						func, vendor_id, attribute));
				 }
			} /* end of inner switch */
			break;

		} /* end of middle switch */
	} /* end of outer switch */

	/* Determine how to put the data onto the wire. */
	switch (vendor_id)
	{
	    case VC_RADIUS:
		break;

	    case VC_USR:
		/* The USR NAS does strange things. */
		if (version == VER1)
		{
			/*
			 *	Map the USR attribute into a
			 *	Vendor-Specific attribute.
			 */

			/*
			 *	vendor id (4 bytes)
			 *	USR attr  (4 bytes)
			 *	USR value (depends)
			 */

			temp = VC_USR;
			temp = htonl(temp);
			memcpy ((char *) &dummy_data[0], (char *) &temp, 4);

			usr_attr = htonl(attribute);
			memcpy ((char *) &dummy_data[4], (char *) &usr_attr, 4);

			switch (type)
			{
			    case PW_TYPE_STRING:
			    case PW_TYPE_OCTETS:
				if (outlen > (255 - (2 + 8)))
				{
					errors++;
					fatal++;
					logit (LOG_DAEMON, LOG_INFO,
					    "%s: USR attribute %s:d too long",
						func, attr->name, attr->value);
					break;
				}

				memcpy ((char *) &dummy_data[8], data, outlen);
				data = dummy_data;
				outlen += 8;	/* vendor id + USR attr num */
				attribute = PW_VENDOR_SPECIFIC;
				break;

			    case PW_TYPE_INTEGER:
			    case PW_TYPE_DATE:
			    case PW_TYPE_IPADDR:
				memcpy ((char *) &usr_value, data, outlen);
				usr_value = htonl(usr_value);
				memcpy ((char *) &dummy_data[8],
					(char *) &usr_value, 4);

				data = dummy_data;
				outlen = 12;
				attribute = PW_VENDOR_SPECIFIC;
				break;

			    default:
				logit (LOG_DAEMON, LOG_INFO,
		      "%s: Unable to convert USR attribute %s:%d to V1 format",
					func, attr->name, attr->value);
				fatal++;
				errors++;
			} /* end of switch */
			break;
		} /* end of if V1 */
		/***FALLTHROUGH***/

	    default:
		/*
		 *	Send the vendor specific attribute plain on
		 *	the wire only if ALL of the below apply:
		 *
		 *	1) Using version one of protocol (RFC conformant)
		 *	2) It wasn't encapsulated when originally received
		 *	3) The dictionary doesn't require encapsulation
		 *	4) The attribute number within the vendor space
		 *	   doesn't conflict with a previous vendor in
		 *	   the client list
		 *	5) The vendor matches
		 */
		if (((av_flags & VPF_ENCAPS) == 0) && (version == VER1))
		{
			vendor = (VENDOR *) NULL;

			for (each_veps = veps;
				each_veps != (VENDOR_LIST *) NULL;
				each_veps = each_veps->next)
			{
				if (each_veps->vep->id == vendor_id)
				{
					/*
					 *	Remap the vendor specific
					 *	attribute into standard space.
					 */
					vendor = each_veps->vep;

					if ((vmap = vendor->map)
							!= (VENDOR_MAP *) NULL)
					{
						dprintf(2, (LOG_DAEMON,
							LOG_DEBUG,
				"%s: mapping vendor %d attribute %s (%d) to %d",
							func, vendor_id,
							attr->name, attribute,
							vmap->v_attr[attribute]));

						attribute =
							vmap->v_attr[attribute];
					}

					vendor_id = VC_RADIUS;
					break;
				}

				if ((vmap = each_veps->vep->map)
							!= (VENDOR_MAP *) NULL)
				{
					/*
					 *	If the vendor doesn't match,
					 *	and there's an attribute there,
					 *	then encapsulate.
					 */
					if (vmap->v_attr[attribute] != 0)
					{
						av_flags |= VPF_ENCAPS;
						break;
					}
				}
			} /* end of for (each vendor in output vendor list) */

			/* No match, so encapsulate. */
			if (vendor == (VENDOR *) NULL)
			{
				av_flags |= VPF_ENCAPS;
			}
		} /* end of if (version 1 and encapsulation required) */

		/* Only version one (V1) needs prefix */
		if (((av_flags & VPF_ENCAPS) != 0) && (version == VER1))
		{
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: Encapsulating vendor %d attribute %d",
				func, vendor_id, attribute));

			*ptr++ = PW_VENDOR_SPECIFIC;

			if ((length =
				2 + sizeof (vendor_id) + 2 + outlen) > 255)
			{
				errors++;
				fatal++;	/* Don't modify things! */
			}

			/* Don't modify anything if a fatal error occurs */
			if (fatal == 0)
			{
				*ptr++ = length;
				vendor_id = htonl(vendor_id);
				memcpy ((char *) ptr, &vendor_id,
					sizeof (vendor_id));
				ptr += sizeof (vendor_id);
			}
		}
		else
		{
			vendor_id = htonl(vendor_id);
		}
	} /* end of switch */

	if (version == VER1)
	{
		if ((fatal == 0) && (overflow == 0))
		{
			*ptr++ = attribute;
		}

		if ((length = outlen + 2) > 255 || attribute > 255 || errors)
		{
			logit (LOG_DAEMON, LOG_ALERT,
	       "%s: Attribute %s(%d:%ld) or value length %u doesn't fit in V1",
				func, attr->name, attr->value, attr->vendor_id,
				outlen);
			errors++;

			if (length > 255)
			{
				fatal++;
			}
		}

		/* MAXLEN check */
		if (*len_ptr + length >= maxlen)
		{
			logit (LOG_DAEMON, LOG_ERR,
		     "%s: maximum packet length exceeded (%u), for %s(%d:%ld)",
				func, maxlen, attr->name, attr->value,
				attr->vendor_id);
			overflow++;
			fatal++;
			errors++;
		}

		/* Don't modify anything if a fatal error occurs. */
		if (fatal == 0)
		{
			*ptr++ = length;
		}
	}
	else if (*len_ptr + ATTR_HDR_LEN >= maxlen)
	{
		logit (LOG_DAEMON, LOG_ERR,
		  "%s: maximum packet length (%u) exceeded for V2 attr header",
			func, maxlen);
		overflow++;
		fatal++;
		errors++;
	}
	else /* Extended attribute format */
	{
		ah = (ATTR_HDR *) ptr;
		attribute = htons(attribute);
		memcpy ((char *) ah->type, (char *) &attribute,
							sizeof (u_short));
		ah->flags = flags & ATTR_MUST;
		ptr += ATTR_HDR_LEN;
		length = outlen + ATTR_HDR_LEN;

		if (vendor_id != 0) /* If vendor specific */
		{
			if (*len_ptr + length >= maxlen)
			{
				logit (LOG_DAEMON, LOG_ERR,
		   "%s: maximum packet length (%u) exceeded for V2 attr value",
					func, maxlen);
				overflow++;
				fatal++;
				errors++;
			}
			else
			{
				ah->flags |= ATTR_VEND_SP;
				memcpy ((char *) ah->vendor_id,
					(char *) &vendor_id, sizeof (UINT4));
				ptr += sizeof (UINT4);
			}
		}
	}

	if (fatal == 0)
	{
		switch (type)
		{
		    case PW_TYPE_TAG_STR:
			*ptr = tag;
			ptr++;
			outlen--;
			/***FALLTHROUGH***/

		    case PW_TYPE_VENDOR:
		    case PW_TYPE_OCTETS:
		    case PW_TYPE_STRING:

#ifdef BINARY_FILTERS
		    case PW_TYPE_FILTER_BINARY:
#endif	/* BINARY_FILTERS */

			memcpy ((char *) ptr, (char *) data, outlen);
			break;

		    case PW_TYPE_OCTET:
			switch (len)
			{
			    case 1:	/* one byte. */
				(u_char) *ptr = (u_char) *data;
				break;

			    case 2:     /* unsigned short to one byte */
				memcpy ((char *)&temp_short, (char *) data, 2);
				(u_char) *ptr = (u_char) temp_short;
				break;

			    case 4:
				memcpy ((char *)&temp, (char *) data, 4);
				(u_char) *ptr = (u_char) temp;
				break;

			    default:
				logit (LOG_DAEMON, LOG_ERR,
			      "%s: Unable to match length %d to octet type %s",
					func, len, attr->name);
				errors++;
			}
			break;

		    case PW_TYPE_SHORT:
			switch (len)
			{
			    case 1:	/* one byte. */
				temp_short = (u_char) *data;
				temp_short = htons(temp_short);
				memcpy ((char *) ptr, (char *) &temp_short, 2);
				break;

			    case 2:     /* unsigned short to one byte */
				memcpy ((char *)&temp_short, (char *) data, 2);
				temp_short = htons(temp_short);
				memcpy ((char *) ptr, (char *) &temp_short, 2);
				break;

			    case 4:
				memcpy ((char *)&temp, (char *) data, 4);
				(u_short) temp_short = (u_short) temp;
				temp_short = htons(temp_short);
				memcpy ((char *) ptr, (char *) &temp_short, 2);
				break;

			    default:
				logit (LOG_DAEMON, LOG_ERR,
			      "%s: Unable to match length %d to short type %s",
					func, len, attr->name);
				errors++;
			}
			break;

		    case PW_TYPE_TAG_INT:
			memcpy ((char *) &temp, (char *) data, 4);
			temp = htonl(temp);
			/*
			 *	In network order, the first octet is
			 *	the most significant, and that octet
			 *	is being used for the tag.
			 */
			memcpy ((char *) ptr, (char *) &temp, 4);
			*ptr = tag;
			break;

		    case PW_TYPE_IPADDR:
		    case PW_TYPE_INTEGER:
		    case PW_TYPE_DATE:
			memcpy ((char *) &temp, (char *) data, 4);
			temp = htonl(temp);
			memcpy ((char *) ptr, (char *) &temp, 4);
			break;

		    default:
			logit (LOG_DAEMON, LOG_ALERT,
				"%s: Invalid type for attribute %s(%lu)",
				func, attr->name, attr->vendor_id);
			errors++;
			break;
		}
	}

	ptr += outlen;

	if ((version != VER1) && (fatal == 0))
	{
		temp = (char *) ptr - (char *) ah;
		if (temp <= 65535)
		{
			length = temp;
			length = ntohs(length);
		}
		else
		{
			length = 65535;
			logit (LOG_DAEMON, LOG_ERR,
				"%s: Too large for network short (%lu)",
				func, temp);
		}
		memcpy ((char *) ah->length, (char *) &length, sizeof (length));
	}

	/*
	 *	Error return check.
	 */
	if (overflow != 0)
	{
		return (-2);
	}

	if (fatal != 0)
	{
		return (-1);
	}

	if (errors != 0)
	{
		return 0;
	}

	*len_ptr = ((char *) ptr - (char *) auth);
	return *len_ptr;
} /* end of insert_attribute () */

/*************************************************************************
 *
 *	Function: insert_vp
 *
 *	Purpose: Given the address of an existing list "a" and a pointer
 *		 to an entry "p" in that list, add the value pair "b" to
 *		 the "a" list after the "p" entry.  If "p" is NULL, add
 *		 the value pair "b" to the end of "a".
 *
 *************************************************************************/

void
insert_vp (a, p, b)

VALUE_PAIR     **a;
VALUE_PAIR     *p;
VALUE_PAIR     *b;

{
	VALUE_PAIR     *this_node;
	VALUE_PAIR     *vp;
	static char    *func = "insert_vp";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (b->next != NULL_VP)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: FATAL value pair (0x%p) next ptr. (0x%p) not NULL",
			func, b, b->next);
		dumpcore = 1;
		abort ();
	}

	if (*a == NULL_VP)
	{
		*a = b;
		return;
	}

	vp = *a;

	if (p == NULL_VP)		/* run to end of "a" list */
	{
		while (vp != NULL_VP)
		{
			this_node = vp;
			vp = vp->next;
		}
	}
	else	/* look for the "p" entry in the "a" list */
	{
		this_node = *a;
		while (this_node != NULL_VP)
		{
			if (this_node == p)
			{
				break;
			}
			this_node = this_node->next;
		}
	}

	b->next = this_node->next;
	this_node->next = b;

	return;
} /* end of insert_vp () */

/*************************************************************************
 *
 *	Function: list_cat
 *
 *	Purpose: Given two lists, "a" and "b", place "b" at the end of "a"
 *
 *************************************************************************/

void
list_cat (a, b)

VALUE_PAIR    **a;
VALUE_PAIR     *b;

{
	VALUE_PAIR    **last;
	FILE           *debugout = stdout;
	static char    *func = "list_cat";

	dprintf(4, (LOG_AUTH, LOG_DEBUG, "%s: entered", func));

	if (debug_flag >= 4)
	{
		if (ddt)
		{
			debugout = ddt;
		}
		fprintf (debugout, "First list:\n");
	}

	for (last = a ; *last != NULL_VP ; last = &((*last)->next))
	{
		if (debug_flag >= 4)
		{
			debug_pair (debugout, *last);
		}
	}

	*last = b;

	if (debug_flag >= 4)
	{
		fprintf (debugout, "and Second list:\n");
		debug_list (debugout, b);
	}

	return;
} /* end of list_cat () */

/*************************************************************************
 *
 *	Function: list_copy
 *
 *	Purpose: Make a copy of the entire list of value pairs pointed to by
 *		 from_list.  It is necessary to copy the check_items and
 *		 reply_items from a USER_ENTRY before processing a request
 *		 because they may be modified or freed.
 *
 *	Returns: how many a/v pairs copied.
 *
 *************************************************************************/

int
list_copy (to_list, from_list)

VALUE_PAIR    **to_list;
VALUE_PAIR     *from_list;

{
	int             count = 0;      /* Count items we copy. */
	int             to_size = 0;	/* How many we've counted to. */
	int             from_size = 0;	/* How many we've counted from. */
	VALUE_PAIR     *copy_item;
	VALUE_PAIR     *new_item;
	VALUE_PAIR    **last;
	VALUE_PAIR    **old_end;
	static char    *func = "list_copy";

	dprintf(2, (LOG_AUTH, LOG_DEBUG, "%s: entered", func));

	if (to_list == (VALUE_PAIR **) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR, "%s: FATAL: NULL parameter", func);
		exit (-13);
	}

	copy_item = NULL_VP;

	/* run to end of destination list */
	for (last = to_list ; *last != NULL_VP ; last = &((*last)->next))
	{
		if (*last == from_list)
		{
			logit (LOG_DAEMON, LOG_ALERT,
		       "%s: FATAL: (0x%p->0x%p,0x%p) crosslinked at 0x%p->0x%p",
			       func, to_list, *to_list, from_list, last, *last);
			dumpcore = 1;
			abort ();
		}
		to_size++;
	}
	old_end = last; /* Save old end-ptr for sanity checking. */

	new_item = NULL_VP;

	dprintf(5, (LOG_AUTH, LOG_DEBUG,
			"%s: copy from list 0x%p to end of list at 0x%p->0x%p",
			func, from_list, to_list, *to_list));

	for (copy_item = from_list ;
		copy_item != NULL_VP ;
		copy_item = copy_item->next)
	{
		if (count > list_copy_limit)
		{
			/* Save from_length for debugging. */
			from_size = avpair_list_length (from_list);
			logit (LOG_DAEMON, LOG_ALERT,
"%s: FATAL (0x%p->0x%p, 0x%p), at 0x%p, to_size=%d, count=%d, from_size=%d, limit exceeded",
				func, to_list, *to_list, from_list, copy_item,
				to_size, count, from_size);
			dumpcore = 1;
			abort ();
		}

		if (copy_item == *old_end)
		{
			logit (LOG_DAEMON, LOG_ALERT,
		 "%s: FATAL (0x%X->0x%X, 0x%X) list appended to itself at 0x%X",
				func, to_list, *to_list, from_list, copy_item);
			dumpcore = 1;
			abort ();
		}

		new_item = avpair_dup (copy_item);

		*last = new_item; /* always put copy at end of to_list */
		last = &(new_item->next); /* new end of to_list */
		count++;
	}

	dprintf(2, (LOG_AUTH, LOG_DEBUG, "%s: copied %d items", func, count));

	if ((from_size = count + to_size) > list_copy_limit)
	{
		logit (LOG_DAEMON, LOG_ALERT,
"%s: WARNING (0x%X->0x%X, 0x%X) list (%d+%d = %d) exceeds 'list_copy_limit' (%d)",
			func, to_list, *to_list, from_list, to_size, count,
			from_size, list_copy_limit);
	}

	return from_size;
} /* end of list_copy () */

/*************************************************************************
 *
 *	Function: list_free
 *
 *	Purpose: Release the memory used by a list of a/v pairs.
 *
 *************************************************************************/

void
list_free (pair)

VALUE_PAIR     *pair;

{
	int             n = 0;
	VALUE_PAIR     *next;
	static char    *func = "list_free";

	dprintf(2, (LOG_AUTH, LOG_DEBUG, "%s: entered", func));

	while (pair != NULL_VP)
	{
		n++;
		next = pair->next;
		avpair_free (pair);
		pair = next;
	}

	if (n > 0)
	{
		dprintf(2, (LOG_AUTH, LOG_DEBUG,
			"%s: freeing %d pairs", func, n));
	}

	return;
} /* end of list_free () */

#ifndef RELIABLE_FLOCK

/******************************************************************************
 *
 *	Function: lockfile
 *
 *	Purpose: Use the fcntl() call to perform a file lock operation since
 *		 the flock() library routine is not reliable on many systems.
 *
 *	Returns: zero, on success,
 *		 -1, on failure and sets errno to indicate the error.
 *
 *****************************************************************************/

int
lockfile (fd, operation)

int      fd;
int      operation;

{
	int              retval = 0;
	int              op = F_SETLKW;         /* assuming blocking */
	struct flock     lck;
	static char     *func = "lockfile";

	if ((operation & LOCK_NB) != 0)
	{
		op = F_SETLK;
	}

	lck.l_type = ((operation & LOCK_UN) ? F_UNLCK :
				((operation & LOCK_SH) ? F_RDLCK : F_WRLCK));
	lck.l_whence = 0;
	lck.l_start = SEEK_SET;
	lck.l_len = 0L;
	lck.l_pid = (pid_t) 0;

	if (fcntl (fd, op, &lck) == -1)
	{
		retval = -1;
	}

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s(fd=%d, op=%d) => %d",
		func, fd, operation, retval));

	return retval;
} /* end of lockfile () */
#endif  /* RELIABLE_FLOCK */

/*************************************************************************
 *
 *	Function: logfmt_accounting
 *
 *	Purpose: Take an a/v pair list and log it in the Livingston format.
 *
 *	Returns: A count of the number of a/v pairs logged.
 *
 *	values for sws:
 *
 *	LF_ACCT_NO_MULTIPLE (0x08)
 *		Don't log the same attribute multiple times.
 *
 *	LF_ACCT_DICT_NOVALUE (0x10)
 *		Don't interpret dictionary integer values.
 *
 *	LF_ACCT_DICT_NONAME (0x20)
 *		Don't show the dictionary attribute name.
 *
 *************************************************************************/

int
logfmt_accounting (f, list, gmt_or_local, sws)

FILE           *f;		/* Stream to write to. */
VALUE_PAIR     *list;		/* What to log. */
int             gmt_or_local;	/* 0 ==> local time, 1 ==> GMT time */
int             sws;		/* See above. */

{
	int             count = 0;	/* How many a/v pairs we logged. */
	time_t          now;
	struct tm      *tm;
	static char    *func = "logfmt_accounting";

	dprintf(2, (LOG_AUTH, LOG_DEBUG, "%s: entered", func));

	/* Logging here should be independant of logging anywhere else. */
	reset_vp_flags_list (list, VPF_LOGGED);
	reset_vp_attr_flags_list (list, ATTR_LOGGED);

	/* Post a timestamp */
	now = time (NULL);
	if (gmt_or_local)
	{
		tm = gmtime (&now);
	}
	else
	{
		tm = localtime (&now);
	}
	fputs (asctime (tm), f);

	/* Write each attribute/value to the call detail file */
	while (list != NULL_VP)
	{
		/*
		 * Check to see if the dictionary doesn't allow this
		 * attribute to be logged.
		 */
		if ((list->ap->flags & ATTR_NOLOG) != ATTR_NOLOG)
		{
			/*
			 * Don't log same attribute twice if sws is non-zero.
			 */
		        if (((list->ap->flags & ATTR_LOGGED) != ATTR_LOGGED) ||
				((sws & LF_ACCT_NO_MULTIPLE) == 0))
			{
				fputs ("\t", f);
				fprint_attr_val_sws (f, list, sws);
				fputs ("\n", f);

				/*
				 * Mark the value pair and attribute as logged.
				 */
				set_vp_flag (list, VPF_LOGGED);
				set_attr_flag (list->ap, ATTR_LOGGED);
				
				count++;
			}
		}
		list = list->next;
	}

	fputs ("\n", f);	/* Empty line is End of Record. */	

	return count;		/* How many a/v pairs were recorded. */
} /* end of logfmt_accounting () */

/*************************************************************************
 *
 *	Function: _logit
 *
 *	Purpose: Log the provided error message to the error logging facility.
 *
 *	Usage: logit (facility, level, format, args, ...);
 *
 *		Where facility and level are found in syslog.h and the
 *		format is just a printf-style format string using the args.
 *
 *************************************************************************/

static int

#if __STDC__ == 1
_logit (int facility, int level, CONST char *format, ...)
#else
_logit (va_alist) va_dcl
#endif

{
	va_list         pvar;
	int             priority;
	int             old_errno = errno;	/* Save in case of problems */
	time_t          timeval;
	static char     logit_buffer[MAXPATHLEN];
	static char    *func = "_logit";

#if __STDC__ == 1
	va_start (pvar, format);
#else
	int             facility;
	int             level;
	char           *format;

	va_start (pvar);
	facility = va_arg (pvar, int);
	level = va_arg (pvar, int);
	format = va_arg (pvar, char *);
#endif

#if defined(HAVE_VSNPRINTF)
	vsnprintf (logit_buffer, MAXPATHLEN, format, pvar);
#else	/* HAVE_VSNPRINTF */
	vsprintf (logit_buffer, format, pvar);
#endif	/* HAVE_VSNPRINTF */

	va_end (pvar);

	if (file_logging == 1) /* log it to the logfile */
	{
		if (msgfd == stderr)
		{
			msgfd = (FILE *) NULL;
		}
		setup_logfile (0);	/* Time to do logfile swapping? */

		if (level != LOG_DEBUG) /* don't log debugging messages */
		{
			timeval = time (0);
			fprintf (msgfd, "%-24.24s: %s\n",
				ctime (&timeval), logit_buffer);

			if (level == LOG_ALERT)
			{
				fflush (msgfd);
			}
		}
	}
	else /* was not logging to a file */
	{
		if (file_logging == 2) /* log it to stderr */
		{
			fprintf (msgfd, "%s\n", logit_buffer);
		}
		else /* log it to syslog(3) */
		{
			zap_logfile = 0;
			priority = facility | level;
			syslog (priority, "%s", logit_buffer);
		}
	}

	if (level == LOG_DEBUG && ddt != (FILE *) NULL)
	{
		fprintf (ddt, "%s\n", logit_buffer); /* log it to pre-opened device */
	}

	errno = old_errno;		/* Restore old error number. */
	return 0;
} /* end of _logit () */

#define	MAX_MF_ENT_TOAS	20

/*************************************************************************
 *
 *	Function: mf_ent_toa
 *
 *	Purpose: Display an MF_ENT.
 *
 *	Returns: 0, normal return,
 *		-1, authreq is bad somehow.
 *
 *************************************************************************/

char *
mf_ent_toa (title, p_mf)

char            *title;		/* Descriptor of what we're showing. */
MF_ENT          *p_mf;		/* What to dump. */

{
	static char      buffers[MAX_MF_ENT_TOAS][40];
	static int       ndx = 0;
	char            *str = buffers[ndx];
	static char     *func = "mf_ent_toa";

	if ((title == (char *) NULL) || (p_mf == (MF_ENT *) NULL))
	{
		return "";
	}

	sprintf (str, "%s=%d/%d", title, p_mf->m, p_mf->f);

	if (++ndx >= MAX_MF_ENT_TOAS)
	{
		ndx = 0;
	}

	return str;
} /* end of mf_ent_toa () */

/*************************************************************************
 *
 *	Function: missing_attribute
 *
 *	Purpose: Generate standard log message for missing attributes.
 *
 *************************************************************************/

void
missing_attribute (authreq, func, attribute, etc)

AUTH_REQ       *authreq;
char	       *func;		/* Function which called us. */
int		attribute;	/* Missing attribute. */
char	       *etc;		/* Optional additional information. */

{
	static char     *thisfunc = "missing_attribute";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", thisfunc));

	missing_attribute_vend (authreq, func, attribute, etc, 0);

	return;
} /* end of missing_attribute () */

/*************************************************************************
 *
 *	Function: missing_attribute_vend
 *
 *	Purpose: Generate standard log message for missing attributes.
 *
 *************************************************************************/

void
missing_attribute_vend (authreq, func, attribute, etc, vendor_id)

AUTH_REQ       *authreq;
char           *func;		/* Function which called us. */
int	        attribute;	/* Missing attribute. */
char           *etc;		/* Optional additional information. */
int             vendor_id;

{
	DICT_ATTR       *attr = dict_attrget (attribute, vendor_id);
	char            *attr_name;
	VALUE_PAIR      *vp;
	char             unknown_attr[20];
	static char     *thisfunc = "missing_attribute_vend";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", thisfunc));

	if (attr != NULLDA)
	{
		attr_name = attr->name;  /* Mark name. */
	}
	else
	{
		sprintf (unknown_attr, "unknown(%d:%d)", vendor_id, attribute);
		attr_name = unknown_attr;
	}

	/* Get NAS-Identifier or NAS-IP-Address. */
	if ((vp = get_vp (authreq->cur_request, PW_NAS_IDENTIFIER)) == NULL_VP)
	{
		vp = get_vp (authreq->cur_request, PW_NAS_IP_ADDRESS);
	}

	logit (LOG_DAEMON, LOG_ERR,
   "%s:* MISSING %s (%d:%d) in %s (type %d) request %d from %s via. %s[%d] %s",
		func, attr_name, vendor_id, attribute,
		authtype_toa (authreq->code), authreq->code, authreq->rep_id,
		(vp == NULL_VP) ? "?" : avpair_vtoa (vp, 0),
		ip_hostname (authreq->ipaddr), authreq->udp_port,
		(etc == (char *) NULL)  ? "" : etc);

	return;
} /* end of missing_attribute_vend () */

/******************************************************************************
 *
 *	Function: new_string
 *
 *	Purpose: Allocate a new string in memory.
 *
 *	Returns: Pointer to the new string.
 *
 ******************************************************************************/

char *
new_string (str, func)

char       *str;
char       *func;

{
	int              len;
	char            *ptr;
	static char     *thisfunc = "new_string";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", thisfunc));

	len = strlen (str) + 1;
	ptr = get_memory (len, func, func);
	rad_strncpy (ptr, str, len);
	return ptr;
} /* end of new_string () */

/*************************************************************************
 *
 *	Function: packet_log
 *
 *	Purpose: Produce (into a caller supplied buffer) information
 *		 about the packet.  For use by rad_recv(), rad_reply(),
 *		 and similar functions which trace where things go to
 *		 and come from.
 *
 *	Returns: > zero on success,
 *		 < zero on failure.
 *
 *	Remarks: In buf, returns a string formatted as follows:
 *
 *		<how>: id <id> ['<username>'] from <nas> [port <port>]
 *				 [via <srvr>] [<acct-status-type>]
 *
 *************************************************************************/

int
packet_log (buf, authreq, sws)

char           *buf;		/* Caller-supplied buffer to dump into. */
AUTH_REQ       *authreq;	/* Authreq to log to buffer. */
int             sws;		/* Show additional detail. */

{
	int		err_count = 0;
	char           *via = ip_hostname (authreq->ipaddr);
	char           *from = (char *) NULL;
	VALUE_PAIR     *vp;			/* arbitrary a/v pair */
	char            via_buf[AUTH_ID_LEN];
	static char    *func = "packet_log";

	*buf = '\0';		/* Saftey: Start with empty string. */

	/* Save the 'via' string, if we find it. */
	via_buf[0] = '\0';
	if (via != (char *) NULL)
	{
		strcpy (via_buf, via);	/* save the returned name */
		via = via_buf;		/* point to save area */
	}

	vp = get_vp_vend (authreq->request, PW_PROXY_ACTION, VC_MERIT);

	if (vp == NULL_VP)
	{
		/*
		 *	Support the classical "Authentication", etc., but
		 *	use authtype_toa() for the newer stuff.
		 */
		switch (authreq->code)
		{
		    case PW_ACCESS_REQUEST:
			strcpy (buf, "Authentication");
			break;

		    case PW_ACCOUNTING_REQUEST:
			strcpy (buf, "Accounting");
			break;

		    case PW_PASSWORD_REQUEST:
			strcpy (buf, "Passwd");
			break;

#ifdef USR_CCA
		    case PW_RESOURCE_FREE_REQ:
			strcpy (buf, "Resource-Free-Request");
			break;

		    case PW_RESOURCE_FREE_RESP:
			strcpy (buf, "Resource-Free-Response");
			break;

		    case PW_RESOURCE_QUERY_REQ:
			strcpy (buf, "Resource-Query-Request");
			break;

		    case PW_RESOURCE_QUERY_RESP:
			strcpy (buf, "Resource-Query-Response");
			break;

		    case PW_NAS_REB_REQ:
			strcpy (buf, "NAS-Reboot-Free-Request");
			break;

		    case PW_NAS_REB_RESP:
			strcpy (buf, "NAS-Reboot-Free-Response");
			break;
#endif	/* USR_CCA */

#ifdef ASCEND
		    case PW_TERMINATE_SESSION:
			strcpy (buf, "Terminate-Session");
			break;

		    case PW_PASSWORD_EXPIRED:
			strcpy (buf, "Password-Expired");
			break;

		    case PW_ASCEND_EVENT_REQUEST:
			strcpy (buf, "Ascend-Event-Request");
			break;

		    case PW_ASCEND_EVENT_RESPONSE:
			strcpy (buf, "Ascend-Event-Response");
			break;

		    case PW_ASCEND_RADIPA_ALLOCATE:
			strcpy (buf, "Ascend-IP-Allocate");
			break;

		    case PW_ASCEND_RADIPA_RELEASE:
			strcpy (buf, "Ascend-IP-Release");
			break;
#endif	/* ASCEND */

		    default:
			strcpy (buf, authtype_toa (authreq->code));
		}
	}
	else /* Put the proxy action in here. */
	{
		strcpy (buf, vp->strvalue);
	}

	/* Add the reply-id and forwarding-id. */
	buf += strlen (buf);		/* Position to end of string... */
	sprintf (buf, ": %u/%u", authreq->rep_id, authreq->fwd_id);

	/* Show the source UDP port, if requested. */
	if ((sws & PL_REP_PORT) != 0)
	{
		buf += strlen (buf);
		sprintf (buf, " udp %u", authreq->udp_port);
	}

	/* Show the forward or reply digests... */
	if ((sws & (PL_REP_VECTOR | PL_FWD_VECTOR)) != 0)
	{
		strcat (buf, " vector ");
		if ((sws & PL_REP_VECTOR) != 0)
		{
			strcat (buf, auth_vectortoa (authreq->repvec, 0));
		}
		strcat (buf, "/");
		if ((sws & PL_FWD_VECTOR) != 0)
		{
			strcat (buf, auth_vectortoa (authreq->fwdvec, 0));
		}
	}

	/* Put in the User-Name (if any) */
	if ((from = packet_log_validate (authreq, PW_USER_NAME, 0,
					&err_count, 0)) != NULL)
	{
		strcat (buf, " '");
		strcat (buf, from);
		strcat (buf, "'");
	}

	/* Try to determine from the a/v pairs who this claims to be. */
	from = packet_log_validate (authreq, PW_NAS_IDENTIFIER, 0,
					&err_count, 0);
	if (from == (char *) NULL)
	{
		from = packet_log_validate (authreq, PW_NAS_IP_ADDRESS,
						0, &err_count, 0);
	}

	/* Set up from in case nothing matches. */
	if (from == (char *) NULL)
	{
		from = "?";		/* We're really lost here. */
	}

	/* Only show "via..." if Nas-Identifier/NAS-IP-Address != from */
	if (strcasecmp (from, via) != 0)
	{
		strcat (buf, " via ");
		strcat (buf, via);
	}

	/* Always show "from" info */
	strcat (buf, " from ");
	strcat (buf, from);

	if ((from = packet_log_validate (authreq, PW_NAS_PORT, 0,
					&err_count, 0)) != NULL)
	{
		buf += strlen (buf);
		sprintf (buf, " port %s", from);
	}
	
	/* Show Huntgroup-Name too. */
	if ((from = packet_log_validate (authreq, PW_HUNTGROUP_NAME,
					VC_MERIT, &err_count, 0)) != NULL)
	{
		strcat (buf, " <");
		strcat (buf, from);
		strcat (buf, ">");
	}

	if ((from = packet_log_validate (authreq, PW_CLASS, 0, &err_count,
			AVPAIR_VTOA_NULL | AVPAIR_VTOA_DQUOTE)) != NULL)
	{
		strcat (buf, " #");
		strcat (buf, from);
	}

	if ((from = packet_log_validate (authreq, PW_ACCT_SESSION_ID, 0,
		&err_count, AVPAIR_VTOA_NULL | AVPAIR_VTOA_DQUOTE)) != NULL)
	{
		strcat (buf, " $");
		strcat (buf, from);
	}

	if ((vp = get_vp (authreq->request, PW_SERVICE_TYPE)) != NULL_VP)
	{
		strcat (buf, " ");
		switch (vp->lvalue)
		{
		    case PW_CALLBACK_LOGIN:
			strcat (buf, "callback-");
			/***FALLTHROUGH***/

		    case PW_LOGIN:
			strcat (buf, "dumb");
			if ((vp = get_vp (authreq->request,
						PW_LOGIN_IP_HOST)) != NULL_VP)
			{
				if (vp->lvalue != (UINT4) -1)
				{
					strcat (buf, "/");
					strcat (buf, avpair_vtoa (vp, 0));
					if ((vp = get_vp (authreq->request,
						PW_LOGIN_PORT)) != NULL_VP)
					{
						buf += strlen (buf);
						sprintf (buf,
							":%lu", vp->lvalue);
					}
				}
			}
			break;

		    case PW_CALLBACK_FRAMED:
			strcat (buf, "callback-");
			/***FALLTHROUGH***/

		    case PW_FRAMED:
			if ((vp = get_vp (authreq->request,
					PW_FRAMED_PROTOCOL)) != NULL_VP)
			{
				/* If PPP, SLIP, MPP, etc., show IP address */
				strcat (buf, avpair_vtoa (vp, 0));
				if ((vp = get_vp (authreq->request,
					PW_FRAMED_IP_ADDRESS)) != NULL_VP)
				{
					if (vp->lvalue != (UINT4) -1)
					{
						strcat (buf, "/");
						strcat (buf,
							avpair_vtoa (vp, 0));
					}
				}
			}
			else
			{
				strcat (buf, "framed?");
			}
			break;

		    default:
			strcat (buf, avpair_vtoa (vp, 0));
		} /* end of switch */
	} /* end of if */

	/* tail-end stuff... Modem-Start/stop, etc. */
	switch (authreq->code)
	{
	    case PW_ACCOUNTING_REQUEST:
		if ((vp = get_vp (authreq->request,
					PW_ACCT_STATUS_TYPE)) != NULL_VP)
		{
			strcat (buf, " ");
			strcat (buf, avpair_vtoa (vp, 0));
			switch (vp->lvalue)
			{
			    case PW_STATUS_STOP:
			    case PW_STATUS_MODEM_STOP:
				if ((vp = get_vp (authreq->request,
					PW_ACCT_TERMINATE_CAUSE)) != NULL_VP)
				{
					strcat (buf, "/");
					strcat (buf, avpair_vtoa (vp, 0));
				}
				break;
			} /* end of switch */
		}
		else
		{
			strcat (buf, " !NO acct-status-type!");
		}
		break;
	} /* end of switch */

	/* Report retry count for all callers. */
	if (authreq->retry_cnt > 0)
	{
		sprintf (via_buf, " (%u retries)", authreq->retry_cnt);
		strcat (buf, via_buf);
	}

	return 1;
} /* end of packet_log () */

/*************************************************************************
 *
 *	Function: packet_log_validate
 *
 *	Purpose: Used by packet_log to produce displayable information
 *		 about certain things. Depending on the value of
 *		 packet_log_switch, it may compare both the original
 *		 request and the current request to see if they're the
 *		 same.
 *
 *	Returns: pointer to string buffer to use for formatting
 *		 and (possibly) modifies an integer passed by pointer.
 *
 *************************************************************************/

static char *
packet_log_validate (authreq, attr, vend_id, p_err, sws)

AUTH_REQ       *authreq;	/* original and current requests */
int             attr;		/* Attribute to check */
UINT4           vend_id;	/* vendor to check */
int            *p_err;		/* Count the errors we find */
int             sws;		/* avpair_vtoa() switches */

{
	char           *buff;
	VALUE_PAIR     *cur = NULL_VP;
	VALUE_PAIR     *orig = NULL_VP;
	static char     abuffers[MAX_AVPAIR_VTOA][(AUTH_STRING2_LEN + 1)*2];
	static int      andx = 0;
	static char    *func = "packet_log_validate";

	if (authreq == (AUTH_REQ *) NULL)
	{
		logit (LOG_DAEMON, LOG_CRIT, "%s: No authreq!", func);
		return (NULL);
	}

	/* Get (or not) */
	if ((packet_log_switch & PL_SWS_ORIG) != 0)
	{
		orig = get_vp_vend (authreq->request, attr, vend_id);
	}

	if (((packet_log_switch & PL_SWS_CUR) != 0) || (orig == NULL_VP))
	{
		cur = get_vp_vend (authreq->cur_request, attr, vend_id);
	}

	/* Compare both? */
	if (((packet_log_switch & PL_SWS_COMP) != 0) &&
		(orig != NULL_VP) &&
		(cur != NULL_VP))
	{
		if (avpair_comp (orig, cur) == 0)
		{
			return avpair_vtoa (orig, sws);
		}

		/*
		 * They're different... what do we do?
		 */
		if ((packet_log_switch & PL_SWS_ABORT) != 0)
		{
			logit (LOG_DAEMON, LOG_CRIT,
			       "%s: FATAL! original %s != current; %s != %s",
			       func, cur->ap->name, avpair_vtoa (orig, sws),
			       avpair_vtoa (cur, sws));
			dumpcore = 1;	/* Force a core-dump */
			abort ();
		}

		if (p_err != (int *) NULL)
		{
			(*p_err)++;
		}
		
		buff = abuffers[andx];
		andx++;
		if (andx >= MAX_AVPAIR_VTOA)
		{
			andx = 0;
		}

		sprintf (buff, "%s!=%s", avpair_vtoa (orig, sws),
			avpair_vtoa (cur, sws));
		return (buff);

	}
	else
	{
		if (orig != NULL_VP)
		{
			return avpair_vtoa (orig, sws);
		}
		else
		{
			if (cur != NULL_VP)
			{
				return avpair_vtoa (cur, sws);
			}
		}
	}

	return (NULL);	/* Nothing to show for this. */
} /* end of packet_log_validate () */

/*************************************************************************
 *
 *	Function: parse_realm
 *
 *	Purpose: Split user entered string found in PW_USER_NAME into
 *		 the PW_USER_ID and PW_USER_REALM a/v pairs and hang
 *		 them both on both the authreq->cur_request and the
 *		 authreq->cur_request lists for later use.
 *
 *	Returns: pointer to the realm a/v pair,
 *		 NULL otherwise.
 *
 *************************************************************************/

VALUE_PAIR *
parse_realm (authreq)

AUTH_REQ       *authreq;

{
	static char    *func = "parse_realm";

	dprintf(2, (LOG_AUTH, LOG_DEBUG, "%s: entered", func));

	return parse_realm2 (&authreq->cur_request,
				&authreq->cur_count, authreq->client);
} /* end of parse_realm () */

/*************************************************************************
 *
 *	Function: parse_realm2
 *
 *	Purpose: Split user entered string found in PW_USER_NAME
 *		 into the PW_USER_ID and PW_USER_REALM a/v pairs
 *		 and hang them both onto the authreq->request and
 *		 the authreq->cur_request lists for later use.
 *
 *	Returns: pointer to the realm a/v pair,
 *		 NULL otherwise.
 *
 *************************************************************************/

VALUE_PAIR *
parse_realm2 (p_cur_request, p_cur_count, client)

VALUE_PAIR    **p_cur_request;
int            *p_cur_count;
CLIENT_ENTRY   *client;

{
	int             type;
	int             count;
	int             cur_count;
	UINT4           ipaddr;
	VALUE_PAIR     *vp;
	VALUE_PAIR    **vp_prev;
	char           *agent;
	char           *filter;
	char           *pos;
	char           *realm;
	char           *u_realm;
	char           *userid;
	char            name[AUTH_ID_LEN + 1];
	static char    *func = "parse_realm2";

	dprintf(2, (LOG_AUTH, LOG_DEBUG, "%s: entered", func));

	/*
	 *	Provide a fake cur_count, as necessary.
	 */
	if (p_cur_count == (int *) NULL)
	{
		cur_count = 0;
		p_cur_count = &cur_count;
		for (vp = *p_cur_request, cur_count = 0;
			vp != NULL_VP;
			vp = vp->next)
		{
			cur_count++;
		}
	}

	if (client == (CLIENT_ENTRY *) NULL)
	{
		find_client_by_name (RADIUS_LOCALSERVER, &ipaddr, &client);
	}

	vp = get_vp_vend (*p_cur_request, PW_USER_REALM, VC_MERIT);

	if (vp != NULL_VP)
	{
		return vp; /* It's already there, so just return it! */
	}

	vp = get_vp_vend (*p_cur_request, PW_USER_ID, VC_MERIT);

	if (vp == NULL_VP)
	{
		return vp; /* The PW_USER_ID must be there to parse! */
	}

	/* Make a local copy of the name. */
	strncpy (name, vp->strvalue, AUTH_ID_LEN);
	name[AUTH_ID_LEN] = '\0'; /* Guarantee a null terminated string. */

	/*
	 *	Parse the User-Name as follows:
	 *
	 *	1) <realm> "/" <accessid>
	 *
	 *	or
	 *
	 *	2) <accessid> "@" <realm>
	 */

	/* Was it the <realm> '/' <accessid> style? */
	if ((pos = (char *) strchr (name, '/')) != (char *) NULL)
	{
		if ((u_realm = (char *) strtok (name, "/")) == (char *) NULL)
		{
			u_realm = "";
		}

		if ((userid = (char *) strtok (NULL, "")) == (char *) NULL)
		{
			return NULL_VP;	/* Name was null. */
		}
	}
	else /* There was no '/' in the User-Id. */
	{
		if ((pos = (char *) strchr (name, '@')) != (char *) NULL)
		{
			/* Was '@' style. */
			if ((userid =
				(char *) strtok (name, "@")) == (char *) NULL)
			{
				return NULL_VP; /* Can't use a null name. */
			}

			if ((u_realm =
				(char *) strtok (NULL, "")) == (char *) NULL)
			{
				u_realm = "";
			}
		}
		else /* There was neither '@' nor '/' in the User-Id. */
		{
			userid = name;
			u_realm = "";
		}
	}

	/* Check for null user id. */
	if ((userid == (char *) NULL) || (*userid == '\0'))
	{
		return NULL_VP; /* Name was null. */
	}

	avpair_string_mod (vp, userid, -1);

	/* Next, build the realm a/v pair. */
	if (u_realm != (char *) NULL)
	{
		if (find_auth_type (u_realm, PW_PROTTYPE_DFLT,
					(char *) client->file_pfx, &type,
					&agent, &realm, &filter) == 0)
		{
			u_realm = realm;	
		}
	}

	/*
	 *	Now stick it at end of original request items on the
	 *	cur_request list so that it can be included in cur_count.
	 */
	vp = avpair_add_vend ((VALUE_PAIR **) NULL, PW_USER_REALM,
				u_realm, -1, VC_MERIT);
	if (vp == NULL_VP)
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s: Unable to add USER-REALM for '%s'", func, u_realm);
	}
	else
	{
		count = *p_cur_count;
		vp_prev = p_cur_request;

		/* Run to end of list of cur_count items only */
		while (count-- > 0 && *vp_prev != NULL_VP)
		{
			vp_prev = &(*vp_prev)->next;
		}

		if (count > 0)  /* then something is wrong here... */
		{
			logit (LOG_DAEMON, LOG_ERR, "%s: cur_count is bad!",
				func);
			dumpcore = 1;
			abort ();
		}

		vp->next = *vp_prev;
		*vp_prev = vp;		

		/* Indicate and record the additional a/v pair. */
		if (p_cur_count != (int *) NULL)
		{
			*p_cur_count++;
		}

		dprintf(2, (LOG_AUTH, LOG_DEBUG,
			"%s: name = '%s', realm = '%s'",
			func, userid, vp->strvalue));
	}

	return vp;
} /* end of parse_realm2 () */

#ifndef	MAX_VP_CNT
#define	MAX_VP_CNT      100 /* max. number of reply vp's with limits on them */
#endif	/* MAX_VP_CNT */

/*************************************************************************
 *
 *	Function: prune_pairs    XXX: turn this into an AATV later
 *
 *	Purpose: Remove all extraneous a/v pairs before replying to the NAS.
 *		 Remove all Reply-If-Ack-Message attributes, if the result
 *		 is Access-Reject.  Finally, change any remaining
 *		 Reply-If-Ack-Message attributes to Reply-Message attributes.
 *		 Repack all Reply-Message attributes into as few as possible.
 *
 *	Returns: 0 == normal return,
 *		-1 == some error occurred.
 *
 *	Remark: This code does not handle the long strings of Version 2.
 *
 *	Remark: This code may change the order of the a/v pairs returned.
 *
 *************************************************************************/

int
prune_pairs (authreq, result)

AUTH_REQ       *authreq;	/* modify this request's cur_request list */
int             result;		/* the packet type Access-Accept or -Reject */

{
	int             i;
	int             putlen;
	int             remlen;
	char           *pos;
	VALUE_PAIR     *new = NULL_VP;
	VALUE_PAIR     *old;
	VALUE_PAIR     *next;
	VALUE_PAIR     *vp;
	VALUE_PAIR    **prev_ptr;
	VALUE_PAIR    **eol = &new;
	VENDOR_LIST    *each_veps;
	struct
	{
		int		attr;
		short		vend_spec;
		short		cnt;
	}               attr_count[MAX_VP_CNT];	/* Array of counting elements */
	char            buf[AUTH_STRING1_LEN + 1];
	static char    *func = "prune_pairs";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	switch (result)
	{
	    case EV_ACK:
	    case EV_NAK:
		break;

	    case EV_ACC_CHAL: /* Not handled according to RADIUS RFC */
		dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: ACC_CHAL not handled",
			func));
		return 0;
		break;

	    default:
		dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: result=%d in error",
			func, result));
		return (-1);
		break;
	}

	if (result == EV_ACK && authreq->code == PW_ACCOUNTING_REQUEST) /* no */
	{
		/* A standard accounting response doesn't have any a/v pairs. */
		list_free (authreq->cur_request);
		authreq->cur_request = NULL_VP;
		dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: Accounting trims all!",
			func));
		return 0;
	}

	/* Don't send back original request items ...
	while (--authreq->cur_count >= 0)
	{
		vp = authreq->cur_request;
		authreq->cur_request = vp->next;
		avpair_free (vp);
	}
	* ... except that we can't do this yet because remote server may
        * have pruned.  They probably should not prune if Proxy-State
        * is present in the request.
	*/

	/* Make first pass through list looking for limited attributes. */
	attr_count[0].attr = 0;
	prev_ptr = &authreq->cur_request;
	while ((vp = *prev_ptr) != NULL_VP)
	{
		/* Toss config items... */
		if (vp->ap->flags & ATTR_CONFIG)
		{
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: toss config %s=%s",
				func, vp->ap->name, avpair_vtoa (vp, 0)));
			*prev_ptr = vp->next;
			vp->next = NULL_VP;
			avpair_free (vp);
			continue;
		}

		/* Toss vendor-specific attribute if not for this NAS vendor */
		if (vp->ap->vendor_id != 0)
		{
			for (each_veps = authreq->client->veps;
				(each_veps != (VENDOR_LIST *) NULL) &&
								(vp != NULL_VP);
				each_veps = each_veps->next)
			{
				if (each_veps->vep->id == vp->ap->vendor_id)
				{
					break;
				}
			}

			if (each_veps == (VENDOR_LIST *) NULL)
			{
				*prev_ptr = vp->next;
				dprintf(2, (LOG_DAEMON, LOG_DEBUG,
					"%s: toss vendor %s attr %s=%s",
					func, vp->ap->vendor_ptr->name,
					vp->ap->name, avpair_vtoa (vp, 0)));
				vp->next = NULL_VP;
				avpair_free (vp);
				vp = NULL_VP;
			}
		}

		if (vp == NULL_VP)
		{
			continue;
		}

		/* Check for attribute limit. */
		if (result == EV_ACK)  /* Access-Accept */
		{
			if (vp->ap->flags & ATTR_ACK_NONE)
			{
				/* None allowed */
				*prev_ptr = vp->next;
				dprintf(2, (LOG_DAEMON, LOG_DEBUG,
					"%s: ACK none, %s=%s", func,
					vp->ap->name, avpair_vtoa (vp, 0)));
				avpair_free (vp);
				continue;
			}
			if ((vp->ap->flags & ATTR_ACK_ONE) == 0)
			{
				/* Infinite allowed */
				dprintf(2, (LOG_DAEMON, LOG_DEBUG,
					"%s: ACK all, %s=%s",
					func, vp->ap->name,
					avpair_vtoa (vp, 0)));
				prev_ptr = &vp->next;
				continue;
			}
		}
		else  /* Access-Reject */
		{
			if ((vp->ap->flags & ATTR_NAK_NONE) ||
				(vp->ap->value == PW_REPLY_IF_ACK_MESSAGE))
			{
				/* None allowed */
				*prev_ptr = vp->next;
				dprintf(2, (LOG_DAEMON, LOG_DEBUG,
					"%s: NAK none %s=%s", func,
					vp->ap->name, avpair_vtoa (vp, 0)));
				avpair_free (vp);
				continue;
			}

			if ((vp->ap->flags & ATTR_NAK_ONE) == 0)
			{
				/* Infinite allowed */
				dprintf(2, (LOG_DAEMON, LOG_DEBUG,
					"%s: NAK all, %s=%s", func,
					vp->ap->name, avpair_vtoa (vp, 0)));
				prev_ptr = &vp->next;
				continue;
			}
		}

		/* It is a limited reply-item, so count it */
		for (i = 0; attr_count[i].attr != 0; i++)
		{
			if (attr_count[i].attr == vp->attribute)
			{
				if (vp->ap->vendor_id == 0)
				{
					if (!attr_count[i].vend_spec)
					{
						break;
					}
				}
				else
				{
					if (attr_count[i].vend_spec)
					{
						break;
					}
				}
			}
		}

		if (attr_count[i].attr == 0)
		{
			if (i == MAX_VP_CNT - 1)
			{
				logit (LOG_DAEMON, LOG_ERR,
					"%s: Need to increase MAX_VP_CNT",
					func);
				abort ();
			}
			attr_count[i].attr = vp->attribute;
			attr_count[i].vend_spec = (vp->ap->vendor_id != 0);
			attr_count[i].cnt = 1;
			attr_count[i + 1].attr = 0;
		}
		else
		{
			attr_count[i].cnt++;
		}

		/* Overwrite attribute with attr_cnt index for later */
		vp->attribute = i;
		prev_ptr = &vp->next;
	} /* end of while */

	/* Prune multiple limited attributes from the list. */

	prev_ptr = &authreq->cur_request;
	while ((vp = *prev_ptr) != NULL_VP)
	{
		if (result == EV_ACK) /* Access-Accept */
		{
			if ((vp->ap->flags & ATTR_ACK_ONE) == 0)
			{
				prev_ptr = &vp->next;
				continue;
			}
		}
		else /* Access-Reject */
		{
			if ((vp->ap->flags & ATTR_NAK_ONE) == 0)
			{
				prev_ptr = &vp->next;
				continue;
			}
		}

		/* Only one of these allowed.  Find the last one. */
		if (--attr_count[vp->attribute].cnt != 0)
		{
			*prev_ptr = vp->next;
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: ACK/NAK one %s=%s",
				func, vp->ap->name, avpair_vtoa (vp, 0)));
			avpair_free (vp);
			continue;
		}

		/* Restore overwritten attribute */
		vp->attribute = vp->ap->value;
		prev_ptr = &vp->next;
	} /* end of while */

	/*
	 *	Change Reply-If-Ack-Message attributes to Reply-Message
	 *	attributes and stuff as many messages into as few
	 *	Reply-Message attributes as possible, unless the request
	 *	was of the PW_STATUS_SERVER type.
	 */
	if (authreq->code != PW_STATUS_SERVER)
	{
		buf[0] = '\0';
		pos = buf;
		remlen = AUTH_STRING1_LEN;

		for (old = authreq->cur_request; old != NULL_VP; old = next)
		{
			next = old->next;

			if ((old->ap->value == PW_REPLY_MESSAGE) ||
				(old->ap->value == PW_REPLY_IF_ACK_MESSAGE))
			{
				putlen = MIN(remlen, old->lvalue);
				strncat (pos, old->strvalue, putlen);

				i = 0;
				if (putlen == remlen)
				{
					i =  old->lvalue - putlen;
				}

				pos += putlen;
				remlen -= putlen;

				/*
				 *	Create a new Reply-Message attribute and
				 *	place it at the end of the "new" list.
				 */
				if (remlen <= 0)
				{
					pos[0] = '\0';
					avpair_add (eol, PW_REPLY_MESSAGE,
								buf, -1);
					/* bump to end of list */
					eol = &((*eol)->next);

					buf[0] = '\0';
					pos = buf;
					remlen = AUTH_STRING1_LEN;
					if (i > 0)
					{
						strncat (pos,
						     old->strvalue + putlen, i);
						pos += i;
						remlen -= i;
					}
				}
				avpair_free (old);
			}
			else /* just relink the value pair to the new list */
			{
				*eol = old;
				eol = &old->next;
			}

			*eol = NULL_VP;
		}

		if (pos != buf) /* There was remaining data in the buffer. */
		{
			avpair_add (eol, PW_REPLY_MESSAGE, buf, -1);
			eol = &((*eol)->next); /* bump to end of list */
		}

		authreq->cur_request = new;
	}

	return 0;
} /* end of prune_pairs () */

/******************************************************************************
 *
 *	Function: rad_fork
 *
 *	Purpose: Call the kernel fork() function, flush logfiles, etc.
 *
 *	Returns: System fork() results.
 *
 *****************************************************************************/

int

#if __STDC__ == 1
rad_fork (char *format, ...)
#else
rad_fork (va_alist) va_dcl
#endif

{
	va_list            pvar;
	int                result;	/* fork() result. */
	static char       *func = "rad_fork";

#if __STDC__ ==1
	va_start (pvar, format);
#else
	char            *format;

	va_start (pvar);
	format = va_arg (pvar, char *);
#endif

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/* Insure that any pending output gets flushed out. */
	if (msgfd != (FILE *) NULL)
	{
		fflush (msgfd);
	}

	/* Make sure the debugging stream gets flushed, too. */
	if ((debug_flag > 0) && (ddt != (FILE *) NULL))
	{
		fflush (ddt);
	}

	/* Do the fork(), and then set up the child. */
	if ((result = fork ()) == 0)
	{
		dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: Child running", func));
		radius_child = 1;
		if (format != (char *) NULL)
		{
			rad_vptitle (format, pvar);
		}
	}
	else
	{
		dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: child started, %d",
			func, result));
	}
	return result;
} /* end of rad_fork () */

/******************************************************************************
 *
 *	Function: rad_ptitle
 *
 *	Purpose: Set the process argv[] information, only if it is
 *		 possible and we are a child.  Accepts variable arg list.
 *
 *	Returns: 0 == not a child
 *		 1 == title set
 *		-1 == something bad happened.
 *
 *****************************************************************************/

int

#if __STDC__ == 1
rad_ptitle (char *format, ...)
#else
rad_ptitle (va_alist) va_dcl
#endif

{
	va_list           pvar;
	static char      *func = "rad_ptitle";

#if __STDC__ ==1
	va_start (pvar, format);
#else
	char             *format;

	va_start (pvar);
	format = va_arg (pvar, char *);
#endif

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	return (rad_vptitle (format, pvar));
} /* end of rad_ptitle () */

/******************************************************************************
 *
 *	Function: rad_sleep
 *
 *	Purpose: Call the C library's sleep() function, flush logfiles, etc.
 *
 *	Returns: System sleep() results.
 *
 *****************************************************************************/

int

#if __STDC__ == 1
rad_sleep (u_int t, char *format, ...)
#else
rad_sleep (va_alist) va_dcl
#endif

{
	va_list            pvar;
	static char       *func = "rad_sleep";

#if __STDC__ ==1
	va_start (pvar, format);
#else
	u_int              t;
	char              *format;

	va_start (pvar);
	t = va_arg (pvar, u_int);
	format = va_arg (pvar, char *);
#endif

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered (%u)", func, t));

	/* Insure that any pending output gets flushed out. */
	if (msgfd != (FILE *) NULL)
	{
		fflush (msgfd);
	}

	/* Make sure that the debugging stream gets flushed, too. */
	if ((debug_flag > 0) && (ddt != (FILE *) NULL))
	{
		fflush (ddt);
	}

	/* Set the title... */
	rad_vptitle (format, pvar);

	return sleep (t);
} /* end of rad_sleep () */

/*************************************************************************
 *
 *	Function: _rad_strdup
 *
 *	Purpose: Copy a string into a newly allocated piece of memory.
 *		 Log and call abort(), if no memory available.
 *
 *	Returns: pointer to a new string.
 *
 *************************************************************************/

char *
_rad_strdup (whatfunc, src)

char           *whatfunc;	/* calling function name */
char           *src;		/* source string */

{
	int              len;
	char            *new = NULL;
	static char     *func = "_rad_strdup";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (src)
	{
		len = strlen (src) + 1;
		if ((new = (char *) calloc (1, len)) == (char *) NULL)
		{
			logit (LOG_DAEMON, LOG_ALERT,
		       "%s: FATAL rad_strdup('%s') calloc() failed, errno = %d",
				whatfunc, src, errno);
			abort ();
		}
		strcpy (new,src);
	}
	else
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s: rad_strdup((null))!!!", whatfunc);
	}

	return new;
} /* end of _rad_strdup () */

/*******************************************************************************
 *
 *	Function: rad_strncpy
 *
 *	Purpose: Copy at most a given number of bytes from one string value to
 *		 another, and guarantee the new string is null terminated.
 *
 *	Returns: A pointer to the new string.
 *
 ******************************************************************************/

char *
rad_strncpy (dststr, srcstr, n)

char       *dststr;		/* new string */
char       *srcstr;		/* source string */
int         n;			/* size of the new string */

{
	static char     *func = "rad_strncpy";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (srcstr != (char *) NULL)
	{
		strncpy (dststr, srcstr, n);
		dststr[n - 1] = 0;
	}
	else
	{
		*dststr = 0;
	}
	return dststr;
} /* end of rad_strncpy () */

#define	RAD_TIMES	20	/* How many buffers to cycle through? */
#define	RAD_TIMES_SIZE	20

/******************************************************************************
 *
 *	Function: rad_time
 *
 *	Purpose: Convert a time_t to a string <(YY)YYMMDD>.<HHMMSS>
 *
 *	Returns: <(YY)YYMMDD>.<HHMMSS>,
 *		 or "?", if t is zero.
 *
 *****************************************************************************/

char *
rad_time (t, sws)

time_t           t;	/* Drop it in. */
int              sws;	/* 0x00 == localtime, 0x01 == gmtime */

{
	struct tm         *tm;		/* Convert current time to this. */
	static int         pos = 0;
	static char        buffers[RAD_TIMES_SIZE][RAD_TIMES];
	char              *str = buffers[pos];
	static char       *func = "rad_time";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (t == 0)
	{
		return "?";
	}

	if ((sws & 0x01) == 0x01)
	{
		tm = gmtime (&t);
	}
	else
	{
		tm = localtime (&t);
	}

#ifdef Y2K
	strftime (str, RAD_TIMES_SIZE, "%Y%m%d.%H%M%S", tm);
#else	/* Y2K */
	strftime (str, RAD_TIMES_SIZE, "%y%m%d.%H%M%S", tm);
#endif	/* Y2K */

	if (++pos >= RAD_TIMES)
	{
		pos = 0;
	}

	return str;
} /* end of rad_time () */

/******************************************************************************
 *
 *	Function: rad_vptitle
 *
 *	Purpose: Set the process argv[] information, only if it is
 *		 possible and we are a child.
 *
 *	Returns: 0 == not a child
 *		 1 == title set
 *		-1 == something bad happened.
 *
 *****************************************************************************/

int
rad_vptitle (format, pvar)

char             *format;
va_list           pvar;

{
	int               i;
	int               len;
	char              buffer[1024];
	static int        maxlen = 0;		/* Uninitilized */
	static char      *start = (char *) NULL;
	static char      *end = (char *) NULL;
	static char      *func = "rad_vptitle";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((radius_argv == (char **) NULL) || (format == (char *) NULL))
	{
		return (-1);
	}

	if (radius_child == 0)
	{
		return (0);
	}

	/* Prepare the text. */

#if defined(HAVE_VSNPRINTF)
	vsnprintf (buffer, MAXPATHLEN, format, pvar);
#else	/* HAVE_VSNPRINTF */
	vsprintf (buffer, format, pvar);
#endif	/* HAVE_VSNPRINTF */

	len = strlen (buffer);

	if (maxlen == 0)
	{
		/* Figure out how much space we have. */
		start = radius_argv[0];
		end = radius_argv[radius_argc - 1] +
					strlen (radius_argv[radius_argc - 1]);

		/*
		 *	This block will only get used if radius_envp is
		 *	initialized non-NULL elsewhere.  This assumes a
		 *	special layout of the environment: the "beginning"
		 *	of the "environment" is at the "end" of the arguments
		 *	and that the hunk of memory from argv[0] through the
		 *	environment is contiguous and contains only those
		 *	two entities (arguments and environment).
		 */
		if (radius_envp != (char **) NULL)
		{
			for (i = 0; radius_envp[i] != (char *) NULL; i++)
			{
				; /* find end of envp */
			}

			if (i > 0)
			{
				/* Save environment, if we can */
				if ((environ =
					(char **) calloc (i + 1,
							  sizeof (char *)))
							      != (char **) NULL)
				{
					for (i = 0;
						radius_envp[i] != (char *) NULL;
						i++)
					{
						environ[i] =
						    rad_strdup (radius_envp[i]);
					}
					environ[i] = (char *) NULL;

					end = radius_envp[i-1] +
						strlen (radius_envp[i-1]);
				}
			}
		}

		maxlen = end - start;
	}

	memset (start, ' ', maxlen);	/* Clear old space. */
	len = MIN(maxlen, len);		/* Find space to fit. */
	if (len > 0)
	{
		strncpy (radius_argv[0], buffer, len + 1);
	}
	return (1);
} /* end of rad_vptitle () */

/******************************************************************************
 *
 *	Function: radius_dbfile
 *
 *	Purpose: Generate a RADIUS database file name with path.
 *
 *	Returns: Constructed pathname.
 *
 *	Remarks: "radius_dir" is used as the directory name.
 *
 *****************************************************************************/

char *
radius_dbfile (buf, name)

char            *buf;	/* must be large enough to hold the resultant path */
char            *name;	/* RADIUS database file base file name */

{
	if (*name == '/')
	{
		strcpy (buf, name);
	}
	else
	{
		sprintf (buf, "%s/%s", radius_dir, name);
	}

	return buf;
} /* end of radius_dbfile () */

/*************************************************************************
 *
 *	Function: _reply_message
 *
 *	Purpose: Generate a reply message and stick it into the list
 *		 of reply items to send back to the client.
 *
 *	Returns: 0 == normal return
 *		-1 == msgno is out of range
 *
 *	Remarks: The message is also logged.
 *
 *************************************************************************/

int
_reply_message (authreq, msgno, func, filename, line)

AUTH_REQ       *authreq;	/* this authentication request */
ERRORCODE       msgno;		/* message number */
char           *func;		/* calling function name */
char           *filename;	/* Filename were error occured. */
int             line;		/* Line number where error occured. */

{
	static char    *msg[] =
	{
		"Internal error",
		"Configuration error",
		"Out of memory",
		"Error creating file",
		"No token available",
		"No ports available for guests",
		"Too many simultaneous sessions",
		"ABS failure",
		"Error querying balance",
		"Your account balance is too low"
	};

	if ((u_int)(--msgno) < numbof(msg))
	{
		logit (LOG_AUTH, LOG_INFO, "%s: %s at %s line %d", func,
			msg[msgno], filename, line);
		reply_sprintf (0, authreq, "%s [%s()]",
				msg[msgno], func);
		return 0;
	}
	reply_sprintf (0, authreq, "Software error [%s()]", func);
	logit (LOG_AUTH, LOG_ERR, "%s: message %d out of range at %s line %d",
		func, msgno, filename, line);
	return (-1);
} /* end of _reply_message () */

/*************************************************************************
 *
 *	Function: reply_sprintf
 *
 *	Purpose: Generate either one or more Reply-Message or
 *		 Reply_If_Ack_Message attributes to add to the
 *		 list of reply items to send back to the requestor.
 *
 *	Remarks: Normally adds CR/LF sequence unless RS_NO_CRLF specified.
 *
 *	Returns: 0 == normal return
 *		-1 == authreq is bad somehow.
 *
 *************************************************************************/

int

#if __STDC__ == 1
reply_sprintf (int logsw, AUTH_REQ *authreq, char *format, ...)
#else
reply_sprintf (va_alist) va_dcl
#endif

{
	va_list         pvar;	/* Miscellaneous arguments... */
	int             attr;
	int             remlen;
	int             vendorid;
	char           *pos;
	char            buf[MAXPATHLEN];

#if __STDC__ == 1
	va_start (pvar, format);
#else	/* __STDC__ == 1 */
	int             logsw;	/* bit 1 == log this message */
				/* bit 2 == omit CR/LF on this message */
				/* bit 4 == do Reply-If-Ack-Message attribute */
	AUTH_REQ       *authreq;
	char           *format;

	va_start (pvar);
	logsw = va_arg (pvar, int);
	authreq	= va_arg (pvar, AUTH_REQ *);
	format = va_arg (pvar, char *);
#endif	/* __STDC__ == 1 */

	/* Format message, add it to reply, log it if necessary. */

#if defined(HAVE_VSNPRINTF)
	/* Use MAXPATHLEN - 2 to leave space for CR/LF */
	vsnprintf (buf, MAXPATHLEN - 2, format, pvar);
#else	/* HAVE_VSNPRINTF */
	vsprintf (buf, format, pvar);
#endif	/* HAVE_VSNPRINTF */

	if (logsw & RS_LOG)
	{
	      logit (LOG_AUTH, LOG_INFO, "%s", buf);
	}

	pos = buf;

	if (logsw & ~RS_NO_CRLF) /* skips default behaviour */
	{
		strcat (buf, "\r\n");     /* Force newline. */
	}

	if ((remlen = strlen (pos)) == 0)
	{
		return 0;
	}

	attr = PW_REPLY_MESSAGE; /* Assume normal Reply-Message attribute. */
	vendorid = 0;		 /* Standard vendor code. */

	if (logsw & RS_IF_ACK)
	{
		attr = PW_REPLY_IF_ACK_MESSAGE;
		vendorid = VC_MERIT;
	}

	/* Use more attributes to hold the message, as necessary. */
	while (remlen >= 0)
	{
		(void) avpair_add_vend (&authreq->cur_request, attr, pos,
					(remlen <= AUTH_STRING1_LEN)
						? remlen : AUTH_STRING1_LEN,
					vendorid);
		remlen -= AUTH_STRING1_LEN;
		pos += AUTH_STRING1_LEN;
	}

	return 0;
} /* end of reply_sprintf () */

/*******************************************************************************
 *
 *	Function: reset_attr_flag
 *
 *	Purpose: Clear the flags indicated by "flags" in the given attribute.
 *
 *	Returns: -1, if missing attribute,
 *		  0, if no flags changed,
 *		  1, if flags changed.
 *
 ******************************************************************************/

int
reset_attr_flag (attr, flags)

DICT_ATTR      *attr;
int             flags;

{
	int             old;
	static char    *func = "reset_attr_flag";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (attr == NULLDA)
	{
		return (-1);
	}

	if (flags & ATTR_RO_FLAGS != 0)
	{
		logit (LOG_DAEMON, LOG_ERR,
	    "%s: Attempt to modify read-only attribute flags 0x%x (0x%x) in %s",
			func, flags & ATTR_RO_FLAGS, flags, attr->name);
		flags &= ~ATTR_RO_FLAGS;
	}

	/* Warning check */
	if (flags == 0)
	{
		logit (LOG_DAEMON, LOG_INFO,
			"%s: Attempt to set NO flags for in %s",
			func, attr->name);
		return 0;
	}

	old = attr->flags;	/* Save old flags. */
	attr->flags &= ~flags;	/* Set flags marked. */

	if (attr->flags != old)
	{
		return 1;	/* Flags changed, indicate so. */
	}

	return 0;		/* No flags changed. */
} /* end of reset_attr_flag () */

/*******************************************************************************
 *
 *	Function: reset_stderr
 *
 *	Purpose: Reset stderr
 *
 ******************************************************************************/

int
reset_stderr (path, recurse)

char       *path;
int         recurse;

{
	int              fd;
	FILE            *fp;
	static char     *func = "reset_stderr";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((fp = freopen (path, "w+", stderr)) == (FILE *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s: Unable to freopen(\"%s\", \"w+\", stderr), %s",
			func, path, get_errmsg ());

		if ((recurse != 0) && (strcmp (path, "/dev/console") != 0))
		{
			return reset_stderr ("/dev/console", 0);
		}

		fp = freopen ("/dev/null", "w+", stderr);

		if (fp == (FILE *) NULL)
		{
			fd = open ("/dev/null", O_WRONLY, 0);
			if (fd >= 0)
			{
				fp = fdopen (fd, "w+");
			}
		}
	}

	/* Disaster... */
	if (fp == (FILE *) NULL)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: Unable to freopen(...,stderr) AT ALL!", func);
		return 1;
	}

	/* Insure that it's stderr. */
	if (fileno(fp) != STDERR_FILENO)
	{

#if !defined(M_UNIX)
		/*
		 * Try REALLY hard to put something
		 * on file descriptor 2 (STDERR_FILENO)
		 */
		if (dup2 (fileno(fp), STDERR_FILENO) < 0)
		{
			logit (LOG_DAEMON, LOG_ERR,
		 "%s: Unable to force fileno(stderr)=%d on %d (STDERR_FILENO)",
				func, fileno(stderr), STDERR_FILENO);
			return 1;
		}

/*The following two lines do not compile on Solaris or Linux or BSDI. */
#if !(defined(sys5) || defined(linux) || defined (BSDI))
		close (fileno(fp));
		fileno(fp) = STDERR_FILENO;
#endif	/* sys5 */

		return 0;
#else /* M_UNIX */
		logit (LOG_DAEMON, LOG_ERR,
	       "%s: Unable to freopen(...,stderr) properly, fileno(stderr)=%d",
			func, fileno(stderr));
		return 1;
#endif	/* M_UNIX */

	}

	return 0;	/* Success. */
} /* end of reset_stderr () */

/*******************************************************************************
 *
 *	Function: reset_vp_attr_flags_list
 *
 *	Purpose: Clear the flags indicated by "flags" in all the
 *		 attributes in the given a/v pair list.
 *
 *	Returns: -1, if no list,
 *		  0, if no flags changed,
 *		 +n, indicates how many a/v pairs changed.
 *
 ******************************************************************************/

int
reset_vp_attr_flags_list (list, flags)

VALUE_PAIR     *list;
int             flags;

{
	int             count = 0;
	static char    *func = "reset_vp_attr_flags_list";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (list == NULL_VP)
	{
		return (-1);
	}

	if (flags & ATTR_RO_FLAGS != 0)
	{
		logit (LOG_DAEMON, LOG_ERR,
		  "%s: Attempt to modify read-only attribute flags 0x%x (0x%x)",
			func, flags & ATTR_RO_FLAGS, flags);
		flags &= ~ATTR_RO_FLAGS;
	}

	/* Warning check */
	if (flags == 0)
	{
		logit (LOG_DAEMON, LOG_INFO,
			"%s: Attempt to clear NO flags", func);
		return 0;
	}

	for ( ; list != NULL_VP; list = list->next)
	{
		if (reset_attr_flag (list->ap, flags) != 0)
		{
			count++;
		}
	}

	return count;
} /* end of reset_vp_attr_flags_list () */

/*******************************************************************************
 *
 *	Function: reset_vp_flag
 *
 *	Purpose: Clear the flags indicated by "flags" in the given a/v pair.
 *
 *	Returns: -1, if no a/v pair,
 *		  0, if no flags changed,
 *		  1, if flags changed.
 *
 ******************************************************************************/

int
reset_vp_flag (vp, flags)

VALUE_PAIR     *vp;
int             flags;

{
	int             old;
	static char    *func = "reset_vp_flag";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (vp == NULL_VP)
	{
		return (-1);
	}

	old = vp->flags;	/* Save old flags. */
	vp->flags &= ~flags;	/* Clear flags marked. */

	if (vp->flags != old)
	{
		return 1;	/* Flags changed, indicate so. */
	}

	return 0;		/* No flags changed. */
} /* end of reset_vp_flag () */

/*******************************************************************************
 *
 *	Function: reset_vp_flags_list
 *
 *	Purpose: Clear the flags indicated by "flags" in the
 *		 given a/v pair list.
 *
 *	Returns: -1, if no list,
 *		  0, if no flags changed,
 *		 +n, indicates how many a/v pairs changed.
 *
 ******************************************************************************/

int
reset_vp_flags_list (list, flags)

VALUE_PAIR     *list;
int             flags;

{
	int             count = 0;
	static char    *func = "reset_vp_flags_list";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (list == NULL_VP)
	{
		return (-1);
	}

	for ( ; list != NULL_VP; list = list->next)
	{
		if (reset_vp_flag (list, flags) != 0)
		{
			count++;
		}
	}

	return count;
} /* end of reset_vp_flags_list () */

/*******************************************************************************
 *
 *	Function: safe_free
 *
 *	Purpose: Check if a pointer is NULL before freeing it.
 *
 *	Returns: zero, if the pointer is NULL,
 *		 or one, if it is not NULL and freed.
 *
 ******************************************************************************/

int
safe_free (ptr)

void           *ptr;

{
	if (ptr != NULL)
	{
		free (ptr);
		return 1;
	}

	return 0;
} /* end of safe_free () */

/*******************************************************************************
 *
 *	Function: set_attr_flag
 *
 *	Purpose: Set the flags indicated by "flags" in the given attribute.
 *
 *	Returns: -1, if missing attribute,
 *		  0, if no flags changed,
 *		  1, if flags changed.
 *
 ******************************************************************************/

int
set_attr_flag (attr, flags)

DICT_ATTR      *attr;
int             flags;

{
	int             old;
	static char    *func = "set_attr_flag";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (attr == NULLDA)
	{
		return (-1);
	}

	if (flags & ATTR_RO_FLAGS != 0)
	{
		logit (LOG_DAEMON, LOG_ERR,
	   "%s: Attempt to modify read-only attribute flags 0x%x (0x%x) in %s",
			func, flags & ATTR_RO_FLAGS, flags, attr->name);
		flags &= ~ATTR_RO_FLAGS;
	}

	/* Warning check */
	if (flags == 0)
	{
		logit (LOG_DAEMON, LOG_INFO,
			"%s: Attempt to set NO flags for in %s",
			func, attr->name);
		return 0;
	}

	old = attr->flags;	/* Save old flags. */
	attr->flags |= flags;	/* Set flags marked. */

	if (attr->flags != old)
	{
		return 1;	/* Flags changed, indicate so. */
	}

	return 0;		/* No flags changed. */
} /* end of set_attr_flag () */

/******************************************************************************
 *
 *	Function: set_realm_name
 *
 *	Purpose: Set realm name with a given string.
 *		 The string "NULL" means a null realm name.
 *
 *	Returns: Pointer to realm name.
 *
 *****************************************************************************/

char *
set_realm_name (rname)

char       *rname;

{
	return add_string (get_realm_name (rname), ASLC);
} /* end of set_realm_name () */

/*******************************************************************************
 *
 *	Function: set_vp_attr_flags_list
 *
 *	Purpose: Set the flags indicated by "flags" in all the
 *		 attributes in the given a/v pair list.
 *
 *	Returns: -1, if no list,
 *		  0, if no flags changed,
 *		 +n, indicates how many a/v pairs changed.
 *
 ******************************************************************************/

int
set_vp_attr_flags_list (list, flags)

VALUE_PAIR     *list;
int             flags;

{
	int             count = 0;
	static char    *func = "set_vp_attr_flags_list";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (list == NULL_VP)
	{
		return (-1);
	}

	if (flags & ATTR_RO_FLAGS != 0)
	{
		logit (LOG_DAEMON, LOG_ERR,
		 "%s: Attempt to modify read-only attribute flags 0x%x (0x%x)",
			func, flags & ATTR_RO_FLAGS, flags);
		flags &= ~ATTR_RO_FLAGS;
	}

	/* Warning check */
	if (flags == 0)
	{
		logit (LOG_DAEMON, LOG_INFO,
			"%s: Attempt to set NO flags", func);
		return 0;
	}

	for ( ; list != NULL_VP; list = list->next)
	{
		if (set_attr_flag (list->ap, flags) != 0)
		{
			count++;
		}
	}

	return count;
} /* end of set_vp_attr_flags_list () */

/*******************************************************************************
 *
 *	Function: set_vp_flag
 *
 *	Purpose: Set the flags indicated by "flags" in the given a/v pair.
 *
 *	Returns: -1, if no a/v pair,
 *		  0, if no flags changed,
 *		  1, if flags changed.
 *
 ******************************************************************************/

int
set_vp_flag (vp, flags)

VALUE_PAIR     *vp;
int             flags;

{
	int             old;
	static char    *func = "set_vp_flag";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (vp == NULL_VP)
	{
		return (-1);
	}

	old = vp->flags;	/* Save old flags. */
	vp->flags |= flags;	/* Set flags marked. */

	if (vp->flags != old)
	{
		return 1;	/* Flags changed, indicate so. */
	}

	return 0;		/* No flags changed. */
} /* end of set_vp_flag () */

/*******************************************************************************
 *
 *	Function: set_vp_flags_list
 *
 *	Purpose: Set the flags indicated by "flags" in the a/v pair list.
 *
 *	Returns: -1, if no list,
 *		  0, if no flags changed,
 *		 +n, indicates how many a/v pairs changed.
 *
 ******************************************************************************/

int
set_vp_flags_list (list, flags)

VALUE_PAIR     *list;
int             flags;

{
	int             count = 0;
	static char    *func = "set_vp_flags_list";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (list == NULL_VP)
	{
		return (-1);
	}

	for ( ; list != NULL_VP; list = list->next)
	{
		if (set_vp_flag (list, flags) != 0)
		{
			count++;
		}
	}

	return count;
} /* end of set_vp_flags_list () */

#define	LOGFILE_FMT_SIZE	100

/*************************************************************************
 *
 *	Function: setup_logfile
 *
 *	Purpose: Setup a new RADIUS event logfile.
 *
 *************************************************************************/

void
setup_logfile (zap)

int             zap;	/* If one, then rename the new file, if it's there. */

{
	time_t           timeval;
	struct tm       *tm;
	logfile_info     lf;		/* .../raddb/logfile */
	logfile_info     lf_fmt;	/* .../raddb/logfile<fmt> */
	logfile_info     new;		/* For zapping */
	char             my_ctime[30];
	char             warning[LOGFILE_FMT_SIZE * 2];
	char             this[LOGFILE_FMT_SIZE];
	static char     *last_logfile_fmt = (char *) NULL;
	static char     *last_logfile = (char *) NULL;
	static char      last_logfile_fmt_buf[LOGFILE_FMT_SIZE];
	static char      last_logfile_buf[MAXPATHLEN];
	static time_t    last_timeval = 0;
	static char     *func = "setup_logfile";

	/* If no file logging, then don't do anything. */
	if (file_logging == 0)
	{
		return;
	}

	timeval = time (0);

	/* If not first time through and less than five seconds, skip it */
	if (last_timeval != 0 && timeval - last_timeval < 5)
	{
		return;
	}

	/* Watch out for backwards running clocks. */
	if (last_timeval < timeval)
	{
		last_timeval = timeval;
	}

	tm = localtime (&last_timeval);		/* Get current time. */
	strftime (this, sizeof (this), radius_log_fmt, tm);

	/* This looks like what ctime() produces. */
	strftime (my_ctime, sizeof (my_ctime), "%a %b %e %T %Y", tm);

	/* Build the (new) filename(s) here. */
	sprintf (lf.name, "%s/%s", radius_dir, RADIUS_LOG);

	/* Check to see if the variable name is rooted or not... */
	if ((this[0] == '/') ||
		(strncmp (this, "./", 2) == 0) ||
		(strncmp (this, "../", 3) == 0))
	{
		/* Absolute or relative pathname explicitly specified. */
		strcpy (lf_fmt.name, this);
	}
	else	/* drop it into the ../raddb directory */
	{
		sprintf (lf_fmt.name, "%s/%s", radius_dir, this);
	}

	/* Flush and re-open the logfile. */
	if ((zap == 2) &&
		(last_logfile != (char *) NULL) &&
		(msgfd != (FILE *) NULL) &&
		(msgfd != stderr))
	{
		fflush (msgfd);
		freopen (last_logfile, "a", msgfd);
		return;
	}

	/* If we want to leave a warning in the logfile, put it here. */
	warning[0] = '\0';

	/* If this isn't our first time, try and clean up. */
	if ((last_logfile_fmt != (char *) NULL) &&
		(msgfd != (FILE *) NULL))
	{
		/* If the format string hasn't changed, do nothing. */
		if (strcmp (this, last_logfile_fmt) == 0)
		{
			return;
		}
		
		/*
		 *	Don't switch logfiles if we've been up
		 *	for less than two minutes, or our clock
		 *	is running backwards.
		 */
		if ((last_timeval < birthdate) ||
			((last_timeval - birthdate) < (2 * 60)))
		{
			return;
		}

		/* Do stat() on ".../raddb/logfile" before we back it off. */
		stat_logfile_info (&lf);

		/* Remove the old ".../raddb/logfile" thing. */
		(void) backoff_logfile (&lf, 100);

		/* Close the old logfile. */
		if (msgfd != stderr)
		{
			if (msgfd != (FILE *) NULL)
			{
				fprintf (msgfd,
					"%s: %s: Switching from '%s' to '%s'\n",
					my_ctime, func, last_logfile_buf,
					lf_fmt.name);
				fclose (msgfd);
				msgfd = stderr;	
			}

			/* Compress the old formatted logfile. */
			compress_file (last_logfile);
		}
	}
	else /* Have a last_logfile_fmt to work with. */
	{
		if (last_logfile_fmt != (char *) NULL)
		{
			sprintf (warning,
				"Warning! msgfd = NULL/last_logfile_fmt = '%s'",
				last_logfile_fmt);
		}

		/* Do stat() on ".../raddb/logfile" first, then call backoff. */
		stat_logfile_info (&lf);

		/* First time up?  Remove the old "../raddb/logfile" file. */
		(void) backoff_logfile (&lf, 100);
		
		/* If zap is specified, zap only once. */
		if (zap == 1)
		{
			sprintf (new.name, "%s.old", lf_fmt.name);
			unlink (new.name);
			rename (lf_fmt.name, new.name);
		}
	}

	/* Open the new logfile. */
	if ((msgfd = fopen (lf_fmt.name, "a")) == (FILE *) NULL)
	{
		fprintf (stderr,
			"%s: %s: Couldn't open %s for logging, error %d %s\n",
			my_ctime, func, lf_fmt.name, errno, get_errmsg ());
		msgfd = stderr;
	}
	else /* logfile opened successfully */
	{

#ifndef SCO
		/* Set permissions correctly... */
		fchmod (fileno(msgfd), RAD_READ_MODE);
#endif

		/* Get whatever information we have. */
		stat_logfile_info (&lf_fmt);

		/* Add in welcome message. */
		if ((last_timeval > birthdate) &&
			((last_timeval - birthdate) > (2 * 60)) &&
			(birthdate != 0))
		{
			fprintf (msgfd,
				"%s: created by PID %u %s up since %s",
				my_ctime, getpid (), verinfo (0),
				ctime (&birthdate));
		}
		
		if (last_logfile != (char *) NULL)
		{
			fprintf (msgfd, "%s: Switched from '%s' to '%s'\n",
				 my_ctime, last_logfile, lf_fmt.name);
		}

		if (strcmp (lf.name, lf_fmt.name) != 0)
		{
			/* And link to the real ".../raddb/logfile" */
			if (link (lf_fmt.name, lf.name) != 0)
			{
				fprintf (msgfd,
			    "%s: %s: Unable to link('%s', '%s'), error %d %s\n",
					my_ctime, func, lf_fmt.name, lf.name,
					errno, get_errmsg ());
			}
		}

		/*
		 *	Report any warnings too.
		 */
		if (warning[0] != '\0')
		{
			fprintf (msgfd, "%s: %s: %s\n", my_ctime, func,
				warning);
		}

		/* Remember current state. */
		strcpy (last_logfile_fmt_buf, this);
		last_logfile_fmt = last_logfile_fmt_buf;
		strcpy (last_logfile_buf, lf_fmt.name);
		last_logfile = last_logfile_buf;
	}
	return;
} /* end of setup_logfile () */

/*************************************************************************
 *
 *	Function: setupsock
 *
 *	Purpose: Gets and binds a socket.
 *
 *************************************************************************/

int
setupsock (sin, portnum)

struct sockaddr_in *sin;
int             portnum;

{
	int              sock;
	int              sinlen;
	static char     *func = "setupsock";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/*
	 * Get a socket.
	 */
	if ((sock = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
	{
		(void) perror ("socket");
		exit (-11);
	}
	sinlen = sizeof (struct sockaddr_in);
	memset ((char *) sin, '\0', sinlen);

	/*
	 * Get server's listening port number
	 */
	sin->sin_port = htons(portnum);

	/*
	 * Bind socket to port.  bind finds free port if portnum == 0
	 */
	sin->sin_family = AF_INET;
	sin->sin_addr.s_addr = INADDR_ANY;
	if (bind (sock, (struct sockaddr *) sin,
		sizeof (struct sockaddr_in)) < 0)
	{
		(void) perror ("bind");
		exit (-11);
	}
	/* Retrieve complete socket info */
	if (getsockname (sock, (struct sockaddr *) sin, &sinlen) < 0)
	{
		(void) perror ("getsockname");
		exit (-11);
	}
	return sock;
} /* end of setupsock () */

/*************************************************************************
 *
 *	Function: stat_logfile_info
 *
 *	Purpose: Call stat() on the given file.
 *
 *************************************************************************/

static int
stat_logfile_info (plf)

logfile_info   *plf;	/* Stat the logfile, etc. */

{
	if (plf == (logfile_info *) NULL)
	{
		return (-1);
	}

	if (stat (plf->name, &(plf->stat)) != 0)
	{
		plf->errcode = errno;
	}
	else
	{
		plf->errcode = 0;
        }

	return plf->errcode;	/* Return result code. */
} /* end of stat_logfile_info () */

/*************************************************************************
 *
 *	Function: switch_by_name
 *
 *	Purpose: Turn on and off various bit-flags.
 *
 *	Returns: 0 : success,
 *		-1 : no such name,
 *		-2 : name not prefixed with + or -,
 *		-3 : parameter error.
 *
 *************************************************************************/

int
switch_by_name (table, name, p_sws)

SWITCH_TABLE   *table;	/* Table of switch names and values */
char           *name;	/* Name of thing to look up in table, prefix with +/- */
int            *p_sws;	/* Pointer to switches to modify */

{
	u_char          on_off;
	static char    *func = "switch_by_name";

	if ((table == (SWITCH_TABLE *) NULL) ||
		(name == NULL) ||
		(p_sws == NULL))
	{
		return (-3);	/* Parameter error return */
	}

	switch (*name)
	{
	    case '+':
	    case '-':
		on_off = *name;
		name++;
		break;

	    default:
		return (-2);	/* Format error. */
	}

	/*
	 * Scan to the end of the table.
	 */
	for ( ; table->name != NULL; table++)
	{
		if (strcasecmp (name, table->name) == 0)
		{
			switch (on_off)
			{
			    case '+':
				*p_sws |= table->value;
				return (0);

			    case '-':
				*p_sws &= ~table->value;
				return (0);

			    default:
				logit (LOG_DAEMON, LOG_CRIT,
					"%s: FATAL ERROR", func);
				dumpcore = 1;
				abort ();
			}
		}
	}

	return (-1);	/* Not found error. */
} /* end of switch_by_name () */

/*************************************************************************
 *
 *	Function: type_string
 *
 *	Purpose: Returns protocol type string for logging of authentication
 *		 requests.
 *
 *************************************************************************/

char *
type_string (authreq, protpair)

AUTH_REQ       *authreq;
VALUE_PAIR     *protpair;

{
	char            *ptr;
	VALUE_PAIR      *user_type;
	static char      string[10];
	static char     *func = "type_string";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	user_type = get_vp (authreq->cur_request, PW_SERVICE_TYPE);

	if (user_type != NULL_VP && user_type->lvalue == PW_AUTHENTICATE_ONLY)
	{
		ptr = "auth";
	}
	else
	{
		ptr = (protpair == NULL_VP)
			? "dumb" : avpair_vtoa (protpair, AVPAIR_VTOA_NULL);
	}

	strncpy (string, ptr, sizeof (string));

	return (string);
} /* end of type_string () */

/******************************************************************************
 *
 *	Function: xget_word_list
 *
 *	Purpose: Split a text buffer into a list of 'words' separated by
 *		 "delim" characters.
 *
 *	Returns: Number of words.
 *
 *****************************************************************************/

int
xget_word_list (buf, wv, nwv, delim)

char       *buf;
char       *wv[];
int         nwv;
char       *delim;

{
	char             cq;
	int              wlen;
	int              tlen;
	int              wc;
	char            *ptr;
	static char     *func = "xget_word_list";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	for (wc = 0 ; wc < nwv ; )
	{
		switch (*(buf = get_next_word (buf, delim, &wlen)))
		{
		    case COMMENT:
			return wc;

		    case '"':			/* double quote */
		    case '\'':			/* quote */
			cq = *buf++;
			ptr = buf;
			tlen = wlen - 1;
			while (ptr[tlen] != '\n' && ptr[tlen] != 0)
			{
				if (cq == ptr[tlen - 1])
				{
					break;
				}
				ptr = get_next_word (ptr + tlen, delim, &tlen);
			}
			wlen = (ptr - buf) + tlen - 1;
			break;

		    default:
			if (wlen == 0)
			{
				return wc;
			}
		}

		wv[wc++] = buf;
		buf += wlen;
		if (*buf == 0)
		{
			break;
		}
		*buf++ = 0;
	}
	return wc;
} /* end of xget_word_list () */
