#ifdef USR_CCA

/*
 *
 * Copyright (c) 1996 U.S. Robotics, Access Corp.
 * All rights reserved.
 *
 * Permission to copy, display, distribute and make derivative works
 * from this material in whole or in part for any purpose is granted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all copies.  THIS SOFTWARE IS PROVIDED "AS IS" AND
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * If providing code not subject to a copyright please indicate that the
 * code has been dedicated to the public.
 *
 */

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

static char     rcsid[] = "$Id: fwd2nas.c,v 1.6 1998/07/06 17:43:16 web Exp $";

/****************************************************************************
 *
 *			fwd_2_nas.c
 *
 *	This file contains all the AATVs, functions, etc. necessary to forward
 *	Resource Query Requests to the NAS.
 *
 ***************************************************************************/

#include        <sys/param.h>
#include        <sys/types.h>
#include        <sys/socket.h>
#include        <netinet/in.h>
#include        <arpa/inet.h>
#include        <sys/ioctl.h>

#include        <sys/file.h>
#include        <sys/file.h>
#include        <sys/wait.h>
#include        <sys/stat.h>

#if defined(sys5)
#include        <sys/sysmacros.h>
#endif	/* sys5 */

#include        <net/if.h>

#include        <stdio.h>
#include        <stdlib.h>
#include        <netdb.h>
#include        <fcntl.h>
#include        <time.h>
#include        <errno.h>
#include        <memory.h>
#include        <signal.h>
#include        <syslog.h>

#include        "radius.h"

extern int      debug_flag;
extern AUTH_REQ_Q global_auth_q;
extern FSM_ENT **fsm;

/**************************************************************************
 *
 *			FWD_TO_NAS definition
 *
 *************************************************************************/

static int rad_fwd2nas_action PROTO((AUTH_REQ *, int, char *));
static int initial_fwd PROTO((AUTH_REQ *));
static int forward PROTO((AUTH_REQ *));

static AATV     fwd2nas_aatv = DEF_AATV_DIRECT("FWD_TO_NAS", rad_fwd2nas_action);

AATVPTR         rad_fwd2nas_aatv = &fwd2nas_aatv;

/**************************************************************************
 *
 *	Function: rad_fwd2nas_action
 *
 *	Purpose: Action function of FWD_TO_NAS AATV.  Forwards the Resource
 *		 Query Requests to the appropriate NAS.
 *
 *************************************************************************/

static int
rad_fwd2nas_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	VALUE_PAIR     *vp;
	struct in_addr  addr;
	UINT4           index;
	char           *func = "rad_fwd2nas_action";

	dprintf (2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	addr.s_addr = authreq->ipaddr;
	if ((vp = get_vp_vend (authreq->request, PW_USR_RQ_INDEX, VC_USR))
								== NULL_VP)
	{
		logit (LOG_DAEMON, LOG_ERR,
		    "%s: Missing Index value in Resource Query Request from %s",
		       func, inet_ntoa (addr));
		return EV_NAK;
	}

/*	if (vp->lvalue < VENDOR_ID_LENGTH + SUB_ID_LENGTH)
	{
		logit (LOG_DAEMON, LOG_ERR,
		   "%s: Invalid Index Length in Resource Query Request from %s",
		       func, inet_ntoa (addr));
		return EV_NAK;
	}
*/
	authreq->fsmstatus = EV_ACK;

/*	memcpy ((char *) &index, vp->strvalue, sizeof (UINT4));

	index = ntohl (index);
*/
	index = vp->lvalue;

	if (index == 0)
	{
		return initial_fwd (authreq);
	}

	return forward (authreq);

} /* end of rad_fwd2nas_action () */

/***************************************************************************
 *
 *	Function: initial_fwd
 *
 *	Purpose: handles the initial Resource Query Request from a DAS.  It
 *		 makes a copy of this request for each NAS in its clients file
 *		 and then forwards each copy.
 *
 **************************************************************************/

static int
initial_fwd (authreq)

AUTH_REQ       *authreq;

{
	AUTH_REQ       *auth;
	CLIENT_ENTRY   *client_ent;
	CLIENT_ENTRY   *client_list;
	AATV           *act_aatv;
	int             qry_count = 0;
	int             ver_1 = 0;
	char           *func = "initial_fwd";

	dprintf (2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));
	act_aatv = find_aatv ("REPLY");

	/* Find the VPN IDs for this DAS */

	if (find_vpn (authreq) == 1)
	{
		logit (LOG_DEBUG, LOG_INFO,
		       "%s: No VPN ID specified for this DAS ", func);
	}
	else
	{
		client_list = get_client_list ();
		for (client_ent = client_list;
				client_ent != (CLIENT_ENTRY *) NULL;
				client_ent = client_ent->next)
		{
			if ((client_ent->client_type & CE_NAS) != CE_NAS)
			{
				continue;
			}

			if (client_ent->version == VER1)
			{
				ver_1++;
				continue;
			}

			if (client_ent->addrs == (IP_ADDRESS *) NULL)
			{
				continue;
			}

			auth = dup_authreq (authreq);

			auth->ipaddr = client_ent->addrs->ipaddr.s_addr;
			auth->ttl = RQUERY_TIMER;
			auth->retry_cnt = 0;
			auth->nas_ip = authreq->ipaddr;
			auth->fwd_id = auth->rep_id;
			auth->rep_id = new_id (global_auth_q.q);
			auth->type = USR_PROXY | USR_CHILD;
			auth->timer = 0;
			auth->fsmstatus = EV_ACK;
			auth->state = authreq->state;

			if (time (0) > client_ent->expire_time)
			{
				update_clients ();
			}

			auth->client = client_ent;

			call_action (act_aatv, auth, 0, "");
			qry_count++;
		}
	}

	if (qry_count == 0 || ver_1 > 0)	/* Request not forwarded to
						 * any NAS */
	{
		avpair_del (&authreq->cur_request, PW_USR_VPN_ID, VC_USR);
		authreq->code = PW_RESOURCE_QUERY_RESP;
		avpair_add (&authreq->cur_request, PW_NAS_IP_ADDRESS,
			    &authreq->ipaddr, 0);
		call_action (act_aatv, authreq, 0, "");
		return EV_ACK;
	}
	return EV_ACK;
} /* end of initial_fwd () */

/***************************************************************************
 *
 *	Function: forward
 *
 *	Purpose: Forwards all Resource Query Requests, except the first from
 *		 a DAS to the correct NAS
 *
 **************************************************************************/

static int
forward (authreq)

AUTH_REQ       *authreq;

{
	VALUE_PAIR     *vp;
	AATV           *paatv;
	AUTH_REQ       *auth;
	CLIENT_ENTRY   *ce;
	struct in_addr  addr;
	char           *func = "forward";

	dprintf (2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((vp = get_vp (authreq->request, PW_NAS_IP_ADDRESS))
			== (VALUE_PAIR *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR,
		     "%s: Missing NAS IP Address in Resource Query Request",
		       func);
		return EV_NAK;
	}

	if (find_client (vp->lvalue, &ce) < 0)
	{
		addr.s_addr = vp->lvalue;
		logit (LOG_DAEMON, LOG_ERR,
		       "%s: Resource Query Request for unknown client %s",
		       func, inet_ntoa (addr));
		return EV_NAK;
	}

	if (find_vpn (authreq) != 0)
	{
		addr.s_addr = authreq->ipaddr;
		logit (LOG_DEBUG, LOG_DEBUG,
		       "%s: No VPN ID specified for DAS %s ", func,
		       inet_ntoa (addr));
		return EV_NAK;
	}

	auth = dup_authreq (authreq);
	auth->client = ce;
	auth->ipaddr = vp->lvalue;
	auth->timer = 0;
	auth->ttl = RQUERY_TIMER;
	auth->type = USR_PROXY;
	auth->fwd_id = authreq->rep_id;
	auth->rep_id = new_id (global_auth_q.q);
	auth->fsmstatus = EV_ACK;
	auth->state = authreq->state;
	auth->nas_ip = authreq->ipaddr;
	paatv = find_aatv ("REPLY");
	call_action (paatv, auth, 0, "");
	return EV_ACK;

} /* end of forward () */

#endif  /* USR_CCA */
