#ifdef USR_CCA

/*
 *
 * Copyright (c) 1996 U.S. Robotics, Access Corp.
 * All rights reserved.
 *
 * Permission to copy, display, distribute and make derivative works
 * from this material in whole or in part for any purpose is granted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all copies.  THIS SOFTWARE IS PROVIDED "AS IS" AND
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * If providing code not subject to a copyright please indicate that the
 * code has been dedicated to the public.
 *
 */

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

static char     rcsid[] = "$Id: nas_reb.c,v 1.4 1998/07/06 17:43:20 web Exp $";

/*****************************************************************************
 *
 *	This file defines the NAS Reboot Free Request (NAS_REB_FREE) AATV
 *	and other functions required by this AATV
 *
 ****************************************************************************/

#include        <sys/param.h>
#include        <sys/types.h>
#include        <sys/socket.h>
#include        <netinet/in.h>
#include        <arpa/inet.h>
#include        <sys/ioctl.h>
#include        <sys/file.h>
#include        <sys/time.h>
#include        <sys/file.h>
#include        <sys/wait.h>
#include        <sys/stat.h>

#if defined(sys5)
#include        <sys/sysmacros.h>
#endif	/* sys5 */

#include        <net/if.h>

#include        <stdio.h>
#include        <stdlib.h>
#include        <netdb.h>
#include        <fcntl.h>
#include        <errno.h>
#include        <signal.h>
#include        <syslog.h>

#include        "radius.h"

extern char     port_msg[128];
extern int      ack_nak_flag;
extern int      debug_flag;
extern FILE    *ddt;
extern FSM_ENT **fsm;
extern AUTH_REQ *make_dup PROTO((AUTH_REQ *));
extern UINT4    self_ip[];

/*****************************************************************************
 *
 *			     rad_nas_reb_aatv
 *
 ****************************************************************************/

static int rad_nas_reb_action PROTO((AUTH_REQ *, int, char *));

static AATV     nas_reb_aatv = DEF_AATV_DIRECT("NAS_REB", rad_nas_reb_action);

AATVPTR         rad_nas_reb_aatv = &nas_reb_aatv;

static char free_nas PROTO((UINT4));

/*****************************************************************************
 *
 *	Function: rad_nas_reb_action
 *
 *	Purpose:  Handle NAS Reboot Free Requests
 *
 ****************************************************************************/

static int
rad_nas_reb_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	VALUE_PAIR     *nas;
	AUTH_REQ       *auth_tmp;
	AUTH_REQ       *auth;
	CLIENT_ENTRY   *client_ent;
	CLIENT_ENTRY   *client_list;
	FSM_ENT        *fsm_ent;
	u_char          next_state;
	AATV           *paatv;
	char           *func = "rad_nas_reb_action";

	dprintf (2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((nas = get_vp (authreq->cur_request, PW_NAS_IP_ADDRESS))
							== (VALUE_PAIR *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR,
	     "%s: Missing NAS IP address in NAS Reboot Free Resource Request\n",
			func);
		free_authreq (authreq);
		return EV_NAK;
	}

	free_nas (nas->lvalue);

	auth_tmp = make_dup (authreq);
	auth_tmp->retry_cnt = 0;
	auth_tmp->ttl = NAS_REB_TIMER;
	auth_tmp->fsmstatus = EV_ACK;
	fsm_ent = fsm[authreq->state];
	for ( ; fsm_ent != (FSM_ENT *) NULL; fsm_ent = fsm_ent->next)
	{
		if (fsm_ent->event.value == EV_RF_REQ)
		{
			break;
		}
	}

	if (fsm_ent != (FSM_ENT *) NULL)
	{
		next_state = fsm_ent->next_state;
	}

	paatv = find_aatv ("RAD2RAD");

	client_list = get_client_list ();
	for (client_ent = client_list;
		client_ent != (CLIENT_ENTRY *) NULL;
		client_ent = client_ent->next)
	{
		if ((client_ent->client_type & CE_DAS) != CE_DAS)
		{
			continue;
		}

		if (get_ipaddr (client_ent->hostname) == self_ip[0])
		{
			continue;
		}
		auth = dup_authreq (auth_tmp);
/*	XXX	auth->ipaddr = tmp; */
		auth->rep_id = auth->fwd_id;

		/* Forwarding request. */
		call_action (paatv, auth, 0, client_ent->hostname);

		if (auth != (AUTH_REQ *) NULL)
		{
			auth->state = next_state;
		}
	}

	if (auth_tmp != (AUTH_REQ *) NULL)
	{
		free_event_list (auth_tmp);
		list_free (auth_tmp->request);
		list_free (auth_tmp->cur_request);
		list_free (auth_tmp->user_check);
		free (auth_tmp);
	}
	authreq->fsmstatus = EV_ACK;
	authreq->retry_cnt = NAS_REB_RETRY;
	authreq->ttl = 1;

	paatv = find_aatv ("REPLY");

	call_action (paatv, authreq, 0, "");

	return EV_ACK;

} /* end of rad_nas_reb_action () */

/****************************************************************************
 *
 *      Function: free_nas
 *
 *      Purpose: Frees all the resources associated with the given NAS IP
 *               address
 *
 ***************************************************************************/

static char
free_nas (ipaddr)

UINT4           ipaddr;

{
	FILE_LIST      *file_ent;
	ADDR_POOL      *aptr;
	ASSIGNED_IP   **assign_prev;
	ASSIGNED_IP    *assign_cur;
	char           *func = "free_nas";


	dprintf (2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));
	file_ent = get_default_file_entry ();

	for (; file_ent; file_ent = file_ent->next)
	{
		for (aptr = file_ent->pool_list; aptr; aptr = aptr->next)
		{
			if (aptr->count == 0)
			{
				continue;
			}
			assign_prev = &aptr->user_q;
			assign_cur = *assign_prev;
			while (assign_cur != (ASSIGNED_IP *) NULL)
			{
				if (assign_cur->nas_ip == ipaddr)/* found NAS */
				{
					*assign_prev = assign_cur->next;
					aptr->count--;
					if (assign_cur->user_ent
							!= (USER_ENTRY *) NULL)
					{
						(assign_cur->user_ent)->count--;
					}
					free (assign_cur);
					assign_cur = *assign_prev;
					continue;
				}
				assign_prev = &assign_cur->next;
				assign_cur = assign_cur->next;
			}
		}
	}
	return 1;
} /* end of free_nas () */

#endif  /* USR_CCA */
