#ifdef BSD_AUTHENTICATION

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved.
 *
 * Some code in this module has been contributed by BSDi to the public.
 */

#include	<sys/types.h>
#include	<sys/param.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/file.h>
#include	<sys/wait.h>
#include	<net/if.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<errno.h>
#include	<signal.h>
#include	<memory.h>
#include	<syslog.h>

#include	<login_cap.h>
#include	<stdarg.h>
#include	<bsd_auth.h>

#include	"radius.h"


static int       bsd_pass PROTO((AUTH_REQ *, int, char *));

static AATV      bsd_aatv = DEF_AATV_FORK_TYPE("BSD-AUTH", AA_BSD, bsd_pass, 0);

AATVPTR          rad_bsd_aatv = &bsd_aatv;

/*************************************************************************
 *
 *	Function: bsd_pass
 *
 *	Purpose: Check the users password using BSD Authentication
 *
 *************************************************************************/

static int
bsd_pass (authreq, value, af_param)

AUTH_REQ       *authreq;
int             value;
char           *af_param;

{
	int             status;
	int             s;
	char           *challenge = NULL;
	char           *name;
	char           *reqstyle;
	char           *style;
	login_cap_t    *class;
	auth_session_t *as;
	VALUE_PAIR     *vp;
	void          (*sigchld) ();
	char            passwd[AUTH_PASS_LEN + 1];
	static char    *func = "bsd_pass";

	if ((vp = get_vp_vend (authreq->cur_request,
				PW_USER_ID, VC_MERIT)) == NULL_VP)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: Improper userid specification", func);
		reply_message (authreq, EC_INTERNAL, func);
		return EV_NAK;
	}
	name = (char *) vp->strvalue;

	if ((reqstyle = strchr (name, ':')) != NULL)
	{
		*reqstyle++ = '\0';
	}

	dprintf(1, (LOG_AUTH, LOG_DEBUG, "%s: ID = '%s'", func, name));

	for (vp = authreq->cur_request; vp != NULL_VP; vp = vp->next)
	{
		if (vp->attribute == PW_STATE)
		{
			challenge = (char *) vp->strvalue;
		}
	}

	if ((class = login_getclass ("RADIUS")) == NULL)
	{
		dprintf(1, (LOG_DAEMON, LOG_ERR,
			"%s: class RADIUS not found in /etc/login.conf", func));
		return EV_NAK;
	}

	if ((style = login_getstyle (class, reqstyle, "auth-radius")) == NULL)
	{
		dprintf(1, (LOG_AUTH, LOG_DEBUG,
			"%s: user %s style %s not available", func, name,
			reqstyle == NULL ? "<Default Style>" : reqstyle));
		login_close (class);
		return EV_NAK;
	}

	/* Decrypt password - NULL third argument says we don't handle CHAP */
	if ((status = get_passwd (authreq, passwd,
					(char *) NULL, (char *) NULL)) != 0)
	{
		memset ((char *) passwd, '\0', sizeof (passwd));
		login_close (class);
		dprintf(1, (LOG_AUTH, LOG_DEBUG,
			"%s: Error %d decrypting password", func, status));
		return EV_NAK;
	}

	dprintf(1, (LOG_AUTH, LOG_DEBUG, "%s: checking response for %s",
		func, name));

	as = auth_open ();
	auth_setitem (as, AUTHV_NAME, name);
	auth_setitem (as, AUTHV_STYLE, style);
	auth_setitem (as, AUTHV_CLASS, "RADIUS");
	if (challenge)
	{
		auth_setitem (as, AUTHV_CHALLENGE, challenge);
	}

	/*
	 *	Do not let the server capture our children.
	 *	Check the password with possible challenge.
	 */
	sigchld = signal (SIGCHLD, SIG_DFL);
	status = auth_userresponse (as, passwd, 1);
	memset ((char *) passwd, '\0', sizeof (passwd));
	signal (SIGCHLD, sigchld);

	/*
	 *	Positive status implies we authenticated the user
	 */
	if (status > 0)
	{
		auth_close (as);
		login_close (class);
		return EV_ACK;
	}

	/*
	 *	If the user has already provided a challenge, then
	 *	there is no sense challenging them a second time.
	 *	Let them start over from the beginning.
	 */
	if (challenge)
	{
		auth_close (as);
		login_close (class);
		return EV_NAK;
	}

	/* Check to see if the user should be challenged. */
	sigchld = signal (SIGCHLD, SIG_DFL);
	challenge = auth_challenge (as);
	signal (SIGCHLD, sigchld);
	login_close (class);

	if (challenge && *challenge)
	{
		dprintf(2, (LOG_AUTH, LOG_DEBUG,
			"%s: sending challenge for %s", name));
		reply_sprintf (RS_NONE, authreq, "%s", challenge);
		avpair_add (&authreq->cur_request, PW_STATE, challenge, -1);
		status = EV_ACC_CHAL;
	}
	else
	{
		status = EV_NAK;
	}

	auth_close (as);

	return (status);

} /* end of bsd_pass () */

#endif	/* BSD_AUTHENTICATION */
