/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

/*
 *
 * Public entry points in this file:
 *
 */

static char     rcsid[] = "$Id: rad.kchap.c,v 1.2 1998/06/11 18:40:44 web Exp $";

#include	<sys/types.h>
#include	<sys/param.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/file.h>
#include	<sys/wait.h>
#include	<net/if.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<errno.h>
#include	<signal.h>
#include	<syslog.h>
#include	<memory.h>

#include	"radius.h"

extern int      debug_flag;

#ifndef KCHAP
AATVPTR         rad_kchp_aatv = NULL;
#else

static int      kchap_pass PROTO((AUTH_REQ *, int, char *));

static AATV     kchap_aatv = DEF_AATV_DIRECT_TYPE("KCHAP", AA_KCHAP,
							kchap_pass);

AATVPTR         rad_kchp_aatv = & kchap_aatv;

/*************************************************************************
 *
 *	Function: kchap_pass
 *
 *	Purpose: Check users password against MIT Kerberos server for
 *		 the specified realm.
 *
 *************************************************************************/

static int
kchap_pass (authreq, value, af_param)

AUTH_REQ       *authreq;
int             value;
char	       *af_param;

{
	char            key[42];
	int             id_to_key ();
	VALUE_PAIR     *vp;
	char            id[AUTH_ID_LEN + 1];
	static char    *func = "kchap_pass";

	dprintf(2, (LOG_AUTH, LOG_DEBUG, "%s: entered", func));

	if ((vp = get_vp_vend (authreq->cur_request, PW_USER_ID, VC_MERIT))
								== NULL_VP)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: Improper userid specification", func);
		reply_message (authreq, EC_INTERNAL, func);
		return EV_NAK;
	}
	strcpy (id, vp->strvalue);

	/* Get key (encrypted secret) for this id */

	if (id_to_key (id, key, sizeof (key)) != 0)
	{
		return EV_NAK;
	}

	/* Now use it for CHAP evaluation (NULL pw forces only CHAP check) */

	if (get_passwd (authreq, (char *) NULL, key, (char *) NULL) != 0)
	{
		memset (key, '\0', sizeof (key));
		return EV_NAK;
	}
	memset (key, '\0', sizeof (key));
	return EV_ACK;
} /* end of kchap_pass () */

#endif	/* KCHAP */
