/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

/*
 *
 * Public entry points in this file:
 *
 */

static char     rcsid[] = "$Id: rad.kerberos.c,v 1.5 1998/06/25 20:16:09 weiwang Exp $";

#include	<sys/types.h>
#include	<sys/param.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/file.h>
#include	<sys/wait.h>
#include	<net/if.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<errno.h>
#include	<signal.h>
#include	<memory.h>
#include	<syslog.h>

#include	"radius.h"

#if defined(M_KERB) || defined(A_KERB)

#include	<krb.h>

static int      krb_pass PROTO((AUTH_REQ *, int, char *,
				int (*) (AUTH_REQ *, int, char *)));

extern int      debug_flag;

#endif	/* M_KERB || A_KERB */

#ifndef M_KERB
AATVPTR         rad_mkrb_aatv = NULL;
#else	/* M_KERB */
extern int      mit_passwd_to_key ();

static int      mkrb_pass PROTO((AUTH_REQ *, int, char *));

static AATV     mkrb_aatv = DEF_AATV_FORK_TYPE("MKERB", AA_MKRB, mkrb_pass, 0);

AATVPTR         rad_mkrb_aatv = & mkrb_aatv;

/***************************************************************************
 *
 *	Functions: mkrb_pass
 *
 *	Purpose: Call krb_pass() with the correct password function.
 *
 ***************************************************************************/

static int
mkrb_pass (authreq, value, realm)

AUTH_REQ       *authreq;
int             value;
char           *realm;

{
	return krb_pass (authreq, value, realm, mit_passwd_to_key);
} /* end of mkrb_pass () */
#endif	/* M_KERB */

#ifndef A_KERB
AATVPTR         rad_akrb_aatv = NULL;
#else	/* A_KERB */
extern int      afs_passwd_to_key ();

static int      akrb_pass PROTO((AUTH_REQ *, int, char *));

static AATV     akrb_aatv = DEF_AATV_FORK_TYPE("AKERB", AA_AKRB, akrb_pass, 0);

AATVPTR         rad_akrb_aatv = & akrb_aatv;

/***************************************************************************
 *
 *	Functions: akrb_pass
 *
 *	Purpose: Call krb_pass() with the correct password function.
 *
 ***************************************************************************/

static int
akrb_pass (authreq, value, realm)

AUTH_REQ       *authreq;
int             value;
char           *realm;

{
	return krb_pass (authreq, value, realm, afs_passwd_to_key);
} /* end of akrb_pass () */
#endif	/* A_KERB */

#if defined(M_KERB) || defined(A_KERB)

#ifndef KRB_ENVIRON
#define KRB_ENVIRON	"KRBTKFILE"
#endif

#ifndef KRB_TK_DIR
#define KRB_TK_DIR	"/tmp/tkt_"
#endif

/*************************************************************************
 *
 *	Function: krb_pass
 *
 *	Purpose: Gets Kerberos ticket from specified realm for userid.
 *
 *	Returns: EV_ACK if the userid and password pair was valid,
 *		 EV_NAK if they were somehow invalid,
 *		 EV_ERROR otherwise.
 *
 *************************************************************************/

static int
krb_pass (authreq, value, realm, passwd_to_key)

AUTH_REQ       *authreq;
int             value;
char           *realm;
int           (*passwd_to_key) ();

{
	VALUE_PAIR     *vp;
	char            tkfile[MAXPATHLEN];
	int             krbval;
	int             krbreturn;
	char            userid[AUTH_ID_LEN + 1];
	char            passwd[AUTH_PASS_LEN + 1];
	char            lrealm[REALM_SZ];
	static char    *func = "krb_pass";

	if ((vp = get_vp_vend (authreq->cur_request,
				PW_USER_ID, VC_MERIT)) == NULL_VP)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: Improper userid specification", func);
		reply_message (authreq, EC_INTERNAL, func);
		return EV_NAK;
	}
	strcpy (userid, vp->strvalue);

	dprintf(1, (LOG_AUTH, LOG_DEBUG, "%s: ID = %s  Realm = %s\n",
		func, userid, (realm == (char *) NULL) ? "?" : realm));

	if (!realm || !*realm)		/* if no realm given, use local realm */
	{
		if (krb_get_lrealm (lrealm, 1) != KSUCCESS)
		{
			(void) strncpy (lrealm, KRB_REALM, sizeof (lrealm));
		}
		realm = lrealm;
	}

	if (get_passwd (authreq, passwd, (char *) NULL, (char *) NULL) != 0)
	{
		return EV_NAK;
	}

	/* Set up the ticket file environment variable */

	sprintf (tkfile, "%.*s%d", sizeof (tkfile) - 16, KRB_TK_DIR, getpid ());
	(void) setenv (KRB_ENVIRON, tkfile, 1);
	krb_set_tkt_string (tkfile);

	krbval = INTK_BADPW;  /* Fail if type is bad somehow */

	/* get the ticket */
	krbval = krb_get_in_tkt (userid, "", realm, "krbtgt", realm,
				DEFAULT_TKT_LIFE, passwd_to_key, NULL, passwd);
	switch (krbval)
	{
	    case INTK_OK:
		krbreturn = EV_ACK;
		break;

	/* KDC errors */
	    case KDC_NAME_EXP:
		reply_sprintf (RS_LOG, authreq,
			"Principal (%s) in realm (%s) expired", userid, realm);
		krbreturn = EV_NAK;
		break;

            case KDC_PR_UNKNOWN:
		reply_sprintf (RS_LOG, authreq,
			"Principal (%s) in realm (%s) unknown", userid, realm);
		krbreturn = EV_NAK;
		break;

            case KDC_PR_N_UNIQUE:
		reply_sprintf (RS_LOG, authreq,
			"Principal (%s) in realm (%s) not unique",
			userid, realm);
		krbreturn = EV_NAK;
		break;

            case KDC_NULL_KEY:
		reply_sprintf (RS_LOG, authreq,
			"Principal (%s) in realm (%s) has no key",
			userid, realm);
		krbreturn = EV_NAK;
		break;

	    case KDC_PKT_VER:
		reply_sprintf (RS_LOG, authreq,
			"Kerberos in realm (%s) protocol version unknown",
			realm);
		krbreturn = EV_ERROR;
		break;
		
	/* SKDC errors */
	    case SKDC_RETRY:
		reply_sprintf (RS_LOG, authreq,
			"Kerberos retry count exceeded for realm (%s)",
			realm);
		krbreturn = EV_NAK;
		break;

	    case SKDC_CANT:
		reply_sprintf (RS_LOG, authreq,
			"Can't send request for realm (%s)", realm);
		krbreturn = EV_NAK;
		break;

	/* INTK errors */
	    case INTK_BADPW:	/* Tell client to give up on bad password... */
	    case INTK_W_NOTALL: /* ... also, on no password */
		krbreturn = EV_NAK;
		break;

	    default:
		krbreturn = EV_ERROR;
		reply_sprintf (RS_LOG, authreq,
			"odd Kerberos error %d for '%s@%s'",
			krbval, userid, realm);
		break;
	}

	dest_tkt ();		/* destroy the ticket */
	memset (passwd, 0, sizeof (passwd));
	return (krbreturn);
} /* end of krb_pass() */

#endif	/* M_KERB || A_KERB */
