/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

static char     rcsid[] = "$Id: radcheck.c,v 1.6 1998/07/06 17:43:22 web Exp $";

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/param.h>
#include	<netinet/in.h>
#include	<sys/time.h>

#ifdef	SVR4
#include	<sys/systeminfo.h>
#endif	/* SVR4 */

#include	<netdb.h>
#include	<stdio.h>
#include	<stdlib.h>

#include	"radius.h"

#ifndef RESPONSE_TIMEOUT
#define RESPONSE_TIMEOUT 3
#endif

#ifndef RETRY_MAX
#define RETRY_MAX	10
#endif

UINT2           send_buffer_size = RAD_SEND_BUFFER_SIZE;
char            recv_buffer[RAD_RECV_BUFFER_SIZE];
char            send_buffer[RAD_SEND_BUFFER_SIZE];
char            ourhostname[MAXHOSTNAMELEN];
char           *progname;
char           *radius_dir;
int             debug_flag = 0;
int             dumpcore = 0;
int             file_logging = 2;   /* 0 => syslog, 1 => logfile, 2 => stderr */
int             zap_logfile = 0;
int             authfile_cnt = 0;
int             clients_cnt = 0;
int             users_cnt = 0;
time_t          birthdate;
AATVPTR		rad_authen_aatv = (AATV *) NULL;
AATVPTR         rad_ipc_aatv = (AATV *) NULL;
AATV           *authtype_tv[PW_AUTH_MAX + 1];
FILE           *ddt = NULL;
FILE           *msgfd = stderr;
extern void     dir_init ();

static void     radcheck_usage ();

#ifdef	MERIT_TIMELEFT
static int      parse_hg ();
#endif	/* MERIT_TIMELEFT */

int
main (argc, argv)

int             argc;
char           *argv[];

{

#ifdef	MERIT_TIMELEFT
	char            dns;
	char            p;
	char            m;
	int             timeleft = 0;
	int             num;
	UINT4           ip_addr;
	VALUE_PAIR     *vp;
	HG_ENTRY       *hg;
#endif	/* MERIT_TIMELEFT */

	int             dict_inited = 0;
	int             max_retries;
	int             result;
	int             retries;
	int             new_old;
	int             zero = 0;
	char           *huntgroup_name;
	char           *subgroup_name;

#ifdef	MERIT_TIMELEFT
	char            buf[256];
	char            hgserver[MAXHOSTNAMELEN];
#endif	/* MERIT_TIMELEFT */

	char            msg[4 * 4096]; /* big enough to hold several messages */
	SEND_DATA       data;

	progname = *argv;

	data.version = 0;
	data.svc_port = 0;
	max_retries = RETRY_MAX;
	data.timeout = RESPONSE_TIMEOUT;
	new_old = 1; /* assume new style */
	radius_dir = "";
	data.user_file = (char *) NULL;
	data.group = (char *) NULL;
	data.arades = 0;
	data.send_pairs = NULL_VP;

	while (--argc > 0 && *(*++argv) == '-')
	{
		/* switch on char. after "-" */
		switch (*(*argv + 1))
		{
		    case 'd':
			if (--argc == 0)
			{
				radcheck_usage ();
			}
			argv++;
			radius_dir = *argv;
			break;

		    case 'g':
			if (--argc == 0)
			{
				radcheck_usage ();
			}
			argv++;
			huntgroup_name = *argv;

			if (dict_inited == 0)
			{
				dir_init ();
 
				if (dict_init () != 0)
				{
					exit (-1);
				}
				dict_inited = 1;
			}

			avpair_add_vend (&data.send_pairs, PW_HUNTGROUP_NAME,
					huntgroup_name, -1, VC_MERIT);
			break;

		    case 's':
			if (--argc == 0)
			{
				radcheck_usage ();
			}
			argv++;
			subgroup_name = *argv;

			if (dict_inited == 0)
			{
				dir_init ();

				if (dict_init () != 0)
				{
					exit (-1);
				}
				dict_inited = 1;
			}

			avpair_add_vend (&data.send_pairs, PW_SUBGROUP,
					subgroup_name, -1, VC_MERIT); 

			break;

		    case 'p':
			if (--argc == 0)
			{
				radcheck_usage ();
			}
			argv++;
			sscanf (*argv, "%u", &data.svc_port);
			break;

		    case 't':	/* Timeout value */
			if (--argc == 0)
			{
				radcheck_usage ();
			}
			argv++;
			sscanf (*argv, "%u", &data.timeout);
			break;

		    case 'r':	/* max. Retransmit count */
			if (--argc == 0)
			{
				radcheck_usage ();
			}
			argv++;
			sscanf (*argv, "%u", &max_retries);
			break;

		    case 'o':
			new_old = 0;
			break;

		    case 'v':
			fprintf (stderr, "Version %s\n", verinfo (2));
			exit (0);
			break;

		    case 'x':
			debug_flag++;
			ddt = stderr;
			break;
#ifdef	MERIT_TIMELEFT
		    case 'Z':
			timeleft++;
			break;
#endif	/* MERIT_TIMELEFT */

		    case '0':
			zero = 1;
			break;

		    default:
			radcheck_usage ();
		}
	}

#ifdef	MERIT_TIMELEFT
	if ((zero == 0) && (timeleft == 0))
	{
#else	/* MERIT_TIMELEFT */
	if (zero == 0)
	{
#endif	/* MERIT_TIMELEFT */

		printf ("Merit AAA server %s, licensed software\n", verinfo (2));
		printf ("COPYRIGHT 1992, 1993, 1994, 1995, 1996, 1997, 1998\n");
		printf ("THE REGENTS OF THE UNIVERSITY OF MICHIGAN\n");
		printf ("ALL RIGHTS RESERVED\n");
		printf ("\n");

#ifdef BASIC_SERVER
		printf (
"PERMISSION IS GRANTED TO USE, COPY AND REDISTRIBUTE THIS VERSION OF THE MERIT\n");
		printf (
"BASIC AAA SERVER, SO LONG AS NO FEE IS CHARGED FOR THIS SOFTWARE, AND SO LONG\n");
		printf (
"AS THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND THE DISCLAIMER\n");
		printf (
"BELOW APPEAR IN ALL COPIES MADE; AND SO LONG AS THE NAME OF THE UNIVERSITY OF\n");
		printf (
"MICHIGAN OR MERIT NETWORK IS NOT USED IN ANY ADVERTISING OR PUBLICITY\n");
		printf (
"PERTAINING TO THE USE OR DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC,\n");
		printf (
"WRITTEN PRIOR AUTHORIZATION.\n");
		printf ("\n");
		printf (
"NO RIGHTS ARE GRANTED HEREUNDER FOR ANY RECIPIENT TO MODIFY, DISASSEMBLE,\n");
		printf (
"DECOMPILE, REVERSE ENGINEER OR OTHERWISE CREATE DERIVATIVE WORKS OF THIS\n");
		printf (
"SOFTWARE.\n");
		printf ("\n");
		printf (
"THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION FROM THE UNIVERSITY\n");
		printf (
"OF MICHIGAN AS TO ITS FITNESS FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE\n");
		printf (
"UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING\n");
		printf (
"WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n");
		printf (
"A PARTICULAR PURPOSE.  THE REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE\n");
		printf (
"LIABLE FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR\n");
		printf (
"CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT OF OR IN\n");
		printf (
"CONNECTION WITH THE USE OF THE SOFTWARE, EVEN IF IT HAS BEEN OR IS HEREAFTER\n");
		printf (
"ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n");
		printf ("\n");
		printf (
"FOR FURTHER INFORMATION ABOUT THE ENHANCED MERIT AAA SERVER, SEND EMAIL TO:\n");
		printf (
"aaa.license@merit OR, VISIT THE WWW SITE:  www.merit.edu/aaa/\n");
		printf ("\n");
#endif	/* BASIC_SERVER */

	}

#ifndef	MERIT_TIMELEFT
	if (argc == 1)
	{
		data.server = *argv;
	}
	else
	{
		radcheck_usage ();
	}
#else	/* MERIT_TIMELEFT */
	if (timeleft == 0) /* If no -Z option, act as normal radcheck client */
	{
		if (argc == 1)
		{
			data.server = *argv;
		}
		else
		{
			radcheck_usage ();
		}
	}
#endif	/* MERIT_TIMELEFT */

	if (dict_inited == 0)
	{
		dir_init ();

		if (dict_init () != 0)
		{
			exit (-1);
		}
		dict_inited = 1;
	}

	/*
	 *	Specify maximum number of times to issue request.
	 *	Number of retransmissions required shows up in retries.
	 */
	retries = max_retries;

	data.seq_nbr = 0;
	data.user_name = "TEST";
	data.password = "PW";
	data.fptype = 0;

#ifdef	SVR4
	if (sysinfo (SI_HOSTNAME, ourhostname, sizeof (ourhostname)) < 0)
	{
		perror ("SI_HOSTNAME");
		exit (-1);
	}
#else	/* Assume BSD */
	if (gethostname (ourhostname, sizeof (ourhostname)) < 0)
	{
		perror ("gethostname");
		exit (-1);
	}
#endif	/* SVR4 */

	if ((data.client_id = get_ipaddr (ourhostname)) == 0)
	{
		printf ("%s: Couldn't get our own IP address!\n", progname);
	}
	data.port_num = 1;

	data.ustype = PW_ADMINISTRATIVE_USER; /* was old PW_MANAGEMENT_POLL */
	if (new_old == 1) /* new style */
	{
		data.code = PW_STATUS_SERVER;
	}
	else /* old style */
	{
		data.code = PW_ACCESS_REQUEST;
	}

#ifdef	MERIT_TIMELEFT
	if (timeleft != 0)
	{
		vp = NULL_VP;
		avpair_add_vend (&vp, PW_PROXY_ACTION,
				"TIMELEFT", -1, VC_MERIT);
		strcpy (buf, getenv ("REMOTEHOST"));
		strtok (buf, "-");
		sscanf (buf, "%c%c%d", &p, &m, &num);
		sprintf (buf, "%c%c%d", p, m, num);
		ip_addr = get_ipaddr (buf);
		dns = (ip_addr == (UINT4) 0) ? 0 : 1 ; /* dns = 0 if addr = 0 */
		strcpy (buf, ip_hostname (ip_addr)); /* buf has full NAS name */
		avpair_add (&vp, PW_NAS_IDENTIFIER, buf , -1);
		ip_addr = get_ipaddr (getenv ("REMOTEIP"));
		avpair_add (&vp, PW_FRAMED_IP_ADDRESS, &ip_addr, 0);
		data.send_pairs = vp;
		hgserver[0] = '\0';
		result = parse_hg (buf, hgserver); /* one if have server name */
		if (result == 0) /* had trouble locating the server name */
		{
			printf ("Unable to determine time remaining");
			if (strstr (buf, "dialip.mich.net") == (char *) NULL &&
				dns == 1)
			{
				printf (", probably\n");
			}
			else /* was from pool or DNS problem */
			{
			 printf (".\nThis may be due to network problems or\n");
			 printf ("a configuration error.  It also may be\n");
			}
			printf ("because you are not telneting from a\n");
			printf ("PPP client which is directly connected to\n");
			printf ("a Network Access Server (NAS) \"%s\".\n",
				getenv ("REMOTEHOST"));

			sleep (30);
			exit (result);
		}
		data.server = hgserver;
	}
#endif	/* MERIT_TIMELEFT */

	msg[0] = '\0';
	result = send_server (&data, &retries, msg);
	send_server_done ();

#ifdef	MERIT_TIMELEFT
	if (debug_flag != 0 && timeleft != 0)
	{
		printf ("host was '%s'\n", getenv ("REMOTEHOST"));
		printf ("IP address was '%s'\n", getenv ("REMOTEIP"));
		printf ("huntgroup server was '%s'\n", data.server);
	}

	if (timeleft != 0)
	{
		if (result == OK_RC)
		{
			if (msg[0] != '\0')
			{
				if (strlen (msg) > 64) /* Then got too much! */
				{
					printf ("Timeleft processing error.\n");
					sleep (30);
					exit (result);
				}
				printf ("%s\n", msg);
				sleep (30);
			}
		}
		exit (result);
	}
#endif	/* MERIT_TIMELEFT */

	if (result == OK_RC)
	{
		if (msg[0] != '\0')
		{
			printf ("%s\n", msg);
		}
		printf ("\"%s(%u)\" is responding", data.server, data.svc_port);
		if (retries)
		{
			printf (" (%u retries)", retries);
		}
		putchar('\n');
	}
	else
	{
		if (msg[0] == '\0')
		{
			sprintf (msg, "RC = %i - Strange response!", result);
		}
		printf ("%s(%u): %s\n", data.server, data.svc_port, msg);
	}
	exit (result);
} /* end of main () */

#ifdef	MERIT_TIMELEFT

/*************************************************************************
 *
 *	Function: parse_hg
 *
 *	Purpose: Locate the huntgroup server for this NAS
 *
 *	Returns: 1, if the matching huntgroup server was placed in server,
 *		 or 0, otherwise.
 *
 *************************************************************************/

static int
parse_hg (given_nas, server)

char           *given_nas;	/* INPUT: the full name of a NAS */
char           *server;		/* OUTPUT: receives the huntgroup server */

{
	int             result = 0;
	int             found = 0;
	char           *nas;
	char           *ptr;
	char           *s;
	FILE           *hgfd;
	char            buffer[256];
	char            fname[MAXPATHLEN];

	/*
	 * Open the huntgroups file
	 */
	sprintf (fname, "%s/%s", radius_dir, RADIUS_HUNTGROUPS);

	if ((hgfd = fopen (fname, "r")) == (FILE *) NULL)
	{
		return result;
	}

	*server = '\0';		/* Initial state: No known server. */
	while (fgets (buffer, sizeof (buffer), hgfd) != (char *) NULL)
	{
		if (*buffer == COMMENT || isspace (*buffer))
		{
			continue;
		}

		if ((ptr = strtok (buffer, " \t\n\r")) == NULL)
		{
			continue;
		}

		if (strcasecmp (ptr, "nas") == 0) 
		{
			if (found == 1) /* keep looking for server */
			{
				continue;
			}

			if ((nas = strtok (NULL, " \t")) == (char *) NULL ||
				strlen (nas) >= AUTH_ID_LEN)
			{
				continue;
			}
 			else /* see if this NAS == given NAS */
			{
				if (strcasecmp (nas, given_nas) == 0)
				{
					found = 1;
					if (*server)
					{
						result = 1;
						break;
					}
				}
			}
			continue;
		}
		else if (strcasecmp (ptr, "server") == 0)
		{
			if (((s = strtok (NULL, " ,)\t\n\r")) != NULL) &&
				strlen (s) < MAXHOSTNAMELEN)
			{
				if (strcasecmp (s, "localserver") == 0)
				{
					s = ourhostname;
				}
				strcpy (server, s);
				if (found == 1)
				{
					result = 1;
					break;
				}
			}
		}
		else if (strcasecmp (ptr, "endgroup") == 0)
		{
			*server = '\0';
		}
		continue;

	} /* end of while () */

	fclose (hgfd);

	return result;
		
} /* end of parse_hg () */

#endif	/* MERIT_TIMELEFT */

static void
radcheck_usage ()

{
	printf ("Usage: %s [-d dir] [-p port] [-t timeout] [-r retries]\n",
		progname);
	printf ("\t[-g <huntgroup>] [-s subgroup_name]\n");
	printf ("\t[-x] [-n] [-v] servername\n");
	exit (-1);
} /* end of radcheck_usage () */
