#ifndef RADIUS_H
#define	RADIUS_H

/*
 *	RADIUS   Remote Authentication Dial In User Service
 *
 *	Livingston Enterprises, Inc.
 *	6920 Koll Center Parkway
 *	Pleasanton, CA   94566
 *
 *	Copyright 1992 Livingston Enterprises, Inc.
 *
 *	Permission to use, copy, modify, and distribute this software for any
 *	purpose and without fee is hereby granted, provided that this
 *	copyright and permission notice appear on all copies and supporting
 *	documentation, the name of Livingston Enterprises, Inc. not be used
 *	in advertising or publicity pertaining to distribution of the
 *	program without specific prior permission, and notice be given
 *	in supporting documentation that copying and distribution is by
 *	permission of Livingston Enterprises, Inc.
 *
 *	Livingston Enterprises, Inc. makes no representations about
 *	the suitability of this software for any purpose.  It is
 *	provided "as is" without express or implied warranty.
 *
 *
 *      Copyright (c) 1996 Ascend Communications, Inc.
 *      All rights reserved.
 *
 *      Permission to copy, display, distribute and make derivative works
 *      from this material in whole or in part for any purpose is granted
 *      provided that the above copyright notice and this paragraph are
 *      duplicated in all copies.  THIS SOFTWARE IS PROVIDED "AS IS" AND
 *      WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT
 *      LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *      FOR A PARTICULAR PURPOSE.
 *
 */

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 *
 *	$Id: radius.h,v 1.19 1998/07/10 16:33:12 web Exp $
 *
 */

#include        <time.h>
#include	"conf.h"
#include	"usr.h"

#ifdef ASCEND
#include	"ascend.h"
#endif	/* ASCEND */

#ifndef TRUE
#define	TRUE			1
#define	FALSE			0
#endif

#define	COMMENT			'#'	/* comment char for config files */
#define	WHITESPACES		" \t\n\r" /* white space chars for strtok() */

#ifndef ADD_STRING_HASH_SIZE
#define	ADD_STRING_HASH_SIZE	4363	/* add_string() table size, a prime */
#endif

#ifndef LIST_COPY_LIMIT
#define	LIST_COPY_LIMIT		512	/* Limit the number of items to copy. */
#endif

#ifndef AVPAIR_LIST_LENGTH_MAX
#define	AVPAIR_LIST_LENGTH_MAX	(list_copy_limit*40)	/* big enough... */
#endif

#define	AUTH_VECTOR_LEN		16
#define	AUTH_PASS_LEN		255	/* Long passwords now */
#define	AUTH_ID_LEN		64
#define	AUTH_STRING1_LEN	253	/* maximum of 253 (in V1) */
#define	AUTH_STRING2_LEN	2000    /* Up to 64k in V2 */

#define	RAD_RECV_BUFFER_SIZE	16536
#define	RAD_SEND_BUFFER_SIZE	16536

#define	FILTER_LEN		16
#define	NAME_LENGTH		32
#define	MAX_FSMID_LEN		20	/* Maximum length of %FSMID string */
#define	MAX_DICTID_LEN		20	/* Maximum length of %DICTID string */
#define	MAX_VENDID_LEN		20	/* Maximum length of %VENDORSID str. */

#define	RADIUS_V1		"V1"
#define	RADIUS_V2		"V2"
#define	VER1			1
#define	VER2			2
#define	HIVER			VER2	/* Current highest version */

typedef struct pw_auth1_hdr
{
	u_char          code;
	u_char          id;
	u_short         length;
	u_char          vector[AUTH_VECTOR_LEN];
	u_char          data[2];
} AUTH_HDR1;

#define	AUTH_HDR1_LEN		20

typedef struct pw_auth_hdr
{
	u_char          code;			/* PW_EXTENDED_FORMAT */
	u_char          flag_ver;		/* Flags and version */
	UINT2           length;			/* Including header */
	UINT2           id;			/* Message Identifier */
	UINT2           command;		/* Message type */
	u_char          vector[AUTH_VECTOR_LEN];/* Random value */
	u_char          mic[AUTH_VECTOR_LEN];	/* Message Integrity Code */
	u_char          data[2];		/* The attribute-value pairs */
} AUTH_HDR;

#define	AUTH_HDR_LEN		40

/* flag_ver definitions: */
#define	AUTH_HDR_VERSION_BITS	0x07	/* The version bits - Rest are flags */
#define	AUTH_HDR_TIMESTAMP	0x08	/* Timestamp present in vector */

/* V2 Timestamp definitions: */
#define	RECV_TIME_WINDOW 5 * 60	/* Accept messages within +/- of this window */

/* Version 2 transmitted attribute-value pair structure */
typedef struct pw_attr_hdr
{
	u_char		type[2];        /* The attribute */
	u_char		length[2];	/* Length of entire pair */
	u_char		flags;		/* Flag octet (Must and Vendor-Sp) */
	u_char		vendor_id[4];	/* Optional vendor id, if Vendor-Sp. */
} ATTR_HDR;

#define	ATTR_HDR_LEN	5	/* Non-Vendor-Specific attr. header length */

#define	MAX_SECRET_LENGTH		16
#define	CHAP_VALUE_LENGTH		16

#define	PW_AUTH_UDP_PORT		1645
#define	PW_ACCT_UDP_PORT		1646

/* For rlmadmin... */
#if !defined(RCS_BACKUP)
#  define RCS_BACKUP 0
#endif

#if !defined(RCS_CTRL)
#  define	RCS_CTRL	"/usr/local/bin/rcs"
#endif
#if !defined(RCS_CO)
#  define	RCS_CO		"/usr/local/bin/co"
#endif
#if !defined(RCS_CI)
#  define	RCS_CI		"/usr/local/bin/ci"
#endif

#define	PW_TYPE_STRING			0
#define	PW_TYPE_INTEGER			1
#define	PW_TYPE_IPADDR			2
#define	PW_TYPE_DATE			3

#ifdef BINARY_FILTERS
#define	PW_TYPE_FILTER_BINARY           4
#endif	/* BINARY_FILTERS */

#ifndef NO_EXTENDED_TYPES
#define	PW_TYPE_OCTETS			5
#define	PW_TYPE_VENDOR			6
#define	PW_TYPE_OCTET			7
#define	PW_TYPE_SHORT			8
#define	PW_TYPE_TAG_INT			9
#define	PW_TYPE_TAG_STR			10
#endif	/* EXTENDED_TYPES */

/* standard RADIUS codes */

#define	PW_ACCESS_REQUEST		1
#define	PW_ACCESS_ACCEPT		2
#define	PW_ACCESS_REJECT		3
#define	PW_ACCOUNTING_REQUEST		4
#define	PW_ACCOUNTING_RESPONSE		5
#define	PW_ACCOUNTING_STATUS		6
#define	PW_PASSWORD_REQUEST		7
#define	PW_PASSWORD_ACK			8
#define	PW_PASSWORD_REJECT		9
#define	PW_ACCOUNTING_MESSAGE		10
#define	PW_ACCESS_CHALLENGE		11
#define	PW_STATUS_SERVER		12
#define	PW_STATUS_CLIENT		13

#define	PW_FORWARDING			216
#define	PW_EXTENDED_FORMAT		254	/* This is the new stuff */
#define	PW_COMMAND_UNRECOGNIZED		256	/* V2 command not recognized */

#ifdef USR_CCA
#define	PW_RESOURCE_FREE_REQ		21
#define	PW_RESOURCE_FREE_RESP		22
#define	PW_RESOURCE_QUERY_REQ		23
#define	PW_RESOURCE_QUERY_RESP		24
#define	PW_ALT_RESOURCE_RECLAIM_REQ	25	/* USR NAS accepts 25 AND 265 */
#define	PW_NAS_REB_REQ			26
#define	PW_NAS_REB_RESP			27

/* V2 values for above ...
#define	PW_RESOURCE_FREE_REQ		261
#define	PW_RESOURCE_FREE_RESP		262
#define	PW_RESOURCE_QUERY_REQ		263
#define	PW_RESOURCE_QUERY_RESP		264
#define	PW_NAS_REB_REQ			267
#define	PW_NAS_REB_RESP			268
*/

#define	PW_RESOURCE_RECLAIM_REQ		265	/* see above (code number 25) */
#define	PW_RESOURCE_RECLAIM_RESP	266

#define	PW_CHANGE_FILTER_REQ		304
#define	PW_CHANGE_FILTER_ACK		305
#define	PW_CHANGE_FILTER_NAK		306
#endif	/* USR_CCA */

/* Merit reserved packet codes 400 to 499 */
#define	PW_ACCESS_ERROR			402
#define	PW_ACCOUNTING_ERROR		405


/* standard RADIUS attribute-value pairs */

#define	PW_USER_NAME			1	/* string */
#define	PW_USER_PASSWORD		2	/* string */
#define	PW_CHAP_PASSWORD		3	/* string */
#define	PW_NAS_IP_ADDRESS		4	/* ipaddr */
#define	PW_NAS_PORT			5	/* integer */
#define	PW_SERVICE_TYPE			6	/* integer */
#define	PW_FRAMED_PROTOCOL		7	/* integer */
#define	PW_FRAMED_IP_ADDRESS		8	/* ipaddr */
#define	PW_FRAMED_IP_NETMASK		9	/* ipaddr */
#define	PW_FRAMED_ROUTING		10	/* integer */
#define	PW_FILTER_ID		        11	/* string */
#define	PW_FRAMED_MTU			12	/* integer */
#define	PW_FRAMED_COMPRESSION		13	/* integer */
#define	PW_LOGIN_IP_HOST		14	/* ipaddr */
#define	PW_LOGIN_SERVICE		15	/* integer */
#define	PW_LOGIN_PORT			16	/* integer */
#define	PW_OLD_PASSWORD			17	/* string */ /* deprecated */
#define	PW_REPLY_MESSAGE		18	/* string */
#define	PW_LOGIN_CALLBACK_NUMBER	19	/* string */
#define	PW_FRAMED_CALLBACK_ID		20	/* string */
#define	PW_EXPIRATION			21	/* date */ /* deprecated */
#define	PW_FRAMED_ROUTE			22	/* string */
#define	PW_FRAMED_IPX_NETWORK		23	/* integer */
#define	PW_STATE			24	/* string */
#define	PW_CLASS			25	/* string */
#define	PW_VENDOR_SPECIFIC		26	/* vendor */
#define	PW_SESSION_TIMEOUT		27	/* integer */
#define	PW_IDLE_TIMEOUT			28	/* integer */
#define	PW_TERMINATION_ACTION		29	/* integer */
#define	PW_CALLED_STATION_ID		30	/* string */
#define	PW_CALLING_STATION_ID		31	/* string */
#define	PW_NAS_IDENTIFIER		32	/* string */
#define	PW_PROXY_STATE			33	/* string */
#define	PW_LOGIN_LAT_SERVICE		34	/* string */
#define	PW_LOGIN_LAT_NODE		35	/* string */
#define	PW_LOGIN_LAT_GROUP		36	/* string */
#define	PW_FRAMED_APPLETALK_LINK	37	/* integer */
#define	PW_FRAMED_APPLETALK_NETWORK	38	/* integer */
#define	PW_FRAMED_APPLETALK_ZONE	39	/* string */
#define	PW_CHAP_CHALLENGE		60	/* string */
#define	PW_NAS_PORT_TYPE		61	/* integer */
#define	PW_PORT_LIMIT			62	/* integer */
#define	PW_LOGIN_LAT_PORT		63	/* string */
#define	PW_TUNNEL_TYPE			64	/* string */
#define	PW_TUNNEL_MEDIUM_TYPE		65	/* string */
#define	PW_TUNNEL_CLIENT_ENDPOINT	66	/* string */
#define	PW_TUNNEL_SERVER_ENDPOINT	67	/* string */
#define	PW_ACCT_TUNNEL_CONNECTION	68	/* string */
#define	PW_TUNNEL_PASSWORD		69	/* string */
#define	PW_ARAP_PASSWORD		70	/* string */
#define	PW_ARAP_FEATURES		71	/* string */
#define	PW_ARAP_ZONE_ACCESS		72	/* integer */
#define	PW_ARAP_SECURITY		73	/* integer */
#define	PW_ARAP_SECURITY_DATA		74	/* string */
#define	PW_PASSWORD_RETRY		75	/* integer */
#define	PW_PROMPT			76	/* integer */
#define	PW_CONNECT_INFO			77	/* string */
#define	PW_CONFIGURATION_TOKEN		78	/* string */
#define	PW_EAP_MESSAGE			79	/* string */
#define	PW_SIGNATURE			80	/* string */
#define	PW_TUNNEL_PRIVATE_GROUP_ID	81	/* octets */
#define	PW_TUNNEL_ASSIGNMENT_ID		82	/* octets */
#define	PW_TUNNEL_PREFERENCE		83	/* octets */
#define	PW_ARAP_CHALLENGE_RESPONSE	84	/* string */
#define	PW_ACCT_INTERIM_INTERVAL	85	/* string */

/*	Accounting */

#define	PW_ACCT_STATUS_TYPE		40	/* integer */
#define	PW_ACCT_DELAY_TIME		41	/* integer */
#define	PW_ACCT_INPUT_OCTETS		42	/* integer */
#define	PW_ACCT_OUTPUT_OCTETS		43	/* integer */
#define	PW_ACCT_SESSION_ID		44	/* string */
#define	PW_ACCT_AUTHENTIC		45	/* integer */
#define	PW_ACCT_SESSION_TIME		46	/* integer */
#define	PW_ACCT_INPUT_PACKETS		47	/* integer */
#define	PW_ACCT_OUTPUT_PACKETS		48	/* integer */
#define	PW_ACCT_TERMINATE_CAUSE		49	/* integer */
#define	PW_ACCT_MULTI_SESSION_ID	50	/* string */
#define	PW_ACCT_LINK_COUNT		51	/* integer */
#define	PW_ACCT_INPUT_GIGAWORDS		52	/* integer */
#define	PW_ACCT_OUTPUT_GIGAWORDS	53	/* integer */
/* #define PW_ACCT_LINK_COUNT		54 */	/* unused */
#define	PW_ACCT_EVENT_TIME		55	/* date */

/*	Merit Experimental Extensions */

#define	PW_REPLY_IF_ACK_MESSAGE		144	/* string */
#define	PW_LAS_START_TIME		145	/* integer */
#define	PW_LAS_CODE			146	/* integer */
#define	PW_LAS_DURATION			147	/* integer */
#define	PW_LOCAL_DURATION		148	/* integer */
#define	PW_HUNTGROUP_SERVICE		149	/* string */
#define	PW_PORT_ENTRY			150	/* octets */
#define	PW_PROXY_ACTION			211	/* string */
#define	PW_TOKEN			213	/* string */
#define	PW_OWNERSHIP			219	/* integer */
#define	PW_SUBGROUP			220	/* string */
#define	PW_HUNTGROUP_NAME		221	/* string */
#define	PW_USER_ID			222	/* string */
#define	PW_USER_REALM			223	/* string */

/*	Configuration Only Attributes (for check-items) */

#define	CI_COMMENT			1024	/* string */
#define	CI_XVALUE			1025	/* integer */
#define	CI_XSTRING			1026	/* string */
#define	CI_AUTHENTICATION_TYPE		1027	/* integer */
#define	CI_PROHIBIT			1028	/* integer */
#define	CI_USER_CATEGORY		1029	/* string */
#define	CI_GROUP_NAME			1030	/* string */
#define	CI_ENCRYPTED_PASSWORD		1031	/* string */
#define	CI_EXPIRATION			1032	/* date */
#define	CI_USER_PASSWORD		1033	/* string */
#define	CI_SIMULTANEOUS_USE		1034	/* integer */
#define	CI_SERVER_NAME			1035	/* string */
#define	CI_ADDRESS_POOL_NAME		1036	/* string */
#define	CI_SERVICE_CLASS		1037	/* string */
#define	CI_DENY_MESSAGE			1038	/* string */

/*	Integer Translations */

/*	SERVICE TYPES	*/

#define	PW_LOGIN			1
#define	PW_FRAMED			2
#define	PW_CALLBACK_LOGIN		3
#define	PW_CALLBACK_FRAMED		4
#define	PW_OUTBOUND_USER		5
#define	PW_ADMINISTRATIVE_USER		6
#define	PW_SHELL_USER			7
#define	PW_AUTHENTICATE_ONLY		8
#define	PW_CALLBACK_ADMIN_USER		9

/*	FRAMED PROTOCOLS	*/

#define	PW_PPP				1
#define	PW_SLIP				2
#define	PW_ARA				3
#define	PW_GANDALF			4
#define	PW_XYLOGICS			5

/*	FRAMED ROUTING VALUES	*/

#define	PW_NONE				0
#define	PW_BROADCAST			1
#define	PW_LISTEN			2
#define	PW_BROADCAST_LISTEN		3

/*	FRAMED COMPRESSION TYPES	*/

#define	PW_VAN_JACOBSON_TCP_IP		1
#define	PW_IPX_HEADER_COMPRESSION	2

/*	LOGIN SERVICES	*/

#define	PW_TELNET			0
#define	PW_RLOGIN			1
#define	PW_TCP_CLEAR			2
#define	PW_PORTMASTER			3
#define	PW_LAT				4
#define	PW_X25_PAD			5
#define	PW_X25_T3POS			6

/*	TERMINATION ACTIONS	*/

#define	PW_DEFAULT			0
#define	PW_RADIUS_REQUEST		1

#ifdef USR_CCA
#define	PW_MANAGE_RESOURCES             2
#endif /* USR_CCA */

/*	AUTHENTICATION TYPES */

#define	AA_NONE		0	/* This is not a valid user name entry */
#define	AA_UNIX		1	/* Use local UNIX password file */
#define	AA_AKRB		2	/* AFS Kerberos type authentication */
#define	AA_MKRB		3	/* MIT Kerberos type authentication */
#define	AA_RAD		4	/* Pass to remote RADIUS server */
#define	AA_KCHAP	5	/* Kerberos CHAP authentication */
#define	AA_TACACS	6	/* Encrypted TACACS authentication */
#define	AA_REALM	7	/* Find given realm in authfile */
#define	AA_LOCAL	8	/* ??? XXX ??? */
#define	AA_FILE		9	/* User name and password list in a file */
#define	AA_TACPLUS	10	/* TACACS+ authentication */
#define	AA_ARADES	11	/* Ascend ARA DES authentication */
#define	AA_ACE		12	/* Ascend ARA DES authentication */
#define	AA_DEFENDER	13	/* Ascend smart card authentication */
#define	AA_SKEY		14	/* SKEY authentication */
#define	AA_ODBC		15	/* Database authentication */
#define	AA_ORACLE	16	/* Oracle authentication */
#define	AA_ALLOW	17	/* Allow all users of a realm. */
#define	AA_DENY		18	/* Deny all users of a realm. */
#define	AA_BLACKHOLE	19	/* Blackhole all requests for this realm. */
#define	AA_SLOW		20	/* Use param as realm to authenticate slowly. */
#define	AA_LDAP		21	/* LDAP authentication */
#define	AA_LOCAL_VPN	22	/* Locally defined VPN */
#define	AA_BSD		23	/* BSD Authentication */
#define	PW_AUTH_MAX	24	/* Highest authentication type */

/*	PROHIBIT PROTOCOL	*/

#define	PW_DUMB		0	/* 1 and 2 are defined in FRAMED PROTOCOLS */
#define	PW_AUTH_ONLY	3
#define	PW_ALL		255

/*	ACCOUNTING STATUS TYPES	*/

#define	PW_STATUS_START		1
#define	PW_STATUS_STOP		2
#define	PW_STATUS_ALIVE		3
#define	PW_STATUS_MODEM_START	4
#define	PW_STATUS_MODEM_STOP	5
#define	PW_STATUS_CANCEL	6
#define	PW_STATUS_ON		7
#define	PW_STATUS_OFF		8

/*	ACCOUNTING TERMINATION CAUSES	*/

#define	PW_USER_REQUEST		1
#define	PW_LOST_CARRIER		2
#define	PW_LOST_SERVICE		3
#define	PW_ACCT_IDLE_TIMEOUT	4
#define	PW_ACCT_SESSION_TIMEOUT	5
#define	PW_ADMIN_RESET		6
#define	PW_ADMIN_REBOOT		7
#define	PW_PORT_ERROR		8
#define	PW_NAS_ERROR		9
#define	PW_NAS_REQUEST		10
#define	PW_NAS_REBOOT		11
#define	PW_PORT_UNNEEDED	12
#define	PW_PORT_PREEMPTED	13
#define	PW_PORT_SUSPENDED	14
#define	PW_SERVICE_UNAVAILABLE	15
#define	PW_CALLBACK		16
#define	PW_USER_ERROR		17
#define	PW_HOST_REQUEST		18

/*	NAS PORT TYPES	*/

#define	PW_ASYNC		0
#define	PW_SYNC			1
#define	PW_ISDN_SYNC		2
#define	PW_ISDN_ASYNC_V120	3
#define	PW_ISDN_ASYNC_V110	4
#define	PW_VIRTUAL		5
#define	PW_PIAFS		6
#define	PW_HDLC_CLEAR_CHANNEL	7
#define	PW_X_25			8
#define	PW_X_75			9

/*	PROMPT VALUES	*/

#define	PW_NO_ECHO		0
#define	PW_ECHO			1

/*	ARAP ZONE ACCESS VALUES	*/

#define	PW_DEFAULT_ZONE		1
#define	PW_INCLUSIVE_FILTER	2
#define	PW_EXCLUSIVE_FILTER	4

/* Default Database File Names */

#ifndef RADIUS_DIR
#define	RADIUS_DIR		"/usr/private/etc/raddb"
#endif

#ifndef RADACCT_DIR
#define	RADACCT_DIR		"/usr/private/etc/radacct"
#endif

/*
 *	Note:	To change where these files go, do not change the#defines
 *		below, instead change the RADIUS_DIR#define above.
 */

#define	RADIUS_DICTIONARY	"dictionary"
#define	RADIUS_CLIENTS		"clients"
#define	RADIUS_USERS		"users"
#define	RADIUS_HOLD		"holdusers"
#define	RADIUS_LOG		"logfile"
#define	RADIUS_AUTH		"authfile"
#define	RADIUS_PID		"radiusd.pid"
#define	RADIUS_FSM		"radius.fsm"
#define	RADIUS_DEBUG		"radius.debug"
#define	RADIUS_VENDORS          "vendors"

#ifndef RAD_READ_MODE
#define	RAD_READ_MODE		0644		/* f/chmod() access */
#endif

#ifndef RAD_LOG_MODE
#define	RAD_LOG_MODE		0640		/* f/chmod() access */
#endif

#ifndef RADIUS_LOG_FMT

#ifdef Y2K
#define	RADIUS_LOG_FMT		"logfile.%Y%m%d" /* logfile.yyyymmdd */
#else	/* Y2K */
#define	RADIUS_LOG_FMT		"logfile.%y%m%d" /* logfile.yymmdd */
#endif	/* Y2K */

#endif	/* RADIUS_LOG_FMT */

#ifndef RAD_DEBUG_MODE
#define	RAD_DEBUG_MODE		0600		/* f/chmod() access */
#endif

#ifndef RAD_LOG_DEFAULT_AATV
#define	RAD_LOG_DEFAULT_AATV	rad_log_v2_0_aatv
#endif

#ifndef RAD_LOG_DEFAULT_FMT
#define	RAD_LOG_DEFAULT_FMT	"session.%Y-%m-%d.las"
#endif

#ifndef	RAD_GZCAT
#define	RAD_GZCAT		"/usr/local/bin/gzcat"
#endif

#ifndef	RAD_ZCAT
#define	RAD_ZCAT		"/usr/ucb/zcat"
#endif

#ifndef	RAD_GZIP
#define	RAD_GZIP		"/usr/local/bin/gzip"
#endif

/* define GZIP_ARGS to pass non-file arguments to RAD_GZIP program */
/*#define	GZIP_ARGS	" -9 " */

#ifndef RAD_COMPRESS
#define	RAD_COMPRESS		"/usr/ucb/compress"
#endif

/* define COMPRESS_ARGS to pass non-file arguments to RAD_COMPRESS program */
/*#define	COMPRESS_ARGS		" -9 " */

#ifndef RADIUS_LOCALSERVER
#define	RADIUS_LOCALSERVER	"localserver"
#endif

#ifndef DEFAULT_REALM
#define	DEFAULT_REALM		"DEFAULT"
#endif

#ifndef NULL_REALM
#define	NULL_REALM		"NULL"
#endif

/* Server data structures */

typedef struct dict_attr
{
	char             *name;		/* attribute name */
	int               value;	/* attribute index number */
	int               type;		/* string, int, etc. */
	UINT4             vendor_id;	/* vendor OID or 0 */
	int               flags;	/* Attribute flags */
	struct vendor    *vendor_ptr;	/* pointer to VENDOR structure */
	struct dict_attr *next;		/* Global list */
	struct dict_attr *vnext;	/* Vendor list */
} DICT_ATTR;

#define	NULLDA	((DICT_ATTR *) NULL)

/* Definition of DICT_ATTR flags */
#define	ATTR_ACK_NONE	0x000100	/* None in ACK */
#define	ATTR_ACK_ONE	0x000200	/* Only one in ACK */
#define	ATTR_NAK_NONE	0x000400	/* None in NAK */
#define	ATTR_NAK_ONE	0x000800	/* Only one in NAK */
#define	ATTR_CONFIG	0x001000	/* Only a Configuration attribute */
#define	ATTR_NOLOG	0x002000	/* Attribute never gets logged */
#define	ATTR_ENCAPS	0x004000	/* MUST encapsulate this attribute. */
#define	ATTR_RO_FLAGS	0x00FF00	/* Don't modify these flags */
#define	ATTR_LOGGED	0x010000	/* Has this attribute been logged? */

/* Flags sent in packet */
#define	ATTR_MUST	0x000001	/* Receiver MUST know this attribute */
#define	ATTR_VEND_SP	0x000080	/* Vendor Specific indicator */

typedef struct dict_value
{
	char              *name;	/* Value name */
	UINT4              dv_value;
	char              *attrname;	/* corresponding attribute */
	int		   attrnum;	/* Attribute number */
	struct vendor     *vendor_ptr;	/* pointer to VENDOR structure */
	struct dict_value *next;	/* Global list */
	struct dict_value *vnext;	/* Vendor list */
} DICT_VALUE;

#define	NULLDV	((DICT_VALUE *) NULL)

typedef struct dict_attr_list
{
	struct dict_attr_list *next;
	DICT_ATTR             *ap;
} DICT_ATTR_LIST;

typedef struct value_pair
{
	int                attribute;	/* Attribute num. of this value_pair */
	DICT_ATTR         *ap;		/* Pointer to dictionary attrib entry */
	UINT4              lvalue;	/* For type==string, the string's len */
	char              *strvalue;	/* Pointer to string */
	int                strsize;	/* Length of string storage block */
	int                flags;	/* Flags to control logging, etc. */
	u_char             tag;		/* For tagged attributes, the tag. */
	struct value_pair *next;
} VALUE_PAIR;

#define	NULL_VP	((VALUE_PAIR *) NULL)

/* Definition of VALUE_PAIR flags */
#define	VPF_LOGGED	0x01		/* Has this value pair been logged? */
#define	VPF_ENCAPS	0x02		/* Was it encapsulated when received? */

typedef struct vp_string
{
	int		usecnt;		/* Number of VALUE_PAIRS using this */
	char		string[2];	/* The string data */
} VP_STRING;

#define	VPSTR_HDR_LEN sizeof (int) 	/* Size of VP_STRING header */
#define	VPSTR_MIN 8	 /* Smallest block we allocate for value_pair string */

typedef struct auth_req
{
	UINT4             ipaddr;           /* IP address of requestor */

#ifdef USR_CCA
	UINT4             nas_ip;           /* Used only with Resource Query */
					     /* ... Requests and Responses.  */
	char              type;             /* Parent, Child, or Proxy Query */
	int               qry_count;
#endif /* USR_CCA */

	u_short           udp_port;         /* UDP reply socket of requestor */
	u_short           code;             /* Type of RADIUS packet */
	u_short           rcv_len;          /* Length of received packet. */
	u_short           rep_id;           /* Original request seq. number */
	u_short           fwd_id;           /* Locally generated seq. number */
	u_char            repvec[AUTH_VECTOR_LEN]; /* Original vector (reply) */
	u_char            fwdvec[AUTH_VECTOR_LEN]; /* Forwarding vector (V1) */
	char             *realm_filter;
	struct client_ent *client;          /* Pointer to Client Entry */
	int               repstatus;        /* Determines final request value */
	int               fsmstatus;        /* Result of previous AATV action */
	int               cur_count;        /* Original number request pairs */
	time_t            onqueue;          /* Epoch when request was queued */
	time_t            starthg;          /* Epoch when request starts HGAS */
	time_t            startlas;         /* Epoch when request entered LAS */
	time_t            free_end;         /* When to remove from freed queue */
	u_char            vers_in;          /* Version number received */
	u_char            vers_out;         /* Version number sent */
	u_char            flags;            /* Received flags bits */
	u_char            ttlslice;         /* Holds time-to-live init value */
	u_char            ttl;              /* Global queue time-to-live secs */
	u_char            timer;            /* General utility timer */
	u_char            retry_cnt;        /* Counter for duplicate requests */
	u_char            retry_limit;      /* Zero ==> allow infinite number */
	u_char            seqch_cnt;        /* Count sequence number changes */
	u_char            seqch_limit;      /* Zero ==> allow infinite number */
	u_char            state;            /* State of current request */
	u_char            sws;              /* Switches, flags, etc. */
	u_char            debug_flag;       /* Special debugging */
	struct aatv      *fsm_aatv;         /* Pointer to current FSM action */
	struct aatv      *direct_aatv;      /* Pointer to actual action */
	struct event_ent *event_q;          /* Pointer to active event queue */
	struct event_ent *freed_events;     /* Free'd events being held */
	struct proc_ent  *proc_q;           /* Pointer to fork process queue */
	struct auth_req  *next;             /* Global request queue link */
	struct auth_req  *p_prev;           /* Pointer to what points to this */
	VALUE_PAIR       *request;          /* Original client a/v pairs */
	VALUE_PAIR       *cur_request;      /* Represents current a/v pairs */
	VALUE_PAIR       *user_check;       /* List of users file check items */
	VALUE_PAIR       *user_deny;        /* List of users file deny items */
} AUTH_REQ;

typedef struct auth_req_q
{
	struct auth_req_q *next;	/* Next in list of queues. */
	char            *q_name;	/* Name of queue "auth", "acct", etc.*/
	int              max;		/* Maximum queue size observed. */
	int              cur;		/* Current queue size */
	int              cur_freed;	/* Current freed queue size */
	u_short          limit;		/* Queue size limit. */
	u_short          ident;		/* Sequence number on queue. */
	time_t           max_time;	/* When was the max queue size hit? */
	time_t           hold;		/* How long to hold on freed queue */
	AUTH_REQ        *q;		/* The head of the queue. */
	AUTH_REQ       **p_q_end;	/* Pointer to the 'next' of the end */
	AUTH_REQ        *freed;		/* Free'd authreq's being held */
	UINT4            q_ok;		/* How many were queue'd OK? */
	UINT4            q_fail;	/* How many couldn't be queued? */
	UINT4            q_dup;		/* How many were matched? */
	UINT4            q_freed;	/* How many were queued to be freed? */
	UINT4            dq_freed;	/* How many were dequeued from freed */
	UINT4            c_free_authreq; /* How many calls to free_authreq() */
	UINT4            c_free_authreq_final; /* ditto, free_authreq_final() */
} AUTH_REQ_Q;

typedef struct event_ent	/* This is the so-called waldo structure. */
{
	struct event_ent  *next;	/* Next one for same authreq */
	AUTH_REQ          *auth_head;	/* pointer back to authreq structure */
	struct event_ent  *client_next;	/* next one for same client */
	struct event_ent **client_prev;	/* previous pointer for same client */
	struct client_ent *client;	/* the client we're waiting for */
	struct aatv       *fsm_aatv;	/* record action from FSM table */
	struct aatv       *sub_aatv;	/* save AATV when request was issued */
	struct aatv       *direct_aatv;	/* saved from authreq */
	time_t             queued_t;	/* When was this one queued? */
	u_char            *packet;	/* copy of request packet sent */
	u_char            *freed_packet; /* free'd packet. */
	int                len;		/* length of packet */
	int                freed_len;	/* Length of (freed) packet. */
	pid_t              pid;		/* AA_FORK: pid, AA_SOCKET: == zero */
	struct sockaddr_in sin;		/* socket info for packet re-sending */
	int                evalue;	/* AATV act_func integer argument */
	u_char             state;	/* state where the request was issued */
	char               action[NAME_LENGTH+1]; /* "cmd" arg to radius_send */
	char               estring[AUTH_ID_LEN]; /* AATV act_func string arg */
} EVENT_ENT;

/* Structure for deferred fork or fork-reply */
typedef struct proc_ent
{
	struct proc_ent   *next;	/* pointer to next entry on authreq */
	struct auth_req   *authreq;	/* pointer to authreq */
	struct proc_ent   *aatv_next;	/* next one for same AATV */
	struct proc_ent  **aatv_prev;	/* previous pointer for same AATV */
	struct aatv       *sub_aatv;	/* the AATV we're waiting for */
	struct aatv       *fsm_aatv;	/* record action from FSM table */
	struct aatv       *direct_aatv;	/* saved from authreq */
	time_t             queued_t;	/* When was this one queued? */
	int                evalue;	/* AATV act_func integer argument */
	u_char             state;	/* state where the request was issued */
	char               estring[AUTH_ID_LEN]; /* AATV act_func string arg */
} PROC_ENT;

typedef struct user_ent
{
	struct user_ent *next;
	char            *name;
	VALUE_PAIR      *check;
	VALUE_PAIR      *deny;
	VALUE_PAIR      *reply;

#ifdef USR_CCA
	int              sessions; /* number of simultaneous login sessions
				      allowed */
	int              count;   /*  count of current active sessions */
	char            *pool_name; /* Name of pool from which
				       this user must be assigned addresse */
#endif /* USR_CCA */

} USER_ENTRY;

#ifdef MERIT_LAS
typedef struct lasrealm_ent *LAS_REALM;
#endif	/* MERIT_LAS */

typedef struct auth_ent
{
	struct auth_ent *next;
	char            *name;
	struct auth_ent *parent;
	char            *host;
	char            *filter;
	int              prot;
	int              type;

#ifdef MERIT_LAS
	LAS_REALM        las_realm;
#endif	/* MERIT_LAS */

#ifdef USR_CCA
	struct vpn_info   *vpn;
	struct ip_address *dns_info;
	struct ip_address *nbns_info;
#endif /* USR_CCA */

} AUTH_ENTRY;

/* The following must match the beginning of the auth_ent structure */
typedef struct auth_aent
{
	struct auth_ent *next;
	char            *name;
	struct auth_ent *parent;
} AUTH_ALIAS_ENTRY;

typedef struct linklist_entry
{
	struct linklist_entry *next;	/* pointer to next entry in list */
} LINKLIST_ENT, *LINKLIST;

#define	numbof(X)	(sizeof(X)/sizeof(X[0]))

typedef struct name_list
{
	struct name_list  *next;
	char              *name;
	u_char             flag;
	u_short            num;
} NAME_LIST;

/*	Binary port entry structure used in Port-Entry attribute */

#define	PORT_ENTRY_VERSION	0	/* Increase if change structure here */

typedef struct bin_port_ent
{
	u_char             version;	/* Be sure to use PORT_ENTRY_VERSION */
	u_char             port_source;	/* Zero => was HGAS, one => otherwise */
	time_t             start_time;	/* Start time of session on this port */
	UINT4              port_nbr;	/* Port number of this session */
	UINT4              duration;	/* Session length (seconds) */
} BIN_PORT_ENT;

typedef struct vendor
{
	char              *name;	/* Vendor name */
	char              *attr_name;	/* <vendor-ATTRIBUTE> string */
	char              *value_name;	/* <vendor-VALUE> string */
	UINT4              id;		/* Vendor OID */
	struct dict_attr  *attrs;	/* List of vendor specific. attrs. */
	struct dict_value *values;	/* List of vendor specific. values. */
	struct vend_map   *map;		/* Pointer to kludge attr. mappings */
	struct vendor     *next;
} VENDOR;

typedef struct vendor_list
{
	struct vendor_list *next;	/* Next vendor for this client. */
	VENDOR             *vep;
} VENDOR_LIST;

#define	VC_RADIUS			0
#define	VC_MERIT			61

#if !defined(DEFAULT_VENDOR_ID)
#define	DEFAULT_VENDOR_ID	VC_MERIT
#endif	/* DEFAULT_VENDOR_ID */

/* Vend_map used to map between abused standard attrs. and vendor specific */
typedef struct vend_map
{
	UINT4              vid;		/* Vendor ID */
	u_char             s_attr[256]; /* From standard to vend. spec. */
	u_char             v_attr[256];	/* From Vend. spec. to standard */
} VENDOR_MAP;


#ifdef USR_CCA
typedef struct vpn_info
{
	UINT4              id;
	struct vpn_router *router;
	u_short            type;	/* Router type */
	char              *name;
} VPN_INFO;

typedef struct vpn_router
{
	char              *hostname;
	UINT2              tunnel_refresh; /* Used only with VPN-Gateway type */
	char               tunnel_present; /* Indicate tunnel_refresh valid */
	struct vpn_router *next;
} VPN_ROUTER;

typedef struct assigned_ip
{
	struct user_ent   *user_ent;   /* Points to user entry in users file */
	UINT4              ip_address; /* IP address assigned to user */
	UINT4              nas_ip;     /* IP address of user's NAS */
	UINT4              nas_port;   /* NAS Port of user's NAS */
	struct assigned_ip *next;
} ASSIGNED_IP;

typedef struct address_pool
{
	char              *name;
	UINT4              ip_address; /* base IP address in this pool */
	UINT4              netmask;    /* netmask to use with this pool */
	UINT4              network;    /* network part of address pool */
	int                range;      /* range of this pool */
	int                count;      /* number of pool addresses assigned */
	ASSIGNED_IP       *user_q;     /* list of users with pool addresses */
	struct address_pool *next;     /* pointer to the next pool */
} ADDR_POOL;

#endif /* USR_CCA */

/*
 * Use the following to specify default "realm" names to use for
 * authentication-type entries of RADIUS or TACACS that may be
 * configured in the "users" file.  May be configured globally
 * in the Makefile or changed in the authfile on a running server.
 */

#ifndef DEFAULT_RADIUS_SERVER
#define	DEFAULT_RADIUS_SERVER ""
#endif

#ifndef DEFAULT_TACACS_SERVER
#define	DEFAULT_TACACS_SERVER ""
#endif

/******************************************************************
 *
 *      PW_PROTTYPE & PW_PROTTYPES - define authentication protocol allowed
 *                                   for particular realm entry in authfile.
 *
 *      The PW_PROTTYPE value is stored in the auth_ent.prot field.
 *      The PW_PROTTYPE value corresponds to the order of PW_PROTTYPES.
 *
 *****************************************************************/

#define	PW_PROTTYPE_DFLT	0	/* Use this entry for any protocol */
#define	PW_PROTTYPE_CHAP	1	/* Entry is for CHAP style authent. */
#define	PW_PROTTYPE_PW		2	/* Entry is for id/pw style authent. */
#define	PW_PROTTYPE_HASDOT	3	/* Entry is for user.name authent. */

#define	PW_PROTTYPES_DFLT	"DEFAULT"
#define	PW_PROTTYPES_CHAP	"CHAP"
#define	PW_PROTTYPES_PW		"PW"
#define	PW_PROTTYPES_HASDOT	"HASDOT"

typedef struct file_list
{
	struct file_list       *next;
	char                   *prefix;
	USER_ENTRY             *user_list;
	AUTH_ENTRY             *auth_list;

#ifdef USR_CCA
	struct address_pool    *pool_list;
#endif	/* USR_CCA */
} FILE_LIST;

typedef struct ip_address
{
	struct ip_address *next;
	struct in_addr     ipaddr;
} IP_ADDRESS;

typedef struct dns_name
{
	struct dns_name   *next;
	u_char             type;	/* 0 = official name, 1 = alias */
	char               name[1];
} DNS_NAME;

typedef struct client_ent
{
	struct client_ent *next;
	IP_ADDRESS        *addrs;
	char              *secret;
	char              *file_pfx;
	char              *hostname;
	DNS_NAME          *names;
	VENDOR_LIST       *veps;	/* Pointer to VENDOR_LIST NAS/server */
	struct event_ent  *event_q;	/* Events waiting for this client */
	time_t             expire_time;
	UINT2              auth_port;   /* UDP port to send auth to (if != 0) */
	UINT2              acct_port;   /* UDP port to send acct to (if != 0) */
	enum
	{
		IP_DNS,
		IP_NUMERIC,
		IP_OURADDR
	}                  type;
	UINT4              client_type; /* CE_DAS, CE_NAS, CE_PROXY, CE_FRGW */
	u_char             reply_holdtime; /* Default hold time of replies */
	u_char             version;	/* RADIUS Version client supports */
	u_char             flags;	/* Flag bits for this client */

#ifdef USR_CCA
	u_char             state;	/* Has this client responded to ... */
					 /* ... the resource query request? */
#endif	/* USR_CCA */

} CLIENT_ENTRY;

/* The following define the possible host types in the clients entry */

#define	CE_DAS			0x000001 /* USR */
#define	CE_NAS			0x000002 /* Network Access Server */
#define	CE_PROXY		0x000004 /* Client is RADIUS server */
#define	CE_FRGW			0x000008 /* USR */
#define	CE_NEIGHBOR		0x000010 /* USR */
#define	CE_RAD_RFC		0x000020 /* Conforms with RADIUS RFC */
#define	CE_ACCT_RFC		0x000040 /* Conforms with Accounting RFC */
#define	CE_DEBUG		0x000080 /* Dump packets in and out, if debug */
#define	CE_APPEND		0x000100 /* Add only new attributes from reply */
#define	CE_OLDCHAP		0x000200 /* This machine does pre-RFC CHAP */
#define	CE_DUMMY		0x000400 /* This is a dummy entry. */
#define	CE_NOENCAPS		0x000800 /* Don't encapsulate vendor response. */
#define	CE_HGAS1		0x001000 /* HGAS flag #1 */
#define	CE_HGAS2		0x002000 /* HGAS flag #2 */
#define	CE_HGAS3		0x004000 /* HGAS flag #3 */
#define	CE_HGAS4		0x008000 /* HGAS flag #4 */
#define	CE_LAS1			0x010000 /* LAS flag #1 */
#define	CE_LAS2			0x020000 /* LAS flag #2 */
#define	CE_LAS3			0x040000 /* LAS flag #3 */
#define	CE_LAS4			0x080000 /* LAS flag #4 */
#define	CE_CHECK_ALL		0x100000 /* Check all attributes */
#define	CE_NO_CHECK	        0x200000 /* Don't check all attributes */

/* client_entry flags definition: */

#define	CLIENT_NO_TS	1	/* Don't issue V2 Timestamps to this guy */

#define	dprintf(lev, args) { if (debug_flag >= lev) logit args; }
#define	ddumpx(lev, args)  { if (debug_flag > lev) dumpit args; }

/* 	Define return codes from "SendServer" utility */

#define	BADRESP_RC	-2
#define	ERROR_RC	-1
#define	OK_RC		0
#define	TIMEOUT_RC	1

typedef struct send_data /* Used to pass information to sendserver() function */
{
	int		version;	/* RADIUS version number to send */
	u_short         code;		/* RADIUS packet code */
	u_short         seq_nbr;	/* Packet sequence number */
	char           *user_name;
	char           *password;	/* Cleartext user password */
	int             ustype;		/* Service-Type attribute */
	u_char          fptype;		/* Framed-Protocol attribute */
	char           *server;		/* Name/addrress of RADIUS server */
	int             svc_port;	/* RADIUS protocol destination port */
	int             timeout;	/* Session timeout in seconds */
	UINT4           client_id;	/* IP address of client */
	int             port_num;	/* Port number on client */
	char           *user_file;	/* Users style file of a/v pairs */
	char           *group;
	int             arades;		/* 0 ==> no ARA DES, 1 ==> ARA DES */
	int             challenge;	/* 1 ==> append state information */
	VALUE_PAIR     *send_pairs;     /* More a/v pairs to send */
	VALUE_PAIR     *receive_pairs;  /* Where to place received a/v pairs */
	int             result;		/* Return value */
} SEND_DATA;

/*	Handle older syslog versions, too! */

#ifndef	LOG_CONS
#define	LOG_DAEMON		0
#define	LOG_AUTH		0
#endif

#define	MGMT_POLL_SECRET	"Hardlyasecret"

#ifndef MAX_AUTH_REQUESTS
#define	MAX_AUTH_REQUESTS	200
#endif

#ifndef MAX_ACCT_REQUESTS
#define	MAX_ACCT_REQUESTS	400
#endif

#define	MAX_REQUEST_TIME	30	/* Lifetime of a request (seconds) */
#define	MAX_ACCT_REQUEST_TIME	MAX_REQUEST_TIME * 6 /* For build_acct_req() */
#define	CLEANUP_DELAY		6	/* Hold onto old requests this long */
#define	CLEANUP_BUCKETS		100	/* Remember this many replies. */
#define	DEFAULT_INETD_TIMEOUT	15	/* Fifteen minutes by default */
#define	DEFAULT_TIMER_VALUE	3	/* Three seconds by default */
#define	ADDRESS_AGING		60*60	/* One hour by default */
#define	DFLT_TACACS_UDP_PORT	49	/* Default TACACS server port */
#define	DFLT_TACACS_TCP_PORT	49	/* Default TACACS+ server port */
#define	SESS_ID_LEN		8	/* Session identifier length */
#define	SECONDS_PER_DAY		86400
#define	DNS_SLEEP		100	/* Time which DNS sub-process sleeps. */
#define	MAX_ALIAS		3	/* Number of DNS aliases (CNAMES) */
#define	MAX_AUTH_ALIAS		5	/* Number of REALM aliases (authfile) */
#define	ARA_PASS_LEN		8	/* Maximum length of ARA DES password */
#define	CLIENT_LOOP		100	/* Prevent loops reading clients file */

#ifdef USR_CCA
#define	RF_REQ_RETRIES  5       /* Number of retries */
#define	RF_REQ_TIMER    2       /* Time in seconds between retries */
#define	RQUERY_TIMER    10      /* Ditto for Resource Query Request retries */
#define	RQUERY_RETRIES  2
#define	NAS_REB_RETRY   2       /* Retries to forward the NAS Reboot request */
#define	NAS_REB_TIMER   10 
#endif	/* USR_CCA */

typedef enum				/* error code */
{
	EC_OK,				/* no error */
	EC_INTERNAL,			/* internal error */
	EC_CONFIG,			/* configuration error */
	EC_NO_MEMORY,			/* out of memory */
	EC_CREATE_FILE,			/* error creating file */
	EC_NO_TOKEN,			/* no token available */
	EC_NO_PORTS,			/* no ports available for guests */
	EC_TOO_MANY_SESSIONS,		/* user has too many sessions */
	EC_ABS_FAILURE,			/* ABS failed (with message) */
	EC_NO_BALANCE,			/* error querying for balance */
	EC_BAD_BALANCE			/* balance too low */
} ERRORCODE;

typedef enum				/* accounting code */
{
	AC_TEXT		= -3,		/* LAS-Code in text */
	AC_INIT		= -2,		/* initial state */
	AC_ERROR	= -1,		/* no accounting code */
	AC_NORMAL,			/* disconnect normally*/
	AC_REJECT,			/* rejected by this server */
	AC_CANCEL,			/* access rejected by someone */
	AC_NOCONFIRM,			/* no confirmation */
	AC_OVERTIME,			/* session over maximum time allowed */
	AC_UNKNOWN,			/* session killed for unknown reason */
	AC_NOTOKEN,			/* rejected because no token */
	AC_NOTLOCAL,			/* session not local */
	AC_SUSPEND,			/* session suspended */
	AC_FAILED,			/* authentication failed */
	AC_AUTHORIZED,			/* session authorized (for stats) */
	AC_NASREBOOT,			/* released due to NAS reboot */
	AC_REMOTE,			/* remote session, failed to forward */
	AC_DUPLICATE,			/* may be duplicate accounting record */
	AC_COLLISION,			/* session collided with another */
	AC_STOP,			/* Accounting-Stop received */
	AC_NASRESTART,			/* Accounting restart message */
	AC_NUMBOFCODE			/* number of accounting code */
} ACCTCODE;

#define	STATUSTEXT			\
		"[Init]",		\
		"[Error]",		\
		"Normal",		\
		"Reject",		\
		"Cancel",		\
		"Noconfirm",		\
		"Overtime",		\
		"Unknown",		\
		"Notoken",		\
		"Notlocal",		\
		"Suspend",		\
		"Failed",		\
		"Authorized",		\
		"NASreboot",		\
		"Remote",		\
		"Duplicate",		\
		"Collision",		\
		"Stop",			\
		"NASrestart"

typedef union action_u
{
	struct aatv    *aatv;	/* points to the id field of an AATV */
	char           *proxy;	/* pointer to a Proxy-Action string */
} UACTION;

/*	Define event structure (for events generated by AATV recv functions */

typedef struct ev
{
	u_char          state;
	union action_u  a;
	int             isproxy;	/* set to one if action "a" is proxy */
	int             value;
	char            xstring[AUTH_ID_LEN];
} EV;

typedef struct mf_entry		/* Structure for malloc() and free() counters */
{
	UINT4             m;	/* Counter for malloc()/calloc() calls */
	UINT4             f;	/* Counter for free()/cfree() calls */
} MF_ENT;

extern MF_ENT	dns_name_mf;
extern MF_ENT	dns_addr_mf;
extern MF_ENT	dns_client_mf;
extern MF_ENT	vp_mf;

typedef struct packet_counts
{
	struct packet_counts *next;     /* Linked list of all known */
	char             *name;		/* A name for this counter */
	unsigned int      packets;	/* packets done with. */
	u_long            octets;	/* octets transmitted. */
	u_long            actions;	/* Other actions performed */
} PACKET_COUNTS;

/* Used to count non-engine AATV transmissions and receptions. */
extern PACKET_COUNTS stat_etc_xmit;
extern PACKET_COUNTS stat_etc_rcvd;

extern u_short list_copy_limit;	/* A limit for list_copy() */

/*	Define aatvfunc_type codes */ 

#define	AA_DIRECT	0	/* Function gives direct reply */
#define	AA_SOCKET	1	/* Deferred reply returned on socket */
#define	AA_FORK		2	/* Spawn a process to wait for reply */
#define	AA_FREPLY	3	/* Fork & get reply on server socket */

typedef struct aatv
{
	u_char       id[NAME_LENGTH + 1];
	char         authen_type; /* a -1 value indicates built-in AATV types */
	u_char       aatvfunc_type;
	void       (*init) PROTO((struct aatv *));
	int        (*timer) PROTO((void));
	int        (*act_func) PROTO((AUTH_REQ *, int, char *));
	AUTH_REQ * (*recv) PROTO((int, struct sockaddr_in *, UINT4, u_int, EV *));
	void       (*cleanup) PROTO((void));
	UINT4        sockfd;
	u_short      proc_max;		/* Configured maximum number of forks */
	u_short      proc_cnt;		/* Current number of forked processes */
	u_short      proc_cnt_hi;	/* High water mark for proc_cnt */
	u_short      proc_q_cur;	/* Current number queued in proc_q */
	u_short      proc_q_hi;		/* High water mark for proc_q_cur */
	time_t       proc_cnt_hi_t;	/* When did this occur? */
	time_t       proc_q_hi_t;	/* When did proc_cnt_hi occur? */
	time_t       proc_q_last;	/* Last time one was queued. */
	PROC_ENT    *proc_q;		/* proc_max caused queue of requests */
} AATV, *AATVPTR;

#define	DEF_AATV_DIRECT(id,act_func)	DEF_AATV_DIRECT_TYPE(id,-1,act_func)
  
#define	DEF_AATV_DIRECT_TYPE(id,authen_type,act_func) 	\
	DEF_AATV_DIRECT_FULL(id,authen_type,NULL,NULL,act_func,NULL)

#define	DEF_AATV_DIRECT_CFG(id,init_func,act_func,term_func) \
	DEF_AATV_DIRECT_FULL(id,-1,init_func,NULL,act_func,term_func)

#define	DEF_AATV_DIRECT_FULL(id,authen_type,init_func,timer_func,act_func,cleanup_func) {	\
	id,			/* Name of AATV */			\
	authen_type,		/* What kind of authentication? */	\
	AA_DIRECT,		/* aatvfunc_type code */		\
	init_func,		/* How we startup. */			\
	timer_func,		/* Timer function. */			\
	act_func,		/* Action function. */			\
	NULL,			/* No recv() function. */		\
	cleanup_func,		/* How we cleanup. */			\
	0,			/* No socket to speak of. */		\
	0, 			/* Configured maximum (N/A) */		\
	0,			/* Number of forked processes (N/A) */	\
	0, 0, 0, 0, 0, 0,	/* proc_cnt_hi, proc_q_hi, etc. */	\
	NULL }			/* Queue of requests (N/A) */

#define	DEF_AATV_FORK(id,act_func,max) DEF_AATV_FORK_TYPE(id,-1,act_func,max)

#define	DEF_AATV_FORK_TYPE(id,authen_type,act_func,max)	\
	DEF_AATV_FORK_TYPE_FULL(id,authen_type,NULL,act_func,max)

#define	DEF_AATV_FORK_TYPE_FULL(id,authen_type,init_func,act_func,max) { \
	id,			/* Name of AATV */			\
	authen_type,		/* Non-builtin type. */			\
	AA_FORK,		/* A fork()ing AATV */			\
	init_func,		/* The init() function */		\
	NULL,			/* No timer() function */		\
	act_func,		/* Action function */			\
	NULL,			/* No recv() function. */		\
	NULL,			/* No cleanup() function. */		\
	0,			/* No socket. */			\
	max,			/* Configured maximum */		\
	0,			/* Number of forked processes */	\
	0, 0, 0, 0, 0, 0,	/* proc_cnt_hi, proc_q_hi, etc. */	\
	NULL }			/* Queue of requests */

#define	DEF_AATV_SOCKET(id,init_func,act_func,recv_func) \
	DEF_AATV_SOCKET_TYPE(id,-1,init_func,act_func,recv_func)

#define	DEF_AATV_SOCKET_TYPE(id,authen_type,init_func,act_func,recv_func) \
	DEF_AATV_SOCKET_FULL(id,authen_type,init_func,NULL,act_func,recv_func,NULL)

#define	DEF_AATV_SOCKET_FULL(id,authen_type,init_func,timer_func,act_func,recv_func,cleanup_func) {	\
	id,			/* Name of AATV */			\
	authen_type,		/* Authentication type */		\
	AA_SOCKET,		/* A socket based AATV */		\
	init_func,		/* How we setup. */			\
	timer_func,		/* How we time things. */		\
	act_func,		/* Action function */			\
	recv_func,		/* Where we receive something */	\
	cleanup_func,		/* Cleanup function */			\
	-1,			/* No socket. */			\
	0, 			/* Configigured maximum (N/A) */	\
	0,			/* Number of forked processes (N/A) */	\
	0, 0, 0, 0, 0, 0,	/* proc_cnt_hi, proc_q_hi, etc. */	\
	NULL }			/* Queue of requests (N/A) */

#define	DEF_AATV_FREPLY(id,act_func,max) \
	DEF_AATV_FREPLY_TYPE(id,-1,NULL,act_func,max)

#define	DEF_AATV_FREPLY_TYPE(id,authen_type,init_func,act_func,max) \
	DEF_AATV_FREPLY_FULL(id,authen_type,init_func,NULL,act_func,NULL,max)

#define	DEF_AATV_FREPLY_FULL(id,authen_type,init_func,timer_func,act_func,cleanup_func,max) {	\
	id,			/* Name of AATV */			\
	authen_type,		/* Authentication type */		\
	AA_FREPLY,		/* Fork Reply based AATV */		\
	init_func,		/* How we setup. */			\
	timer_func,		/* How we time things. */		\
	act_func,		/* Action function */			\
	NULL,			/* FREPLY has no receive function */	\
	cleanup_func,		/* Cleanup function */			\
	-1,			/* No socket */				\
	max,			/* Configured maximum */		\
	0,			/* Number of forked processes */	\
	0, 0, 0, 0, 0, 0,	/* proc_cnt_hi, proc_q_hi, etc. */	\
	NULL }			/* Queue of requests */ 

extern AATV    *authtype_tv[];

extern AATVPTR	rad_log_aatv;		/* For logging (selector) */
extern AATVPTR	rad_log_accounting_aatv; /* For logging Livingston style acct */
extern AATVPTR	rad_log_all_aatv;	/* For logging (debugging) */
extern AATVPTR	rad_log_brief_aatv;	/* For logging (logging) */
extern AATVPTR	rad_log_by_huntgroup_aatv; /* Select log by PW_HUNTGROUP_NAME */
extern AATVPTR	rad_log_by_nas_aatv;	/* Select log by PW_NAS_IDENTIFIER */
extern AATVPTR	rad_log_by_realm_aatv;	/* Select log by PW_USER_REALM */
extern AATVPTR	rad_log_by_attribute_aatv; /* Select log by arb. attr. AATV */
extern AATVPTR	rad_log_old_aatv;	/* For logging (logging) */
extern AATVPTR	rad_log_tacacs_aatv;	/* For logging (logging) */
extern AATVPTR	rad_log_v1_0_aatv;	/* For logging (logging) */
extern AATVPTR	rad_log_v1_1_aatv;	/* For logging (logging) */
extern AATVPTR	rad_log_v2_0_aatv;	/* For logging (logging) */
extern AATVPTR	rad_log_v2_1_aatv;	/* For logging (logging) */
extern char    *logconfig;

/*	Specify all authentication/authorization transfer vectors here. */

extern AATVPTR	rad_authen_aatv;	/* Authentication begins here */
extern AATVPTR	rad_realm_aatv;		/* Needed for authtype = realm */
extern AATVPTR	rad_2rad_aatv;		/* Authtype = Radius */
extern AATVPTR	rad_tacs_aatv;		/* Authtype = TACACS */
extern AATVPTR	rad_unix_aatv;		/* Authtype = UNIX-PW */
extern AATVPTR	rad_slow_aatv;		/* Authtype = SLOW */
extern AATVPTR	rad_kchp_aatv;		/* Authtype = KCHAP */
extern AATVPTR	rad_akrb_aatv;		/* Authtype = akerb */
extern AATVPTR	rad_mkrb_aatv;		/* Authtype = mkerb */
extern AATVPTR	rad_arades_aatv;	/* Authtype = Ascend ARA DES */
extern AATVPTR	rad_passwd_aatv;	/* Used for changing passwords */
extern AATVPTR	rad_ip_pool_aatv;	/* IP Address Allocate/Release AATV */

#ifdef BSD_AUTHENTICATION
extern AATVPTR	rad_bsd_aatv;		/* Authtype = BSD Authentication */
#define	BSD_AATV	,&rad_bsd_aatv
#else	/* BSD_AUTHENTICATION */
#define	BSD_AATV
#endif	/* BSD_AUTHENTICATION */

#ifdef MERIT_HUNTGROUP
#include	"huntgroup.h"
#else	/* MERIT_HUNTGROUP */
#define	HGAATVS
#endif	/* MERIT_HUNTGROUP */

#ifdef MERIT_ORGANIZATION
#include	"oas.h"
extern AATVPTR	rad_oas_aatv;		/* Org Authorization begins here */
extern AATVPTR	rad_oasrem_aatv;	/* Org Authorization remote stuff */
extern AATVPTR	rad_oasloc_aatv;	/* Org Authorization local stuff */
extern AATVPTR	oas_acct_aatv;		/* Org Accounting begins here */
#define	OASAATVS ,&rad_oas_aatv,&rad_oasrem_aatv,&rad_oasloc_aatv,&oas_acct_aatv
#else	/* MERIT_ORGANIZATION */
#define	OASAATVS
#endif	/* MERIT_ORGANIZATION */

#ifdef MERIT_LAS
#include	"las.h"
#define	EN_LAS			"AUTHENTICATE"
#define	EN_LAS_ACCT		"LAS_ACCT"
extern AATVPTR	rad_las_aatv;		/* Local authorization server (LAS) */
extern AATVPTR	postlas_aatv;		/* Post LAS processing */
extern AATVPTR	las_auth_subaatv;	/* Generic LAS authorization */
extern AATVPTR	las_acct_subaatv;	/* Generic LAS accounting */
extern AATVPTR	las_acct_aatv;		/* LAS accounting */
extern AATVPTR	lascp_aatv;		/* LAS synchronizing */
extern AATVPTR	rad_file_aatv;		/* Authtype = File */
extern AATVPTR	rad_tac_plus_aatv;	/* Authtype = TACPLUS */
extern AATVPTR	rad_cache_chk_aatv;	/* Authentication by cached token */
extern AATVPTR	rad_cache_tok_aatv;	/* Authentication by cached token */
extern AATVPTR	rad_sc_aatv;		/* Sample FREPLY AATV */

#ifdef CHK_COUNTS
extern AATVPTR	rad_count_aatv;		/* Check those counters */
#define	RAD_COUNT_AATV	&rad_count_aatv,
#else	/* CHK_COUNTS */
#define	RAD_COUNT_AATV
#endif	/* CHK_COUNTS */

#ifdef CHECKTOKEN
extern AATVPTR  rad_tokencnt_aatv;
#define	TOKENCNTAATV	&rad_tokencnt_aatv,
#else	/* CHECKTOKEN */
#define	TOKENCNTAATV
#endif	/* CHECKTOKEN */

#ifdef RADLDAP
extern AATVPTR	rad_ldap_aatv;
#define	LDAPAATV	&rad_ldap_aatv,
#else	/* RADLDAP */
#define	LDAPAATV
#endif	/* RADLDAP */

#define	LOGAATVS	&rad_log_aatv			\
			,&rad_log_accounting_aatv	\
			,&rad_log_all_aatv		\
			,&rad_log_brief_aatv		\
			,&rad_log_by_attribute_aatv	\
			,&rad_log_by_huntgroup_aatv	\
			,&rad_log_by_nas_aatv		\
			,&rad_log_by_realm_aatv		\
			,&rad_log_old_aatv		\
			,&rad_log_tacacs_aatv		\
			,&rad_log_v1_0_aatv		\
			,&rad_log_v1_1_aatv		\
			,&rad_log_v2_0_aatv		\
			,&rad_log_v2_1_aatv		\

#ifdef UOFM_LAS
#include	"umlas.h"
extern AATVPTR  las_um_aatv;		/* U of M LAS */
#define	UMLAS_AATV	&las_um_aatv,
#else	/* UOFM_LAS */
#define	UMLAS_AATV
#endif	/* UOFM_LAS */

#define	LASAATVS  ,&las_auth_subaatv,&las_acct_subaatv,UMLAS_AATV     \
		&postlas_aatv,&rad_file_aatv,&rad_tac_plus_aatv,      \
		&rad_sc_aatv,&rad_cache_chk_aatv,&rad_cache_tok_aatv, \
		TOKENCNTAATV LDAPAATV RAD_COUNT_AATV &rad_las_aatv,   \
		&las_acct_aatv,&lascp_aatv, LOGAATVS
#else	/* MERIT_LAS */
#define	LASAATVS
#endif	/* MERIT_LAS */

#ifdef USR_CCA
extern AATVPTR  rad_rf_req_aatv;        /* Handles resource free requests */
extern AATVPTR  rad_rf_resp_aatv;       /* Handles resource free responses */
extern AATVPTR  rad_rq_resp_aatv;       /* Handles resource query responses
                                           in the initializer state */
extern AATVPTR  rad_fwd2nas_aatv;       /* Forwards Resoruce Query Requests to
                                           NAS */
extern AATVPTR  rad_nas_reb_aatv;       /* AATV that handles the NAS Reboot
                                           resource free request */
#define	USRAATVS ,&rad_rf_req_aatv,&rad_rf_resp_aatv,&rad_rq_resp_aatv, \
		&rad_fwd2nas_aatv,&rad_nas_reb_aatv
#else	/* USR_CCA */
#define	USRAATVS
#endif	/* USR_CCA */

#define	AATVS	&rad_realm_aatv,  &rad_unix_aatv,      &rad_2rad_aatv,      \
		&rad_tacs_aatv,   &rad_kchp_aatv,      &rad_akrb_aatv,      \
		&rad_mkrb_aatv,   &rad_authen_aatv,    &rad_passwd_aatv,    \
		&rad_arades_aatv, &rad_ip_pool_aatv,   &rad_slow_aatv       \
		HGAATVS OASAATVS LASAATVS USRAATVS BSD_AATV

/*
 *	Event names (EN_*) in RADIUS   ###   see the NOTE in enum_event()
 */

#define	EN_NAK			"NAK"
#define	EN_ACK			"ACK"
#define	EN_ERROR		"ERROR"
#define	EN_WAIT			"WAIT"
#define	EN_FATAL		"FATAL"
#define	EN_DUP_REQ		"DUP"
#define	EN_TIMER		"TIMER"
#define	EN_TIMEOUT		"TIMEOUT"
#define	EN_ABORT		"ABORT"
#define	EN_NEW_AUTHEN		"AUTHEN"
#define	EN_NEW_ACCT		"ACCT"
#define	EN_NEW_PASSWD		"PASSWD"
#define	EN_IP_ALLOC		"IPALLOC"
#define	EN_IP_RELEASE		"IPRELEASE"
#define	EN_PW_EXPIRED		"PW_EXPIRED"
#define	EN_EVENT_REQUEST	"EVENT_REQUEST"
#define	EN_TERM_SESSION		"TERM_SESSION"
#define	EN_RETRY_LIMIT		"RETRY_LIMIT"
#define	EN_RE_ACCESS		"REACCESS"
#define	EN_ACC_CHAL		"ACC_CHAL"
#define	EN_MGT_POLL		"MGT_POLL"
#define	EN_AUTH_ONLY		"AUTH_ONLY"
#define	EN_ACCT_START		"ACCT_START"
#define	EN_ACCT_STOP		"ACCT_STOP"
#define	EN_ACCT_ALIVE		"ACCT_ALIVE"
#define	EN_ACCT_MODEM_START	"ACCT_MSTART"
#define	EN_ACCT_MODEM_STOP	"ACCT_MSTOP"
#define	EN_ACCT_CANCEL		"ACCT_CANCEL"
#define	EN_ACCT_ON		"ACCT_ON"
#define	EN_ACCT_OFF		"ACCT_OFF"
#define	EN_ACCT_DUP		"ACCT_DUP"
#define	EN_RC1			"RC1"
#define	EN_RC2			"RC2"
#define	EN_RC3			"RC3"
#define	EN_RC4			"RC4"
#define	EN_RC5			"RC5"
#define	EN_RC6			"RC6"
#define	EN_RC7			"RC7"
#define	EN_RC8			"RC8"
#define	EN_RC9			"RC9"
#define	EN_RC10			"RC10"
#define	EN_RC11			"RC11"
#define	EN_RC12			"RC12"
#define	EN_RC13			"RC13"
#define	EN_RC14			"RC14"
#define	EN_RC15			"RC15"
#define	EN_RC16			"RC16"
#define	EN_RC17			"RC17"
#define	EN_RC18			"RC18"
#define	EN_RC19			"RC19"
#define	EN_RC20			"RC20"
#define	EN_RC21			"RC21"

#ifdef USR_CCA
#define	EN_RF_REQ               "RF_REQ"
#define	EN_RF_RESP              "RF_RESP"
#define	EN_RQ_REQ               "RQ_REQ"
#define	EN_RQ_RESP              "RQ_RESP"
#define	EN_NAS_REB_REQ          "NAS_REB_REQ"
#define	EN_NAS_REB_RESP         "NAS_REB_RESP"
#define	EN_DONE                 "DONE"
#endif /* USR_CCA */

/*
 *	Event numbers in RADIUS   ###   see the NOTE in enum_event()
 */
typedef enum
{
	EV_NAK			= -1,
	EV_ACK			= 0,
	EV_ERROR		= 1,
	EV_WAIT			= 2,
	EV_FATAL		= 3,
	EV_DUP_REQ		= 4,
	EV_TIMER		= 5,
	EV_TIMEOUT		= 6,
	EV_ABORT		= 7,

	/* arbitrary return codes from AATV action functions */

	EV_RC1			= 8,
	EV_RC2			= 9,
	EV_RC3			= 10,
	EV_RC4			= 11,
	EV_RC5			= 12,
	EV_RC6			= 13,
	EV_RC7			= 14,
	EV_RC8			= 15,
	EV_RC9			= 16,
	EV_RC10			= 17,
	EV_RC11			= 18,
	EV_RC12			= 19,
	EV_RC13			= 20,
	EV_RC14			= 21,
	EV_RC15			= 22,
	EV_RC16			= 23,
	EV_RC17			= 24,
	EV_RC18			= 25,
	EV_RC19			= 26,
	EV_RC20			= 27,
        EV_RC21                 = 28,

#ifdef USR_CCA
        EV_RF_REQ               = 29,
        EV_RQ_REQ               = 30,
        EV_RQ_RESP              = 31,
        EV_DONE                 = 32,
        EV_NAS_REB_REQ          = 33,
        EV_NAS_REB_RESP         = 34,
        EV_RF_RESP              = 35,
#endif /* USR_CCA */

	EV_PW_EXPIRED		= 29,
	EV_RETRY_LIMIT		= 30,
	EV_PLACE_HOLDER		= 0
} EVENT;

/* Request type events */

#define	EV_NEW_AUTHEN		EV_RC1
#define	EV_NEW_ACCT		EV_RC2
#define	EV_NEW_PASSWD		EV_RC3
#define	EV_RE_ACCESS		EV_RC4
#define	EV_ACC_CHAL		EV_RC5
#define	EV_MGT_POLL		EV_RC6
#define	EV_AUTH_ONLY		EV_RC7
#define	EV_ACCT_START		EV_RC8
#define	EV_ACCT_STOP		EV_RC9
#define	EV_ACCT_ALIVE		EV_RC10
#define	EV_ACCT_MODEM_START	EV_RC11
#define	EV_ACCT_MODEM_STOP	EV_RC12
#define	EV_ACCT_CANCEL		EV_RC13
#define	EV_ACCT_ON		EV_RC14
#define	EV_ACCT_OFF		EV_RC15
#define	EV_ACCT_DUP		EV_RC16

typedef enum		/* Typedef for second add_string() argument */
{
	ASIS		= 0x0000,	/* No conversion on string */
	ASLC		= 0x0001,	/* Store as lower case sting */
	FINDONLY	= 0x0002,	/* Find string only */
	ASSTATIC	= 0x0004	/* String is built-in */
} AS_CONVERT;

typedef enum		/* Typedef for gen_valpair() final argument */
{
	GVP_DROP	= 0x0000,	/* Just drop the attribute. */
	GVP_ENCAP	= 0x0001,	/* Encapsulate the attribute. */
	GVP_SILENT	= 0x0002	/* Silently drop and do not report. */
} GVP_FLAGS;

/*
 *	The finite state machine (FSM) table is laid out as follows:
 *
 *	state0:
 *		event01         aatv01          nextstate01
 *		event02         aatv02          nextstate02
 *		...
 *	state1:
 *		event11         aatv11          nextstate11
 *		...
 */

#define	NUMSTATES	64	/* initial maximum number of states */

#define	ST_INIT		0	/* initial state */

#define	ST_RESERVED	240	/* beginning of reserved state range */
#define	ST_SEEN		241	/* flag for state seen before being defined */
#define	ST_DEFINED	242	/* flag for state definition */

#define	ST_RECV		251	/* to indicate state which receives requests */
#define	ST_HOLD		252	/* to indicate dead requests */
#define	ST_SAME		253	/* for default action table */
#define	ST_ANY		254	/* for default action table */
#define	ST_END		255	/* end of FSM table */

typedef struct statelist        /* list of all state names */
{
	int        maxst;	/* capacity of this list */
	int        nst;		/* number of states already there */
	NAME_LIST *states;	/* list of states found in the config file */
} STATELIST;

typedef struct fsm_entry	/* The Finite State Machine an array of these */
{
	struct fsm_entry *next;		/* list of entries for this state */
	EV                event;	/* (state.action.event) 3-tuple */
	AATV             *action;	/* what AATV (action) to invoke */
	int               xvalue;	/* miscellaneous integer from FSM */
	char             *xstring;	/* miscellaneous string from FSM */
	u_char            next_state;	/* the next state to visit */
	char             *fsm_name;	/* name of the FSM (default, etc.) */
	char             *state_name;	/* name of the state */
} FSM_ENT;

typedef void		(*DESTRUCTOR) PROTO((void *));
#define	NODESTRUCTOR	((DESTRUCTOR) 0)

#define	AR_NO_LOG	0x01		/* sws: Suppress the logging flag */
#define	AR_DEBUG	0x02		/* sws: Debug this authreq */
#define	AR_FROM_PROXY	0x04		/* sws: authreq did not come from NAS */
#define	AR_HGNOCHECK	0x08		/* sws: huntgroup code sanity check */
#define	AR_QUEUED	0x10		/* sws: authreq has been queued */
#define	AR_FREED	0x20		/* sws: authreq has been freed & held */
#define	AR_HOLD		0x40		/* sws: hold authreq a bit longer */

#define	SAR_NO_LOG(authreq) (authreq->sws |= AR_NO_LOG)	      /* set flag */
#define	CAR_NO_LOG(authreq) (authreq->sws &= ~AR_NO_LOG)      /* clear flag */
#define	TAR_NO_LOG(authreq) ((authreq->sws & AR_NO_LOG) != 0) /* test flag */

#define	SAR_HGNOCHECK(authreq)	(authreq->sws |= AR_HGNOCHECK)  /* set flag */
#define	CAR_HGNOCHECK(authreq)	(authreq->sws &= ~AR_HGNOCHECK) /* clear flag */
#define	TAR_HGNOCHECK(authreq)	(authreq->sws & AR_HGNOCHECK)   /* test flag */

#define	SAR_FROM_PROXY(authreq)	(authreq->sws |= AR_FROM_PROXY)   /* set flag */
#define	CAR_FROM_PROXY(authreq)	(authreq->sws &= ~AR_FROM_PROXY)  /* clr flag */
#define	TAR_FROM_PROXY(authreq)	((authreq->sws & AR_FROM_PROXY) != 0) /* test */

#define	SAR_QUEUED(authreq)	(authreq->sws |= AR_QUEUED)	/* set flag */
#define	CAR_QUEUED(authreq)	(authreq->sws &= ~AR_QUEUED)	/* clr flag */
#define	TAR_QUEUED(authreq)	((authreq->sws & AR_QUEUED) != 0) /* test */

#define	SAR_FREED(authreq)	(authreq->sws |= AR_FREED)	/* set flag */
#define	CAR_FREED(authreq)	(authreq->sws &= ~AR_FREED)	/* clr flag */
#define	TAR_FREED(authreq)	((authreq->sws & AR_FREED) != 0) /* test */

#define	SAR_HOLD(authreq)	(authreq->sws |= AR_HOLD)	/* set flag */
#define	CAR_HOLD(authreq)	(authreq->sws &= ~AR_HOLD)	/* clr flag */
#define	TAR_HOLD(authreq)	((authreq->sws & AR_HOLD) != 0)	/* test */

#define	AVPAIR_VTOA_QUOTE 0x0001 /* Quote strings with "'" */
#define	AVPAIR_VTOA_NULL  0x0002 /* Print "" instead of NULL for missing item */
#define	AVPAIR_VTOA_DQUOTE 0x0004 /* Quote strings with '"' */
#define	AVPAIR_VTOA_DATE  0x0008 /* Show only date part of time/dates. */
#define	AVPAIR_VTOA_TIME  0x0010 /* Show only time part of time/dates. */
#define	AVPAIR_VTOA_LCLTIME 0x0020 /* Use localtime() instead of gmtime() */
#define	AVPAIR_VTOA_MASK  0x00ff /* Reserve fourteen more bits. */

#define	LOG_VP_QUOTE	0x0001	/* Quote strings (same as AVPAIR_VTOA_QUOTE) */
#define	LOG_VP_NULL	0x0002  /* Use "" (incompatible with LOG_VP_NA) */
#define	LOG_VP_DQUOTE	0x0004	/* Quote strings with '"' */
#define	LOG_VP_DATE	0x0008	/* Show only date part of time/dates. */
#define	LOG_VP_TIME	0x0010	/* Show only time part of time/dates. */
#define	LOG_VP_LCLTIME	0x0020	/* Use localtime() instead of gmtime() */
#define	LOG_VP_TAB	0x0100	/* Put tab after printing. */
#define	LOG_VP_NA	0x0200  /* fprintf ("NA") if no attr exists in list. */
#define	LOG_VP_LAST	0x0400	/* Log last value pair found. */
#define	LOG_VP_ALL	0x0800	/* Log all attributes found. */
#define	LOG_VP_ANYWAY	0x1000	/* Log even if this vp is logged already. */
#define	LOG_ATTR_ANYWAY	0x2000	/* Log even if this attribute is logged. */
#define	LOG_VP_MASK	0xFFFF	/* Switches available. */

#define	RS_NONE		0x0000	/* normal default behavior of reply_sprintf() */
#define	RS_LOG		0x0001	/* log message side effect in reply_sprintf() */
#define	RS_NO_CRLF	0x0002	/* omit CR/LF side effect in reply_sprintf() */
#define	RS_IF_ACK	0x0004	/* use Reply-If-Ack-Message attribute */

#define	LF_ACCT_RESERVED0	0x01	/* Not used. */
#define	LF_ACCT_RESERVED1	0x02	/* Not used. */
#define	LF_ACCT_RESERVED2	0x04	/* Not used. */
#define	LF_ACCT_NO_MULTIPLE	0x08	/* Don't log same attribute twice. */
#define	LF_ACCT_DICT_NOVALUE	0x10	/* Don't show dictionary values. */
#define	LF_ACCT_DICT_NONAME	0x20	/* Don't show dictionary name. */
#define	LF_NOT_EQUAL		0x40	/* Indicates "!=" instead of "=" */

#define	CHK_ACCEPT	0x00	/* Process as an accept-only list. */
#define	CHK_DENY	0x01	/* Process as a denial list. */
#define	CHK_ONCE	0x02	/* Check only the first check item in list. */
#define	CHK_MESSAGE	0x04	/* Produce a message somehow. */

#ifdef BINARY_FILTERS

/*
 * Two types of filters are supported, GENERIC and IP.  The identifiers are:
 */
#define	RAD_FILTER_GENERIC	0
#define	RAD_FILTER_IP		1

/*
 * Generic filters mask and match up to RAD_MAX_FILTER_LEN bytes starting at
 * some offset.  The length is:
 */
#define	RAD_MAX_FILTER_LEN	6
#define	NO_TOKEN		-1

typedef struct
{
	CONST char     *name;
	int             value;
} keywordstruct;

typedef enum
{
	FILTER_IP_TYPE,
	FILTER_GENERIC_TYPE,
	FILTER_IN,
	FILTER_OUT,
	FILTER_FORWARD,
	FILTER_DROP,
	FILTER_GENERIC_OFFSET,
	FILTER_GENERIC_MASK,
	FILTER_GENERIC_VALUE,
	FILTER_GENERIC_COMPNEQ,
	FILTER_GENERIC_COMPEQ,
	FILTER_MORE,
	FILTER_IP_DST,
	FILTER_IP_SRC,
	FILTER_IP_PROTO,
	FILTER_IP_DST_PORT,
	FILTER_IP_SRC_PORT,
	FILTER_EST
} filtertokens;

/*
 * Enumerated values for the IP filter port comparisons.
 */
typedef enum
{
	RAD_NO_COMPARE,
	RAD_COMPARE_LESS,
	RAD_COMPARE_EQUAL,
	RAD_COMPARE_GREATER,
	RAD_COMPARE_NOT_EQUAL
} radfiltercomp;

extern keywordstruct filtercompare[];

/*
 * The binary format of an IP filter.  ALL fields are stored in network byte
 * order.
 * 
 * srcip:	The source IP address.
 * 
 * dstip:	The destination IP address.
 * 
 * srcmask:	The number of leading one bits in the source address mask.
 *		Specifies the bits of interest.
 * 
 * dstmask:	The number of leading one bits in the destination address
 *		mask. Specifies the bits of interest.
 * 
 * proto:	The IP protocol number
 * 
 * establised:	A boolean value.  TRUE when we care about the established
 *		state of a TCP connection.  FALSE when we dont care.
 * 
 * srcport:	TCP or UDP source port number.
 * 
 * dstport:	TCP or UDP destination port number.
 * 
 * srcportcmp:	One of the values of the radfiltercomp enumeration
 *		specifying how to compare the srcport value.
 * 
 * dstportcmp:	One of the values of the radfiltercomp enumeration
 *		specifying how to compare the dstport value.
 * 
 * fill:	Round things out to a dword boundary.
 */

typedef struct radip
{
	UINT4           srcip;
	UINT4           dstip;
	u_char          srcmask;
	u_char          dstmask;
	u_char          proto;
	u_char          established;
	u_short         srcport;
	u_short         dstport;
	u_char          srcportcomp;
	u_char          dstportcomp;
	u_char          fill[2];
} radipfilter;

/*
 * The binary format of a GENERIC filter.  ALL fields are stored in network
 * byte order.
 * 
 * offset:	Number of bytes into packet to start comparison.
 * 
 * len:		Number of bytes to mask and compare.  May not exceed
 *		RAD_MAX_FILTER_LEN.
 * 
 * more:	Boolean.  If non-zero the next filter entry is also to be
 *		applied to a packet.
 * 
 * mask:	A bit mask specifying the bits to compare.
 * 
 * value:	A value to compare against the masked bits at offset in a
 *		users packet.
 * 
 * compneq:	Defines type of comparison (Equal or Notequal) default is
 *		Equal.
 * 
 * fill:	Round things out to a dword boundary
 */

typedef struct radgeneric
{
	u_short         offset;
	u_short         len;
	u_short         more;
	u_char          mask[RAD_MAX_FILTER_LEN];
	u_char          value[RAD_MAX_FILTER_LEN];
	u_char          compneq;
	u_char          fill;
} radgenfilter;

/*
 * A binary filter element.  Contains either a radipfilter or a
 * radgenfilter.  All fields are stored in network byte order.
 * 
 * type:	Either RAD_FILTER_GENERIC or RAD_FILTER_IP.
 * 
 * forward:	TRUE if we should forward packets that match this filter,
 *		FALSE if we should drop packets that match this filter.
 * 
 * input:	TRUE if this is an input filter, FALSE if this is an output
 *		filter.
 * 
 * fill:	Round things out to a dword boundary.
 * 
 * u:		A union of:
 *
 *		ip:		An IP filter entry
 *		generic:	A generic filter entry
 */

typedef struct filter
{
	u_char          type;
	u_char          forward;
	u_char          input;
	u_char          fill;
	union
	{
		radipfilter     ip;
		radgenfilter    generic;
	} u;
} radfilter;

#endif	/* BINARY_FILTERS */

/*
 *	SWITCH_TABLE should be used as an array with a { NULL, -1 } entry
 *	at the end to terminate the table.
 */

typedef struct
{
	char   *name;	/* name of thing */
	int     value;	/* value of thing */
} SWITCH_TABLE;

/* authenticate.c */

int check_request PROTO((AUTH_REQ *, VALUE_PAIR *, int));
char *get_deny_message PROTO((AUTH_REQ *, VALUE_PAIR *, char *));

/* des.c */

int des_init PROTO((void));
void desdone PROTO((void));
void dessetkey PROTO((char *));
void endes PROTO((char *));
void dedes PROTO((char *));

/* dict.c */
int attr_check PROTO((DICT_ATTR_LIST **, int, UINT4));
int attr_check_by_dict PROTO((DICT_ATTR_LIST **, DICT_ATTR *));
int attr_check_by_name PROTO((DICT_ATTR_LIST **,char *));
int attr_check_clear PROTO((DICT_ATTR_LIST **));
int dict_init PROTO((void));
DICT_ATTR * dict_attrget PROTO((int, UINT4));
DICT_ATTR * dict_attrfind PROTO((char *));
DICT_VALUE * dict_find_value PROTO((UINT4, DICT_ATTR *));
DICT_VALUE * dict_valfind PROTO((char *, char *));
DICT_VALUE * dict_valget PROTO((UINT4, char *));
VENDOR * find_vendor_by_id PROTO((UINT4));
VENDOR * find_vendor_by_name PROTO((char *));
int free_vendor_list PROTO((VENDOR_LIST *));
char * parse_for_vendor_list PROTO((char *, VENDOR_LIST **));
char * vendor_list_toa PROTO((VENDOR_LIST *));

/* filters.c */
int filter_binary PROTO((char *, char *));

/* fsm.c */
int init_fsm PROTO((int, char *, FSM_ENT ***, FSM_ENT ***));

/* funcs.c */

#if __STDC__ == 1
#include	<stdarg.h>
#else
#include	<varargs.h>
#endif

int ack_action PROTO((AUTH_REQ *, int, char *));

#ifdef USR_CCA
int add_dns_nbns PROTO((AUTH_REQ *, AUTH_ENTRY *));
#endif	/* USR_CCA */

char * add_string PROTO((char *, AS_CONVERT));
void add_string_dump PROTO((void));
int attribute_out PROTO((AUTH_HDR *, UINT4, int, UINT4, void *, int, int,
			VENDOR_LIST *));
int attribute_out_tag PROTO((AUTH_HDR *, UINT4, int, UINT4, void *, int, int,
			int, VENDOR_LIST *));
int attribute_pw_out PROTO((AUTH_HDR *, UINT4, char *, char *));
char * authtype_toa PROTO((int));
char * auth_vectortoa PROTO((u_char *, int));
VALUE_PAIR * avpair_add PROTO((VALUE_PAIR **, int, void *, int));
VALUE_PAIR * avpair_add_attr_tag PROTO((VALUE_PAIR **, DICT_ATTR *, void *,
					int, int));
VALUE_PAIR * avpair_add_tag PROTO((VALUE_PAIR **, int, void *, int, int));
VALUE_PAIR * avpair_add_vend PROTO((VALUE_PAIR **, int, void *, int, UINT4));
VALUE_PAIR * avpair_add_vend_tag PROTO((VALUE_PAIR **, int, void *, int,
					UINT4, int));
VALUE_PAIR * avpair_assign PROTO((DICT_ATTR *, void *, int));
VALUE_PAIR * avpair_assign_tag PROTO((DICT_ATTR *, void *, int, int));
int avpair_comp PROTO((VALUE_PAIR *, VALUE_PAIR *));
void avpair_del PROTO((VALUE_PAIR **, int, UINT4));
void avpair_del_ci PROTO((VALUE_PAIR **, int, UINT4));
VALUE_PAIR * avpair_dup PROTO((VALUE_PAIR *));
void avpair_free PROTO((VALUE_PAIR *));
int avpair_get PROTO((void *, VALUE_PAIR *, int));
int avpair_get_vend PROTO((void *, VALUE_PAIR *, int, int));
int avpair_out PROTO((VALUE_PAIR *, AUTH_HDR *, UINT4, VENDOR_LIST *));
void avpair_string_mod PROTO((VALUE_PAIR *, char *, int));
char * avpair_vtoa PROTO((VALUE_PAIR *, int));
char * build_header PROTO((u_int, char *, u_int, u_int, AUTH_HDR *,
			CLIENT_ENTRY *));
int build_packet PROTO((VALUE_PAIR *, AUTH_HDR *, UINT4, CLIENT_ENTRY *));
int build_reply_mic PROTO((AUTH_HDR *, char *));
int build_request_mic PROTO((AUTH_HDR *, char *));
int check_mic PROTO((AUTH_HDR *, u_int, char *, CLIENT_ENTRY *));
int client_event_queue PROTO((CLIENT_ENTRY *));
void compress_file PROTO((char *));
void debug_list PROTO((FILE *, VALUE_PAIR *));
void debug_pair PROTO((FILE *, VALUE_PAIR *));

#if __STDC__ == 1
int dumpit (int, int, void *, UINT4, UINT4, char *, ...);
#else
int dumpit ();
#endif

int dump_received_packet PROTO((char *func, int code, u_int len,
				struct sockaddr_in *sin, char *reason));

extern CLIENT_ENTRY dummy_status_server_client;

int fdcmp PROTO((int, int));
int free_linklist PROTO((LINKLIST_ENT **, DESTRUCTOR));
void fprint_attr_val PROTO((FILE *, VALUE_PAIR *));
void fprint_attr_val_sws PROTO((FILE *, VALUE_PAIR *, int));
VALUE_PAIR * gen_valpairs PROTO((AUTH_HDR *, u_int, VENDOR_LIST *, int));
char * get_errmsg PROTO((void));
UINT4 get_ipaddr PROTO((char *));
VALUE_PAIR * get_last_vp PROTO((VALUE_PAIR *, int));
VALUE_PAIR * get_last_vp_vend PROTO((VALUE_PAIR *, int, int));
char * get_memory PROTO((u_int, char *, char *));
char * get_next_word PROTO((char *, char *, int *));
int get_passwd PROTO((AUTH_REQ *, char *, char *, char *));
char *get_realm_name PROTO((char *));
VALUE_PAIR * get_vp PROTO((VALUE_PAIR *, int));
VALUE_PAIR * get_vp_ci PROTO((VALUE_PAIR *, int, UINT4));
VALUE_PAIR * get_vp_vend PROTO((VALUE_PAIR *, int, UINT4));
int get_word_list PROTO((char *, char **, int));
int good_ipaddr PROTO((char *));
int hex_dump PROTO((char *, char *, int, int));
void insert_vp PROTO((VALUE_PAIR **, VALUE_PAIR *, VALUE_PAIR *));
void list_cat PROTO((VALUE_PAIR **, VALUE_PAIR *));
int list_copy PROTO((VALUE_PAIR **, VALUE_PAIR *));
void list_free PROTO((VALUE_PAIR *));

#ifdef RELIABLE_FLOCK
#define	lockfile	flock
#else	/* RELIABLE_FLOCK */

#ifndef LOCK_SH
#define	LOCK_SH		1	/* shared lock */
#define	LOCK_EX		2	/* exclusive lock */
#define	LOCK_NB		4	/* don't block when locking */
#define	LOCK_UN		8	/* unlock */
#endif	/* LOCK_SH */

int lockfile PROTO((int, int));
#endif	/* RELIABLE_FLOCK */

int logfmt_accounting PROTO((FILE *, VALUE_PAIR *, int, int));
extern int (*logit) PROTO((int, int, CONST char *, ...));
char * mf_ent_toa PROTO((char *, MF_ENT *));
char * new_string PROTO((char *, char *));
void missing_attribute PROTO((AUTH_REQ *, char *, int, char *));
void missing_attribute_vend PROTO((AUTH_REQ *, char *, int, char *, int));
extern int packet_log PROTO((char *, AUTH_REQ *, int));

#define	PL_REP_PORT	0x0001	/* Show reply UDP port */
#define	PL_REP_VECTOR	0x0002	/* Show reply vector to use */
#define	PL_FWD_VECTOR	0x0004	/* Show forwarding vector */
#define	PL_RESERVED	0xff00	/* Reserved for forwarding logging switches */

/* for the "packet_log_switch" variable */
#define	PL_SWS_ORIG	0x00000001	/* Search original request */
#define	PL_SWS_CUR	0x00000002	/* Search current request */
#define	PL_SWS_COMP	0x00000004	/* Compare original and current req */
#define	PL_SWS_ABORT	0x00000008	/* Abort if compare fails */

VALUE_PAIR * parse_realm PROTO((AUTH_REQ *));
VALUE_PAIR * parse_realm2 PROTO((VALUE_PAIR **, int *, CLIENT_ENTRY *));
int prune_pairs PROTO((AUTH_REQ *, int));

extern char **radius_argv;
extern char **radius_envp;
extern int    radius_argc;
extern int    radius_child;	/* Set by rad_fork() when in a child process. */

#if __STDC__ == 1
int rad_fork (char *, ...);
int rad_ptitle (char *, ...);
int rad_sleep (u_int , char *, ...);
int rad_vptitle (char *, va_list);
#else	/* __STDC__ */
int rad_fork ();		/* Set title like rad_ptitle() does. */ 
int rad_ptitle ();		/* Set title reported by ps(1) command. */
int rad_sleep ();
int rad_vptitle ();
#endif	/* __STDC__ */

#define	rad_strdup(str) _rad_strdup(func, str)
extern char * _rad_strdup PROTO((char *, char *));
char * rad_strncpy PROTO((char *, char *, int));
extern char * rad_time PROTO((time_t, int));	/* 0 = localtime, 1 = gmtime */
char * radius_dbfile PROTO((char *, char *));
#define	reply_message(authreq, msgno, msg) _reply_message(authreq, msgno, msg,__FILE__, __LINE__)
int _reply_message PROTO((AUTH_REQ *, ERRORCODE, char *, char *, int));

#if __STDC__ == 1
int reply_sprintf (int, AUTH_REQ *, char *, ...);
#else
int reply_sprintf ();
#endif

int reset_attr_flag PROTO((DICT_ATTR *, int));
int reset_vp_attr_flags_list PROTO((VALUE_PAIR *, int));
int reset_vp_flag PROTO((VALUE_PAIR *, int));
int reset_vp_flags_list PROTO((VALUE_PAIR *, int));
int reset_stderr PROTO((char *, int));
int safe_free PROTO((void *));
int set_attr_flag PROTO((DICT_ATTR *, int));
char *set_realm_name PROTO((char *));
int set_vp_attr_flags_list PROTO((VALUE_PAIR *, int));
int set_vp_flag PROTO((VALUE_PAIR *, int));
int set_vp_flags_list PROTO((VALUE_PAIR *, int));
int setupsock PROTO((struct sockaddr_in *, int));
void setup_logfile PROTO((int));
int switch_by_name PROTO((SWITCH_TABLE *, char *, int *));
char * type_string PROTO((AUTH_REQ *, VALUE_PAIR *));
int xget_word_list PROTO((char *, char **, int, char *));

/* passchange.c */
int pw_expired PROTO((UINT4, VALUE_PAIR *));

/* radiusd.c */
extern int debug_flag;
extern char ourhostname[];

int authreq_holdtime PROTO((AUTH_REQ *));
AUTH_REQ * build_acct_req PROTO((AUTH_REQ *, int, char *, time_t, VALUE_PAIR *));
int call_action PROTO((AATV *, AUTH_REQ *, int, char *));
int fatal_action PROTO((AUTH_REQ *, int, char *));
AATV * find_aatv PROTO((char *));
AUTH_REQ * rad_2rad_recv PROTO((int, struct sockaddr_in *, UINT4, u_int, EV *));
AUTH_REQ * rad_recv PROTO((int, struct sockaddr_in *, UINT4, u_int, EV *));
int radius_send PROTO((char *, u_int, u_int, char *, AUTH_REQ *, int));
void start_fsm PROTO((AUTH_REQ *, int, char *, char *));
AUTH_REQ_Q * queue_find PROTO((int));
AUTH_REQ * enqueue_authreq PROTO((AUTH_REQ_Q *, AUTH_REQ *));

#ifdef USR_CCA
void free_event_list PROTO((AUTH_REQ *));
void free_authreq PROTO((AUTH_REQ *));
void free_event_list_final PROTO((AUTH_REQ *));
#endif /* USR_CCA */

/* sendserver.c */
void dir_init PROTO((void));
int send_server PROTO((SEND_DATA *, int *, char *));
void send_server_done PROTO((void));

/* users.c */
int add_file_list PROTO((char *));
int addr_is_us PROTO((UINT4));
int change_pw PROTO((char *, int, VALUE_PAIR *, char *));
int client_is_us PROTO((CLIENT_ENTRY *));
int client_queue_size PROTO((CLIENT_ENTRY *));
int config_files PROTO((int, int, int));
void config_fini PROTO((void));
void config_init PROTO((void));
void dns_recv PROTO((struct sockaddr_in *, UINT4, int));
AUTH_ENTRY * find_auth_ent PROTO((char *, char *));
int find_auth_type PROTO((char *, int, char *, int *, char **, char **, char **));
int insert_client PROTO((char *, char *, char *, int, int, VENDOR_LIST *, int));
int find_client PROTO((UINT4, CLIENT_ENTRY **));
int find_client_by_name PROTO((char *, UINT4 *, CLIENT_ENTRY **));

#ifdef USR_CCA
FILE_LIST * find_file_ent PROTO((char *));
void free_assign_ip PROTO((ASSIGNED_IP *));
void free_vpn_rtr PROTO((VPN_ROUTER **));
FILE_LIST * get_default_file_entry PROTO((void));
#endif	/* USR_CCA */

int find_host_by_name PROTO((UINT4 *, char *));
void free_user_ent PROTO((USER_ENTRY *));
CLIENT_ENTRY * get_client_list PROTO((void));
UINT4 get_our_addr PROTO((void));
int host_is_us PROTO((char *));
char * ip_hostname PROTO((UINT4));
int pair_parse PROTO((char *, VALUE_PAIR **, VALUE_PAIR **));
FILE_LIST * return_file_list PROTO((void));
int update_clients PROTO((void));
int update_expire PROTO((char *, int, VALUE_PAIR *));
int user_find PROTO((char *, char *, int, VALUE_PAIR **, VALUE_PAIR **,
			VALUE_PAIR **, int));
void user_gettime PROTO((char *, struct tm *));
int user_update PROTO((char *, VALUE_PAIR *, VALUE_PAIR *, VALUE_PAIR *));

/* version.c */
char * verinfo PROTO((int));

#ifdef USR_CCA

/*  resources.c  */
int add_to_addr_pool PROTO((ADDR_POOL **, char *, int));
int resource_mgmt PROTO((AUTH_REQ *));
void free_pool_ent PROTO((ADDR_POOL *));
int free_resources PROTO((char *, UINT4, UINT4, UINT4));

/* rf_req.c */
AUTH_REQ * dup_authreq PROTO((AUTH_REQ *));
AUTH_REQ * make_dup PROTO((AUTH_REQ *));
char * find_das PROTO((char *, UINT4, char *));

/* res_qry.c */
void rq_req_init PROTO((void));
u_char new_id PROTO((AUTH_REQ *));
void send_rq_req PROTO((CLIENT_ENTRY *));
int set_client PROTO((UINT4, int));

/* vpn.c */
int parse_filter_vpn PROTO((char *,char *, char *, int, char **,
			    char **, char **, char **));
int parse_vpn PROTO((char *, UINT4 *, VPN_ROUTER **, int *, char **, int));
int parse_rtr PROTO((int, VPN_ROUTER **, char **));
int add_vpn_info PROTO((AUTH_REQ *, AUTH_ENTRY *));
int find_vpn PROTO((AUTH_REQ *));
void proxy_vector_proc PROTO((AUTH_REQ *, char *, char *));

#endif /* USR_CCA */

#endif /* RADIUS_H */
