/*
 * RADIUS -- Remote Authentication Dial In User Service
 *
 *
 * Livingston Enterprises, Inc. 6920 Koll Center Parkway Pleasanton, CA   94566
 *
 * Copyright 1992 Livingston Enterprises, Inc.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose and without fee is hereby granted, provided that this copyright
 * and permission notice appear on all copies and supporting documentation,
 * the name of Livingston Enterprises, Inc. not be used in advertising or
 * publicity pertaining to distribution of the program without specific
 * prior permission, and notice be given in supporting documentation that
 * copying and distribution is by permission of Livingston Enterprises, Inc.
 *
 * Livingston Enterprises, Inc. makes no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 *      Copyright (c) 1996 Ascend Communications, Inc.
 *      All rights reserved.
 *
 *      Permission to copy, display, distribute and make derivative works
 *      from this material in whole or in part for any purpose is granted
 *      provided that the above copyright notice and this paragraph are
 *      duplicated in all copies.  THIS SOFTWARE IS PROVIDED "AS IS" AND
 *      WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT
 *      LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *      FOR A PARTICULAR PURPOSE.
 *
 *
 * Copyright (c) 1996 U.S. Robotics, Access Corp.
 * All rights reserved.
 *
 * Permission to copy, display, distribute and make derivative works
 * from this material in whole or in part for any purpose is granted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all copies.  THIS SOFTWARE IS PROVIDED "AS IS" AND
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 */

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation
 * for any purpose and without fee is hereby granted, provided:
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof,
 *
 * 2) that both the copyright notice and this permission and disclaimer notice
 *    appear in all supporting documentation, and
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

/*
 *
 * Public entry points in this file:
 *
 * build_acct_req
 * call_action
 * dump_received_packet
 * enqueue_authreq
 * queue_find
 * rad_2rad_recv
 * rad_recv
 * radius_send
 * start_fsm
 *
 */

/* N.B. don't look here for the version, run radiusd -v or look in version.c */

static char     sccsid[] =
		"@(#)radiusd.c 1.5 Copyright 1992 Livingston Enterprises Inc";

static char     rcsid[] =
		"$Id: radiusd.c,v 1.30 1998/07/16 16:24:01 web Exp $";

#include	<sys/types.h>
#include	<sys/stat.h>

#if !(defined(FD_SET) || defined(linux))
#include	<sys/select.h>
#endif	/* FD_SET */

#if defined(sys5)
#include	<sys/sysmacros.h>
#endif	/* sys5 */

#ifdef	SVR4
#include	<sys/systeminfo.h>
#endif	/* SVR4 */

#include	<sys/param.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/file.h>
#include	<sys/wait.h>
#include	<net/if.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>

#include	<signal.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<netdb.h>
#include	<fcntl.h>
#include	<errno.h>
#include	<memory.h>
#include	<unistd.h>
#include	<syslog.h>

#include	"radius.h"

/* Static Declarations */

#ifdef USR_CCA
int             alarm_set = 0;    /* Required by rq_req.c */
#else /* USR_CCA */
static int      alarm_set = 0;    /* Flag indicates alarm is set */
#endif	/* USR_CCA */

static int      cache_users = 1;  /* Read users file to memory (default) */
static u_char   log_forwarding = 0; /* 1 ==> packet log relaying and replying */
static int      log_forwarding_sws = 0;

#define	LFS_FWD_VECTOR	PL_FWD_VECTOR	/* These three should be in radius.h */
#define	LFS_DUMP	0x0100		/* Dump packet when forwarding. */
#define	LFS_FWD_DIGEST  0x0200		/* Dump digest when forwarding. */

static char    *progname;
static u_char   log_generated_request = 1;
static int      select_max = 0;   /* computed in main() */
static char    *debug_file = RADIUS_DEBUG;
static int      zap_debugfile = 0; /* Empty debugfile first time referenced. */
static char    *radius_fsm = RADIUS_FSM;
static char    *cur_wrk_dir = (char *) NULL; /* Initially use our parent's. */
static int      nfsm;             /* number of FSM entries */
static int      child_done = 0;   /* This child isn't done yet. */
static AATV    *child_aatv = (AATV *) NULL;
static AATV    *current_aatv = (AATV *) NULL;

#ifdef USR_CCA
FSM_ENT       **fsm;
#else
static FSM_ENT **fsm;             /* pointer to FSM table */
#endif	/* USR_CCA */

static FSM_ENT **default_fsm;
static int      avalue;
static time_t   tofmaxdelay;
static time_t   select_cur = 0;   /* recorded in main() */
static char     path[MAXPATHLEN];
static char     logversion[MAXPATHLEN];
static int      last_send_len = 0;    /* Length of last socket request sent */
static struct sockaddr_in last_send_sin; /* Socket info of last request sent */
static char     last_send_action[64]; /* Name of action sending last request */
static int      default_retry_limit = 0;
static int      default_seqch_limit = 0;
static int      rad_reply_switch = 0;	/* See RRS_xxx below */

/* All these RRS_* should be in radius.h (XXX: so why aren't they?) */
#define	RRS_ALL		0x00000001	/* Check all queue'd requests */
#define	RRS_ABORT	0x00000002	/* Abort if match fails */
#define	RRS_IGNORE	0x00000004	/* Ignore reply */
#define	RRS_VERBOSE	0x00000008	/* Dump a/v pairs into logfile */
#define	RRS_DUMP	0x00000010	/* Dump received reply packet */
#define	RRS_DROP	0x00000100	/* Drop pending request */
#define	RRS_NAK		0x00000200	/* NAK pending request */

#define	RADCHECK_QSTATS 0x0001          /* Show queue information */
#define	RADCHECK_PSTATS 0x0002          /* Show packet stats */

static int      radcheck_switch = RADCHECK_QSTATS;

/*
 *	These counters help determine how much traffic we encounter.
 *	They are arranged in the opposite order from the radcheck output.
 */

PACKET_COUNTS stat_etc_xmit =
			{
				(PACKET_COUNTS *) NULL,
				"etc_xmit",
				0,
				0,
				0
			};

PACKET_COUNTS stat_etc_resp =
			{
				&stat_etc_xmit,
				"etc_resp",
				0,
				0,
				0
			};

static PACKET_COUNTS stat_redos =
			{
				&stat_etc_resp,
				"redo",
				0,
				0,
				0
			};

static PACKET_COUNTS stat_responses =
			{
				&stat_redos,
				"resp",
				0,
				0,
				0
			};

static PACKET_COUNTS stat_transmitted =
			{
				&stat_responses,
				"xmit",
				0,
				0,
				0
			};

static PACKET_COUNTS stat_replied =
			{
				&stat_transmitted,
				"reply",
				0,
				0,
				0
			};

static PACKET_COUNTS stat_received =
			{
				&stat_replied,
				"rcvd",
				0,
				0,
				0
			};

static DICT_ATTR_LIST *reply_check_list = (DICT_ATTR_LIST *) NULL;

#ifdef USR_CCA
static char     qry_init = FALSE;
extern char     dns_done;
#endif	/* USR_CCA */

#ifdef MERIT_HUNTGROUP
time_t          save_hgtime = 0;	/* timestamp of huntgroups file */
#endif	/* MERIT_HUNTGROUP */

/* Forward Declarations */

static void     aatv_process_end PROTO((AATV *));
static int      acc_chal_action PROTO((AUTH_REQ *, int, char *));
static int      authreq_dup_check PROTO((AUTH_REQ *, AUTH_REQ *, VALUE_PAIR **,
					char **, char **));
static int      authreq_q_size PROTO((AUTH_REQ *));
/* external     build_acct_req */
/* external     call_action */
static int      check_reply PROTO((AUTH_REQ *, VALUE_PAIR *));
static void     child_end PROTO((int));
static int      cleanup_delay PROTO((int));
static int      config_initialize PROTO((void));
static void     debug_bump PROTO((int));
static void     debug_off PROTO((int));
static void     doconfig PROTO((int));
static int      done_action PROTO((AUTH_REQ *, int, char *));
static int      ev2code PROTO((AUTH_REQ *, int));
static int      fail_log_action PROTO((AUTH_REQ *, int, char *));
/* external     fatal_action */
static int      fatal_log_action PROTO((AUTH_REQ *, int, char *));
/* external     find_aatv */
static char    *find_state_name PROTO((int));
static int      fork_reply PROTO((AUTH_REQ *, int));
static void     found_waldo PROTO((EVENT_ENT *, EV *));

#if !defined(USR_CCA)
static void     free_authreq PROTO((AUTH_REQ *));
static void     free_event_list PROTO((AUTH_REQ *));
#endif	/* USR_CCA */

static void     free_authreq_final PROTO((AUTH_REQ *));

#if !defined(USR_CCA)
static void     free_event_list_final PROTO((AUTH_REQ *));
#endif	/* USR_CCA */

static void     free_event PROTO((EVENT_ENT *));
static void     free_event_final PROTO((EVENT_ENT *));
static void     free_proc_ent PROTO((PROC_ENT *));
static int      get_radrequest PROTO((int, AUTH_REQ **, struct sockaddr_in *,
					UINT4, u_int, CLIENT_ENTRY *));
static u_char   get_state PROTO((VALUE_PAIR **));
static int      handle_sysconf PROTO((int, int, char *, char *));
static int      init_aatvs PROTO((void));
static AUTH_REQ *is_dup_request PROTO((AUTH_REQ *, int *));
static int      kill_action PROTO((AUTH_REQ *, int, char *));
static void     log_queues PROTO((AUTH_REQ *, char *));
static EVENT_ENT *match_waldo PROTO((int, AUTH_REQ *, EV *, VALUE_PAIR *));
static int      nak_action PROTO((AUTH_REQ *, int, char *));
static int      null_action PROTO((AUTH_REQ *, int, char *));

static char    *packet_counts_toa PROTO((PACKET_COUNTS *));
static int      pending_action PROTO((AUTH_REQ *, int, char *));
static int      protocol_check PROTO((AUTH_REQ *, VALUE_PAIR **));
static AUTH_REQ *proxy_forwarding PROTO((int, struct sockaddr_in *, UINT4,
					u_int));
static int      pw_expired_action PROTO((AUTH_REQ *, int, char *));
/* external     rad_2rad_recv */
static void     rad_init PROTO((AATV *));
static void     rad_ipc_init PROTO((AATV *));
static AUTH_REQ *rad_ipc_recv PROTO((int, struct sockaddr_in *, UINT4, u_int,
					EV *));
/* external     rad_recv */
static int      rad_reply PROTO((AUTH_REQ *, int, char *));
static void     rad_reply_init PROTO((AATV *));
/* external     radius_send */
static void     read_sysconf PROTO((void));
static int      record_event PROTO((AUTH_REQ *, AATV *, int, int, char *));
static int      redo_action PROTO((AUTH_REQ *, int, char *));
static void     reply_timer PROTO((int));
static AUTH_REQ *response_match PROTO((AUTH_REQ *, CLIENT_ENTRY *, u_char *,
					int, int, int, u_char *, u_char *,
					int *, int *, AUTH_REQ **));
static int      retry_limit_action PROTO((AUTH_REQ *, int, char *));
static int      seqch_limit_action PROTO((AUTH_REQ *, int, char *));
static void     send_cmd_unrec PROTO((int, int, struct sockaddr_in *, int,
					int, CLIENT_ENTRY *));
static void     send_reply PROTO((int, char *, int, AUTH_REQ *, int));
static int      server_status PROTO((AUTH_REQ *, int, char *));
static void     set_debug PROTO((int));
static void     sig_fatal PROTO((int));
static void     sig_int PROTO((int));
static void     sig_quit PROTO((int));
static void     sig_term PROTO((int));
/* external     start_fsm */
static void     state_machine PROTO((EV, AUTH_REQ *));
static void     stat_files PROTO((int, int));
static void     sysconf_init PROTO((AATV *));
static int      timeout_action PROTO((AUTH_REQ *, int, char *));
static int      timer_action PROTO((AUTH_REQ *, int, char *));
static int      ttl_action PROTO((AUTH_REQ *, int, char *));
static int      ttl_slice_action PROTO((AUTH_REQ *, int, char *));
static void     usage PROTO((void));
static int      wait_action PROTO((AUTH_REQ *, int, char *));

/*************************************************************************
 *
 *	Utility AATV structures
 *
 *************************************************************************/

static AATV     any_aatv = DEF_AATV_DIRECT_CFG("*", sysconf_init, null_action,
						NULL);
static AATVPTR  rad_any_aatv = & any_aatv;

static AATV     end_aatv = DEF_AATV_DIRECT("CLEANUP", NULL);
static AATVPTR  rad_end_aatv = & end_aatv;

static AATV     acc_chal_aatv = DEF_AATV_DIRECT("ACC_CHAL", NULL);
static AATVPTR  rad_acc_chal_aatv = & acc_chal_aatv;

static AATV     done_aatv = DEF_AATV_DIRECT("DONE", done_action);
static AATVPTR  rad_done_aatv = & done_aatv;

static AATV     fail_log_aatv = DEF_AATV_DIRECT("FAIL", fail_log_action);
static AATVPTR  rad_fail_log_aatv = & fail_log_aatv;

static AATV     fatal_aatv = DEF_AATV_DIRECT("FATAL", fatal_action);
static AATVPTR  rad_fatal_aatv = & fatal_aatv;

static AATV     fatal_log_aatv = DEF_AATV_DIRECT("FATAL_LOG", fatal_log_action);
static AATVPTR  rad_fatal_log_aatv = & fatal_log_aatv;

static AATV     kill_aatv = DEF_AATV_DIRECT("KILL", kill_action);
static AATVPTR  rad_kill_aatv = & kill_aatv;

static AATV     nak_aatv = DEF_AATV_DIRECT_TYPE("NAK", AA_DENY, nak_action);
static AATVPTR  rad_nak_aatv = & nak_aatv;

static AATV     null_aatv = DEF_AATV_DIRECT_TYPE("NULL", AA_BLACKHOLE,
								null_action);
static AATVPTR  rad_null_aatv = & null_aatv;

static AATV     pending_aatv = DEF_AATV_DIRECT("PENDING", pending_action);
static AATVPTR  rad_pending_aatv = & pending_aatv;

static AATV     pw_expired_aatv = DEF_AATV_DIRECT("PW_EXPIRED",
							pw_expired_action);
static AATVPTR  rad_pw_expired_aatv = & pw_expired_aatv;

static AATV     redo_aatv = DEF_AATV_DIRECT("REDO", redo_action);
static AATVPTR  rad_redo_aatv = & redo_aatv;

static AATV     retry_limit_aatv = DEF_AATV_DIRECT("RETRY_LIMIT",
							retry_limit_action);
static AATVPTR  rad_retry_limit_aatv = & retry_limit_aatv;

static AATV     seqch_limit_aatv = DEF_AATV_DIRECT("SEQCH_LIMIT",
							seqch_limit_action);

static AATVPTR  rad_seqch_limit_aatv = & seqch_limit_aatv;

static AATV     status_aatv = DEF_AATV_DIRECT("SRV_STATUS", server_status);
static AATVPTR  rad_status_aatv = & status_aatv;

static AATV     timeout_aatv = DEF_AATV_DIRECT("TIMEOUT", timeout_action);
static AATVPTR  rad_timeout_aatv = & timeout_aatv;

static AATV     timer_aatv = DEF_AATV_DIRECT("TIMER", timer_action);
static AATVPTR  rad_timer_aatv = & timer_aatv;

static AATV     ttl_aatv = DEF_AATV_DIRECT("TTL", ttl_action);
static AATVPTR  rad_ttl_aatv = & ttl_aatv;

static AATV     ttl_slice_aatv = DEF_AATV_DIRECT("TTL_SLICE", ttl_slice_action);
static AATVPTR  rad_ttl_slice_aatv = & ttl_slice_aatv;

static AATV     wait_aatv = DEF_AATV_DIRECT("WAIT", wait_action);
static AATVPTR  rad_wait_aatv = & wait_aatv;

/*
 *	Global Variables
 */

u_short         auth_port = 0;
u_short         auth_fwd_port = 0;  /* UDP port number for relaying */
u_short         acct_port = 0;
u_short         acct_fwd_port = 0;  /* UDP port number for acct relaying */
UINT2           send_buffer_size = RAD_SEND_BUFFER_SIZE;
u_char          recv_buffer[RAD_RECV_BUFFER_SIZE];
static char     recv_buffer_backup[RAD_RECV_BUFFER_SIZE];
u_char          send_buffer[RAD_SEND_BUFFER_SIZE];
char            ourhostname[MAXHOSTNAMELEN];
UINT4           was_proxy_forwarding = 0; /* length of recv_buffer_backup[] */
int             debug_flag = 0;     /* Values > 0 allow various debug output */
int             dumpcore = 0;       /* Normally 0, when > 0 causes core dump */
int             file_logging = 1;   /* 0 => syslog, 1 => logfile, 2 => stderr */
int             zap_logfile = 0;    /* Empty logfile first time referenced */
int             want_timer = 0;     /* When non-zero, call timer functions */
MF_ENT          authreq_mf = { 0, 0 };  /* For authreq allocation */
MF_ENT          waldo_mf = { 0, 0 }; /* For waldo record allocation */
MF_ENT          redo_mf = { 0, 0 };  /* for packets */
char           *radius_dir;
char           *fsm_id = NULL;      /* From %FSMID string in the FSM table */
FILE           *ddt = (FILE *) NULL;
FILE           *msgfd = (FILE *) NULL;
extern AATVPTR  rad_ack_aatv;
extern int      packet_log_switch;

/* needed only by passchange.c */
UINT4           expiration_seconds;
UINT4           warning_seconds;
int             allow_pw_changing = 0;

/* needed only by tokcache.c */
int             allow_token_caching = 0;

/* needed only by authenticate.c and tokcache.c */
int             token_caching_auth_type[] = { AA_ACE, 0 };
/* Authentication protocols which may cache tokens, must end with a zero. */
/* Otherwise oreder is unimportant.  Defined here, external elsewhere. */

/* needed publicly only by authenticate.c, radfile.c and users.c */
AATV           *authtype_tv[PW_AUTH_MAX + 1]; /* AATV by authentication types */

/* needed publicly only by rad.accounting.c */
char           *radacct_dir;
u_short         inetd = 0;

/* needed publicly by funcs.c and las.token.c */
time_t          birthdate;
/* this variable is declared globally and initialized in funcs.c */
extern char    *radius_log_fmt;

/* needed publicly only by users.c */
int             authfile_cnt = 0;
int             clients_cnt = 0;
int             users_cnt = 0;
/* these variables are declared globally and initialized in users.c */
extern int      dnspid;            /* PID of DNS resolver process */
extern UINT4    dns_address_aging;
extern UINT4    dns_address_window;
extern int      doing_init;        /* Flag indicating initialization phase */
extern int      spawn_flag;        /* 0 => no spawning, 1 => spawning allowed */
extern int      default_reply_holdtime;
extern int      rad_ipc_port;      /* Local port number of ipc socket */
extern char     authfile_id[128];
extern char     clients_id[128];
extern MF_ENT   vendor_mf;	   /* Used in dict.c */
extern MF_ENT   vendor_list_mf;	   /* Used in dict.c */

/* these variables are declared globally and initialized in dict.c */
extern char    *dict_id;           /* From %DICTID string in the dictionary */
extern char    *vend_id;           /* From %VENDORSID string in vendors file */

#ifdef WANT_PS_NAMES
extern char   **environ;
#endif	/* WANT_PS_NAMES */

#ifdef MERIT_LAS
extern int      no_old_session;
#endif	/* MERIT_LAS */

static AUTH_REQ_Q global_acct_q =
		{
			(AUTH_REQ_Q *) NULL,	/* next */
			"acct",			/* q_name :: accounting */
			0,			/* max */
			0,			/* cur */
			0,			/* cur_freed */
			MAX_ACCT_REQUESTS,	/* limit */
			0,			/* ident */
			0,			/* max_time */
			0,			/* hold */
			(AUTH_REQ *) NULL,	/* q */
			&global_acct_q.q,	/* p_q_end */
			(AUTH_REQ *) NULL,	/* freed */
			0,			/* q_ok */
			0,			/* q_fail */
			0,			/* q_dup */
			0,			/* q_freed */
			0,			/* dq_freed */
			0,			/* c_free_authreq */
			0			/* c_free_authreq_final */
		};

/* needed publicly by rad.tacacs.c and radcount.c and the USR files */
AUTH_REQ_Q      global_auth_q =
		{
			&global_acct_q,		/* next */
			"auth",			/* q_name :: authentication */
			0,			/* max */
			0,			/* cur */
			0,			/* cur_freed */
			MAX_AUTH_REQUESTS,	/* limit */
			0,			/* ident */
			0,			/* max_time */
			0,			/* hold */
			(AUTH_REQ *) NULL,	/* q */
			&global_auth_q.q,	/* p_q_end */
			(AUTH_REQ *) NULL,	/* freed */
			0,			/* q_ok */
			0,			/* q_fail */
			0,			/* q_dup */
			0,			/* q_freed */
			0,			/* dq_freed */
			0,			/* c_free_authreq */
			0			/* c_free_authreq_final */
		};

static AATV     server_aatv = DEF_AATV_SOCKET("RADIUS", rad_init, NULL,
						rad_recv);
AATVPTR  rad_server_aatv = & server_aatv;

static AATV     reply_aatv = DEF_AATV_SOCKET("REPLY", rad_reply_init, rad_reply,
						NULL);
static AATVPTR  rad_reply_aatv = & reply_aatv;

extern AATVPTR  rad_acct_aatv;
extern AATVPTR  rad_acct_switch_aatv;
extern AATVPTR  rad_accounting_aatv;
extern AATVPTR  rad_ipc_aatv;

static AATVPTR *aatv_ptrs[] =
{
	&rad_acct_aatv,
	&rad_acct_switch_aatv,
	&rad_accounting_aatv,
	&rad_server_aatv,
	&rad_reply_aatv,
	&rad_ipc_aatv,
	AATVS,	/* for all "engine external" AATVs (except ACCT) see radius.h */
	&rad_acc_chal_aatv,
	&rad_ack_aatv,
	&rad_any_aatv,
	&rad_done_aatv,
	&rad_end_aatv,
	&rad_fail_log_aatv,
	&rad_fatal_aatv,
	&rad_fatal_log_aatv,
	&rad_kill_aatv,
	&rad_nak_aatv,
	&rad_null_aatv,
	&rad_pending_aatv,
	&rad_pw_expired_aatv,
	&rad_redo_aatv,
	&rad_retry_limit_aatv,
	&rad_seqch_limit_aatv,
	&rad_status_aatv,
	&rad_timeout_aatv,
	&rad_timer_aatv,
	&rad_ttl_aatv,
	&rad_ttl_slice_aatv,
	&rad_wait_aatv
};


#define	MAX_AATV (sizeof (aatv_ptrs) / sizeof (aatv_ptrs[0]))

static AATV    *sockfd_tv[MAX_AATV + 1];
static fd_set   select_mask;

static int    (*timer_funcs[MAX_AATV + 1]) PROTO((void));

/* Keep track of the time it took to service the last 100 replies. */
static u_short  rad_reply_times[CLEANUP_BUCKETS];
static u_short  rad_reply_pos = 0;	/* Start here. */

/*************************************************************************
 *
 *	Function: Main RADIUS server code
 *
 *	Purpose: Handle dispatching of incoming RADIUS requests on well
 *		 known socket(s) to AATV recv() function(s).
 *
 *************************************************************************/

int
main (argc, argv)

int             argc;
char          **argv;

{
	u_short         udp_port;
	int             authtype;
	int             dtablesize;
	int             i;
	int             j;
	int             len;
	int             maxfd;
	int             pid;
	int             result;
	int             selcnt;
	AATV           *aatv;
	AUTH_REQ       *authreq;
	FILE           *fp;
	char           *ptr;
	struct timeval *selecttime = NULL;
	struct servent *svp;
	EV              event;
	sigset_t        signals;          /* Main signal mask */
	struct sigaction action;
	struct sockaddr_in fromsin;       /* Remote socket info */
	struct stat     stbuf;
	struct timeval  savetime;
	struct timeval  timeout;
	fd_set          readfds;
	char            errmsg[256];
	char            oldpath[MAXPATHLEN];
	static char    *func = "main";

	birthdate = time (0);

#ifdef WANT_PS_NAMES
	/* Save these for later calls to rad_ptitle() */
	radius_argv = argv;
	radius_argc = argc;
	radius_envp = environ;
#endif	/* WANT_PS_NAMES */

	fprintf (stderr,
		"Merit AAA server %s, licensed software\n", verinfo (2));
	fprintf (stderr,
"COPYRIGHT 1992, 1993, 1994, 1995, 1996, 1997, 1998\n");
	fprintf (stderr,
"THE REGENTS OF THE UNIVERSITY OF MICHIGAN\n");
	fprintf (stderr,
"ALL RIGHTS RESERVED\n");
	fprintf (stderr, "\n");

#ifdef BASIC_SERVER
	fprintf (stderr,
"PERMISSION IS GRANTED TO USE, COPY AND REDISTRIBUTE THIS VERSION OF THE MERIT\n");
	fprintf (stderr,
"BASIC AAA SERVER, SO LONG AS NO FEE IS CHARGED FOR THIS SOFTWARE, AND SO LONG\n");
	fprintf (stderr,
"AS THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND THE DISCLAIMER\n");
	fprintf (stderr,
"BELOW APPEAR IN ALL COPIES MADE; AND SO LONG AS THE NAME OF THE UNIVERSITY OF\n");
	fprintf (stderr,
"MICHIGAN OR MERIT NETWORK IS NOT USED IN ANY ADVERTISING OR PUBLICITY\n");
	fprintf (stderr,
"PERTAINING TO THE USE OR DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC,\n");
	fprintf (stderr,
"WRITTEN PRIOR AUTHORIZATION.\n");
	fprintf (stderr, "\n");
	fprintf (stderr,
"NO RIGHTS ARE GRANTED HEREUNDER FOR ANY RECIPIENT TO MODIFY, DISASSEMBLE,\n");
	fprintf (stderr,
"DECOMPILE, REVERSE ENGINEER OR OTHERWISE CREATE DERIVATIVE WORKS OF THIS\n");
	fprintf (stderr,
"SOFTWARE.\n");
	fprintf (stderr, "\n");
	fprintf (stderr,
"THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION FROM THE UNIVERSITY\n");
	fprintf (stderr,
"OF MICHIGAN AS TO ITS FITNESS FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE\n");
	fprintf (stderr,
"UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING\n");
	fprintf (stderr,
"WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n");
	fprintf (stderr,
"A PARTICULAR PURPOSE.  THE REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE\n");
	fprintf (stderr,
"LIABLE FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR\n");
	fprintf (stderr,
"CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT OF OR IN\n");
	fprintf (stderr,
"CONNECTION WITH THE USE OF THE SOFTWARE, EVEN IF IT HAS BEEN OR IS HEREAFTER\n");
	fprintf (stderr,
"ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n");
	fprintf (stderr, "\n");
	fprintf (stderr,
"FOR FURTHER INFORMATION ABOUT THE ENHANCED MERIT AAA SERVER, SEND EMAIL TO:\n");
	fprintf (stderr,
"aaa.license@merit OR, VISIT THE WWW SITE:  www.merit.edu/aaa/\n");
	fprintf (stderr, "\n");
#endif	/* BASIC_SERVER */

#if ((defined OSF) || (defined SCO))
	set_auth_parameters (argc, argv);
#endif	/* OSF */

	file_logging = 1;
	progname = *argv++;
	argc--;

	radius_dir = RADIUS_DIR;
	radacct_dir = RADACCT_DIR;

	authfile_id[0] = '\0';
	clients_id[0] = '\0';

	timeout.tv_sec = 0;
	timeout.tv_usec = 0;

	action.sa_handler = sig_fatal;
	sigfillset (&action.sa_mask);
	action.sa_flags = 0;

	sigaction (SIGQUIT, &action, NULL);
	sigaction (SIGILL, &action, NULL);
	sigaction (SIGTRAP, &action, NULL);
	sigaction (SIGIOT, &action, NULL); /* Perhaps also known as SIGABRT ! */
	sigaction (SIGFPE, &action, NULL);

#ifdef	_SC_OPEN_MAX
	if ((dtablesize = sysconf (_SC_OPEN_MAX)) == -1)
	{
		perror ("_SC_OPEN_MAX");
		exit (-17);
	}
#else	/* Assume BSD */
	dtablesize = getdtablesize ();
#endif	/* _SC_OPEN_MAX */

	for (j = dtablesize; j >= 3; j--)
	{
		close (j);
	}

	/* See if anything is attached to stderr at this point */
	if ((fstat (fileno(stderr), &stbuf) == -1) && (errno == EBADF))
	{
		/* Then open system console as stderr. */
		reset_stderr ("/dev/console", 1);
	}

	/*
	 * Current options are:
	 *
	 *	+  Print usage message.
	 *	?  Print usage message.
	 *	h  Print usage message.
	 *
	 *	a  Set RADIUS accounting directory.
	 *	C  Allow token caching.
	 *	c  Set new current working directory.
	 *	d  Set RADIUS database directory.
	 *	f  Specify RADIUS FSM file.
	 *	g  Specify file, syslog or stderr logging.
	 *	l  Specify the strftime(3) format used for RADIUS logfile.
	 *      n  Specify no session table in LAS (with #ifdef MERIT_LAS).
	 *	P  Allow password changing.
	 *	p  Specify UDP port number for receiving RADIUS authentication.
	 *	pp Specify UDP port number for relaying RADIUS authentication.
	 *	q  Specify UDP port number for receiving RADIUS accounting.
	 *	qq Specify UDP port number for relaying RADIUS accounting.
	 *	s  Single-process (non-spawning) flag.
	 *	t  Specify inactivity timeout value.
	 *	u  Don't cache "users" files (DBM version only).
	 *	v  Print version info.
	 *	x  Add to the debug flag value.
	 *	z  Zap logfile and debug file first time they're referenced.
	 *	   (-z ignored if debugging '-x' isn't enabled)
	 *
	 */

	while (argc) /* XXX - should use getopt here */
	{
		if (argv[0][0] != '-')
		{
			fprintf (stderr, "%s: Invalid argument, \"%s\"\n",
				progname, *argv);
			usage ();
		}

		switch (argv[0][1])
		{

		    case '+':
		    case 'h':
		    case '?':
			usage ();
			break;

		    case 'v':
			strcpy (errmsg, verinfo (1));
			fprintf (stderr, "Use -h for help\n%s\n", errmsg);
			exit (-10);
			break;

		    case 'x':
			debug_flag++;
			break;

		    case 's':
			spawn_flag = 0;
			break;

		    case 'f':
			if (argc <= 1)
			{
				usage ();
			}
			radius_fsm = (++argv)[0];
			argc--;
			break;

		    case 'l':
			if (argc <= 1)
			{
				usage ();
			}
			radius_log_fmt = (++argv)[0];
			argc--;
			break;

		    case 'a':
			if (argc <= 1)
			{
				usage ();
			}
			radacct_dir = (++argv)[0];
			argc--;
			break;

		    case 'c':
			if (argc <= 1)
			{
				usage ();
			}
			cur_wrk_dir = (++argv)[0];
			argc--;
			break;

		    case 'C':		/* Allow cachine of tokens */
			allow_token_caching = 1;
			cache_init ();
			break;

		    case 'd':
			if (argc <= 1)
			{
				usage ();
			}
			radius_dir = (++argv)[0];
			argc--;
			break;

		    case 'g':
			if (argc <= 1)
			{
				usage ();
			}

			if (strcasecmp (*(++argv), "logfile") == 0)
			{
				file_logging = 1;
			}
			else
			{
				if (strcasecmp (*argv, "stderr") == 0)
				{
					file_logging = STDERR_FILENO;
					msgfd = stderr;
				}
				else
				{
					file_logging = 0;

#ifdef	LOG_CONS
					openlog ("radiusd", LOG_PID | LOG_CONS,
						LOG_DAEMON);
#else	/* LOG_CONS */
					openlog ("radiusd", LOG_PID);
#endif	/* LOG_CONS */

					msgfd = (FILE *) NULL;
				}
			}
			argc--;
			break;

#ifdef MERIT_LAS
		    case 'n':	/* No session table */
			no_old_session = 1;
			break;
#endif	/* MERIT_LAS */

		    case 'P':	/* Allow password changing. */
			allow_pw_changing = 1;
			break;

		    case 'p':
			i = 0;	/* use i as double-letter flag */
			if (argv[0][2] == 'p')
			{
				i = 1;
				if (argv[0][3])
				{
					ptr = &argv[0][3];
				}
				else
				{
					if (--argc == 0)
					{
						usage ();
					}
					ptr = (++argv)[0];
				}
			}
			else /* only one "p" and i == 0 */
			{
				if (argv[0][2])
				{
					ptr = &argv[0][2];
				}
				else
				{
					if (--argc == 0)
					{
						usage ();
					}
					ptr = (++argv)[0];
				}
			}

			if (sscanf (ptr, "%u", &result) != 1)
			{
				fprintf (stderr, "%s: Invalid port number\n",
					 progname);
				usage ();
			}

			if (i == 1) /* double "p" sets relay UDP port */
			{
				auth_fwd_port = result;
			}
			else /* only one "p" */
			{
				auth_port = result;
			}
			break;

		    case 'q':
			i = 0; /* use i as double-letter flag */
			if (argv[0][2] == 'q')
			{
				i = 1;
				if (argv[0][3])
				{
					ptr = &argv[0][3];
				}
				else
				{
					if (--argc == 0)
					{
						usage ();
					}
					ptr = (++argv)[0];
				}
			}
			else /* only one "q" and i == 0 */
			{
				if (argv[0][2])
				{
					ptr = &argv[0][2];
				}
				else
				{
					if (--argc == 0)
					{
						usage ();
					}
					ptr = (++argv)[0];
				}
			}

			if (sscanf (ptr, "%u", &result) != 1)
			{
				fprintf (stderr, "%s: Invalid port number\n",
					 progname);
				usage ();
			}

			if (i == 1) /* double "q" sets relay UDP port */
			{
				acct_fwd_port = result;
			}
			else /* only one "q" */
			{
				acct_port = result;
			}
			break;

#if defined(USE_DBM) || defined(USE_NDBM)
		    case 'u':
			/* Don't read RADIUS_USERS file into data structure */
			cache_users = 0;
			break;
#endif	/* USE_DBM || USE_NDBM*/

		    case 't':

			/*
			 * Set inactivity timeout for select(2).  The program
			 * will exit upon timeout.  This is intended for those
			 * systems which will start the server from inetd(8).
			 */
			if (argv[0][2])
			{
				ptr = &argv[0][2];
			}
			else
			{
				if (argc > 1)
				{
					ptr = (++argv)[0];
					argc--;
				}
				else
				{
					ptr = NULL;
				}
			}

			if (ptr == NULL || sscanf (ptr, "%d", &i) != 1)
			{
				fprintf (stderr, "%s: Invalid timeout value\n",
					 progname);
				usage ();
			}
			timeout.tv_sec = 60 * i;
			selecttime = &timeout;
			break;

		    case 'z':	/* zap (empty) logfile & debug file, once */
			zap_logfile = 1;
			zap_debugfile = 1;
			break;

		    default:
			fprintf (stderr, "%s: Invalid option, \"%s\"\n",
				progname, *argv);
			usage ();
			break;
		}
		argc--;
		argv++;
	}

	if (zap_logfile > 0)
	{
		setup_logfile (1);	/* Zap the radius logfile */

		sprintf (path, "%s/%s", radius_dir, RADIUS_DEBUG);
		strcpy (oldpath, path);
		strcat (oldpath, ".old");
		unlink (oldpath);
		rename (path, oldpath);
	}

	logit (LOG_DAEMON, LOG_INFO,
		"Merit AAA server %s, licensed software", verinfo (2));
	logit (LOG_DAEMON, LOG_INFO,
		"COPYRIGHT 1992, 1993, 1994, 1995, 1996, 1997, 1998");
	logit (LOG_DAEMON, LOG_INFO,
		"THE REGENTS OF THE UNIVERSITY OF MICHIGAN");
	logit (LOG_DAEMON, LOG_INFO, "ALL RIGHTS RESERVED");

#ifdef BASIC_SERVER
	logit (LOG_DAEMON, LOG_INFO,
"PERMISSION IS GRANTED TO USE, COPY AND REDISTRIBUTE THIS VERSION OF THE MERIT");
	logit (LOG_DAEMON, LOG_INFO,
"BASIC AAA SERVER, SO LONG AS NO FEE IS CHARGED FOR THIS SOFTWARE, AND SO LONG");
	logit (LOG_DAEMON, LOG_INFO,
"AS THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND THE DISCLAIMER");
	logit (LOG_DAEMON, LOG_INFO,
"BELOW APPEAR IN ALL COPIES MADE; AND SO LONG AS THE NAME OF THE UNIVERSITY OF");
	logit (LOG_DAEMON, LOG_INFO,
"MICHIGAN OR MERIT NETWORK IS NOT USED IN ANY ADVERTISING OR PUBLICITY");
	logit (LOG_DAEMON, LOG_INFO,
"PERTAINING TO THE USE OR DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC,");
	logit (LOG_DAEMON, LOG_INFO,
"WRITTEN PRIOR AUTHORIZATION.");
	logit (LOG_DAEMON, LOG_INFO,
"NO RIGHTS ARE GRANTED HEREUNDER FOR ANY RECIPIENT TO MODIFY, DISASSEMBLE,");
	logit (LOG_DAEMON, LOG_INFO,
"DECOMPILE, REVERSE ENGINEER OR OTHERWISE CREATE DERIVATIVE WORKS OF THIS");
	logit (LOG_DAEMON, LOG_INFO,
"SOFTWARE.");
	logit (LOG_DAEMON, LOG_INFO,
"THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION FROM THE UNIVERSITY");
	logit (LOG_DAEMON, LOG_INFO,
"OF MICHIGAN AS TO ITS FITNESS FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE");
	logit (LOG_DAEMON, LOG_INFO,
"UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING");
	logit (LOG_DAEMON, LOG_INFO,
"WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR");
	logit (LOG_DAEMON, LOG_INFO,
"A PARTICULAR PURPOSE.  THE REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE");
	logit (LOG_DAEMON, LOG_INFO,
"LIABLE FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR");
	logit (LOG_DAEMON, LOG_INFO,
"CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT OF OR IN");
	logit (LOG_DAEMON, LOG_INFO,
"CONNECTION WITH THE USE OF THE SOFTWARE, EVEN IF IT HAS BEEN OR IS HEREAFTER");
	logit (LOG_DAEMON, LOG_INFO,
"ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.");
	logit (LOG_DAEMON, LOG_INFO,
"FOR FURTHER INFORMATION ABOUT THE ENHANCED MERIT AAA SERVER, SEND EMAIL TO:");
	logit (LOG_DAEMON, LOG_INFO,
"aaa.license@merit OR, VISIT THE WWW SITE:  www.merit.edu/aaa/");
#endif	/* BASIC_SERVER */

#ifdef	SVR4
	if (sysinfo (SI_HOSTNAME, ourhostname, sizeof (ourhostname)) < 0)
	{
		perror ("SI_HOSTNAME");
		exit (-16);
	}
#else	/* Assume BSD */
	if (gethostname (ourhostname, sizeof (ourhostname)) < 0)
	{
		perror ("gethostname");
		exit (-16);
	}
#endif	/* SVR4 */

	if (cur_wrk_dir != (char *) NULL)
	{
		if (chdir (cur_wrk_dir) < 0)
		{
			perror ("chdir");
			exit (-15);
		}
	}

	if (debug_flag > 0)
	{
		set_debug (1);	/* sets ddt global variable */
	}

	avalue = 0;

	/* Initialize the dictionary */
	if (dict_init () != 0)
	{
		if ((file_logging == 1) && (msgfd != (FILE *) NULL))
		{
			fflush (msgfd);
		}

		perror ("dict_init");
		exit (-1);
	}

	/* Initialize Configuration Values */
	if (config_initialize () != 0)
	{
		if ((file_logging == 1) && (msgfd != (FILE *) NULL))
		{
			fflush (msgfd);
		}

		perror ("config_initialize");
		exit (-2);
	}

	if (acct_port == 0 || acct_fwd_port == 0) /* was not on command line */
	{
		svp = getservbyname ("radacct", "udp");
		if (svp == (struct servent *) NULL)
		{
			udp_port = PW_ACCT_UDP_PORT;
			fprintf (stderr,
	"%s: Cannot find service: radacct/udp\nUsing default UDP port %u for ",
				 progname, udp_port);

			if (acct_port == 0)
			{
				acct_port = udp_port;  /* Assume default */
				fprintf (stderr, "input ");
			}

			if (acct_fwd_port == 0)
			{
				acct_fwd_port = udp_port; /* Assume default */
				fprintf (stderr, "output ");
			}
			fprintf (stderr, "accounting port.\n");
		}
		else
		{
			if (acct_port == 0)
			{
				acct_port = ntohs(svp->s_port);
			}

			if (acct_fwd_port == 0)
			{
				acct_fwd_port = ntohs(svp->s_port);
			}
		}
	}

	if (auth_port == 0 || auth_fwd_port == 0) /* was not on command line */
	{
		svp = getservbyname ("radius", "udp");
		if (svp == (struct servent *) NULL)
		{
			udp_port = PW_AUTH_UDP_PORT;
			fprintf (stderr,
	"%s: Cannot find service: radius/udp\nUsing default UDP port %u for ",
				 progname, udp_port);

			if (auth_port == 0)
			{
				auth_port = udp_port;  /* Assume default */
				fprintf (stderr, "input ");
			}

			if (auth_fwd_port == 0)
			{
				auth_fwd_port = udp_port; /* Assume default */
				fprintf (stderr, "output ");
			}
			fprintf (stderr, "authentication port.\n");
		}
		else
		{
			if (auth_port == 0)
			{
				auth_port = ntohs(svp->s_port);
			}

			if (auth_fwd_port == 0)
			{
				auth_fwd_port = ntohs(svp->s_port);
			}
		}
	}

	fsm = (FSM_ENT **) NULL;
	default_fsm = (FSM_ENT **) NULL;
	nfsm = 0;

	for (i = 0; i <= PW_AUTH_MAX; i++)
	{
	        authtype_tv[i] = (AATV *) NULL; /* array for authentication */
	}

	for (i = j = 0; i < MAX_AATV; i++)
	{
		if ((aatv = *aatv_ptrs[i]) == NULL)
		{
			continue;
		}

		aatv->sockfd = -1;	/* do this here to ensure consistency */

		if ((authtype = aatv->authen_type) != -1)
		{
			authtype_tv[authtype] = aatv;
		}

		if (aatv->timer != (int (*)() ) NULL)
		{
			timer_funcs[j++] = aatv->timer; /* array for timers */
		}
	}
	timer_funcs[j] = NULL;

	read_sysconf ();	/* Configure the engine for the first time */

	/* Do AATV initialization now (to get inetd flag set) */
	maxfd = init_aatvs ();

	/*
	 *	If we're running under (x)inetd, change stderr,
	 *	if it is the same as stdin/stdout.
	 */
	if (inetd)
	{
		if (fdcmp (STDIN_FILENO, STDERR_FILENO) == 0)
		{
			reset_stderr ("/dev/console", 1);
		}
	}

	/*
	 *	Disconnect from session
	 */
	if (debug_flag <= 0 && !inetd)
	{
		pid = (int) fork ();
		if (pid < 0)
		{
			sprintf (errmsg, "%s: Could not fork", progname);
			perror (errmsg);

			if ((file_logging == 1) && (msgfd != (FILE *) NULL))
			{
				fflush (msgfd);
			}

			exit (-5);
		}

		if (pid > 0) /* parent */
		{
			exit (0);
		}
	}

	sigemptyset (&signals);		/* Init signal suspend mask */
	sigaddset (&signals, SIGALRM);
	sigaddset (&signals, SIGCHLD);
	sigaddset (&signals, SIGHUP);
	sigaddset (&signals, SIGINT);
	sigaddset (&signals, SIGQUIT);
	sigaddset (&signals, SIGTERM);
	sigaddset (&signals, SIGUSR1);
	sigaddset (&signals, SIGUSR2);

	memcpy ((char *) &action.sa_mask, (char *) &signals,
		sizeof (action.sa_mask));
	action.sa_flags = 0;

	action.sa_handler = reply_timer;	/* Set up to use alarm() */
	sigaction (SIGALRM, &action, NULL);
	action.sa_handler = child_end;	/* General AATV process end routine */
	sigaction (SIGCHLD, &action, NULL);
	action.sa_handler = doconfig;		/* Set up HUP signal handler */
	sigaction (SIGHUP, &action, NULL);
	action.sa_handler = sig_int;		/* Initialize all AATVs */
	sigaction (SIGINT, &action, NULL);
	action.sa_handler = sig_quit;		/* Child terminator */
	sigaction (SIGQUIT, &action, NULL);
	action.sa_handler = sig_term;		/* Orderly shutdown */
	sigaction (SIGTERM, &action, NULL);
	action.sa_handler = debug_bump;		/* Increase debugging level */
	sigaction (SIGUSR1, &action, NULL);
	action.sa_handler = debug_off;		/* Disable debugging output */
	sigaction (SIGUSR2, &action, NULL);

	/*
	 * Disable signal processing until we're ready to go.  In particular
	 * we need to prevent update_clients() process from doing child_end()
	 * until we're fully initialized.
	 */
	sigprocmask (SIG_BLOCK, &signals, NULL);

	/* Now finish initialization, skipping call to init_aatvs () */
	doconfig (0);

	setsid ();

	/* Position RCS revision number at beginning of logversion[] */

	ptr = strchr (verinfo (2), ' ');	/* Locate first space */
	strcpy (logversion, ptr + 1);	/* Move version number to front */
	strtok (logversion, " ");  /* Terminate string after version number */

	if (debug_flag <= 0)
	{
		sprintf (errmsg, "%s/%s", radius_dir, RADIUS_PID);
		if ((fp = fopen (errmsg, "w")) == (FILE *) NULL)
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: Could not open %s for startup message",
				progname, errmsg);

			if ((file_logging == 1) && (msgfd != (FILE *) NULL))
			{
				fflush (msgfd);
			}

			exit (-6);
		}

#ifndef SCO
		fchmod (fileno(fp), RAD_READ_MODE);
#endif

		sprintf (errmsg, "%u PID %s version [%s]",
			getpid (), progname, logversion);

		if (inetd)
		{
			strcat (errmsg, " (x)inetd");
		}

		fprintf (fp, "%s %-24.24s\n", errmsg, ctime (&birthdate));
		fclose (fp);

		sprintf (oldpath, "%-24.24s", ctime (&birthdate));
		logit (LOG_DAEMON, LOG_INFO, "Started %s: %s", oldpath, errmsg);
	}
	else
	{
		fprintf (ddt, "%-24.24s: Debugging turned ON, Level %d\n",
			ctime (&birthdate), debug_flag);
		fprintf (ddt, "%s\n", verinfo (1));
		fprintf (ddt, "Program = %s\n", progname);
	}

	if (inetd > 0 && selecttime == NULL)
	{
		timeout.tv_sec = 60 * DEFAULT_INETD_TIMEOUT;
		selecttime = &timeout;
	}
	stat_files (1, cache_users); /* first arg == one => init stat values */

	if (selecttime != NULL && timeout.tv_sec == 0)
	{
		selecttime = NULL;	/* No time for this! */
	}
	tofmaxdelay = time (0); /* Initialize the time of maximum delay */

	/* Give DNS process a chance to finish before reading requests */
	if (spawn_flag)
	{
		FD_CLR(server_aatv.sockfd, &select_mask);
		alarm (1);
		alarm_set++;
	}

	/*
	 * Loop where we spend the rest of our life.
	 */
	result = 0;
	memcpy ((char *) &savetime, (char *) &timeout, sizeof (struct timeval));

	do
	{
		if (ddt != (FILE *) NULL && debug_flag <= 0)
		{
			fprintf (ddt, "Debug turned OFF\n");

			if ((ddt == stderr) ||
				(fileno(ddt) == STDERR_FILENO) ||
				(fileno(ddt) == fileno(stderr)))
			{
				reset_stderr ("/dev/console", 1);
			}
			else
			{
				(void) fclose (ddt);
			}

			ddt = (FILE *) NULL;
		}

		/* Enable signal processing now */
		sigprocmask (SIG_UNBLOCK, &signals, NULL);

#ifdef USR_CCA
		/* Send out the resource query requests */
		if (qry_init == FALSE && dns_done == TRUE)
		{
			qry_init = TRUE;
			rq_req_init ();
			if (!alarm_set || global_auth_q.q)
			{
				alarm (1);
				alarm_set++;
			}
		}
#endif	/* USR_CCA */

		memcpy ((char *) &readfds, (char *) &select_mask,
							sizeof (readfds));
		memcpy ((char *) &timeout, (char *) &savetime,
			sizeof (struct timeval));
		selcnt = select (maxfd + 1, &readfds, NULL, NULL, selecttime);
		if (selcnt == 0)
		{
			logit (LOG_DAEMON, LOG_INFO,
			     "%s: terminated by inactivity timeout (%ld secs.)",
				progname, timeout.tv_sec);
			sig_term (0);
		}

		if (selcnt < 0)
		{
			if (errno == EINTR)
			{
				continue;
			}

			logit (LOG_DAEMON, LOG_ALERT, "FATAL select: %s",
				get_errmsg ());
			dumpcore = 1;
			abort ();
		}

		/*
		 * Suspend signal processing while we do our stuff.
		 * This is to prevent possible recursive calls to
		 * nonreentrant functions.
		 */
		sigprocmask (SIG_BLOCK, &signals, NULL);

/*#ifdef USR_CCA
		* Send out the resource query requests *
		if (qry_init == FALSE && dns_done == TRUE)
		{
			qry_init = TRUE;
			rq_req_init ();
			if (!alarm_set || global_auth_q.q)
			{
				alarm (1);
				alarm_set++;
			}
		}
*/
/* #endif	* USR_CCA */

		for (i = 0; (aatv = sockfd_tv[i]) != NULL; i++)
		{
			time_t dummy_time;

			select_cur = time (&dummy_time);
			if (select_cur == (time_t) -1)
			{
				logit (LOG_DAEMON, LOG_ERR,
					"%s: time() error, #%d", func, errno);
			}

			if (FD_ISSET(aatv->sockfd, &readfds))
			{
				len = sizeof (struct sockaddr_in);
				memset ((char *) &fromsin, '\0', len);
				result = recvfrom (aatv->sockfd,
						   (char *) recv_buffer,
						   (int) sizeof (recv_buffer) -
							MAX_SECRET_LENGTH,
						   (int) 0,
						   (struct sockaddr *) &fromsin,
						   & len);
				if (result < 0)
				{
					if (errno == ECONNREFUSED)
					{
						result = 0;
					}
					else
					{
						break;
					}
				}

				if (result > 0) /* Handle received request */
				{
					/* For some event.value to be filled */
					/* in on return from AATV recv call */
					event.state = ST_ANY;
					event.a.aatv = aatv;
					event.isproxy = 0;
					event.xstring[0] = '\0';

					authreq = aatv->recv (aatv->sockfd,
						& fromsin,
						ntohl(fromsin.sin_addr.s_addr),
						result, & event);
					if (authreq != (AUTH_REQ *) NULL)
					{
						authreq->fsm_aatv = aatv;
						state_machine (event, authreq);
					/* Set alarm if a request is pending */
						if (!alarm_set &&
							(global_acct_q.q ||
							 global_auth_q.q))
						{
							alarm (1);
							alarm_set++;
						}
					}
				}
			}

			if ((time (0) - select_cur) > select_max)
			{
				tofmaxdelay = time (0);
				select_max = tofmaxdelay - select_cur;
			}
		}
	} while (result >= 0);

	logit (LOG_DAEMON, LOG_ALERT, "%s: FATAL recvfrom: returned %d '%s'",
		func, result, get_errmsg ());
	dumpcore = 1;
	abort ();
} /* end of main () */

/*************************************************************************
 *
 *	Function: aatv_process_end
 *
 *	Purpose: Start up next deferred request on a forking type AATV.
 *
 *************************************************************************/

static void
aatv_process_end (aatv)

AATV         *aatv;

{
	u_char          save_state;
	int             evalue;
	PROC_ENT       *pe;
	AUTH_REQ       *authreq;
	char            estring[sizeof (pe->estring)];
	static char    *func = "aatv_process_end";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/* Only applies for forking type AATVs. */
	if (aatv == (AATV *) NULL ||
		(aatv->aatvfunc_type != AA_FORK &&
		 aatv->aatvfunc_type != AA_FREPLY))
	{
		return;
	}

	/*
	 *	See if AATV was at process maximum and
	 *	if we are able to de-queue anything.
	 */
	aatv->proc_cnt--;
	if (((pe = aatv->proc_q) == (PROC_ENT *) NULL) ||
		(aatv->proc_cnt >= aatv->proc_max))
	{
		return;
	}

	authreq = pe->authreq;

	dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		"%s: proc_ent [%d '%s' '%s' %d '%s']",
		func, pe->state,
		(pe->fsm_aatv == (AATV *) NULL)
			? (u_char *) "?" : pe->fsm_aatv->id,
		(pe->sub_aatv == (AATV *) NULL)
			? (u_char *) "?" : pe->sub_aatv->id,
		pe->evalue,
		(pe->estring[0] == '\0') ? "?" : pe->estring));

	/* Unlink proc_ent from the authreq. */
	save_state = authreq->state;
	authreq->state = pe->state;
	authreq->fsm_aatv = pe->fsm_aatv;
	authreq->direct_aatv = pe->direct_aatv;
	evalue = pe->evalue;
	strncpy (estring, pe->estring, sizeof (estring));
	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: invoking AATV '%s'",
		func, (pe->sub_aatv == (AATV *) NULL)
					? (u_char *) "?" : pe->sub_aatv->id));

	/* Unlink and free this proc_ent structure. */
	authreq->proc_q = pe->next;
	free_proc_ent (pe);

	/* Now, process the de-queued request. */
	call_action (aatv, authreq, evalue, estring);

	authreq->state = save_state;

	return;
} /* end of aatv_process_end () */

/*************************************************************************
 *
 *	Function: acc_chal_action
 *
 *	Purpose: Return EV_ACC_CHAL event for FSM purposes.
 *
 *************************************************************************/

static int
acc_chal_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "acc_chal_action";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	return EV_ACC_CHAL;
} /* end of acc_chal_action () */

/*************************************************************************
 *
 *	Function: authreq_dup_check
 *
 *	Purpose: Determine if a authreq1 is a duplicate of authreq2.
 *
 *	Returns: 0, if not a duplicate,
 *		 1, if is a duplicate.	 
 *
 *************************************************************************/

static int
authreq_dup_check (auth1, auth2, p_pw_vp1, p_pw1, p_why)

AUTH_REQ       *auth1;		/* Authreq to check. */
AUTH_REQ       *auth2;		/* Authreq to compare against. */
VALUE_PAIR    **p_pw_vp1;	/* Password found in auth1 (if any) */
char          **p_pw1;		/* Decrypted password found in auth1 (if any) */
char          **p_why;		/* Message indicating why decision was made. */

{
	int             vp_type;	/* attribute type (string, etc.) */
	DICT_ATTR      *da;		/* What dictionary entry it is. */
	VALUE_PAIR     *pw_vp1 = NULL_VP;	/* Save password. */
	VALUE_PAIR     *pw_vp2 = NULL_VP;	/* Save password. */
	VALUE_PAIR     *vp1;
	VALUE_PAIR     *vp2;
	char           *pw1 = *p_pw1;		/* Saved password (if any) */
	char            pw2[AUTH_PASS_LEN + 1];
	static char     pw1_buff[AUTH_PASS_LEN + 1];
	static char    *func = "authreq_dup_check";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/*
	 *	If the packet types are different,
	 *	or the source IP address is different,
	 *	or the source UDP port is different,
	 *	or the lengths are different, then
	 *	it can not be a duplicate.
	 */
	if (auth1->code != auth2->code ||		/* Packet type */
		auth1->ipaddr != auth2->ipaddr ||	/* Source IP address */
		auth1->udp_port != auth2->udp_port ||	/* Source UDP port # */
		auth1->rcv_len != auth2->rcv_len)	/* Packet length */
	{
		/* Definitely is NOT a duplicate. */
		*p_why = "source, packet type or length different";
		return (0);
	}

	/*
	 *	If the packet type, source IP address,
	 *	the source UDP port, the sequence number,
	 *	and the reply vector are the same, then
	 *	it is a duplicate.
	 */
	if (auth1->rep_id == auth2->rep_id) 
	{
		if (memcmp (auth1->repvec, auth2->repvec, AUTH_VECTOR_LEN) == 0)
		{
			/* Definitely IS a duplicate. */
			*p_why = "reply id and authenticating vector match";
			return (1);
		}
	}

	/*
	 *	Packet type, source IP address, source UDP port,
	 *	and received length are all the same.  Plus
	 *	either the sequence number or the authenticating
	 *	vector are different (or both).
	 *
	 *	If the client is not a NAS (assume it's a PROXY),
	 *	presume that it will change the reply id and the
	 *	authenticating vector only for completely new
	 *	requests, nor for retransmissions.  For instance,
	 *	the Merit AAA Server does NOT change the reply id
	 *	and the authenticating vector when it retransmits.
	 *
	 *	However, allow some non-NAS clients to require the
	 *	more extensive checking by configuring "check_all"
	 *	in the "clients" file, if that proves necessary.
	 */
	if ((auth1->client->client_type & CE_NAS) == CE_NAS) /* came from NAS */
	{
		/*
		 * For some NAS vendors, the reply id and authenticating
		 * vector are changed based on PPP exchanges, so if the
		 * PPP client retransmits, everything is the same EXCEPT
		 * the reply ID and vector.
		 *
		 * These requests need to be processed further by
		 * comparing each and every attribute.   The attribute
		 * order is assumed to be preserved for these kinds of
		 * re-transmissions.
		 *
		 * The default should be to do more extensive checking,
		 * but some NAS vendors may not behave in this way.
		 * Therefore, let the check be overridden by a configuration
		 * in the "clients" file.
		 */
		if ((auth1->client->client_type & CE_NO_CHECK) == CE_NO_CHECK)
		{
			/*
			 * The clients file indicates that PPP retransmissions
			 * won't cause the reply id and authenticating vector
			 * to be changed.
			 *
			 * Leave now, indicating that this is NOT a duplicate.
			 */
			*p_why = "new request (NAS, config)";
			return (0);
		}

		/* Fall through to more extensive checking. */
	}
	else /* was not from a NAS */
	{
		if ((auth1->client->client_type & CE_CHECK_ALL) == 0)
		{
			*p_why = "new request (non-NAS, default)";
			return (0);
		}
	}

	/*
	 *	EXTENSIVE, attribute by attribute checking.
	 *
	 *	Still may be a duplicate, check all attributes to be sure.
	 *
	 *	"vp1" is the current attribute/value pair from the
	 *	incoming request.
	 *
	 *	"vp2" is the attribute/value pair from the request
	 *	which we are checking to see if it is a duplicate.
	 */
	for (vp1 = auth1->request, vp2 = auth2->request; 
		(vp1 != NULL_VP) && (vp2 != NULL_VP);
		vp1 = vp1->next, vp2 = vp2->next)
	{
		/*
		 *	The lvalue of the attribute structure is the
		 *	data payload for the integer types and the
		 *	length of the string types.  Since it is always
		 *	compared, check it here for effeciency.
		 *
		 *	Check it first, because new, incoming requests
		 *	which are retransmissions of already enqueued
		 *	requests will probably have the same attributes
		 *	in the same order, differing only in their value(s).
		 */
		if (vp1->lvalue != vp2->lvalue) /* Definitely not duplicate. */
		{
			*p_why = "not a dup (value/length)";
			return (0);
		}

		/* Easy check for attribute and vendor_id match */
		if (vp1->ap != vp2->ap) /* Definitely is not a duplicate. */
		{
			*p_why = "not a dup (attr)";
			return (0);
		}

		/* Compare tags, too. */
		if (vp1->tag != vp2->tag)
		{
			*p_why = "not a dup (tags)";
			return (0);
		}

		da = vp1->ap;		/* Get dictionary entry */
		vp_type = da->type;	/* Attribute type (string, etc.) */

		/*
		 * 	If this attribute is not a string type,
		 *	then all the comparisons are done.
		 *	Attributes vp1 and vp2 are equal.
		 */
		if ((vp_type != PW_TYPE_STRING) &&
			(vp_type != PW_TYPE_TAG_STR)

#if defined(BINARY_FILTERS)
		    && (vp_type != PW_TYPE_FILTER_BINARY)
#endif /* BINARY_FILTERS */

#if !defined(NO_EXTENDED_TYPES)
		    && (vp_type != PW_TYPE_OCTETS)
		    && (vp_type != PW_TYPE_VENDOR)
#endif /* !defined(NO_EXTENDED_TYPES) */

			)
		{
			continue;	/* Attributes vp1 and vp2 are equal. */
		}

		/*
		 *	If this attribute is a User-Password,
		 *	then special case code handles it below.
		 */
		if ((vp1->attribute != PW_USER_PASSWORD) ||
			(da->vendor_id != VC_RADIUS))
		{
			/* Default string matching check. */
			if (memcmp (vp1->strvalue, vp2->strvalue,
					vp1->lvalue) == 0)
			{
				/*
				 *	The request might be a duplicate
				 *	(if all the rest match, too.)
				 */
				continue;
			}

			/* Attribute vp1 is different from vp2. */
			*p_why = "string mismatch";
			return (0);	/* Not a duplicate */
		}

		if ((pw_vp1 != NULL_VP) || (pw_vp2 != NULL_VP))
		{
			logit (LOG_DAEMON, LOG_INFO,
			     "%s: More than one password in request (ignored)",
				func);
		}
		else /* Save the passwords for later processing. */
		{
			pw_vp1 = vp1;
			pw_vp2 = vp2;
		}
	} /* end of for each of the attribute in both requests */

	/*
	 *	At this point, all that's left to compare are the passwords.
	 *	Since this attribute is a User-Password,
	 *	just decrypt it and compare the passwords.
	 *
	 *	Note that the caller is informed what the password
	 *	in auth1 was via the p_pw1 and p_pw_vp1 parameters.
	 */

	if (*p_pw_vp1 == NULL_VP)
	{
		*p_pw_vp1 = pw_vp1;	/* Save it. */
	}
	else
	{
		if (*p_pw_vp1 != pw_vp1)
		{
			logit (LOG_DAEMON, LOG_CRIT,
				"%s: Internal error, *p_pw_vp1 != pw_vp1",
				func);
			pw1 = (char *) NULL;	/* Force decryption again. */
		}
	}

	/*
	 *	Check to see if the password of the incoming request has been
	 *	decrypted.
	 *
	 *	Warning: This code assumes that only ONE User-Password will
	 *	be present in a request at a time.
	 */
	if (pw1 == (char *) NULL)
	{
		/* 
		 *	Indicate that the password of the new
		 *	request has been decrypted.
		 */
		pw1 = pw1_buff;

		/* Decrypt the newly arrived password. */
		get_passwd (auth1, pw1, (char *) NULL, (char *) NULL);
		*p_pw1 = pw1;
	}

	/* Try to decrypt the password that is on the queue. */
	if (get_passwd (auth2, pw2, (char *) NULL, (char *) NULL) != 0)
	{
		/* Unable to get a password decrypted. Not a match. */
	  	*p_why = "queued User-Password fail";
		return (0);	/* Assume not a duplicate */
	}

	/* Compare the passwords. (Passwords shouldn't have NULL's in them.) */
	if (strcmp (pw1, pw2) != 0)	/* Passwords aren't the same. */
	{
		/* Safety, clear the passwords. */
	  	memset ((char *) pw1_buff, 0, sizeof (pw1_buff));
	  	memset ((char *) pw2, 0, sizeof (pw2));
		*p_why = "User-Password mismatch";
		return (0);
	}

	/* Safety, clear the passwords. */
	memset ((char *) pw1_buff, 0, sizeof (pw1_buff));
	memset ((char *) pw2, 0, sizeof (pw2));

	return (1);		/* Everything matches. */

} /* end of authreq_dup_check () */

/*************************************************************************
 *
 *	Function: authreq_q_size
 *
 *	Purpose: Indicate current length of authentication or accounting queue.
 *
 *************************************************************************/

static int
authreq_q_size (authreq)

AUTH_REQ       *authreq;

{
	int             count;

	for (count = 0; authreq != (AUTH_REQ *) NULL; authreq = authreq->next)
	{
		count++;
	}

	return count;
} /* end of authreq_q_size () */

/*************************************************************************
 *
 *	Function: authreq_holdtime
 *
 *	Purpose: Compute cleanup hold time for the given AUTH_REQ.
 *
 *	Returns: hold time in seconds.
 *
 *************************************************************************/

int
authreq_holdtime (authreq)

AUTH_REQ       *authreq;

{
	int             hold_time;

	/* By default, use the value configured in the clients file. */
	hold_time = authreq->client->reply_holdtime;

	if (hold_time == 0)	/* Then, use what's left in the authreq */
	{
		hold_time = authreq->ttl;
	}

	/* Calculate the average holding (floored) time now. */
	if ((hold_time = cleanup_delay (hold_time)) > 0)
	{
		return hold_time;
	}

	return 1;	/* Safety */
} /* end of authreq_holdtime () */

/*************************************************************************
 *
 *	Function: build_acct_req
 *
 *	Purpose: Build an acct-request structure, fill out the header and
 *		 other values and attach attribute-value pairs as needed.
 *
 *	Returns: a pointer to an authreq data structure,
 *		 or NULL, if the queue is too full.
 *
 *************************************************************************/

AUTH_REQ *
build_acct_req (authreq, status, session_id, stime, pairs)

AUTH_REQ       *authreq;		/* optional (may be NULL), so ignore */
int             status;			/* required! */
char           *session_id;		/* optional (may be NULL), so create */
time_t          stime;			/* session time */
VALUE_PAIR     *pairs;			/* optional (may be NULL), so ignore */

{
	int             flag;
	int             qcount = 0;
	UINT4           ip;	/* Dummy value for find_client_by_name() call */
	time_t          now = time (0);
	AUTH_REQ       *acctreq;
	VALUE_PAIR     *vp;
	VALUE_PAIR     *name;
	VALUE_PAIR     *nas;
	VALUE_PAIR    **prev_ptr;
	FILE           *debugout = stdout;
	char            buf[AUTH_STRING2_LEN];
	static int      id = -1;
	static char    *func = "build_acct_req";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (ddt != (FILE *) NULL)
	{
		debugout = ddt;
	}

	/*
	 *	Allocate the new accounting data structure.
	 */

	if ((acctreq = (AUTH_REQ *) calloc (1, sizeof (AUTH_REQ)))
							== (AUTH_REQ *) NULL)
	{
		logit (LOG_DAEMON, LOG_ALERT, "%s: FATAL out of memory", func);
		abort ();
	}
	authreq_mf.m++;

	/*
	 *	Fill header fields
	 */

	acctreq->ipaddr = get_our_addr ();
	acctreq->udp_port = 0;		/* dummy values -- don't care */
	acctreq->rep_id = 0;		/* dummy values -- don't care */
	acctreq->fwd_id = 0;
	acctreq->code = PW_ACCOUNTING_REQUEST;
	memset ((char *) acctreq->repvec, 0, sizeof (authreq->repvec));
	memset ((char *) acctreq->fwdvec, 0, sizeof (authreq->fwdvec));

	if (authreq != (AUTH_REQ *) NULL) /* Pick up client from here. */
	{
		acctreq->client = authreq->client;
	}
	else
	{
		if (find_client_by_name (RADIUS_LOCALSERVER, &ip,
					&acctreq->client) < 0)
		{
			acctreq->client = (CLIENT_ENTRY *) NULL;
		}
	}
	acctreq->ttlslice = MAX_ACCT_REQUEST_TIME; /* About three minutes. */
	acctreq->ttl = MAX_ACCT_REQUEST_TIME;
	acctreq->timer = DEFAULT_TIMER_VALUE;
	acctreq->retry_cnt = 0;
	acctreq->seqch_cnt = 0;
	acctreq->retry_limit = default_retry_limit;
	acctreq->seqch_limit = default_seqch_limit;
	acctreq->vers_in = 0;
	acctreq->vers_out = 0;
	acctreq->flags = 0;
	acctreq->realm_filter = (char *) NULL;

	if (authreq != (AUTH_REQ *) NULL) /* Pick up state from where we are. */
	{
		acctreq->state = authreq->state;
		acctreq->debug_flag = authreq->debug_flag;
	}
	else
	{
		acctreq->state = ST_INIT;
		acctreq->debug_flag = 0;	/* No special debugging. */
	}

	acctreq->sws = 0;

	if (global_acct_q.hold > 0)
	{
		SAR_HOLD(acctreq);	/* Set hold flag in sws. */
	}

	acctreq->repstatus = -2;	/* invalid value */
	acctreq->fsmstatus = EV_NAK;	/* initial value */
	acctreq->cur_count = 0;
	acctreq->onqueue = now;
	acctreq->starthg = now;
	acctreq->startlas = now;
	acctreq->fsm_aatv = (AATV *) NULL;
	acctreq->direct_aatv = (AATV *) NULL;
	acctreq->event_q = (EVENT_ENT *) NULL;
	acctreq->proc_q = (PROC_ENT *) NULL;
	acctreq->next = (AUTH_REQ *) NULL;
	acctreq->request = NULL_VP;
	acctreq->cur_request = NULL_VP;
	acctreq->user_check = NULL_VP;
	acctreq->user_deny = NULL_VP;

	if (pairs != NULL_VP)
	{
		dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: pairs list:", func));
		debug_list (debugout, pairs);
	}

	flag = 0;
	if (authreq != (AUTH_REQ *) NULL)
	{
		dprintf(2, (LOG_DAEMON, LOG_DEBUG,
			"%s: authreq->cur_request:", func));
		debug_list (debugout, authreq->cur_request);

		if (get_vp (authreq->cur_request,
				PW_ACCT_STATUS_TYPE) == NULL_VP)
		{
			avpair_add (&acctreq->request, PW_ACCT_STATUS_TYPE,
				    &status, 0);
		}

		if (status == PW_STATUS_MODEM_STOP)
		{
			if (get_vp (authreq->cur_request,
					PW_ACCT_SESSION_TIME) == NULL_VP)
			{
				avpair_add (&acctreq->request,
					    PW_ACCT_SESSION_TIME, &stime, 0);
			}
		}

		if ((vp = get_vp (authreq->cur_request,
					PW_ACCT_SESSION_ID)) == NULL_VP)
		{
			flag = 1; /* Since no Acct-Session-Id can be present */
		}
	}
	else /* was NULL */
	{
		flag = 1;
		avpair_add (&acctreq->request, PW_ACCT_STATUS_TYPE, &status, 0);
		avpair_add (&acctreq->request, PW_ACCT_SESSION_TIME, &stime, 0);
	}

	if (flag == 1) /* This ACCT packet needs an Acct-Session-Id */
	{
		if (session_id == (char *) NULL) /* create unique one */
		{
			sprintf (buf, "%08X", ++id);
		}
		else /* use the one given by the caller */
		{
			memcpy (buf, session_id, 8);
		}
		avpair_add (&acctreq->request, PW_ACCT_SESSION_ID, buf, 8);
	}

	if (pairs != NULL_VP)
	{
		list_copy (&acctreq->request, pairs);
	}

	if ((authreq != (AUTH_REQ *) NULL) && (authreq->cur_request != NULL_VP))
	{
		list_copy (&acctreq->request, authreq->cur_request);
	}

	/* Remove attributes which should never be in ACCT packet (per RFC) */

	for (prev_ptr = &acctreq->request, vp = *prev_ptr;
		vp != NULL_VP;
		vp = *prev_ptr)
	{
		switch (vp->ap->vendor_id)
		{
		    default:	/* No special treatment for unknown vendors. */
			break;

		    case VC_RADIUS:	/* Standard attribute space. */
			switch (vp->attribute)
			{
			    case PW_USER_PASSWORD:
			    case PW_CHAP_PASSWORD:
			    case PW_REPLY_MESSAGE:
			    case PW_STATE:
				/* Remove these from the request list. */
				*prev_ptr = vp->next;
				avpair_free (vp);
				continue;

			    default:
				break;
			}
			break;

		    case VC_MERIT:	/* Merit vendor specific attributes. */
			switch (vp->attribute)
			{
			    case PW_PROXY_ACTION:
				/* Remove these from the request list. */
				*prev_ptr = vp->next;
				avpair_free (vp);
				continue;

			    default:
				break;
			}
			break;
		}

		/* Leave all others in request list. */
		prev_ptr = &vp->next;
	}

	list_copy (&acctreq->cur_request, acctreq->request);
	debug_list (debugout, acctreq->cur_request);

	if (enqueue_authreq (&global_acct_q, acctreq) == (AUTH_REQ *) NULL)
	{
		name = get_vp (acctreq->cur_request, PW_USER_NAME);
		nas = get_vp (acctreq->cur_request, PW_NAS_IDENTIFIER);
		vp = get_vp (acctreq->cur_request, PW_NAS_PORT);

		logit (LOG_DAEMON, LOG_INFO,
			"%s: global_acct_q.limit (%d) exceeded (%d)",
			func, global_acct_q.limit, qcount);

		logit (LOG_DAEMON, LOG_INFO,
			"%s: Acct-Status-Type %d - %s on port %ld of %s",
			func, status,
			(name != NULL_VP) ? name->strvalue : "'?'",
			(vp != NULL_VP) ? vp->lvalue : -1,
			(nas != NULL_VP) ? nas->strvalue : "'?'");

		/* Mark it free'd so that free_authreq_final() does free it. */
		SAR_FREED(acctreq);
		free_authreq_final (acctreq);
		return (AUTH_REQ *) NULL;	/* Rejected */
	}

	return acctreq;
} /* end of build_acct_req () */

/*************************************************************************
 *
 *	Function: call_action
 *
 *	Purpose: Calls the action function specified by the AATV argument.
 *
 *	Returns: The result (return code or "event") of the action function.
 *
 *************************************************************************/

int
call_action (aatv, authreq, value, afpar)

AATV           *aatv;
AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	int             i;
	int             old_debug = debug_flag;
	int             pid;
	int             result;
	AATV           *previous_aatv = (AATV *) NULL;
	PROC_ENT       *pe;
	VALUE_PAIR     *vp;
	sigset_t        signals;
	struct sigaction action;
	char            buffer[AUTH_STRING1_LEN];
	static char    *func = "call_action";

	if (aatv == (AATV *) NULL)
	{
		dprintf(2, (LOG_DAEMON, LOG_DEBUG,
			"%s: configuration error: NULL AATV, value %d and '%s'",
			func, value,
			(afpar == (char *) NULL) ? "?" : afpar));
		return EV_FATAL;
	}

	dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		"%s: AATV '%s', type %d, value %d and '%s'", func, aatv->id,
		aatv->aatvfunc_type, value,
		(afpar == (char *) NULL) ? "?" : afpar));

	if (authreq != (AUTH_REQ *) NULL)
	{
		if (aatv != authreq->fsm_aatv)
		{
			if (authreq->fsm_aatv != (AATV *) NULL)
			{
				authreq->direct_aatv = aatv;
			}
			else	/* Need to init fsm_aatv value */
			{
				authreq->fsm_aatv = aatv;
			}
		}

		/*
		 *	Modify debugging on a per-authreq basis.
		 */
		if (authreq->debug_flag > debug_flag)
		{
			/*
			 *	XXX: This code could turn on debugging that
			 *		had been off. Something needs to be
			 *		done here about the debug files!
			 */
			debug_flag = authreq->debug_flag;
		}
	}

	if (aatv->act_func == (int (*) ()) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s: configuration error: NULL action function: %s",
			func, aatv->id);

		/* Sideways exit, restore debug_flag. */
		debug_flag = old_debug;
		return EV_FATAL;
	}

	pid = 0;

	/* If we're a child process, do some special things... */
	if (child_aatv != (AATV *) NULL)
	{
		if (aatv->aatvfunc_type == AA_SOCKET)
		{
			logit (LOG_DAEMON, LOG_ERR,
		  "%s: socket type AATV %s called in child from AATV %s via %s",
				func, aatv->id,
				(current_aatv == (AATV *) NULL)
					? (u_char *) "?" : current_aatv->id,
				child_aatv->id);

			/* Sideways exit, restore debug_flag. */
			debug_flag = old_debug;

			return EV_FATAL;	/* Maybe abort() instead? */
		}

		/* Change the title to reflect the active AATV. */
		rad_ptitle ("%s -> AATV %s %d %s", child_aatv->id, aatv->id,
				value, (afpar == (char *) NULL) ? "?" : afpar);
		previous_aatv = current_aatv;	/* Stack for restoring later. */
		current_aatv = aatv;
	}

	switch (aatv->aatvfunc_type)
	{
	    case AA_DIRECT:
	    case AA_SOCKET:
		result = aatv->act_func (authreq, value, afpar);
		break;

	    case AA_FREPLY:
		authreq->vers_out = HIVER;
		/****FALLTHROUGH***/

	    case AA_FORK:
		/*
		 *	If -s option was specified,
		 *	then no child process is started.
		 *	So we wait.
		 */
		if (spawn_flag == 0)
		{
			result = aatv->act_func (authreq, value, afpar);
		}
		else
		{
			if ((aatv->proc_max != 0) &&
				(aatv->proc_cnt >= aatv->proc_max))
			{
				if ((pe =
					(PROC_ENT *) malloc (sizeof (PROC_ENT)))
							== (PROC_ENT *) NULL)
				{
					logit (LOG_DAEMON, LOG_ALERT,
					       "%s: FATAL out of memory", func);
					abort ();
				}

				waldo_mf.m++; /* Count as waldo, even if not */

				/* Set up the previous pointer. */
				pe->aatv_prev = &(aatv->proc_q);
				aatv->proc_q_cur++;	/* Count current */

				/* Remember when we queued it. */
				aatv->proc_q_last = time (0);
				pe->queued_t = aatv->proc_q_last;

				if (aatv->proc_q_cur >= aatv->proc_q_hi)
				{
					aatv->proc_q_hi = aatv->proc_q_cur;
					aatv->proc_q_hi_t = aatv->proc_q_last;
				}

				/*
				 * If there is a list, reset the previous
				 * pointer of the first element on the list.
				 */
				if (aatv->proc_q != (PROC_ENT *) NULL)
				{
					aatv->proc_q->aatv_prev =
								&pe->aatv_next;
				}
				pe->aatv_next = aatv->proc_q;
				aatv->proc_q = pe;

				/* Indicate the AATV for which we're waiting. */
				pe->sub_aatv = aatv;

				/* Link onto the authreq, too. */
				pe->next = authreq->proc_q;
				authreq->proc_q = pe;
				pe->authreq = authreq;

				pe->fsm_aatv = authreq->fsm_aatv;
				pe->direct_aatv = authreq->direct_aatv;
				pe->state = authreq->state;
				pe->evalue = value;
				strcpy (pe->estring, afpar);

				dprintf(2, (LOG_DAEMON, LOG_DEBUG,
					"%s: event [%d '%s' '%s' %d '%s']",
					func, pe->state,
					(pe->fsm_aatv == (AATV *) NULL)
					    ? (u_char *) "?" : pe->fsm_aatv->id,
					(pe->sub_aatv == (AATV *) NULL)
					    ? (u_char *) "?" : pe->sub_aatv->id,
					pe->evalue,
					(pe->estring[0] == '\0')
					    ? "?" : pe->estring));

				/* Sideways exit, restore debug_flag. */
				debug_flag = old_debug;

				return EV_WAIT;
			}

			if (msgfd != (FILE *) NULL)
			{
				fflush (msgfd);
			}

			/* Call fork() and set title of child radiusd process */
			pid = (int) rad_fork ("AATV %s %d %s", aatv->id, value,
					(afpar == (char *) NULL) ? "?" : afpar);
			if (pid < 0)
			{
				logit (LOG_DAEMON, LOG_ALERT, "%s: fork: %s",
					func, get_errmsg ());
				result = EV_FATAL;
				break;
			}
			else
			{
				if (pid != 0) /* Parent proc returns */
				{
					result = EV_WAIT;
					aatv->proc_cnt++;
					if (aatv->proc_cnt >= aatv->proc_cnt_hi)
					{
						aatv->proc_cnt_hi =
								aatv->proc_cnt;
						aatv->proc_cnt_hi_t = time (0);
					}
					break;
				}
			}

/* ---------- CHILD CODE STARTS ----------------------------- */
			spawn_flag = 0;	/* Force future calls to go direct. */
			child_aatv = aatv;	/* Recall what AATV we're in */
			current_aatv = aatv;	/* ...ditto, but is variable */

			/*
			 *	Change SIGHUP handler in child process.
			 */

			memset ((char *) &action, '\0', sizeof (action));
			sigaction (SIGHUP, &action, NULL);
			action.sa_handler = sig_quit;	/* Child terminator */

			/*
			 *	Allow only certain signals within the child.
			 */

			sigemptyset (&signals);	/* Child signal allow mask */
			sigaddset (&signals, SIGQUIT);
			sigaddset (&signals, SIGTERM);
			sigaddset (&signals, SIGHUP);
			sigaddset (&signals, SIGUSR1);
			sigaddset (&signals, SIGUSR2);
			sigaddset (&signals, SIGILL);
			sigaddset (&signals, SIGIOT);
			sigaddset (&signals, SIGTRAP);
			sigaddset (&signals, SIGFPE);

			sigprocmask (SIG_UNBLOCK, &signals, NULL);

			/*
			 *	For these two forking types, close
			 *	the normal RADIUS and Accounting
			 *	sockets so as not to confuse x/inetd(8).
			 *
			 *      Make sure the child process has the
			 *      correct authenticator/vector.
			 *
			 *	Child process continues with call to
			 *	service new request.
			 *
			 *	Child exits with return code from the
			 *	act_func for given authentication type.
			 *
			 *	For FREPLY types, send the attributes
			 *	back to the parent on a socket.
			 */

			if (rad_server_aatv->sockfd != -1)
			{
				/*
				 *	Close STDOUT, STDERR, if they're the
				 *	same as STDIN, which they are for
				 *	(x)inetd started processes.
				 */
				if (rad_server_aatv->sockfd == STDIN_FILENO)
				{
					for (i = STDOUT_FILENO;
						i <= STDERR_FILENO;
						i++)
					{
						if (fdcmp (i,
							STDIN_FILENO) == 0)
						{
							close (i);
						}
					}
				}

				close (rad_server_aatv->sockfd);
				rad_server_aatv->sockfd = -1;
			}

			if (rad_acct_aatv->sockfd != -1)
			{
				close (rad_acct_aatv->sockfd);
				rad_acct_aatv->sockfd = -1;
			}

			memcpy ((char *) authreq->fwdvec,
				(char *) authreq->repvec, AUTH_VECTOR_LEN);

			if (aatv->aatvfunc_type == AA_FREPLY)
			{
				/*
				 *	Note: this will not be necessary
				 *	when the waldo matching changes.
				 */
				if ((vp = avpair_add_vend (NULL,
					PW_PROXY_ACTION, authreq->fsm_aatv->id,
					-1, VC_MERIT)) != NULL_VP)
				{
					/*
					 *	Place at the beginning
					 *	of the cur_request list.
					 */
					vp->next = authreq->cur_request;
					authreq->cur_request = vp;
				}

				/*
				 *	The Proxy-State goes at the end
				 *	of the cur_request list.
				 */
				sprintf (buffer, "%d", authreq->state); /*YYY*/
				avpair_add (&authreq->cur_request,
						PW_PROXY_STATE, buffer, -1);
			}

			/* Call the action function to the the actual work. */
			result = aatv->act_func (authreq, value, afpar);

			if (msgfd != (FILE *) NULL)
			{
				fflush (msgfd);
			}

			if (aatv->aatvfunc_type == AA_FREPLY)
			{
				/* Note: no retries here... */
				(void) fork_reply (authreq, result);

				child_done = 1;

				/* Wait here to get our reply */
				rad_sleep (90, "AA_FREPLY %s", aatv->id);

				/*
				 *	Will be killed whether we make
				 *	it here or not.
				 */

				/***** normally NOTREACHED *****/

				logit (LOG_DAEMON, LOG_ERR,
					"%s: zombie child AATV %s",
					func, aatv->id);

				if (msgfd)
				{
					fclose (msgfd);
				}

				_exit (EV_WAIT);
			}

			_exit (result);
/* ---------- CHILD CODE ENDS ----------------------------- */

		} /* end of else (spawn_flag) */
		break;
	} /* end of switch () */

	/* For child AATVs, restore old title. */
	if (child_aatv != (AATV *) NULL)
	{
		current_aatv = previous_aatv;

		if (current_aatv != (AATV *) NULL)
		{
			/* Restore the old title to reflect the active AATV. */
			rad_ptitle ("%s -> AATV %s ...", child_aatv->id,
					current_aatv->id);
		}
	}

	/* If there is an event pending... */
	if ((aatv->aatvfunc_type != AA_DIRECT) && (result == EV_WAIT))
	{
		if (record_event (authreq, aatv, pid, value, afpar) != 0)
		{
			logit (LOG_DAEMON, LOG_CRIT,
			 "%s: Unable to record event: AATV=%s, value=%d, '%s'",
				func, aatv->id, value, afpar);
			result = EV_FATAL;
		}
	}

	debug_flag = old_debug; /* restore debug_flag */

	return result;
} /* end of call_action () */

/*************************************************************************
 *
 *	Function: check_reply
 *
 *	Purpose: Check to see if certain reply items match the original
 *		 items (or the current-list items anyway.)  Note that
 *		 this test has no functional affect, it is only a check
 *		 which may or may not log something to the event logfile.
 *
 *************************************************************************/

static int
check_reply (authreq, list)

AUTH_REQ       *authreq;
VALUE_PAIR     *list;

{
	int             reply_mismatches;
	VALUE_PAIR     *chk_rep;
	VALUE_PAIR     *chk_cur;
	DICT_ATTR_LIST *rep_check;
	char           *func = "check_reply";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	reply_mismatches = 0;

	if (reply_check_list != (DICT_ATTR_LIST *) NULL)
	{
		for (rep_check = reply_check_list;
			rep_check != (DICT_ATTR_LIST *) NULL;
			rep_check = rep_check->next)
		{
			if (((chk_rep = get_vp_vend (list,
				rep_check->ap->value,
				rep_check->ap->vendor_id)) != NULL_VP) &&
			    ((chk_cur = get_vp_vend (authreq->cur_request,
				rep_check->ap->value,
				rep_check->ap->vendor_id)) != NULL_VP))
			{
				if (avpair_comp (chk_rep, chk_cur) != 0)
				{
					reply_mismatches++;
					logit (LOG_DAEMON, LOG_CRIT,
				       "%s: Reply %s does not match, %s != %s",
						func, rep_check->ap->name,
						avpair_vtoa (chk_rep, 0),
						avpair_vtoa (chk_cur, 0));
				}
			}
		}
	}

	return reply_mismatches;

} /* end of check_reply () */

/*************************************************************************
 *
 *	Function: child_end
 *
 *	Purpose: Invoked by SIGCHLD signal.  Some authentication requests
 *		 are handled by child processes in order to prevent blocking
 *		 the server process.  This routine handles the termination of
 *		 spawned processes.  A "EVENT_ENT" item corresponding to the
 *		 terminated process is found (which contains the PID of the
 *		 now deceased child).  The saved "state" (at the time of the
 *		 fork() call) along with the "event" (the child's return code)
 *		 are together presented to the state machine as a new "event".
 *		 The exit code of the child indicates the result (event) of
 *		 the action function (EV_NAK, EV_ACK, EV_ERROR, etc.).
 *
 *************************************************************************/

static void
child_end (signo)

int             signo;

{
	char            short_result;
	int             result;
	int             status;
	AUTH_REQ       *authreq;
	AUTH_REQ      **prev;
	AUTH_REQ_Q     *aaq;
	EVENT_ENT      *event;
	EVENT_ENT     **prev_event;
	int             pid;
	EV              ev;
	static char    *func = "child_end";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	while ((pid = (int) waitpid ((pid_t) -1, &status, WNOHANG)) > 0)
	{
		dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: PID = %d", func, pid));

		result = 0;

		/* Scan all queues.  The auth queue is first. */
		for (aaq = &global_auth_q;
			aaq != (AUTH_REQ_Q *) NULL;
			aaq = aaq->next)
		{
			/* Scan each queue for the authreq matching the PID */
			for (prev = &(aaq->q);
				(authreq = *prev) != (AUTH_REQ *) NULL ;
				prev = &authreq->next)
			{
				for (prev_event = &authreq->event_q ;
					(event = *prev_event) ;
					prev_event = &event->next)
				{
					if ((event->pid != 0) &&
						(debug_flag > 0))
					{
						dprintf(2, (LOG_DAEMON,
							LOG_DEBUG,
						  "%s request %u event PID=%d",
							aaq->q_name, 
							authreq->fwd_id,
							event->pid));
					}

					if (event->pid == (pid_t) pid)
					{
						result = 1;
						break;
					}
				}

				if (result == 1) /* Stop scanning authreqs */
				{
					break;
				}
			}

			if (result == 1) /* Stop scanning each global queue */
			{
				break;
			}
		}

		/* If the PID was found, then the authreq will be non-NULL */
		if (authreq != (AUTH_REQ *) NULL)
		{
			aatv_process_end (event->sub_aatv);

			if (WIFEXITED(status)) /* recover the event */
			{
				short_result = WEXITSTATUS(status);

				dprintf(2, (LOG_DAEMON, LOG_DEBUG,
					"%s: %s exit status: %X",
					func, aaq->q_name, short_result));

				result = short_result;
			}
			else /* child died some other (non-normal) way */
			{
				if (authreq->ttl != 0) /* not a timeout */
				{
					logit (LOG_DAEMON, LOG_INFO,
		 "%s: %s Authtype %d child process terminated abnormally - %X",
						func, aaq->q_name,
						event->sub_aatv->authen_type,
						status);

					reply_sprintf (0, authreq,
						"Realm processing error");
					result = EV_NAK;
				}
				else		/* indicate timeout */
				{
					result = EV_ERROR;
				}
			}

			ev.state = event->state;
			ev.a.aatv = event->fsm_aatv;
			ev.isproxy = 0;
			ev.value = result;
			strcpy (ev.xstring, event->estring);

			/* unlink this EVENT_ENT and free the memory */
			*prev_event = event->next;
			state_machine (ev, authreq);
			free (event);
			waldo_mf.f++;
		}
		else
		{
			if (pid == dnspid)
			{
				logit (LOG_DAEMON, LOG_INFO,
					"%s: DNS update finished", func);
				dnspid = 0;
			}
			else /* authreq was null */
			{
				logit (LOG_DAEMON, LOG_INFO,
					"%s: stray process end, PID %d",
					func, pid);
			}
		}
	} /* end of while () */

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: leaving routine", func));

	return;
} /* end of child_end () */

/*************************************************************************
 *
 *	Function: cleanup_delay
 *
 *	Purpose: Calculate the current cleanup_delay.
 *
 *	Returns: The cleanup_delay to be used.
 *
 *************************************************************************/

static int
cleanup_delay (min_delay)

int             min_delay;	/* Minimum delay time to be used. */

{
	int             i;
	int             result = 0;
	static char    *func = "cleanup_delay";

	for (i = 0; i < CLEANUP_BUCKETS; i++)
	{
		/* Don't let the average fall below the minimum delay time. */
		result += MAX(rad_reply_times[i], min_delay);
	}
	result /= CLEANUP_BUCKETS;	/* Get average. */

	return result;
} /* end of cleanup_delay () */

/*************************************************************************
 *
 *	Function: config_initialize
 *
 *	Purpose: intializes configuration values:
 *
 *		 expiration_seconds - When updating a user password,
 *			the amount of time to add to the current time
 *			to set the time when the password will expire.
 *			This is stored as the VALUE Password-Expiration
 *			in the dictionary as number of days.
 *
 *		 warning_seconds - When acknowledging a user authentication,
 *			time remaining for valid password to notify user
 *			of password expiration.
 *
 *************************************************************************/

static int
config_initialize ()

{
	DICT_VALUE     *dval;
	static char    *func = "config_initialize";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((dval = dict_valfind ("Password-Expiration", (char *) NULL))
							== (DICT_VALUE *) NULL)
	{
		expiration_seconds = (UINT4) 0;
	}
	else
	{
		expiration_seconds = dval->dv_value * (UINT4) SECONDS_PER_DAY;
	}

	if ((dval = dict_valfind ("Password-Warning", (char *) NULL))
							== (DICT_VALUE *) NULL)
	{
		warning_seconds = (UINT4) 0;
	}
	else
	{
		warning_seconds = dval->dv_value * (UINT4) SECONDS_PER_DAY;
	}

	return (0);
} /* end of config_initialize () */

/*************************************************************************
 *
 *	Function: debug_bump
 *
 *	Purpose: Increase debugging level.
 *
 *************************************************************************/

static void
debug_bump (sig)

int             sig;

{
	time_t          now;
	static char    *func = "debug_bump";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (debug_flag == 0)
	{
		debug_flag++;
		set_debug (1);
	}
	else
	{
		debug_flag++;
	}

	if (debug_flag > 0)
	{
		now = time (0);
		fprintf (ddt, "%-24.24s: Debugging ", ctime (&now));
		if (debug_flag == 1)
		{
			fprintf (ddt, "turned ON,");
		}
		else
		{
			fprintf (ddt, "increased to");
		}
		fprintf (ddt, " Level %d\n", debug_flag);
		fprintf (ddt, "%s\n", verinfo (1));
		fprintf (ddt, "Program = %s\n", progname);

		if (debug_flag == 4)
		{
			add_string_dump ();
		}
	}

	return;
} /* end of debug_bump () */

/*************************************************************************
 *
 *	Function: debug_off
 *
 *	Purpose: Disable debugging output.
 *
 *************************************************************************/

static void
debug_off (sig)

int             sig;

{
	static char    *func = "debug_off";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	set_debug (0);

	if (ddt != (FILE *) NULL)
	{
		if ((ddt == stderr) ||
			(fileno(ddt) == fileno(stderr)) ||
			(fileno(ddt) == STDERR_FILENO))
		{
			reset_stderr ("/dev/console", 1);
		}
		else
		{
			(void) fclose (ddt);
		}

		ddt = (FILE *) NULL;
	}

	return;
} /* end of debug_off () */

/*************************************************************************
 *
 *	Function: doconfig (sig)
 *
 *	Purpose: Invoked by HUP signal.  You may issue a HUP signal to
 *		 the server process after updating any of the configuration
 *		 files.  Calls config_files() to set up memory resident info
 *		 from these files.  Closes and re-opens the logfile.
 *
 *      Parameters: sig == 0 if 1st call;
 *                        -1 if call from stat_files;
 *			 > 0 if signal handler call.
 *
 *************************************************************************/

static void
doconfig (sig)

int             sig;

{
	int             n;
	AUTH_REQ_Q     *aaq;
	static char    *func = "doconfig";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	config_init (); /* Ensure doing_init is set */

	if (sig > 0) /* then it really is a signal... */
	{
		logit (LOG_DAEMON, LOG_INFO, "%s: HUP signal received", func);
		select_max = 0; /* Reset the select() time recorder ... */

		for (aaq = &global_auth_q;
			aaq != (AUTH_REQ_Q *) NULL;
			aaq = aaq->next)
		{
			aaq->max = 0; /* ...and the max queue size variables. */
		}

		if (msgfd != (FILE *) NULL)
		{
			setup_logfile (2);	/* Flush and re-open */
		}
	}

	/* Be sure to initialize the FSM only once upon startup! */
	if (sig == 0)
	{
		/* Read the FSM config files into data structures */
		if ((n = init_fsm (nfsm, radius_fsm, &fsm, &default_fsm)) <= 0)
		{
			if ((file_logging == 1) && (msgfd != (FILE *) NULL))
			{
				fflush (msgfd);
			}

			logit (LOG_DAEMON, LOG_INFO,
				"%s: init_fsm() failed", func);

			exit (-3);
		}
		nfsm = n;
	}

#ifdef USR_CCA
        qry_init = FALSE;
#endif	/* USR_CCA */

	logit (LOG_DAEMON, LOG_INFO, "%s: %s", func, verinfo (0));

	n = config_files (cache_users, 1, 1);

	if (n == 0) /* Initialize all AATV modules */
	{
		n = init_aatvs ();
	}
	else
	{
		if ((file_logging == 1) && (msgfd != (FILE *) NULL))
		{
			fflush (msgfd);
		}

		logit (LOG_DAEMON, LOG_INFO, "%s: config_files() failed", func);

		exit (-4);
	}

	config_fini ();

	return;
} /* end of doconfig () */

/*************************************************************************
 *
 *	Function: done_action
 *
 *	Purpose: Log a packet generated internally.
 *
 *	Returns: EV_WAIT, like the NULL AATV.
 *
 *************************************************************************/

static int
done_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	char            log_msg[1024];
	char            log_guard[256];
	static char    *func = "done_action";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (log_generated_request == 0)
	{
		return EV_WAIT;
	}

	if (authreq == (AUTH_REQ *) NULL)
	{
		return EV_WAIT;
	}

	/* If the nolog bit is set, just return. */
	if (TAR_NO_LOG(authreq))
	{
		return EV_WAIT;
	}

	packet_log (log_msg, authreq, 0);
	logit (LOG_DAEMON, LOG_INFO, "Done-%s", log_msg);

	return EV_WAIT;
} /* end of done_action () */

/*************************************************************************
 *
 *	Function: dump_received_packet
 *
 *	Purpose: Dump the first twenty bad proxy_forwarding packets received
 *		 each day.
 *
 *	Returns: 0, if no dump occured,
 *		 1, if a regular dump occured,
 *		 2, if a proxy-forwarding dump occured.
 *
 *************************************************************************/

int
dump_received_packet (func, code, len, sin, reason)

char           *func;		/* Function name that called this. */
int             code;		/* Authtype of packet. */
u_int           len;		/* Length of recv_bufffer[] area. */
struct sockaddr_in *sin;	/* Source IP address, port, etc. */
char           *reason;		/* Why to dump. */

{
	int             rc = 0;		/* Return value */
	time_t          now = time (NULL);
	static int      dump_count = 0;
	static time_t   first_dump = 0;

	/*
	 * If it's been more than a day since the last dump, allow dumps again.
	 */
	if ((now - first_dump) > (24 * 3600))	/* XXX: Use macros for this. */
	{
		if (dump_count > 0)
		{
			logit (LOG_DAEMON, LOG_INFO,
				"dump_received_packet: %d dumps since %s",
				dump_count, rad_time (first_dump, 0));
		}
		dump_count = 0;
		first_dump = now;
	}

	/*
	 * Don't dump more than 20 times a day.
	 */
	if (dump_count >= 20)
	{
		return (0);
	}

	if (reason == (char *) NULL)
	{
		reason = "";	/* No particular reason (sigh) */
	}

	dump_count++;

	logit (LOG_DAEMON, LOG_INFO,
		"%s: %s packet dump #%d, received from %s[%u] -- %s",
		func, authtype_toa (code), dump_count,
		ip_hostname (ntohl(sin->sin_addr.s_addr)),
		ntohs(sin->sin_port), reason);

	if (was_proxy_forwarding > 0)
	{
		dumpit (LOG_DAEMON, LOG_INFO, (u_char *) recv_buffer_backup,
			was_proxy_forwarding, 0,
			"%s: Original PROXY-FORWARDING packet",	func);
		rc++;
	}

	dumpit (LOG_DAEMON, LOG_INFO, (u_char *) recv_buffer, len, 0,
		"%s: Modified %s packet", func, authtype_toa (code));
	rc++;

	return (rc);
} /* end of dump_received_packet () */

/*************************************************************************
 *
 *	Function: enqueue_authreq
 *
 *	Purpose: Queue an authreq, if the queue's limit allows.
 *		 Assign a forwarding ID based on the queue ident.
 *
 *	Returns: the authreq, if enqueued,
 *		 or NULL, if the limits are exceeded.
 *
 *************************************************************************/

AUTH_REQ *
enqueue_authreq (aaq, authreq)

AUTH_REQ_Q     *aaq;		/* Which queue to put authreq on. */
AUTH_REQ       *authreq;	/* Authreq to put on queue. */

{
	static char    *func = "enqueue_authreq";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

#ifdef USR_CCA
	if (authreq->code != PW_RESOURCE_QUERY_REQ &&
		authreq->code != PW_RESOURCE_QUERY_RESP &&
		authreq->code != PW_RESOURCE_FREE_REQ &&
		authreq->code != PW_RESOURCE_FREE_RESP &&
		authreq->code != PW_NAS_REB_REQ &&
		authreq->code != PW_NAS_REB_RESP &&
		aaq->cur >= aaq->limit)
#else	 /* USR_CCA */
	if (aaq->cur >= aaq->limit)
#endif	 /* USR_CCA */

	{
		logit (LOG_DAEMON, LOG_INFO,
		      "%s: Request denied - too many entries (%u) in %s queue",
			func, aaq->cur, aaq->q_name);

		reply_sprintf (0, authreq,
				"Can't process request now, try again later.");

		aaq->q_fail++;
		return (AUTH_REQ *) NULL;	/* Rejected */
	}

	authreq->fwd_id = aaq->ident++;	/* Set forwarding ID */

	authreq->next = *(aaq->p_q_end);/* Link onto the actual queue. */
	(*aaq->p_q_end) = authreq;	/* Modify 'next' ptr at end of queue */
	aaq->p_q_end = &(authreq->next); /* Indicate where new end is. */

	SAR_QUEUED(authreq);		/* Has been queued, mark it so. */
	aaq->cur++;
	aaq->max = MAX(aaq->cur, aaq->max);
	aaq->q_ok++;			/* Count requests queued OK */

	authreq->onqueue = time (0); /* record time when request was enqueued */

	/* Set (or clear) the hold bit in the authreq */
	if (aaq->hold > 0)
	{
		SAR_HOLD(authreq);
	}
	else
	{
		CAR_HOLD(authreq);
	}

	return (authreq);	/* Indicate successful queueing. */
} /* end of enqueue_authreq () */

/*************************************************************************
 *
 *	Function: ev2code
 *
 *	Purpose: Determine the packet code of the reply based on the event.
 *
 *	Returns: The packet code number,
 *		 or -1, if the packet should be dropped.
 *
 *************************************************************************/

static int
ev2code (authreq, result)

AUTH_REQ       *authreq;
int             result;

{
	int             code;
	static char    *func = "ev2code";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	switch (result)
	{
	    case EV_NAK:
		switch (authreq->code)
		{
		    case PW_ACCESS_REQUEST:
			/* Look for any Reply-Message attributes. */
			if (get_vp (authreq->cur_request,
						PW_REPLY_MESSAGE) == NULL_VP)
			{
				reply_sprintf (0, authreq,
						"Authentication failure");
			}

			code = PW_ACCESS_REJECT;
			break;

		    case PW_STATUS_SERVER:
			code = PW_ACCESS_REJECT;
			break;

#ifdef ASCEND
		    case PW_ASCEND_RADIPA_ALLOCATE:
			code = PW_ASCEND_RADIPA_ALLOCATE;
			break;

		    case PW_ASCEND_RADIPA_RELEASE:
			code = PW_ASCEND_RADIPA_RELEASE;
			break;

		    case PW_TERMINATE_SESSION:
			code = PW_PASSWORD_REJECT;
			break;

		    case PW_ASCEND_EVENT_REQUEST:
			code = PW_ASCEND_EVENT_RESPONSE;
			break;

		    case PW_PASSWORD_REQUEST:
			code = PW_PASSWORD_REJECT;
			break;
#endif	/* ASCEND */

		    case PW_ACCOUNTING_RESPONSE:
		    case PW_ACCOUNTING_REQUEST:
			code = -1;
			break;

		    default:
			code = PW_ACCESS_REJECT;
			logit (LOG_DAEMON, LOG_ERR,
				"%s: Rejecting unknown request type (%d)",
				func, authreq->code);
			break;
		} /* end of switch */
		break;

	    case EV_ACK:
		switch (authreq->code)
		{
		    case PW_ACCESS_REQUEST:
			code = PW_ACCESS_ACCEPT;
			break;

		    case PW_PASSWORD_REQUEST:
			code = PW_PASSWORD_ACK;
			break;

		    case PW_ACCOUNTING_REQUEST:
			code = PW_ACCOUNTING_RESPONSE;
			break;

#ifdef USR_CCA
		    case PW_RESOURCE_FREE_REQ:
			code = PW_RESOURCE_FREE_REQ;
			break;

		    case PW_RESOURCE_FREE_RESP:
			code = PW_RESOURCE_FREE_RESP;
			break;

		    case PW_RESOURCE_QUERY_RESP:
			code = PW_RESOURCE_QUERY_RESP;
			break;

		    case PW_RESOURCE_QUERY_REQ:
			code = PW_RESOURCE_QUERY_REQ;
			break;

		    case PW_NAS_REB_REQ:
			code = PW_NAS_REB_RESP;
			break;

#endif	/* USR_CCA */

#ifdef ASCEND
		    case PW_ASCEND_RADIPA_ALLOCATE:
			code = PW_ASCEND_RADIPA_ALLOCATE;
			break;

		    case PW_ASCEND_RADIPA_RELEASE:
			code = PW_ASCEND_RADIPA_RELEASE;
			break;
#endif	/* ASCEND */

		    case PW_STATUS_SERVER:
			code = PW_ACCESS_ACCEPT;
			break;

		    default:
			code = PW_ACCESS_ACCEPT;
			logit (LOG_DAEMON, LOG_ERR,
				"%s: Accepting unknown request type (%d)",
				func, authreq->code);
			break;
		} /* end of switch */
		break;

	    case EV_ERROR:
		switch (authreq->code)
		{
		    case PW_ACCESS_REQUEST:
			code = PW_ACCESS_ERROR;
			break;

		    case PW_ACCOUNTING_REQUEST:
			code = PW_ACCOUNTING_ERROR;
			break;

		    default:
			code = PW_COMMAND_UNRECOGNIZED;
			logit (LOG_DAEMON, LOG_ERR,
				"%s: Error from unknown request type (%d)",
				func, authreq->code);
			break;
		} /* end of switch */
		break;

	    case EV_ACC_CHAL:
		code = PW_ACCESS_CHALLENGE;
		break;

#ifdef ASCEND
	    case EV_PW_EXPIRED:
		switch (authreq->code)
		{
		    case PW_ACCESS_REQUEST:
			code = PW_PASSWORD_EXPIRED;
			break;

		    default:
			code = PW_COMMAND_UNRECOGNIZED;
			logit (LOG_DAEMON, LOG_ERR,
			  "%s: Password expired from unknown request type (%d)",
				func, authreq->code);
			break;
		} /* end of switch */
		break;
#endif	/* ASCEND */

	    default:
		logit (LOG_DAEMON, LOG_ERR, "%s: event %d not supported",
			func, result);
		code = PW_COMMAND_UNRECOGNIZED;
		break;
	} /* end of switch */

	return code;
} /* end of ev2code () */

/*************************************************************************
 *
 *	Function: fail_log_action
 *
 *	Purpose: This AATV function always NAKs and adds a Reply-Message.
 *
 *************************************************************************/

static int
fail_log_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "fail_log_action";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq == (AUTH_REQ *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR, "%s: NULL authreq detected", func);
	}
	else
	{
		log_queues (authreq, func);

		if ((afpar != (char *) NULL) && (strlen (afpar) != 0))
		{
			reply_sprintf (0, authreq,
				"Authentication timed out in %s", afpar);
		}
		else
		{
			reply_sprintf (0, authreq, "Authentication timed out");
		}
	}

	return EV_NAK;
} /* end of fail_log_action () */

/*************************************************************************
 *
 *	Function: fatal_action
 *
 *	Purpose: This AATV function logs fatal error conditions in the FSM.
 *
 *************************************************************************/

int
fatal_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "fatal_action";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq != (AUTH_REQ *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR,
		     "%s: fatal error detected in FSM: AATV '%s' state %s (%d)",
			func, authreq->fsm_aatv->id,
			find_state_name (authreq->state), authreq->state);
		authreq->state = ST_END; /* indicates not to enter the FSM */
	}
	else
	{
		logit (LOG_DAEMON, LOG_ERR, "%s: error detected in FSM", func);
	}
	return EV_FATAL;
} /* end of fatal_action () */

/*************************************************************************
 *
 *	Function: fatal_log_action
 *
 *	Purpose: This AATV function logs fatal error conditions in the FSM.
 *
 *************************************************************************/

static int
fatal_log_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "fatal_log_action";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq != (AUTH_REQ *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR,
		     "%s: fatal error detected in FSM: AATV '%s' state %s (%d)",
			func, authreq->fsm_aatv->id,
			find_state_name (authreq->state), authreq->state);

		log_queues (authreq, func);

		authreq->state = ST_END; /* indicates not to enter the FSM */
	}
	else
	{
		logit (LOG_DAEMON, LOG_ERR, "%s: error detected in FSM", func);
	}
	return EV_NAK;
} /* end of fatal_log_action () */

/*************************************************************************
 *
 *	Function: find_aatv
 *
 *	Purpose: Find the AATV with the given id in the AATV array.
 *
 *	Returns: pointer to the given AATV,
 *		 NULL pointer if no match found.
 *
 *************************************************************************/

AATV *
find_aatv (paction)

char           *paction;		/* the AATV id to search for */

{
	int             i;
	AATV           *aatv;
	AATV           *result;
	static char    *func = "find_aatv";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered, looking for '%s'",
		func, (paction == (char *) NULL) ? "?" : paction));

	result = (AATV *) NULL;

	for (i = 0; i < MAX_AATV; i++)
	{
		if ((aatv = *aatv_ptrs[i]) != NULL)
		{
			if (strcmp (paction, (char *) aatv->id) == 0)
			{
				result = aatv;
				break;
			}
		}
	}

	return result;
} /* end of find_aatv () */

#define	MAX_STATES_BUFFERED	10

/*************************************************************************
 *
 *	Function: find_state_name
 *
 *	Purpose: Find the name of a state when given state number.
 *
 *	Returns: pointer to a character string naming the state.
 *
 *************************************************************************/

static char *
find_state_name (num)

int         num;		/* State number to find. */

{
	FSM_ENT        *pe;
	static int      index = 0;
	static char     buffers[MAX_STATES_BUFFERED][MAXPATHLEN];
	char           *buff = buffers[index];
	static char    *func = "find_state_name";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	switch (num)
	{
	    case ST_END:
		return "END";

	    case ST_HOLD:
		return "HOLD";

	    case ST_SAME:
		return "SAME";

	    case ST_ANY:
		return "ANY";
	}

	/* Loop around the list. */
	index++;
	if (index >= MAX_STATES_BUFFERED)
	{
		index = 0;
	}

	if ((nfsm > num) && (num >= 0))
	{
		pe = fsm[num];
		if (pe != (FSM_ENT *) NULL)
		{
			sprintf (buff, "%s::%s", pe->fsm_name, pe->state_name);
			return buff;
		}
	}

	sprintf (buff, "?%u-No-Such-State?", num);

	return buff;

} /* end of find_state_name () */

/******************************************************************************
 *
 *	Function: fork_reply
 *
 *	Purpose: Send a RADIUS response packet to ourselves using a UDP
 *		 socket.  Treat the RADIUS packet returned from an FREPLY AATV
 *		 the same as the packet radius_send() would send to a remote
 *		 server (i.e., attach the action name "cmd" from the FSM
 *		 table as the first attribute of type Proxy-Action and add a
 *		 Proxy-State attribute at the end).  The state is needed upon
 *		 receipt to help match up incoming requests with existing
 *		 request structures.
 *
 *	Returns: length of packet sent, if successful,
 *		 or -1, if error detected.
 *
 *****************************************************************************/

static int
fork_reply (authreq, result)

AUTH_REQ       *authreq;
int             result;

{
	int             lcl_sin_len;
	int             rc;
	int             total_length;
	u_int           code;
	UINT4           ipaddr;
	AUTH_HDR       *auth;
	CLIENT_ENTRY   *pce;
	struct sockaddr_in lcl_sin;
	char           *func = "fork_reply";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s(..., %d): entered",
		func, result));

	lcl_sin_len = sizeof (lcl_sin);

	if (getsockname (rad_2rad_aatv->sockfd,
			(struct sockaddr *) &lcl_sin, &lcl_sin_len))
	{
		logit (LOG_AUTH, LOG_ERR,
			"%s: FATAL - error (%d) in getsockname(%d...)",
			func, errno, rad_2rad_aatv->sockfd);
		return (-1);
	}

	lcl_sin.sin_addr.s_addr = htonl(get_our_addr ());  /* htonl(LOOPBACK) */

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: lcl_sin = { %d, %d, %s }",
		func, lcl_sin.sin_family, lcl_sin.sin_port,
		inet_ntoa (lcl_sin.sin_addr)));

	auth = (AUTH_HDR *) send_buffer;

	if (find_client_by_name (RADIUS_LOCALSERVER, &ipaddr, &pce) == -1)
	{
		logit (LOG_AUTH, LOG_ERR, "%s: client '%s' not configured",
			func, RADIUS_LOCALSERVER);
		return (-1);
	}

	if ((code = ev2code (authreq, result)) == -1)
	{
		logit (LOG_AUTH, LOG_ERR, "%s: Response dropped", func);
		return (-1);
	}

	build_header (authreq->vers_out, (char *) authreq->fwdvec, code,
			authreq->fwd_id, auth, pce);

	/* Check for disasters... */
	if (build_packet (authreq->cur_request, auth,
			  send_buffer_size, pce) <= 0)
	{
		logit (LOG_AUTH, LOG_ERR, "%s: build_packet() failed", func);
		return (-1);
	}

	total_length = build_reply_mic (auth, pce->secret);

	/* Flush debugging and logfiles here, before calling sendto() */
	if (msgfd != (FILE *) NULL)
	{
		fflush (msgfd);
	}

	if (debug_flag > 0)
	{
	  	/*
		 *	Packet level debugging
		 */
		if ((debug_flag > 2) ||
			((pce != (CLIENT_ENTRY *) NULL) &&
			((pce->client_type & CE_DEBUG) != 0)))
		{
			dumpit (LOG_DAEMON, LOG_DEBUG,
				(u_char *) auth, total_length, 0,
				"%s: sending packet from [%s] type=%s to %s:%d",
				func, ip_hostname (authreq->ipaddr),
				authtype_toa (authreq->code),
				pce ? pce->hostname : "??",
				ntohs(lcl_sin.sin_port));
		}

		if (ddt != (FILE *) NULL)
		{
			fflush (ddt);
		}
	}

	rc = sendto (rad_2rad_aatv->sockfd, (char *) auth, (int) total_length,
		(int) 0, (struct sockaddr *) & lcl_sin, sizeof (lcl_sin));

	dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		"%s: sendto (%d ..., %d ...) returned %d",
		func, rad_2rad_aatv->sockfd, total_length, rc));

	return rc;

} /* end of fork_reply () */

/*************************************************************************
 *
 *	Function: found_waldo
 *
 *	Purpose: Log the found event and save a few walues.
 *
 *************************************************************************/

static void
found_waldo (event, ev)

EVENT_ENT      *event;
EV             *ev;

{
	static char    *func = "found_waldo";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		"%s: event [%d '%s' '%s'  PID = %d  %d '%s']",
		func, event->state,
		(event->fsm_aatv == (AATV *) NULL)
			? (u_char *) "?"
			: event->fsm_aatv->id,
		(event->sub_aatv == (AATV *) NULL)
			? (u_char *) "?"
			: event->sub_aatv->id,
		event->pid, event->evalue,
		(event->estring[0] == '\0') ? "?" : event->estring));

	ev->state = event->state;
	ev->a.aatv = event->fsm_aatv;
	ev->isproxy = 0;
	strcpy (ev->xstring, event->estring);

} /* end of found_waldo () */

/*************************************************************************
 *
 *	Function: free_authreq
 *
 *	Purpose: Free all chains hanging off an authreq structure, set
 *		 authreq structure to all zeroes and free it too.
 *
 *************************************************************************/

#ifdef USR_CCA
void
#else
static void
#endif	/* USR_CCA */

free_authreq (authreq)

AUTH_REQ       *authreq;

{
	char            log_msg[1024];
	char            log_guard[256];
	int             found = 0;
	AUTH_REQ_Q     *aaq;
	AUTH_REQ      **prev;
	AUTH_REQ       *current;
	static char    *func = "free_authreq";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/* If the authreq has already been free'd, complain. */
	if (TAR_FREED(authreq))
	{
		packet_log (log_msg, authreq,
				PL_REP_VECTOR | PL_REP_PORT | PL_FWD_VECTOR);

		logit (LOG_DAEMON, LOG_CRIT,
			"%s: Authreq already freed, %s", func, log_msg);
		return;
	}

	/* Find the correct queue to use */
	aaq = queue_find (authreq->code);

	prev = &(aaq->q);
	for ( ; (current = *prev) != (AUTH_REQ *) NULL ; prev = &current->next)
	{
		if (current == authreq)
		{
			if (authreq->next == (AUTH_REQ *) NULL)
			{
				/*
				 *	If the end element is removed,
				 *	then update the end-list pointer
				 *	in the list.
				 */
				aaq->p_q_end = prev;
			}

			found = 1;
			*prev = authreq->next;
			aaq->cur--;		/* Remove from queue */
			CAR_QUEUED(authreq);	/* No longer queued. */
			break;
		}
	}

	/* Sanity check. */
	if ((found == 0) && (TAR_QUEUED(authreq)))
	{
		packet_log (log_msg, authreq,
				PL_REP_VECTOR | PL_REP_PORT | PL_FWD_VECTOR);

		logit (LOG_DAEMON, LOG_ALERT,
			"%s: Unable to find authreq on %s queue!",
			func, aaq->q_name);
		logit (LOG_DAEMON, LOG_ALERT, "Loose-%s", log_msg);
	}

	aaq->c_free_authreq++;	/* Count calls to free_authreq() */

	/* Mark authreq as being freed */
	SAR_FREED(authreq);

	/* Indicate when to kill this one. */
	if (aaq->hold == 0)
	{
		/* If hold is zero, don't even queue it. */
		free_authreq_final (authreq);
		return;
	}

	/* Put it into hold the state (for now) */
	authreq->free_end = aaq->hold + time (NULL);
	authreq->next = aaq->freed;
	aaq->freed = authreq;
	aaq->q_freed++;		/* Count requests queued. */
	aaq->cur_freed++;	/* Update current queue size */

	return;
} /* end of free_authreq () */

/*************************************************************************
 *
 *	Function: free_authreq_final
 *
 *	Purpose: Really free the authreq from the "freed" queue.
 *		 Remove its other structures too.
 *
 *************************************************************************/

static void
free_authreq_final (authreq)

AUTH_REQ       *authreq;

{
	char            log_msg[1024];
	char            log_guard[256];
	AUTH_REQ      **prev;
	AUTH_REQ       *current;
	AUTH_REQ_Q     *aaq;		/* Which queue? */
	static char    *func = "free_authreq_final";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/* If the authreq hasn't been free'd, complain. */
	if (! TAR_FREED(authreq))
	{
		packet_log (log_msg, authreq,
				PL_REP_VECTOR | PL_REP_PORT | PL_FWD_VECTOR);

		logit (LOG_DAEMON, LOG_CRIT,
			"%s: Authreq not freed, %s", func, log_msg);
		return;
	}

	/* Find the correct queue. */
	aaq = queue_find (authreq->code);
	aaq->c_free_authreq_final++;	/* Count number of times called. */

	/* Scan the freed queue. */
	for (prev = &(aaq->freed) ;
		(current = *prev) != (AUTH_REQ *) NULL ;
		prev = &(current->next))
	{
		if (current == authreq)
		{
			*prev = authreq->next;  /* Remove from linked list */
			aaq->dq_freed++;	/* Count the number de-queued */
			aaq->cur_freed--;	/* Update the current state */
			break;
		}
	}

	free_event_list_final (authreq);
	list_free (authreq->request);
	list_free (authreq->cur_request);
	list_free (authreq->user_check);
	list_free (authreq->user_deny);
	memset ((char *) authreq, '\0', sizeof (AUTH_REQ));
	free (authreq);
	authreq_mf.f++;
	return;
} /* end of free_authreq_final () */

/*************************************************************************
 *
 *	Function: free_event
 *
 *	Purpose: Free an EVENT_ENT node and (perhaps) kill a child process.
 *
 *************************************************************************/

static void
free_event (event)

EVENT_ENT      *event;

{
	EVENT_ENT     **events;
	static char    *func = "free_event";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (event != (EVENT_ENT *) NULL)
	{
		if (event->pid > 0)
		{
			aatv_process_end (event->sub_aatv);
			kill (event->pid, SIGQUIT);
		}

		if (event->packet != (u_char *) NULL)
		{
			if (event->freed_packet != (u_char *) NULL)
			{
				free (event->freed_packet);
				redo_mf.f++;
			}
			event->freed_packet = event->packet;
			event->freed_len = event->len;
			event->packet = (u_char *) NULL;
		}

		/* Was this event queued on the client? */
		if (event->client)
		{
			/* Update the forward list of whoever points to this. */
			*event->client_prev = event->client_next;

			/* Update the reverse list of whoever we point to. */
			if (event->client_next != (EVENT_ENT *) NULL)
			{
				event->client_next->client_prev =
							event->client_prev;
			}
			event->client = (CLIENT_ENTRY *) NULL;
		}

		/* If we're not holding onto things, free now really. */
		if (! TAR_HOLD(event->auth_head))
		{
			free_event_final (event);
			return;
		}

		/*
		 * If this event is still queued on the authreq,
		 * move it to the free list and remove from queue.
		 */

		for (events = &(event->auth_head->event_q);
			*events != (EVENT_ENT *) NULL;
			events = &(*events)->next)
		{
			if (event == *events)	/* Found it! */
			{
				*events = event->next;

				/* Find end of list. */
				for (events = &(event->auth_head->freed_events);
					*events != (EVENT_ENT *) NULL;
					events = &((*events)->next))
				{
					; /* continue */
				}

				/* Put on end of free list */
				*events = event;
				break;
			}
		}
	} /* end of outermost if */

	return;
} /* end of free_event () */

/*************************************************************************
 *
 *	Function: free_event_final
 *
 *	Purpose: Free an EVENT_ENT node
 *
 *************************************************************************/

static void
free_event_final (event)

EVENT_ENT      *event;

{
	static char    *func = "free_event_final";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (event != (EVENT_ENT *) NULL)
	{
		if (event->packet != (u_char *) NULL)
		{
			free (event->packet);
			redo_mf.f++;
		}

		if (event->freed_packet != (u_char *) NULL)
		{
			free (event->freed_packet);
			redo_mf.f++;
		}

		/* Was this event queued on the client? */
		if (event->client)
		{
			/* Update the forward list of whoever points to this. */
			*event->client_prev = event->client_next;

			/* Update the reverse list of whoever we point to. */
			if (event->client_next != (EVENT_ENT *) NULL)
			{
				event->client_next->client_prev =
							event->client_prev;
			}
		}

		memset ((char *) event, '\0', sizeof (EVENT_ENT));
		free (event);
		waldo_mf.f++;
	}
	return;
} /* end of free_event_final () */

/*************************************************************************
 *
 *	Function: free_event_list
 *
 *	Purpose: Free all EVENT_ENT nodes on event_q.
 *
 *************************************************************************/

#ifdef USR_CCA
void
#else
static void
#endif	/* USR_CCA */

free_event_list (authreq)

AUTH_REQ       *authreq;

{
	PROC_ENT       *pe;
	EVENT_ENT     **free_end;
	static char    *func = "free_event_list";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/* Unlink possible process entries for forking type AATVs */
	while ((pe = authreq->proc_q) != (PROC_ENT *) NULL)
	{
		authreq->proc_q = pe->next;
		free_proc_ent (pe);
	}

	if (TAR_HOLD(authreq))
	{
		/* Find end of list. */
		for (free_end = (&authreq->freed_events);
			*free_end != (EVENT_ENT *) NULL;
			free_end = &((*free_end)->next))
		{
			; /* continue */
		}

		*free_end = authreq->event_q;
		authreq->event_q = (EVENT_ENT *) NULL;
	}
	else
	{
		free_event_list_final (authreq);
	}
	return;
} /* end of free_event_list () */

/*************************************************************************
 *
 *	Function: free_event_list_final
 *
 *	Purpose: Free all EVENT_ENT nodes on event_q.
 *
 *************************************************************************/

#ifdef USR_CCA
void
#else
static void
#endif	/* USR_CCA */

free_event_list_final (authreq)

AUTH_REQ       *authreq;

{
	PROC_ENT       *pe;
	EVENT_ENT      *event;
	static char    *func = "free_event_list_final";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	while ((event = authreq->event_q) != (EVENT_ENT *) NULL)
	{
		authreq->event_q = event->next;
		free_event_final (event);
	}

	while ((event = authreq->freed_events) != (EVENT_ENT *) NULL)
	{
		authreq->freed_events = event->next;
		free_event_final (event);
	}


	/* Unlink possible process entries for forking type AATVs */
	while ((pe = authreq->proc_q) != (PROC_ENT *) NULL)
	{
		authreq->proc_q = pe->next;
		free_proc_ent (pe);
	}

	return;
} /* end of free_event_list_final () */

/*************************************************************************
 *
 *	Function: free_proc_ent
 *
 *	Purpose: Free a PROC_ENT node
 *
 *************************************************************************/

static void
free_proc_ent (pe)

PROC_ENT       *pe;

{
	static char    *func = "free_proc_ent";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (pe != (PROC_ENT *) NULL)
	{
		/* Was this event queued on an AATV? */
		if (pe->sub_aatv)
		{
			pe->sub_aatv->proc_q_cur--;	/* Count this down */
			/* Update the forward list of whoever points to this. */
			*pe->aatv_prev = pe->aatv_next;

			/* Update the reverse list of whoever we point to. */
			if (pe->aatv_next != (PROC_ENT *) NULL)
			{
				pe->aatv_next->aatv_prev = pe->aatv_prev;
			}
		}

		memset ((char *) pe, '\0', sizeof (PROC_ENT));
		free (pe);
/*		waldo_mf.f++;  */   /* XXX: why is this commented out? */
	}
	return;
} /* end of free_proc_ent () */

/*************************************************************************
 *
 *	Function: get_radrequest
 *
 *	Purpose: Receive UDP client requests, build an auth-request
 *		 structure, and attach attribute-value pairs contained in
 *		 the request to the new structure.
 *
 *	Returns: -1 if errors found,
 *		  0 if normal return.
 *
 *************************************************************************/

static int
get_radrequest (sockfd, arptr, sin, host, length, ce)

int             sockfd;
AUTH_REQ      **arptr;
struct sockaddr_in *sin;
UINT4           host;
u_int           length;
CLIENT_ENTRY   *ce;

{
	int             error = 0;
	int             rc;
	u_int           totallen;
	u_short         code;
	u_short         id;
	u_char          version;
	u_char          flags;
	u_short         udp_port;
	time_t          now = time (0);
	u_char         *buffer;
	u_char         *vector_ptr;
	AUTH_HDR       *auth;
	AUTH_HDR1      *ah1;
	AUTH_REQ       *authreq;
	VALUE_PAIR     *request;
	CLIENT_ENTRY   *virtual_ce = ce;
	char            save_digest[AUTH_VECTOR_LEN];
	char            log_msg[1024];	/* For reporting incoming packets. */
	char            log_guard[256];	/* Room for overflow, if needed. */
	static char    *func = "get_radrequest";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	buffer = (u_char *) recv_buffer;
	udp_port = ntohs(sin->sin_port);
	auth = (AUTH_HDR *) buffer;

	code = auth->code;

	/*
	 *	Packet level debugging
	 */
	if ((debug_flag > 2) ||
		((debug_flag > 0) &&
		 (ce != (CLIENT_ENTRY *) NULL) &&
		 ((ce->client_type & CE_DEBUG) != 0)))
	{
		dumpit (LOG_DAEMON, LOG_DEBUG, buffer, length, 0,
		 "%s: packet received from %s [%s]:%u, %d bytes, type=%s (%d)",
			func, ce ? ce->hostname : "??",
			inet_ntoa (sin->sin_addr),
			udp_port, length, authtype_toa (code), code);
	}

	/*
	 *	Check for status requests.
	 */
	if ((code == PW_STATUS_SERVER) || (ce == (CLIENT_ENTRY *) NULL))
	{
		virtual_ce = &dummy_status_server_client;
		if (ce == (CLIENT_ENTRY *) NULL)
		{
			ce = virtual_ce;
		}
	}

	/* Check for receipt of new format */
	if (code == PW_EXTENDED_FORMAT)
	{
		totallen = ntohs(auth->length);
		code = ntohs(auth->command);
		id = ntohs(auth->id);
		vector_ptr = auth->vector;
		version = flags = auth->flag_ver;
		version &= AUTH_HDR_VERSION_BITS;
		flags &= ~AUTH_HDR_VERSION_BITS;

		if (length < AUTH_HDR_LEN || version != 2)
		{
			error++;
		}

		if ((rc = check_mic (auth, length, virtual_ce->secret, ce))
		    						!= 0)
		{
			logit (LOG_DAEMON, LOG_INFO,
				"%s: Received invalid %s from %s[%u]",
				func, rc < 0 ? "MIC" : "TIMESTAMP",
				ip_hostname (ntohl(sin->sin_addr.s_addr)),
				ntohs(sin->sin_port));
			return (-1);
		}
	}
	else /* Good ole V1. */
	{
		ah1 = (AUTH_HDR1 *) auth;
		if (length < AUTH_HDR1_LEN)
		{
			return (-1);
		}
		totallen = ntohs(ah1->length);
		id = ah1->id;
		vector_ptr = ah1->vector;
		version = 1;
		flags = 0;

		if ((code == PW_ACCOUNTING_REQUEST) &&
			((ce->client_type & CE_ACCT_RFC) == CE_ACCT_RFC))
		{
			/* Save rcvd. digest and recompute it.  Then compare */
			memcpy (save_digest, (char *) vector_ptr,
							AUTH_VECTOR_LEN);
			/* function expects length in host order */
			ah1->length = ntohs(ah1->length);
			build_request_mic (auth, virtual_ce->secret);

			if (memcmp (save_digest, (char *) vector_ptr,
							AUTH_VECTOR_LEN) != 0)
			{
				logit (LOG_DAEMON, LOG_INFO,
			"%s: Rcvd invalid acctg-req. digest from %s[%u]", func,
				    ip_hostname (ntohl(sin->sin_addr.s_addr)),
				    ntohs(sin->sin_port));
				return (-1);
			}
		}
	}

	if (error || length < totallen)
	{
		dumpit (LOG_DAEMON, LOG_INFO, auth, length, 0,
	   "%s: ill formed packet from %s[%u] - code = %u, vers = %u, len = %u",
			func, ip_hostname (host), udp_port, code,
			version, totallen);
		return (-1);
	}

	switch (code)
	{
	    case PW_FORWARDING:
		*arptr = (AUTH_REQ *) NULL;
		return 0;

	    case PW_COMMAND_UNRECOGNIZED:
		logit (LOG_DAEMON, LOG_INFO,
			"%s: Received CMD_UNREC from %s[%u] - id = %u",
			func, ip_hostname (host), udp_port, id);
		return (-1);

#ifdef USR_CCA
	    case PW_RESOURCE_FREE_REQ:
	    case PW_RESOURCE_FREE_RESP:
	    case PW_RESOURCE_QUERY_REQ:
	    case PW_RESOURCE_QUERY_RESP:
	    case PW_NAS_REB_REQ:
	    case PW_NAS_REB_RESP:
#endif	/* USR_CCA */

#ifdef ASCEND
	    case PW_ASCEND_RADIPA_ALLOCATE:
	    case PW_ASCEND_RADIPA_RELEASE:
#endif	/* ASCEND */

	    case PW_ACCOUNTING_REQUEST:
	    case PW_ACCESS_REQUEST:
	    case PW_PASSWORD_REQUEST:
	    case PW_STATUS_SERVER:
		break;

	    default:
		dumpit (LOG_DAEMON, LOG_INFO, auth, length, 0,
	  "%s: invalid request from %s[%u] - %s (type %u), vers = %u, len = %u",
			func, ip_hostname (host), udp_port,
			authtype_toa (auth->code), auth->code,
			version, totallen);
		send_cmd_unrec (sockfd, version, sin, id, code, ce);
		return (-1);
	}

	/*
	 *	Grab attributes from packet (doing mapping if specified),
	 *	then hang the attributes on a local variable.
	 */
	request = gen_valpairs (auth, length, ce->veps, GVP_ENCAP);

	if (request == NULL_VP)
	{
		dumpit (LOG_DAEMON, LOG_INFO, auth, length, 0,
		       "%s: NO a/v pairs from %s [%u] - %s (type %u), len = %u",
			func, ip_hostname (host), udp_port,
			authtype_toa (auth->code), auth->code, totallen);
		return (-1);
	}

	/*
	 *	Pre-allocate the new request data structure
	 */

	if ((authreq = (AUTH_REQ *) calloc (1, sizeof (AUTH_REQ)))
							== (AUTH_REQ *) NULL)
	{
		logit (LOG_DAEMON, LOG_ALERT, "%s: FATAL out of memory", func);
		abort ();
	}
	authreq_mf.m++;

	dprintf(1, (LOG_DAEMON, LOG_DEBUG,
		"%s: Request from %lx (%s[%u]) %s, id = %d, len = %d",
		func, host, ip_hostname (host), udp_port,
		authtype_toa (code), id, totallen));

	/*
	 *	Fill header fields
	 */
	authreq->ipaddr = host;
	authreq->udp_port = udp_port;
	authreq->rcv_len = length;	/* Save length for is_dup_request() */
	authreq->rep_id = id;
	authreq->fwd_id = 0;
	authreq->code = code;
	authreq->vers_in = version;
	authreq->vers_out = 0;
	authreq->flags = flags;
	/* Initialize reply vector (for responding to whomever sent request.) */
	memcpy ((char *) authreq->repvec, (char *) vector_ptr, AUTH_VECTOR_LEN);
	/* Initialize forward vector (for forwarding requests) */
	memset ((char *) authreq->fwdvec, 0, AUTH_VECTOR_LEN);

#ifdef USR_CCA
	if (authreq->code == PW_RESOURCE_QUERY_REQ)
	{
		authreq->ttlslice = 0;
		authreq->ttl = 0;
		authreq->timer = 0;
	}
/***	else if (authreq->code == PW_NAS_REB_REQ)
	{
		authreq->ttlslice = NAS_REB_TIMER;
		authreq->ttl = NAS_REB_TIMER;
		authreq->timer = 0;
	} ***/
	else
	{
		authreq->ttlslice = MAX_REQUEST_TIME;
		authreq->ttl = MAX_REQUEST_TIME;
		authreq->timer = 0;
	}
	authreq->type = USR_CHILD;
	authreq->qry_count = 0;
#else	/* USR_CCA */
	authreq->ttlslice = MAX_REQUEST_TIME;
	authreq->ttl = MAX_REQUEST_TIME;
	authreq->timer = 0;
#endif	/* USR_CCA */

	authreq->retry_cnt = 0;
	authreq->seqch_cnt = 0;
	authreq->retry_limit = default_retry_limit;
	authreq->seqch_limit = default_seqch_limit;
	authreq->realm_filter = (char *) NULL;
	authreq->state = ST_END;
	authreq->sws = 0;
	authreq->debug_flag = 0;	/* No special debugging */
	authreq->repstatus = -2;	/* invalid value */
	authreq->fsmstatus = EV_NAK;	/* initial value */
	authreq->cur_count = 0;
	authreq->onqueue = now;
	authreq->starthg = now;
	authreq->startlas = now;
	authreq->fsm_aatv = (AATV *) NULL;
	authreq->direct_aatv = (AATV *) NULL;
	authreq->event_q = (EVENT_ENT *) NULL;
	authreq->proc_q = (PROC_ENT *) NULL;
	authreq->client = ce;
	authreq->next = (AUTH_REQ *) NULL;
	authreq->request = request;
	authreq->cur_request = NULL_VP;
	authreq->user_check = NULL_VP;
	authreq->user_deny = NULL_VP;
	*arptr = authreq;

	/*
	 *	Verify that Access-Requests have:
	 *		either a User-Password, a CHAP-Password,
	 *		or an Ascend ARADES password
	 *	**AND**
	 *		either a NAS-IP-Address or a NAS-Identifier
	 *	**AND**
	 *		a User-Name
	 *	**AND**
	 *		either a NAS-Port or a NAS-Port-Type.
	 *
	 *	and verify that Accounting-Requests have:
	 *		either a NAS-IP-Address or a NAS-Identifier
	 *	**AND**
	 *		an Acct-Status-Type
	 *	**AND**
	 *		an Acct-Session-Id
	 */

	/* Conform with RADIUS RFC */
	if ((authreq->request != NULL_VP) &&
		((authreq->client->client_type & CE_NAS) == CE_NAS))
	{
		switch (authreq->code)
		{
		    case PW_ACCESS_REQUEST:
			if (

#ifdef ASCEND
			    (get_vp (authreq->request,
						PW_USER_PASSWORD) == NULL_VP &&
				get_vp (authreq->request,
						PW_CHAP_PASSWORD) == NULL_VP &&
				get_vp_vend (authreq->request, PW_ASCEND_ARADES,
						VC_ASCEND) == NULL_VP) ||
#else	/* ASCEND */
			    (get_vp (authreq->request,
						PW_USER_PASSWORD) == NULL_VP &&
				get_vp (authreq->request,
						PW_CHAP_PASSWORD) == NULL_VP) ||
#endif	/* ASCEND */

				(get_vp (authreq->request,
						PW_NAS_IP_ADDRESS) == NULL_VP &&
				get_vp (authreq->request,
					       PW_NAS_IDENTIFIER) == NULL_VP) ||
				get_vp (authreq->request,
						PW_USER_NAME) == NULL_VP)
			{
				dumpit (LOG_DAEMON, LOG_ERR, auth, length, 0,
		      "%s: non-RFC packet from %s[%u] - %s (type %u), len = %u",
					func, ip_hostname (host), udp_port,
					authtype_toa (auth->code), auth->code,
					totallen);
				free_authreq (authreq);
				return (-1);
			}
			break;

		    case PW_ACCOUNTING_REQUEST:
			if ((get_vp (authreq->request,
						PW_NAS_IP_ADDRESS) == NULL_VP &&
				get_vp (authreq->request,
					       PW_NAS_IDENTIFIER) == NULL_VP) ||
				get_vp (authreq->request,
					      PW_ACCT_STATUS_TYPE) == NULL_VP ||
				get_vp (authreq->request,
						PW_ACCT_SESSION_ID) == NULL_VP)
			{
				dumpit (LOG_DAEMON, LOG_ERR, auth, length, 0,
		      "%s: non-RFC packet from %s[%u] - %s (type %u), len = %u",
					func, ip_hostname (host), udp_port,
					authtype_toa (auth->code), auth->code,
					totallen);
				free_authreq (authreq);
				return (-1);
			}
			break;
		} /* end of switch */
	}

	/* In debug mode, log the incoming request we have just processed. */
	if (debug_flag > 0)
	{
		packet_log (log_msg, authreq, 0);
		logit (LOG_AUTH, LOG_INFO, "Original-%s", log_msg);
	}

	return (0);
} /* end of get_radrequest () */

/*************************************************************************
 *
 *	Function: get_state   XXX: Only obsolete this routine with care!
 *
 *	Purpose: Finds the last (nearest the end) PW_PROXY_STATE attribute
 *		 in the list of attributes passed to it and if one is found,
 *		 removes it and returns the numeric value of that state.
 *
 *************************************************************************/

static u_char
get_state (vpq)

VALUE_PAIR    **vpq;

{
	long            num;
	u_char          result;
	VALUE_PAIR    **prev_ptr;
	VALUE_PAIR     *vp;
	VALUE_PAIR     *this_vp;
	static char    *func = "get_state";

	dprintf(2, (LOG_AUTH, LOG_DEBUG, "%s: entered", func));

	result = ST_END;

	/* Get last PW_PROXY_STATE */
	this_vp = get_last_vp (*vpq, PW_PROXY_STATE);

	if (this_vp != NULL_VP) /* found at least one Proxy-State */
	{
		for (prev_ptr = vpq;
			(vp = *prev_ptr) != NULL_VP;
			prev_ptr = &vp->next)
		{
			if (vp == this_vp) /* this is last Proxy-State */
			{
				num = atol (this_vp->strvalue);
				if (num >= 0 && num <= 255)  /* valid state */
				{
					result = (u_char) num;
				}
				*prev_ptr = this_vp->next; /* take off list */
				avpair_free (this_vp);
				break;
			}
		}
	}

	return result;
} /* end of get_state () */

/*************************************************************************
 *
 *	Function: handle_sysconf
 *
 *	Purpose: Handle:  Special :: aatv-name <space> <value>
 *
 *************************************************************************/

static int
handle_sysconf (lnum, valcount, confpath, value)

int             lnum;
int             valcount;
char           *confpath;
char           *value;

{
	int             num;
	AATV           *cfg_aatv;
	char           *verb;
	static char    *func = "handle_sysconf";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered"));

	if (!*value)
	{
		logit (LOG_DAEMON, LOG_ERR,
		    "%s: No AATV or value specified at '%s' line %d (ignored)",
			func, confpath, lnum);
	}
	else
	{
		verb = strtok (value, "\t ");

		if (!verb)
		{
			logit (LOG_DAEMON, LOG_ERR,
		    "%s: No value for aatv.proc_max at '%s' line %d (ignored)",
				func, confpath, lnum);
		}
		else
		{
			value = strtok (NULL, "\xff");

			num = atoi (value);
			num = num < 0 ? 0 : num;

			if ((cfg_aatv = find_aatv (verb)) == (AATV *) NULL)
			{
				logit (LOG_DAEMON, LOG_ERR,
			     "%s: No such AATV '%s' at '%s' line %d (ignored)",
					func, verb, confpath, lnum);
			}
			else if (num != cfg_aatv->proc_max)
			{
				logit (LOG_DAEMON, LOG_INFO,
					"%s: AATV %s->proc_max was %d now %d",
					func, verb, cfg_aatv->proc_max, num);

				if (cfg_aatv->proc_cnt_hi != 0)
				{
				    logit (LOG_DAEMON, LOG_INFO,
					"%s: %s: %d, %d, %d-%s, %d-%s, %d-%s",
					func, cfg_aatv->id,
					cfg_aatv->proc_max,
					cfg_aatv->proc_cnt,
					cfg_aatv->proc_cnt_hi,
					rad_time (cfg_aatv->proc_cnt_hi_t, 0),
					cfg_aatv->proc_q_hi,
					rad_time (cfg_aatv->proc_q_hi_t, 0),
					cfg_aatv->proc_q_cur,
					rad_time (cfg_aatv->proc_q_last, 0));
				}

				cfg_aatv->proc_cnt_hi = 0;
				cfg_aatv->proc_q_hi = 0;
				cfg_aatv->proc_cnt_hi_t = 0;
				cfg_aatv->proc_q_hi_t = 0;
				cfg_aatv->proc_q_last = 0;
				cfg_aatv->proc_max = num;
				valcount++;
			}
		}
	}

	return valcount;

} /* end of handle_sysconf () */

/*************************************************************************
 *
 *	Function: init_aatvs
 *
 *	Purpose: Does the initialization of all AATVs which have
 *		 initialization functions.
 *
 *	Returns: Highest file descriptor number set by FD_SET().
 *
 *************************************************************************/

static int
init_aatvs ()

{
	int             i;
	int             j;
	int             maxfd = 0;
	int             n;
	int             save_init;
	AATV           *this_aatv;
	AATV           *seen_aatv;
	void          (*init_func) ();
	static char    *func = "init_aatvs";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	save_init = doing_init;
	doing_init = TRUE;	/* We're definitely initializing now */

	FD_ZERO(&select_mask);		/* clear the bits */
	j = 0;
	for (i = 0; i < MAX_AATV; i++)
	{
		if ((this_aatv = *aatv_ptrs[i]) == (AATV *) NULL)
		{
			continue;
		}
		for (n = 0; n < i; n++) /* AATV names must be unique. */
		{
			if ((seen_aatv = *aatv_ptrs[n]) == (AATV *) NULL)
			{
				continue;
			}

			if (strcasecmp ((char *) this_aatv->id,
					(char *) seen_aatv->id) == 0)
			{
				logit (LOG_DAEMON, LOG_ALERT,
			 "%s: FATAL configuration error: AATV names match: %s",
					func, this_aatv->id);
				abort ();
			}
		}

		init_func = this_aatv->init;
		if (init_func != (void (*) () ) NULL)
		{
			init_func (this_aatv);	/* initialize each AATV */

			if (msgfd != (FILE *) NULL)
			{
				fflush (msgfd);
			}

			if (this_aatv->sockfd != -1 &&	/* AATV has socket */
				! FD_ISSET(this_aatv->sockfd, &select_mask))
			{
				FD_SET(this_aatv->sockfd, &select_mask);
				maxfd = MAX(maxfd, this_aatv->sockfd);
				sockfd_tv[j++] = this_aatv; /* save for later */
			}
		}
	}

	sockfd_tv[j] = (AATV *) NULL;	/* terminate the sockfd_tv[] array */

	doing_init = save_init;
	return maxfd;
} /* end of init_aatvs () */

/*************************************************************************
 *
 *	Function: is_dup_request
 *
 *	Purpose: Looks for duplicate client requests on global queues.
 *
 *	Returns: EV_DUP_REQ and found authreq, if request is a duplicate.
 *		 EV_NEW_A*** and NULL authreq, if request is not a duplicate.
 *		 EV_NAK and NULL authreq, if queue is full.
 *
 *************************************************************************/

static AUTH_REQ *
is_dup_request (authreq, event)

AUTH_REQ       *authreq;
int            *event;

{
	int             qcount = 0;
	char           *tmp;
	AUTH_REQ       *q;
	AUTH_REQ_Q     *aaq;
	VALUE_PAIR     *pw_vp = NULL_VP;
	VALUE_PAIR     *vp;
	VALUE_PAIR     *vp2;
	char           *pw = (char *) NULL;
	char           *why_dup = "not a duplicate";
	char            changetxt[256];
	static char    *func = "is_dup_request";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/* Look for duplicate request. */

	aaq = queue_find (authreq->code);

	for (q = aaq->q; q != (AUTH_REQ *) NULL ; q = q->next)
	{
		qcount++;

		dprintf(2, (LOG_DAEMON, LOG_DEBUG, "Check against %s id %d",
			aaq->q_name, q->fwd_id));

		if (authreq_dup_check (authreq, q, &pw_vp, &pw, &why_dup) != 0)
		{
			break; /* Found a duplicate. */
		}
	}

	/*
	 * Clear temporary memory used to compare User-Password attributes
	 */
	if (pw != (char *) NULL)
	{
		memset (pw, '\0', AUTH_VECTOR_LEN);
	}

	if (q != (AUTH_REQ *) NULL) /* Found a duplicate before reaching end. */
	{
		dprintf(1, (LOG_DAEMON, LOG_DEBUG,
			"RADIUS request %s id %u is a duplicate (%s)",
			authtype_toa (authreq->code),
			authreq->rep_id, why_dup));

		if (debug_flag >= 4)
		{
			FILE *debug_out = stderr;

			if (ddt)
			{
				debug_out = ddt;
			}

			/* Show given authreq... */
			if ((vp = get_vp (authreq->request,
						PW_NAS_IDENTIFIER)) == NULL_VP)
			{
				vp = get_vp (authreq->request,
						PW_NAS_IP_ADDRESS);
			}

			dprintf(4, (LOG_DAEMON, LOG_DEBUG,
				"%s: Incoming %s id %u from %s via. %s[%d]",
				func, authtype_toa (authreq->code),
				authreq->rep_id,
				(vp == NULL_VP) ? "?" : avpair_vtoa (vp, 0),
				ip_hostname (authreq->ipaddr),
				authreq->udp_port));
			debug_list (debug_out, authreq->request);

			/* Show matching authreq... */
			if ((vp = get_vp (q->request,
						PW_NAS_IDENTIFIER)) == NULL_VP)
			{
				vp = get_vp (q->request, PW_NAS_IP_ADDRESS);
			}

			dprintf(4, (LOG_DAEMON, LOG_DEBUG,
				"%s: Matching %s id %u from %s via. %s[%d]",
				func, authtype_toa (q->code), q->rep_id,
				(vp == NULL_VP) ? "?" : avpair_vtoa (vp, 0),
				ip_hostname (q->ipaddr), q->udp_port));
			debug_list (debug_out, q->request);
		}

		changetxt[0] = '\0';	/* Indicate no change at first. */

		/* Check to see if the reply id changed. */
		if (q->rep_id != authreq->rep_id) /* Save new sequence number */
		{
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		    "%s: New ID for %s old id %u, new id %u from %s via %s[%d]",
				func, authtype_toa (q->code),
				q->rep_id, authreq->rep_id,
				(vp == NULL_VP) ? "?" : avpair_vtoa (vp, 0),
				ip_hostname (q->ipaddr), q->udp_port));

			sprintf (changetxt, "rep_id %u -> %u",
				q->rep_id, authreq->rep_id);
			q->rep_id = authreq->rep_id;
		}

		/* Check to see if the authenticating vector changed. */
		if (memcmp ((char *) q->repvec, (char *) authreq->repvec,
							AUTH_VECTOR_LEN) != 0)
		{
			tmp = changetxt;

			if (changetxt[0] != '\0')
			{
				strcat (changetxt, ", ");
				tmp += strlen (changetxt);
			}

			sprintf (tmp, "vector %s -> %s",
				auth_vectortoa (q->repvec, 0x01),
				auth_vectortoa (authreq->repvec, 0x01));

			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
"%s: New vector for %s id %u [%s] from %s via %s[%d]",
				func, authtype_toa (q->code),
				q->rep_id,
				auth_vectortoa (authreq->repvec, 0x01),
				(vp == NULL_VP) ? "?" : avpair_vtoa (vp, 0),
				ip_hostname (q->ipaddr), q->udp_port));

			/* Save new random number/authenticator vector, too. */
			memcpy ((char *) q->repvec, (char *) authreq->repvec,
				AUTH_VECTOR_LEN);
		}

		/* Grab pointers to passwords both in packet and on queue. */
		vp = get_vp (authreq->request, PW_USER_PASSWORD); /* packet */
		vp2 = get_vp (q->request, PW_USER_PASSWORD); /* from queue */

		/* Swap the queue password for the in-packet password. */
		if ((vp != NULL_VP) && (vp2 != NULL_VP))
		{
			tmp = vp2->strvalue;
			vp2->strvalue = vp->strvalue;
			vp->strvalue = tmp;
		}
		else /* both were NULL (okay) or have one of each (error!) */
		{
			if ((vp != NULL_VP) || (vp2 != NULL_VP))
			{
				logit (LOG_DAEMON, LOG_ALERT,
					"%s: FATAL duplicate password mismatch",
					func);
				dumpcore = 1;
				abort ();
			}
		}

		/*
		 *	Special logging if the duplicate has changed.
		 *
		 *	If we produce a message here, record the
		 *	sequence number and digest changes.
		 */
		if (changetxt[0])
		{
			q->seqch_cnt++; /* Count sequence number changes */
			logit (LOG_DAEMON, LOG_INFO,
	"%s: Special duplicate for %s %u/%u received, %s, ttl=%u, ttlslice=%u",
				func, aaq->q_name, q->rep_id, q->fwd_id,
				changetxt, q->ttl, q->ttlslice);
		}

		SAR_FREED(authreq);

		/* Free the in-packet and the old password */
		free_authreq_final (authreq);

#if !defined(USR_CCA)
		if (q->ttlslice > 0) /* Only reset time-to-live if non-zero. */
		{
			q->ttl = q->ttlslice;	/* Reset time-to-live count. */
		}
#endif	 /* USR_CCA */

		q->retry_cnt++;		/* Record the duplicate request. */

		/*
		 *	If we've exceeded our (optional) retry limit,
		 *	return a retry_limit event.
		 */
		if ((q->seqch_limit != 0) && (q->seqch_cnt >= q->retry_limit))
		{
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: Sequence# change limit (%u) exceeded, %u",
				func, q->seqch_limit, q->seqch_cnt));
			*event = EV_RETRY_LIMIT;
		}
		else
		{
			if ((q->retry_limit != 0) &&
				(q->retry_cnt >= q->retry_limit))
			{
				dprintf(2, (LOG_DAEMON, LOG_DEBUG,
					"%s: Retry limit (%u) exceeded, %u",
					func, q->retry_limit, q->retry_cnt));
				*event = EV_RETRY_LIMIT;
			}
			else
			{
				*event = EV_DUP_REQ;
			}
		}

		/* Set (or clear) the hold bit in the authreq */
		if (aaq->hold > 0)
		{
			SAR_HOLD(q);
		}
		else
		{
			CAR_HOLD(q);
		}

		aaq->q_dup++;
		return q;
	}

	if (enqueue_authreq (aaq, authreq) == (AUTH_REQ *) NULL)
	{
		*event = EV_NAK; /* Too many on queue. Rejected. */
	}
	else
	{
		/*XXX This code should be table driven. XXX*/
		if (authreq->code == PW_ACCOUNTING_REQUEST)
		{
			*event = EV_NEW_ACCT;
		}
		else /* all other requests look like authentication requests */
		{
			*event = EV_NEW_AUTHEN;
		}
	}

	return (AUTH_REQ *) NULL;	/* New authreq, or failed to queue. */
} /* end of is_dup_request () */

/*************************************************************************
 *
 *	Function: kill_action
 *
 *	Purpose: This AATV function unconditionally removes pending events
 *		 (the EVENT_ENT structures attached to the authreq).
 *
 *************************************************************************/

static int
kill_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "kill_action";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq != (AUTH_REQ *) NULL)
	{
		free_event_list (authreq);
	}
	return EV_WAIT;
} /* end of kill_action () */

/*************************************************************************
 *
 *	Function: log_queues
 *
 *	Purpose: Log waldoes, and like structures waiting on an authreq.
 *		 (the EVENT_ENT structures attached to the authreq).
 *
 *************************************************************************/

static void
log_queues (authreq, where)

AUTH_REQ       *authreq;
char           *where;

{
	EVENT_ENT      *wait;		/* Events waiting for... */
	PROC_ENT       *pe;		/* Processes waiting for... */
	char           *log;		/* For appending to log_msg[] */
	char            log_msg[1024];	/* For logging message. */
	char            log_guard[256];	/* For overflows, if any. */
	static char    *func = "log_queues";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq == (AUTH_REQ *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s: NULL authreq detected from %s()",
			func, where);
		return;
	}

	/* No logging this one? */
	if (TAR_NO_LOG (authreq))
	{
		return;
	}

	if (authreq->cur_request == NULL_VP)
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s:*** Missing ALL attributes!", where);
	}

	/* LOG and DEBUG this session. */
	packet_log (log_msg, authreq, 0);

	/* Now, LOG and DEBUG the information. */
	logit (LOG_DAEMON, LOG_INFO, "%s: %s - state %s",
		where, log_msg, find_state_name (authreq->state));

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "timeout-%s - state %s",
		log_msg, find_state_name (authreq->state)));

	/* Log just who we're waiting for... */
	for (wait = authreq->event_q;
		wait != (EVENT_ENT *) NULL;
		wait = wait->next)
	{
		if (wait->sub_aatv->aatvfunc_type == AA_SOCKET)
		{
			/*
			 *	The REPLY AATV is a socket type AATV,
			 *	but it doesn't forward anything anywhere.
			 */
			if (wait->sin.sin_addr.s_addr == 0)
			{
				sprintf (log_msg,
					"%s+: Already replied to in state %s",
					where,
					find_state_name (wait->state));
			}
			else
			{
			    sprintf (log_msg,
				"%s+: waiting for host %s from state %s, q=%d",
				where,
				ip_hostname (ntohl(wait->sin.sin_addr.s_addr)),
				find_state_name (wait->state),
				client_queue_size (wait->client));
			}

		}
		else	/* was not AA_SOCKET type AATV */
		{
			sprintf (log_msg,
				"%s+: waiting for pid %d issued in state %s",
				where, wait->pid,
				find_state_name (wait->state));
		}

		/* Find end-of-message for adding on additional things.  */
		log = log_msg + strlen (log_msg);

		if (wait->sub_aatv != (AATV *) NULL)
		{
			sprintf (log, ", issued by AATV %s",
				wait->sub_aatv->id);

			if ((wait->fsm_aatv != (AATV *) NULL) &&
				(wait->sub_aatv != wait->fsm_aatv))
			{
				log += strlen (log);
				sprintf (log, ", from %s", wait->fsm_aatv->id);
			}
		}
		else
		{
			if (wait->fsm_aatv != (AATV *) NULL)
			{
				sprintf (log, ", from %s", wait->fsm_aatv->id);
			}
		}

		logit (LOG_DAEMON, LOG_NOTICE, "%s", log_msg);

		dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s", log_msg));
	} /* end of for */

	for (pe = authreq->proc_q; pe != (PROC_ENT *) NULL; pe = pe->next)
	{
		sprintf (log_msg,
			"%s+: waiting for process issued in state %s",
			where, find_state_name (pe->state));

		/* Find end-of-message for adding on additional things. */
		log = log_msg + strlen (log_msg);

		if (pe->sub_aatv != (AATV *) NULL)
		{
			sprintf (log, ", issued by AATV %s", pe->sub_aatv->id);

			if ((pe->fsm_aatv != (AATV *) NULL) &&
				(pe->sub_aatv != pe->fsm_aatv))
			{
				log += strlen (log);
				sprintf (log, ", from %s", pe->fsm_aatv->id);
			}
		}
		else
		{
			if (pe->fsm_aatv != (AATV *) NULL)
			{
				sprintf (log, ", from %s", pe->fsm_aatv->id);
			}
		}

		logit (LOG_DAEMON, LOG_NOTICE, "%s", log_msg);

		dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s", log_msg));
	}

} /* end of log_queues () */

/*************************************************************************
 *
 *	Function: match_waldo
 *
 *	Purpose: Locate a waldo (event) which matches the received reply.
 *		 Find the matching EVENT_ENT for the given authreq which
 *		 recorded the sending of the request and which resulted
 *		 in this reply being returned.  The standard PW_PROXY_STATE
 *		 attribute which was added when the request was created
 *		 is used to locate the correct EVENT_ENT.  In the case of
 *		 the FORK_REPLY type of AATV, the PID value will be greater
 *		 than zero.  The SOCKET type of AATV will always have a PID
 *		 of zero.  For the former case, we need to kill the child
 *		 process having the same PID.  In either case, we need the
 *		 state recorded in the EVENT_ENT, and then we need to unlink
 *		 the EVENT_ENT entry and then free its memory.
 *
 *	Returns: the discovered event, or
 *		 NULL, if there was no waldo, or no event matched.
 *
 *	Remarks: Here is the waldo matching algorithm (given a
 *		 recovered state):
 *
 *		How many waldoes are on the authreq event_q?
 *
 *		None:
 *			We are done.
 *
 *		One:
 *			We are done.
 *
 *		More than one:
 *
 *			Was there a Proxy-Action in the received reply?
 *
 *			Yes:
 *				Search the waldo list to match for the state
 *				and to match for the Proxy-Action recovered
 *				from the reply.
 *
 *			No:
 *				Search the waldo list to match for just the
 *				state.
 *
 *************************************************************************/

static EVENT_ENT *
match_waldo (state, authreq, ev, list)

int             state;
AUTH_REQ       *authreq;
EV             *ev;
VALUE_PAIR     *list;

{
	int             len;
	char           *s;
	EVENT_ENT      *event;
	EVENT_ENT     **prev_event;
	VALUE_PAIR     *vp;
	char            action[AUTH_ID_LEN + 1];
	static char    *func = "match_waldo";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq->event_q == (EVENT_ENT *) NULL) /* No waldoes on list. */
	{
		return (EVENT_ENT *) NULL;
	}

	/* If there is only one waldo, then that one must be the one. */
	if (authreq->event_q->next == (EVENT_ENT *) NULL)
	{
		event = authreq->event_q; /* Done.  Only one waldo. */
		found_waldo (event, ev);
		free_event (authreq->event_q);	/* Unlink the waldo. */
		authreq->event_q = (EVENT_ENT *) NULL;
		return event;	/* EXIT HERE with the discovered event. */
	}

	action[0] = '\0';	/* Assume no action in the reply. */

	/* Recover the Proxy-Action if there was one. */
	if ((vp = get_vp_vend (list, PW_PROXY_ACTION, VC_MERIT)) != NULL_VP)
	{
		len = MIN(strlen (vp->strvalue), AUTH_ID_LEN);
		strncpy (action, vp->strvalue, len);
		action[len] = '\0';

		/* Since we have the action, match on both state and action. */
		for (prev_event = &authreq->event_q ;
			(event = *prev_event) != (EVENT_ENT *) NULL ;
			prev_event = &event->next)
		{
			if ((event->action == (char *) NULL) ||
						(event->action[0] == '\0'))
			{
				s = (char *) event->fsm_aatv->id;
			}
			else
			{
				s = event->action;
			}

			if ((event->state == (u_char) state) &&
							strcmp (s, action) == 0)
			{
				found_waldo (event, ev);
				*prev_event = event->next; /* Unlink waldo. */
				free_event (event);
				break;
			}
		}

		return event;	/* EXIT HERE with the discovered event. */
	}

	for (prev_event = &authreq->event_q ;
		(event = *prev_event) != (EVENT_ENT *) NULL ;
		prev_event = &event->next)
	{
		if (event->state == (u_char) state)
		{
			found_waldo (event, ev);
			*prev_event = event->next; /* Unlink the waldo. */
			free_event (event);
			break;
		}
	}

	return event;	/* Return the discovered event. */

} /* end of match_waldo () */

/*************************************************************************
 *
 *	Function: nak_action
 *
 *	Purpose: Utility AATV which always responds negatively.
 *
 *************************************************************************/

static int
nak_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "nak_action";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	return EV_NAK;
} /* end of nak_action () */

/*************************************************************************
 *
 *	Function: null_action
 *
 *	Purpose: Place holder for no action in the FSM (which usually
 *		 results in a return to the engine's main select() loop).
 *
 *************************************************************************/

static int
null_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "null_action";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	return EV_WAIT;
} /* end of null_action () */

#define	PACKET_COUNTS_BUFFERS	20

/*************************************************************************
 *
 *	Function: packet_counts_toa
 *
 *	Purpose: Display routine for PACKET_COUNTS structure
 *
 *************************************************************************/

static char *
packet_counts_toa (ctr)

PACKET_COUNTS  *ctr;

{
	static int      ndx = 0;
	static char     buffers[PACKET_COUNTS_BUFFERS][80];
	char           *end;
	char           *buff = buffers[ndx];
	static char    *func = "packet_counts_toa";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (ctr == (PACKET_COUNTS *) NULL)
	{
		return ((char *) NULL);
	}

	if ((ctr->packets == 0) && (ctr->octets == 0) && (ctr->actions == 0))
	{
		return ("");
	}

	/* prefix the buffer. */
	sprintf (buff, "%s: ", ctr->name);
	end = buff + strlen (buff);

	if ((ctr->packets != 0) || (ctr->octets != 0))
	{
		sprintf (end, "%lu/%u", ctr->octets, ctr->packets);
		if (ctr->actions != 0)
		{
			strcat (end, " ");
		}
		end += strlen (end);
	}

	if (ctr->actions != 0)
	{
		sprintf (end, "(%lu)", ctr->actions);
	}

	ndx++;
	if (ndx >= PACKET_COUNTS_BUFFERS)
	{
		ndx = 0;
	}

	return (buff);
} /* end of packet_counts_toa () */

/*************************************************************************
 *
 *	Function: pending_action
 *
 *	Purpose: Checks on the event queue of this AUTH_REQ structure.
 *
 *************************************************************************/

static int
pending_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "pending_action";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq->event_q == (EVENT_ENT *) NULL &&
		authreq->proc_q == (PROC_ENT *) NULL)
	{
		return EV_ACK;
	}
	else /* something still in the event queue (pending) */
	{
		return EV_WAIT;
	}
} /* end of pending_action () */

/*************************************************************************
 *
 *	Function: protocol_check
 *
 *	Purpose: Perform old style authorization
 *
 *	Returns: EV_ACK or EV_NAK
 *
 *************************************************************************/

static int
protocol_check (authreq, protpair)

AUTH_REQ       *authreq;
VALUE_PAIR    **protpair;

{
	int             count = 0;
	int             result;
	VALUE_PAIR     *vp;
	VALUE_PAIR    **last;
	char           *ptr;
	int             fprot;
	static char    *fuser[] = {"dumbuser", "pppuser", "slipuser",
				"cblogin", "cbframed", "obuser", "admin",
				"execuser", "authonly"};
	static int      fuser_members = 9;
	static char    *func = "protocol_check";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	result = authreq->repstatus;

	/*
	 * Special check to match protocol configuration returned to that
	 * being used by client.  Individual entries in users can override
	 * this check by explicitly providing a protocol configuration.
	 */
	if (result == EV_ACK)
	{
		fprot = -1;		/* Assume we don't know protocol */

		if ((vp = get_vp (authreq->cur_request,
						PW_SERVICE_TYPE)) == NULL_VP)
		{
			fprot = 0; /* assume dumbuser */
		}
		else /* Service-Type provided in request */
		{
			fprot = vp->lvalue;

			if (fprot == PW_LOGIN)
			{
				fprot = 0;
			}
			else
			{
				if (fprot == PW_FRAMED)
				{
					if ((vp = get_vp (authreq->cur_request,
						PW_FRAMED_PROTOCOL)) != NULL_VP)
					{
						fprot = vp->lvalue;
					}
				}
			}
		}

		for (vp = authreq->cur_request ; vp != NULL_VP ; vp = vp->next)
		{
			if (count == authreq->cur_count)
			{
				break; /* vp points to added stuff */
			}
			count++;
		}

		/*
		 *	Set "last" to point to the "next" pointer
		 *	of the actual last cur_request list item.
		 */

		for (last = &authreq->cur_request ;
			*last != NULL_VP ;
			last = &((*last)->next))
		{
			continue;
		}

		if ((fprot >= 0) &&
			(fprot < fuser_members) &&
			((vp == NULL_VP) ||
				(get_vp (vp, PW_SERVICE_TYPE) == NULL_VP)))
		{
			/*
			 * If appropriate config info isn't in cur_request,
			 * try to find "xxxuser" entry for this protocol.
			 *
			 * Forget it if pseudo-user entries aren't in "users"
			 * file, because we might be a remote RADIUS server
			 * and the local server (closest to the NAS) should
			 * fill in this information.
			 */

			user_find ((char *) authreq->client->file_pfx,
				fuser[fprot], fprot, (VALUE_PAIR **) NULL,
				(VALUE_PAIR **) NULL, last, 0);
		}
	}

	*protpair = get_last_vp (authreq->cur_request, PW_FRAMED_PROTOCOL);

	/*
	 * Enforce protocol restrictions.  See if protocol specified in
	 * cur_request is in list of prohibited protocols in user_check.
	 */

	ptr = (char *) NULL;	/* Use as flag on loop exit */
	for (vp = authreq->user_check ;
		(result == EV_ACK) && (vp != NULL_VP) ;
		vp = vp->next)
	{
		if ((vp = get_vp_ci (vp, CI_PROHIBIT, 0)) == NULL_VP)
		{
			break;
		}

		if (*protpair == NULL_VP)  /* was not FRAMED type */
		{
			if (vp->lvalue == PW_DUMB)
			{
				ptr = "Non-framed";
				result = EV_NAK;
			}
		}
		else
		{
			if (vp->lvalue == (*protpair)->lvalue)
			{
				ptr = dict_find_value (vp->lvalue,
							vp->ap)->name;
				result = EV_NAK;
			}
		}
	}

	/* Attempt to use prohibited protocol, tell the user. */
	if (ptr != (char *) NULL)
	{
		reply_sprintf (0, authreq, "%s access is prohibited", ptr);
	}

	return result;
} /* end of protocol_check () */

/*************************************************************************
 *
 *	Function: proxy_forwarding
 *
 *	Purpose: Process incoming proxy action forwarding packets.
 *
 *	Returns: authreq with attributes for local case,
 *		 or NULL, if packet was forwarded.
 *
 *************************************************************************/

static AUTH_REQ *
proxy_forwarding (sockfd, sin, host, len)

int             sockfd;
struct sockaddr_in *sin;
UINT4           host;
u_int           len;

{
	u_short       attr;
	u_short       length;
	int           bad_packet;
	int           shorten = 0;
	int           type;
	UINT4         ipaddr;
	u_char       *gap;
	u_char       *ptr;
	AUTH_HDR1    *ah1;
	ATTR_HDR     *ah;
	AUTH_HDR     *auth;
	AUTH_REQ     *areq;
	char         *agent;
	char         *bad_reason;
	char         *cannonical;
	char         *filter;
	CLIENT_ENTRY *ce;
	struct sockaddr_in lcl_sin;
	char          realm[AUTH_ID_LEN + 1];
	static char  *func = "proxy_forwarding";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	auth = (AUTH_HDR *) recv_buffer;
	bad_packet = 0;		/* 0 == not a bad packet. */
				/* 1 == bad packet, don't dump it. */
				/* 2 == bad packet, dump it. */
	bad_reason = "unknown";
	type = -1;		/* Invalid authentication type */

	if (auth->code == PW_FORWARDING)
	{
		/*
		 * Save proxy-forwarding messages in the original...
		 */
		memcpy (recv_buffer_backup, recv_buffer,
			sizeof (recv_buffer_backup));
		was_proxy_forwarding = len; /* validate recv_buffer_backup[] */

		ah1 = (AUTH_HDR1 *) auth;
		ptr = ah1->data;
		gap = ptr;		/* Start of buffer for shift. */
		attr = *ptr++;		/* First attribute (is User-Realm?) */

		/*
		 *	Note: Proxy-Forwarding will only come
		 *	from Merit style servers.
		 */
		if (find_client (host, &ce) != 0)
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: server '%s' not in %s/%s",
				func, ip_hostname (host), radius_dir,
				RADIUS_CLIENTS);

			bad_packet = 2;
			bad_reason = "unknown client";
		}
		else	/* have found client */
		{
			if ((ce->veps == (VENDOR_LIST *) NULL) ||
				(ce->veps->vep->id != VC_MERIT))
			{
				logit (LOG_DAEMON, LOG_ERR,
			"%s: Proxy-Forwarding packet from type=%s client '%s'",
					func, vendor_list_toa (ce->veps),
					ce->hostname);

				bad_packet = 2;
				bad_reason = "vendor type != Merit";
			}
			else	/* was Merit style vendor */
			{
				if (attr != PW_USER_REALM)
				{
					bad_reason = "User-Realm not first";
					bad_packet = 1; /* Don't dump it. */
				}
				else	/* was User-Realm attribute */
				{
					length = *ptr++;
					if (length < 2)
					{
						bad_reason =
							"User-Realm length < 2";
						bad_packet = 2; /* dump it. */
					}
					else	/* have reasonable length */
					{
						/* Save how much shortened. */
						shorten = length;

						/* New attribute type/length. */
						length -= 2;

						/* Save realm for forwarding. */
						memcpy (realm,
							(char *) ptr, length);
						realm[length] = '\0';

						/* Point to next attribute. */
						attr = *(ptr + length);

						/* Advance to next value. */
						ptr = gap + length + 2;

						length = ntohs(auth->length) -
						   AUTH_HDR1_LEN - (ptr - gap);

						/*
						 *	Clobber packet length!
						 *	Note: This prevents
						 *	multiple forwarding.
						 */
						auth->length =
						    htons(ntohs(auth->length)
							  - shorten);
					}
				}
			}
		}
	}
	else	/* not PW_FORWARDING packet */
	{
		if (auth->code == PW_EXTENDED_FORMAT &&
			auth->command == PW_FORWARDING)
		{
			ah = (ATTR_HDR *) auth->data;
			gap = (u_char *) ah;
			ptr = gap;
			memcpy ((char *) &attr, (char *) ah->type,
								sizeof (attr));
			attr = ntohs(attr);

			/*
			 *	XXX : This code needs to deal with
			 *		Merit vendor specific attributes.
			 */
			if (attr != PW_USER_REALM || (ah->flags & ATTR_VEND_SP))
			{
				return (AUTH_REQ *) NULL; /* silently discard */
			}
			memcpy ((char *) &length, (char *) ah->length,
							sizeof (length));
			shorten = ntohs(length);
			length = shorten - ATTR_HDR_LEN;
			if (length < ATTR_HDR_LEN)
			{
				bad_reason = "header lenth < ATTR_HDR_LEN";
				bad_packet = 2; /* dump it */
			}
			else
			{
				memcpy (realm, (char *) ah + ATTR_HDR_LEN,
					length);
				realm[length] = '\0';
				ah += ATTR_HDR_LEN + length;
				memcpy ((char *) &attr, (char *) ah->type,
								sizeof (attr));
				attr = ntohs(attr);
				ptr = gap + length + ATTR_HDR_LEN;
				length = ntohs(auth->length) -
						    AUTH_HDR_LEN - (ptr - gap);
				auth->length =
					  htons(htons(auth->length) - shorten);
			}
		}
		else
		{
			return (AUTH_REQ *) NULL; /* Don't forward V2 for now */
		}
	}

	/*
	 *	XXX: This code needs to deal with
	 *	Merit vendor specific attributes.
	 */
	/* Check that the second attribute is PW_PROXY_ACTION */
	if ((attr != PW_PROXY_ACTION) && (bad_packet == 0))
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s: Badly formed packet for realm '%s'",
			func, realm);
		bad_reason = "Missing Proxy-Action";
		bad_packet = 2;
	}

	/* Get the "agent" for this realm. */
	if ((bad_packet == 0) && (find_auth_type (realm, 0, "", &type, &agent,
						&cannonical, &filter) < 0))
	{
		logit (LOG_DAEMON, LOG_ERR, "%s: Can't find realm '%s'",
			func, realm);
		bad_reason = "No such realm";
		if ('\0' != realm[0])
		{
			bad_packet = 1; /* Don't dump these (for now) */
		}
		else
		{
			bad_packet = 2;	/* Dump these */
		}
	}

	/* See if this realm is of type RADIUS */
	if ((bad_packet == 0) && (type == AA_RAD))
	{
		/* See if the "agent" is known to us. */
		if (find_client_by_name (agent, &ipaddr, &ce) == 0)
		{
			/* addr_is_us() handles dual-homed machines */
			if (addr_is_us (ipaddr) != 0)   /* for us? */
			{
				/*
				 *	Since we have determined that
				 *	this realm is for us, strip
				 *	off the first attribute leaving
				 *	Proxy-Action as first attribute
				 *	in the request.
				 */

				if ((ptr - gap) > 2) /* be careful */
				{
					dprintf(2, (LOG_DAEMON, LOG_DEBUG,
					     "%s: %d bytes from 0x%p to 0x%p.",
						func, length, ptr, gap));
					memcpy (gap, ptr, length);
				}

				/* Fake out get_radrequest() */
				auth->code = PW_ACCESS_REQUEST;

				if (get_radrequest (sockfd, &areq, sin, host,
						    len -shorten , ce) == 0)
				{
					/* Restore true request type */
					auth->code = PW_FORWARDING;

					return areq; /* Now have attributes! */
				}
				else /* Error was logged in get_radrequest() */
				{
					return (AUTH_REQ *) NULL;
				}
			}
			else	/* Make sure we forward to a Merit vendor! */
			{
				if ((ce->veps == (VENDOR_LIST *) NULL) ||
					(ce->veps->vep->id != VC_MERIT))
				{
					logit (LOG_DAEMON, LOG_ERR,
	 "%s: Proxy-forwarding to realm '%s' failed, host '%s' server type=%s",
						func, realm, ce->hostname,
						vendor_list_toa (ce->veps));
					bad_packet = 2;
					bad_reason = "Realm server != Merit";
				}
				else	/* was not destined for "us" */
				{
					/*
					 *	If came in V2, it goes out v2
					 *	and must recalculate the MIC.
					 */
					if (auth->code == PW_EXTENDED_FORMAT)
					{
						auth->length =
							ntohs(auth->length);
						build_request_mic (auth,
							ce->secret);
					}

					lcl_sin.sin_family = AF_INET;
					lcl_sin.sin_addr.s_addr = htonl(ipaddr);
					lcl_sin.sin_port = htons(auth_fwd_port);
					length = (int) ntohs(ah1->length);

					/*
					 *	Packet level debugging.
					 */
					if ((debug_flag > 2) ||
					   ((debug_flag > 0) &&
					   (ce != (CLIENT_ENTRY *) NULL) &&
					   ((ce->client_type & CE_DEBUG) != 0)))
					{
						dumpit (LOG_DAEMON, LOG_DEBUG,
						    (u_char *) auth,
						    length, 0,
			      "%s: forwarding packet from %s type=%s to %s:%d",
						    func, ip_hostname (host),
						    authtype_toa (auth->code),
						    ce ? ce->hostname : "??",
						    ntohs(lcl_sin.sin_port));
					}

					if (log_forwarding != 0)
					{
						logit (LOG_DAEMON, LOG_INFO,
				    "Proxy-Forwarding from %s for %s to %s:%d",
						    ip_hostname (host), realm,
						    ce ? ce->hostname : "??",
						    htons(lcl_sin.sin_port));
					}

					sendto (rad_2rad_aatv->sockfd,
						(char *) auth, length, (int) 0,
						(struct sockaddr *) & lcl_sin,
						sizeof (lcl_sin));

					return (AUTH_REQ *) NULL;
				}
			}
		}
		else /* Could not find any client information. */
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: No client for '%s'", func, agent);
			bad_packet = 1;
			bad_reason = "No remote client";
		}
	}
	else /* Realm was not of authentication type RADIUS */
	{
		if (bad_packet == 0)
		{
			if (find_client_by_name (ourhostname,
						&ipaddr, &ce) == 0)
			{
				/*
				 *	Since we have determined that
				 *	this realm is for us, strip
				 *	off the first attribute leaving
				 *	Proxy-Action as first attribute
				 *	in the request.
				 */

				if ((ptr - gap) > 2) /* be careful */
				{
					dprintf(2, (LOG_DAEMON, LOG_DEBUG,
					      "%s: %d bytes from 0x%p to 0x%p",
						func, length, ptr, gap));

					memcpy (gap, ptr, length);
				}

				/* Fake out get_radrequest() */
				auth->code = PW_ACCESS_REQUEST;

				if (get_radrequest (sockfd, &areq, sin,
						host, len - shorten, ce) == 0)
				{
					/* Restore true request type */
					auth->code = PW_FORWARDING;

					if (enqueue_authreq (&global_auth_q,
						areq) == (AUTH_REQ *) NULL)
					{
						SAR_FREED(areq);
						free_authreq_final (areq);
						return ((AUTH_REQ *) NULL);
					}

					return areq; /* We have attributes! */
				}
				else /* Error was logged in get_radrequest() */
				{
					return (AUTH_REQ *) NULL;
				}
			}
			else /* Could not find any client information. */
			{
				logit (LOG_DAEMON, LOG_ERR,
				 "%s: No client information for ourself, '%s'",
					func, ourhostname);
				bad_packet = 1; /* Don't dump it. */
				bad_reason = "No loopback client";
			}
		}
	}

	/* If we fell through to here, we've got a bad packet to report */
	switch (bad_packet)
	{
	    case 1:	/* Simple log, don't dumpit. */
		logit (LOG_DAEMON, LOG_INFO,
			"%s: Bad %s packet received from %s[%u] -- %s",
			func, authtype_toa (auth->code),
			ip_hostname (ntohl(sin->sin_addr.s_addr)),
			ntohs(sin->sin_port), bad_reason);
		break;

	    case 2:	/* Log it and dump it! */
		if (dump_received_packet (func, auth->code, len,
					  sin, bad_reason) == 0)
		{
			dumpit (LOG_DAEMON, LOG_INFO, auth, len, 0,
				"%s: Bad %s packet received from %s[%u] -- %s",
				func, authtype_toa (auth->code),
				ip_hostname (ntohl(sin->sin_addr.s_addr)),
				ntohs(sin->sin_port), bad_reason);
		}
		break;

	    default:	/* Shouldn't get here... */
		dumpit (LOG_DAEMON, LOG_ERR, auth, len, 0,
  "%s: Non-fatal internal error (%d), bad %s packet received from %s[%u] -- %s",
			func, authtype_toa (auth->code),
			ip_hostname (ntohl(sin->sin_addr.s_addr)),
			ntohs(sin->sin_port), bad_reason);
		break;
	} /* end of switch */

	return (AUTH_REQ *) NULL;
} /* end of proxy_forwarding () */

/*************************************************************************
 *
 *	Function: pw_expired_action
 *
 *	Purpose: Return EV_PW_EXPIRED event for FSM purposes.
 *
 *************************************************************************/

static int
pw_expired_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "pw_expired_action";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	return EV_PW_EXPIRED;
} /* end of pw_expired_action () */

/*************************************************************************
 *
 *	Function: queue_find
 *
 *	Purpose: Return AUTH_REQ_Q for the type of code.
 *
 *************************************************************************/

AUTH_REQ_Q *
queue_find (code)

int             code;

{
	AUTH_REQ_Q     *q;
	static char    *func = "queue_find";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (code == PW_ACCOUNTING_REQUEST)
	{
		/* Accounting goes onto it's own queue. */
		q = &global_acct_q;
	}
	else
	{
		/* All other requests go on the authentication queue. */
		q = &global_auth_q;
	}

	return (q);
} /* end of queue_find () */

/*************************************************************************
 *
 *	Function: rad_2rad_recv
 *
 *	Purpose: Retrieve RADIUS to RADIUS replies from global recv_buffer,
 *		 find matching local request structure, validate senders
 *		 credentials (using shared secret and reply digest), attach
 *		 reply-items from RADIUS packet to local request structure,
 *		 and return the (modified) identifed request structure and
 *		 the corresponding event type.
 *
 *************************************************************************/

AUTH_REQ *
rad_2rad_recv (sockfd, sin, from_ipaddr, rcvlen, ev)

int             sockfd;
struct sockaddr_in *sin;
UINT4           from_ipaddr;
u_int           rcvlen;
EV             *ev;

{
	u_char          state;
	u_short         code;
	u_short         rcv_id;
	int             i;
	int             missing_state;
	int             result;
	int             version;
	int             seq_matches;
	int             digest_matches;
	int             reply_mismatches;
	char           *xdigest;		/* for building strings */
	u_char         *vector_ptr;
	AUTH_HDR       *auth = (AUTH_HDR *) NULL;
	AUTH_REQ       *authreq;
	AUTH_REQ       *last_authreq;
	AUTH_REQ_Q     *aaq;
	VALUE_PAIR     *new_stuff;
	VALUE_PAIR     *reply_items;
	VALUE_PAIR     *vp;
	VALUE_PAIR     *chk_rep;
	VALUE_PAIR     *chk_cur;
	EVENT_ENT      *event;
	EVENT_ENT     **prev_event;
	CLIENT_ENTRY   *ce;
	VENDOR_LIST    *veps;
	char            log_msg[1024];
	char            log_guard[256];
	u_char          reply_digest[AUTH_VECTOR_LEN];
	static char    *func = "rad_2rad_recv";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered, reply from %s[%u]",
		func, inet_ntoa (sin->sin_addr), ntohs(sin->sin_port)));

	ev->a.aatv = rad_any_aatv;
	ev->isproxy = 0;

	/* Measure how much reply traffic we get. */
	stat_responses.packets++;
	stat_responses.octets += rcvlen;	/* Just UDP payload. */

	/* Find sending server in the local database */
	if (find_client (from_ipaddr, &ce) != 0)
	{
		logit (LOG_DAEMON, LOG_ERR, "%s: server \"%s\" not in %s/%s",
			func, ip_hostname (from_ipaddr), radius_dir,
			RADIUS_CLIENTS);
		return (AUTH_REQ *) NULL;
	}

	/* Retrieve packet header values into local variables. */
	auth = (AUTH_HDR *) recv_buffer;
	if (auth->code == PW_EXTENDED_FORMAT)
	{
		if ((result = check_mic (auth, rcvlen, ce->secret, ce)) != 0)
		{
			logit (LOG_DAEMON, LOG_INFO,
				"%s: Received invalid %s from %s[%u]",
				func, result < 0 ? "MIC" : "TIMESTAMP",
				ip_hostname (ntohl(sin->sin_addr.s_addr)),
				ntohs(sin->sin_port));
			return (AUTH_REQ *) NULL;
		}
		rcv_id = ntohs(auth->id);
		code = ntohs(auth->command);
		vector_ptr = auth->vector;
		version = auth->flag_ver & AUTH_HDR_VERSION_BITS;
	}
	else	/* Good ole V1. */
	{
		code = auth->code;
		rcv_id = ((AUTH_HDR1 *) auth)->id;
		vector_ptr = ((AUTH_HDR1 *) auth)->vector;
		version = VER1;
	}

	/*	Packet level debugging. */
	if ((debug_flag > 2) ||
		((debug_flag > 0) &&
			(ce != (CLIENT_ENTRY *) NULL) &&
			((ce->client_type & CE_DEBUG) != 0)))
	{
		dumpit (LOG_DAEMON, LOG_DEBUG, (u_char *) auth, rcvlen, 0,
			"%s: reply type=%s from %s for [%s]",
			func, authtype_toa (code), ce ? ce->hostname : "??",
			ip_hostname (ntohl(sin->sin_addr.s_addr)));
	}

	/* Assign to a queue based on the packet type. */
	switch (code)
	{
	    case PW_ACCESS_ACCEPT:
		result = EV_ACK;
	  	aaq = &global_auth_q;
		break;

	    case PW_ACCESS_CHALLENGE:
		result = EV_ACC_CHAL;
	  	aaq = &global_auth_q;
		break;

	    case PW_ACCESS_REJECT:
	    case PW_ACCESS_ERROR:
		result = EV_NAK;
	  	aaq = &global_auth_q;
		break;

	    case PW_ACCOUNTING_RESPONSE:
		result = EV_ACK;
		aaq = &global_acct_q;
		break;

	    case PW_ACCOUNTING_ERROR:
		result = EV_NAK;
		aaq = &global_acct_q;
		break;

	    case PW_COMMAND_UNRECOGNIZED:
		logit (LOG_DAEMON, LOG_INFO,
			"%s: Received CMD_UNREC from %s[%u] - id = %u",
				func, inet_ntoa (sin->sin_addr),
				ntohs(sin->sin_port), rcv_id);
		return (AUTH_REQ *) NULL;

	    default:
		logit (LOG_DAEMON, LOG_INFO,
		 "%s: Received strange reply to request %u from %s[%u]",
			func, rcv_id, inet_ntoa (sin->sin_addr),
			ntohs(sin->sin_port));
		send_cmd_unrec (sockfd, version, sin, rcv_id, code, ce);
		return (AUTH_REQ *) NULL;
	}

	seq_matches = 0;
	digest_matches = 0;

	/*
	 *	Match up the received reply's sequence number with one of
	 *	the existing request structures on the global request queue.
	 */
	authreq = response_match (aaq->q, ce, recv_buffer, rcvlen, version,
				rcv_id, vector_ptr, reply_digest, &seq_matches,
				&digest_matches, &last_authreq);

	if (authreq == (AUTH_REQ *) NULL) /* nothing found on entire queue */
	{
		if (seq_matches >= 1) /* had at least one seq number match */
		{
			xdigest = log_msg;
			*xdigest = '\0';

			for (i = 0; i < AUTH_VECTOR_LEN; i++)
			{
				sprintf (xdigest, "%2.2X",
					(u_char) vector_ptr[i]);
				xdigest += strlen (xdigest);
			}

			dumpit (LOG_DAEMON, LOG_INFO, auth, rcvlen, 0,
	 "%s: Invalid reply %s digest from %s[%u] id %u digest %s, %d matches",
				func, authtype_toa (code),
				ip_hostname (from_ipaddr), ntohs(sin->sin_port),
				rcv_id, log_msg, seq_matches);

			packet_log (log_msg, last_authreq,
				   PL_REP_PORT | PL_REP_VECTOR | PL_FWD_VECTOR);

			logit (LOG_DAEMON, LOG_INFO, "%s-Matched-%s",
				func, log_msg);
		}
		else /* no sequence numbers matched */
		{
			logit (LOG_DAEMON, LOG_INFO,
	       "%s: Received unexpected reply %s (type %u) id %u from '%s[%u]'",
				func, authtype_toa (code), code, rcv_id,
				ip_hostname (from_ipaddr), ntohs(sin->sin_port));
		}

		/* Add some diagnostics. */
		if (debug_flag >= 2)
		{
			dumpit (LOG_DAEMON, LOG_DEBUG, recv_buffer, rcvlen, 0,
				"%s: got reply %s (type %u) id %u from %s[%u]",
				func, authtype_toa (code), code, rcv_id,
				ip_hostname (from_ipaddr), ntohs(sin->sin_port));
		}

		return authreq;	/* Return the NULL authreq. */
	}

	dprintf(1, (LOG_DAEMON, LOG_DEBUG,
		"%s: received reply %s to RADIUS request %u/%u",
		func, authtype_toa (code), authreq->fwd_id, rcv_id));

	/* Recover the reply items found in the received packet. */
	reply_items = gen_valpairs (auth, rcvlen, ce->veps, GVP_DROP);

	/* Clear the encapsulation bit, if necessary. */
	if ((ce->client_type & CE_NOENCAPS) != 0)
	{
		for (vp = reply_items; vp != NULL_VP;  vp = vp->next)
		{
			if (((vp->flags & VPF_ENCAPS) != 0) &&
				(vp->ap->flags & ATTR_ENCAPS) == 0)
			{
				dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		     "%s: Trying to clear VPF_ENCAPS for %s, received from %s",
					func, vp->ap->name, ce->hostname));

				for (veps = ce->veps;
					veps != (VENDOR_LIST *) NULL;
					veps = veps->next)
				{
					if (vp->ap->vendor_id == veps->vep->id)
					{
					    dprintf(2, (LOG_DAEMON, LOG_DEBUG,
	     "%s: Clearing VPF_ENCAPS for %s, received from %s vendor %s (%s)",
						func, vp->ap->name,
						ce->hostname, veps->vep->name,
						vendor_list_toa (ce->veps)));

					    vp->flags &= ~VPF_ENCAPS;
					    break;
					}
				}
			}
		}
	}

	/* Get rid of received password attribute (if any). */
	avpair_del (&reply_items, PW_USER_PASSWORD, 0);

	/* Find where the new stuff starts and just point to those a/v pairs. */
	new_stuff = get_last_vp (reply_items, PW_PROXY_STATE);

	if (new_stuff == NULL_VP)
	{
		new_stuff = reply_items;	/* To handle older servers. */
		missing_state = 1;
	}
	else	/* found the last Proxy-State */
	{
		new_stuff = new_stuff->next;	/* Just want the new pairs. */
		missing_state = 0;
	}

	/* This call removes the Proxy-State attribute as a side effect. */
	state = get_state (&reply_items);  /* ST_END indicates no state found */

#ifdef USR_CCA
	if (code != PW_NAS_REB_RESP)
	{
#endif	 /* USR_CCA */

	if (state == ST_END) /* grandfather missing state */
	{
		dprintf(1, (LOG_DAEMON, LOG_DEBUG,
			"%s: no state found, grab event from waldo", func));

		/*
		 *	WARNING:  The following for loop assumes that
		 *	the first matching socket-type waldo found is
		 *	the relevant one.  This is normally the case
		 *	except in special situations (e.g., broadcasting).
		 */
		for (prev_event = &authreq->event_q ;
			(event = *prev_event) != (EVENT_ENT *) NULL ;
			prev_event = &event->next)
		{
			if ((event->fsm_aatv->aatvfunc_type == AA_SOCKET) ||
				(event->sub_aatv->aatvfunc_type == AA_SOCKET))
			{
				found_waldo (event, ev);
				*prev_event = event->next; /* Unlink waldo. */
				free_event (event);
				break;
			}
		}
	}
	else /* Use the recovered state to find the correct EVENT_ENT */
	{
		event = match_waldo (state, authreq, ev, reply_items);
	}

	if (event == (EVENT_ENT *) NULL)
	{
		logit (LOG_DAEMON, LOG_INFO,
       "%s: Received unexpected reply %s (type %u) to request %u from '%s[%u]'",
			func, authtype_toa (code), code, rcv_id,
			ip_hostname (from_ipaddr), ntohs(sin->sin_port));
		list_free (reply_items);
		return (AUTH_REQ *) NULL;
	}

	/*
	 *	Check to see if certain reply items match the original
	 *	items (or the current-list items anyway.)
	 */
	reply_mismatches = check_reply (authreq, reply_items);

	/*	If there's too many digest matches or any reply mismatches.  */
	if ((digest_matches > 1) || (reply_mismatches > 0))
	{
		logit (LOG_DAEMON, LOG_CRIT,
			"%s: WARNING -- %d digest matches!",
			func, digest_matches);

		dumpit (LOG_DAEMON, LOG_CRIT, (u_char *) authreq->fwdvec,
			AUTH_VECTOR_LEN, 0,
			"%s: forwarding vector for id %u (%u)",
			func, authreq->fwd_id, (u_char) authreq->fwd_id);

		dumpit (LOG_DAEMON, LOG_CRIT, (u_char *) reply_digest,
			AUTH_VECTOR_LEN, 0, "%s: expected reply digest", func);

		dumpit (LOG_DAEMON, LOG_CRIT, (u_char *) vector_ptr,
			AUTH_VECTOR_LEN, 0,
			"%s: packet reply digest (signature) on reply id (%u)",
			func, rcv_id);

		if (reply_mismatches > 0)
		{
			packet_log (log_msg, authreq,  PL_FWD_VECTOR);
			logit (LOG_DAEMON, LOG_CRIT,
				"Mismatched-Reply-%s", log_msg);
			logit (LOG_DAEMON, LOG_INFO,
				"%s: Original current request, id %u (%u)",
				func, authreq->fwd_id,
				(u_char) authreq->fwd_id);

			if ((rad_reply_switch & RRS_VERBOSE) != 0)
			{
				for (chk_cur = authreq->cur_request;
					chk_cur;
					chk_cur = chk_cur->next)
				{
					logit (LOG_DAEMON, LOG_INFO,
						"%s: ... %s=%s",
						func, chk_cur->ap->name,
						avpair_vtoa (chk_cur, 0));
				}
			}

			logit (LOG_DAEMON, LOG_INFO,
				"%s: New reply, id (%u)", func, rcv_id);

			if ((rad_reply_switch & RRS_VERBOSE) != 0)
			{
				for (chk_rep = reply_items;
					chk_rep;
					chk_rep = chk_rep->next)
				{
					logit (LOG_DAEMON, LOG_INFO,
						"%s: ... %s=%s",
						func, chk_rep->ap->name,
						avpair_vtoa (chk_rep, 0));
				}
			}
		} /* end of if (reply_mismatches > 0) */

		if ((rad_reply_switch & RRS_DUMP) != 0)
		{
			dumpit (LOG_DAEMON, LOG_INFO, (u_char *) recv_buffer,
				rcvlen, 0, "%s: Dump of mismatched reply",
				func);
		}

		/* Search free'd queue */
		last_authreq = response_match (aaq->freed, ce, recv_buffer,
						rcvlen, version, rcv_id,
						vector_ptr, reply_digest,
						NULL, NULL, NULL);

		if (last_authreq != (AUTH_REQ *) NULL)
		{
			logit (LOG_DAEMON, LOG_INFO,
				"%s: Also found on freed list", func);
			packet_log (log_msg, last_authreq,
				PL_FWD_VECTOR | PL_REP_PORT | PL_REP_VECTOR);
			logit (LOG_DAEMON, LOG_INFO, "Freed-%s", log_msg);
		}

		if ((rad_reply_switch & RRS_ABORT) != 0)
		{
			logit (LOG_DAEMON, LOG_CRIT,
				"%s: FATAL, errors in reply!", func);
			dumpcore = 1;
			abort ();
		}

		/*	Ignore the reply. */
		if ((rad_reply_switch & RRS_IGNORE) != 0)
		{
			packet_log (log_msg, authreq, PL_FWD_VECTOR);
			logit (LOG_DAEMON, LOG_CRIT, "Ignore-Reply-%s",
			       log_msg);
			list_free (reply_items);
			return ((AUTH_REQ *) NULL);
		}
	} /* end of if (digest_matches > 1) */

#ifdef USR_CCA
	} /* end of if (code != PW_NAS_REB_RESP) */
#endif	/* USR_CCA */

	/*
	 *	Note: The following code will not properly preserve the
	 *	order of received a/v pairs in the broadcasting case if
	 *	the reply from the first broadcast server arrives AFTER
	 *	the reply from a second broadcast server.
	 */

	/* Polite clients return everything sent to them, use everything. */
	if ((ce->client_type & CE_APPEND) == 0) /* Client is "polite". */
	{
		new_stuff = reply_items;

		/*
		 *	If the Proxy-State isn't missing, then the
		 *	Proxy-Action shouldn't be missing either...
		 *	Remove it now so we don't accumulate it.
		 */
		if (missing_state == 0 && reply_items != NULL_VP)
		{
			/* Remove the "first" Proxy-Action attribute. */
			if ((reply_items->ap->vendor_id == VC_MERIT) &&
				(reply_items->attribute == PW_PROXY_ACTION))
			{
				new_stuff = reply_items->next;
			}
		}
	}

	if (new_stuff != NULL_VP)
	{
		/*
		 *	Save only those a/v pairs added by the remote
		 *	server by adding them to the cur_request list.
		 */
		vp = NULL_VP;
		list_copy (&vp, new_stuff);

		/*
		 *	For old-style or "impolite" clients,
		 *	only append the new attributes.
		 */
		if (((ce->client_type & CE_APPEND) == CE_APPEND) ||
			(missing_state == 1))
		{
			list_cat (&authreq->cur_request, vp);
		}
		else /* For "polite" clients, use the entire reply. */
		{
			list_free (authreq->cur_request);
			authreq->cur_request = vp;
		}

#ifdef USR_CCA
		dprintf(2, (LOG_AUTH, LOG_DEBUG,
			"%s: secret = %s", func, ce->secret));

		if ((vp = get_vp_vend (authreq->cur_request,
				       PW_USR_AUTH_VECTOR, VC_USR)) != NULL_VP)
		{
			debug_pair (stderr, vp);

			/* Decrypt and then re-encrypt the VPN-Auth-Vector */
			proxy_vector_proc (authreq, ce->secret, vp->strvalue);
		}
#endif	/* USR_CCA */

	}

#ifdef USR_CCA
	if (code == PW_NAS_REB_RESP)
	{
		dprintf(2,(LOG_AUTH, LOG_DEBUG,
			"%s: NAS Reboot Response", func));
		free_authreq (authreq);
		result =  EV_NAS_REB_RESP;
	}
#endif	/* USR_CCA */

	list_free (reply_items);
	ev->value = result;

	if (log_forwarding != 0)
	{
		packet_log (log_msg, authreq, 0);
		logit (LOG_DAEMON, LOG_INFO, "Response-%s from %s[%s]:%d",
			log_msg, ce->hostname,
			ip_hostname (from_ipaddr), ntohs(sin->sin_port));
	}

	return authreq;
} /* end of rad_2rad_recv () */

/*************************************************************************
 *
 *	Function: rad_init
 *
 *	Purpose: Open a socket for sending to and receiving from NAS's.
 *		 Check if there's a socket on file descriptor zero.  If so,
 *		 check the socket port number.  If it is not ours, get and
 *		 bind the client request socket ourself.  Otherwise, use
 *		 this file descriptor for the client request socket.  If
 *		 file descriptor zero is not a socket, get and bind the
 *		 client request socket ourself.
 *
 *************************************************************************/

static void
rad_init (aatv)

AATV   *aatv;

{
	struct sockaddr_in lclsin;
	int             lcllen;
	int             sockfd = STDIN_FILENO; /* Did (x)inetd set this up? */
	static char    *func = "rad_init";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (aatv->sockfd == -1)
	{
		lcllen = sizeof (lclsin);
		memset ((char *) &lclsin, '\0', lcllen);
		if ((getsockname (sockfd, (struct sockaddr *) &lclsin,
								&lcllen) < 0) ||
			lclsin.sin_port != htons(auth_port))
		{
			sockfd = setupsock (&lclsin, auth_port);
		}
		else
		{
			inetd++;	/* indicate automatic invocation */
		}
		aatv->sockfd = sockfd;
	}
	return;
} /* end of rad_init () */

static AATV     radipc_aatv = DEF_AATV_SOCKET("RADDNS", rad_ipc_init, NULL,
						rad_ipc_recv);

AATVPTR         rad_ipc_aatv = & radipc_aatv;

/*************************************************************************
 *
 *      Function: rad_ipc_init
 *
 *      Purpose: Initialize the IPC socket used for resolving DNS names.
 *
 *************************************************************************/

static void
rad_ipc_init (aatv)

AATV           *aatv;

{
	struct sockaddr_in lclsin;
	static char    *func = "rad_ipc_init";

	dprintf(2, (LOG_AUTH, LOG_DEBUG, "%s: entered", func));

	if (aatv->sockfd == -1)
	{
		aatv->sockfd = setupsock (&lclsin, 0);
		rad_ipc_port = ntohs(lclsin.sin_port);
	}
	return;
} /* end of rad_ipc_init () */

/*************************************************************************
 *
 *      Function: rad_ipc_recv
 *
 *      Purpose: Process received DNS updates for clients database.
 *
 *************************************************************************/

static AUTH_REQ *
rad_ipc_recv (sockfd, sin, from_ipaddr, rcvlen, ev)

int                 sockfd;
struct sockaddr_in *sin;
UINT4               from_ipaddr;
u_int               rcvlen;
EV                 *ev;

{
	static char     *func = "rad_ipc_recv";

	dprintf(4, (LOG_AUTH, LOG_DEBUG, "%s: entered", func));

	switch (recv_buffer[0])
	{

	    case (0):	/* DNS reply (check that sender is us) */
		dns_recv (sin, from_ipaddr, rcvlen);
		break;

#if defined(MERIT_NASMAN)
	    case (1):	/* NAS Manager reply */
		nas_man_recv (sin, from_ipaddr, rcvlen);
		break;
#endif	/* MERIT_NASMAN */

#ifdef	USR_CCA
	    case (2):   /* Signals end of DNS replies.  Safe to send out
				Resource Query Reqeusts now */
		dns_done = TRUE;
		break;
#endif	/* USR_CCA */

	    default:
		logit (LOG_DAEMON, LOG_INFO, "%s: from %s - Invalid code",
			func, ip_hostname (from_ipaddr));
		break;
	}
	return (AUTH_REQ *) NULL;

} /* end of rad_ipc_recv () */

/*************************************************************************
 *
 *	Function: rad_recv
 *
 *	Purpose: Receive RADIUS client UDP requests, build an auth-request
 *		 structure, attach attribute-value pairs contained in the
 *		 request to the new structure, determine if this request
 *		 is a duplicate, if not, assign a unique identifier code,
 *		 and generate the appropriate EV_NEW_*** type event, and
 *		 otherwise generate an EV_DUP_REQ event.
 *
 *	Valid incoming requests are:
 *
 *	PW_ACCESS_REQUEST - Authentication request from a network
 *				client (a NAS, RADIUS server or a program).
 *
 *	PW_STATUS_SERVER - Management Poll to see if we're (still) alive.
 *
 *	PW_FORWARDING - Forward (possibly) this information to someone.
 *
 *	PW_PASSWORD_REQUEST - User request to change a password.
 *
 *	PW_ACCOUNTING_REQUEST - Accounting packets from client.
 *
 *	PW_ASCEND_RADIPA_ALLOCATE - IP address pool allocation request.
 *
 *	PW_ASCEND_RADIPA_RELEASE - IP address pool release request.
 *
 *************************************************************************/

AUTH_REQ *
rad_recv (sockfd, sin, host, length, ev)

int             sockfd;
struct sockaddr_in *sin;
UINT4           host;
u_int           length;
EV             *ev;

{
	int           result;
	AUTH_REQ     *authreq;
	AUTH_REQ     *candidate;
	CLIENT_ENTRY *ce;
	VALUE_PAIR   *vp;
	char          log_msg[1024];		/* For logging message. */
	char          log_guard[256];		/* For overflows, if any. */
	static char  *func = "rad_recv";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	was_proxy_forwarding = 0;	/* Invalidate recv_buffer_backup[] */

	/*
	 *	This find client() call tells us if the packet came from
	 *	someone we knew, and if so, pulls up the client entry (if
	 *	available).  However, the client entry may not be available
	 *	yet because the DNS hasn't finished...
	 */
        find_client (host, &ce);

	/* Measure what we receive. */
	stat_received.packets++;
	stat_received.octets += length;	/* Just UDP payload. */

	/* Collect the received packet. */
	if (get_radrequest (sockfd, &authreq, sin, host, length, ce) < 0)
	{
		return (AUTH_REQ *) NULL;
	}

	if (authreq == (AUTH_REQ *) NULL) /* was PW_FORWARDING */
	{

		if ((authreq = proxy_forwarding (sockfd, sin, host, length))
							== (AUTH_REQ *) NULL)
		{
			return authreq;
		}
		else /* We have a real authreq of type PW_ACCESS_REQUEST now. */
		{
			authreq->state = ST_INIT; /* set initial state */

			list_copy (&authreq->cur_request, authreq->request);

			/*
			 * Grab Proxy-Action and hang off event.a.proxy.
			 */

			vp = authreq->request;
			ev->a.proxy = vp->strvalue;
			ev->isproxy = 1;
			ev->value = EV_ACK;
			return authreq;
		}
	}

	authreq->state = ST_INIT; /* new requests get initial state */

#ifdef MERIT_GRANDFATHER
	if ((ce == (CLIENT_ENTRY *) NULL) || ((ce->client_type & CE_NAS) == 0))
	{
		/*
		 *	XXX: grandfather old style PW_AUTHENTICATION_ONLY
		 *	to new style.
		 */

		if ((authreq->code == PW_ACCESS_REQUEST) &&
			((vp = get_vp (authreq->request,
					PW_SERVICE_TYPE)) != NULL_VP &&
			vp->lvalue == PW_OUTBOUND_USER))
		{
			vp->lvalue = PW_AUTHENTICATE_ONLY;
		}

		/*
		 *	XXX: grandfather old style MANAGEMENT_POLL
		 *	to new Status-Server.
		 */

		if ((authreq->code == PW_ACCESS_REQUEST) &&
			((vp = get_vp (authreq->request,
					PW_SERVICE_TYPE)) != NULL_VP &&
			vp->lvalue == PW_ADMINISTRATIVE_USER))
		{
			authreq->code = PW_STATUS_SERVER;
		}
	}
#endif	/* MERIT_GRANDFATHER */

	if (authreq->code == PW_STATUS_SERVER)
	{
		authreq->client = &dummy_status_server_client;
	}
	else
	{
		if ((authreq->client == (CLIENT_ENTRY *) NULL) ||
			(authreq->client == &dummy_status_server_client))
		{
			logit (LOG_DAEMON, LOG_INFO,
				"%s: Request from unknown client %s",
				func, ip_hostname (authreq->ipaddr));
			free_authreq (authreq);
			return (AUTH_REQ *) NULL;
		}

#ifdef USR_CCA
/*		if (dns_done == TRUE)
		{
*/
			if (ce->state == NO_RQ_RESP)
			{
				logit (LOG_DAEMON, LOG_INFO,
				   "%s: Resending Resource Query Request to %s",
					func, ip_hostname (authreq->ipaddr));

				if (dns_done == TRUE)
				{
					send_rq_req (ce);
				}

				if (authreq->code != PW_NAS_REB_REQ)
				{
					/*
					 *	Forward the NAS Reboot request,
					 *	since the NAS transmits it only
					 *	once.
					 */
					free_authreq (authreq);
					return (AUTH_REQ *) NULL;
				}
			}
			else
			{
				if (ce->state == QUERY_IN_PROGRESS &&
					authreq->code != PW_RESOURCE_QUERY_RESP)
				{
					free_authreq (authreq);
					return (AUTH_REQ *) NULL;
				}
			}
/*		}
		else
		{
			logit (LOG_DAEMON, LOG_INFO,
			"%s: Not done with DNS Querying, dropping Request",
				func);
			free_authreq (authreq);
			return (AUTH_REQ *) NULL;
		}
*/
#endif	/* USR_CCA */

	}

	authreq->state = ST_INIT; /* new requests get initial state */

	/* See if this request is a duplicate.  The possible result values */
	/* are one of: EV_NEW_AUTHEN, EV_NEW_ACCT, EV_NAK or EV_DUP_REQ. */

	candidate = is_dup_request (authreq, &result);

	if (candidate != (AUTH_REQ *) NULL) /* non-NULL => duplicate found */
	{

#ifdef USR_CCA
		if (candidate->code == PW_RESOURCE_QUERY_REQ)
		{
			return (AUTH_REQ *) NULL;
		}
#endif	/* USR_CCA */

		authreq = candidate; /* Just use the old request (duplicate). */
	}
	else /* Copy the request attributes on cur_request for non-duplicate. */
	{

#ifdef	USR_CCA
/*		if (authreq->code != PW_RESOURCE_QUERY_RESP)
		{ */
			list_copy (&authreq->cur_request, authreq->request);
/*		} */

		if (authreq->code != PW_RESOURCE_FREE_REQ &&
			authreq->code != PW_RESOURCE_FREE_RESP &&
			authreq->code != PW_RESOURCE_QUERY_REQ &&
			authreq->code != PW_RESOURCE_QUERY_RESP &&
			authreq->code != PW_NAS_REB_REQ &&
			authreq->code != PW_STATUS_SERVER)
#else	/* USR_CCA */
		list_copy (&authreq->cur_request, authreq->request);
		if (authreq->code != PW_STATUS_SERVER)
#endif	/* USR_CCA */

		{
			if ((vp = get_vp (authreq->cur_request,
						PW_USER_NAME)) == NULL_VP)
			{
				if (authreq->code != PW_ACCOUNTING_REQUEST)
				{
					missing_attribute (authreq, func,
							   PW_USER_NAME, NULL);
				}
			}
			else /* Copy into PW_USER_ID attribute for later. */
			{
				if (get_vp_vend (authreq->cur_request,
					      PW_USER_ID, VC_MERIT) == NULL_VP)
				{
					avpair_add_vend (&authreq->cur_request,
						PW_USER_ID, vp->strvalue,
						-1, VC_MERIT);
				}
			}

			if (get_vp (authreq->cur_request,
						PW_NAS_IDENTIFIER) == NULL_VP &&
				(vp = get_vp (authreq->cur_request,
						PW_NAS_IP_ADDRESS)) != NULL_VP)
			{
				avpair_add (&authreq->cur_request,
					    PW_NAS_IDENTIFIER,
					    ip_hostname (vp->lvalue), -1);
			}

			/*
			 *	If this request is directly from a NAS client
			 *	and it is a CHAP request, we must retain the
			 *	reply vector for relaying purposes.
			 */
			if (((authreq->client->client_type & CE_NAS)
								== CE_NAS) &&
				(get_vp (authreq->cur_request,
					PW_CHAP_CHALLENGE)) == NULL_VP &&
				(get_vp (authreq->cur_request,
						PW_CHAP_PASSWORD)) != NULL_VP)
			{
				avpair_add (&authreq->cur_request,
					PW_CHAP_CHALLENGE,
					authreq->repvec, AUTH_VECTOR_LEN);
			}
		}

		/*
		 *	Indicate this request is an EV_RE_ACCESS if it
		 *	contains a non-null PW_STATE attribute-value pair,
		 *	since it must have been from an Access-Challenge.
		 */
		if ((vp = get_vp (authreq->cur_request, PW_STATE)) != NULL_VP)
		{
			if (vp->strsize != 0)
			{
				result = EV_RE_ACCESS;
			}
		}

		/* Count the attributes on cur_request. */

		for (vp = authreq->cur_request; vp != NULL_VP; vp = vp->next)
		{
			authreq->cur_count++;
		}
	}

	/* Log the incoming request we have just processed. */
	if (authreq->code != PW_STATUS_SERVER)
	{
		packet_log (log_msg, authreq, 0);
		logit (LOG_AUTH, LOG_INFO, "Received-%s", log_msg);
	}

	ev->value = result;
	ev->isproxy = 0;

	/*
	 *	Skip the following "if" statement for EV_DUP_REQ,
	 *	EV_NAK or EV_RETRY_LIMIT events.
	 */
	if (result != EV_DUP_REQ &&
		result != EV_NAK &&
		result != EV_RETRY_LIMIT)
	{
		ev->isproxy = 1;
		ev->value = EV_ACK;
		ev->a.proxy = (char *) NULL;	/* non-existant proxy */

#if defined(MERIT_HUNTGROUP) || defined(MERIT_LAS) || defined(MERIT_ORGANIZATION)
		if ((vp = get_vp_vend (authreq->cur_request,
					PW_PROXY_ACTION, VC_MERIT)) != NULL_VP)
		{
			SAR_FROM_PROXY(authreq);
			ev->a.proxy = vp->strvalue;
		}
#endif	/* MERIT_HUNTGROUP */

		/*
		 * If there is a proxy, we're done!
		 */
		if (ev->a.proxy != (char *) NULL)
		{
			return authreq;
		}

		/*
		 * No proxy, so make one up.
		 */
		switch (authreq->code)
		{
		    case PW_ACCESS_REQUEST:
			if (((vp = get_vp (authreq->cur_request,
						PW_SERVICE_TYPE)) != NULL_VP) &&
				vp->lvalue == PW_AUTHENTICATE_ONLY)
			{
				ev->a.proxy = EN_AUTH_ONLY;
			}
			else
			{
				ev->a.proxy = EN_NEW_AUTHEN;
			}
			break;

		    case PW_ACCOUNTING_REQUEST:
			ev->a.proxy = EN_NEW_ACCT;
			break;

		    case PW_STATUS_SERVER:

			/*
			 *	Allow management poll from anywhere.
			 *	Check to see if we're (still) alive.
			 */

			/*
			 *	Side effect -- update files:
			 *	(first arg == zero) => do not initialize
			 */
			stat_files (0, cache_users);

			ev->a.proxy = EN_MGT_POLL;
			break;

#ifdef USR_CCA
		    case PW_RESOURCE_FREE_REQ:
			ev->a.proxy = EN_RF_REQ;
			break;

		    case PW_RESOURCE_FREE_RESP:
			ev->a.proxy = EN_RF_RESP;
			break;

		    case PW_RESOURCE_QUERY_REQ:
			ev->a.proxy = EN_RQ_REQ;
			break;

		    case PW_RESOURCE_QUERY_RESP:
			ev->a.proxy = EN_RQ_RESP;
			break;

		    case PW_NAS_REB_REQ:
			ev->a.proxy = EN_NAS_REB_REQ;
			break;
#endif	/* USR_CCA */

#ifdef ASCEND
		    case PW_PASSWORD_REQUEST:
			ev->a.proxy = EN_NEW_PASSWD;
			break;

		    case PW_ASCEND_RADIPA_ALLOCATE:
			ev->a.proxy = EN_IP_ALLOC;
			break;

		    case PW_ASCEND_RADIPA_RELEASE:
			ev->a.proxy = EN_IP_RELEASE;
			break;

		    case PW_TERMINATE_SESSION:
			ev->a.proxy = EN_TERM_SESSION;
			break;

		    case PW_ASCEND_EVENT_REQUEST:
			ev->a.proxy = EN_EVENT_REQUEST;
			break;
#endif	/* ASCEND */

		    default: /* Don't know what this is! */
			logit (LOG_DAEMON, LOG_ALERT,
				"%s: FATAL, unknown code from [%s], %d", func,
				ip_hostname (authreq->ipaddr), authreq->code);
			ev->a.proxy = EN_FATAL;
			ev->value = EV_FATAL;
			break;

		} /* end of switch */
	} /* end of if */

	return authreq;
} /* end of rad_recv () */

/*************************************************************************
 *
 *	Function: rad_reply
 *
 *	Purpose: Generates and sends reply back to client based on
 *		 result code.  A reply is not sent to client if a
 *		 timeout occurred on our request to a remote server.
 *
 *************************************************************************/

static int
rad_reply (authreq, value, af_param)

AUTH_REQ       *authreq;
int             value;
char           *af_param;

{
	int             code;
	int             i;
	int             hold_time;
	int             msglen;
	int             result = 0;
	int             sockfd;
	time_t          now;
	VALUE_PAIR     *vp;
	VALUE_PAIR     *save_cur = NULL_VP;
	VALUE_PAIR     *protpair;
	VALUE_PAIR     *check_item;
	char	       *secret;
	char           *get;
	char           *put;
	char            failed_message[AUTH_STRING2_LEN];
	char            log_msg[1024]; /* Should be too big, but might not be */
	char            log_guard[256];	/* Room for overflow, if needed. */

#ifdef USR_CCA
	UINT4           framed_ip = 0;
	UINT4           nas_ip = 0;
	UINT4           nas_port = 0;
	AUTH_ENTRY     *auth_ent;
	FILE_LIST      *file_ent;
	char           *name = (char *) NULL;
	struct in_addr  addr;
#endif	/* USR_CCA */

	static char    *func = "rad_reply";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq == (AUTH_REQ *) NULL)
	{
		return EV_NAK;
	}

	if (authreq->repstatus == -2)
	{
		authreq->repstatus = authreq->fsmstatus;
	}

	/* Prevent EV_RETRY_LIMIT from occuring once a REPLY has occured */
	authreq->retry_limit = 0;
	authreq->seqch_limit = 0;

	free_event_list (authreq);	/* free up any remaining events */
	authreq->event_q = (EVENT_ENT *) NULL;

	secret = authreq->client->secret;
	if (authreq->code == PW_STATUS_SERVER)
	{
		secret = dummy_status_server_client.secret;
	}

#ifdef USR_CCA
	if (authreq->code != PW_RESOURCE_QUERY_REQ)
	{
		authreq->timer = 0;
	}
#else	/* USR_CCA */
	authreq->timer = 0;
#endif	/* USR_CCA */

	/* Produce standard formatted message */
	sockfd = rad_server_aatv->sockfd;
	if (authreq->code == PW_ACCESS_REQUEST)
	{
		result = protocol_check (authreq, &protpair);
	}
	else
	{
		result = authreq->repstatus;
		protpair = NULL_VP;
		if (authreq->code == PW_ACCOUNTING_REQUEST)
		{
			sockfd = rad_acct_aatv->sockfd;
		}
	}

	code = ev2code (authreq, result);

	if ((result == EV_ACK) ||
		((authreq->code == PW_ACCOUNTING_REQUEST) && (code != -1)))
	{
		/* It's a go! */
		if ((authreq->realm_filter && authreq->realm_filter[0]) &&
			(authreq->code == PW_ACCESS_REQUEST))
		{
			/* A filter was specified in the authfile. */
			if ((check_item = get_last_vp (authreq->cur_request,
						      PW_FILTER_ID)) == NULL_VP)
			{
				/* Generate filter value-pair */
				avpair_add (&authreq->cur_request, PW_FILTER_ID,
						 authreq->realm_filter, -1);
			}
			else
			{
				avpair_string_mod (check_item,
						   authreq->realm_filter, -1);
			}
		}

#ifdef USR_CCA
		if (authreq->code == PW_ACCESS_REQUEST ||
			authreq->code == PW_ACCESS_ACCEPT)
		{
			if ((vp = get_vp_vend (authreq->cur_request,
					  PW_USER_REALM, VC_MERIT)) == NULL_VP)
			{ /* Generate the User Realm by calling parse_realm() */
				if ((vp = parse_realm (authreq)) == NULL_VP)
				{
					addr.s_addr = authreq->ipaddr;
					logit (LOG_DAEMON, LOG_ERR,
				 "%s: Problem parsing user for request from %s",
						func, inet_ntoa (addr));
					result = EV_NAK;
				}
			}

			if (result != EV_NAK)
			{
				file_ent =
				      find_file_ent (authreq->client->file_pfx);

				for (auth_ent = file_ent->auth_list;
					auth_ent != (AUTH_ENTRY *) NULL;
					auth_ent = auth_ent->next)
				{
					if (strcmp (auth_ent->name,
							vp->strvalue) == 0)
					{
						break;
					}
				}

				if (auth_ent != (AUTH_ENTRY *) NULL &&
					(auth_ent->type == AA_RAD ||
					auth_ent->type == AA_LOCAL_VPN))
				{
					if (add_dns_nbns (authreq,
							auth_ent) != 0)
					{
						addr.s_addr = authreq->ipaddr;
						logit (LOG_DAEMON, LOG_ERR,
		  "%s: Problem adding DNS/NBNS information for request from %s",
							func, inet_ntoa (addr));
						result = EV_NAK;
					}
				}

				if (result != EV_NAK &&
					auth_ent != (AUTH_ENTRY *) NULL &&
					(auth_ent->type == AA_RAD ||
					 auth_ent->type == AA_LOCAL_VPN))
				{
					if (add_vpn_info (authreq,
								auth_ent) == 0)
					{
						addr.s_addr = authreq->ipaddr;
						logit (LOG_DAEMON, LOG_ERR,
		       "%s: Problem adding VPN information for request from %s",
							func, inet_ntoa (addr));
						result = EV_NAK;
					}
				}
			}
		}
#endif	/* USR_CCA */

		/*
		 *	Get the packet logging information now,
		 *	before the call to prune_pairs().
		 */
		packet_log (log_msg, authreq, 0);

#ifdef USR_CCA
		if (((authreq->client->client_type & CE_NAS) == CE_NAS) &&
			(code != -1) &&
			(authreq->code != PW_RESOURCE_QUERY_RESP) &&
			(authreq->code != PW_RESOURCE_QUERY_REQ))
#else	/* USR_CCA */
		if (((authreq->client->client_type & CE_NAS) == CE_NAS) &&
			(code != -1))
#endif	/* USR_CCA */

		{ /* was NAS */

/* #ifdef USR_CCA
			if ((result == EV_NAK) &&
				((vp = get_vp (authreq->cur_request,
					 PW_TERMINATION_ACTION)) != NULL_VP) &&
				(vp->lvalue == PW_MANAGE_RESOURCES))
			{
				if ((vp = get_vp (authreq->cur_request,
						  PW_USER_NAME)) != NULL_VP)
				{
					name = vp->strvalue;
				}

				if ((vp = get_vp (authreq->cur_request,
					     PW_FRAMED_IP_ADDRESS)) != NULL_VP)
				{
					framed_ip = vp->lvalue;
				}

				if ((vp = get_vp (authreq->cur_request,
						PW_NAS_IP_ADDRESS)) != NULL_VP)
				{
					nas_ip = vp->lvalue;
				}

				if ((vp = get_vp (authreq->cur_request,
						  PW_NAS_PORT)) != NULL_VP)
				{
					nas_port = vp->lvalue;
				}

				free_resources (name, framed_ip, nas_ip,
						nas_port);
				avpair_del (&authreq->cur_request,
						PW_FRAMED_IP_ADDRESS, 0);
			}
*/
/* #endif * USR_CCA */

			save_cur = authreq->cur_request;
			authreq->cur_request = NULL_VP;
			list_copy (&authreq->cur_request, save_cur);
			prune_pairs (authreq, result);
		} /* end of else it was a NAS... */

		/* Check for dropped responses. */
		if (code != -1)
		{
			send_reply (code, log_msg, result, authreq, sockfd);
		}

		if (save_cur != NULL_VP)
		{
			list_free (authreq->cur_request);
			authreq->cur_request = save_cur;
		}
	}
	else	/* was not EV_ACK */
	{
		if (code != -1) /* was failure, challenge, expired or error */
		{
			packet_log (log_msg, authreq, 0);

			/* On failure log protocol from original user request */
			protpair = get_vp (authreq->cur_request,
							PW_FRAMED_PROTOCOL);

			/*
			 *	A postive result indicates a password failure
			 *	which may be due to a lost packet.  The client
			 *	should retry -- don't issue a reject yet.
			 */
			if (result == EV_NAK ||
				result == EV_ACC_CHAL ||
				result == EV_PW_EXPIRED)
			{
				if ((authreq->client->client_type & CE_NAS)
								== CE_NAS)
				{ /* was NAS */

#if 0
/* #ifdef USR_CCA
			if ((authreq->code == PW_ACCESS_REQUEST) &&
				((vp = get_vp (authreq->cur_request,
					PW_TERMINATION_ACTION)) != NULL_VP) &&
				(vp->lvalue == PW_MANAGE_RESOURCES))
			{

				if ((vp = get_vp (authreq->cur_request,
						PW_USER_NAME)) != NULL_VP)
				{
					name = vp->strvalue;
				}

				if ((vp = get_vp (authreq->cur_request,
					     PW_FRAMED_IP_ADDRESS)) != NULL_VP)
				{
					framed_ip = vp->lvalue;
				}

				if ((vp = get_vp (authreq->cur_request,
						PW_NAS_IP_ADDRESS)) != NULL_VP)
				{
					nas_ip = vp->lvalue;
				}

				if ((vp = get_vp (authreq->cur_request,
						  PW_NAS_PORT)) != NULL_VP)
				{
					nas_port = vp->lvalue;
				}

				free_resources (name, framed_ip, nas_ip,
						nas_port);
				avpair_del (&authreq->cur_request,
						PW_FRAMED_IP_ADDRESS, 0);
			}
*/
/* #endif * USR_CCA */
#endif	/* 0 */

					/* was NAS */
					save_cur = authreq->cur_request;
					authreq->cur_request = NULL_VP;
					list_copy (&authreq->cur_request,
							save_cur);
					prune_pairs (authreq, result);
				}

				send_reply (code, log_msg, result,
							authreq, sockfd);

				if (save_cur != NULL_VP)
				{
					list_free (authreq->cur_request);
					authreq->cur_request = save_cur;
				}
			}
		}
		else	/* was dropped */
		{
			packet_log (log_msg, authreq, 0);
		}
	}

	if (result > EV_ERROR)
	{
		result = 3;
	}
	else
	{
		result++;
	}

	switch (authreq->code)
	{
	    case PW_ACCESS_REQUEST:
	    case PW_ACCOUNTING_REQUEST:
	    case PW_PASSWORD_REQUEST:

#ifdef USR_CCA
	    case PW_RESOURCE_FREE_REQ:
	    case PW_RESOURCE_QUERY_REQ:
	    case PW_NAS_REB_REQ:
#endif	/* USR_CCA */

		put = log_msg + strlen (log_msg);

		if (result == 0) /* indicates failure, now */
		{
			strcpy (failed_message, "FAILED ");

			if (code == -1)
			{
				strcat (failed_message, "(DROPPED) ");
			}

			msglen = strlen (failed_message);
			put = failed_message + msglen;

			for (vp = authreq->cur_request;
				(vp != NULL_VP) &&
					(msglen < sizeof (failed_message));
				vp = vp->next)
			{
				if (vp->attribute == PW_REPLY_MESSAGE &&
					vp->ap->vendor_id == 0)
				{
					for (get = vp->strvalue; *get; get++)
					{
						if (put == failed_message)
						{
							*put++ = ' ';
							msglen++;
						}

						/* Make ctrl chars printable. */
						if (*get < ' ')
						{
							*put++ = '^';
							*put++ = *get + 'A' - 1;
							msglen += 2;
						}
						else
						{
							*put++ = *get;
							msglen++;
						}

						/*
						 *	Check buffer size limit
						 */
						i = sizeof (failed_message);
						if (msglen >= i)
						{
							put =
						       &(failed_message[i - 1]);
							*put = '\0';
							break;
						}
					}
				}
			} /* end of for (each attribute) */

			*put = '\0';  /* Terminate the string. */
		}
		else	/* was not failure */
		{
			failed_message[0] = '\0';
			strcpy (failed_message, "OK");

			if (code == -1)
			{
				strcat (failed_message, " (DROPPED)");
			}
		}

		now = time (0);

		/* Determine how long this request took. */
		if (now > authreq->onqueue)
		{
			hold_time = now - authreq->onqueue;
		}
		else
		{
			hold_time = 0;
		}

		switch (authreq->code)
		{
		    case PW_ACCESS_REQUEST:
		    case PW_ACCOUNTING_REQUEST:
			/*
			 *	Track the last CLEANUP_BUCKETS times
			 *	for  authentication and accounting only.
			 */
			rad_reply_times[rad_reply_pos++] = hold_time;
			if (rad_reply_pos >= CLEANUP_BUCKETS)
			{
				rad_reply_pos = 0;
			}
			break;

		    default:
			/* Ignore any requests we don't understand. */
			break;
		} /* end of switch */

		/* Not an error, but a way to log it */
		if (!TAR_NO_LOG(authreq) || (debug_flag > 0))
		{
			logit (LOG_DAEMON, LOG_INFO,

#ifdef MERIT_HUNTGROUP
				"%s - %s -- total %u, holding %u, hg %u",
#else	/* MERIT_HUNTGROUP */
				"%s - %s -- total %u, holding %u",
#endif	/* MERIT_HUNTGROUP */

				log_msg, failed_message,
				now - authreq->onqueue,

#ifdef MERIT_HUNTGROUP
				authreq->starthg - authreq->onqueue,
				authreq->startlas - authreq->starthg);
#else	/* MERIT_HUNTGROUP */
				authreq->startlas - authreq->onqueue);
#endif	/* MERIT_HUNTGROUP */

		}
	} /* end of switch */

	/* The actual TTL must hold some non-zero timeout value. */

#ifdef USR_CCA
	if ((authreq->code != PW_RESOURCE_QUERY_REQ) &&
		(authreq->ttlslice > 0))
#else
	if (authreq->ttlslice > 0)
#endif	/* USR_CCA */

	{
		authreq->ttl = authreq_holdtime (authreq);
		authreq->ttlslice = 0;
	}

	/* Measure the traffic we put on the network when sending a reply. */
	stat_replied.packets++;
	stat_replied.octets += last_send_len;	/* Just UDP payload. */

	SAR_NO_LOG(authreq);	/* no logging of duplicates in hold state */
	last_send_len = 0;	/* forces redo_action() to use act_func() */

	return EV_WAIT;
} /* end of rad_reply () */

/*************************************************************************
 *
 *	Function: rad_reply_init
 *
 *	Purpose: Perform RADIUS Reply initialization.
 *		 Initialize the rad_reply_times[] array.
 *
 *************************************************************************/

static void
rad_reply_init (aatv)

AATV   *aatv;

{
	u_short         i;
	static char    *func = "rad_reply_init";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	for (i = 0; i < CLEANUP_BUCKETS; i++)
	{
		rad_reply_times[i] = 1;	/* Initialize it to SOMETHING */
	}
	rad_reply_pos = 0;		/* Restart this too. */

	aatv->sockfd = rad_server_aatv->sockfd;

	return;
} /* end of rad_reply_init () */

/*************************************************************************
 *
 *	Function: radius_send
 *
 *	Purpose: Send a RADIUS request packet to a remote RADIUS server.
 *
 *	Returns: length of packet sent, if successful,
 *		 -1, if error detected.
 *
 *************************************************************************/

int
radius_send (cmd, code, flags, dns_name, authreq, socket)

char           *cmd;
u_int           code;
u_int           flags;
char           *dns_name;
AUTH_REQ       *authreq;
int             socket;

{
	u_short            svc_port;
	int                errors = 0;	/* Count errors. */
	int                i;
	int                ret;		/* Return value from avpair_out() */
	int                total_length;
	UINT4              remote_ipaddr;
	AUTH_HDR          *auth;
	CLIENT_ENTRY      *ce;
	VALUE_PAIR        *vp;
	VALUE_PAIR        *pw_vp;
	char              *put;
	char              *secret;
	char              *vec_ptr;
	char              *vector;
	char               buffer[16];
	char               passwd[AUTH_PASS_LEN + 1];
	char               log_more[128];
	char               log_msg[1024];
	char               log_guard[256];
	static char       *func = "radius_send";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/*
	 *	Don't forward Status-Server messages,
	 *	if they don't come from a known client.
	 */
	if (authreq->code == PW_STATUS_SERVER)
	{
		if (find_client (authreq->ipaddr, &ce) != 0)
		{
			logit (LOG_DAEMON, LOG_INFO,
				"%s: Relaying of Status-Server rejected", func);
			return (-1);
		}
		secret = dummy_status_server_client.secret;
	}
	else
	{
		secret = authreq->client->secret;
	}

	/* Find remote RADIUS server in the database */
	if (find_client_by_name (dns_name, &remote_ipaddr, &ce) != 0)
	{
		logit (LOG_DAEMON, LOG_ERR,
			"%s: server '%s' not in %s/%s",
			func, dns_name, radius_dir, RADIUS_CLIENTS);

		if (authreq->code == PW_ACCESS_REQUEST)
		{
			reply_sprintf (0, authreq,
	    "Authentication failed, remote server not found, try again later.");
		}

		return (-1);
	}

	/* Determine the correct secret to use for relaying. */
	if (authreq->code == PW_STATUS_SERVER)
	{
		secret = dummy_status_server_client.secret;
	}
	else
	{
		secret = ce->secret;
	}

	/* See if relaying this request might start a looping situation */
	if ((debug_flag <= 0) &&
	    (authreq->ipaddr == remote_ipaddr)) /* then why ask your asker? */
	{
		logit (LOG_DAEMON, LOG_ERR,
		   "%s: remote server '%s (%s)' matches requestor's address %s",
			 func, dns_name, ip_hostname (remote_ipaddr),
			 ip_hostname (authreq->ipaddr));

		/* Tell the user why this was rejected. */
		if (authreq->code == PW_ACCESS_REQUEST)
		{
			reply_sprintf (0, authreq,
	       "Authentication requests cannot be forwarded to the originator");
		}

		return (-1);
	}

#if defined(MERIT_HUNTGROUP) || defined(MERIT_LAS) || defined(MERIT_ORGANIZATION)
	if ((cmd != (char *) NULL) && (*cmd != '\0'))
	{
		/*
		 *	When relaying a request to a remote server, attach
		 *	the "cmd" (usually the action name from the FSM table)
		 *	as the first attribute of type Proxy-Action.
		 */

		if ((vp = avpair_add_vend (NULL, PW_PROXY_ACTION,
						cmd, -1, VC_MERIT)) == NULL_VP)
		{
			logit (LOG_DAEMON, LOG_ALERT,
			    "%s: avpair_add_vend(PW_PROXY_ACTION, %s) failure",
				func, cmd);
			abort ();
		}
		vp->next = authreq->cur_request;
		authreq->cur_request = vp;  /* place at start of cur_request */
		strcpy (last_send_action, cmd); /* cmd name for reply match */
	}
	else	/* No command */
	{
		last_send_action[0] = '\0';
	}
#else
	last_send_action[0] = '\0';
#endif	/* MERIT_HUNTGROUP */

	/*
	 *	Add the PW_PROXY_STATE attribute-value pair on the end
	 *	of the request as the last attribute in the packet.
	 *	This allows the receiver to add reply items after the
	 *	state, thereby delimiting the request from the reply.
	 *	Also, the state is needed upon receipt to help match
	 *	up incoming replies with existing request structures.
	 */

	sprintf (buffer, "%d", authreq->state); /* YYY: add IP address */
	if ((vp = avpair_add (&authreq->cur_request, PW_PROXY_STATE,
				buffer, -1)) == NULL_VP)
	{
		logit (LOG_DAEMON, LOG_ALERT,
			"%s: FATAL avpair_add(PW_PROXY_STATE, %s) failure",
			func, buffer);
		abort ();
	}

	/*
	 *	Get the UDP port to use to send RADIUS packets to a
	 *	remote RADIUS host.
	 */

	if (code == PW_ACCOUNTING_REQUEST)
	{
		svc_port = acct_fwd_port;

		if (ce->acct_port != 0)
		{
			svc_port = ce->acct_port;
		}
	}
	else /* was Access-Request */
	{
		svc_port = auth_fwd_port;

		if (ce->auth_port != 0)
		{
			svc_port = ce->auth_port;
		}
	}

	/* Start to build the RADIUS protocol packet. */
	authreq->vers_out = ce->version;
	auth = (AUTH_HDR *) send_buffer;

	/* Preserve the CHAP authenticator for older servers. */
	vector = (char *) NULL;
	if (((ce->client_type & CE_OLDCHAP) == CE_OLDCHAP) &&
	    (vp = get_vp (authreq->cur_request, PW_CHAP_CHALLENGE)) != NULL_VP)
	{
		vector = vp->strvalue;
	}

	vec_ptr = build_header (ce->version | (flags & ~AUTH_HDR_VERSION_BITS),
				vector, code, authreq->fwd_id, auth, ce);

	dprintf(1, (LOG_DAEMON, LOG_DEBUG,
		"Relaying %s request with id %d (now %d) from %lx (%s) to %s",
		authtype_toa (authreq->code), authreq->rep_id, authreq->fwd_id,
		authreq->ipaddr, ip_hostname (authreq->ipaddr), dns_name));

	if (get_vp (authreq->cur_request, PW_USER_PASSWORD) == NULL_VP)
	{
		if ((pw_vp = get_vp (authreq->request, PW_USER_PASSWORD))
								!= NULL_VP)
		{
			if (avpair_add (&authreq->cur_request, PW_USER_PASSWORD,
					pw_vp->strvalue, pw_vp->lvalue)
								== NULL_VP)
			{
				logit (LOG_DAEMON, LOG_ERR,
					"%s: cannot add user password", func);
				return (-1);
			}
		}
	}

	/*
	 *	Decrypt password, if it's there - pass along CHAP too.
	 *	If PASSWORD v/p is present, get_passwd() will decrypt it in
	 *	passwd.  CHAP just can be passed along since we have copied
	 *	the vector from the request which is the CHAP challenge.
	 */

	memset ((char *) passwd, 0, sizeof (passwd));
	get_passwd (authreq, passwd, (char *) NULL, (char *) NULL);

	/* Load up the configuration values for the user */
	for (vp = authreq->cur_request;
		vp != NULL_VP;
		vp = vp->next)
	{
		/* Password requires special handling */
		if ((vp->attribute == PW_USER_PASSWORD) &&
		    	(vp->ap->vendor_id == VC_RADIUS))
		{
			/*
			 *	Re-encrypt the password using the
			 *	secret shared by us and the remote
			 *	RADIUS system.  The variable "passwd"
			 *	contains an already decrypted password.
			 */

			if (authreq->fsm_aatv == rad_authen_aatv)
			{
				attribute_pw_out (auth, send_buffer_size,
						  passwd, secret);
			}
			continue;
		}

		if ((ret = avpair_out (vp, auth, send_buffer_size,
					ce->veps)) <= 0)
		{
			logit (LOG_DAEMON, LOG_ERR,
			     "%s: avpair_out (%s(%d), ..., %u, %s) returns %d",
				func, vp->ap->name, vp->attribute,
				send_buffer_size,
				vendor_list_toa (ce->veps), ret);
			errors++;

			/* Overflow check. */
			if (ret == -2)
			{
				logit (LOG_DAEMON, LOG_ERR,
				  "%s: Packet not sent - send_buffer overflow",
					func);
				return (ret);
			}
		}
	}

	memset (passwd, 0, sizeof (passwd));  /* Don't keep password around */
	total_length = build_request_mic (auth, secret);

	if ((cmd != (char *) NULL) && (*cmd != '\0')) /* Remove Proxy-Action. */
	{
		vp = authreq->cur_request; /* Get pointer to start of list. */
		authreq->cur_request = vp->next; /* Skip over Proxy-Action. */
		avpair_free (vp);	/* Proxy-Action attribute is history. */
	}

	/* Use side-effect of get_state() to remove just added Proxy-State. */
	(void) get_state (&authreq->cur_request);

	/*
	 *	If V1, we need to save the vector for matching reply.
	 *	For V1 accounting request, we end up saving the MD5 digest.
	 */
	if (authreq->vers_out == 1)
	{
		memcpy ((char *) authreq->fwdvec, vec_ptr, AUTH_VECTOR_LEN);
	}

	memset ((char *) &last_send_sin, '\0', sizeof (last_send_sin));
	last_send_sin.sin_family = AF_INET;
	last_send_sin.sin_addr.s_addr = htonl(remote_ipaddr);
	last_send_sin.sin_port = htons(svc_port);

	last_send_len = total_length;

	/* Measure what we transmit elsewhere */
	stat_transmitted.packets++;
	stat_transmitted.octets += last_send_len;	/* Just UDP payload. */

	/* Packet level debugging */
	if ((debug_flag > 2) ||
		((debug_flag > 0) &&
		(ce != (CLIENT_ENTRY *) NULL) &&
		((ce->client_type & CE_DEBUG) != 0)))
	{
		dumpit (LOG_DAEMON, LOG_DEBUG, (u_char *) auth,	total_length, 0,
			"%s: relaying packet from [%s] type=%s to %s:%d",
			func, ip_hostname (authreq->ipaddr),
			authtype_toa (authreq->code), ce ? ce->hostname : "??",
			ntohs(last_send_sin.sin_port));
	}

	if (log_forwarding != 0)
	{
		packet_log (log_msg, authreq, log_forwarding_sws);
		log_more[0] = '\0';

		if ((log_forwarding_sws & LFS_FWD_DIGEST) != 0)
		{
			strcpy (log_more, " digest ");
			put = log_more;

			for (i = 0; i < AUTH_VECTOR_LEN; i ++)
			{
				put += strlen (put);
				sprintf (put, "%2.2X",auth->vector[i]);
			}
		}

		if ((cmd != (char *) NULL) && (*cmd != '\0'))
		{
			logit (LOG_DAEMON, LOG_INFO,
				"Sending-%s-%s to %s[%s]:%u%s",
				cmd, log_msg, ce ? ce->hostname : "??",
				ip_hostname (remote_ipaddr), svc_port,
				log_more);
		}
		else
		{
			logit (LOG_DAEMON, LOG_INFO,
				"Sending-%s to %s[%s]:%u%s",
				log_msg, ce ? ce->hostname : "??",
				ip_hostname (remote_ipaddr), svc_port,
				log_more);
		}

		if ((log_forwarding != 0) && (log_forwarding_sws & LFS_DUMP))
		{
			dumpit (LOG_DAEMON, LOG_DEBUG, (u_char *) auth,
				total_length, 0,
			      "%s: relaying packet from [%s] type=%s to %s:%d",
				func, ip_hostname (authreq->ipaddr),
				authtype_toa (authreq->code),
				ce->hostname, ntohs(last_send_sin.sin_port));
		}
	}

	return sendto (socket, (char *) auth, total_length, (int) 0,
		(struct sockaddr *) & last_send_sin, sizeof (last_send_sin));
} /* end of radius_send () */

/*************************************************************************
 *
 *	Function: read_sysconf
 *
 *	Purpose: Read a configuration file and modify daemon characteristics.
 *
 *	Remarks: It reads a configuration file formatted as follows:
 *
 *	<variable>=<value>
 *
 *	where the following <variables> may have the following <values>:
 *
 *	<variable>			<value description>
 *
 *	aatv.direct			<aatvid>
 *	aatv.forking			<aatvid>
 *	aatv.forkreply			<aatvid>
 *	aatv.proc_max			<aatvid> <positive integer>
 *	aatv.socket			<aatvid>
 *	default_reply_holdtime		<positive integer>
 *	default_retry_limit		<positive integer>
 *	default_seqch_limit		<positive integer>
 *	dns_address_aging		<positive integer>
 *	dns_address_window		<positive integer>
 *	global_acct_q.limit		<positive integer>
 *	global_acct_q.hold		<non-negative integer>
 *	global_auth_q.limit		<positive integer>
 *	global_auth_q.hold		<non-negative integer>
 *	list_copy_limit			<positive integer>
 *	log_forwarding			on | off | {+|-}vector | {+|-}digest
 *						{+|-}dump clear
 *	log_generated_request		on | off
 *	packet_log			{+|-}abort {+|-}both {+|-}current
 *						{+|-}original none default
 *	radius_log_fmt			<string>
 *	reply_check			[all|first]{+|-}abort {+|-}ignore
 *						{+|-}verbose {+|-}dump
 *						clear [none|<attribute>]
 *	send_buffer_size		<positive integer>
 *
 *************************************************************************/

static void
read_sysconf ()

{
	u_char          type;
	int             found;
	int             len;
	int             lnum = 0;
	int             num;
	int             was;
	int             valcount = 0;
	char           *new;
	char           *slash;
	char           *value;
	char           *verb;
	AATV           *cfg_aatv;
	DICT_ATTR_LIST *was_dal;
	FILE           *conf;
	char            buffer[256];		/* Input lines are this long. */
	char            confpath[MAXPATHLEN];

	static char    *aatv_types[] =
			{
				"direct",
				"socket",
				"forking",
				"forkreply"
			};

	static SWITCH_TABLE log_forwarding_table[] =
			{
				{ "vector",	LFS_FWD_VECTOR	},
				{ "digest",	LFS_FWD_DIGEST	},
				{ "dump",	LFS_DUMP	},
				{ NULL,		-1		}
			};

	static SWITCH_TABLE packet_log_table[] =
			{
				{ "abort",	PL_SWS_ABORT	},
				{ "both",	PL_SWS_COMP	},
				{ "comp",	PL_SWS_COMP	},
				{ "current",	PL_SWS_CUR	},
				{ "cur",	PL_SWS_CUR	},
				{ "original",	PL_SWS_ORIG	},
				{ "orig",	PL_SWS_ORIG	},
				{ NULL,		-1		}
			};

	static SWITCH_TABLE rad_reply_table[] =
			{
				{ "abort",	RRS_ABORT	},
				{ "ignore",	RRS_IGNORE	},
				{ "verbose",	RRS_VERBOSE	},
				{ "drop",	RRS_DROP	},
				{ "nak",	RRS_NAK		},
				{ "dump",	RRS_DUMP	},
				{ NULL,		-1		}
			};

	static SWITCH_TABLE radcheck_table[] =
			{
				{ "queues",	RADCHECK_QSTATS	},
				{ "packets",	RADCHECK_PSTATS	},
				{ NULL,		-1		}
			};

	static char    *func = "read_sysconf";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	radius_dbfile (confpath, "engine.config");

	if ((conf = fopen (confpath, "r")) != (FILE *) NULL)
	{
		lnum = 0;
		while (fgets (buffer, sizeof (buffer) - 1, conf) != NULL)
		{
			lnum++;

			if (buffer[0] == '#')
			{
				continue;
			}

			for (verb = buffer; *verb && isspace(*verb); verb++)
			{
				;	/* Skip over blanks */
			}

			/* Remove newline at end, if any. */
			len = strlen (verb);

			if ((len > 0) && (verb[len - 1] == '\n'))
			{
				verb[len - 1] = '\0';
			}

			/* Ignore empty lines. */
			if (!*verb)
			{
				continue;
			}

			/* remove trailing blanks */
			for (len = strlen (verb);
				(len > 0) && isspace(verb[len - 1]);
				len--)
			{
				verb[len - 1] = '\0';
			}

			/* Find '<verb>=<value>' */
			verb = strtok (verb, "=");

			if (!verb)
			{
				logit (LOG_DAEMON, LOG_ERR,
			     "%s: Invalid text '%s' line %d of '%s' (ignored)",
					func, buffer, lnum, confpath);
				continue;
			}

			/* remove trailing blanks */
			for (len = strlen (verb);
				(len > 0) && isspace(verb[len - 1]);
				len--)
			{
				verb[len - 1] = '\0';
			}

			/* Check for hostname prefixing */
			if ((slash = strchr (verb, '/')) != NULL)
			{
				new = verb;
				verb = slash + 1;
				*slash = '\0';
				slash = new;
				found = 0;

				for (slash = strchr (slash, ',');
					slash != NULL;
					slash = strchr (slash, ','))
				{
					*slash = '\0';
					slash++;

					if (strcasecmp (new, ourhostname) == 0)
					{
						found = 1;
						break;
					}
					new = slash;
				}

				if ((found == 0) && (*new))
				{
					if (strcasecmp (new, ourhostname) == 0)
					{
						found = 1;
					}
				}

				/* Was our name found in the list? */
				if (found == 0)
				{
					continue;
				}
			}

			value = strtok (NULL, "\xff");

			if (value)
			{
				for ( ; *value && isspace(*value); value++)
				{
					;	/* Skip over blanks. */
				}
			}
			else
			{
				value = "";
			}

			/* Remove trailing blanks. */
			for (len = strlen (value);
				(len > 0) && isspace(value[len - 1]);
				len--)
			{
				value[len - 1] = '\0';
			}

			if (strcasecmp (verb, "default_retry_limit") == 0)
			{
				if (!*value)
				{
					num = 0;
				}
				else
				{
					num = atoi (value);
					num = num < 0 ? 0 : num;

				}

				if (num != default_retry_limit)
				{
					logit (LOG_DAEMON, LOG_INFO,
					"%s: default_retry_limit was %d now %d",
						func, default_retry_limit, num);
				}

				default_retry_limit = num;
				valcount++;
			}

			/*
			 * default_seqch_limit <integer>
			 */
			else if (strcasecmp (verb, "default_seqch_limit") == 0)
			{
				if (!*value)
				{
					num = 0;
				}
				else
				{
					num = atoi (value);
					num = num < 0 ? 0 : num;
				}

				if (num != default_seqch_limit)
				{
					logit (LOG_DAEMON, LOG_INFO,
					"%s: default_seqch_limit was %d now %d",
						func, default_seqch_limit, num);
				}

				default_seqch_limit = num;
				valcount++;
			}
			else if (strcasecmp (verb, "dns_address_aging") == 0)
			{
				if (!*value)
				{
					num = 0;
				}
				else
				{
					num = atoi (value);
					num = num <= 0 ? ADDRESS_AGING : num;
				}

				if (num != dns_address_aging)
				{
					logit (LOG_DAEMON, LOG_INFO,
					 "%s: dns_address_aging was %d now %d",
						func, dns_address_aging, num);
				}

				dns_address_aging = num;
				valcount++;
			}

			/*
			 * dns_address_window <integer>
			 */
			else if (strcasecmp (verb, "dns_address_window") == 0)
			{
				if (!*value)
				{
					num = 0;
				}
				else
				{
					num = atoi (value);
					num = num <= 0 ? 60 : num;
				}

				if (num != dns_address_window)
				{
					logit (LOG_DAEMON, LOG_INFO,
					"%s: dns_address_window was %d now %d",
						func, dns_address_window, num);
				}

				dns_address_window = num;
				valcount++;
			}

			/*
			 * list_copy_limit <integer>
			 */
			else if (strcasecmp (verb, "list_copy_limit") == 0)
			{
				if (!*value)
				{
					num = LIST_COPY_LIMIT;
				}
				else
				{
					num = atoi (value);
					num = num < 0 ? LIST_COPY_LIMIT : num;
				}

				if (num != list_copy_limit)
				{
					logit (LOG_DAEMON, LOG_INFO,
					    "%s: list_copy_limit was %d now %d",
						func, list_copy_limit, num);
				}

				list_copy_limit = num;
				valcount++;
			}

			/*
			 * send_buffer_size <integer>
			 */
			else if (strcasecmp (verb, "send_buffer_size") == 0)
			{
				if (!*value)
				{
					num = RAD_SEND_BUFFER_SIZE;
				}
				else
				{
					num = atoi (value);
					num = MAX(0, num);
					num = MIN(num, RAD_SEND_BUFFER_SIZE);
					if (num == 0)
					{
						num = RAD_SEND_BUFFER_SIZE;
					}
				}

				if (num != send_buffer_size)
				{
					logit (LOG_DAEMON, LOG_INFO,
					  "%s: send_buffer_size was %d now %d",
						func, send_buffer_size, num);
				}

				send_buffer_size = num;
				valcount++;
			}

			/*
			 * default_reply_holdtime <integer>
			 */
			else if (strcasecmp (verb,
						"default_reply_holdtime") == 0)
			{
				if (!*value)
				{
					num = 0;
				}
				else
				{
					num = atoi (value);
					num = MAX(0, num);
					num = MIN(num, 255);
				}

				if (num != default_reply_holdtime)
				{
					logit (LOG_DAEMON, LOG_INFO,
				    "%s: default_reply_holdtime was %d now %d",
						func, default_reply_holdtime,
						num);
				}

				default_reply_holdtime = num;
				valcount++;
			}

			/*
			 * radius_log_fmt <string>
			 */
			else if (strcasecmp (verb, "radius_log_fmt") == 0)
			{
				if (!*value)
				{
					radius_log_fmt = RADIUS_LOG_FMT;
				}
				else if (strcmp (radius_log_fmt, value) != 0)
				{
					if ((new = rad_strdup (value)) != NULL)
					{
						radius_log_fmt = new;
					}
				}
				valcount++;
			}

			/*
			 * log_generated_request [on|off]
			 */
			else if (strcasecmp (verb,
						"log_generated_request") == 0)
			{
				if (!*value)
				{
					num = 1;
				}
				else
				{
					if (strcasecmp (value, "off") == 0)
					{
						num = 0;
					}
					else if (strcasecmp (value, "on") == 0)
					{
						num = 1;
					}
					else
					{
						logit (LOG_DAEMON, LOG_INFO,
				       "%s: log_generated_request defaults ON",
							func);
					}
				}

				if (num != log_generated_request)
				{
					logit (LOG_DAEMON, LOG_INFO,
				     "%s: log_generated_request was %s now %s",
						func,
						log_generated_request == 0
							? "off" : "on", num == 0
								? "off" : "on");
				}

				log_generated_request = num;
				valcount++;
			}

			/*
			 * log_forwarding [on|off]
			 */
			else if (strcasecmp (verb, "log_forwarding") == 0)
			{
				was = log_forwarding;
				num = log_forwarding_sws;

				if (!*value)
				{
					log_forwarding = 1;
				}
				else
				{
					if (strcasecmp (value, "off") == 0)
					{
						log_forwarding = 0;
					}
					else if (strcasecmp (value, "on") == 0)
					{
						log_forwarding = 1;
					}
					else if (strcasecmp (value,
								"clear") == 0)
					{
						log_forwarding_sws = 0;
					}
					else if (switch_by_name
						    (log_forwarding_table,
						    value,
						    &log_forwarding_sws) != 0)
					{
						logit (LOG_DAEMON, LOG_INFO,
					      "%s: log_forwarding defaults ON",
							func);
						log_forwarding = 1;
					}
				}

				if (was != log_forwarding)
				{
					logit (LOG_DAEMON, LOG_INFO,
					    "%s: log_forwarding was %s now %s",
						func,
						was == 0 ? "off" : "on",
					        log_forwarding == 0
								? "off" : "on");
				}

				if (num != log_forwarding_sws)
				{
					logit (LOG_DAEMON, LOG_INFO,
				"%s: log_forwarding was 0x%x, now 0x%x for %s",
						func, num, log_forwarding_sws,
						value);
				}

				valcount++;
			}

			/*
			 * global_acct_q.limit <integer>
			 */
			else if (strcasecmp (verb, "global_acct_q.limit") == 0)
			{
				if (!*value)
				{
					num = MAX_ACCT_REQUESTS;
				}
				else
				{
					num = atoi (value);
					num = num < 0 ? 0 : num;
				}

				if (num != global_acct_q.limit)
				{
					logit (LOG_DAEMON, LOG_INFO,
					"%s: global_acct_q.limit was %d now %d",
						func, global_acct_q.limit, num);

					logit (LOG_DAEMON, LOG_INFO,
				     "%s: global_acct_q max was %d, cur is %d",
						func, global_acct_q.max,
						global_acct_q.cur);

					/* Reset maximum queue size */
					global_acct_q.max = 0;
					global_acct_q.limit = num;

					logit (LOG_DAEMON, LOG_INFO,
			  "%s: global_acct_q (q'd, fail, dup)=(%lu, %lu, %lu)",
						func, global_acct_q.q_ok,
						global_acct_q.q_fail,
						global_acct_q.q_dup);

					global_acct_q.q_ok = 0;
					global_acct_q.q_fail = 0;
					global_acct_q.q_dup = 0;
				}

				valcount++;
			}

			/*
			 * global_acct_q.hold <integer>
			 */
			else if (strcasecmp (verb, "global_acct_q.hold") == 0)
			{
				if (!*value)
				{
					num = 0;
				}
				else
				{
					num = atoi (value);
					num = num < 0 ? 0 : num;
				}

				if (num != global_acct_q.hold)
				{
					logit (LOG_DAEMON, LOG_INFO,
					"%s: global_acct_q.hold was %d now %d",
						func, global_acct_q.hold, num);

					logit (LOG_DAEMON, LOG_INFO,
				     "%s: global_acct_q max was %d, cur is %d",
						func, global_acct_q.max,
						global_acct_q.cur);

					/* Reset maximum queue size. */
					global_acct_q.max = 0;
					global_acct_q.hold = num;

					logit (LOG_DAEMON, LOG_INFO,
			  "%s: global_acct_q (q'd, fail, dup)=(%lu, %lu, %lu)",
						func, global_acct_q.q_ok,
						global_acct_q.q_fail,
						global_acct_q.q_dup);

					global_acct_q.q_ok = 0;
					global_acct_q.q_fail = 0;
					global_acct_q.q_dup = 0;
				}
			}

			/*
			 * global_auth_q.limit <integer>
			 */
			else if (strcasecmp (verb, "global_auth_q.limit") == 0)
			{
				if (!*value)
				{
					num = MAX_AUTH_REQUESTS;
				}
				else
				{
					num = atoi (value);
					num = num < 0 ? 0 : num;
				}

				if (num != global_auth_q.limit)
				{
					logit (LOG_DAEMON, LOG_INFO,
					"%s: global_auth_q.limit was %d now %d",
						func, global_auth_q.limit, num);

					logit (LOG_DAEMON, LOG_INFO,
				     "%s: global_auth_q max was %d, cur is %d",
						func, global_auth_q.max,
						global_auth_q.cur);

					/* Reset maximum queue size */
					global_auth_q.max = 0;
					global_auth_q.limit = num;

					logit (LOG_DAEMON, LOG_INFO,
			  "%s: global_auth_q (q'd, fail, dup)=(%lu, %lu, %lu)",
						func, global_auth_q.q_ok,
						global_auth_q.q_fail,
						global_auth_q.q_dup);

						global_auth_q.q_ok = 0;
						global_auth_q.q_fail = 0;
						global_auth_q.q_dup = 0;
				}
				valcount++;
			}

			/*
			 * global_auth_q.hold <integer>
			 */
			else if (strcasecmp (verb, "global_auth_q.hold") == 0)
			{
				if (!*value)
				{
					num = MAX_AUTH_REQUESTS;
				}
				else
				{
					num = atoi (value);
					num = num < 0 ? 0 : num;
				}

				if (num != global_auth_q.hold)
				{
					logit (LOG_DAEMON, LOG_INFO,
					"%s: global_auth_q.hold was %d now %d",
						func, global_auth_q.hold, num);

					logit (LOG_DAEMON, LOG_INFO,
				     "%s: global_auth_q max was %d, cur is %d",
						func, global_auth_q.max,
						global_auth_q.cur);

					/* Reset maximum queue size. */
					global_auth_q.max = 0;
					global_auth_q.hold = num;

					logit (LOG_DAEMON, LOG_INFO,
			  "%s: global_auth_q (q'd, fail, dup)=(%lu, %lu, %lu)",
						func, global_auth_q.q_ok,
						global_auth_q.q_fail,
						global_auth_q.q_dup);

					global_auth_q.q_ok = 0;
					global_auth_q.q_fail = 0;
					global_auth_q.q_dup = 0;
				}
				valcount++;
			}

			/*
			 * aatv.forking <aatv-name>
			 */
			else if (strcasecmp (verb, "aatv.forking") == 0)
			{
				if (!*value)
				{
					logit (LOG_DAEMON, LOG_ERR,
			       "%s: No AATV specified at %s line %d (ignored)",
						func, confpath, lnum);
				}
				else if ((cfg_aatv =
					find_aatv (value)) != (AATV *) NULL)
				{
					type = cfg_aatv->aatvfunc_type;

					if (type != AA_FORK)
					{
						logit (LOG_DAEMON, LOG_INFO,
					     "%s: AATV %s was %s, now forking",
							func, cfg_aatv->id,
							aatv_types[type]);

						cfg_aatv->aatvfunc_type =
									AA_FORK;
					}

					valcount++;
				}
				else
				{
					logit (LOG_DAEMON, LOG_ERR,
			     "%s: No such AATV '%s' at '%s' line %d (ignored)",
						func, value, confpath, lnum);
				}
			}

			/*
			 * aatv.forkreply <aatvname>
			 */
			else if (strcasecmp (verb, "aatv.forkreply") == 0)
			{
				if (!*value)
				{
					logit (LOG_DAEMON, LOG_ERR,
			       "%s: No AATV specified at %s line %d (ignored)",
						func, confpath, lnum);
				}
				else if ((cfg_aatv =
					find_aatv (value)) != (AATV *) NULL)
				{
					type = cfg_aatv->aatvfunc_type;

					if (type != AA_FREPLY)
					{
						logit (LOG_DAEMON, LOG_INFO,
					   "%s: AATV %s was %s, now forkreply",
							func, cfg_aatv->id,
							aatv_types[type]);

						cfg_aatv->aatvfunc_type =
								AA_FREPLY;
					}

					valcount++;
				}
				else
				{
					logit (LOG_DAEMON, LOG_ERR,
			     "%s: No such AATV '%s' at '%s' line %d (ignored)",
						func, value, confpath, lnum);
				}
			}

			/*
			 * aatv.direct <aatvname>
			 */
			else if (strcasecmp (verb, "aatv.direct") == 0)
			{
				if (!*value)
				{
					logit (LOG_DAEMON, LOG_ERR,
			       "%s: No AATV specified at %s line %d (ignored)",
						func, confpath, lnum);
				}
				else if ((cfg_aatv =
					find_aatv (value)) != (AATV *) NULL)
				{
					type = cfg_aatv->aatvfunc_type;

					if (type != AA_DIRECT)
					{
						logit (LOG_DAEMON, LOG_INFO,
					      "%s: AATV %s was %s, now direct",
							func, cfg_aatv->id,
							aatv_types[type]);

						cfg_aatv->aatvfunc_type =
								AA_DIRECT;
					}

					valcount++;
				}
				else
				{
					logit (LOG_DAEMON, LOG_ERR,
			     "%s: No such AATV '%s' at '%s' line %d (ignored)",
						func, value, confpath, lnum);
				}
			}

			/*
			 * aatv.socket <aatvname>
			 */
			else if (strcasecmp (verb, "aatv.socket") == 0)
			{
				if (!*value)
				{
					logit (LOG_DAEMON, LOG_ERR,
			       "%s: No AATV specified at %s line %d (ignored)",
						func, confpath, lnum);
				}
				else if ((cfg_aatv =
					find_aatv (value)) != (AATV *) NULL)
				{
					type = cfg_aatv->aatvfunc_type;

					if (type != AA_SOCKET)
					{
						logit (LOG_DAEMON, LOG_INFO,
					      "%s: AATV %s was %s, now socket",
							func, cfg_aatv->id,
							aatv_types[type]);

						cfg_aatv->aatvfunc_type =
								AA_SOCKET;
					}

					valcount++;
				}
				else
				{
					logit (LOG_DAEMON, LOG_ERR,
			     "%s: No such AATV '%s' at '%s' line %d (ignored)",
						func, value, confpath, lnum);
				}
			}

			/*
			 * aatv.proc_max <something>
			 */
			else if (strcasecmp (verb, "aatv.proc_max") == 0)
			{
				num = handle_sysconf (lnum, valcount,
							confpath, value);
				valcount = num;
			}

			/*
			 * packet_log
			 */
			else if (strcasecmp (verb, "packet_log") == 0)
			{
			  	was = packet_log_switch;
				if (strcasecmp (value, "default") == 0)
				{
					packet_log_switch =
						PL_SWS_CUR | PL_SWS_ORIG;
					valcount++;
				}
				else if ((strcasecmp (value, "none") == 0) ||
					(strcasecmp (value, "clear") == 0))
				{
					packet_log_switch = 0;
					valcount++;
				}
				else if (switch_by_name (packet_log_table,
							value,
							&packet_log_switch) == 0)
				{
					  valcount++;
				}
				else
				{
					logit (LOG_DAEMON, LOG_INFO,
						"%s: %s invalid value %s",
						func, verb, value);
				}

				if (was != packet_log_switch)
				{
					logit (LOG_DAEMON, LOG_INFO,
				    "%s: packet_log was 0x%x, now 0x%x for %s",
					       func, was,
					       packet_log_switch, value);
				}
			}

			/*
			 * radcheck
			 */
			else if (strcasecmp (verb, "radcheck") == 0)
			{
				was = radcheck_switch;
				if (strcasecmp (value, "default") == 0)
				{
					radcheck_switch = RADCHECK_QSTATS;
					valcount++;
				}
				else if ((strcasecmp (value, "none") == 0) ||
					(strcasecmp (value, "clear") == 0))
				{
					radcheck_switch = 0;
					valcount++;
				}
				else if (switch_by_name (radcheck_table,
							value,
							&radcheck_switch) == 0)
				{
					valcount++;
				}
				else
				{
					logit (LOG_DAEMON, LOG_INFO,
						"%s: %s invalid value %s",
						func, verb, value);
				}

				if (was != radcheck_switch)
				{
					logit (LOG_DAEMON, LOG_INFO,
				     "%s: radcheck was 0x%x, now 0x%x for %s",
						func, was,
						radcheck_switch, value);
				}
			}

			/*
			 * reply_check
			 */
			else if (strcasecmp (verb, "reply_check") == 0)
			{
				was = rad_reply_switch;
				was_dal = reply_check_list;

				if (strcasecmp (value, "default") == 0)
				{
					rad_reply_switch = 0;
					attr_check_clear (&reply_check_list);
					valcount++;
				}
				else if (strcasecmp (value, "none") == 0)
				{
					attr_check_clear (&reply_check_list);
					valcount++;
				}
				else if (strcasecmp (value, "all") == 0)
				{
					valcount++;
					rad_reply_switch |= RRS_ALL;
				}
				else if (strcasecmp (value, "first") == 0)
				{
					valcount++;
					rad_reply_switch &= ~(RRS_ALL);
				}
				else if (strcasecmp (value, "clear") == 0)
				{
					valcount++;
					rad_reply_switch = 0;
				}
				else if (switch_by_name (rad_reply_table,
							value,
							&rad_reply_switch) == 0)
				{
					  valcount++;
				}
				else if (attr_check_by_name (&reply_check_list,
								value) == 0)
				{
					valcount++;
					if (was_dal != reply_check_list)
					{
						if (reply_check_list
						    == (DICT_ATTR_LIST *) NULL)
						{
						    logit (LOG_DAEMON, LOG_INFO,
						"%s: reply_check_list cleared",
							func);
						}
						else
						{
						    logit (LOG_DAEMON, LOG_INFO,
				    "%s: reply_check_list now checking %s too",
							func,
							reply_check_list->ap->name);
						}
					}
				}
				else
				{
					logit (LOG_DAEMON, LOG_INFO,
						"%s: %s invalid value %s",
						func, verb, value);
				}

				if (was != rad_reply_switch)
				{
					logit (LOG_DAEMON, LOG_INFO,
				     "%s: rad_reply was 0x%x, now 0x%x for %s",
						func, was,
						rad_reply_switch, value);
				}
			} /* end of reply-check */


			/*
			 *	Fell off the end.  Invalid configiration item.
			 */
			else
			{
				logit (LOG_DAEMON, LOG_ERR,
	     "%s: Invalid configuration option '%s' in '%s' line %d (ignored)",
					func, verb, confpath, lnum);
			}
		} /* end of while */
		fclose (conf);

		logit (LOG_DAEMON, LOG_INFO,
			"%s: '%s' %d lines read, %d values",
			func, confpath, lnum, valcount);

	} /* end of if (fopen) */

	return;

} /* end of read_sysconf () */

/*************************************************************************
 *
 *	Function: record_event
 *
 *	Purpose: Adds EVENT_ENT to authreq if resultant event is EV_WAIT.
 *		 Records current state, FSM action, direct action, PID,
 *		 integer and string in EVENT_ENT for later re-sending.
 *
 *	Returns: 0 :: event properly set up,
 *		 1 :: error (currently, if the length of string is too long).
 *
 *************************************************************************/

static int
record_event (authreq, aatv, pid, value, string)

AUTH_REQ       *authreq;
AATV           *aatv;
int             pid;
int             value;
char           *string;

{
	CLIENT_ENTRY   *client;
	EVENT_ENT      *event;
	static char    *func = "record_event";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/*
	 * Check to see if string exceeds EVENT_ENT.estring[]
	 */
	if (strlen (string) >= AUTH_ID_LEN)
	{
		logit (LOG_DAEMON, LOG_CRIT,
			"%s: Length >= %d, '%s'", func, AUTH_ID_LEN, string);
		return (1);
	}

	if ((event = (EVENT_ENT *) calloc (1, sizeof (EVENT_ENT)))
							== (EVENT_ENT *) NULL)
	{
		logit (LOG_DAEMON, LOG_ALERT, "%s: FATAL out of memory", func);
		abort ();
	}
	waldo_mf.m++;

	event->queued_t = time (0);
	event->auth_head = authreq; /* all EVENT_ENT nodes point to authreq */

	event->state = authreq->state;
	event->fsm_aatv = authreq->fsm_aatv;
	event->direct_aatv = authreq->direct_aatv;
	event->sub_aatv = aatv;

	if ((aatv->aatvfunc_type == AA_SOCKET) && (last_send_len > 0))
	{
		if ((event->packet = (u_char *) calloc (1, last_send_len))
							== (u_char *) NULL)
		{
			logit (LOG_DAEMON, LOG_ALERT, "%s: FATAL out of memory",
				func);
			abort ();
		}
		redo_mf.m++;
		memcpy ((char *) &event->sin, (char *) &last_send_sin,
			sizeof (last_send_sin));
		event->len = last_send_len;
		memcpy ((char *) event->packet, send_buffer, last_send_len);
		strcpy (event->action, last_send_action);

		/* Link the event onto the client event list. */
		if (find_client (ntohl(last_send_sin.sin_addr.s_addr),
								&client) == 0)
		{
			/* Set up the previous pointer. */
			event->client_prev = &(client->event_q);

			/*
			 *	If there is a list, reset the previous
			 *	pointer of the first element on the list.
			 */
			if (client->event_q != (EVENT_ENT *) NULL)
			{
				client->event_q->client_prev =
							&(event->client_next);
			}

			event->client_next = client->event_q;
			client->event_q = event;

			/* Indicate client for which this event is waiting. */
			event->client = client;
		}
		else
		{
			logit (LOG_DAEMON, LOG_INFO,
			    "%s: Unable to queue event for host %s", func,
			    ip_hostname (ntohl(last_send_sin.sin_addr.s_addr)));
		}
	}
	else
	{
		event->len = 0;
		event->packet = (u_char *) NULL;
		event->action[0] = '\0';
	}

	last_send_len = 0;
	event->evalue = value;
	strcpy (event->estring, string);
	event->pid = (pid_t) pid;

	event->next = authreq->event_q; /* link this node onto event_q */
	authreq->event_q = event;

	dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		"%s: event [%d '%s' '%s'  PID = %d  %d '%s']", func,
		event->state,
		(event->fsm_aatv == (AATV *) NULL)
					? (u_char *) "?" : event->fsm_aatv->id,
		(event->sub_aatv == (AATV *) NULL)
					? (u_char *) "?" : event->sub_aatv->id,
		event->pid, event->evalue,
		(event->estring[0] == '\0') ? "?" : event->estring));

	return (0);	/* Indicate success. */
} /* end of record_event () */

/*************************************************************************
 *
 *	Function: redo_action
 *
 *	Purpose: For pending events of aatvfunc_type == AA_SOCKET this
 *		 AATV function re-issues the socket AATV action function.
 *
 *************************************************************************/

static int
redo_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	int             result;
	u_char          save_state;
	CLIENT_ENTRY   *ce;
	EVENT_ENT      *event_list;
	EVENT_ENT      *event;
	EVENT_ENT     **prev_event;
	char		log_msg[1024];
	char		log_guard[256];
	static char    *func = "redo_action";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq == (AUTH_REQ *) NULL)
	{
		return EV_WAIT;
	}

	event_list = (EVENT_ENT *) NULL;

	for (prev_event = &authreq->event_q ;
		(event = *prev_event) != (EVENT_ENT *) NULL ; )
	{
		dprintf(2, (LOG_DAEMON, LOG_DEBUG,
			"%s: event [%d '%s' '%s'  PID = %d  %d '%s']", func,
			event->state,
			(event->fsm_aatv == (AATV *) NULL)
					? (u_char *) "?" : event->fsm_aatv->id,
			(event->sub_aatv == (AATV *) NULL)
					? (u_char *) "?" : event->sub_aatv->id,
			event->pid, event->evalue,
			(event->estring[0] == '\0') ? "?" : event->estring));

		if (event->sub_aatv->aatvfunc_type == AA_SOCKET)
		{
			*prev_event = event->next;
			event->next = event_list;
			event_list = event;
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: event found: AATV '%s'", func,
				(event->sub_aatv == (AATV *) NULL)
				      ? (u_char *) "?" : event->sub_aatv->id));
			continue;
		}
		prev_event = &event->next;
	}

	/* redo each event by calling its AATV redo() function */

	while (event_list != (EVENT_ENT *) NULL)
	{
		event = event_list;
		event_list = event->next;

		if (event->packet == (u_char *) NULL)
		{
			save_state = authreq->state;
			authreq->state = event->state;
			authreq->fsm_aatv = event->fsm_aatv;
			authreq->direct_aatv = event->direct_aatv;
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: invoking AATV '%s'", func,
				(event->sub_aatv == (AATV *) NULL)
				      ? (u_char *) "?" : event->sub_aatv->id));
			result = call_action (event->sub_aatv, authreq,
						event->evalue, event->estring);
			authreq->state = save_state;
			stat_redos.actions++;
		}
		else
		{
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: resending packet for %s", func,
				(event->sub_aatv == (AATV *) NULL)
				      ? (u_char *) "?" : event->sub_aatv->id));

			ce = event->client;

			/* Packet level debugging */
			if ((debug_flag > 2) ||
				((debug_flag > 0) &&
					(ce != (CLIENT_ENTRY *) NULL) &&
					((ce->client_type & CE_DEBUG) != 0)))
			{
				dumpit (LOG_DAEMON, LOG_DEBUG,
					(u_char *) event->packet, event->len, 0,
			     "%s: resending packet from [%s] type=%s to %s:%d",
					func, ip_hostname (authreq->ipaddr),
					authtype_toa (authreq->code),
					ce->hostname,
					ntohs(event->sin.sin_port));
			}

			if (log_forwarding != 0)
			{
				packet_log (log_msg, authreq,
							log_forwarding_sws);
				logit (LOG_DAEMON, LOG_INFO,
					"Resending-%s to %s:%d", log_msg,
					ce->hostname,
					ntohs(event->sin.sin_port));
			}

			sendto (event->sub_aatv->sockfd, (char *) event->packet,
				event->len, (int) 0,
				(struct sockaddr *) &event->sin,
				sizeof (event->sin));
			result = EV_ACK;	/* prevent freeing of event */

			/* Measure how much redos do. */
			stat_redos.packets++;
			stat_redos.octets += event->len;
		}

		if (result == EV_WAIT)
		{
			free_event (event);
		}
		else /* return to authreq structure */
		{
			event->next = authreq->event_q;
			authreq->event_q = event;
		}
	}
	return EV_WAIT;
} /* end of redo_action () */

/*************************************************************************
 *
 *	Function: reply_timer
 *
 *	Purpose: Invoked by ALARM signal.  Performs timeout of outstanding
 *		 RADIUS-to-RADIUS requests.  Requests stay around on the
 *		 global queue with a state of ST_HOLD until they timeout.
 *		 At this point, they are removed from the queue.
 *
 *************************************************************************/

static void
reply_timer (signo)

int             signo;

{
	int             i;
	int             reset = 0;
	int		pending = 0;
	AUTH_REQ       *authreq;
	AUTH_REQ      **prev;
	AUTH_REQ_Q     *aaq;
	int           (*timer_func) ();
	EV              ev;
	time_t		now = time (NULL);

#ifdef USR_CCA
	AATV           *aatv_ent;
#endif	/* USR_CCA */

	char            log_msg[1024];
	char		log_guard[256];
	static char    *func = "reply_timer";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((file_logging == 1) && (msgfd != (FILE *) NULL))
	{
		fflush (msgfd);
	}

	/* Really only need to do this the first time through here... */
	FD_SET(server_aatv.sockfd, &select_mask);

	ev.state = ST_ANY;
	ev.a.aatv = rad_any_aatv;
	ev.isproxy = 0;
	ev.xstring[0] = '\0';

	/* Check all entries for process timeout (request ttl) and timer */
	for (aaq = &global_auth_q; aaq != (AUTH_REQ_Q *) NULL;
	     aaq = aaq->next)
	{
		for (prev = &(aaq->q); (authreq = *prev) ; )
		{
#ifdef USR_CCA
			if ((authreq->code != PW_RESOURCE_QUERY_REQ) &&
			      (authreq->code != PW_NAS_REB_REQ) &&
			      (authreq->timer != 0) && (--authreq->timer == 0))
#else	/* USR_CCA */
			if ((authreq->timer != 0) && (--authreq->timer == 0))
#endif	/* USR_CCA */
			{
				ev.value = EV_TIMER;
				state_machine (ev, authreq);

				if (*prev != authreq)
				{
					continue;
				}
			}
#ifdef USR_CCA
			switch (authreq->code)
			{
			    case PW_RESOURCE_QUERY_REQ:
				if (authreq->retry_cnt >= RQUERY_RETRIES)
				{
					if (authreq->ttl > 0)
					{
						reset++;
					}
				}
				else
				{
					/*
					 *	qry_count == 0 is to prevent
					 *	original request from being
					 *	retransmitted once a reply is
					 *	received from a NAS.
					 *
					 *	type != USR_PROXY is to	prevent
					 *	the Proxy server from
					 *	retransmitting the Query
					 *	Request.
					 */
					if (authreq->ttl == 1 &&
					    authreq->qry_count == 0 &&
					    authreq->type != USR_PROXY)
				        {
						authreq->ttl = RQUERY_TIMER + 1;
						authreq->ttlslice = RQUERY_TIMER + 1;
						authreq->rep_id =
						  new_id (global_auth_q.q);
						aatv_ent = find_aatv ("REDO");
						call_action (aatv_ent, authreq, 0, "");
					}
				}
				break;

			    case PW_NAS_REB_REQ:
			        if (authreq->retry_cnt >= NAS_REB_RETRY)
				{
					if (authreq->ttl > 0)
					{
						reset++;
					}
				}
				else
				{
					if (authreq->ttl == 1)
					{	/* time to retransmit */
						authreq->ttl =
							NAS_REB_TIMER + 1;
						authreq->ttlslice =
							NAS_REB_TIMER + 1;
						authreq->rep_id =
						     new_id (global_auth_q.q);
						aatv_ent = find_aatv ("REDO");
						call_action (aatv_ent, authreq,
								0, "");
					}
					reset++;
				}
				break;
			}	/* switch (authreq->code) */
#endif	/* USR_CCA */

			/* Ignore requests that have a ttl of zero */
			if ((authreq->ttl != 0) && (--authreq->ttl == 0))
			{
#ifdef USR_CCA
				if (authreq->code == PW_RESOURCE_QUERY_REQ &&
				    authreq->type == USR_PARENT)
				{
					set_client (authreq->ipaddr, TEST_GOT);
				}
#endif	/* USR_CCA */
				ev.value = EV_TIMEOUT;
				state_machine (ev, authreq);

				if (*prev != authreq)
				{
					continue;
				}
			}

			prev = &authreq->next;
		}  /* For each authreq in current queue */

		/*
		 * Now, check the free'd queues.
		 */

		for (prev = &(aaq->freed) ; (authreq = *prev) ; )
		{
			if (authreq->free_end < now)
			{
				packet_log (log_msg, authreq, PL_REP_PORT |
					    PL_REP_VECTOR | PL_FWD_VECTOR);
				logit (LOG_DAEMON, LOG_INFO, "Freeing-%s",
				       log_msg);

				free_authreq_final (authreq);
			}
			else
			{
				prev = &(authreq->next);
			}
		}
	}

	for (i = 0 ; (timer_func = timer_funcs[i]) ; i++)
	{
		if (timer_func ())
		{
			reset++;
		}
	}

	/*
	 * Anything left that needs a timer?
	 */
	for (aaq = (&global_auth_q); aaq != (AUTH_REQ_Q *) NULL;
	     aaq = aaq->next)
	{
		/*
		 * If there's an authreq in the system, a timer needs
		 * to be around to clean it up.
		 */
		if ((aaq->q != (AUTH_REQ *) NULL) ||
		    (aaq->freed != (AUTH_REQ *) NULL))
		{
			pending = 1;
			break;
		}
	}

	if ((pending == 0) && (want_timer == 0) && (reset == 0))
	{
		alarm_set = 0;		/* Indicate no alarm set now */
	}
	else /* still awaiting some replies */
	{
		alarm (1);		/* Reset timer */
	}

	return;
} /* end of reply_timer () */

/*************************************************************************
 *
 *	Function: response_match
 *
 *	Purpose: Find a response matching the authreq
 *
 *************************************************************************/

static AUTH_REQ *
response_match (authreq, ce, recv_buffer, recv_len, vers, recv_id, vector_ptr,
		reply_digest, p_seq_matches, p_digest_matches, p_last)

AUTH_REQ       *authreq;
CLIENT_ENTRY   *ce;
u_char         *recv_buffer;
int             recv_len;
int             vers;
int             recv_id;
u_char         *vector_ptr;
u_char         *reply_digest;
int            *p_seq_matches;
int            *p_digest_matches;
AUTH_REQ      **p_last;

{
	int             digest_matches = 0;
	int             secretlen;
	int             seq_matches = 0;
	char           *secret;
	AUTH_REQ       *found = (AUTH_REQ *) NULL;
	u_char          md5buf[AUTH_VECTOR_LEN];
	char            log_msg[1024];
	char            log_guard[256];
	static char    *func = "response_match";

	/* Save the received reply digest in md5buf */
	memcpy ((char *) md5buf, (char *) vector_ptr, AUTH_VECTOR_LEN);

	/* Scan all authreq's in the list for a match */
	for ( ; authreq != (AUTH_REQ *) NULL; authreq = authreq->next)
	{
		if (authreq->vers_out != vers)
		{
			continue;
		}

		/* Matching differs depending on the protocol version */
		if (vers == VER1)
		{
			if ((u_char) authreq->fwd_id != recv_id)
			{
				continue;
			}

			/* Indicate sequence number matched. */
			seq_matches++;

			/*
			 *	Copy the forward vector into the
			 *	reply digest space.
			 */
			memcpy ((char *) vector_ptr, (char *) authreq->fwdvec,
				AUTH_VECTOR_LEN);

			/* Append the secret to the packet. */
			if (authreq->code == PW_STATUS_SERVER)
			{
				secret = dummy_status_server_client.secret;
			}
			else
			{
				secret = ce->secret;
			}
			secretlen = strlen (secret);
			memcpy (recv_buffer + recv_len, secret, secretlen);

			/*
			 *	Calculate the MD5 checksum on the packet
			 *	and put in reply_digest.
			 */
			md5_calc (reply_digest, recv_buffer, recv_len +
				  secretlen);

			/* Clear the secret from the end of the packet. */
			memset (recv_buffer + recv_len, 0, secretlen);

			/* Restore the received reply digest from md5buf. */
			memcpy ((char *) vector_ptr, (char *) md5buf,
				AUTH_VECTOR_LEN);

			/*
			 *	Check the received reply digest against
			 *	the calculated one.
			 */
			if (memcmp ((char *) md5buf, (char *) reply_digest,
							AUTH_VECTOR_LEN) == 0)
			{
				if (found == (AUTH_REQ *) NULL)
				{
					found = authreq;
				}
				digest_matches++;

				if ((rad_reply_switch & RRS_ALL) != 0)
				{
					if (digest_matches == 2)
					{
						packet_log (log_msg, found,
							    PL_FWD_VECTOR);
						logit (LOG_DAEMON, LOG_INFO,
						 "%s: %s-Match-%s // number 1",
						       func, log_msg);

						packet_log (log_msg, authreq,
							    PL_FWD_VECTOR);
						logit (LOG_DAEMON, LOG_INFO,
						"%s: %s-Match-%s // number %d",
						       func, log_msg,
						       digest_matches);
					}
					else if (digest_matches > 2)
					{
						packet_log (log_msg, authreq,
							    PL_FWD_VECTOR);
						logit (LOG_DAEMON, LOG_INFO,
						"%s: %s-Match-%s // number %d",
						       func, log_msg,
						       digest_matches);

					}
					/***FALLTHROUGH***/
				}
				else
				{
					break; /* the digests matched*/
				}
			}

			if (p_last != (AUTH_REQ **) NULL)
			{
				(*p_last) = authreq; /* Save for match checks */
			}
		}
		else  /* V2 or beyond */
		{
			if (authreq->fwd_id == recv_id)
			{
				found = authreq;
				seq_matches++;
				break;	/* Good enough if not V1 */
			}
		}
	} /* end of for loop */

	if (p_seq_matches != (int *) NULL)
	{
		(*p_seq_matches) = seq_matches;
	}

	if (p_digest_matches != (int *) NULL)
	{
		(*p_digest_matches) = digest_matches;
	}

	return (found);
} /* end of response_match () */

/*************************************************************************
 *
 *	Function: retry_limit_action
 *
 *	Purpose: Reset the request retry_limit value.
 *
 *************************************************************************/

static int
retry_limit_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "retry_limit_action";

	if (value == 0)
	{
		value = CLEANUP_DELAY;
	}

	dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		"%s: setting request retry_limit value to %d", func, value));

	if (authreq != (AUTH_REQ *) NULL)
	{
		authreq->retry_limit = value;
	}

	return EV_ACK;
} /* end of retry_limit_action () */

/*************************************************************************
 *
 *	Function: send_cmd_unrec
 *
 *	Purpose: Tell sender that we didn't like the command we just got.
 *		 This is sent in response to non-V1 messages only.
 *
 *************************************************************************/

static void
send_cmd_unrec (sockfd, version, sin, id, code, ce)

int                 sockfd;
int                 version;
struct sockaddr_in *sin;
int                 id;
int                 code;
CLIENT_ENTRY       *ce;

{
	int             total_length;
	AUTH_HDR       *auth;
	static char    *func = "send_cmd_unrec";

	dprintf(3, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (version == VER1)
	{
		return;
	}

	auth = (AUTH_HDR *) send_buffer;
	build_header (version, (char *) NULL, PW_COMMAND_UNRECOGNIZED,
								id, auth, ce);
	total_length = build_request_mic (auth, ce->secret);

	if (debug_flag > 0)
	{
		if ((debug_flag > 1) ||
			((ce != (CLIENT_ENTRY *) NULL) &&
			((ce->client_type & CE_DEBUG) != 0))) /* Packet debug */
		{
			dumpit (LOG_DAEMON, LOG_DEBUG,
				(u_char *) auth, total_length, 0,
			 "%s: Sending CMD_UNREC for id %d of type=%s to %s:%d",
				func, id, authtype_toa (code),
				ce ? ce->hostname : "??", ntohs(sin->sin_port));
		}
		else	/* record oddness */
		{
			logit (LOG_AUTH, LOG_DEBUG,
		    "%s: Sending CMD_UNREC for id %d of type %d to %s port %d",
			      func, id, code,
			      ip_hostname (ntohl(sin->sin_addr.s_addr)),
			      ntohs(sin->sin_port));
		}
	}

	/* Send it to the offender */
	sendto (sockfd, (char *) auth, total_length, (int) 0,
		(struct sockaddr *) sin, sizeof (struct sockaddr_in));
}  /* end of send_cmd_unrec () */

/*************************************************************************
 *
 *	Function: seqch_limit_action
 *
 *	Purpose: Reset the request's seqch_limit value.
 *
 *************************************************************************/

static int
seqch_limit_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "seqch_limit_action";

	if (value == 0)
	{
		value = CLEANUP_DELAY;
	}

	dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		"%s: setting request seqch_limit value to %d", func, value));

	if (authreq != (AUTH_REQ *) NULL)
	{
		authreq->seqch_limit = value;
	}

	return EV_ACK;
} /* end of seqch_limit_action () */

/*************************************************************************
 *
 *	Function: send_reply
 *
 *	Purpose: Reply to the original request with an ACKNOWLEDGE,
 *		 CHALLENGE or REJECT.  Attach reply attribute value pairs.
 *
 *************************************************************************/

static void
send_reply (code, packet, result, authreq, sockfd)

int             code;
char           *packet;
int             result;
AUTH_REQ       *authreq;
int             sockfd;

{
	u_short         total_length;
	int             errors = 0;
	int             ret;		/* for avpair_out() results */
	AUTH_HDR       *auth;
	VALUE_PAIR     *reply;
	VALUE_PAIR     *vp;
	CLIENT_ENTRY   *ce;
	VENDOR_LIST    *veps;
	static char    *func = "send_reply";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered: result = %d",
		func, result));

	/* Build standard response header */

	ce = authreq->client;
	auth = (AUTH_HDR *) send_buffer;
	build_header (authreq->vers_in, (char *) authreq->repvec, code,
						authreq->rep_id, auth, ce);
	ce->flags &= ~CLIENT_NO_TS;
	reply = authreq->cur_request;

	/* Load up the configuration values for the user (if any) */
	switch (code)
	{

#ifdef ASCEND
	    case PW_ASCEND_RADIPA_ALLOCATE:
		if ((vp = get_vp (reply, PW_FRAMED_IP_ADDRESS)) != NULL_VP)
		{
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: Reply to %s global pool IP alloc %lx",
				func, ip_hostname (authreq->ipaddr),
				vp->lvalue));

			if ((ret = avpair_out (vp, auth, send_buffer_size,
						ce->veps)) <= 0)
			{
				logit (LOG_DAEMON, LOG_ERR,
 "%s: avpair_out(%s(%d), ..., %u, %s) for PW_ASCEND_RADIPA_ALLOCATE returns %d",
					func, vp->ap->name, vp->attribute,
					send_buffer_size,
					vendor_list_toa (ce->veps), ret);
				errors++;
			}
		}
		break;

	    case PW_ASCEND_RADIPA_RELEASE:
		dprintf(2, (LOG_DAEMON, LOG_DEBUG,
			"%s: Reply to %s release global pool IP address",
			func, ip_hostname (authreq->ipaddr)));
		break;
#endif	/* ASCEND */

	    default:
		while (reply != NULL_VP)
		{
			/*
			 *	If the dictionary doesn't require
			 *	encapsulation, and the client entry
			 *	has encapsulation turned off, turn
			 *	off encapsulation if the vendor(s) match.
			 *
			 */
			if (((ce->client_type & CE_NOENCAPS) != 0) &&
				((reply->flags & VPF_ENCAPS) != 0) &&
				((reply->ap->flags & ATTR_ENCAPS) == 0))
			{
				dprintf(2, (LOG_DAEMON, LOG_DEBUG,
			"%s: Trying to clear VPF_ENCAPS for %s, sending to %s",
					func, reply->ap->name, ce->hostname));

				for (veps = ce->veps;
					veps != (VENDOR_LIST *) NULL;
					veps = veps->next)
				{
					if (reply->ap->vendor_id
							== veps->vep->id)
					{
					     dprintf(2, (LOG_DAEMON,
						  LOG_DEBUG,
		"%s: Clearing VPF_ENCAPS for %s, sending to %s vendor %s (%s)",
						  func, reply->ap->name,
						  ce->hostname,
						  veps->vep->name,
						  vendor_list_toa (ce->veps)));

					     reply->flags &= ~VPF_ENCAPS;
					     break;
					}
				}
			}

			/* Re-resolve all DNS names */
			if (reply->ap->type == PW_TYPE_IPADDR &&
				reply->strvalue != (char *) NULL)
			{
				if (find_host_by_name (&reply->lvalue,
							reply->strvalue) != 0)
				{
					logit (LOG_DAEMON, LOG_ERR,
		"%s: Reply not sent - Unresolved or bad DNS name '%s' present",
						func, reply->strvalue);
					/* Ugly, but effective, to just ... */
					return;
				}
			}

			if ((ret = avpair_out (reply, auth, send_buffer_size,
						ce->veps)) <= 0)
			{
				logit (LOG_DAEMON, LOG_ERR,
		  "%s: avpair_out(%s(%d), ..., %u, %s) for type %s returns %d",
					func, reply->ap->name,
					reply->attribute, send_buffer_size,
					vendor_list_toa (ce->veps),
					authtype_toa (code), ret);
				errors++;

				/* Overflow check. */
				if (ret == -2)
				{
					logit (LOG_DAEMON, LOG_ERR,
				   "%s: Reply not sent - send_buffer overflow",
						func);
					return;
				}
			}

			reply = reply->next;
		} /* end of while */
		break;
	} /* end of switch */

	/* Use null secret on password answers */
	if (code == PW_PASSWORD_ACK || code == PW_PASSWORD_REJECT)
	{
		total_length = (u_short) build_reply_mic (auth, "");
	}
	else
	{
		total_length = (u_short) build_reply_mic (auth, ce->secret);
	}

	memset ((char *) &last_send_sin, '\0', sizeof (last_send_sin));
	last_send_sin.sin_family = AF_INET;
	last_send_sin.sin_addr.s_addr = htonl(authreq->ipaddr);
	last_send_sin.sin_port = htons(authreq->udp_port);

	dprintf(1, (LOG_AUTH, LOG_DEBUG, "%s: %s", func,
		(packet == (char *) NULL) ? "?" : packet));

	last_send_len = total_length;

	/*
	 *	Packet level debugging
	 */
	if ((debug_flag > 2) ||
		((debug_flag > 0) &&
		(ce != (CLIENT_ENTRY *) NULL) &&
		((ce->client_type & CE_DEBUG) != 0)))
	{
		dumpit (LOG_DAEMON, LOG_DEBUG, (u_char *) auth,	total_length, 0,
			"%s: replying to packet [%s] type=%s to %s:%d",
			func, ip_hostname (authreq->ipaddr),
			authtype_toa (authreq->code), ce ? ce->hostname : "??",
			ntohs(last_send_sin.sin_port));
	}

	/* Send it to the user */
	sendto (sockfd, (char *) auth, (int) total_length, (int) 0,
		(struct sockaddr *) & last_send_sin, sizeof (last_send_sin));

	return;
} /* end of send_reply () */

/*************************************************************************
 *
 *	Function: server_status
 *
 *	Purpose: Allow management poll (poll to see if we're alive)
 *		 from anywhere.  Returns some server statistics.
 *
 *************************************************************************/

static int
server_status (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	int             i;
	int             pool_cnt = -1;
	UINT4           found_vep = 0;
	char           *end;
	AATVPTR         aatv;
	AUTH_REQ       *q;
	AUTH_REQ_Q     *aaq;
	CLIENT_ENTRY   *client_list;
	CLIENT_ENTRY   *each_ce;
	PACKET_COUNTS  *ctr;
	VENDOR_LIST    *each_vep;
	char            buf[AUTH_STRING2_LEN];
	char            buf2[AUTH_STRING2_LEN];
	char            etc[AUTH_STRING1_LEN];	/* For partial results */
	static char    *func = "server_status";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	/* If source isn't a client, be silent but still ack */
	if (find_client (authreq->ipaddr, (CLIENT_ENTRY **) NULL) != 0)
	{
		return EV_ACK;
	}

	/* Show statistics about standard memory utilization. */
	reply_sprintf (RS_NONE, authreq, "MF: %s %s %s %s",
		mf_ent_toa ("vp", &vp_mf),
		mf_ent_toa ("auth", &authreq_mf),
		mf_ent_toa ("waldo", &waldo_mf),
	        mf_ent_toa ("redo", &redo_mf));

	reply_sprintf (RS_NONE, authreq, "DNS-MF: %s %s %s",
		mf_ent_toa ("client", &dns_client_mf),
		mf_ent_toa ("addr", &dns_addr_mf),
		mf_ent_toa ("name", &dns_name_mf));

	client_list = get_client_list ();

	for (each_ce = client_list;
		each_ce != (CLIENT_ENTRY *) NULL;
		each_ce = each_ce->next)
	{
		for (each_vep = each_ce->veps, i = 0;
			each_vep != (VENDOR_LIST *) NULL;
			each_vep = each_vep->next)
		{
			i++;
		}

		if ((debug_flag > 1) && (i > 0))
		{
			dprintf(2, (LOG_DAEMON, LOG_INFO,
				"%s: client '%s' vendor-list is %d long",
				func, each_ce->hostname, i));
		}

		found_vep += i;
	}

	reply_sprintf (RS_NONE, authreq, "CLIENT-MF: %s %s %s(found=%lu)%s",
		mf_ent_toa ("vendor", &vendor_mf),
		mf_ent_toa ("vendor_list", &vendor_list_mf),
		(found_vep != (vendor_list_mf.m - vendor_list_mf.f)
			? "***" : ""),
		found_vep,
		(found_vep != (vendor_list_mf.m - vendor_list_mf.f)
			? "***" : ""));

#ifdef MERIT_LAS
	pool_cnt = rad_las_query (authreq); /* LAS status information */
	if (pool_cnt != 0)
	{
		reply_sprintf (0, authreq, "number of pools: %d", pool_cnt);
	}
#endif	/* MERIT_LAS */

	/*
	 *	Produce information about all queues:
	 *
	 *	buf[] contains classic queue stats,
	 *	buf2[] contains alloc/free stats.
	 */
	buf[0] = '\0';
	buf2[0] = '\0';

	for (aaq = &global_auth_q; aaq != (AUTH_REQ_Q *) NULL; aaq = aaq->next)
	{
		/*
		 *	Use the variable "i" to hold the number of
		 *	requests which have been replied to.
		 */
		for (q = aaq->q, i = 0; q != (AUTH_REQ *) NULL; q = q->next)
		{
			 /* Then it has been replied to. */
			if (q->repstatus != -2)
			{
				i++;
			}
		}

		sprintf (etc, "%s queue: %d/%d/(%d/%d)", aaq->q_name,
			aaq->max, aaq->cur, authreq_q_size (aaq->q), i);

		if (buf[0] != '\0')
		{
			/* Put a comma in between the queue names. */
			strcat (buf, ", ");
			strcat (buf, etc);
		}
		else
		{
			strcpy (buf, etc);
		}

		if ((radcheck_switch & RADCHECK_QSTATS) != 0)
		{
			/* Now, queue stats. */
			sprintf (etc, "%s stats: %lu/%lu/%lu", aaq->q_name,
				aaq->q_ok, aaq->q_fail, aaq->q_dup);

			if (buf2[0] != '\0')
			{
				/* Put a comma in between stats information. */
				strcat (buf2, ", ");
				strcat (buf2, etc);
			}
			else
			{
				strcpy (buf2, etc);
			}

			if ((aaq->hold != 0) ||
				(aaq->freed != (AUTH_REQ *) NULL))
			{
				sprintf (etc,
					"[%ld/(%u?%u)/%lu-%lu/%lu-%lu]",
					aaq->hold, aaq->cur_freed,
					authreq_q_size (aaq->freed),
					aaq->q_freed, aaq->dq_freed,
					aaq->c_free_authreq,
					aaq->c_free_authreq_final);
				strcat (buf2, etc);
			}
		}
	} /* end of for each known queue */

	reply_sprintf (0, authreq, "%s, maxtime: %d (%s)", buf,
			select_max, rad_time (tofmaxdelay, 0));

	if (buf2[0] != '\0')
	{
		reply_sprintf (0, authreq, "%s", buf2);
	}

	/* Show how many entries are in some files. */

	if (authfile_id[0] == '\0')
	{
		sprintf (etc, "authfile: %d", authfile_cnt);
	}
	else
	{
		sprintf (etc, "authfile: %s (%d)",
			authfile_id, authfile_cnt);
	}

	if (clients_id[0] == '\0')
	{
		sprintf (buf, "%s, clients: %d, users: %d, ",
			etc, clients_cnt, users_cnt);
	}
	else
	{
		sprintf (buf, "%s, clients: %s (%d), users: %d, ",
			etc, clients_id, clients_cnt, users_cnt);
	}

	/* Then put in the birthdate of when we started running. */
	sprintf (etc, "%s\n", rad_time (birthdate, 0));
	strcat (buf, etc);

	/* Next show the string from the %FSMID keyword in the FSM table. */
	if (fsm_id != NULL)
	{
		strcat (buf, "fsmid: ");
		strcat (buf, fsm_id);
	}
	else
	{
		sprintf (etc, " fsm: %d, ", nfsm);
		strcat (buf, etc);
	}

	/* Then show the string from the %DICTID keyword in the dictionary. */
	if (dict_id != NULL)
	{
		strcat (buf, ", dictid: ");
		strcat (buf, dict_id);
	}

	/* Then show the string from the %VENDORSID keyword in vendors file. */
	if (vend_id != NULL)
	{
		strcat (buf, ", vendid: ");
		strcat (buf, vend_id);
	}

	/* Then show what our debugging level is remotely. */
	if (debug_flag > 0)
	{
		sprintf (etc, ", dbg: %d, ", debug_flag);
		strcat (buf, etc);
	}

	avpair_add (&authreq->cur_request, PW_REPLY_MESSAGE, buf, -1);

	/* Show response times and averages. */
	reply_sprintf (0, authreq, "cleanup_delay: %d, avg-delay %d (of %d)",
			cleanup_delay (CLEANUP_DELAY), cleanup_delay (0),
			CLEANUP_BUCKETS);

	if ((radcheck_switch & RADCHECK_PSTATS) != 0)
	{
		buf[0] = '\0';
		for (ctr = &stat_received;
			ctr != (PACKET_COUNTS *) NULL;
			ctr = ctr->next)
		{
			end = packet_counts_toa (ctr);

			/* If no report, do nothing. */
			if (*end == '\0')
			{
				continue;
			}

			if ((strlen (end) + 2 + strlen (buf)) > 80)
			{
				reply_sprintf (0, authreq, "%s", buf);
				strcpy (buf, end);
			}
			else
			{
				if (buf[0] != '\0')
				{
					strcat (buf, ", ");
				}
				strcat (buf, end);
			}
		}

		if (buf[0] != '\0')
		{
			reply_sprintf (0, authreq, "%s", buf);
		}
	}

	reply_sprintf (0, authreq, "%s", verinfo (0));

	/* Report on queue sizes, for all AATVs */
	for (i = 0; i < MAX_AATV; i++)
	{
		aatv = *aatv_ptrs[i];

		if ((aatv != (AATVPTR) NULL) && (aatv->proc_cnt_hi != 0))
		{
			reply_sprintf (0, authreq,
				"%s: %d, %d, %d-%s, %d-%s, %d-%s",
				aatv->id, aatv->proc_max, aatv->proc_cnt,
				aatv->proc_cnt_hi,
				rad_time (aatv->proc_cnt_hi_t, 0),
				aatv->proc_q_hi,
				rad_time (aatv->proc_q_hi_t, 0),
				aatv->proc_q_cur,
				rad_time (aatv->proc_q_last, 0));
		}
	}

	return EV_ACK;
} /* end of server_status () */

/*************************************************************************
 *
 *	Function: set_debug
 *
 *	Purpose: Turn on (code == 1) or off (code == 0) debuging by opening
 *		 or closing the debug file.
 *
 *************************************************************************/

static void
set_debug (code)

int code;

{
	int             n;
	time_t          now;
	static char    *func = "set_debug";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (code)
	{
		sprintf (path, "%s/%s", radius_dir, debug_file);
		if (reset_stderr (path, 1) == 0)
		{
			ddt = stderr;
		}
		else
		{
			ddt = fopen (path, "w+");
		}

		if (ddt == (FILE *) NULL)
		{
			debug_flag = 0;
		}
		else
		{

#if defined(HAVE_SETVBUF)
			setvbuf (ddt, NULL, _IOLBF, BUFSIZ);
#else
			setlinebuf (ddt);
#endif

			if (zap_debugfile == 0)
			{
				if ((n = fcntl (fileno(ddt), F_GETFL, 0)) < 0)
				{
					syslog (LOG_WARNING,
						"fcntl(ddt, F_GETFL): %m");
				}
				else
				{
					(void) fcntl (fileno(ddt),
							F_SETFL, n | O_APPEND);
				}
			}
			else
			{
				zap_debugfile = 0;
			}
		}
	}
	else	/* delay closing ddt, we might interrupt someone */
	{
		if (ddt != (FILE *) NULL)
		{
			now = time (0);
			fprintf (ddt, "%-24.24s: Debugging turned off\n",
				ctime (&now));
			fflush (ddt);
			debug_flag = 0;
		}
	}
} /* end of set_debug () */

/*************************************************************************
 *
 *	Function: sig_fatal
 *
 *	Purpose: Log error message when undefined (fatal) signals occur.
 *
 *************************************************************************/

static void
sig_fatal (sig)

int             sig;

{
	struct sigaction action;
	static char    *func = "sig_fatal";

	dprintf(1, (LOG_DAEMON, LOG_DEBUG, "%s: signal %d", func, sig));

	switch (sig)
	{
	    case SIGABRT:
		if (dumpcore == 0) /* don't call abort(3) here */
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: exit on signal (%d)", func, sig);
			exit (-7);
		}
	}

	logit (LOG_DAEMON, LOG_ERR, "%s: ABORT on signal (%d)", func, sig);

	dumpcore = 1;

	action.sa_handler = SIG_DFL;
	sigemptyset (&action.sa_mask);
	action.sa_flags = 0;

	sigaction (SIGABRT, &action, NULL);
	abort ();

	/*** NOTREACHED ***/

} /* end of sig_fatal () */

/*************************************************************************
 *
 *	Function: sig_int
 *
 *	Purpose: Another way to initialize all AATVs which have
 *		 initialization functions.
 *
 *************************************************************************/

static void
sig_int (sig)

int             sig;

{
	int             n;
	PACKET_COUNTS  *clr;
	static char    *func = "sig_int";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	n = init_aatvs ();

	for (clr = &stat_received;
		clr != (PACKET_COUNTS *) NULL;
		clr = clr->next)
	{
		clr->packets = 0;
		clr->octets = 0;
		clr->actions = 0;
	}

	logit (LOG_DAEMON, LOG_INFO,
		"%s: INT signal received, %d descriptors initialized",
		func, n);

	return;
} /* end of sig_int () */

/*************************************************************************
 *
 *	Function: sig_quit
 *
 *	Purpose: Orderly termination of a child process.
 *
 *************************************************************************/

static void
sig_quit (sig)

int             sig;

{
	void          (*close_func) PROTO((void));
	static char    *func = "sig_quit";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (radius_child == 0) /* Must be the parent that is going away... */
	{
		sig_term (SIGTERM); /* "Goodnight, Chet", "Goodnight, David" */
		exit (-18);
	}

	if (child_done == 0)
	{
		if (current_aatv != child_aatv)
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: SIGQUIT in AATV %s (from %s)",
				func, current_aatv->id, child_aatv->id);
		}
		else
		{
			logit (LOG_DAEMON, LOG_ERR, "%s: SIGQUIT in AATV %s",
				func, current_aatv->id);
		}
	}

	/* Cleanup. */
	if (msgfd != (FILE *) NULL)
	{
		fclose (msgfd);
	}

	if ((debug_flag > 0) && (ddt != (FILE *) NULL))
	{
		fclose (ddt);
	}

	if (child_done != 0)
	{
		_exit (EV_ABORT);
	}

	_exit (EV_ACK);			/* We're in the sleep code. */
} /* end of sig_quit () */

/*************************************************************************
 *
 *	Function: sig_term
 *
 *	Purpose: Orderly shutdown of RADIUS engine/server.
 *
 *************************************************************************/

static void
sig_term (sig)

int             sig;

{
	int             i;
	AATV           *aatv;
	void          (*close_func) PROTO((void));
	static char    *func = "sig_term";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (sig == 0)
	{
		logit (LOG_DAEMON, LOG_INFO, "%s: select timed out", func);
	}
	else
	{
		logit (LOG_DAEMON, LOG_INFO, "%s: TERM signal received", func);
	}

	/* It would be nice to purge the authreq queue(s) here, but it's hard */

	for (i = 0; i < MAX_AATV; i++)
	{
		if ((aatv = *aatv_ptrs[i]) == NULL)
		{
			continue;
		}

		close_func = aatv->cleanup;
		if (close_func != (void (*) () ) NULL)
		{
			close_func ();
		}
	}

	if (file_logging == 0)
	{
		closelog ();
	}
	else /* may be file logging */
	{
		if (file_logging == 1)
		{
			(void) fclose (msgfd);
		}
	}

	if (ddt != (FILE *) NULL)
	{
		(void) fclose (ddt);
	}

	exit (0);
} /* end of sig_term () */

/*************************************************************************
 *
 *	Function: start_fsm
 *
 *	Purpose: Enters the FSM with the given event, AATV and authreq.
 *
 *************************************************************************/

void
start_fsm (authreq, event, action, xstring)

AUTH_REQ       *authreq;
int             event;
char           *action;		/* optional (may be NULL), so ignore */
char           *xstring;        /* pointer to optional string FSM parameter */

{
	EV              ev;
	char           *end;
	char            log_msg[1024];
	char            log_guard[256];
	char            extra[256];
	static char    *func = "start_fsm";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq != (AUTH_REQ *) NULL)
	{
		ev.state = authreq->state; /* record the old (current) state */
		authreq->state = ST_INIT; /* always enter FSM at start state */
	}
	else
	{
		dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));
		logit (LOG_DAEMON, LOG_ERR,
			"%s: can't enter FSM with NULL authreq", func);
		return;
	}

	ev.isproxy = 0; /* assume action is not a proxy string */
	if (action == (char *) NULL)
	{
		ev.a.aatv = rad_any_aatv;
	}
	else /* action is either a proxy string or an AATV name */
	{
		if (action[0] == '+') /* action is a proxy string */
		{
			ev.a.proxy = add_string (&action[1], ASIS | ASSTATIC);
			ev.isproxy = 1;
		}
		else /* action was an AATV name */
		{
			ev.a.aatv = find_aatv (action);
		}
	}

	ev.value = event;

	if (xstring != (char *) NULL)
	{
		strcpy (ev.xstring, xstring);
	}
	else
	{
		ev.xstring[0] = '\0';
	}

	/*
	 *	Log the new authreq, unless we're not supposed to.
	 */
	if ((!TAR_NO_LOG(authreq)) && (log_generated_request != 0))
	{
		/* report packets we start up */
		extra[0] = '\0';
		if ((action != NULL) || (xstring != NULL))
		{
			strcpy (extra, "[");
			if (action != NULL)
			{
				strcat (extra, action);
				if (xstring != NULL)
				{
					strcat (extra, " ");
				}
			}

			if (xstring != NULL)
			{
				end = extra + strlen (extra);
				sprintf (end, "\"%s\"", xstring);
			}
			strcat (extra, "]");
		}

		packet_log (log_msg, authreq, 0);
		logit (LOG_AUTH, LOG_INFO, "Initiated%s-%s", extra, log_msg);
	}

	/* Run it through the state machine */
	state_machine (ev, authreq);

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: exiting", func));

	return;
} /* end of start_fsm () */

/*************************************************************************
 *
 *	Function: state_machine
 *
 *	Purpose: Given an event from a previous action and a current state,
 *		 determine (from a pre-configured FSM table): 1) the action
 *		 to take as a result of this event having occurred and,
 *		 2) the value of the next state to go to in the FSM table.
 *
 *************************************************************************/

static void
state_machine (given, authreq)

EV              given;
AUTH_REQ       *authreq;

{
	u_char          fsm_state;
	u_char          cur_state;
	u_char          next_state;
	u_char          default_match;
	int             result;
	int             avalue;
	AATV           *fsm_action;
	FSM_ENT        *fsm_ent;
	char            log_msg[1024];
	char            log_guard[256];
	static char    *func = "state_machine";

	/*
	 *	Loop forever in the FSM until either:
	 *
	 *	1) a state is encountered which has no action (NULL action)
	 *
	 *	   or
	 *
	 *	2) the end of the FSM table is reached
	 *
	 */

	result = EV_ACK;

	if (authreq == (AUTH_REQ *) NULL)
	{
		cur_state = ST_ANY;
	}
	else
	{
		cur_state = authreq->state;
	}

	dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		"%s: entered: current state = %s (%d)  event = [%d %s %d]",
		func, find_state_name (cur_state), cur_state, given.state,
		(given.isproxy == 1) ? given.a.proxy :
				(char *) given.a.aatv->id, given.value));

	while (cur_state != ST_END)
	{
		default_match = 0;
		if (cur_state == ST_ANY)
		{
			fsm_ent = (FSM_ENT *) NULL; /* to force default table */
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: current state is ST_ANY, use default FSM",
				func));
		}
		else
		{
			if (cur_state >= nfsm)
			{
				logit (LOG_DAEMON, LOG_ERR,
		"%s: FATAL invalid state machine, cur_state (%d) >= nfsm (%d)",
					func, cur_state, nfsm);
				dumpcore = 1;
				abort ();
			}

			fsm_ent = fsm[cur_state];
			do /* find explicit match */
			{
				if ((fsm_ent->event.value == given.value) &&
					(fsm_ent->event.state == ST_ANY ||
					 fsm_ent->event.state == given.state) &&
					((fsm_ent->event.isproxy == 0 &&
						given.isproxy == 0 &&
					(fsm_ent->event.a.aatv == &any_aatv ||
					fsm_ent->event.a.aatv == given.a.aatv))
					||
					(fsm_ent->event.isproxy == 1 &&
						given.isproxy == 1 &&
					strcmp (fsm_ent->event.a.proxy,
						given.a.proxy) == 0)))
				{
					fsm_state = fsm_ent->next_state;
					fsm_action = fsm_ent->action;
					avalue = fsm_ent->xvalue;

					if (fsm_ent->xstring != (char *) NULL)
					{
						strcpy (given.xstring,
							fsm_ent->xstring);
					}
					break; /* found explicit match */
				}
				fsm_ent = fsm_ent->next;
			}
			while (fsm_ent != (FSM_ENT *) NULL);
			default_match = 0;
		}

		if (fsm_ent == (FSM_ENT *) NULL) /* else, try default table */
		{
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: Use default FSM: current state = (%d) %s",
				func, cur_state, find_state_name (cur_state)));

			fsm_ent = default_fsm[0];
			do /* find implicit match */
			{
				if (fsm_ent->event.value == given.value)
				{
					fsm_state = fsm_ent->next_state;
					fsm_action = fsm_ent->action;
					avalue = fsm_ent->xvalue;

					if (fsm_ent->xstring != (char *) NULL)
					{
						strcpy (given.xstring,
							fsm_ent->xstring);
					}
					break; /* found implicit match */
				}
				fsm_ent = fsm_ent->next;
			}
			while (fsm_ent != (FSM_ENT *) NULL);

			if (fsm_ent == (FSM_ENT *) NULL)
			{
				/*
				 *	If there are no explicit events which
				 *	match and no default event table
				 *	entries which match, then the default
				 *	action is to ignore event.
				 */

				if (given.isproxy == 1)
				{
					packet_log (log_msg, authreq, 0);

					logit (LOG_DAEMON, LOG_INFO,
				      "%s: proxy action '%s' not found for %s",
						func, given.a.proxy, log_msg);
				}
				else if (given.value != EV_WAIT)
				{
					packet_log (log_msg, authreq, 0);

					logit (LOG_DAEMON, LOG_INFO,
"%s: next state not found: cur state %s given = [%s value=%d aatv=%s proxy=%s] for %s",
						func,
						find_state_name (cur_state),
						find_state_name (given.state),
						given.value,
						(given.isproxy == 0) ?
						    (char *) given.a.aatv->id
						    : "none",
						(given.isproxy != 0) ?
						    given.a.proxy : "none",
						log_msg);

					dprintf(2, (LOG_DAEMON, LOG_DEBUG,
"%s: next state not found: cur state %s given = [%s value=%d aatv=%s proxy=%s] for %s",
						func,
						find_state_name (cur_state),
						find_state_name (given.state),
						given.value,
						(given.isproxy == 0) ?
						    (char *) given.a.aatv->id
						    : "none",
						(given.isproxy != 0) ?
						    given.a.proxy : "none",
						log_msg));
				}

				/*
				 *	Check for non-queued authreq entries.
				 *	If any pass through here, they could
				 *	get lost.  So, we destroy them instead.
				 */
				if (! TAR_QUEUED(authreq))
				{
					packet_log (log_msg, authreq, 0);

					logit (LOG_DAEMON, LOG_INFO,
						"Orphaned-%s", log_msg);

					dprintf(2, (LOG_DAEMON, LOG_DEBUG,
						"%s: Orphaned-%s",
						func, log_msg));

					logit (LOG_DAEMON, LOG_ERR,
					     "%s: Orphaned authreq, destroyed",
						func);

					free_authreq (authreq);

					dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				     "%s: return from FSM -- orphaned authreq",
						func));

					return;
				}

				fsm_state = ST_SAME;
				fsm_action = rad_null_aatv;
			}
			default_match = 1;
		}

		if ((next_state = fsm_state) == ST_SAME)
		{
			/* We're to stay in same state */
			next_state = cur_state;
		}

		dprintf(2, (LOG_DAEMON, LOG_DEBUG,
			"%s: decision: action = %s  next_state = %s (%d)",
			func, fsm_action->id,
			find_state_name (next_state), next_state));

		if (authreq != (AUTH_REQ *) NULL)
		{
			authreq->fsm_aatv = fsm_action;

#ifdef USR_CCA
			if (given.value == EV_ACK ||
				given.value == EV_NAK ||
				given.value == EV_ERROR ||
				given.value == EV_ACC_CHAL ||
				given.value == EV_PW_EXPIRED ||
				given.value == EV_RF_REQ)
#else	/* USR_CCA */
			if (given.value == EV_ACK ||
				given.value == EV_NAK ||
				given.value == EV_ERROR ||
				given.value == EV_ACC_CHAL ||
				given.value == EV_PW_EXPIRED)
#endif	/* USR_CCA */

			{
				authreq->fsmstatus = given.value;
			}
		}

		if (fsm_action == rad_end_aatv)
		{
			break;
		}

		result = call_action (fsm_action, authreq, avalue,
								given.xstring);
		given.state = cur_state;
		given.a.aatv = fsm_action;
		given.isproxy = 0;
		given.value = result;
		dprintf(2, (LOG_DAEMON, LOG_DEBUG,
			"%s: after action: event = [%s (%d) %s %d %s]",
			func, find_state_name (given.state), given.state,
			(given.isproxy == 1)
				? given.a.proxy : (char *) given.a.aatv->id,
			given.value,
			(given.xstring == (char *) NULL)
				? "?" :  given.xstring));

		if (authreq != (AUTH_REQ *) NULL)
		{
			authreq->state = next_state;
		}

		/* Exit if default table entry used and staying in same state */
		if (cur_state == next_state && default_match)
		{
			dprintf(2, (LOG_DAEMON, LOG_DEBUG,
				"%s: return from FSM -- nothing to do", func));
			return;
		}

		dprintf(2, (LOG_DAEMON, LOG_DEBUG,
			"%s: current state was (%d) %s, now (%d) %s",
			func, cur_state, find_state_name (cur_state),
			next_state, find_state_name (next_state)));
		cur_state = next_state;

	} /* end of while (1) */

	free_authreq (authreq);

	dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		"%s: return from FSM -- finished with FSM table", func));
	return; /* this return means: finished with the FSM */
} /* end of state_machine () */

/*************************************************************************
 *
 *	Function: stat_files
 *
 *	Purpose: Reads configuration files into memory if their timestamps
 *		 differ from the recorded values.
 *
 *************************************************************************/

static void
stat_files (init_flag, cache_flag)

int             init_flag;  /* controls initialization (1 => init) */
int             cache_flag; /* copy of radiusd cache_users (-u) option */

{
	int             doit;           /* one implies call config_files() */
	static time_t   save_atime = 0; /* timestamp of authfile */
	static time_t   save_ctime = 0; /* timestamp of clients file */
	static time_t   save_utime = 0; /* timestamp of users file */
	struct stat     stbuf;
	static char    *func = "stat_files";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	doit = 0;
	sprintf (path, "%s/%s", radius_dir, RADIUS_AUTH);
	if (stat (path, &stbuf))
	{
		save_atime = (time_t) 0;
	}
	else /* stat () returned zero (success) */
	{
		doit = MAX(doit, (stbuf.st_mtime > save_atime) ? 1 : 0);
		save_atime = stbuf.st_mtime;
	}

	sprintf (path, "%s/%s", radius_dir, RADIUS_CLIENTS);
	if (stat (path, &stbuf))
	{
		save_ctime = (time_t) 0;
	}
	else /* stat () returned zero (success) */
	{
		doit = MAX(doit, (stbuf.st_mtime > save_ctime) ? 1 : 0);
		save_ctime = stbuf.st_mtime;
	}

	if (cache_flag)
	{
		sprintf (path, "%s/%s", radius_dir, RADIUS_USERS);
		if (stat (path, &stbuf))
		{
			save_utime = (time_t) 0;
		}
		else /* stat () returned zero (success) */
		{
			doit = MAX(doit, (stbuf.st_mtime > save_utime) ? 1 : 0);
			save_utime = stbuf.st_mtime;
		}
	}

#ifdef MERIT_HUNTGROUP
	sprintf (path, "%s/%s", radius_dir, RADIUS_HUNTGROUPS);
	if (stat (path, &stbuf))
	{
		save_hgtime = (time_t) 0;
	}
	else /* stat () returned zero (success) */
	{
		doit = MAX(doit, (stbuf.st_mtime > save_hgtime) ? 1 : 0);
	}
#endif	/* MERIT_HUNTGROUP */

	if ((!init_flag) && doit)
	{
		doconfig (-1);
	}

	return;
} /* end of stat_files () */

/*************************************************************************
 *
 *	Function: sysconf_init
 *
 *	Purpose: Reconfigure various parameters of a running AAA server.
 *
 *************************************************************************/

static void
sysconf_init (aatv)

AATV           *aatv;

{
	static int      inited = 0;

	inited++;

	/*
	 * Skip first calls to init_aatvs()
	 * and doconfig () from mainline code.
	 */

	if (inited > 2)
	{
		read_sysconf ();
	}

} /* end of sysconf_init () */

/*************************************************************************
 *
 *	Function: timeout_action
 *
 *	Purpose: Performs the logging required when a timeout event occurs.
 *
 *************************************************************************/

static int
timeout_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "timeout_action";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq == (AUTH_REQ *) NULL)
	{
		return EV_ERROR;
	}

	/* Report queues in standard fashion. */
	log_queues (authreq, func);

	if ((value > 0) && (value < 255) && (value > authreq->ttl))
	{
		logit (LOG_DAEMON, LOG_INFO, "%s: Resetting ttl from %d to %d",
			func, authreq->ttl, value);
		authreq->ttl = value;
	}

	return EV_WAIT;
} /* end of timeout_action () */

/*************************************************************************
 *
 *	Function: timer_action
 *
 *	Purpose: Initializes the request timer value.
 *
 *************************************************************************/

static int
timer_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "timer_action";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		"%s: setting request timer value to %d", func, value));

	authreq->timer = value;

	if (authreq->event_q != (EVENT_ENT *) NULL)
	{
		authreq->retry_cnt++;	/* Pseudo-retransmission. */
	}

	return EV_WAIT;
} /* end of timer_action () */

/*************************************************************************
 *
 *	Function: ttl_action
 *
 *	Purpose: Reset the request TTL value.
 *
 *************************************************************************/

static int
ttl_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "ttl_action";

	if (authreq != (AUTH_REQ *) NULL)
	{
		if (value == 0)
		{
			value = authreq->ttlslice;
		}

		dprintf(2, (LOG_DAEMON, LOG_DEBUG,
			"%s: setting request ttl value to %d", func, value));

		authreq->ttl = value;
	}

	return EV_ACK;
} /* end of ttl_action () */

/*************************************************************************
 *
 *	Function: ttl_slice_action
 *
 *	Purpose: Reset the request ttl_slice value.
 *
 *************************************************************************/

static int
ttl_slice_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	static char    *func = "ttl_slice_action";

	if (value == 0)
	{
		value = CLEANUP_DELAY;
	}

	dprintf(2, (LOG_DAEMON, LOG_DEBUG,
		"%s: setting request ttl_slice value to %d", func, value));

	if (authreq != (AUTH_REQ *) NULL)
	{
		authreq->ttlslice = value;
	}

	return EV_ACK;
} /* end of ttl_slice_action () */

/*************************************************************************
 *
 *	Function: usage
 *
 *	Purpose: Display the syntax for starting this program.
 *
 *************************************************************************/

static void
usage ()

{
	fprintf (stderr,
		"Usage: %s [ -d raddb_dir ] [ -a acct_dir ] [ -c cwd ] [ -C ]\n",
		progname);
	fprintf (stderr, "\t\t [ -p auth_port ] [ -q acct_port ] [ -f fsm ]\n");
	fprintf (stderr, "\t\t [ -l format ]");

#ifdef MERIT_LAS
	fprintf (stderr, " [ -n ]");
#endif	/* MERIT_LAS */

	fprintf (stderr, " [ -pp auth_relay ] [ -qq acct_relay ]\n");
	fprintf (stderr,
		"\t\t [ -g 'logfile' | 'syslog' | 'stderr' ] [ -h ]\n");
	fprintf (stderr, "\t\t [ -t timeout ] [ -s ] [ -x ] [ -v ] [ -z ]");

#if defined(USE_DBM) || defined(USE_NDBM)
	fprintf (stderr, " [ -u ]");
#endif	/* USE_DBM || USE_NDBM*/

	fprintf (stderr, "\n");
	fprintf (stderr, "\t -d\tdirectory: of users, clients, and authfile\n");
	fprintf (stderr, "\t -a\tdirectory: where to put accounting records\n");
	fprintf (stderr, "\t -c\tdirectory: new current working directory\n");
	fprintf (stderr, "\t -C\tdirectory: allow token caching\n");
	fprintf (stderr, "\t -p\tport number to listen for auth requests on\n");
	fprintf (stderr, "\t -q\tport number to listen for acct requests on\n");
	fprintf (stderr, "\t -f\tfile name of FSM configuration table\n");
	fprintf (stderr, "\t -l\tstrftime(3) format for naming logfiles\n");

#ifdef MERIT_LAS
	fprintf (stderr, "\t -n\tnew session table at start for LAS\n");
#endif	/* MERIT_LAS */

	fprintf (stderr, "\t -pp\tport number to relay auth requests on\n");
	fprintf (stderr, "\t -qq\tport number to relay acct requests on\n");
	fprintf (stderr, "\t -g\tselect logfile, syslog or stderr logging\n");
	fprintf (stderr, "\t -t\tinactivity timeout value (minutes)\n");
	fprintf (stderr, "\t -s\tsingle process (non-spawning) mode\n");
	fprintf (stderr, "\t -x\tadd to debug flag value\n");
	fprintf (stderr, "\t -v\tdisplays RADIUS version\n");
	fprintf (stderr, "\t -z\tempty (zap) the logfile & debug file if -x\n");
	fprintf (stderr, "\t -h\tdisplays this help syntax\n");

#if defined(USE_DBM) || defined(USE_NDBM)
	fprintf (stderr, "\t -u\tdon't cache users file in memory\n");
#endif	/* USE_DBM || USE_NDBM*/

	exit (-8);
} /* end of usage () */

/*************************************************************************
 *
 *	Function: wait_action
 *
 *	Purpose: Utility AATV which always responds tenatively...
 *		 until the counter runs to zero.
 *
 *************************************************************************/

static int
wait_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	char            log_msg[1024];
	char            log_guard[256];
	static char    *func = "wait_action";

	dprintf(4, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if (authreq != (AUTH_REQ *) NULL)
	{
		if (value > 0)
		{
			if (authreq->retry_cnt >= value)
			{
			  	return EV_ACK;
			}

			if (authreq->retry_cnt == 0)
			{
				packet_log (log_msg, authreq, 0);
				logit (LOG_DAEMON, LOG_INFO,
					"%s: %s", func, log_msg);
			}
		}
	}

	return EV_WAIT;

} /* end of wait_action () */
