/*
 *
 *	RADIUS
 *	Remote Authentication Dial In User Service
 *
 *
 *	Livingston Enterprises, Inc.
 *	6920 Koll Center Parkway
 *	Pleasanton, CA   94566
 *
 *	Copyright 1992 Livingston Enterprises, Inc.
 *
 *	Permission to use, copy, modify, and distribute this software for any
 *	purpose and without fee is hereby granted, provided that this
 *	copyright and permission notice appear on all copies and supporting
 *	documentation, the name of Livingston Enterprises, Inc. not be used
 *	in advertising or publicity pertaining to distribution of the
 *	program without specific prior permission, and notice be given
 *	in supporting documentation that copying and distribution is by
 *	permission of Livingston Enterprises, Inc.
 *
 *	Livingston Enterprises, Inc. makes no representations about
 *	the suitability of this software for any purpose.  It is
 *	provided "as is" without express or implied warranty.
 *
 *      Copyright (c) 1996 Ascend Communications, Inc.
 *      All rights reserved.
 *
 *      Permission to copy, display, distribute and make derivative works
 *      from this material in whole or in part for any purpose is granted
 *      provided that the above copyright notice and this paragraph are
 *      duplicated in all copies.  THIS SOFTWARE IS PROVIDED "AS IS" AND
 *      WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT
 *      LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *      FOR A PARTICULAR PURPOSE.
 *
 */

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

static char     sccsid[] =
		"@(#)radpass.c	1.2 Copyright 1992 Livingston Enterprises Inc";

static char     rcsid[] = "$Id: radpass.c,v 1.3 1998/07/06 17:43:31 web Exp $";

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/param.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<memory.h>
#include	<netdb.h>

#include	"radius.h"

#define MAXPWNAM	8

UINT2           send_buffer_size = RAD_SEND_BUFFER_SIZE;
u_char          recv_buffer[RAD_RECV_BUFFER_SIZE];
u_char          send_buffer[RAD_SEND_BUFFER_SIZE];
char            ourhostname[MAXHOSTNAMELEN];
char           *progname;
char           *radius_dir;
int             debug_flag = 0;
int             dumpcore = 0;
int             file_logging = 2;   /* 0 => syslog, 1 => logfile, 2 => stderr */
int             zap_logfile = 0;
int             authfile_cnt = 0;
int             clients_cnt = 0;
int             users_cnt = 0;
time_t          birthdate;
AATVPTR		rad_authen_aatv = (AATV *) NULL;
AATVPTR         rad_ipc_aatv = (AATV *) NULL;
AATV           *authtype_tv[PW_AUTH_MAX + 1];
FILE           *ddt = NULL;
FILE           *msgfd = stderr;

static u_char   vector[AUTH_VECTOR_LEN];
static u_char   oldpass[AUTH_PASS_LEN];
static void     radpass_usage ();
static void     result_recv ();

int
main (argc, argv)

int             argc;
u_char         *argv[];

{
	int             salen;
	int             result;
	int             sockfd;
	struct sockaddr salocal;
	struct sockaddr saremote;
	struct sockaddr_in *sin;
	struct servent *svp;
	u_short         svc_port;
	AUTH_HDR       *auth;
	u_char         *username;
	u_char          newpass1[AUTH_PASS_LEN];
	u_char          newpass2[AUTH_PASS_LEN];
	u_char	       *rv;
	UINT4           auth_ipaddr;
	u_short         local_port;
	int             total_length;
	char           *getpass ();
	int             length;

	progname = (char *) argv[0];
	radius_dir = RADIUS_DIR;

	if (argc != 2)
	{
		radpass_usage ();
	}
	/* Get the user name */
	username = argv[1];

	svp = getservbyname ("radius", "udp");
	if (svp == (struct servent *) 0)
	{
		fprintf (stderr, "No such service: %s/%s\n", "radius", "udp");
		exit (-1);
	}
	svc_port = ntohs(svp->s_port);

	/* Get the IP address of the authentication server */
	if ((auth_ipaddr = get_ipaddr ("radius-server")) == (UINT4) 0)
	{
		fprintf (stderr, "Couldn't find host radius-server\n");
		exit (-1);
	}

	sockfd = socket (AF_INET, SOCK_DGRAM, 0);
	if (sockfd < 0)
	{
		(void) perror ("socket");
		exit (-1);
	}

	sin = (struct sockaddr_in *) & salocal;
	memset ((char *) sin, '\0', sizeof (salocal));
	sin->sin_family = AF_INET;
	sin->sin_addr.s_addr = INADDR_ANY;

	local_port = 1025;
	do
	{
		local_port++;
		sin->sin_port = htons((u_short) local_port);
	} while ((bind (sockfd, (struct sockaddr *) sin,
			sizeof (struct sockaddr)) < 0) &&
		local_port < 64000);
	if (local_port >= 64000)
	{
		close (sockfd);
		(void) perror ("bind");
		exit (-1);
	}

	printf ("Changing Password for user %s\n", username);

	/* Get their old password */
	strcpy ((char *) oldpass, getpass ("Old Password:"));
	if (*oldpass == '\0')
	{
		exit (0);
	}

	/* Get their new password */
	strcpy ((char *) newpass1, getpass ("New Password:"));
	if (*newpass1 == '\0')
	{
		exit (0);
	}

	/* Get their new password again */
	strcpy ((char *) newpass2, getpass ("Re-type New Password:"));
	if (strcmp ((char *) newpass1, (char *) newpass2) != 0)
	{
		printf ("New Passwords didn't match\n");
		exit (-1);
	}

	/* Build a password change request */
	auth = (AUTH_HDR *) send_buffer;
	rv = (u_char *) build_header (VER1, (char *) NULL, 
					PW_PASSWORD_REQUEST, 0, auth, NULL);
	memcpy ((char *) vector, (char *) rv, sizeof (vector));

	/* User Name */
	length = strlen ((char *) username);
	if (length > MAXPWNAM)
	{
		length = MAXPWNAM;
	}
	attribute_out (auth, send_buffer_size, PW_USER_NAME, 0, username,
			length, 0, (VENDOR_LIST *) NULL);

	/* New Password */
	attribute_pw_out (auth, send_buffer_size, (char *) newpass1,
			 (char *) oldpass);
	total_length = attribute_pw_out (auth, send_buffer_size,
					(char *) oldpass, (char *) oldpass);

	sin = (struct sockaddr_in *) & saremote;
	memset ((char *) sin, '\0', sizeof (saremote));
	sin->sin_family = AF_INET;
	sin->sin_addr.s_addr = htonl(auth_ipaddr);
	sin->sin_port = htons(svc_port);

	sendto (sockfd, (char *) auth, (int) total_length, (int) 0,
		(struct sockaddr *) sin, sizeof (struct sockaddr_in));

	salen = sizeof (saremote);
	result = recvfrom (sockfd, (char *) recv_buffer,
			   (int) sizeof (recv_buffer),
			   (int) 0, &saremote, &salen);

	if (result > 0)
	{
		result_recv (recv_buffer, result);
		exit (0);
	}
	(void) perror ("recv");
	close (sockfd);
	exit (0);
} /* end of main () */

static void
result_recv (buffer, length)

u_char         *buffer;
int             length;

{
	AUTH_HDR1      *auth;
	int             totallen;
	u_char          reply_digest[AUTH_VECTOR_LEN];
	u_char          calc_digest[AUTH_VECTOR_LEN];
	int             secretlen;

	auth = (AUTH_HDR1 *) buffer;
	totallen = ntohs(auth->length);

	if (totallen != AUTH_HDR1_LEN)
	{
		printf ("Received invalid reply length from server\n");
		exit (-1);
	}

	/* Verify the reply digest */
	memcpy ((char *) reply_digest, (char *) auth->vector, AUTH_VECTOR_LEN);
	memcpy ((char *) auth->vector, (char *) vector, AUTH_VECTOR_LEN);
	secretlen = strlen ((char *) oldpass);
	memcpy ((char *) buffer + AUTH_HDR1_LEN, (char *) oldpass, secretlen);
	md5_calc (calc_digest, (char *) auth, AUTH_HDR1_LEN);

	if (memcmp ((char *) reply_digest, (char *) calc_digest,
		    AUTH_VECTOR_LEN) != 0)
	{
		printf ("Warning: Received invalid reply digest from server\n");
	}

	if (auth->code == PW_PASSWORD_ACK)
	{
		printf ("Password successfully changed\n");
	}
	else
	{
		printf ("Request Denied\n");
	}
	return;
} /* end of result_recv () */

static void
radpass_usage ()
{
	printf ("Usage: %s username\n", progname);
	exit (-1);
} /* end of radpass_usage () */
