/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

static char     rcsid[] = "$Id: radpwtst.c,v 1.3 1998/07/06 16:34:20 web Exp $";

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/param.h>
#include	<netinet/in.h>
#include	<sys/time.h>
#include	<sys/signal.h>

#ifdef	aix
#include	<sys/termio.h>
#else	/* aix */
#include	<sys/termios.h>
#endif	/* aix */

#ifdef	SVR4
#include	<sys/systeminfo.h>
#endif	/* SVR4 */

#include	<netdb.h>
#include	<pwd.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>

#include	"radius.h"

#ifndef RESPONSE_TIMEOUT
#define RESPONSE_TIMEOUT 3
#endif

#ifndef MAX_RETRIES
#define MAX_RETRIES	10
#endif

UINT2           send_buffer_size = RAD_SEND_BUFFER_SIZE;
char            recv_buffer[RAD_RECV_BUFFER_SIZE];
char            send_buffer[RAD_SEND_BUFFER_SIZE];
char            ourhostname[MAXHOSTNAMELEN];
char           *progname;
char           *radius_dir;
int             debug_flag = 0;
int             dumpcore = 0;
int             file_logging = 2;   /* 0 => syslog, 1 => logfile, 2 => stderr */
int             zap_logfile = 0;
int             authfile_cnt = 0;
int             clients_cnt = 0;
int             users_cnt = 0;
time_t          birthdate;
AATVPTR		rad_authen_aatv = (AATV *) NULL;
AATVPTR         rad_ipc_aatv = (AATV *) NULL;
AATV           *authtype_tv[PW_AUTH_MAX + 1];
FILE           *ddt = NULL;
FILE           *msgfd = stderr;
extern void     dir_init();

static void     radpwtst_usage ();

typedef struct string_list_struct
{
	struct string_list_struct *next;
	char                      *str;
} string_list;

static char *
rad_getpass (prompt)

char           *prompt;

{
	int             ch;
	char           *p;
	FILE           *infp;
	FILE           *outfp;
	sigset_t        newset;
	sigset_t        oldset;

#ifdef	TCSAFLUSH
typedef	struct termios  TERM_STRUCT;
#define	GET_TTY(x,y)    tcgetattr(x,y)
#define	SET_TTY(x,y)    tcsetattr(x,TCSAFLUSH,y)
#else	/* TCSAFLUSH */
typedef	struct termio   TERM_STRUCT;
#define	GET_TTY(x,y)    ioctl(x,TCGETA,y)
#define	SET_TTY(x,y)    ioctl(x,TCSETAF,y)
#endif	/* TCSAFLUSH */

	TERM_STRUCT     term;
	TERM_STRUCT     termsave;
	static char     buf[AUTH_PASS_LEN + 1];

	infp = stdin;
	outfp = stderr;

	sigemptyset (&newset);  /* block SIGINT and SIGTSTP, save signal mask */
	sigaddset (&newset, SIGINT);
	sigaddset (&newset, SIGTSTP);
	sigprocmask (SIG_BLOCK, &newset, &oldset);

	GET_TTY(fileno(infp), &termsave);
	term = termsave;			/* copy the entire structure */
	term.c_lflag &= ~(ECHO | ECHOE | ECHOK | ECHONL); /* turn off echoing */
	SET_TTY(fileno(infp), &term);

	fputs (prompt, outfp);
	rewind (outfp);				/* implied flush */

	p = buf;
	while (((ch = getc (infp)) != EOF) && (ch != '\n'))
	{
		if (p < buf + AUTH_PASS_LEN)
		{
			*p++ = ch;
		}
	}
	*p = '\0';				/* null terminated password */

	write (fileno (outfp), "\n", 1);	/* echo one newline */

	SET_TTY(fileno(infp), &termsave);

	sigprocmask (SIG_SETMASK, &oldset, NULL);

	return (buf);
} /* end of rad_getpass () */

int
main (argc, argv)

int             argc;
char           *argv[];

{
	int             acks = 0;	/* ACKs to ignore */
	int             result;
	int             retries;
	int             new_old;
	int             zero = 0;
	char           *clear_pw = (char *) NULL;
	char           *client_name = (char *) NULL;
  	char	       *ptr;
	string_list    *vplist = NULL;  /* For '-:' option(s) */
	string_list   **vpnext = &vplist; /* For '-:' option */
	char            passwd[AUTH_PASS_LEN + 1];
	char            msg[4096]; /* big enough to hold several messages */
	SEND_DATA       data;

	/*
	 *	Determine what program we're running as...
	 *	Strip off the path (if any).
	 */
	progname = *argv;
	for (ptr = progname; *ptr != '\0'; ptr++)
	{
		if (*ptr == '/')
		{
			progname = ptr + 1;
		}
	}

	/* Set up some defaults */
	data.version = 0;
	data.server = "";	/* SendServer picks server, if need be */
	radius_dir = "";	/* SendServer picks directory, if need be */
	data.timeout = RESPONSE_TIMEOUT;
	data.user_file = (char *) NULL;
	data.send_pairs = NULL_VP;
	data.receive_pairs = NULL_VP;
	data.group = (char *) NULL;
	data.arades = 0;
	data.challenge = 0;
	data.password = (char *) NULL;
	data.user_name = (char *) NULL;
	data.client_id = 0;

	retries = MAX_RETRIES;	/* Try for response this many times */
	new_old = 0;		/* Assume old style */
	data.ustype = 0;
	data.fptype = 0;	/* by default */
	data.svc_port = 0;	/* Late binding */

	if (strcmp (progname, "radsend") == 0)
	{
		data.code = PW_ACCESS_REQUEST;
		data.port_num = -1; /* Don't let send_server() force to one */
		data.ustype = -1;
		data.client_id = (UINT4) -1;
		new_old = 1;		/* New style, where that counts. */
	}
	else
	{
		data.port_num = 1; /* Just default to port number one here */
		if (strcmp (progname, "radacct") == 0)
		{
			data.code = PW_ACCOUNTING_REQUEST;
		}
		else /* radpwtst, classic. */
		{
			data.code = PW_ACCESS_REQUEST;
		}
	}

#ifdef	SVR4
	if (sysinfo (SI_HOSTNAME, ourhostname, sizeof (ourhostname)) < 0)
	{
		perror ("SI_HOSTNAME");
		exit (-1);
	}
#else	/* Assume BSD */
	if (gethostname (ourhostname, sizeof (ourhostname)) < 0)
	{
		perror ("gethostname");
		exit (-1);
	}
#endif	/* SVR4 */

	/* Check command args */
	while (--argc > 0 && *(*++argv) == '-')
	{
		/* switch on char. after "-" */
		ptr = *argv + 1;
		switch (*ptr++)
		{
		    case 'a':	/* "ACKs to ignore" */
			if (--argc <= 0)
			{
				printf ("bad or no count of ACKs to ignore\n");
				radpwtst_usage ();
			}
			argv++;
			acks = atoi (*argv);
			break;

		    case 'c':	/* "Packet Code" */
			if (--argc == 0)
			{
				radpwtst_usage ();
				printf ("packet code\n");
			}
			argv++;
			data.code = atoi (*argv);
			break;

		    case 'd':	/* "Directory" */
			if (--argc == 0)
			{
				radpwtst_usage ();
				printf ("directory\n");
			}
			argv++;
			radius_dir = *argv;	/* Use specified directory */
			break;

		    case 'f':	/* "Users" file */
			if (--argc == 0)
			{
				radpwtst_usage ();
				printf ("users file\n");
			}
			argv++;
			data.user_file = *argv;
			break;

		    case 'g':	/* "Users" group */
			if (--argc == 0)
			{
				radpwtst_usage ();
				printf ("users group\n");
			}
			argv++;
			data.group = *argv;
			break;

		    case 'h':	/* "Help" message */
			radpwtst_usage ();
			argv++;
			break;

		    case 'i':   /* Client-Id */
			if (--argc == 0)
			{
				radpwtst_usage ();
			}
			argv++;
			client_name = *argv;
			break;

		    case 'l':	/* async-line */
			if (--argc == 0)
			{
				radpwtst_usage ();
				printf ("async-line\n");
			}
			argv++;
			sscanf (*argv, "%u", &data.port_num);
			break;

		    case 'n':
			new_old = 1;
			break;

		    case 'p':	/* UDP-port */
			if (--argc == 0)
			{
				radpwtst_usage ();
				printf ("udp port\n");
			}
			argv++;
			sscanf (*argv, "%u", &data.svc_port);
			break;

		    case 'r':   /* Retries */
			if (--argc == 0)
			{
				radpwtst_usage ();
				printf ("retries\n");
			}
			argv++;
			sscanf (*argv, "%u", &retries);
			break;

		    case 's':	/* "Server name" */
			if (--argc == 0)
			{
				radpwtst_usage ();
				printf ("server\n");
			}
			argv++;
			data.server = *argv;
			break;

		    case 't':   /* Timeout */
			if (--argc == 0)
			{
				radpwtst_usage ();
				printf ("timeout\n");
			}
			argv++;
			sscanf (*argv, "%u", &data.timeout);
			break;

		    case 'u':	/* "Service Type" */
			if (--argc == 0)
			{
				radpwtst_usage ();
				printf ("service type\n");
			}
			argv++;
			if (strcasecmp (*argv, "auth") == 0)
			{
				if (new_old == 1) /* new style */
				{
					data.ustype = PW_AUTHENTICATE_ONLY;
				}
				else /* old style */
				{
					data.ustype = PW_OUTBOUND_USER;
				}
			}

#ifdef ASCEND
			else if (strcasecmp (*argv, "arades") == 0)
			{
				data.ustype = PW_FRAMED;
				data.fptype = ASCEND_ARA;
				data.arades = 1;
			}
#endif	/* ASCEND */

			else if (strcasecmp (*argv, "challenge") == 0)
			{
				data.challenge = 1;	/* Challenge/response */
			}
			else if (strcasecmp (*argv, "chap") == 0)
			{
				data.ustype = 255;	/* for testing chap */
				data.fptype = PW_PPP;
			}
			else if (strcasecmp (*argv, "dumb") == 0)
			{
				data.ustype = PW_LOGIN;
			}
			else if (strcasecmp (*argv, "slip") == 0)
			{
				data.ustype = PW_FRAMED;
				data.fptype = PW_SLIP;
			}
			else if (strcasecmp (*argv, "ppp") == 0)
			{
				data.ustype = PW_FRAMED;
				data.fptype = PW_PPP;
			}
			else if (strcasecmp (*argv, "dbdumb") == 0)
			{
				data.ustype = PW_CALLBACK_LOGIN;
			}
			else if (strcasecmp (*argv, "dbslip") == 0)
			{
				data.ustype = PW_CALLBACK_FRAMED;
				data.fptype = PW_SLIP;
			}
			else if (strcasecmp (*argv, "dbppp") == 0)
			{
				data.ustype = PW_CALLBACK_FRAMED;
				data.fptype = PW_PPP;
			}
			else if (strcasecmp (*argv, "outbound") == 0)
			{
				data.ustype = PW_OUTBOUND_USER;
			}
			else if (strcasecmp (*argv, "admin") == 0)
			{
				data.ustype = PW_ADMINISTRATIVE_USER;
			}
			else if (strcasecmp (*argv, "exec") == 0)
			{
				data.ustype = PW_SHELL_USER;
			}
			else if (strcasecmp (*argv, "dbadmin") == 0)
			{
				data.ustype = PW_CALLBACK_ADMIN_USER;
			}
			else
			{
				radpwtst_usage ();
			}
			break;

		    case 'v':	/* version */
			if (*ptr == '\0')
			{
				if (--argc == 0)
				{
					fprintf (stderr,
						"Version %s\n", verinfo (2));
					radpwtst_usage ();
				}
				argv++;
				ptr = *argv;
			}
			if (strcmp (ptr, "2") == 0)
			{
				data.version = 2;
			}
			else if (strcmp (ptr, "1") == 0)
			{
				data.version = 1;
			}
			else
			{
				radpwtst_usage ();
			}
				
			break;

		    case 'w':	/* password */
			if (--argc == 0)
			{
				radpwtst_usage ();
				printf ("password\n");
			}
			argv++;
			clear_pw = *argv;
			break;

		    case 'X':
			debug_flag++;
			ddt = stderr;
			msgfd = fdopen (dup (fileno (stderr)), "w");
			file_logging = 1;
			break;

		    case 'x':
			debug_flag++;
			ddt = stderr;
			break;

		    case ':':		/* Send arbirary A/V pairs */
			*vpnext = (string_list *) malloc (sizeof (string_list));
			(*vpnext)->str = *argv + 2;
			(*vpnext)->next = (string_list *) NULL;
			vpnext = &((*vpnext)->next);
			break;

		    case '0':
			zero = 1;
			break;

		    default:
			fprintf (stderr, "%s: Invalid option, '%s'\n",
				progname, *argv);
			radpwtst_usage ();
		}
	}

	if (zero == 0)
	{
		printf ("Merit AAA server %s, licensed software\n", verinfo (2));
		printf ("COPYRIGHT 1992, 1993, 1994, 1995, 1996, 1997, 1998\n");
		printf ("THE REGENTS OF THE UNIVERSITY OF MICHIGAN\n");
		printf ("ALL RIGHTS RESERVED\n");
		printf ("\n");

#ifdef BASIC_SERVER
		printf (
"PERMISSION IS GRANTED TO USE, COPY AND REDISTRIBUTE THIS VERSION OF THE MERIT\n");
		printf (
"BASIC AAA SERVER, SO LONG AS NO FEE IS CHARGED FOR THIS SOFTWARE, AND SO LONG\n");
		printf (
"AS THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND THE DISCLAIMER\n");
		printf (
"BELOW APPEAR IN ALL COPIES MADE; AND SO LONG AS THE NAME OF THE UNIVERSITY OF\n");
		printf (
"MICHIGAN OR MERIT NETWORK IS NOT USED IN ANY ADVERTISING OR PUBLICITY\n");
		printf (
"PERTAINING TO THE USE OR DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC,\n");
		printf (
"WRITTEN PRIOR AUTHORIZATION.\n");
		printf ("\n");
		printf (
"NO RIGHTS ARE GRANTED HEREUNDER FOR ANY RECIPIENT TO MODIFY, DISASSEMBLE,\n");
		printf (
"DECOMPILE, REVERSE ENGINEER OR OTHERWISE CREATE DERIVATIVE WORKS OF THIS\n");
		printf (
"SOFTWARE.\n");
		printf ("\n");
		printf (
"THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION FROM THE UNIVERSITY\n");
		printf (
"OF MICHIGAN AS TO ITS FITNESS FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE\n");
		printf (
"UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING\n");
		printf (
"WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n");
		printf (
"A PARTICULAR PURPOSE.  THE REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE\n");
		printf (
"LIABLE FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR\n");
		printf (
"CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT OF OR IN\n");
		printf (
"CONNECTION WITH THE USE OF THE SOFTWARE, EVEN IF IT HAS BEEN OR IS HEREAFTER\n");
		printf (
"ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n");
		printf ("\n");
		printf (
"FOR FURTHER INFORMATION ABOUT THE ENHANCED MERIT AAA SERVER, SEND EMAIL TO:\n");
		printf (
"aaa.license@merit OR, VISIT THE WWW SITE:  www.merit.edu/aaa/\n");
		printf ("\n");
#endif	/* BASIC_SERVER */

	}

	/* Plain authentication request ==> PW_AUTHENTICATE_ONLY */
	if (data.ustype == 0)
	{
		if (new_old == 1) /* new style */
		{
			data.ustype = PW_AUTHENTICATE_ONLY;
		}
		else /* old style */
		{
			data.ustype = PW_OUTBOUND_USER;
		}
	}

	/* Get the user name */
	if (argc == 1)
	{
		data.user_name = argv[0];
	}
	else
	{
		radpwtst_usage ();
	}

	dir_init ();

	if (dict_init () != 0)
	{
		exit (-1);
	}

	/* Process saved A/V pairs. */
	for ( ; vplist ; vplist = vplist->next)
	{
		if (pair_parse (vplist->str, &data.send_pairs,
				(VALUE_PAIR **) NULL) != 0)
		{
			fprintf (stderr,
				"%s: Invalid attribute-value pair, '%s'\n",
				progname, vplist->str);
			radpwtst_usage ();
		}
	}

	if (data.code == PW_ACCOUNTING_REQUEST)
	{
		data.password = "";
	}
	else /* get a password from somewhere */
	{
		if (clear_pw == (char *) NULL) /* Get the password */
		{
			if ((clear_pw = rad_getpass ("Password:"))
							== (char *) NULL)
			{
				exit (-1);
			}

			strncpy (passwd, clear_pw, sizeof (passwd));
			data.password = passwd;
		}
		else /* Use the password from the command line (-w) */
		{
			data.password = clear_pw;
		}
	}

	srand (time (0));	/* Use random sequence number in request */
	data.seq_nbr = (u_short) rand ();

#ifdef	SVR4
	if (sysinfo (SI_HOSTNAME, ourhostname, sizeof (ourhostname)) < 0)
	{
		perror ("SI_HOSTNAME");
		exit (-1);
	}
#else	/* Assume BSD */
	if (gethostname (ourhostname, sizeof (ourhostname)) < 0)
	{
		perror ("gethostname");
		exit (-1);
	}
#endif	/* SVR4 */

	if (client_name == (char *) NULL)
	{
		if (data.client_id == 0)
		{
			if ((data.client_id = get_ipaddr (ourhostname)) == 0)
			{
				printf ("%s: Couldn't get own IP address!\n",
					progname);
				data.client_id = 0;
			}
		}
	}
	else /* use name from -i command line option */
	{
		data.client_id = get_ipaddr (client_name);
	}

	if ((data.user_file != (char *) NULL) && (data.group == (char *) NULL))
	{
		data.group = "DEFAULT";
	}

	if (data.svc_port == 0)
	{
		switch (data.code)
		{
		    case PW_ACCESS_REQUEST:
		    default:
			data.svc_port = PW_AUTH_UDP_PORT;
			break;

		    case PW_ACCOUNTING_REQUEST:
			data.svc_port = PW_ACCT_UDP_PORT;
			break;
		}
	}

	msg[0] = '\0';

	do
	{
		list_free (data.receive_pairs);
		data.receive_pairs = NULL_VP;
		result = send_server (&data, &retries, msg);
		sleep (data.timeout);
	} while (acks-- > 0);

	if (result == OK_RC)
	{
		if (data.result == PW_ACCESS_CHALLENGE)
		{
			printf ("ACCESS_CHALLENGE received\n");
			if (msg[0])
			{
				printf ("%s\n", msg);
				msg[0] = '\0';
			}

			if ((clear_pw = rad_getpass ("Challenge response: "))
							== (char *) NULL)
			{
				exit (-1);
			}

			strncpy (passwd, clear_pw, sizeof (passwd));
			data.password = passwd;

			msg[0] = '\0';
			data.code = PW_ACCESS_REQUEST;
			data.challenge = 0;	/* Leave current state intact */
			avpair_del(&data.send_pairs, PW_REPLY_MESSAGE, 0);
			data.seq_nbr++;
			result = send_server (&data, &retries, msg);
			printf ("Data.result: %d\n", data.result);
		}

#ifdef ASCEND
		if (data.result == PW_PASSWORD_EXPIRED)
		{
			printf ("'%s' authentication failed expired password",
				data.user_name);
		}
		else
#endif	/* ASCEND */

		{
			if (data.result == PW_ACCESS_REJECT)
			{
				printf ("'%s' authentication failed",
					data.user_name);
				
			}
			else
			{
				printf ("'%s' authentication OK",
					data.user_name);
			}
		}
	}
	else
	{
		printf ("'%s' authentication failed", data.user_name);
		if (result != BADRESP_RC)
		{
			printf ("(RC=%i)", result);
		}
	}

	send_server_done ();

	if (msg[0])
	{
		printf (": %s", msg);
	}

	putchar('\n');
	exit (result);
} /* end of main () */

static void
radpwtst_usage ()

{
	printf ("Usage: %s [-a ACKs] [-c code] [-d directory] [-f file]\n",
		progname);
	printf ("\t[-g group] [-h] [-i client-id] [-l async port] [-n]\n");
	printf ("\t[-p UDP-port] [-r retries] [-s server] [-t timeout]\n");
	printf ("\t[-u type] [-v version] [-w password] [-x] accessID\n");
	printf ("Codes: Access-Request = 1\n");
	printf ("       Accounting-Request = 4\n");
	printf ("       Password = 7\n");
	printf ("       Status-Server = 12\n");
	printf ("Types: challenge, chap, dumb, slip, ppp, arades, dbdumb,\n");
	printf ("       dpslip, dbppp, outbound, admin, exec, dbadmin\n");
	exit (-1);
} /* end of radpwtst_usage () */
