#ifdef USR_CCA

/*
 *
 * Copyright (c) 1996 U.S. Robotics, Access Corp.
 * All rights reserved.
 *
 * Permission to copy, display, distribute and make derivative works
 * from this material in whole or in part for any purpose is granted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all copies.  THIS SOFTWARE IS PROVIDED "AS IS" AND
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * If providing code not subject to a copyright please indicate that the
 * code has been dedicated to the public.
 *
 */

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

static char     rcsid[] = "$Id: rf_resp.c,v 1.2 1998/06/11 18:41:01 web Exp $";

/***************************************************************************
 *
 *      This file defines the Resource Free Response AATV
 *
 ***************************************************************************/

#include        <sys/param.h>
#include        <sys/types.h>
#include        <sys/socket.h>
#include        <netinet/in.h>
#include        <arpa/inet.h>
#include        <sys/ioctl.h>
#include        <sys/file.h>
#include        <sys/time.h>
#include        <sys/file.h>
#include        <sys/wait.h>
#include        <sys/stat.h>
#include        <net/if.h>

#include        <stdio.h>
#include        <stdlib.h>
#include        <netdb.h>
#include        <fcntl.h>
#include        <errno.h>
#include        <signal.h>
#include        <syslog.h>

#include	"radius.h"

extern int      debug_flag;

/****************************************************************************
 *
 *                      rad_rf_resp_aatv definition
 *
 ***************************************************************************/

static int rad_rf_resp_action PROTO ((AUTH_REQ *, int, char *));

static AATV     rf_resp_aatv = DEF_AATV_DIRECT("RES_FREE_RESP",
							rad_rf_resp_action);
AATVPTR         rad_rf_resp_aatv = &rf_resp_aatv;

/**************************************************************************
 *
 *      Function: rad_rf_resp_action
 *
 *      Purpose: Processe the Resource Free Response.
 *
 *************************************************************************/

static int
rad_rf_resp_action (authreq, value, afpar)

AUTH_REQ       *authreq;
int             value;
char           *afpar;

{
	VALUE_PAIR     *vp;
	AATV           *paatv;
	char           *func = "rad_rf_resp_action";

	dprintf (2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((vp = get_vp (authreq->cur_request, PW_NAS_IP_ADDRESS))
							== (VALUE_PAIR *) NULL)
	{
		return EV_NAK;
	}

	authreq->ipaddr = vp->lvalue;
	authreq->fsmstatus = EV_ACK;
	paatv = find_aatv ("REPLY");
	call_action (paatv, authreq, 0, "");
	return EV_ACK;
} /* end of rad_rf_resp_action () */

#endif	/* USR_CCA */
