#if !defined (USR_H)
#define	USR_H

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

/*
 *
 * Copyright (c) 1996 U.S. Robotics, Access Corp.
 * All rights reserved.
 *
 * Permission to copy, display, distribute and make derivative works
 * from this material in whole or in part for any purpose is granted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all copies.  THIS SOFTWARE IS PROVIDED "AS IS" AND
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * If providing code not subject to a copyright please indicate that the
 * code has been dedicated to the public.
 *
 */

/*
 * $Id: usr.h,v 1.2 1998/06/11 18:40:24 web Exp $
 */

#define PW_IP_INPUT_FILTER		0x9000	/* string */
#define PW_IPX_INPUT_FILTER		0x9001	/* string */
#define PW_SAP_INPUT_FILTER		0x9002	/* string */
#define PW_IP_OUTPUT_FILTER		0x9003	/* string */
#define PW_IPX_OUTPUT_FILTER		0x9004	/* string */
#define PW_SAP_OUTPUT_FILTER		0x9005	/* string */
#define PW_USR_VPN_ID			0x9006	/* integer */
#define PW_USR_VPN_NAME			0x9007	/* string */
#define PW_USR_VPN_NEIGHBOR		0x9008	/* ipaddr */
#define PW_RIP_V2			0x9009	/* integer */
#define PW_USR_VPN_GATEWAY		0x900a	/* string */
#define PW_USR_AUTH_VECTOR		0x900b	/* string */
#define PW_USR_RQ_INDEX			0x900c	/* integer */
/* #define PW_USR_UNUSED		0x900d	 * ???? */
#define PW_USR_PACKET			0x900e	/* string */
#define PW_PRIMARY_DNS_SERVER		0x900f	/* ipaddr */
#define PW_SECONDARY_DNS_SERVER		0x9010	/* ipaddr */
#define PW_PRIMARY_NBNS_SERVER		0x9011	/* ipaddr */
#define PW_SECONDARY_NBNS_SERVER	0x9012	/* ipaddr */
#define PW_SYSLOG_TAP			0x9013	/* integer */
#define PW_USR_MIC			0x9014	/* string */
/* #define PW_USR_UNUSED		0x9015	 * ???? */
/* #define PW_USR_UNUSED		0x9016	 * ???? */
#define PW_LOG_FILTER_PACKET		0x9017	/* integer */
/* #define PW_USR_UNUSED		0x9018	 * ???? */
#define PW_CHASSIS_CALL_SLOT		0x9019	/* integer */
#define PW_CHASSIS_CALL_SPAN		0x901a	/* integer */
#define PW_CHASSIS_CALL_CHANNEL		0x901b	/* integer */
#define PW_KEYPRESS_TIMEOUT		0x901c	/* integer */
#define PW_UNAUTHENTICATED_TIME		0x901d	/* integer */
#define PW_VPN_ENCRYPTER		0x901e	/* string */
#define PW_ACCT_VPN_GATEWAY		0x901f	/* string */
#define PW_RE_CHAP_TIMEOUT		0x9020	/* integer */

#define	VC_USR				429
#define	VPN_NAME_LEN			16
#define	VPN_NEIGHBOR_LEN		32
#define	INVALID_VPN			-1
#define	VPN				"vpn"
#define	FILTER				"filter"
#define	VPN_NEIGHBOR			"neighbor"
#define	VPN_GATEWAY			"gateway"
#define	VPN_NAME			"name"
#define	APOOL_NAME_LEN			16
#define	SESSIONS_ALLOWED		"Sessions-Allowed"
#define	ADDRESS_POOL			"Address-Pool"
#define	FRAMED_IP_ADDR_POOL_NAME	"Framed-IP-Address-Pool-Name"
#define	ASSIGNED			"Assigned"
#define	PW_PACKET_SIZE			256
#define	SELF_IP_LEN			11
#define	FALSE				0
#define	TRUE				1
#define	USR_PARENT			1
#define	USR_CHILD			2
#define	USR_PROXY			4
#define	NO_TUNNEL_REF			-1
#define	MAX_VPN_GATEWAY_LEN		25
/*
 *	octet 0 == 0x01
 *	octets 1 through 4 == Gateway
 *	address octets 5 and 6  == Tunnel-Refresh (optional)
 */
#define	VPN_GATEWAY_FORMAT	0x01
#define	GATEWAY_FORMAT_LEN	1
#define	INT_LEN			4	/* Integer length in an attribute */
#define	IP_ADDR_LEN		4	/* IP Address length in an attribute */
#define	TUNNEL_REF_LEN		2
#define	GATEWAYS_ONLY		1	/* Used when parsing Local-VPN type
					 * in authfile */
#define	SESSION_KEY_LEN		16
#define	MANAGE_RESOURCES	2	/* Termination-Action value for
					 * managing resources */

/* Client Entry States */
#define	NO_RQ_RESP		1
#define	QUERY_IN_PROGRESS	2
#define	GOT_RQ_RESP		3
#define	TEST_GOT		4	/* This flag causes the send_client()
					 * function to test the value of the
					 * client's state flag, and set it to
					 * NO_RQ_RESP, if not GOT_RQ_RESP */

#define	DEFAULT_ID		0x00000000	/* For standard RADIUS
						 * attributes */
#define	VENDOR_ID_LENGTH	4	/* Organization(Vendor) ID length in
					 * octets */
#define	SUB_ID_LENGTH		0	/* Length of the subidentifier in
					 * Vendor Specific attributes */
#define	ASSIGN_IP_ADDR		-1	/* Framed-IP-Address av pair has
					 * lvalue initially set to this if
					 * the user is to be assigned an
					 * address from the address pool */
#define	OUT_OF_ADDRESSES	-1
#define	DEF_POOL_NAME		"No_Pool"	/* Address Pool name for
						 * users that are statically
						 * assigned Framed IP
						 * addresses */

#endif	/* USR_H */
