/*
 *
 *	RADIUS -- Remote Authentication Dial In User Service
 *
 *
 *	Livingston Enterprises, Inc.
 *	6920 Koll Center Parkway
 *	Pleasanton, CA   94566
 *
 *	Copyright 1992 Livingston Enterprises, Inc.
 *
 *	Permission to use, copy, modify, and distribute this software for any
 *	purpose and without fee is hereby granted, provided that this
 *	copyright and permission notice appear on all copies and supporting
 *	documentation, the name of Livingston Enterprises, Inc. not be used
 *	in advertising or publicity pertaining to distribution of the
 *	program without specific prior permission, and notice be given
 *	in supporting documentation that copying and distribution is by
 *	permission of Livingston Enterprises, Inc.
 *
 *	Livingston Enterprises, Inc. makes no representations about
 *	the suitability of this software for any purpose.  It is
 *	provided "as is" without express or implied warranty.
 *
 *
 *      Copyright (c) 1996 Ascend Communications, Inc.
 *      All rights reserved.
 *
 *      Permission to copy, display, distribute and make derivative works
 *      from this material in whole or in part for any purpose is granted
 *      provided that the above copyright notice and this paragraph are
 *      duplicated in all copies.  THIS SOFTWARE IS PROVIDED "AS IS" AND
 *      WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT
 *      LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *      FOR A PARTICULAR PURPOSE.
 *
 */

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

/*
 *
 *      Public entry points in this file:
 *
 *      verinfo
 */

static char     sccsid[] =
		"@(#)version.c	1.1 Copyright 1992 Livingston Enterprises Inc";

static char     rcsid[] = "$Id: version.c,v 1.9 1998/07/28 19:26:54 web Exp $";

#include        <sys/types.h>
#include	<netinet/in.h>

#include	<stdio.h>

#include	"radius.h"

/*
 *	If you make any changes to this software, please update the
 *	version number(s) below.
 *
 */

#ifndef RADIUS_VERSION
#define	RADIUS_VERSION		" 3.6B " /* MUST be surrounded by spaces */
#endif	/* RADIUS_VERSION */

#ifdef MERIT_LAS
#define	LAS_VERSION		" 1.6.18 "   /* MUST be surrounded by spaces */
#endif	/* MERIT_LAS */

/*************************************************************************
 *
 *	Function: verinfo
 *
 *	Purpose: Return version information for this build of the server.
 *
 *************************************************************************/

char *
verinfo (type)

int           type;	/* 2 ==>, just ver, 1 ==> for screen, 0 ==> otherwise */

{
	static char        buf[4096];

	sprintf (buf, "Version%s", RADIUS_VERSION);

	if (type == 2)
	{
		return buf;
	}

	/* here are all the conditional feature flags */

#if defined(USE_DBM)
	strcat (buf, " DBM");
#endif	/* USE_DBM */

#if defined(USE_NDBM)
	strcat (buf, " NDBM");
#endif	/* USE_NDBM */

#if defined(NOSHADOW)
	strcat (buf, " NOSHADOW");
#endif	/* NOSHADOW */

#if defined(CHK_COUNTS)
	strcat (buf, " CHK_COUNTS");
#endif	/* CHK_COUNTS */

	/* here are all the system definitions compilation uses */

#if defined(__alpha)
	strcat (buf, " __alpha");
#endif	/* __alpha */

#if defined(__osf__)
	strcat (buf, " __osf__");
#endif	/* __osf__ */

#if defined(aix)
	strcat (buf, " aix");
#endif

#if defined(bsdi)
	strcat (buf, " bsdi");
#endif

#if defined(linux)
	strcat (buf, " linux");
#endif

#if defined(sun)
	strcat (buf, " sun");
#endif

#if defined(sys5)
	strcat (buf, " sys5");
#endif

#if defined(unixware)
	strcat (buf, " unixware");
#endif

#if defined(M_UNIX)
	strcat (buf, " M_UNIX");
#endif

#if defined(__sgi)
	strcat (buf, " __sgi");
#endif

#if defined(__hpux)
	strcat (buf, " HP-UX");
#endif

#if defined(M_KERB)
	strcat (buf, " M_KERB");
#endif

#if defined(A_KERB)
	strcat (buf, " A_KERB");
#endif

#if defined(ORA_PASS)
	strcat (buf, " ORACLE");
#endif	/* ORA_PASS */

#if defined(TACACS)
	strcat (buf, " XTACACS");
#endif

#if defined(TACACS_PLUS)
	strcat (buf, " TACACS+");
#endif

#if defined(KCHAP)
	strcat (buf, " KCHAP");
#endif

#if defined(ultrix) || defined(ULTRIX_ENHANCED)
#if defined(ultrix)
	strcat (buf, " ultrix");
#else
	strcat (buf, " ULTRIX_ENHANCED");
#endif	/* ultrix */
#endif

#if defined(BASIC_SERVER)
	strcat (buf, " BASIC");
#endif

#if defined(MERIT_LAS)
	strcat (buf, " LAS = ");
	strcat (buf, LAS_VERSION);

#if defined(LAS_NO_HGAS)
	strcat (buf, "(NO-HGAS)");
#endif /* LAS_NO_HGAS */

#endif	/* MERIT_LAS */

#if defined(MERIT_ORGANIZATION)
	strcat (buf, " OAS = ");
	strcat (buf, OAS_VERSION);
#endif	/* OAS */

#if defined(MERIT_HUNTGROUP)
	strcat (buf, " HGAS = ");
	strcat (buf, HGAS_VERSION);

#if defined(MERIT_HUNTGROUP_DAC)
	strcat (buf, " DAC");
#endif	/* DAC */

#if defined(MERIT_HUNTGROUP_SHP)
	strcat (buf, " SHP");
#endif	/* SHP */

#endif	/* MERIT_HUNTGROUP */

	if (type == 1)
	{

#if defined(ASCEND)
		strcat (buf, " \n\rASCEND");
#endif	/* ASCEND */

#if defined(ASCEND_SECRET)
		strcat (buf, " ASCEND_SECRET");
#endif	/* ASCEND_SECRET */

#if defined(BINARY_FILTERS)
		strcat (buf, " BINARY_FILTERS");
#endif	/* BINARY_FILTERS */

#if defined(USR_CCA)
		strcat (buf, " USR_CCA");
#endif	/* USR_CCA */

#if defined(RADIUS_DIR)
		strcat (buf, "\n\rdirectory = ");
		strcat (buf, RADIUS_DIR);
#endif	/* RADIUS_DIR */

	}

	return buf;
} /* end of verinfo () */
