#ifdef USR_CCA

/*
 *
 * Copyright (c) 1996 U.S. Robotics, Access Corp.
 * All rights reserved.
 *
 * Permission to copy, display, distribute and make derivative works
 * from this material in whole or in part for any purpose is granted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all copies.  THIS SOFTWARE IS PROVIDED "AS IS" AND
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * If providing code not subject to a copyright please indicate that the
 * code has been dedicated to the public.
 *
 */

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

static char     rcsid[] = "$Id: vpn.c,v 1.6 1998/07/06 17:43:42 web Exp $";

/*****************************************************************************
 *
 *			vpn.c - VPN related functions
 *
 ****************************************************************************/

#include        <sys/param.h>
#include        <sys/types.h>
#include        <sys/socket.h>
#include        <netinet/in.h>
#include        <arpa/inet.h>
#include        <sys/ioctl.h>
#include        <sys/file.h>
#include        <sys/time.h>
#include        <sys/file.h>
#include        <sys/wait.h>
#include        <sys/stat.h>

#if defined(sys5)
#include        <sys/sysmacros.h>
#endif	/* sys5 */

#include        <net/if.h>

#include        <stdio.h>
#include        <stdlib.h>
#include        <netdb.h>
#include        <fcntl.h>
#include        <errno.h>
#include        <memory.h>
#include        <signal.h>
#include        <syslog.h>
#include        <string.h>

#include        "radius.h"

extern int      debug_flag;

static int add_vpn_gateway PROTO((AUTH_REQ *, VPN_ROUTER *));
static void gen_gw_vector PROTO((char *, char *, char *, char *));

/***********************************************************************
 *
 *       Function: parse_vpn
 *
 *       Purpose:  Get the filter name and the VPN data from current line
 *                 of the authfile.  It sets all those parameters not
 *                 found to zero.
 *
 ************************************************************************/

int
parse_vpn (word, vpn_id, vpn_router, router_type, vpn_name, type)

char           *word;
UINT4          *vpn_id;
VPN_ROUTER    **vpn_router;
int            *router_type;
char          **vpn_name;
int             type;		/* Authentication Type */

{
	char            count;
	char           *temp;
	char           *x;
	char           *func = "parse_vpn";

	if (strcmp (word, VPN) == 0)
	{ /* Should expect to see VPN id, Neighbor/Gateway, Name on this line */
		if ((temp = strtok (NULL, " \t\n\r")) == NULL)
		{
			return 1;
		}
		/* Convert the string to a number - the VPN ID */

		x = temp;
		count = 0;
		for ( ; *x ; x++)
		{
			if (!isdigit(*x))
			{
				count = 1;
				break;
			}
		}

		if (count)
		{
			logit (LOG_DAEMON, LOG_ERR,
			       "%s: Invalid VPN_ID", func);
			return 1;
		}
		else
		{
			*vpn_id = atoi (temp);
		}

		if ((temp = strtok (NULL, " \t\n\r")) == NULL)
		{
			if (type == AA_RAD)
			{
				logit (LOG_DAEMON, LOG_INFO,
"%s: Missing VPN Neighbor/Gateway info. for VPN %d.  Assuming the Remote server will supply this information",
				       func, *vpn_id);
				*router_type = PW_USR_VPN_GATEWAY;
				*vpn_router = (VPN_ROUTER *) NULL;
				*vpn_name = NULL;
				return 0;
			}
			else /* Local VPN type must have a VPN neighbor/gateway defined */
			{
				logit (LOG_DAEMON, LOG_ERR,
			    "%s: Missing VPN Neighbor/Gateway for Local-VPN %d",
					func, *vpn_id);
					return 1;
			}
		}
		else if (strcmp (temp, VPN_NEIGHBOR) == 0)
		{
			*router_type = PW_USR_VPN_NEIGHBOR;
		}
                else if (strcmp (temp, VPN_GATEWAY) == 0)
                {
                	*router_type = PW_USR_VPN_GATEWAY;
		}
		else if (strcmp (temp, VPN_NAME) == 0)
		{
			if (type == AA_RAD)
			{
				logit (LOG_DAEMON, LOG_INFO,
"%s: Missing VPN Neighbor/Gateway info. for VPN %d.  Assuming the Remote server will supply this information",
					func, *vpn_id);
				*router_type = PW_USR_VPN_GATEWAY;
				*vpn_router = (VPN_ROUTER *) NULL;
				*vpn_name = strtok (NULL, " \t\n\r");
				return 0;
			}
			else /* Local VPN type must have a VPN neighbor/gateway defined */
			{
				logit (LOG_DAEMON, LOG_ERR,
			    "%s: Missing VPN Neighbor/Gateway for Local-VPN %d",
					func, *vpn_id);
				return 1;
			}
		}
		else	/* something strange */
		{
			logit (LOG_DAEMON, LOG_ERR,
				 "%s: Invalid entry in authfile for VPN %d",
				func, *vpn_id);
			return 1;
		}

		/*
		 * We can get here only if VPN Gateways/Neighbor are defined
		 * in the authfile
		 */
		return parse_rtr (*router_type, vpn_router, vpn_name);
	} /* end if (strcmp (type, VPN) == 0) */
	else if (strcmp (word, VPN_GATEWAY) == 0 && type == AA_LOCAL_VPN)
	{
		/* List of Realm Gateways */
		*router_type = GATEWAYS_ONLY;
		return parse_rtr (*router_type, vpn_router, vpn_name);
	}
	else /* Error */
	{
		return 1;
	}
} /* end of parse_vpn () */

/******************************************************************************
 *
 *      Function: parse_rtr
 *
 *      Purpose:  Parse the VPN Gateway/Neighbor information
 *
 *****************************************************************************/

int
parse_rtr (type, vpn_router, vpn_name)

int             type;
VPN_ROUTER    **vpn_router;
char          **vpn_name;

{
	int             count = 0;
	int             count2;
	int             xx;
	UINT4           ipaddr;
	char           *temp;
	char           *temp2;
	char           *temp3;
	char           *x;
	VPN_ROUTER     *rtr;
	VPN_ROUTER    **neigh_ptr;
	struct in_addr  addr;
	char           *func = "parse_rtr";

	neigh_ptr = vpn_router;
	temp = strtok (NULL, " \t\n\r");

	if (type == PW_USR_VPN_GATEWAY || type == GATEWAYS_ONLY)
	{
		while (temp != NULL && strcmp (temp, VPN_NAME) != 0)
		{
			temp2 = strdup (temp);
			count2 = strlen (temp);
			temp += count2 + 1;
			if (temp2[count2 - 1] == ':')
			{	/* Detecting errors of type '1.1.1.1:' */
				temp2[count2 - 1] = '\0';
				logit (LOG_DAEMON, LOG_ERR,
			"%s: Error in authfile. Missing Tunnel-Refresh for %s",
					func, temp2);
				free_vpn_rtr (vpn_router);
				return (1);
			}

			temp3 = strtok (temp2, ":");

			/*
			 * if ((ipaddr = get_ipaddr (temp3)) != 0) {
			 */
			if ((rtr =
				(VPN_ROUTER *) malloc (sizeof (VPN_ROUTER)))
						== (VPN_ROUTER *) NULL)
			{
				logit (LOG_DAEMON, LOG_ALERT,
					   "%s: FATAL out of memory", func);
				abort ();
			}
			rtr->hostname = strdup (temp3);
			/* rtr->ipaddr = ipaddr; */
			rtr->next = (VPN_ROUTER *) NULL;
			*neigh_ptr = rtr;
			neigh_ptr = &(*neigh_ptr)->next;
			count++;

			if ((temp3 = strtok (NULL, "")) != NULL)
			{
				x = temp3;
				count2 = 0;
				for (; *x; x++)
				{
					if (!isdigit (*x))
					{
						count2 = 1;
						break;
					}
				}

				if (count2)
				{
					addr.s_addr = ipaddr;
					logit (LOG_DAEMON, LOG_INFO,
	"%s: Error in authfile. Gateway %s has invalid Tunnel Refresh specified.",
						    func, inet_ntoa (addr));
					free_vpn_rtr (vpn_router);
					free (temp2);
					return (1);
				}
				else
				{
				/*	t_ref = atoi (temp3);
                                        if (t_ref > USHRT_MAX)
                                        {
                                                logit (LOG_DAEMON, LOG_ERR,
				      "%s: Tunnel Refresh must be less than %d",
							func, USHRT_MAX);
                                                free_vpn_rtr (vpn_router);
                                                free (temp2);
                                                return (1);
                                        }
                                        xx = sizeof (int) - 1;
                                        for (i = TUNNEL_REF_LEN - 1; i >= 0; i++)
                                        {
                                                rtr->tunnel_refresh[i] =
                                                        (char *) &t_ref[xx];
                                                xx--;
                                        }
                                */

					rtr->tunnel_refresh = atoi (temp3);
					rtr->tunnel_present = TRUE;
				}
			}
			else /* No Tunnel Refresh specified */
			{
				rtr->tunnel_present = FALSE;
			}

			/*} * end if (ipaddr = get_ipaddr (........) *
                        else * Something wrong with this entry *
                        {
                                free_vpn_rtr (vpn_router);
                                free (temp2);
                                logit (LOG_DAEMON, LOG_ERR,
                                       "%s: Error in authfile entry at %s",
                                       func, temp3);
                                return (1);
                        }
                        */

			free (temp2);
			temp2 = temp;
			temp = NULL;
			temp = strtok (temp2, " \t\n\r");
		} /* end while loop */
	} /* end if (*router_type == VPN_GATEWAY) */
	else /* router_type == VPN_NEIGHBOR */
	{
		/*if ((ipaddr = get_ipaddr (temp)) != 0)
                {*/
		if ((rtr =
			(VPN_ROUTER *) malloc (sizeof (VPN_ROUTER)))
						== (VPN_ROUTER *) NULL)
		{
			logit (LOG_DAEMON, LOG_ALERT,
			       "%s: FATAL out of memory", func);
			abort ();
		}

		/* rtr->ipaddr = ipaddr; */
		if (insert_client (temp, "", "", 0, CE_NEIGHBOR,
						(VENDOR_LIST *) NULL, VER1) < 0)
		{
			logit (LOG_DAEMON, LOG_ERR,
			       "%s: Problem parsing authfile at '%s'",
			       func, temp);
			return (1);
		}
		rtr->hostname = strdup (temp);
		rtr->next = (VPN_ROUTER *) NULL;
		rtr->tunnel_present = FALSE;
		*neigh_ptr = rtr;
		count++;
		temp = strtok (NULL, " \t\n\r");
	}

        /*    else
                {
                        logit (LOG_DAEMON, LOG_ERR,
                        "%s: Error in authfile at '%s'", func,
                                        temp);
                        return (1);
                }
        } * end else  [ *router_type == VPN_NEIGHBOR] */

	if (count == 0)
	{
		logit (LOG_DAEMON, LOG_ERR,
		 "%s: Missing VPN Neighbor/Gateway Information in authfile",
		       func);
		return 1;
	}

	if (temp != NULL && strcmp (temp, VPN_NAME) == 0)
	{
		*vpn_name = strtok (NULL, " \t\n\r");
	}
	else
	{
		*vpn_name = NULL;
	}
	return 0;

} /* end of parse_rtr () */

/*****************************************************************************
 *
 *      Function: free_vpn_rtr
 *
 *      Purpose:  Frees the link list of VPN_ROUTER structures
 *
 *****************************************************************************/

void
free_vpn_rtr (vpn_router)

VPN_ROUTER    **vpn_router;

{
	VPN_ROUTER     *x;

	for (x = *vpn_router; x != (VPN_ROUTER *) NULL;)
	{
		free (x->hostname);
		*vpn_router = x->next;
		free (x);
		x = *vpn_router;
	}

	return;
} /* end of free_vpn_rtr () */

/******************************************************************************
 *
 *	Function: add_vpn_info
 *
 *	Purpose:  Adds VPN ID, VPN Name, VPN Neighbor/Gateway to the
 *		  authentication request.
 *
 *****************************************************************************/

int
add_vpn_info (authreq, auth_ent)

AUTH_REQ       *authreq;
AUTH_ENTRY     *auth_ent;

{
	VPN_INFO       *vpn;
	VPN_ROUTER     *router;
	UINT4           tmp_ip;
	UINT4           tmp_vpn;
	char           *func = "add_vpn_info";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((vpn = auth_ent->vpn) == (VPN_INFO *) NULL)
	{
		logit (LOG_DAEMON, LOG_ERR, "%s: NULL VPN pointer for '%s'",
			func, (auth_ent->name == (char *) NULL)
						? "?" : auth_ent->name);
		return 1;
	}

	router = vpn->router;

	/*
	 *	VPN ID, Name, and Neighbor must be inserted by the Proxy.
	 *	If the remote server inserted these values, remove them.
	 */
	avpair_del (&authreq->cur_request, PW_USR_VPN_ID, VC_USR);
	avpair_del (&authreq->cur_request, PW_USR_VPN_NAME, VC_USR);
	avpair_del (&authreq->cur_request, PW_USR_VPN_NEIGHBOR, VC_USR);
	if (vpn->type != GATEWAYS_ONLY)
	{
		tmp_vpn = htonl(vpn->id); /* for avpair_add_vend() call below */
		if ((avpair_add_vend (&authreq->cur_request, PW_USR_VPN_ID,
					&tmp_vpn, INT_LEN, VC_USR)) == NULL_VP)
		{
			logit (LOG_DAEMON, LOG_ERR,
			       "%s: Problem adding VPN ID for VPN %d, Realm %s",
				func, vpn->id, auth_ent->name);
			return 0;
		}

		if ((avpair_add_vend (&authreq->cur_request, PW_USR_VPN_NAME,
					vpn->name, -1, VC_USR)) == NULL_VP)
		{
			logit (LOG_DAEMON, LOG_ERR,
			     "%s: Problem adding VPN Name for VPN %d, Realm %s",
				func, vpn->id, auth_ent->name);
			avpair_del (&authreq->cur_request,
					PW_USR_VPN_ID, VC_USR);
			return 0;
		}

		if (vpn->type == PW_USR_VPN_NEIGHBOR &&
			router == (VPN_ROUTER *) NULL)
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: Missing VPN Neighbor for VPN %d, Realm %s",
				func, vpn->id, auth_ent->name);
			avpair_del (&authreq->cur_request,
					PW_USR_VPN_ID, VC_USR);
			avpair_del (&authreq->cur_request,
					PW_USR_VPN_NAME, VC_USR);
			return 0;
		}

		if (vpn->type == PW_USR_VPN_NEIGHBOR)
		{
			if (find_host_by_name (&tmp_ip, router->hostname) != 0)
			{
				logit (LOG_DAEMON, LOG_ERR,
				  "%s: Problem resolving IP address for %s",
					func, router->hostname);
				avpair_del (&authreq->cur_request,
						 PW_USR_VPN_ID, VC_USR);
				avpair_del (&authreq->cur_request,
						 PW_USR_VPN_NAME, VC_USR);
				return 0;
			}

			/* tmp_ip = htonl(router->ipaddr); */
			if ((avpair_add_vend (&authreq->cur_request,
					PW_USR_VPN_NEIGHBOR, &tmp_ip,
					IP_ADDR_LEN, VC_USR)) == NULL_VP)
			{
				logit (LOG_DAEMON, LOG_ERR,
			 "%s: Problem adding VPN Neighbor for VPN %d, Realm %s",
					func, vpn->id, auth_ent->name);
				avpair_del (&authreq->cur_request,
						PW_USR_VPN_ID, VC_USR);
				avpair_del (&authreq->cur_request,
						PW_USR_VPN_NAME, VC_USR);
				return 0;
			}

		}
		else /* PW_USR_VPN_GATEWAY */
		{
			if (get_vp_vend (authreq->cur_request,
					PW_USR_VPN_GATEWAY, VC_USR) != NULL_VP)
			{
				/*
				 * Gateways can be defined on both the Proxy
				 * and the Remote server.  If the Remote
				 * server already inserted the gateways,
				 * leave them as they are.  The Proxy must
				 * not add gateways in this case.
				 */
				logit (LOG_DAEMON, LOG_INFO,
"%s: VPN Gateways already added for VPN %d\(by Remote Server).\nNot Adding Gateways defined here",
					func, vpn->id);
				return 1;
			}

			if (add_vpn_gateway (authreq, router) == 0)
			{
				avpair_del (&authreq->cur_request,
						 PW_USR_VPN_ID, VC_USR);
				avpair_del (&authreq->cur_request,
						 PW_USR_VPN_NAME, VC_USR);
				avpair_del (&authreq->cur_request,
						 PW_USR_VPN_GATEWAY, VC_USR);
				return 0;
			}
		}
	} /* end if (vpn->type != GATEWAYS_ONLY) */
	else /* GATEWAYS ONLY */
	{
		if (add_vpn_gateway (authreq, router) == 0)
		{
			avpair_del (&authreq->cur_request,
					 PW_USR_VPN_GATEWAY, VC_USR);
			return 0;
		}
	}
	return 1;
} /* end of add_vpn_info () */

#define GATEWAY_AV_LEN 	AUTH_VECTOR_LEN+IP_ADDR_LEN+GATEWAY_FORMAT_LEN+TUNNEL_REF_LEN
/***************************************************************************
 *
 *	Function: add_vpn_gateway
 *
 *	Purpose:  Adds VPN-Gateway attribute type to given list.
 *
 ***************************************************************************/

static int
add_vpn_gateway (authreq, router)

AUTH_REQ       *authreq;
VPN_ROUTER     *router;

{
	char            count = 0;
	UINT2           tunnel_ref;
	int             i;
	int             index;
	int             result;
	UINT4           ip;
	UINT4           sk;
	u_char         *ptr;
	CLIENT_ENTRY   *ce;
	VPN_ROUTER     *rtr_ptr;
	char            buffer[AUTH_VECTOR_LEN];
	char            session_key[SESSION_KEY_LEN];
	char            vp_val[GATEWAY_AV_LEN];
	char           *func = "add_vpn_gateway";

	memset (session_key, 0, SESSION_KEY_LEN);

#ifdef BSDI
	srandom (time (0));
#else
	srand48 (time (0));
#endif	/* BSDI */

	ptr = (u_char *) session_key;
	for (i = 0; i < SESSION_KEY_LEN / 4; i++, ptr += sizeof (UINT4))
	{

#ifdef BSDI
		sk = random ();
#else
		sk = lrand48 ();
#endif	/* BSDI */

		memcpy (ptr, (char *) &sk, sizeof (UINT4));
	}

#ifdef USR_DEBUG
	fprintf (stderr, "%s: SESSION-KEY = ", func);
	ptr = (u_char *) session_key;
	for (i = 0; i < SESSION_KEY_LEN; i++, ptr++)
	{
		fprintf (stderr,"%02x ", *ptr);
	}
	fprintf (stderr,"\n");
#endif	/* USR_DEBUG */

	for (rtr_ptr = router;
		rtr_ptr != (VPN_ROUTER *) NULL;
		rtr_ptr = rtr_ptr->next)
	{
		result = find_client_by_name (rtr_ptr->hostname, &ip, &ce);
		if (result == -1)
		{
			logit (LOG_DAEMON, LOG_ERR,
		    "%s: %s does not have a matching entry in the Clients file",
				func, rtr_ptr->hostname);
			continue;
		}
		else if (result != 0)
		{
			logit (LOG_DAEMON, LOG_ERR,
			       "%s: Couldn't reslove IP address for %s",
			       func, rtr_ptr->hostname);
			continue;
		}
		memset (buffer, 0, AUTH_VECTOR_LEN);
		memset (vp_val, 0, GATEWAY_AV_LEN);

		gen_gw_vector (buffer, (char *) authreq->repvec,
				ce->secret, session_key);
		vp_val[0] = VPN_GATEWAY_FORMAT;
		index = GATEWAY_FORMAT_LEN;

		dprintf(2, (LOG_AUTH, LOG_DEBUG,
			"%s: index = %d", func, index));

		ip = ntohl (ip);
		memcpy (&vp_val[index], (char *) &ip, sizeof (UINT4));
		/* index += IP_ADDR_LEN + AUTH_VECTOR_LEN; */
		index += IP_ADDR_LEN;
		memcpy (&vp_val[index], buffer, AUTH_VECTOR_LEN);
		index += AUTH_VECTOR_LEN;
		fprintf (stderr, "%s: index = %d\n", func, index);
		if (rtr_ptr->tunnel_present == TRUE)
		{
			tunnel_ref = htons(rtr_ptr->tunnel_refresh);
		}
		else
		{
			tunnel_ref = 0;
		}
		memcpy (&vp_val[index], (char *) &tunnel_ref, TUNNEL_REF_LEN);
		index += TUNNEL_REF_LEN;

		dprintf(2, (LOG_AUTH, LOG_DEBUG,
			"%s: again, index = %d", func, index));

		if (avpair_add_vend (&authreq->cur_request, PW_USR_VPN_GATEWAY,
					vp_val, index, VC_USR) == NULL_VP)
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: Problem adding VPN Gateway %s", func,
				rtr_ptr->hostname);
			return 0;
		}
		count++;
	}

	if (count > 0)
	{
		memset (vp_val, 0, GATEWAY_AV_LEN);
		memset (buffer, 0, AUTH_VECTOR_LEN);

		gen_gw_vector (buffer, (char *) authreq->repvec,
				authreq->client->secret, session_key);
		memcpy (vp_val, buffer, AUTH_VECTOR_LEN);
		if (avpair_add_vend (&authreq->cur_request, PW_USR_AUTH_VECTOR,
				vp_val, AUTH_VECTOR_LEN, VC_USR) == NULL_VP)
		{
			logit (LOG_DAEMON, LOG_ERR,
				"%s: Problem adding VPN Auth. Vector", func);
			return 0;
		}
	}
	return 1;
} /* end of add_vpn_gateway () */

/***************************************************************************
 *
 *	Function: gen_gw_vector
 *
 *	Purpose:  Generates the special vector required in the
 *		  PW_USR_VPN_GATEWAY attribute
 *
 ***************************************************************************/

static void
gen_gw_vector (buffer, vector, secret, session_key)

char           *buffer;
char           *vector;
char           *secret;
char           *session_key;

{
	int             i;
	int             secretlen;
	char            md5buf[AUTH_VECTOR_LEN + MAX_SECRET_LENGTH];
	char           *func = "gen_gw_vector";

	memcpy (md5buf, vector, AUTH_VECTOR_LEN);
	secretlen = strlen (secret);
	memcpy (md5buf + AUTH_VECTOR_LEN, secret, secretlen);
	md5_calc (buffer, md5buf, AUTH_VECTOR_LEN + secretlen);

	for (i = 0; i < SESSION_KEY_LEN; i++)
	{
		buffer[i] ^= session_key[i];
	}
	return;
} /* end of gen_gw_vector () */

/***************************************************************************
 *
 *	Function: proxy_vector_proc
 *
 *	Purpose: Generates the special proxy vector.
 *
 ***************************************************************************/

void
proxy_vector_proc (authreq, remote_secret, vector)

AUTH_REQ       *authreq;
char           *remote_secret;
char           *vector;

{
	int             i;
	int             secretlen;
	u_char         *ptr;
	char            buffer[AUTH_VECTOR_LEN + MAX_SECRET_LENGTH];
	char            session_key[SESSION_KEY_LEN];
	char            temp[AUTH_VECTOR_LEN];
	char           *func = "proxy_vector_proc";

	secretlen = strlen (remote_secret);
	memcpy (buffer, authreq->repvec, AUTH_VECTOR_LEN);
	memcpy (buffer + AUTH_VECTOR_LEN, remote_secret, secretlen);

	md5_calc (temp, buffer, AUTH_VECTOR_LEN + secretlen);

	for (i = 0; i < SESSION_KEY_LEN; i++)
	{
		vector[i] ^= temp[i];
	}

	memset (session_key, 0, SESSION_KEY_LEN);
	memcpy (session_key, vector, SESSION_KEY_LEN);

#ifdef USR_DEBUG
	fprintf (stderr, "%s: SESSION-KEY at Proxy is ", func);
	ptr = (u_char *) session_key;
	for (i = 0; i < SESSION_KEY_LEN; i++, ptr++)
	{
		fprintf (stderr, "%02x ", *ptr);
	}
	fprintf (stderr, "\n");
#endif	/* USR_DEBUG */

	memset (vector, 0, AUTH_STRING1_LEN);

	gen_gw_vector (vector, (char *) authreq->repvec,
			authreq->client->secret, session_key);
	return;
} /* end of proxy_vector_proc () */

/***************************************************************************
 *
 *      Function: find_vpn
 *
 *      Purpose: Finds the VPN ID, given the host IP address and file prefix
 *
 **************************************************************************/

int
find_vpn (authreq)

AUTH_REQ       *authreq;

{
	FILE_LIST      *file_ent;
	AUTH_ENTRY     *aent;
	struct in_addr  addr;
	char            found = FALSE;
	char           *func = "find_vpn";

	dprintf(2, (LOG_DAEMON, LOG_DEBUG, "%s: entered", func));

	if ((file_ent = find_file_ent (authreq->client->file_pfx)) ==
			(FILE_LIST *) NULL)
	{
		logit (LOG_DAEMON, LOG_DEBUG,
		       "%s: Couldn't find authfile with prefix %s", func,
		       authreq->client->file_pfx);
		return (1);
	}

	for (aent = file_ent->auth_list; aent != (AUTH_ENTRY *) NULL;
			aent = aent->next)
	{
		if (get_ipaddr (aent->host) == authreq->ipaddr)
		{
			/*
			 *	The host address in the authfile entry matches
			 *	the IP address of the DAS which sent this
			 *	request.  So get the PW_USR_VPN_ID.
			 */
			if ((avpair_add_vend (&authreq->cur_request,
						PW_USR_VPN_ID, &aent->vpn->id,
						INT_LEN, VC_USR)) == NULL_VP)
			{
				avpair_del (&authreq->cur_request,
						PW_USR_VPN_ID, VC_USR);
				return (1);
			}
			found = TRUE;
		}
	}

	if (found == FALSE)
	{
		addr.s_addr = authreq->ipaddr;
		logit (LOG_DAEMON, LOG_DEBUG,
		"%s: Couldn't find a matching entry in the authfile for %s",
		       func, inet_ntoa (addr));
		return (1);
	}
	return 0;
} /* end of find_vpn () */

#endif  /* USR_CCA */
