;;; ljupdate.el --- autoloads for ljupdate

;; Copyright (C) 2001, 2002 Edward O'Connor <ted@oconnor.cx>

;; Maintainer: Edward O'Connor <ted@oconnor.cx>
;; Keywords: convenience

;; This file is part of ljupdate.

;; ljupdate is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; {at your option} any later version.

;; ljupdate is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public
;; License along with ljupdate, or with your Emacs. See the file
;; COPYING, or, if you're using GNU Emacs, try typing C-h C-c to
;; bring it up. If you're using XEmacs, C-h C-l does this. If you
;; do not have a copy, you can obtain one by writing to the Free
;; Software Foundation at this address:

;;                Free Software Foundation, Inc.
;;                59 Temple Place, Suite 330
;;                Boston, MA  02111-1307
;;                USA

;;; Commentary:

;;; History:

;;; Code:

(require 'ljcompat)

(defconst lj--client-version
  "Emacs-ljupdate/3.2"
  "Version of ljupdate reported to the server.")

(defgroup ljupdate nil
  "Blah blah blah."
  :tag "LiveJournal"
  :link '(url-link "http://oconnor.cx/documents/ljupdate/")
  :link '(url-link "http://www.livejournal.com/community/ljupdate/")
  :prefix "lj-"
  :group 'applications)

(defvar lj-debug-flag nil "*Non-nil means that you're debugging ljupdate.el.")
(make-obsolete-variable 'lj-debug-flag 'lj-message-level)
(defvar lj-bbdb-flag nil "*Non-nil means to integrate with the bbdb.")
(make-obsolete-variable 'lj-bbdb-flag "(require 'lj-bbdb)")

(defcustom lj-startup-file "~/.lj.eld"
  "*The location of your LJ startup file.

If you want to use a nonstandard location, you should change this
variable before calling any ljupdate functions."
  :type 'file
  :group 'ljupdate)

(defcustom lj-default-subject nil
  "*The default subject for an entry."
  :type '(choice string (const nil))
  :group 'ljupdate)

(defcustom lj-default-mood nil
  "*The default mood for a Live Journal entry."
  :type '(choice string (const nil))
  :group 'ljupdate)

(defcustom lj-default-access-level "public"
  "*Access level to use by default for LiveJournal posts.

Current possible values are ``public'', ``private'', and
``friends''."
  :type '(choice (const :tag "Public (anyone)" "public")
                 (const :tag "Private (you only)" "private")
                 (const :tag "Friends-only" "friends"))
  :group 'ljupdate)

(defcustom lj-default-comments-flag "yes"
  "*Whether or not to allow comments by default.

If you want to disallow comments, the Allow-Comments header should
be set to the English word ``no'', case insensitively."
  :type '(choice (const :tag "Allow comments" "yes")
                 (const :tag "Disallow comments" "no"))
  :group 'ljupdate)

(defcustom lj-default-mail-notification-flag "yes"
  "*Whether or not to receive email notification of comments by default.

If you want to turn off mail notification, the
Receive-Mail-Notification header should be set to the English word
``no'', case insensitively."
  :type '(choice (const :tag "Receive Mail Notification" "yes")
                 (const :tag "Do Not Receive Mail Notification" "no"))
  :group 'ljupdate)

(defvar lj--startup-modified-p nil
  "This is non-nil if the lj-startup file needs to saved, and nil otherwise.")

;; The file lj-auto.el is really what gets us moving. It's an
;; autogenerated file containing autoloads for the rest of
;; ljupdate.
(require 'lj-auto)

(provide 'ljupdate)

;;; ljupdate.el ends here
