/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.CstInsn;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.TypedConstant;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import java.util.ArrayList;
import java.util.BitSet;

public class SCCP {
    private static final int TOP = 0;
    private static final int CONSTANT = 1;
    private static final int VARYING = 2;
    private SsaMethod ssaMeth;
    private int regCount;
    private int[] latticeValues;
    private Constant[] latticeConstants;
    private ArrayList<SsaBasicBlock> cfgWorklist;
    private BitSet executableBlocks;
    private ArrayList<SsaInsn> ssaWorklist;
    private ArrayList<SsaInsn> varyingWorklist;

    private SCCP(SsaMethod ssaMeth) {
        this.ssaMeth = ssaMeth;
        this.regCount = ssaMeth.getRegCount();
        this.latticeValues = new int[this.regCount];
        this.latticeConstants = new Constant[this.regCount];
        this.cfgWorklist = new ArrayList();
        this.executableBlocks = new BitSet(ssaMeth.getBlocks().size());
        this.ssaWorklist = new ArrayList();
        this.varyingWorklist = new ArrayList();
        for (int i = 0; i < this.regCount; ++i) {
            this.latticeValues[i] = 0;
            this.latticeConstants[i] = null;
        }
    }

    public static void process(SsaMethod ssaMethod) {
        new SCCP(ssaMethod).run();
    }

    private void addBlockToWorklist(SsaBasicBlock ssaBlock) {
        if (!this.executableBlocks.get(ssaBlock.getIndex())) {
            this.cfgWorklist.add(ssaBlock);
            this.executableBlocks.set(ssaBlock.getIndex());
        }
    }

    private void addUsersToWorklist(int reg, int latticeValue) {
        if (latticeValue == 2) {
            for (SsaInsn insn : this.ssaMeth.getUseListForRegister(reg)) {
                this.varyingWorklist.add(insn);
            }
        } else {
            for (SsaInsn insn : this.ssaMeth.getUseListForRegister(reg)) {
                this.ssaWorklist.add(insn);
            }
        }
    }

    private boolean setLatticeValueTo(int reg, int value, Constant cst) {
        if (value != 1) {
            if (this.latticeValues[reg] != value) {
                this.latticeValues[reg] = value;
                return true;
            }
            return false;
        }
        if (this.latticeValues[reg] != value || !this.latticeConstants[reg].equals(cst)) {
            this.latticeValues[reg] = value;
            this.latticeConstants[reg] = cst;
            return true;
        }
        return false;
    }

    private boolean setLatticeValueTo(int reg, int value) {
        return this.setLatticeValueTo(reg, value, null);
    }

    private void simulatePhi(PhiInsn insn) {
        int phiResultReg = insn.getResult().getReg();
        if (this.latticeValues[phiResultReg] == 2) {
            return;
        }
        RegisterSpecList sources = insn.getSources();
        int phiResultValue = 0;
        Constant phiConstant = null;
        int sourceSize = sources.size();
        for (int i = 0; i < sourceSize; ++i) {
            int predBlockIndex = insn.predBlockIndexForSourcesIndex(i);
            int sourceReg = sources.get(i).getReg();
            int sourceRegValue = this.latticeValues[sourceReg];
            if (!this.executableBlocks.get(predBlockIndex) || sourceRegValue == 0) continue;
            if (sourceRegValue == 1) {
                if (phiConstant == null) {
                    phiConstant = this.latticeConstants[sourceReg];
                    phiResultValue = 1;
                    continue;
                }
                if (this.latticeConstants[sourceReg].equals(phiConstant)) continue;
                phiResultValue = 2;
                break;
            }
            if (sourceRegValue != 2) continue;
            phiResultValue = 2;
            break;
        }
        if (this.setLatticeValueTo(phiResultReg, phiResultValue, phiConstant)) {
            this.addUsersToWorklist(phiResultReg, phiResultValue);
        }
    }

    private void simulateBlock(SsaBasicBlock block) {
        for (SsaInsn insn : block.getInsns()) {
            if (insn instanceof PhiInsn) {
                this.simulatePhi((PhiInsn)insn);
                continue;
            }
            this.simulateStmt(insn);
        }
    }

    private static String latticeValName(int latticeVal) {
        switch (latticeVal) {
            case 0: {
                return "TOP";
            }
            case 1: {
                return "CONSTANT";
            }
            case 2: {
                return "VARYING";
            }
        }
        return "UNKNOWN";
    }

    private Insn simplifyJump(Insn insn) {
        return insn;
    }

    private Constant simulateMath(SsaInsn insn) {
        Constant cB;
        Insn ropInsn = insn.getOriginalRopInsn();
        int opcode = insn.getOpcode().getOpcode();
        RegisterSpecList sources = insn.getSources();
        int regA = sources.get(0).getReg();
        Constant cA = this.latticeValues[regA] != 1 ? null : this.latticeConstants[regA];
        if (sources.size() == 1) {
            CstInsn cstInsn = (CstInsn)ropInsn;
            cB = cstInsn.getConstant();
        } else {
            int regB = sources.get(1).getReg();
            cB = this.latticeValues[regB] != 1 ? null : this.latticeConstants[regB];
        }
        if (cA == null || cB == null) {
            return null;
        }
        switch (insn.getResult().getBasicType()) {
            case 6: {
                int vR;
                boolean skip = false;
                int vA = ((CstInteger)cA).getValue();
                int vB = ((CstInteger)cB).getValue();
                switch (opcode) {
                    case 14: {
                        vR = vA + vB;
                        break;
                    }
                    case 15: {
                        vR = vA - vB;
                        break;
                    }
                    case 16: {
                        vR = vA * vB;
                        break;
                    }
                    case 17: {
                        if (vB == 0) {
                            skip = true;
                            vR = 0;
                            break;
                        }
                        vR = vA / vB;
                        break;
                    }
                    case 20: {
                        vR = vA & vB;
                        break;
                    }
                    case 21: {
                        vR = vA | vB;
                        break;
                    }
                    case 22: {
                        vR = vA ^ vB;
                        break;
                    }
                    case 23: {
                        vR = vA << vB;
                        break;
                    }
                    case 24: {
                        vR = vA >> vB;
                        break;
                    }
                    case 25: {
                        vR = vA >>> vB;
                        break;
                    }
                    case 18: {
                        vR = vA % vB;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected op");
                    }
                }
                return skip ? null : CstInteger.make(vR);
            }
        }
        return null;
    }

    private void simulateStmt(SsaInsn insn) {
        Insn ropInsn = insn.getOriginalRopInsn();
        if (ropInsn.getOpcode().getBranchingness() != 1 || ropInsn.getOpcode().isCallLike()) {
            ropInsn = this.simplifyJump(ropInsn);
            SsaBasicBlock block = insn.getBlock();
            int successorSize = block.getSuccessorList().size();
            for (int i = 0; i < successorSize; ++i) {
                int successor = block.getSuccessorList().get(i);
                this.addBlockToWorklist(this.ssaMeth.getBlocks().get(successor));
            }
        }
        if (insn.getResult() == null) {
            return;
        }
        int resultReg = insn.getResult().getReg();
        int resultValue = 2;
        Constant resultConstant = null;
        int opcode = insn.getOpcode().getOpcode();
        switch (opcode) {
            case 5: {
                CstInsn cstInsn = (CstInsn)ropInsn;
                resultValue = 1;
                resultConstant = cstInsn.getConstant();
                break;
            }
            case 2: {
                if (insn.getSources().size() != 1) break;
                int sourceReg = insn.getSources().get(0).getReg();
                resultValue = this.latticeValues[sourceReg];
                resultConstant = this.latticeConstants[sourceReg];
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                resultConstant = this.simulateMath(insn);
                if (resultConstant == null) {
                    resultValue = 2;
                    break;
                }
                resultValue = 1;
                break;
            }
        }
        if (this.setLatticeValueTo(resultReg, resultValue, resultConstant)) {
            this.addUsersToWorklist(resultReg, resultValue);
        }
    }

    private void run() {
        SsaBasicBlock firstBlock = this.ssaMeth.getEntryBlock();
        this.addBlockToWorklist(firstBlock);
        while (!(this.cfgWorklist.isEmpty() && this.ssaWorklist.isEmpty() && this.varyingWorklist.isEmpty())) {
            SsaInsn insn;
            int listSize;
            while (!this.cfgWorklist.isEmpty()) {
                listSize = this.cfgWorklist.size() - 1;
                SsaBasicBlock block = this.cfgWorklist.remove(listSize);
                this.simulateBlock(block);
            }
            while (!this.varyingWorklist.isEmpty()) {
                listSize = this.varyingWorklist.size() - 1;
                insn = this.varyingWorklist.remove(listSize);
                if (!this.executableBlocks.get(insn.getBlock().getIndex())) continue;
                if (insn instanceof PhiInsn) {
                    this.simulatePhi((PhiInsn)insn);
                    continue;
                }
                this.simulateStmt(insn);
            }
            while (!this.ssaWorklist.isEmpty()) {
                listSize = this.ssaWorklist.size() - 1;
                insn = this.ssaWorklist.remove(listSize);
                if (!this.executableBlocks.get(insn.getBlock().getIndex())) continue;
                if (insn instanceof PhiInsn) {
                    this.simulatePhi((PhiInsn)insn);
                    continue;
                }
                this.simulateStmt(insn);
            }
        }
        this.replaceConstants();
    }

    private void replaceConstants() {
        for (int reg = 0; reg < this.regCount; ++reg) {
            SsaInsn defn;
            TypeBearer typeBearer;
            if (this.latticeValues[reg] != 1 || !(this.latticeConstants[reg] instanceof TypedConstant) || (typeBearer = (defn = this.ssaMeth.getDefinitionForRegister(reg)).getResult().getTypeBearer()).isConstant()) continue;
            for (SsaInsn insn : this.ssaMeth.getUseListForRegister(reg)) {
                if (insn.isPhiOrMove()) continue;
                NormalSsaInsn nInsn = (NormalSsaInsn)insn;
                RegisterSpecList sources = insn.getSources();
                int index = sources.indexOfRegister(reg);
                RegisterSpec spec = sources.get(index);
                RegisterSpec newSpec = spec.withType((TypedConstant)this.latticeConstants[reg]);
                nInsn.changeOneSource(index, newSpec);
            }
        }
    }
}

