/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.Context;
import com.google.analytics.tracking.android.ExceptionParser;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.ServiceManager;
import com.google.analytics.tracking.android.StandardExceptionParser;
import com.google.analytics.tracking.android.Tracker;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler mOriginalHandler;
    private final Tracker mTracker;
    private final ServiceManager mServiceManager;
    private ExceptionParser mExceptionParser;
    static final String DEFAULT_DESCRIPTION = "UncaughtException";

    public ExceptionReporter(Tracker tracker, ServiceManager serviceManager, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (serviceManager == null) {
            throw new NullPointerException("serviceManager cannot be null");
        }
        this.mOriginalHandler = originalHandler;
        this.mTracker = tracker;
        this.mServiceManager = serviceManager;
        this.mExceptionParser = new StandardExceptionParser(context, new ArrayList<String>());
        Log.iDebug("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.mExceptionParser;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.mExceptionParser = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String description = DEFAULT_DESCRIPTION;
        if (this.mExceptionParser != null) {
            String threadName = t != null ? t.getName() : null;
            description = this.mExceptionParser.getDescription(threadName, e);
        }
        Log.iDebug("Tracking Exception: " + description);
        this.mTracker.sendException(description, true);
        this.mServiceManager.dispatch();
        if (this.mOriginalHandler != null) {
            Log.iDebug("Passing exception to original handler.");
            this.mOriginalHandler.uncaughtException(t, e);
        }
    }
}

