/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android;

import android.os.Message;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.openqa.selenium.Alert;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.android.AndroidWebDriver;
import org.openqa.selenium.android.WebDriverWebView;

class ChromeClient
extends WebChromeClient {
    private final AndroidWebDriver driver;
    public static ConcurrentLinkedQueue<Alert> unhandledAlerts = new ConcurrentLinkedQueue();

    public ChromeClient(AndroidWebDriver driver) {
        this.driver = driver;
    }

    public void onCloseWindow(WebView window) {
        this.driver.getViewManager().removeView(window);
        super.onCloseWindow(window);
    }

    public boolean onCreateWindow(WebView view, boolean dialog, boolean userGesture, Message resultMsg) {
        WebView newView = WebDriverWebView.create(this.driver);
        WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
        transport.setWebView(newView);
        resultMsg.sendToTarget();
        this.driver.getViewManager().addView(newView);
        return true;
    }

    public void onProgressChanged(WebView view, int newProgress) {
        if (newProgress == 100 && this.driver.getLastUrlLoaded() != null && this.driver.getLastUrlLoaded().equals(view.getUrl())) {
            this.driver.notifyPageDoneLoading();
        }
    }

    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        unhandledAlerts.add(new AndroidAlert(message, result));
        return true;
    }

    public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
        unhandledAlerts.add(new AndroidAlert(message, result));
        return true;
    }

    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        unhandledAlerts.add(new AndroidAlert(message, (JsResult)result, defaultValue));
        return true;
    }

    private class AndroidAlert
    implements Alert {
        private final String message;
        private final JsResult result;
        private String textToSend = null;
        private final String defaultValue;

        public AndroidAlert(String message, JsResult result) {
            this(message, result, null);
        }

        public AndroidAlert(String message, JsResult result, String defaultValue) {
            this.message = message;
            this.result = result;
            this.defaultValue = defaultValue;
        }

        public void accept() {
            unhandledAlerts.remove(this);
            if (this.isPrompt()) {
                JsPromptResult promptResult = (JsPromptResult)this.result;
                String result = this.textToSend == null ? this.defaultValue : this.textToSend;
                promptResult.confirm(result);
            } else {
                this.result.confirm();
            }
        }

        private boolean isPrompt() {
            return this.result instanceof JsPromptResult;
        }

        public void dismiss() {
            unhandledAlerts.remove(this);
            this.result.cancel();
        }

        public String getText() {
            return this.message;
        }

        public void sendKeys(String keys) {
            if (!this.isPrompt()) {
                throw new ElementNotVisibleException("Alert did not have text field");
            }
            this.textToSend = String.valueOf(this.textToSend == null ? "" : this.textToSend) + keys;
        }
    }
}

