/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android;

import android.webkit.CookieManager;
import com.google.common.collect.Sets;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionCookieManager {
    private static final String COOKIE_DATE_FORMAT = "EEE, dd MMM yyyy hh:mm:ss z";
    public static final String COOKIE_SEPARATOR = ";";
    private CookieManager cookieManager = CookieManager.getInstance();

    public List<Cookie> getCookies(String domain) {
        this.cookieManager.removeExpiredCookie();
        String cookies = this.cookieManager.getCookie(domain);
        LinkedList<Cookie> result = new LinkedList<Cookie>();
        if (cookies == null) {
            return result;
        }
        String[] stringArray = cookies.split(COOKIE_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cookie = stringArray[n2];
            String[] cookieValues = cookie.split("=");
            if (cookieValues.length >= 2) {
                result.add(new Cookie(cookieValues[0].trim(), cookieValues[1], domain, null, null));
            }
            ++n2;
        }
        return result;
    }

    public Set<Cookie> getAllCookies(String url) {
        List<String> domains;
        HashSet cookieSet = Sets.newHashSet();
        try {
            domains = this.getDomainsFromUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new WebDriverException("Error while adding cookie. " + e);
        }
        for (String domain : domains) {
            cookieSet.addAll(this.getCookies(domain));
        }
        return cookieSet;
    }

    private List<String> getDomainsFromUrl(URL url) {
        String host = url.getHost();
        String[] paths = new String[]{};
        if (url.getPath() != null) {
            paths = url.getPath().split("/");
        }
        ArrayList<String> domains = new ArrayList<String>(paths.length + 1);
        StringBuilder relative = new StringBuilder().append("http://").append(host).append("/");
        domains.add(relative.toString());
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.length() > 0) {
                relative.append(path).append("/");
                domains.add(relative.toString());
            }
            ++n2;
        }
        return domains;
    }

    public Cookie getCookie(String url, String name) {
        List<Cookie> cookies;
        try {
            cookies = this.getCookies(this.getDomainsFromUrl(new URL(url)).get(0));
        }
        catch (MalformedURLException e) {
            throw new WebDriverException("Error while adding cookie. " + e);
        }
        if (cookies == null || cookies.size() == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public void removeAllCookies(String url) {
        this.cookieManager.removeAllCookie();
    }

    public void remove(String url, String name) {
        List<String> domains;
        try {
            domains = this.getDomainsFromUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new WebDriverException("Error while adding cookie. " + e);
        }
        block2: for (String domain : domains) {
            List<Cookie> cookies = this.getCookies(domain);
            for (Cookie c : cookies) {
                if (!c.getName().equals(name)) continue;
                cookies.remove(c);
                this.cookieManager.setCookie(domain, String.format("%s=; expires=%s", name, new SimpleDateFormat(COOKIE_DATE_FORMAT).format(System.currentTimeMillis() - 500L)));
                continue block2;
            }
        }
        this.cookieManager.removeExpiredCookie();
    }

    public void addCookie(String url, Cookie cookie) {
        URL urlObj;
        try {
            urlObj = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new WebDriverException("Error while adding cookie. ", e);
        }
        String domain = "http://" + urlObj.getHost() + cookie.getPath();
        if (!domain.endsWith("/")) {
            domain = String.valueOf(domain) + "/";
        }
        this.cookieManager.setCookie(domain, this.stringifyCookie(cookie));
    }

    private String stringifyCookie(Cookie cookie) {
        return String.format("%s=%s", cookie.getName(), cookie.getValue());
    }
}

