/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import org.openqa.selenium.android.AndroidWebDriver;
import org.openqa.selenium.android.Logger;

class ViewClient
extends WebViewClient {
    private final AndroidWebDriver driver;
    private final String LOG_TAG = ViewClient.class.getName();
    private String tmpUrl;

    public ViewClient(AndroidWebDriver driver) {
        this.driver = driver;
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        Logger.log(3, this.LOG_TAG, "onReceiveError: " + description + ", error code: " + errorCode);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        boolean shouldAcceptSslCerts = this.driver.getAcceptSslCerts();
        Logger.log(3, this.LOG_TAG, "onReceivedSslError: " + error.toString() + ", shouldAcceptSslCerts: " + shouldAcceptSslCerts);
        if (shouldAcceptSslCerts) {
            handler.proceed();
        } else {
            super.onReceivedSslError(view, handler, error);
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        this.driver.setLastUrlLoaded(url);
        this.tmpUrl = url;
        this.driver.notifyPageStartedLoading();
        super.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.driver.setLastUrlLoaded(url);
        if (url.contains("#") && this.tmpUrl.equals(url.split("#")[0])) {
            this.driver.notifyPageDoneLoading();
        }
    }
}

