/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers.locators;

import java.io.File;
import java.util.logging.Logger;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.os.CommandLine;

public class FirefoxPathLocator
implements BrowserLocator {
    private static final String[] commonNames = new String[]{"firefox", "firefox-bin"};
    private static final Logger log = Logger.getLogger(FirefoxPathLocator.class.getName());

    public BrowserInstallation findBrowserLocation() {
        String[] stringArray = commonNames;
        int n = commonNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String executable = CommandLine.findExecutable(name);
            if (executable != null) {
                if (LauncherUtils.isScriptFile(new File(executable))) {
                    log.warning("Caution: '" + executable + "': file is a script file, not a real executable." + " The browser environment is no longer fully under RC control");
                }
                String libraryPathPropertyName = CommandLine.getLibraryPathPropertyName();
                String libraryPath = System.getenv(libraryPathPropertyName);
                return new BrowserInstallation(executable, libraryPath);
            }
            ++n2;
        }
        return null;
    }

    public BrowserInstallation findBrowserLocationOrFail() {
        BrowserInstallation toReturn = this.findBrowserLocation();
        if (toReturn != null) {
            return toReturn;
        }
        throw new RuntimeException("Unable to find executable on PATH for Firefox");
    }

    public BrowserInstallation retrieveValidInstallationPath(String customLauncherPath) {
        throw new UnsupportedOperationException("retrieveValidInstallationPath");
    }
}

