/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.FileHandler;

public class TemporaryFilesystem {
    private final Set<File> temporaryFiles = new CopyOnWriteArraySet<File>();
    private final File baseDir;
    private final Thread shutdownHook = new Thread(){

        public void run() {
            TemporaryFilesystem.this.deleteTemporaryFiles();
        }
    };
    private static TemporaryFilesystem instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TemporaryFilesystem getDefaultTmpFS() {
        File sysTemp = new File(System.getProperty("java.io.tmpdir"));
        if (instance != null) return instance;
        Class<TemporaryFilesystem> clazz = TemporaryFilesystem.class;
        synchronized (TemporaryFilesystem.class) {
            if (instance != null) return instance;
            instance = new TemporaryFilesystem(sysTemp);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTemporaryDirectory(File directory) {
        Class<TemporaryFilesystem> clazz = TemporaryFilesystem.class;
        synchronized (TemporaryFilesystem.class) {
            instance = new TemporaryFilesystem(directory);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static TemporaryFilesystem getTmpFsBasedOn(File directory) {
        return new TemporaryFilesystem(directory);
    }

    private TemporaryFilesystem(File baseDir) {
        this.baseDir = baseDir;
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        if (!baseDir.exists()) {
            throw new WebDriverException("Unable to find tmp dir: " + baseDir.getAbsolutePath());
        }
        if (!baseDir.canWrite()) {
            throw new WebDriverException("Unable to write to tmp dir: " + baseDir.getAbsolutePath());
        }
    }

    public File createTempDir(String prefix, String suffix) {
        try {
            File file = File.createTempFile(prefix, suffix, this.baseDir);
            file.delete();
            File dir = new File(file.getAbsolutePath());
            if (!dir.mkdirs()) {
                throw new WebDriverException("Cannot create profile directory at " + dir.getAbsolutePath());
            }
            FileHandler.createDir(dir);
            this.temporaryFiles.add(dir);
            return dir;
        }
        catch (IOException iOException) {
            throw new WebDriverException("Unable to create temporary file at " + this.baseDir.getAbsolutePath());
        }
    }

    public void deleteTempDir(File file) {
        if (!this.shouldReap()) {
            return;
        }
        if (this.temporaryFiles.remove(file)) {
            FileHandler.delete(file);
        }
    }

    public void deleteTemporaryFiles() {
        if (!this.shouldReap()) {
            return;
        }
        for (File file : this.temporaryFiles) {
            try {
                FileHandler.delete(file);
            }
            catch (WebDriverException webDriverException) {}
        }
    }

    boolean shouldReap() {
        String reap = System.getProperty("webdriver.reap_profile", "true");
        return Boolean.valueOf(reap);
    }

    public boolean deleteBaseDir() {
        return this.baseDir.delete();
    }
}

