/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.app.AppGlobals;
import android.content.ContentValues;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.DatabaseUtils;
import android.database.DefaultDatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.DatabaseConnectionPool;
import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCompiledSql;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteDirectCursorDriver;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteStatement;
import android.database.sqlite.SQLiteTransactionListener;
import android.database.sqlite.SQLiteUnfinalizedObjectsException;
import android.os.Debug;
import android.os.StatFs;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.LruCache;
import android.util.Pair;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.BlockGuard;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabase
extends SQLiteClosable {
    private static final String TAG = "SQLiteDatabase";
    private static final boolean ENABLE_DB_SAMPLE = false;
    private static final int EVENT_DB_OPERATION = 52000;
    private static final int EVENT_DB_CORRUPT = 75004;
    public static final int CONFLICT_ROLLBACK = 1;
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_NONE = 0;
    private static final String[] CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
    public static final int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000;
    public static final int OPEN_READWRITE = 0;
    public static final int OPEN_READONLY = 1;
    private static final int OPEN_READ_MASK = 1;
    public static final int NO_LOCALIZED_COLLATORS = 16;
    public static final int CREATE_IF_NECESSARY = 0x10000000;
    private boolean mInnerTransactionIsSuccessful;
    private boolean mTransactionIsSuccessful;
    private SQLiteTransactionListener mTransactionListener;
    private boolean mTransactionUsingExecSql;
    private final DatabaseReentrantLock mLock = new DatabaseReentrantLock(true);
    private long mLockAcquiredWallTime = 0L;
    private long mLockAcquiredThreadTime = 0L;
    private static final int LOCK_WARNING_WINDOW_IN_MS = 20000;
    private static final int LOCK_ACQUIRED_WARNING_TIME_IN_MS = 300;
    private static final int LOCK_ACQUIRED_WARNING_THREAD_TIME_IN_MS = 100;
    private static final int LOCK_ACQUIRED_WARNING_TIME_IN_MS_ALWAYS_PRINT = 2000;
    private static final int SLEEP_AFTER_YIELD_QUANTUM = 1000;
    private static final Pattern EMAIL_IN_DB_PATTERN = Pattern.compile("[\\w\\.\\-]+@[\\w\\.\\-]+");
    private long mLastLockMessageTime = 0L;
    private static int sQueryLogTimeInMillis = 0;
    private static final int QUERY_LOG_SQL_LENGTH = 64;
    private static final String COMMIT_SQL = "COMMIT;";
    private static final String BEGIN_SQL = "BEGIN;";
    private final Random mRandom = new Random();
    private String mLastSqlStatement = null;
    private long mTransStartTime;
    static final String GET_LOCK_LOG_PREFIX = "GETLOCK:";
    volatile int mNativeHandle = 0;
    private static int sBlockSize = 0;
    private final String mPath;
    private String mPathForLogs = null;
    private final int mFlags;
    private final CursorFactory mFactory;
    private final WeakHashMap<SQLiteClosable, Object> mPrograms;
    private static final int DEFAULT_SQL_CACHE_SIZE = 25;
    private LruCache<String, SQLiteCompiledSql> mCompiledQueries;
    public static final int MAX_SQL_CACHE_SIZE = 100;
    private boolean mCacheFullWarning;
    private final Throwable mStackTrace;
    private final ArrayList<Integer> mClosedStatementIds = new ArrayList();
    private final DatabaseErrorHandler mErrorHandler;
    volatile DatabaseConnectionPool mConnectionPool = null;
    final short mConnectionNum;
    SQLiteDatabase mParentConnObj = null;
    private static final String MEMORY_DB_PATH = ":memory:";
    private volatile boolean mHasAttachedDbs = false;
    private static ArrayList<WeakReference<SQLiteDatabase>> mActiveDatabases = new ArrayList();
    private boolean mLockingEnabled = true;
    private static final long LOCK_WAIT_PERIOD = 30L;
    private final ArrayList<Integer> mCustomFunctions = new ArrayList();

    synchronized String getLastSqlStatement() {
        return this.mLastSqlStatement;
    }

    synchronized void setLastSqlStatement(String sql) {
        this.mLastSqlStatement = sql;
    }

    synchronized void addSQLiteClosable(SQLiteClosable closable) {
        this.mPrograms.put(closable, null);
    }

    synchronized void removeSQLiteClosable(SQLiteClosable closable) {
        this.mPrograms.remove(closable);
    }

    @Override
    protected void onAllReferencesReleased() {
        if (this.isOpen()) {
            this.close();
        }
    }

    public static int releaseMemory() {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteDatabase#releaseMemory()I", true, null);
    }

    public void setLockingEnabled(boolean lockingEnabled) {
        this.mLockingEnabled = lockingEnabled;
    }

    void onCorruption() {
        EventLog.writeEvent(75004, this.mPath);
        this.mErrorHandler.onCorruption(this);
    }

    void lock(String sql) {
        this.lock(sql, false);
    }

    void lock() {
        this.lock(null, false);
    }

    private void lock(String sql, boolean forced) {
        if (Thread.holdsLock(this)) {
            Log.w(TAG, "don't lock() while in a synchronized method");
        }
        this.verifyDbIsOpen();
        if (!forced && !this.mLockingEnabled) {
            return;
        }
        boolean done = false;
        long timeStart = SystemClock.uptimeMillis();
        while (!done) {
            try {
                done = this.mLock.tryLock(30L, TimeUnit.SECONDS);
                if (done) continue;
                Log.w(TAG, "database lock has not been available for 30 sec. Current Owner of the lock is " + this.mLock.getOwnerDescription() + ". Continuing to wait in thread: " + Thread.currentThread().getId());
            }
            catch (InterruptedException e) {}
        }
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.mLockAcquiredWallTime = SystemClock.elapsedRealtime();
            this.mLockAcquiredThreadTime = Debug.threadCpuTimeNanos();
        }
        if (sql != null) {
            // empty if block
        }
    }

    private void lockForced() {
        this.lock(null, true);
    }

    private void lockForced(String sql) {
        this.lock(sql, true);
    }

    void unlock() {
        if (!this.mLockingEnabled) {
            return;
        }
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.checkLockHoldTime();
        }
        this.mLock.unlock();
    }

    private void unlockForced() {
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.checkLockHoldTime();
        }
        this.mLock.unlock();
    }

    private void checkLockHoldTime() {
        int threadTime;
        long elapsedTime = SystemClock.elapsedRealtime();
        long lockedTime = elapsedTime - this.mLockAcquiredWallTime;
        if (lockedTime < 2000L && !Log.isLoggable(TAG, 2) && elapsedTime - this.mLastLockMessageTime < 20000L) {
            return;
        }
        if (lockedTime > 300L && ((threadTime = (int)((Debug.threadCpuTimeNanos() - this.mLockAcquiredThreadTime) / 1000000L)) > 100 || lockedTime > 2000L)) {
            this.mLastLockMessageTime = elapsedTime;
            String msg = "lock held on " + this.mPath + " for " + lockedTime + "ms. Thread time was " + threadTime + "ms";
            if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING_STACK_TRACE) {
                Log.d(TAG, msg, new Exception());
            } else {
                Log.d(TAG, msg);
            }
        }
    }

    public void beginTransaction() {
        this.beginTransaction(null, true);
    }

    public void beginTransactionNonExclusive() {
        this.beginTransaction(null, false);
    }

    public void beginTransactionWithListener(SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, true);
    }

    public void beginTransactionWithListenerNonExclusive(SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginTransaction(SQLiteTransactionListener transactionListener, boolean exclusive) {
        this.verifyDbIsOpen();
        this.lockForced(BEGIN_SQL);
        boolean ok = false;
        try {
            if (this.mLock.getHoldCount() > 1) {
                if (this.mInnerTransactionIsSuccessful) {
                    String msg = "Cannot call beginTransaction between calling setTransactionSuccessful and endTransaction";
                    IllegalStateException e = new IllegalStateException(msg);
                    Log.e(TAG, "beginTransaction() failed", e);
                    throw e;
                }
                ok = true;
                return;
            }
            if (exclusive && this.mConnectionPool == null) {
                this.execSQL("BEGIN EXCLUSIVE;");
            } else {
                this.execSQL("BEGIN IMMEDIATE;");
            }
            this.mTransStartTime = SystemClock.uptimeMillis();
            this.mTransactionListener = transactionListener;
            this.mTransactionIsSuccessful = true;
            this.mInnerTransactionIsSuccessful = false;
            if (transactionListener != null) {
                try {
                    transactionListener.onBegin();
                }
                catch (RuntimeException e) {
                    this.execSQL("ROLLBACK;");
                    throw e;
                }
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.unlockForced();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        block18: {
            this.verifyLockOwner();
            try {
                if (this.mInnerTransactionIsSuccessful) {
                    this.mInnerTransactionIsSuccessful = false;
                } else {
                    this.mTransactionIsSuccessful = false;
                }
                if (this.mLock.getHoldCount() != 1) {
                    return;
                }
                RuntimeException savedException = null;
                if (this.mTransactionListener != null) {
                    try {
                        if (this.mTransactionIsSuccessful) {
                            this.mTransactionListener.onCommit();
                        } else {
                            this.mTransactionListener.onRollback();
                        }
                    }
                    catch (RuntimeException e) {
                        savedException = e;
                        this.mTransactionIsSuccessful = false;
                    }
                }
                if (this.mTransactionIsSuccessful) {
                    this.execSQL(COMMIT_SQL);
                    if (this.mConnectionPool != null) {
                        this.execSQL("PRAGMA wal_checkpoint;");
                        if (SQLiteDebug.DEBUG_SQL_STATEMENTS) {
                            Log.i(TAG, "PRAGMA wal_Checkpoint done");
                        }
                    }
                    break block18;
                }
                try {
                    this.execSQL("ROLLBACK;");
                    if (savedException != null) {
                        throw savedException;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            finally {
                this.mTransactionListener = null;
                this.unlockForced();
            }
        }
    }

    public void setTransactionSuccessful() {
        this.verifyDbIsOpen();
        if (!this.mLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("no transaction pending");
        }
        if (this.mInnerTransactionIsSuccessful) {
            throw new IllegalStateException("setTransactionSuccessful may only be called once per call to beginTransaction");
        }
        this.mInnerTransactionIsSuccessful = true;
    }

    public boolean inTransaction() {
        return this.mLock.getHoldCount() > 0 || this.mTransactionUsingExecSql;
    }

    synchronized void setTransactionUsingExecSqlFlag() {
        if (Log.isLoggable(TAG, 3)) {
            Log.i(TAG, "found execSQL('begin transaction')");
        }
        this.mTransactionUsingExecSql = true;
    }

    synchronized void resetTransactionUsingExecSqlFlag() {
        if (Log.isLoggable(TAG, 3) && this.mTransactionUsingExecSql) {
            Log.i(TAG, "found execSQL('commit or end or rollback')");
        }
        this.mTransactionUsingExecSql = false;
    }

    synchronized boolean amIInTransaction() {
        boolean b;
        SQLiteDatabase db;
        SQLiteDatabase sQLiteDatabase = db = this.isPooledConnection() ? this.mParentConnObj : this;
        boolean bl = !db.inTransaction() ? false : (b = db.mTransactionUsingExecSql || db.mLock.isHeldByCurrentThread());
        if (Log.isLoggable(TAG, 3)) {
            Log.i(TAG, "amIinTransaction: " + b);
        }
        return b;
    }

    public boolean isDbLockedByCurrentThread() {
        return this.mLock.isHeldByCurrentThread();
    }

    public boolean isDbLockedByOtherThreads() {
        return !this.mLock.isHeldByCurrentThread() && this.mLock.isLocked();
    }

    @Deprecated
    public boolean yieldIfContended() {
        return this.yieldIfContendedHelper(false, -1L);
    }

    public boolean yieldIfContendedSafely() {
        return this.yieldIfContendedHelper(true, -1L);
    }

    public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) {
        return this.yieldIfContendedHelper(true, sleepAfterYieldDelay);
    }

    private boolean yieldIfContendedHelper(boolean checkFullyYielded, long sleepAfterYieldDelay) {
        if (this.mLock.getQueueLength() == 0) {
            this.mLockAcquiredWallTime = SystemClock.elapsedRealtime();
            this.mLockAcquiredThreadTime = Debug.threadCpuTimeNanos();
            return false;
        }
        this.setTransactionSuccessful();
        SQLiteTransactionListener transactionListener = this.mTransactionListener;
        this.endTransaction();
        if (checkFullyYielded && this.isDbLockedByCurrentThread()) {
            throw new IllegalStateException("Db locked more than once. yielfIfContended cannot yield");
        }
        if (sleepAfterYieldDelay > 0L) {
            for (long remainingDelay = sleepAfterYieldDelay; remainingDelay > 0L; remainingDelay -= 1000L) {
                try {
                    Thread.sleep(remainingDelay < 1000L ? remainingDelay : 1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                if (this.mLock.getQueueLength() != 0) continue;
            }
        }
        this.beginTransactionWithListener(transactionListener);
        return true;
    }

    @Deprecated
    public Map<String, String> getSyncedTables() {
        return new HashMap<String, String>(0);
    }

    public static SQLiteDatabase openDatabase(String path, CursorFactory factory, int flags) {
        return SQLiteDatabase.openDatabase(path, factory, flags, new DefaultDatabaseErrorHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLiteDatabase openDatabase(String path, CursorFactory factory, int flags, DatabaseErrorHandler errorHandler) {
        SQLiteDatabase sqliteDatabase = SQLiteDatabase.openDatabase(path, factory, flags, errorHandler, (short)0);
        if (sBlockSize == 0) {
            sBlockSize = new StatFs("/data").getBlockSize();
        }
        sqliteDatabase.setPageSize(sBlockSize);
        sqliteDatabase.setJournalMode(path, "TRUNCATE");
        ArrayList<WeakReference<SQLiteDatabase>> arrayList = mActiveDatabases;
        synchronized (arrayList) {
            mActiveDatabases.add(new WeakReference<SQLiteDatabase>(sqliteDatabase));
        }
        return sqliteDatabase;
    }

    private static SQLiteDatabase openDatabase(String path, CursorFactory factory, int flags, DatabaseErrorHandler errorHandler, short connectionNum) {
        SQLiteDatabase db = new SQLiteDatabase(path, factory, flags, errorHandler, connectionNum);
        try {
            if (Log.isLoggable(TAG, 3)) {
                Log.i(TAG, "opening the db : " + path);
            }
            db.dbopen(path, flags);
            db.setLocale(Locale.getDefault());
            if (SQLiteDebug.DEBUG_SQL_STATEMENTS) {
                db.enableSqlTracing(path, connectionNum);
            }
            if (SQLiteDebug.DEBUG_SQL_TIME) {
                db.enableSqlProfiling(path, connectionNum);
            }
            return db;
        }
        catch (SQLiteDatabaseCorruptException e) {
            db.mErrorHandler.onCorruption(db);
            return SQLiteDatabase.openDatabase(path, factory, flags, errorHandler);
        }
        catch (SQLiteException e) {
            Log.e(TAG, "Failed to open the database. closing it.", e);
            db.close();
            throw e;
        }
    }

    public static SQLiteDatabase openOrCreateDatabase(File file, CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase(file.getPath(), factory);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, CursorFactory factory) {
        return SQLiteDatabase.openDatabase(path, factory, 0x10000000);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, CursorFactory factory, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openDatabase(path, factory, 0x10000000, errorHandler);
    }

    private void setJournalMode(String dbPath, String mode) {
        if (dbPath.equalsIgnoreCase(MEMORY_DB_PATH) || this.isReadOnly()) {
            return;
        }
        String s = DatabaseUtils.stringForQuery(this, "PRAGMA journal_mode=" + mode, null);
        if (!s.equalsIgnoreCase(mode)) {
            Log.e(TAG, "setting journal_mode to " + mode + " failed for db: " + dbPath + " (on pragma set journal_mode, sqlite returned:" + s);
        }
    }

    public static SQLiteDatabase create(CursorFactory factory) {
        return SQLiteDatabase.openDatabase(MEMORY_DB_PATH, factory, 0x10000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        if (Log.isLoggable(TAG, 3)) {
            Log.i(TAG, "closing db: " + this.mPath + " (connection # " + this.mConnectionNum);
        }
        this.lock();
        try {
            if (!this.isOpen()) {
                return;
            }
            this.closeClosable();
            this.closePendingStatements();
            this.releaseCustomFunctions();
            this.closeDatabase();
            if (this.mConnectionPool != null) {
                if (Log.isLoggable(TAG, 3)) {
                    assert (this.mConnectionPool != null);
                    Log.i(TAG, this.mConnectionPool.toString());
                }
                this.mConnectionPool.close();
            }
        }
        finally {
            this.unlock();
        }
    }

    private void closeClosable() {
        this.deallocCachedSqlStatements();
        for (Map.Entry<SQLiteClosable, Object> entry : this.mPrograms.entrySet()) {
            SQLiteClosable program = entry.getKey();
            if (program == null) continue;
            program.onAllReferencesReleasedFromContainer();
        }
    }

    void closeDatabase() throws SQLiteException {
        try {
            this.dbclose();
        }
        catch (SQLiteUnfinalizedObjectsException e) {
            String msg = e.getMessage();
            String[] tokens = msg.split(",", 2);
            int stmtId = Integer.parseInt(tokens[0]);
            Iterator<Map.Entry<SQLiteClosable, Object>> iter = this.mPrograms.entrySet().iterator();
            boolean found = false;
            while (iter.hasNext()) {
                Map.Entry<SQLiteClosable, Object> entry = iter.next();
                SQLiteClosable program = entry.getKey();
                if (program == null || !(program instanceof SQLiteProgram)) continue;
                SQLiteCompiledSql compiledSql = ((SQLiteProgram)program).mCompiledSql;
                if (compiledSql.nStatement != stmtId) continue;
                msg = compiledSql.toString();
                found = true;
            }
            if (!found) {
                if (this.mClosedStatementIds.contains(stmtId)) {
                    Log.w(TAG, "this shouldn't happen. finalizing the statement now: ");
                    this.closePendingStatements();
                    this.closeDatabase();
                }
            }
            throw new SQLiteUnfinalizedObjectsException("close() on database: " + this.getPath() + " failed due to un-close()d SQL statements: " + msg);
        }
    }

    private void dbclose() {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#dbclose()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomFunction(String name, int numArgs, CustomFunction function) {
        this.verifyDbIsOpen();
        ArrayList<Integer> arrayList = this.mCustomFunctions;
        synchronized (arrayList) {
            int ref = this.native_addCustomFunction(name, numArgs, function);
            if (ref == 0) {
                throw new SQLiteException("failed to add custom function " + name);
            }
            this.mCustomFunctions.add(new Integer(ref));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseCustomFunctions() {
        ArrayList<Integer> arrayList = this.mCustomFunctions;
        synchronized (arrayList) {
            for (int i = 0; i < this.mCustomFunctions.size(); ++i) {
                Integer function = this.mCustomFunctions.get(i);
                this.native_releaseCustomFunction(function);
            }
            this.mCustomFunctions.clear();
        }
    }

    private int native_addCustomFunction(String string2, int n, CustomFunction customFunction) {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteDatabase#native_addCustomFunction(Ljava/lang/String;ILandroid/database/sqlite/SQLiteDatabase$CustomFunction;)I", true, this);
    }

    private void native_releaseCustomFunction(int n) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#native_releaseCustomFunction(I)V", true, this);
    }

    public int getVersion() {
        return Long.valueOf(DatabaseUtils.longForQuery(this, "PRAGMA user_version;", null)).intValue();
    }

    public void setVersion(int version) {
        this.execSQL("PRAGMA user_version = " + version);
    }

    public long getMaximumSize() {
        long pageCount = DatabaseUtils.longForQuery(this, "PRAGMA max_page_count;", null);
        return pageCount * this.getPageSize();
    }

    public long setMaximumSize(long numBytes) {
        long pageSize = this.getPageSize();
        long numPages = numBytes / pageSize;
        if (numBytes % pageSize != 0L) {
            ++numPages;
        }
        long newPageCount = DatabaseUtils.longForQuery(this, "PRAGMA max_page_count = " + numPages, null);
        return newPageCount * pageSize;
    }

    public long getPageSize() {
        return DatabaseUtils.longForQuery(this, "PRAGMA page_size;", null);
    }

    public void setPageSize(long numBytes) {
        this.execSQL("PRAGMA page_size = " + numBytes);
    }

    @Deprecated
    public void markTableSyncable(String table, String deletedTable) {
    }

    @Deprecated
    public void markTableSyncable(String table, String foreignKey, String updateTable) {
    }

    public static String findEditTable(String tables) {
        if (!TextUtils.isEmpty(tables)) {
            int spacepos = tables.indexOf(32);
            int commapos = tables.indexOf(44);
            if (spacepos > 0 && (spacepos < commapos || commapos < 0)) {
                return tables.substring(0, spacepos);
            }
            if (commapos > 0 && (commapos < spacepos || spacepos < 0)) {
                return tables.substring(0, commapos);
            }
            return tables;
        }
        throw new IllegalStateException("Invalid tables");
    }

    public SQLiteStatement compileStatement(String sql) throws SQLException {
        this.verifyDbIsOpen();
        return new SQLiteStatement(this, sql, null);
    }

    public Cursor query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        this.verifyDbIsOpen();
        String sql = SQLiteQueryBuilder.buildQueryString(distinct, table, columns, selection, groupBy, having, orderBy, limit);
        return this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, SQLiteDatabase.findEditTable(table));
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor rawQuery(String sql, String[] selectionArgs) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String sql, String[] selectionArgs, String editTable) {
        this.verifyDbIsOpen();
        BlockGuard.getThreadPolicy().onReadFromDisk();
        SQLiteDatabase db = this.getDbConnection(sql);
        SQLiteDirectCursorDriver driver = new SQLiteDirectCursorDriver(db, sql, editTable);
        Cursor cursor = null;
        try {
            cursor = driver.query(cursorFactory != null ? cursorFactory : this.mFactory, selectionArgs);
        }
        finally {
            this.releaseDbConnection(db);
        }
        return cursor;
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, values, 0);
        }
        catch (SQLException e) {
            Log.e(TAG, "Error inserting " + values, e);
            return -1L;
        }
    }

    public long insertOrThrow(String table, String nullColumnHack, ContentValues values) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, values, 0);
    }

    public long replace(String table, String nullColumnHack, ContentValues initialValues) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
        }
        catch (SQLException e) {
            Log.e(TAG, "Error inserting " + initialValues, e);
            return -1L;
        }
    }

    public long replaceOrThrow(String table, String nullColumnHack, ContentValues initialValues) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
    }

    public long insertWithOnConflict(String table, String nullColumnHack, ContentValues initialValues, int conflictAlgorithm) {
        int size;
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT");
        sql.append(CONFLICT_VALUES[conflictAlgorithm]);
        sql.append(" INTO ");
        sql.append(table);
        sql.append('(');
        Object[] bindArgs = null;
        int n = size = initialValues != null && initialValues.size() > 0 ? initialValues.size() : 0;
        if (size > 0) {
            bindArgs = new Object[size];
            int i = 0;
            for (String colName : initialValues.keySet()) {
                sql.append(i > 0 ? "," : "");
                sql.append(colName);
                bindArgs[i++] = initialValues.get(colName);
            }
            sql.append(')');
            sql.append(" VALUES (");
            for (i = 0; i < size; ++i) {
                sql.append(i > 0 ? ",?" : "?");
            }
        } else {
            sql.append(nullColumnHack + ") VALUES (NULL");
        }
        sql.append(')');
        SQLiteStatement statement = new SQLiteStatement(this, sql.toString(), bindArgs);
        try {
            long i$ = statement.executeInsert();
            return i$;
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            statement.close();
        }
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        SQLiteStatement statement = new SQLiteStatement(this, "DELETE FROM " + table + (!TextUtils.isEmpty(whereClause) ? " WHERE " + whereClause : ""), whereArgs);
        try {
            int n = statement.executeUpdateDelete();
            return n;
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            statement.close();
        }
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        return this.updateWithOnConflict(table, values, whereClause, whereArgs, 0);
    }

    public int updateWithOnConflict(String table, ContentValues values, String whereClause, String[] whereArgs, int conflictAlgorithm) {
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("Empty values");
        }
        StringBuilder sql = new StringBuilder(120);
        sql.append("UPDATE ");
        sql.append(CONFLICT_VALUES[conflictAlgorithm]);
        sql.append(table);
        sql.append(" SET ");
        int setValuesSize = values.size();
        int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
        Object[] bindArgs = new Object[bindArgsSize];
        int i = 0;
        for (String colName : values.keySet()) {
            sql.append(i > 0 ? "," : "");
            sql.append(colName);
            bindArgs[i++] = values.get(colName);
            sql.append("=?");
        }
        if (whereArgs != null) {
            for (i = setValuesSize; i < bindArgsSize; ++i) {
                bindArgs[i] = whereArgs[i - setValuesSize];
            }
        }
        if (!TextUtils.isEmpty(whereClause)) {
            sql.append(" WHERE ");
            sql.append(whereClause);
        }
        SQLiteStatement statement = new SQLiteStatement(this, sql.toString(), bindArgs);
        try {
            int colName = statement.executeUpdateDelete();
            return colName;
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            statement.close();
        }
    }

    public void execSQL(String sql) throws SQLException {
        this.executeSql(sql, null);
    }

    public void execSQL(String sql, Object[] bindArgs) throws SQLException {
        if (bindArgs == null) {
            throw new IllegalArgumentException("Empty bindArgs");
        }
        this.executeSql(sql, bindArgs);
    }

    private int executeSql(String sql, Object[] bindArgs) throws SQLException {
        if (DatabaseUtils.getSqlStatementType(sql) == 3) {
            this.disableWriteAheadLogging();
            this.mHasAttachedDbs = true;
        }
        SQLiteStatement statement = new SQLiteStatement(this, sql, bindArgs);
        try {
            int n = statement.executeUpdateDelete();
            return n;
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.isOpen()) {
                Log.e(TAG, "close() was never explicitly called on database '" + this.mPath + "' ", this.mStackTrace);
                this.closeClosable();
                this.onAllReferencesReleased();
                this.releaseCustomFunctions();
            }
        }
        finally {
            super.finalize();
        }
    }

    private SQLiteDatabase(String path, CursorFactory factory, int flags, DatabaseErrorHandler errorHandler, short connectionNum) {
        if (path == null) {
            throw new IllegalArgumentException("path should not be null");
        }
        this.setMaxSqlCacheSize(25);
        this.mFlags = flags;
        this.mPath = path;
        this.mStackTrace = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.mFactory = factory;
        this.mPrograms = new WeakHashMap();
        this.mErrorHandler = errorHandler == null ? new DefaultDatabaseErrorHandler() : errorHandler;
        this.mConnectionNum = connectionNum;
        int limit = Resources.getSystem().getInteger(17694761) * 1024 * 4;
        this.native_setSqliteSoftHeapLimit(limit);
    }

    public boolean isReadOnly() {
        return (this.mFlags & 1) == 1;
    }

    public boolean isOpen() {
        return this.mNativeHandle != 0;
    }

    public boolean needUpgrade(int newVersion) {
        return newVersion > this.getVersion();
    }

    public String getPath() {
        return this.mPath;
    }

    void logTimeStat(String sql, long beginMillis) {
    }

    private void logTimeStat(String sql, long beginMillis, String prefix) {
        String blockingPackage;
        int samplePercent;
        long durationMillis = SystemClock.uptimeMillis() - beginMillis;
        if (durationMillis == 0L && prefix == GET_LOCK_LOG_PREFIX) {
            return;
        }
        if (sQueryLogTimeInMillis == 0) {
            sQueryLogTimeInMillis = SystemProperties.getInt("db.db_operation.threshold_ms", 500);
        }
        if (durationMillis >= (long)sQueryLogTimeInMillis) {
            samplePercent = 100;
        } else {
            samplePercent = (int)(100L * durationMillis / (long)sQueryLogTimeInMillis) + 1;
            if (this.mRandom.nextInt(100) >= samplePercent) {
                return;
            }
        }
        if (prefix != null) {
            sql = prefix + sql;
        }
        if (sql.length() > 64) {
            sql = sql.substring(0, 64);
        }
        if ((blockingPackage = AppGlobals.getInitialPackage()) == null) {
            blockingPackage = "";
        }
        EventLog.writeEvent(52000, this.getPathForLogs(), sql, durationMillis, blockingPackage, samplePercent);
    }

    private String getPathForLogs() {
        if (this.mPathForLogs != null) {
            return this.mPathForLogs;
        }
        if (this.mPath == null) {
            return null;
        }
        this.mPathForLogs = this.mPath.indexOf(64) == -1 ? this.mPath : EMAIL_IN_DB_PATTERN.matcher(this.mPath).replaceAll("XX@YY");
        return this.mPathForLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        this.lock();
        try {
            this.native_setLocale(locale.toString(), this.mFlags);
        }
        finally {
            this.unlock();
        }
    }

    void verifyDbIsOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("database " + this.getPath() + " (conn# " + this.mConnectionNum + ") already closed");
        }
    }

    void verifyLockOwner() {
        this.verifyDbIsOpen();
        if (this.mLockingEnabled && !this.isDbLockedByCurrentThread()) {
            throw new IllegalStateException("Don't have database lock!");
        }
    }

    synchronized void addToCompiledQueries(String sql, SQLiteCompiledSql compiledStatement) {
        int maxCacheSz;
        if (this.mCompiledQueries.get(sql) != null) {
            return;
        }
        int n = maxCacheSz = this.mConnectionNum == 0 ? this.mCompiledQueries.maxSize() : this.mParentConnObj.mCompiledQueries.maxSize();
        if (SQLiteDebug.DEBUG_SQL_CACHE) {
            boolean printWarning;
            boolean bl = this.mConnectionNum == 0 ? !this.mCacheFullWarning && this.mCompiledQueries.size() == maxCacheSz : (printWarning = !this.mParentConnObj.mCacheFullWarning && this.mParentConnObj.mCompiledQueries.size() == maxCacheSz);
            if (printWarning) {
                Log.w(TAG, "Reached MAX size for compiled-sql statement cache for database " + this.getPath() + ". Use setMaxSqlCacheSize() to increase cachesize. ");
                this.mCacheFullWarning = true;
                Log.d(TAG, "Here are the SQL statements in Cache of database: " + this.mPath);
                for (String s : this.mCompiledQueries.snapshot().keySet()) {
                    Log.d(TAG, "Sql statement in Cache: " + s);
                }
            }
        }
        this.mCompiledQueries.put(sql, compiledStatement);
    }

    synchronized void deallocCachedSqlStatements() {
        for (SQLiteCompiledSql compiledSql : this.mCompiledQueries.snapshot().values()) {
            compiledSql.releaseSqlStatement();
        }
        this.mCompiledQueries.evictAll();
    }

    synchronized SQLiteCompiledSql getCompiledStatementForSql(String sql) {
        return this.mCompiledQueries.get(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSqlCacheSize(int cacheSize) {
        SQLiteDatabase sQLiteDatabase = this;
        synchronized (sQLiteDatabase) {
            LruCache<String, SQLiteCompiledSql> oldCompiledQueries = this.mCompiledQueries;
            if (cacheSize > 100 || cacheSize < 0) {
                throw new IllegalStateException("expected value between 0 and 100");
            }
            if (oldCompiledQueries != null && cacheSize < oldCompiledQueries.maxSize()) {
                throw new IllegalStateException("cannot set cacheSize to a value less than the value set with previous setMaxSqlCacheSize() call.");
            }
            this.mCompiledQueries = new LruCache<String, SQLiteCompiledSql>(cacheSize){

                @Override
                protected void entryRemoved(boolean evicted, String key, SQLiteCompiledSql oldValue, SQLiteCompiledSql newValue) {
                    SQLiteDatabase.this.verifyLockOwner();
                    oldValue.releaseIfNotInUse();
                }
            };
            if (oldCompiledQueries != null) {
                for (Map.Entry<String, SQLiteCompiledSql> entry : oldCompiledQueries.snapshot().entrySet()) {
                    this.mCompiledQueries.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    synchronized boolean isInStatementCache(String sql) {
        return this.mCompiledQueries.get(sql) != null;
    }

    synchronized void releaseCompiledSqlObj(String sql, SQLiteCompiledSql compiledSql) {
        if (this.mCompiledQueries.get(sql) == compiledSql) {
            compiledSql.release();
        } else {
            compiledSql.releaseSqlStatement();
        }
    }

    private synchronized int getCacheHitNum() {
        return this.mCompiledQueries.hitCount();
    }

    private synchronized int getCacheMissNum() {
        return this.mCompiledQueries.missCount();
    }

    private synchronized int getCachesize() {
        return this.mCompiledQueries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeStatementLater(int id2) {
        if (!this.isOpen()) {
            return;
        }
        ArrayList<Integer> arrayList = this.mClosedStatementIds;
        synchronized (arrayList) {
            if (this.mClosedStatementIds.contains(id2)) {
                return;
            }
            this.mClosedStatementIds.add(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInQueueOfStatementsToBeFinalized(int id2) {
        if (!this.isOpen()) {
            return true;
        }
        ArrayList<Integer> arrayList = this.mClosedStatementIds;
        synchronized (arrayList) {
            return this.mClosedStatementIds.contains(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closePendingStatements() {
        if (!this.isOpen()) {
            this.mClosedStatementIds.clear();
            return;
        }
        this.verifyLockOwner();
        ArrayList<Integer> list = new ArrayList<Integer>(this.mClosedStatementIds.size());
        ArrayList<Integer> arrayList = this.mClosedStatementIds;
        synchronized (arrayList) {
            list.addAll(this.mClosedStatementIds);
            this.mClosedStatementIds.clear();
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.native_finalize((Integer)list.get(i));
        }
    }

    ArrayList<Integer> getQueuedUpStmtList() {
        return this.mClosedStatementIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableWriteAheadLogging() {
        if (this.isReadOnly()) {
            return false;
        }
        this.lock();
        try {
            if (this.mConnectionPool != null) {
                boolean bl = true;
                return bl;
            }
            if (this.mPath.equalsIgnoreCase(MEMORY_DB_PATH)) {
                Log.i(TAG, "can't enable WAL for memory databases.");
                boolean bl = false;
                return bl;
            }
            if (this.mHasAttachedDbs) {
                if (Log.isLoggable(TAG, 3)) {
                    Log.d(TAG, "this database: " + this.mPath + " has attached databases. can't  enable WAL.");
                }
                boolean bl = false;
                return bl;
            }
            this.mConnectionPool = new DatabaseConnectionPool(this);
            this.setJournalMode(this.mPath, "WAL");
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableWriteAheadLogging() {
        this.lock();
        try {
            if (this.mConnectionPool == null) {
                return;
            }
            this.mConnectionPool.close();
            this.setJournalMode(this.mPath, "TRUNCATE");
            this.mConnectionPool = null;
        }
        finally {
            this.unlock();
        }
    }

    SQLiteDatabase getDatabaseHandle(String sql) {
        if (this.isPooledConnection()) {
            if (this.isOpen() && !this.amIInTransaction()) {
                return this;
            }
            return this.getParentDbConnObj().getDbConnection(sql);
        }
        return this.getDbConnection(sql);
    }

    SQLiteDatabase createPoolConnection(short connectionNum) {
        SQLiteDatabase db = SQLiteDatabase.openDatabase(this.mPath, this.mFactory, this.mFlags, this.mErrorHandler, connectionNum);
        db.mParentConnObj = this;
        return db;
    }

    private synchronized SQLiteDatabase getParentDbConnObj() {
        return this.mParentConnObj;
    }

    private boolean isPooledConnection() {
        return this.mConnectionNum > 0;
    }

    SQLiteDatabase getDbConnection(String sql) {
        this.verifyDbIsOpen();
        if (this.isPooledConnection()) {
            return this;
        }
        if (this.amIInTransaction() || this.mConnectionPool == null) {
            return this;
        }
        if (Log.isLoggable(TAG, 3)) {
            assert (this.mConnectionPool != null);
            Log.i(TAG, this.mConnectionPool.toString());
        }
        return this.mConnectionPool.get(sql);
    }

    private void releaseDbConnection(SQLiteDatabase db) {
        if (!this.isOpen() || !db.isPooledConnection() || db == this) {
            return;
        }
        if (Log.isLoggable(TAG, 3)) {
            assert (this.isPooledConnection());
            assert (this.mConnectionPool != null);
            Log.d(TAG, "releaseDbConnection threadid = " + Thread.currentThread().getId() + ", releasing # " + db.mConnectionNum + ", " + this.getPath());
        }
        this.mConnectionPool.release(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList<SQLiteDebug.DbStats> getDbStats() {
        ArrayList tempList;
        ArrayList<SQLiteDebug.DbStats> dbStatsList = new ArrayList<SQLiteDebug.DbStats>();
        ArrayList<WeakReference<SQLiteDatabase>> arrayList = mActiveDatabases;
        synchronized (arrayList) {
            tempList = (ArrayList)mActiveDatabases.clone();
        }
        for (WeakReference w : tempList) {
            SQLiteDatabase db = (SQLiteDatabase)w.get();
            if (db == null || !db.isOpen()) continue;
            try {
                int lookasideUsed = db.native_getDbLookaside();
                String path = db.getPath();
                int indx = path.lastIndexOf("/");
                String lastnode = path.substring(indx != -1 ? ++indx : 0);
                List<Pair<String, String>> attachedDbs = db.getAttachedDbs();
                if (attachedDbs == null) continue;
                for (int i = 0; i < attachedDbs.size(); ++i) {
                    String dbName;
                    Pair<String, String> p = attachedDbs.get(i);
                    long pageCount = DatabaseUtils.longForQuery(db, "PRAGMA " + (String)p.first + ".page_count;", null);
                    if (i == 0) {
                        dbName = lastnode;
                    } else {
                        lookasideUsed = 0;
                        dbName = "  (attached) " + (String)p.first;
                        if (((String)p.second).trim().length() > 0) {
                            int idx = ((String)p.second).lastIndexOf("/");
                            dbName = dbName + " : " + ((String)p.second).substring(idx != -1 ? ++idx : 0);
                        }
                    }
                    if (pageCount <= 0L) continue;
                    dbStatsList.add(new SQLiteDebug.DbStats(dbName, pageCount, db.getPageSize(), lookasideUsed, db.getCacheHitNum(), db.getCacheMissNum(), db.getCachesize()));
                }
                DatabaseConnectionPool connPool = db.mConnectionPool;
                if (connPool == null) continue;
                for (SQLiteDatabase pDb : connPool.getConnectionList()) {
                    dbStatsList.add(new SQLiteDebug.DbStats("(pooled # " + pDb.mConnectionNum + ") " + lastnode, 0L, 0L, 0, pDb.getCacheHitNum(), pDb.getCacheMissNum(), pDb.getCachesize()));
                }
            }
            catch (SQLiteException e) {
            }
        }
        return dbStatsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, String>> getAttachedDbs() {
        if (!this.isOpen()) {
            return null;
        }
        ArrayList<Pair<String, String>> attachedDbs = new ArrayList<Pair<String, String>>();
        if (!this.mHasAttachedDbs) {
            attachedDbs.add(new Pair<String, String>("main", this.mPath));
            return attachedDbs;
        }
        Cursor c = null;
        try {
            c = this.rawQuery("pragma database_list;", null);
            while (c.moveToNext()) {
                attachedDbs.add(new Pair<String, String>(c.getString(1), c.getString(2)));
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return attachedDbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDatabaseIntegrityOk() {
        this.verifyDbIsOpen();
        List<Pair<String, String>> attachedDbs = null;
        try {
            attachedDbs = this.getAttachedDbs();
            if (attachedDbs == null) {
                throw new IllegalStateException("databaselist for: " + this.getPath() + " couldn't " + "be retrieved. probably because the database is closed");
            }
        }
        catch (SQLiteException e) {
            attachedDbs = new ArrayList<Pair<String, String>>();
            attachedDbs.add(new Pair<String, String>("main", this.mPath));
        }
        for (int i = 0; i < attachedDbs.size(); ++i) {
            Pair<String, String> p = attachedDbs.get(i);
            SQLiteProgram prog = null;
            try {
                prog = this.compileStatement("PRAGMA " + (String)p.first + ".integrity_check(1);");
                String rslt = ((SQLiteStatement)prog).simpleQueryForString();
                if (rslt.equalsIgnoreCase("ok")) continue;
                Log.e(TAG, "PRAGMA integrity_check on " + (String)p.second + " returned: " + rslt);
                boolean bl = false;
                return bl;
            }
            finally {
                if (prog != null) {
                    prog.close();
                }
            }
        }
        return true;
    }

    private void dbopen(String string2, int n) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#dbopen(Ljava/lang/String;I)V", true, this);
    }

    private void enableSqlTracing(String string2, short s) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#enableSqlTracing(Ljava/lang/String;S)V", true, this);
    }

    private void enableSqlProfiling(String string2, short s) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#enableSqlProfiling(Ljava/lang/String;S)V", true, this);
    }

    private void native_setLocale(String string2, int n) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#native_setLocale(Ljava/lang/String;I)V", true, this);
    }

    private int native_getDbLookaside() {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteDatabase#native_getDbLookaside()I", true, this);
    }

    private void native_finalize(int n) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#native_finalize(I)V", true, this);
    }

    private void native_setSqliteSoftHeapLimit(int n) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#native_setSqliteSoftHeapLimit(I)V", true, this);
    }

    public static interface CustomFunction {
        public void callback(String[] var1);
    }

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }

    private static class DatabaseReentrantLock
    extends ReentrantLock {
        DatabaseReentrantLock(boolean fair) {
            super(fair);
        }

        public Thread getOwner() {
            return super.getOwner();
        }

        public String getOwnerDescription() {
            Thread t = this.getOwner();
            return t == null ? "none" : String.valueOf(t.getId());
        }
    }
}

