/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Shader;
import android.graphics.Shader_Delegate;
import java.awt.Paint;

public abstract class Gradient_Delegate
extends Shader_Delegate {
    protected final int[] mColors;
    protected final float[] mPositions;

    public boolean isSupported() {
        return true;
    }

    public String getSupportMessage() {
        return null;
    }

    protected Gradient_Delegate(int[] nArray, float[] fArray) {
        if (nArray.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        if (fArray != null && nArray.length != fArray.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        if (fArray == null) {
            float f = 1.0f / (float)(nArray.length - 1);
            fArray = new float[nArray.length];
            fArray[0] = 0.0f;
            fArray[nArray.length - 1] = 1.0f;
            for (int i = 1; i < nArray.length - 1; ++i) {
                fArray[i] = f * (float)i;
            }
        }
        this.mColors = nArray;
        this.mPositions = fArray;
    }

    protected static abstract class GradientPaint
    implements Paint {
        private static final int GRADIENT_SIZE = 100;
        private final int[] mColors;
        private final float[] mPositions;
        private final Shader.TileMode mTileMode;
        private int[] mGradient;

        protected GradientPaint(int[] nArray, float[] fArray, Shader.TileMode tileMode) {
            this.mColors = nArray;
            this.mPositions = fArray;
            this.mTileMode = tileMode;
        }

        public int getTransparency() {
            return 3;
        }

        protected void precomputeGradientColors() {
            if (this.mGradient == null) {
                this.mGradient = new int[101];
                int n = 0;
                int n2 = 1;
                for (int i = 0; i <= 100; ++i) {
                    float f = (float)i / 100.0f;
                    while (f > this.mPositions[n2]) {
                        n = n2++;
                    }
                    float f2 = (f - this.mPositions[n]) / (this.mPositions[n2] - this.mPositions[n]);
                    this.mGradient[i] = this.computeColor(this.mColors[n], this.mColors[n2], f2);
                }
            }
        }

        protected int getGradientColor(float f) {
            int n;
            if (f < 0.0f) {
                if (this.mTileMode != null) {
                    switch (this.mTileMode) {
                        case CLAMP: {
                            f = 0.0f;
                            break;
                        }
                        case REPEAT: {
                            f -= (float)Math.floor(f);
                            break;
                        }
                        case MIRROR: {
                            f = Math.abs(f);
                            n = (int)Math.floor(f);
                            f -= (float)n;
                            if (n % 2 != 1) break;
                            f = 1.0f - f;
                        }
                    }
                } else {
                    f = 0.0f;
                }
            } else if (f > 1.0f) {
                if (this.mTileMode != null) {
                    switch (this.mTileMode) {
                        case CLAMP: {
                            f = 1.0f;
                            break;
                        }
                        case REPEAT: {
                            f -= (float)Math.floor(f);
                            break;
                        }
                        case MIRROR: {
                            n = (int)Math.floor(f);
                            f -= (float)n;
                            if (n % 2 != 1) break;
                            f = 1.0f - f;
                        }
                    }
                } else {
                    f = 1.0f;
                }
            }
            n = (int)((double)(f * 100.0f) + 0.5);
            return this.mGradient[n];
        }

        private int computeColor(int n, int n2, float f) {
            int n3 = this.computeChannel(n >> 24 & 0xFF, n2 >> 24 & 0xFF, f);
            int n4 = this.computeChannel(n >> 16 & 0xFF, n2 >> 16 & 0xFF, f);
            int n5 = this.computeChannel(n >> 8 & 0xFF, n2 >> 8 & 0xFF, f);
            int n6 = this.computeChannel(n & 0xFF, n2 & 0xFF, f);
            return n3 << 24 | n4 << 16 | n5 << 8 | n6;
        }

        private int computeChannel(int n, int n2, float f) {
            return n + (int)((double)(f * (float)(n2 - n)) + 0.5);
        }
    }
}

