/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Gradient_Delegate;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.Shader_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public final class LinearGradient_Delegate
extends Gradient_Delegate {
    private Paint mJavaPaint;

    public Paint getJavaPaint() {
        return this.mJavaPaint;
    }

    @LayoutlibDelegate
    static int nativeCreate1(LinearGradient linearGradient, float f, float f2, float f3, float f4, int[] nArray, float[] fArray, int n) {
        LinearGradient_Delegate linearGradient_Delegate = new LinearGradient_Delegate(f, f2, f3, f4, nArray, fArray, Shader_Delegate.getTileMode(n));
        return sManager.addNewDelegate(linearGradient_Delegate);
    }

    @LayoutlibDelegate
    static int nativeCreate2(LinearGradient linearGradient, float f, float f2, float f3, float f4, int n, int n2, int n3) {
        return LinearGradient_Delegate.nativeCreate1(linearGradient, f, f2, f3, f4, new int[]{n, n2}, null, n3);
    }

    @LayoutlibDelegate
    static int nativePostCreate1(LinearGradient linearGradient, int n, float f, float f2, float f3, float f4, int[] nArray, float[] fArray, int n2) {
        return 0;
    }

    @LayoutlibDelegate
    static int nativePostCreate2(LinearGradient linearGradient, int n, float f, float f2, float f3, float f4, int n2, int n3, int n4) {
        return 0;
    }

    private LinearGradient_Delegate(float f, float f2, float f3, float f4, int[] nArray, float[] fArray, Shader.TileMode tileMode) {
        super(nArray, fArray);
        this.mJavaPaint = new LinearGradientPaint(f, f2, f3, f4, this.mColors, this.mPositions, tileMode);
    }

    private class LinearGradientPaint
    extends Gradient_Delegate.GradientPaint {
        private final float mX0;
        private final float mY0;
        private final float mDx;
        private final float mDy;
        private final float mDSize2;

        public LinearGradientPaint(float f, float f2, float f3, float f4, int[] nArray, float[] fArray, Shader.TileMode tileMode) {
            super(nArray, fArray, tileMode);
            this.mX0 = f;
            this.mY0 = f2;
            this.mDx = f3 - f;
            this.mDy = f4 - f2;
            this.mDSize2 = this.mDx * this.mDx + this.mDy * this.mDy;
        }

        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            AffineTransform affineTransform2;
            this.precomputeGradientColors();
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in LinearGradient", (Throwable)noninvertibleTransformException, null);
                affineTransform2 = new AffineTransform();
            }
            AffineTransform affineTransform3 = LinearGradient_Delegate.this.getLocalMatrix();
            try {
                affineTransform3 = affineTransform3.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in LinearGradient", (Throwable)noninvertibleTransformException, null);
                affineTransform3 = new AffineTransform();
            }
            return new LinearGradientPaintContext(affineTransform2, affineTransform3, colorModel);
        }

        private int getColor(float f, float f2) {
            float f3;
            if (this.mDx == 0.0f) {
                f3 = (f2 - this.mY0) / this.mDy;
            } else if (this.mDy == 0.0f) {
                f3 = (f - this.mX0) / this.mDx;
            } else {
                float f4 = (this.mDx * this.mDy * (f2 - this.mY0) + this.mDy * this.mDy * this.mX0 + this.mDx * this.mDx * f) / this.mDSize2;
                f3 = (f4 - this.mX0) / this.mDx;
            }
            return this.getGradientColor(f3);
        }

        private class LinearGradientPaintContext
        implements PaintContext {
            private final AffineTransform mCanvasMatrix;
            private final AffineTransform mLocalMatrix;
            private final ColorModel mColorModel;

            private LinearGradientPaintContext(AffineTransform affineTransform, AffineTransform affineTransform2, ColorModel colorModel) {
                this.mCanvasMatrix = affineTransform;
                this.mLocalMatrix = affineTransform2;
                this.mColorModel = colorModel;
            }

            public void dispose() {
            }

            public ColorModel getColorModel() {
                return this.mColorModel;
            }

            public Raster getRaster(int n, int n2, int n3, int n4) {
                BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
                int[] nArray = new int[n3 * n4];
                int n5 = 0;
                float[] fArray = new float[2];
                float[] fArray2 = new float[2];
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        fArray[0] = n + j;
                        fArray[1] = n2 + i;
                        this.mCanvasMatrix.transform(fArray, 0, fArray2, 0, 1);
                        fArray[0] = fArray2[0];
                        fArray[1] = fArray2[1];
                        this.mLocalMatrix.transform(fArray, 0, fArray2, 0, 1);
                        nArray[n5++] = LinearGradientPaint.this.getColor(fArray2[0], fArray2[1]);
                    }
                }
                bufferedImage.setRGB(0, 0, n3, n4, nArray, 0, n3);
                return bufferedImage.getRaster();
            }
        }
    }
}

