/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Path_Delegate;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Parcel;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class Region_Delegate {
    protected static final DelegateManager<Region_Delegate> sManager = new DelegateManager<Region_Delegate>(Region_Delegate.class);
    private Area mArea = new Area();

    public static Region_Delegate getDelegate(int n) {
        return sManager.getDelegate(n);
    }

    public Area getJavaArea() {
        return this.mArea;
    }

    public static Area combineShapes(Shape shape, Shape shape2, int n) {
        if (n == Region.Op.DIFFERENCE.nativeInt) {
            if (shape == null) {
                return null;
            }
            Area area = new Area(shape);
            area.subtract(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return area;
        }
        if (n == Region.Op.INTERSECT.nativeInt) {
            if (shape == null) {
                return new Area(shape2);
            }
            Area area = new Area(shape);
            area.intersect(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return area;
        }
        if (n == Region.Op.UNION.nativeInt) {
            if (shape == null) {
                return new Area(shape2);
            }
            Area area = new Area(shape);
            area.add(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return area;
        }
        if (n == Region.Op.XOR.nativeInt) {
            if (shape == null) {
                return new Area(shape2);
            }
            Area area = new Area(shape);
            area.exclusiveOr(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return area;
        }
        if (n == Region.Op.REVERSE_DIFFERENCE.nativeInt) {
            Area area = new Area(shape2);
            if (shape != null) {
                area.subtract(shape instanceof Area ? (Area)shape : new Area(shape));
            }
            return area;
        }
        return null;
    }

    @LayoutlibDelegate
    static boolean isEmpty(Region region) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return true;
        }
        return region_Delegate.mArea.isEmpty();
    }

    @LayoutlibDelegate
    static boolean isRect(Region region) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return true;
        }
        return region_Delegate.mArea.isRectangular();
    }

    @LayoutlibDelegate
    static boolean isComplex(Region region) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return true;
        }
        return !region_Delegate.mArea.isSingular();
    }

    @LayoutlibDelegate
    static boolean contains(Region region, int n, int n2) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return false;
        }
        return region_Delegate.mArea.contains(n, n2);
    }

    @LayoutlibDelegate
    static boolean quickContains(Region region, int n, int n2, int n3, int n4) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return false;
        }
        return region_Delegate.mArea.isRectangular() && region_Delegate.mArea.contains(n, n2, n3 - n, n4 - n2);
    }

    @LayoutlibDelegate
    static boolean quickReject(Region region, int n, int n2, int n3, int n4) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return false;
        }
        return region_Delegate.mArea.isEmpty() || !region_Delegate.mArea.intersects(n, n2, n3 - n, n4 - n2);
    }

    @LayoutlibDelegate
    static boolean quickReject(Region region, Region region2) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return false;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(region2.mNativeRegion);
        if (region_Delegate2 == null) {
            return false;
        }
        return region_Delegate.mArea.isEmpty() || !region_Delegate.mArea.getBounds().intersects(region_Delegate2.mArea.getBounds());
    }

    @LayoutlibDelegate
    static void translate(Region region, int n, int n2, Region region2) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(region2.mNativeRegion);
        if (region_Delegate2 == null) {
            return;
        }
        if (region_Delegate.mArea.isEmpty()) {
            region_Delegate2.mArea = new Area();
        } else {
            region_Delegate2.mArea = new Area(region_Delegate.mArea);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            region_Delegate2.mArea.transform(affineTransform);
        }
    }

    @LayoutlibDelegate
    static void scale(Region region, float f, Region region2) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(region2.mNativeRegion);
        if (region_Delegate2 == null) {
            return;
        }
        if (region_Delegate.mArea.isEmpty()) {
            region_Delegate2.mArea = new Area();
        } else {
            region_Delegate2.mArea = new Area(region_Delegate.mArea);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(f, f);
            region_Delegate2.mArea.transform(affineTransform);
        }
    }

    @LayoutlibDelegate
    static int nativeConstructor() {
        Region_Delegate region_Delegate = new Region_Delegate();
        return sManager.addNewDelegate(region_Delegate);
    }

    @LayoutlibDelegate
    static void nativeDestructor(int n) {
        sManager.removeJavaReferenceFor(n);
    }

    @LayoutlibDelegate
    static boolean nativeSetRegion(int n, int n2) {
        Region_Delegate region_Delegate = sManager.getDelegate(n);
        if (region_Delegate == null) {
            return true;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(n2);
        if (region_Delegate2 == null) {
            return true;
        }
        region_Delegate.mArea.reset();
        region_Delegate.mArea.add(region_Delegate2.mArea);
        return true;
    }

    @LayoutlibDelegate
    static boolean nativeSetRect(int n, int n2, int n3, int n4, int n5) {
        Region_Delegate region_Delegate = sManager.getDelegate(n);
        if (region_Delegate == null) {
            return true;
        }
        region_Delegate.mArea = new Area(new Rectangle2D.Float(n2, n3, n4 - n2, n5 - n3));
        return !region_Delegate.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeSetPath(int n, int n2, int n3) {
        Region_Delegate region_Delegate = sManager.getDelegate(n);
        if (region_Delegate == null) {
            return true;
        }
        Path_Delegate path_Delegate = Path_Delegate.getDelegate(n2);
        if (path_Delegate == null) {
            return true;
        }
        region_Delegate.mArea = new Area(path_Delegate.getJavaShape());
        Region_Delegate region_Delegate2 = sManager.getDelegate(n3);
        if (region_Delegate2 != null) {
            region_Delegate.mArea.subtract(region_Delegate2.getJavaArea());
        }
        return !region_Delegate.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeGetBounds(int n, Rect rect) {
        Region_Delegate region_Delegate = sManager.getDelegate(n);
        if (region_Delegate == null) {
            return true;
        }
        Rectangle rectangle = region_Delegate.mArea.getBounds();
        if (rectangle.isEmpty()) {
            rect.bottom = 0;
            rect.right = 0;
            rect.top = 0;
            rect.left = 0;
            return false;
        }
        rect.left = rectangle.x;
        rect.top = rectangle.y;
        rect.right = rectangle.x + rectangle.width;
        rect.bottom = rectangle.y + rectangle.height;
        return true;
    }

    @LayoutlibDelegate
    static boolean nativeGetBoundaryPath(int n, int n2) {
        Region_Delegate region_Delegate = sManager.getDelegate(n);
        if (region_Delegate == null) {
            return false;
        }
        Path_Delegate path_Delegate = Path_Delegate.getDelegate(n2);
        if (path_Delegate == null) {
            return false;
        }
        if (region_Delegate.mArea.isEmpty()) {
            path_Delegate.reset();
            return false;
        }
        path_Delegate.setPathIterator(region_Delegate.mArea.getPathIterator(new AffineTransform()));
        return true;
    }

    @LayoutlibDelegate
    static boolean nativeOp(int n, int n2, int n3, int n4, int n5, int n6) {
        Region_Delegate region_Delegate = sManager.getDelegate(n);
        if (region_Delegate == null) {
            return false;
        }
        region_Delegate.mArea = Region_Delegate.combineShapes(region_Delegate.mArea, new Rectangle2D.Float(n2, n3, n4 - n2, n5 - n3), n6);
        assert (region_Delegate.mArea != null);
        if (region_Delegate.mArea != null) {
            region_Delegate.mArea = new Area();
        }
        return !region_Delegate.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeOp(int n, Rect rect, int n2, int n3) {
        Region_Delegate region_Delegate = sManager.getDelegate(n);
        if (region_Delegate == null) {
            return false;
        }
        region_Delegate.mArea = Region_Delegate.combineShapes(region_Delegate.mArea, new Rectangle2D.Float(rect.left, rect.top, rect.width(), rect.height()), n3);
        assert (region_Delegate.mArea != null);
        if (region_Delegate.mArea != null) {
            region_Delegate.mArea = new Area();
        }
        return !region_Delegate.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeOp(int n, int n2, int n3, int n4) {
        Region_Delegate region_Delegate = sManager.getDelegate(n);
        if (region_Delegate == null) {
            return true;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(n2);
        if (region_Delegate2 == null) {
            return false;
        }
        Region_Delegate region_Delegate3 = sManager.getDelegate(n3);
        if (region_Delegate3 == null) {
            return false;
        }
        region_Delegate.mArea = Region_Delegate.combineShapes(region_Delegate2.mArea, region_Delegate3.mArea, n4);
        assert (region_Delegate.mArea != null);
        if (region_Delegate.mArea != null) {
            region_Delegate.mArea = new Area();
        }
        return !region_Delegate.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static int nativeCreateFromParcel(Parcel parcel) {
        Bridge.getLog().error("unsupported", "AIDL is not suppored, and therefore Regions cannot be created from parcels.", null);
        return 0;
    }

    @LayoutlibDelegate
    static boolean nativeWriteToParcel(int n, Parcel parcel) {
        Bridge.getLog().error("unsupported", "AIDL is not suppored, and therefore Regions cannot be written to parcels.", null);
        return false;
    }

    @LayoutlibDelegate
    static boolean nativeEquals(int n, int n2) {
        Region_Delegate region_Delegate = sManager.getDelegate(n);
        if (region_Delegate == null) {
            return false;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(n2);
        if (region_Delegate2 == null) {
            return false;
        }
        return region_Delegate.mArea.equals(region_Delegate2.mArea);
    }

    @LayoutlibDelegate
    static String nativeToString(int n) {
        Region_Delegate region_Delegate = sManager.getDelegate(n);
        if (region_Delegate == null) {
            return "not found";
        }
        return region_Delegate.mArea.toString();
    }
}

