/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.PendingIntent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.media.IRemoteControlClient;
import android.media.IRemoteControlDisplay;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;

public class RemoteControlClient {
    private static final String TAG = "RemoteControlClient";
    public static final int PLAYSTATE_STOPPED = 1;
    public static final int PLAYSTATE_PAUSED = 2;
    public static final int PLAYSTATE_PLAYING = 3;
    public static final int PLAYSTATE_FAST_FORWARDING = 4;
    public static final int PLAYSTATE_REWINDING = 5;
    public static final int PLAYSTATE_SKIPPING_FORWARDS = 6;
    public static final int PLAYSTATE_SKIPPING_BACKWARDS = 7;
    public static final int PLAYSTATE_BUFFERING = 8;
    public static final int PLAYSTATE_ERROR = 9;
    public static final int PLAYSTATE_NONE = 0;
    public static final int FLAG_KEY_MEDIA_PREVIOUS = 1;
    public static final int FLAG_KEY_MEDIA_REWIND = 2;
    public static final int FLAG_KEY_MEDIA_PLAY = 4;
    public static final int FLAG_KEY_MEDIA_PLAY_PAUSE = 8;
    public static final int FLAG_KEY_MEDIA_PAUSE = 16;
    public static final int FLAG_KEY_MEDIA_STOP = 32;
    public static final int FLAG_KEY_MEDIA_FAST_FORWARD = 64;
    public static final int FLAG_KEY_MEDIA_NEXT = 128;
    public static final int FLAGS_KEY_MEDIA_NONE = 0;
    public static final int FLAG_INFORMATION_REQUEST_METADATA = 1;
    public static final int FLAG_INFORMATION_REQUEST_KEY_MEDIA = 2;
    public static final int FLAG_INFORMATION_REQUEST_PLAYSTATE = 4;
    public static final int FLAG_INFORMATION_REQUEST_ALBUM_ART = 8;
    private static final int[] METADATA_KEYS_TYPE_STRING = new int[]{1, 13, 7, 2, 3, 15, 4, 5, 6, 7, 11};
    private static final int[] METADATA_KEYS_TYPE_LONG = new int[]{0, 14, 9};
    private final Object mCacheLock = new Object();
    private int mPlaybackState = 0;
    private long mPlaybackStateChangeTimeMs = 0L;
    private Bitmap mArtwork;
    private final int ARTWORK_DEFAULT_SIZE = 256;
    private final int ARTWORK_INVALID_SIZE = -1;
    private int mArtworkExpectedWidth = 256;
    private int mArtworkExpectedHeight = 256;
    private int mTransportControlFlags = 0;
    private Bundle mMetadata = new Bundle();
    private int mCurrentClientGenId = -1;
    private int mInternalClientGenId = -2;
    private final PendingIntent mRcMediaIntent;
    private IRemoteControlDisplay mRcDisplay;
    private IRemoteControlClient mIRCC = new IRemoteControlClient.Stub(){

        public void onInformationRequested(int clientGeneration, int infoFlags, int artWidth, int artHeight) {
            if (RemoteControlClient.this.mEventHandler != null) {
                RemoteControlClient.this.mEventHandler.removeMessages(5);
                RemoteControlClient.this.mEventHandler.dispatchMessage(RemoteControlClient.this.mEventHandler.obtainMessage(5, artWidth, artHeight, new Integer(clientGeneration)));
                RemoteControlClient.this.mEventHandler.removeMessages(1);
                RemoteControlClient.this.mEventHandler.removeMessages(2);
                RemoteControlClient.this.mEventHandler.removeMessages(3);
                RemoteControlClient.this.mEventHandler.removeMessages(4);
                RemoteControlClient.this.mEventHandler.dispatchMessage(RemoteControlClient.this.mEventHandler.obtainMessage(1));
                RemoteControlClient.this.mEventHandler.dispatchMessage(RemoteControlClient.this.mEventHandler.obtainMessage(3));
                RemoteControlClient.this.mEventHandler.dispatchMessage(RemoteControlClient.this.mEventHandler.obtainMessage(2));
                RemoteControlClient.this.mEventHandler.dispatchMessage(RemoteControlClient.this.mEventHandler.obtainMessage(4));
            }
        }

        public void setCurrentClientGenerationId(int clientGeneration) {
            if (RemoteControlClient.this.mEventHandler != null) {
                RemoteControlClient.this.mEventHandler.removeMessages(6);
                RemoteControlClient.this.mEventHandler.dispatchMessage(RemoteControlClient.this.mEventHandler.obtainMessage(6, clientGeneration, 0));
            }
        }

        public void plugRemoteControlDisplay(IRemoteControlDisplay rcd) {
            if (RemoteControlClient.this.mEventHandler != null) {
                RemoteControlClient.this.mEventHandler.dispatchMessage(RemoteControlClient.this.mEventHandler.obtainMessage(7, rcd));
            }
        }

        public void unplugRemoteControlDisplay(IRemoteControlDisplay rcd) {
            if (RemoteControlClient.this.mEventHandler != null) {
                RemoteControlClient.this.mEventHandler.dispatchMessage(RemoteControlClient.this.mEventHandler.obtainMessage(8, rcd));
            }
        }
    };
    private EventHandler mEventHandler;
    private static final int MSG_REQUEST_PLAYBACK_STATE = 1;
    private static final int MSG_REQUEST_METADATA = 2;
    private static final int MSG_REQUEST_TRANSPORTCONTROL = 3;
    private static final int MSG_REQUEST_ARTWORK = 4;
    private static final int MSG_NEW_INTERNAL_CLIENT_GEN = 5;
    private static final int MSG_NEW_CURRENT_CLIENT_GEN = 6;
    private static final int MSG_PLUG_DISPLAY = 7;
    private static final int MSG_UNPLUG_DISPLAY = 8;

    public RemoteControlClient(PendingIntent mediaButtonIntent) {
        this.mRcMediaIntent = mediaButtonIntent;
        Looper looper = Looper.myLooper();
        if (looper != null) {
            this.mEventHandler = new EventHandler(this, looper);
        } else {
            looper = Looper.getMainLooper();
            if (looper != null) {
                this.mEventHandler = new EventHandler(this, looper);
            } else {
                this.mEventHandler = null;
                Log.e(TAG, "RemoteControlClient() couldn't find main application thread");
            }
        }
    }

    public RemoteControlClient(PendingIntent mediaButtonIntent, Looper looper) {
        this.mRcMediaIntent = mediaButtonIntent;
        this.mEventHandler = new EventHandler(this, looper);
    }

    public MetadataEditor editMetadata(boolean startEmpty) {
        MetadataEditor editor = new MetadataEditor();
        if (startEmpty) {
            editor.mEditorMetadata = new Bundle();
            editor.mEditorArtwork = null;
            editor.mMetadataChanged = true;
            editor.mArtworkChanged = true;
        } else {
            editor.mEditorMetadata = new Bundle(this.mMetadata);
            editor.mEditorArtwork = this.mArtwork;
            editor.mMetadataChanged = false;
            editor.mArtworkChanged = false;
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaybackState(int state) {
        Object object = this.mCacheLock;
        synchronized (object) {
            if (this.mPlaybackState != state) {
                this.mPlaybackState = state;
                this.mPlaybackStateChangeTimeMs = SystemClock.elapsedRealtime();
                this.sendPlaybackState_syncCacheLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransportControlFlags(int transportControlFlags) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mTransportControlFlags = transportControlFlags;
            this.sendTransportControlFlags_syncCacheLock();
        }
    }

    public PendingIntent getRcMediaIntent() {
        return this.mRcMediaIntent;
    }

    public IRemoteControlClient getIRemoteControlClient() {
        return this.mIRCC;
    }

    private void detachFromDisplay_syncCacheLock() {
        this.mRcDisplay = null;
        this.mArtworkExpectedWidth = -1;
        this.mArtworkExpectedHeight = -1;
    }

    private void sendPlaybackState_syncCacheLock() {
        if (this.mCurrentClientGenId == this.mInternalClientGenId && this.mRcDisplay != null) {
            try {
                this.mRcDisplay.setPlaybackState(this.mInternalClientGenId, this.mPlaybackState, this.mPlaybackStateChangeTimeMs);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in setPlaybackState(), dead display " + e);
                this.detachFromDisplay_syncCacheLock();
            }
        }
    }

    private void sendMetadata_syncCacheLock() {
        if (this.mCurrentClientGenId == this.mInternalClientGenId && this.mRcDisplay != null) {
            try {
                this.mRcDisplay.setMetadata(this.mInternalClientGenId, this.mMetadata);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in sendPlaybackState(), dead display " + e);
                this.detachFromDisplay_syncCacheLock();
            }
        }
    }

    private void sendTransportControlFlags_syncCacheLock() {
        if (this.mCurrentClientGenId == this.mInternalClientGenId && this.mRcDisplay != null) {
            try {
                this.mRcDisplay.setTransportControlFlags(this.mInternalClientGenId, this.mTransportControlFlags);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in sendTransportControlFlags(), dead display " + e);
                this.detachFromDisplay_syncCacheLock();
            }
        }
    }

    private void sendArtwork_syncCacheLock() {
        if (this.mCurrentClientGenId == this.mInternalClientGenId && this.mRcDisplay != null) {
            this.mArtwork = this.scaleBitmapIfTooBig(this.mArtwork, this.mArtworkExpectedWidth, this.mArtworkExpectedHeight);
            try {
                this.mRcDisplay.setArtwork(this.mInternalClientGenId, this.mArtwork);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in sendArtwork(), dead display " + e);
                this.detachFromDisplay_syncCacheLock();
            }
        }
    }

    private void sendMetadataWithArtwork_syncCacheLock() {
        if (this.mCurrentClientGenId == this.mInternalClientGenId && this.mRcDisplay != null) {
            this.mArtwork = this.scaleBitmapIfTooBig(this.mArtwork, this.mArtworkExpectedWidth, this.mArtworkExpectedHeight);
            try {
                this.mRcDisplay.setAllMetadata(this.mInternalClientGenId, this.mMetadata, this.mArtwork);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in setAllMetadata(), dead display " + e);
                this.detachFromDisplay_syncCacheLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewInternalClientGen(Integer clientGeneration, int artWidth, int artHeight) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mInternalClientGenId = clientGeneration;
            if (artWidth > 0) {
                this.mArtworkExpectedWidth = artWidth;
                this.mArtworkExpectedHeight = artHeight;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewCurrentClientGen(int clientGeneration) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mCurrentClientGenId = clientGeneration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlugDisplay(IRemoteControlDisplay rcd) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mRcDisplay = rcd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUnplugDisplay(IRemoteControlDisplay rcd) {
        Object object = this.mCacheLock;
        synchronized (object) {
            if (this.mRcDisplay != null && this.mRcDisplay.asBinder().equals(rcd.asBinder())) {
                this.mRcDisplay = null;
                this.mArtworkExpectedWidth = 256;
                this.mArtworkExpectedHeight = 256;
            }
        }
    }

    private Bitmap scaleBitmapIfTooBig(Bitmap bitmap, int maxWidth, int maxHeight) {
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (width > maxWidth || height > maxHeight) {
                float scale = Math.min((float)maxWidth / (float)width, (float)maxHeight / (float)height);
                int newWidth = Math.round(scale * (float)width);
                int newHeight = Math.round(scale * (float)height);
                Bitmap outBitmap = Bitmap.createBitmap(newWidth, newHeight, bitmap.getConfig());
                Canvas canvas = new Canvas(outBitmap);
                Paint paint = new Paint();
                paint.setAntiAlias(true);
                paint.setFilterBitmap(true);
                canvas.drawBitmap(bitmap, null, new RectF(0.0f, 0.0f, outBitmap.getWidth(), outBitmap.getHeight()), paint);
                bitmap = outBitmap;
            }
        }
        return bitmap;
    }

    private static boolean validTypeForKey(int key, int[] validKeys) {
        try {
            int i = 0;
            while (true) {
                if (key == validKeys[i]) {
                    return true;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    private class EventHandler
    extends Handler {
        public EventHandler(RemoteControlClient rcc, Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Object object = RemoteControlClient.this.mCacheLock;
                    synchronized (object) {
                        RemoteControlClient.this.sendPlaybackState_syncCacheLock();
                        break;
                    }
                }
                case 2: {
                    Object object = RemoteControlClient.this.mCacheLock;
                    synchronized (object) {
                        RemoteControlClient.this.sendMetadata_syncCacheLock();
                        break;
                    }
                }
                case 3: {
                    Object object = RemoteControlClient.this.mCacheLock;
                    synchronized (object) {
                        RemoteControlClient.this.sendTransportControlFlags_syncCacheLock();
                        break;
                    }
                }
                case 4: {
                    Object object = RemoteControlClient.this.mCacheLock;
                    synchronized (object) {
                        RemoteControlClient.this.sendArtwork_syncCacheLock();
                        break;
                    }
                }
                case 5: {
                    RemoteControlClient.this.onNewInternalClientGen((Integer)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 6: {
                    RemoteControlClient.this.onNewCurrentClientGen(msg.arg1);
                    break;
                }
                case 7: {
                    RemoteControlClient.this.onPlugDisplay((IRemoteControlDisplay)msg.obj);
                    break;
                }
                case 8: {
                    RemoteControlClient.this.onUnplugDisplay((IRemoteControlDisplay)msg.obj);
                    break;
                }
                default: {
                    Log.e(RemoteControlClient.TAG, "Unknown event " + msg.what + " in RemoteControlClient handler");
                }
            }
        }
    }

    public class MetadataEditor {
        protected boolean mMetadataChanged;
        protected boolean mArtworkChanged;
        protected Bitmap mEditorArtwork;
        protected Bundle mEditorMetadata;
        private boolean mApplied = false;
        public static final int BITMAP_KEY_ARTWORK = 100;
        public static final int METADATA_KEY_ARTWORK = 100;

        private MetadataEditor() {
        }

        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }

        public synchronized MetadataEditor putString(int key, String value) throws IllegalArgumentException {
            if (this.mApplied) {
                Log.e(RemoteControlClient.TAG, "Can't edit a previously applied MetadataEditor");
                return this;
            }
            if (!RemoteControlClient.validTypeForKey(key, METADATA_KEYS_TYPE_STRING)) {
                throw new IllegalArgumentException("Invalid type 'String' for key " + key);
            }
            this.mEditorMetadata.putString(String.valueOf(key), value);
            this.mMetadataChanged = true;
            return this;
        }

        public synchronized MetadataEditor putLong(int key, long value) throws IllegalArgumentException {
            if (this.mApplied) {
                Log.e(RemoteControlClient.TAG, "Can't edit a previously applied MetadataEditor");
                return this;
            }
            if (!RemoteControlClient.validTypeForKey(key, METADATA_KEYS_TYPE_LONG)) {
                throw new IllegalArgumentException("Invalid type 'long' for key " + key);
            }
            this.mEditorMetadata.putLong(String.valueOf(key), value);
            this.mMetadataChanged = true;
            return this;
        }

        public synchronized MetadataEditor putBitmap(int key, Bitmap bitmap) throws IllegalArgumentException {
            if (this.mApplied) {
                Log.e(RemoteControlClient.TAG, "Can't edit a previously applied MetadataEditor");
                return this;
            }
            if (key != 100) {
                throw new IllegalArgumentException("Invalid type 'Bitmap' for key " + key);
            }
            this.mEditorArtwork = RemoteControlClient.this.mArtworkExpectedWidth > 0 && RemoteControlClient.this.mArtworkExpectedHeight > 0 ? RemoteControlClient.this.scaleBitmapIfTooBig(bitmap, RemoteControlClient.this.mArtworkExpectedWidth, RemoteControlClient.this.mArtworkExpectedHeight) : bitmap;
            this.mArtworkChanged = true;
            return this;
        }

        public synchronized void clear() {
            if (this.mApplied) {
                Log.e(RemoteControlClient.TAG, "Can't clear a previously applied MetadataEditor");
                return;
            }
            this.mEditorMetadata.clear();
            this.mEditorArtwork = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void apply() {
            if (this.mApplied) {
                Log.e(RemoteControlClient.TAG, "Can't apply a previously applied MetadataEditor");
                return;
            }
            Object object = RemoteControlClient.this.mCacheLock;
            synchronized (object) {
                RemoteControlClient.this.mMetadata = new Bundle(this.mEditorMetadata);
                if (RemoteControlClient.this.mArtwork != null && !RemoteControlClient.this.mArtwork.equals(this.mEditorArtwork)) {
                    RemoteControlClient.this.mArtwork.recycle();
                }
                RemoteControlClient.this.mArtwork = this.mEditorArtwork;
                this.mEditorArtwork = null;
                if (this.mMetadataChanged & this.mArtworkChanged) {
                    RemoteControlClient.this.sendMetadataWithArtwork_syncCacheLock();
                } else if (this.mMetadataChanged) {
                    RemoteControlClient.this.sendMetadata_syncCacheLock();
                } else if (this.mArtworkChanged) {
                    RemoteControlClient.this.sendArtwork_syncCacheLock();
                }
                this.mApplied = true;
            }
        }
    }
}

