/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public class WifiP2pDevice
implements Parcelable {
    private static final String TAG = "WifiP2pDevice";
    public String deviceName;
    public String deviceAddress;
    public String interfaceAddress;
    public String primaryDeviceType;
    public String secondaryDeviceType;
    private static final int WPS_CONFIG_DISPLAY = 8;
    private static final int WPS_CONFIG_PUSHBUTTON = 128;
    private static final int WPS_CONFIG_KEYPAD = 256;
    private static final int DEVICE_CAPAB_SERVICE_DISCOVERY = 1;
    private static final int DEVICE_CAPAB_CLIENT_DISCOVERABILITY = 2;
    private static final int DEVICE_CAPAB_CONCURRENT_OPER = 4;
    private static final int DEVICE_CAPAB_INFRA_MANAGED = 8;
    private static final int DEVICE_CAPAB_DEVICE_LIMIT = 16;
    private static final int DEVICE_CAPAB_INVITATION_PROCEDURE = 32;
    private static final int GROUP_CAPAB_GROUP_OWNER = 1;
    private static final int GROUP_CAPAB_PERSISTENT_GROUP = 2;
    private static final int GROUP_CAPAB_GROUP_LIMIT = 4;
    private static final int GROUP_CAPAB_INTRA_BSS_DIST = 8;
    private static final int GROUP_CAPAB_CROSS_CONN = 16;
    private static final int GROUP_CAPAB_PERSISTENT_RECONN = 32;
    private static final int GROUP_CAPAB_GROUP_FORMATION = 64;
    public int wpsConfigMethodsSupported;
    public int deviceCapability;
    public int groupCapability;
    public static final int CONNECTED = 0;
    public static final int INVITED = 1;
    public static final int FAILED = 2;
    public static final int AVAILABLE = 3;
    public static final int UNAVAILABLE = 4;
    public int status = 4;
    public static final Parcelable.Creator<WifiP2pDevice> CREATOR = new Parcelable.Creator<WifiP2pDevice>(){

        @Override
        public WifiP2pDevice createFromParcel(Parcel in) {
            WifiP2pDevice device = new WifiP2pDevice();
            device.deviceName = in.readString();
            device.deviceAddress = in.readString();
            device.interfaceAddress = in.readString();
            device.primaryDeviceType = in.readString();
            device.secondaryDeviceType = in.readString();
            device.wpsConfigMethodsSupported = in.readInt();
            device.deviceCapability = in.readInt();
            device.groupCapability = in.readInt();
            device.status = in.readInt();
            return device;
        }

        public WifiP2pDevice[] newArray(int size) {
            return new WifiP2pDevice[size];
        }
    };

    public WifiP2pDevice() {
    }

    public WifiP2pDevice(String string2) throws IllegalArgumentException {
        String[] tokens = string2.split(" ");
        if (tokens.length < 1) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        if (tokens.length == 1) {
            this.deviceAddress = string2;
            return;
        }
        for (String token : tokens) {
            String[] nameValue = token.split("=");
            if (nameValue.length != 2) continue;
            if (nameValue[0].equals("p2p_dev_addr")) {
                this.deviceAddress = nameValue[1];
                continue;
            }
            if (nameValue[0].equals("pri_dev_type")) {
                this.primaryDeviceType = nameValue[1];
                continue;
            }
            if (nameValue[0].equals("name")) {
                this.deviceName = this.trimQuotes(nameValue[1]);
                continue;
            }
            if (nameValue[0].equals("config_methods")) {
                this.wpsConfigMethodsSupported = this.parseHex(nameValue[1]);
                continue;
            }
            if (nameValue[0].equals("dev_capab")) {
                this.deviceCapability = this.parseHex(nameValue[1]);
                continue;
            }
            if (!nameValue[0].equals("group_capab")) continue;
            this.groupCapability = this.parseHex(nameValue[1]);
        }
        if (tokens[0].startsWith("P2P-DEVICE-FOUND")) {
            this.status = 3;
        }
    }

    public boolean wpsPbcSupported() {
        return (this.wpsConfigMethodsSupported & 0x80) != 0;
    }

    public boolean wpsKeypadSupported() {
        return (this.wpsConfigMethodsSupported & 0x100) != 0;
    }

    public boolean wpsDisplaySupported() {
        return (this.wpsConfigMethodsSupported & 8) != 0;
    }

    public boolean isServiceDiscoveryCapable() {
        return (this.deviceCapability & 1) != 0;
    }

    public boolean isGroupOwner() {
        return (this.groupCapability & 1) != 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiP2pDevice)) {
            return false;
        }
        WifiP2pDevice other = (WifiP2pDevice)obj;
        if (other == null || other.deviceAddress == null) {
            return this.deviceAddress == null;
        }
        return other.deviceAddress.equals(this.deviceAddress);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Device: ").append(this.deviceName);
        sbuf.append("\n deviceAddress: ").append(this.deviceAddress);
        sbuf.append("\n interfaceAddress: ").append(this.interfaceAddress);
        sbuf.append("\n primary type: ").append(this.primaryDeviceType);
        sbuf.append("\n secondary type: ").append(this.secondaryDeviceType);
        sbuf.append("\n wps: ").append(this.wpsConfigMethodsSupported);
        sbuf.append("\n grpcapab: ").append(this.groupCapability);
        sbuf.append("\n devcapab: ").append(this.deviceCapability);
        sbuf.append("\n status: ").append(this.status);
        return sbuf.toString();
    }

    public int describeContents() {
        return 0;
    }

    public WifiP2pDevice(WifiP2pDevice source) {
        if (source != null) {
            this.deviceName = source.deviceName;
            this.deviceAddress = source.deviceAddress;
            this.interfaceAddress = source.interfaceAddress;
            this.primaryDeviceType = source.primaryDeviceType;
            this.secondaryDeviceType = source.secondaryDeviceType;
            this.wpsConfigMethodsSupported = source.wpsConfigMethodsSupported;
            this.deviceCapability = source.deviceCapability;
            this.groupCapability = source.groupCapability;
            this.status = source.status;
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.deviceName);
        dest.writeString(this.deviceAddress);
        dest.writeString(this.interfaceAddress);
        dest.writeString(this.primaryDeviceType);
        dest.writeString(this.secondaryDeviceType);
        dest.writeInt(this.wpsConfigMethodsSupported);
        dest.writeInt(this.deviceCapability);
        dest.writeInt(this.groupCapability);
        dest.writeInt(this.status);
    }

    private String trimQuotes(String str) {
        if ((str = str.trim()).startsWith("'") && str.endsWith("'")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private int parseHex(String hexString) {
        int num = 0;
        if (hexString.startsWith("0x") || hexString.startsWith("0X")) {
            hexString = hexString.substring(2);
        }
        try {
            num = Integer.parseInt(hexString, 16);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Failed to parse hex string " + hexString);
        }
        return num;
    }
}

