/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.graphics.Bitmap;
import com.android.tools.layoutlib.create.OverrideMethod;

public class GLUtils {
    private GLUtils() {
    }

    public static int getInternalFormat(Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("getInternalFormat can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        int result = GLUtils.native_getInternalFormat(bitmap);
        if (result < 0) {
            throw new IllegalArgumentException("Unknown internalformat");
        }
        return result;
    }

    public static int getType(Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("getType can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        int result = GLUtils.native_getType(bitmap);
        if (result < 0) {
            throw new IllegalArgumentException("Unknown type");
        }
        return result;
    }

    public static void texImage2D(int target, int level, int internalformat, Bitmap bitmap, int border) {
        if (bitmap == null) {
            throw new NullPointerException("texImage2D can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        if (GLUtils.native_texImage2D(target, level, internalformat, bitmap, -1, border) != 0) {
            throw new IllegalArgumentException("invalid Bitmap format");
        }
    }

    public static void texImage2D(int target, int level, int internalformat, Bitmap bitmap, int type, int border) {
        if (bitmap == null) {
            throw new NullPointerException("texImage2D can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        if (GLUtils.native_texImage2D(target, level, internalformat, bitmap, type, border) != 0) {
            throw new IllegalArgumentException("invalid Bitmap format");
        }
    }

    public static void texImage2D(int target, int level, Bitmap bitmap, int border) {
        if (bitmap == null) {
            throw new NullPointerException("texImage2D can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        if (GLUtils.native_texImage2D(target, level, -1, bitmap, -1, border) != 0) {
            throw new IllegalArgumentException("invalid Bitmap format");
        }
    }

    public static void texSubImage2D(int target, int level, int xoffset, int yoffset, Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("texSubImage2D can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        int type = GLUtils.getType(bitmap);
        if (GLUtils.native_texSubImage2D(target, level, xoffset, yoffset, bitmap, -1, type) != 0) {
            throw new IllegalArgumentException("invalid Bitmap format");
        }
    }

    public static void texSubImage2D(int target, int level, int xoffset, int yoffset, Bitmap bitmap, int format, int type) {
        if (bitmap == null) {
            throw new NullPointerException("texSubImage2D can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        if (GLUtils.native_texSubImage2D(target, level, xoffset, yoffset, bitmap, format, type) != 0) {
            throw new IllegalArgumentException("invalid Bitmap format");
        }
    }

    public static String getEGLErrorString(int error) {
        switch (error) {
            case 12288: {
                return "EGL_SUCCESS";
            }
            case 12289: {
                return "EGL_NOT_INITIALIZED";
            }
            case 12290: {
                return "EGL_BAD_ACCESS";
            }
            case 12291: {
                return "EGL_BAD_ALLOC";
            }
            case 12292: {
                return "EGL_BAD_ATTRIBUTE";
            }
            case 12293: {
                return "EGL_BAD_CONFIG";
            }
            case 12294: {
                return "EGL_BAD_CONTEXT";
            }
            case 12295: {
                return "EGL_BAD_CURRENT_SURFACE";
            }
            case 12296: {
                return "EGL_BAD_DISPLAY";
            }
            case 12297: {
                return "EGL_BAD_MATCH";
            }
            case 12298: {
                return "EGL_BAD_NATIVE_PIXMAP";
            }
            case 12299: {
                return "EGL_BAD_NATIVE_WINDOW";
            }
            case 12300: {
                return "EGL_BAD_PARAMETER";
            }
            case 12301: {
                return "EGL_BAD_SURFACE";
            }
            case 12302: {
                return "EGL_CONTEXT_LOST";
            }
        }
        return "0x" + Integer.toHexString(error);
    }

    private static void nativeClassInit() {
        OverrideMethod.invokeV("android.opengl.GLUtils#nativeClassInit()V", true, null);
    }

    private static int native_getInternalFormat(Bitmap bitmap) {
        return OverrideMethod.invokeI("android.opengl.GLUtils#native_getInternalFormat(Landroid/graphics/Bitmap;)I", true, null);
    }

    private static int native_getType(Bitmap bitmap) {
        return OverrideMethod.invokeI("android.opengl.GLUtils#native_getType(Landroid/graphics/Bitmap;)I", true, null);
    }

    private static int native_texImage2D(int n, int n2, int n3, Bitmap bitmap, int n4, int n5) {
        return OverrideMethod.invokeI("android.opengl.GLUtils#native_texImage2D(IIILandroid/graphics/Bitmap;II)I", true, null);
    }

    private static int native_texSubImage2D(int n, int n2, int n3, int n4, Bitmap bitmap, int n5, int n6) {
        return OverrideMethod.invokeI("android.opengl.GLUtils#native_texSubImage2D(IIIILandroid/graphics/Bitmap;II)I", true, null);
    }

    static {
        GLUtils.nativeClassInit();
    }
}

