/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Registrant;
import java.util.ArrayList;

public class RegistrantList {
    ArrayList registrants = new ArrayList();

    public synchronized void add(Handler h, int what, Object obj) {
        this.add(new Registrant(h, what, obj));
    }

    public synchronized void addUnique(Handler h, int what, Object obj) {
        this.remove(h);
        this.add(new Registrant(h, what, obj));
    }

    public synchronized void add(Registrant r) {
        this.removeCleared();
        this.registrants.add(r);
    }

    public synchronized void removeCleared() {
        for (int i = this.registrants.size() - 1; i >= 0; --i) {
            Registrant r = (Registrant)this.registrants.get(i);
            if (r.refH != null) continue;
            this.registrants.remove(i);
        }
    }

    public synchronized int size() {
        return this.registrants.size();
    }

    public synchronized Object get(int index) {
        return this.registrants.get(index);
    }

    private synchronized void internalNotifyRegistrants(Object result, Throwable exception) {
        int s = this.registrants.size();
        for (int i = 0; i < s; ++i) {
            Registrant r = (Registrant)this.registrants.get(i);
            r.internalNotifyRegistrant(result, exception);
        }
    }

    public void notifyRegistrants() {
        this.internalNotifyRegistrants(null, null);
    }

    public void notifyException(Throwable exception) {
        this.internalNotifyRegistrants(null, exception);
    }

    public void notifyResult(Object result) {
        this.internalNotifyRegistrants(result, null);
    }

    public void notifyRegistrants(AsyncResult ar) {
        this.internalNotifyRegistrants(ar.result, ar.exception);
    }

    public synchronized void remove(Handler h) {
        int s = this.registrants.size();
        for (int i = 0; i < s; ++i) {
            Registrant r = (Registrant)this.registrants.get(i);
            Handler rh = r.getHandler();
            if (rh != null && rh != h) continue;
            r.clear();
        }
        this.removeCleared();
    }
}

