/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Element;
import android.renderscript.Program;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;

public class ProgramVertex
extends Program {
    ProgramVertex(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public static class Builder
    extends Program.BaseProgramBuilder {
        public Builder(RenderScript rs) {
            super(rs);
        }

        public Builder addInput(Element e) throws IllegalStateException {
            if (this.mInputCount >= 8) {
                throw new RSIllegalArgumentException("Max input count exceeded.");
            }
            if (e.isComplex()) {
                throw new RSIllegalArgumentException("Complex elements not allowed.");
            }
            this.mInputs[this.mInputCount++] = e;
            return this;
        }

        public ProgramVertex create() {
            int i;
            this.mRS.validate();
            int[] tmp = new int[(this.mInputCount + this.mOutputCount + this.mConstantCount + this.mTextureCount) * 2];
            int idx = 0;
            for (i = 0; i < this.mInputCount; ++i) {
                tmp[idx++] = Program.ProgramParam.INPUT.mID;
                tmp[idx++] = this.mInputs[i].getID();
            }
            for (i = 0; i < this.mOutputCount; ++i) {
                tmp[idx++] = Program.ProgramParam.OUTPUT.mID;
                tmp[idx++] = this.mOutputs[i].getID();
            }
            for (i = 0; i < this.mConstantCount; ++i) {
                tmp[idx++] = Program.ProgramParam.CONSTANT.mID;
                tmp[idx++] = this.mConstants[i].getID();
            }
            for (i = 0; i < this.mTextureCount; ++i) {
                tmp[idx++] = Program.ProgramParam.TEXTURE_TYPE.mID;
                tmp[idx++] = this.mTextureTypes[i].mID;
            }
            int id2 = this.mRS.nProgramVertexCreate(this.mShader, tmp);
            ProgramVertex pv = new ProgramVertex(id2, this.mRS);
            this.initProgram(pv);
            return pv;
        }
    }
}

