/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RenderScript;

public class Type
extends BaseObj {
    int mDimX;
    int mDimY;
    int mDimZ;
    boolean mDimMipmaps;
    boolean mDimFaces;
    int mElementCount;
    Element mElement;

    public Element getElement() {
        return this.mElement;
    }

    public int getX() {
        return this.mDimX;
    }

    public int getY() {
        return this.mDimY;
    }

    public int getZ() {
        return this.mDimZ;
    }

    public boolean hasMipmaps() {
        return this.mDimMipmaps;
    }

    public boolean hasFaces() {
        return this.mDimFaces;
    }

    public int getCount() {
        return this.mElementCount;
    }

    void calcElementCount() {
        boolean hasLod = this.hasMipmaps();
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        int faces = 1;
        if (this.hasFaces()) {
            faces = 6;
        }
        if (x == 0) {
            x = 1;
        }
        if (y == 0) {
            y = 1;
        }
        if (z == 0) {
            z = 1;
        }
        int count = x * y * z * faces;
        while (hasLod && (x > 1 || y > 1 || z > 1)) {
            if (x > 1) {
                x >>= 1;
            }
            if (y > 1) {
                y >>= 1;
            }
            if (z > 1) {
                z >>= 1;
            }
            count += x * y * z * faces;
        }
        this.mElementCount = count;
    }

    Type(int id2, RenderScript rs) {
        super(id2, rs);
    }

    void updateFromNative() {
        int[] dataBuffer = new int[6];
        this.mRS.nTypeGetNativeData(this.getID(), dataBuffer);
        this.mDimX = dataBuffer[0];
        this.mDimY = dataBuffer[1];
        this.mDimZ = dataBuffer[2];
        this.mDimMipmaps = dataBuffer[3] == 1;
        this.mDimFaces = dataBuffer[4] == 1;
        int elementID = dataBuffer[5];
        if (elementID != 0) {
            this.mElement = new Element(elementID, this.mRS);
            this.mElement.updateFromNative();
        }
        this.calcElementCount();
    }

    public static class Builder {
        RenderScript mRS;
        int mDimX = 1;
        int mDimY;
        int mDimZ;
        boolean mDimMipmaps;
        boolean mDimFaces;
        Element mElement;

        public Builder(RenderScript rs, Element e) {
            e.checkValid();
            this.mRS = rs;
            this.mElement = e;
        }

        public Builder setX(int value) {
            if (value < 1) {
                throw new RSIllegalArgumentException("Values of less than 1 for Dimension X are not valid.");
            }
            this.mDimX = value;
            return this;
        }

        public Builder setY(int value) {
            if (value < 1) {
                throw new RSIllegalArgumentException("Values of less than 1 for Dimension Y are not valid.");
            }
            this.mDimY = value;
            return this;
        }

        public Builder setMipmaps(boolean value) {
            this.mDimMipmaps = value;
            return this;
        }

        public Builder setFaces(boolean value) {
            this.mDimFaces = value;
            return this;
        }

        public Type create() {
            if (this.mDimZ > 0) {
                if (this.mDimX < 1 || this.mDimY < 1) {
                    throw new RSInvalidStateException("Both X and Y dimension required when Z is present.");
                }
                if (this.mDimFaces) {
                    throw new RSInvalidStateException("Cube maps not supported with 3D types.");
                }
            }
            if (this.mDimY > 0 && this.mDimX < 1) {
                throw new RSInvalidStateException("X dimension required when Y is present.");
            }
            if (this.mDimFaces && this.mDimY < 1) {
                throw new RSInvalidStateException("Cube maps require 2D Types.");
            }
            int id2 = this.mRS.nTypeCreate(this.mElement.getID(), this.mDimX, this.mDimY, this.mDimZ, this.mDimMipmaps, this.mDimFaces);
            Type t = new Type(id2, this.mRS);
            t.mElement = this.mElement;
            t.mDimX = this.mDimX;
            t.mDimY = this.mDimY;
            t.mDimZ = this.mDimZ;
            t.mDimMipmaps = this.mDimMipmaps;
            t.mDimFaces = this.mDimFaces;
            t.calcElementCount();
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CubemapFace {
        POSITIVE_X(0),
        NEGATIVE_X(1),
        POSITIVE_Y(2),
        NEGATIVE_Y(3),
        POSITIVE_Z(4),
        NEGATIVE_Z(5),
        POSITVE_X(0),
        POSITVE_Y(2),
        POSITVE_Z(4);

        int mID;

        private CubemapFace(int id2) {
            this.mID = id2;
        }
    }
}

