/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;

public class Selection {
    public static final Object SELECTION_START = new START();
    public static final Object SELECTION_END = new END();

    private Selection() {
    }

    public static int getSelectionStart(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_START);
        }
        return -1;
    }

    public static int getSelectionEnd(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_END);
        }
        return -1;
    }

    public static void setSelection(Spannable text, int start, int stop) {
        int ostart = Selection.getSelectionStart(text);
        int oend = Selection.getSelectionEnd(text);
        if (ostart != start || oend != stop) {
            text.setSpan(SELECTION_START, start, start, 546);
            text.setSpan(SELECTION_END, stop, stop, 34);
        }
    }

    public static void setSelection(Spannable text, int index) {
        Selection.setSelection(text, index, index);
    }

    public static void selectAll(Spannable text) {
        Selection.setSelection(text, 0, text.length());
    }

    public static void extendSelection(Spannable text, int index) {
        if (text.getSpanStart(SELECTION_END) != index) {
            text.setSpan(SELECTION_END, index, index, 34);
        }
    }

    public static void removeSelection(Spannable text) {
        text.removeSpan(SELECTION_START);
        text.removeSpan(SELECTION_END);
    }

    public static boolean moveUp(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            int min = Math.min(start, end);
            int max = Math.max(start, end);
            Selection.setSelection(text, min);
            return min != 0 || max != text.length();
        }
        int line = layout2.getLineForOffset(end);
        if (line > 0) {
            int move;
            if (layout2.getParagraphDirection(line) == layout2.getParagraphDirection(line - 1)) {
                float h = layout2.getPrimaryHorizontal(end);
                move = layout2.getOffsetForHorizontal(line - 1, h);
            } else {
                move = layout2.getLineStart(line - 1);
            }
            Selection.setSelection(text, move);
            return true;
        }
        return false;
    }

    public static boolean moveDown(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            int min = Math.min(start, end);
            int max = Math.max(start, end);
            Selection.setSelection(text, max);
            return min != 0 || max != text.length();
        }
        int line = layout2.getLineForOffset(end);
        if (line < layout2.getLineCount() - 1) {
            int move;
            if (layout2.getParagraphDirection(line) == layout2.getParagraphDirection(line + 1)) {
                float h = layout2.getPrimaryHorizontal(end);
                move = layout2.getOffsetForHorizontal(line + 1, h);
            } else {
                move = layout2.getLineStart(line + 1);
            }
            Selection.setSelection(text, move);
            return true;
        }
        return false;
    }

    public static boolean moveLeft(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            Selection.setSelection(text, Selection.chooseHorizontal(layout2, -1, start, end));
            return true;
        }
        int to = layout2.getOffsetToLeftOf(end);
        if (to != end) {
            Selection.setSelection(text, to);
            return true;
        }
        return false;
    }

    public static boolean moveRight(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            Selection.setSelection(text, Selection.chooseHorizontal(layout2, 1, start, end));
            return true;
        }
        int to = layout2.getOffsetToRightOf(end);
        if (to != end) {
            Selection.setSelection(text, to);
            return true;
        }
        return false;
    }

    public static boolean extendUp(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int line = layout2.getLineForOffset(end);
        if (line > 0) {
            int move;
            if (layout2.getParagraphDirection(line) == layout2.getParagraphDirection(line - 1)) {
                float h = layout2.getPrimaryHorizontal(end);
                move = layout2.getOffsetForHorizontal(line - 1, h);
            } else {
                move = layout2.getLineStart(line - 1);
            }
            Selection.extendSelection(text, move);
            return true;
        }
        if (end != 0) {
            Selection.extendSelection(text, 0);
            return true;
        }
        return true;
    }

    public static boolean extendDown(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int line = layout2.getLineForOffset(end);
        if (line < layout2.getLineCount() - 1) {
            int move;
            if (layout2.getParagraphDirection(line) == layout2.getParagraphDirection(line + 1)) {
                float h = layout2.getPrimaryHorizontal(end);
                move = layout2.getOffsetForHorizontal(line + 1, h);
            } else {
                move = layout2.getLineStart(line + 1);
            }
            Selection.extendSelection(text, move);
            return true;
        }
        if (end != text.length()) {
            Selection.extendSelection(text, text.length());
            return true;
        }
        return true;
    }

    public static boolean extendLeft(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int to = layout2.getOffsetToLeftOf(end);
        if (to != end) {
            Selection.extendSelection(text, to);
            return true;
        }
        return true;
    }

    public static boolean extendRight(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int to = layout2.getOffsetToRightOf(end);
        if (to != end) {
            Selection.extendSelection(text, to);
            return true;
        }
        return true;
    }

    public static boolean extendToLeftEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, -1);
        Selection.extendSelection(text, where);
        return true;
    }

    public static boolean extendToRightEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, 1);
        Selection.extendSelection(text, where);
        return true;
    }

    public static boolean moveToLeftEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, -1);
        Selection.setSelection(text, where);
        return true;
    }

    public static boolean moveToRightEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, 1);
        Selection.setSelection(text, where);
        return true;
    }

    public static boolean moveToPreceding(Spannable text, PositionIterator iter, boolean extendSelection) {
        int offset = iter.preceding(Selection.getSelectionEnd(text));
        if (offset != -1) {
            if (extendSelection) {
                Selection.extendSelection(text, offset);
            } else {
                Selection.setSelection(text, offset);
            }
        }
        return true;
    }

    public static boolean moveToFollowing(Spannable text, PositionIterator iter, boolean extendSelection) {
        int offset = iter.following(Selection.getSelectionEnd(text));
        if (offset != -1) {
            if (extendSelection) {
                Selection.extendSelection(text, offset);
            } else {
                Selection.setSelection(text, offset);
            }
        }
        return true;
    }

    private static int findEdge(Spannable text, Layout layout2, int dir) {
        int pt = Selection.getSelectionEnd(text);
        int line = layout2.getLineForOffset(pt);
        int pdir = layout2.getParagraphDirection(line);
        if (dir * pdir < 0) {
            return layout2.getLineStart(line);
        }
        int end = layout2.getLineEnd(line);
        if (line == layout2.getLineCount() - 1) {
            return end;
        }
        return end - 1;
    }

    private static int chooseHorizontal(Layout layout2, int direction, int off1, int off2) {
        int line2;
        int line1 = layout2.getLineForOffset(off1);
        if (line1 == (line2 = layout2.getLineForOffset(off2))) {
            float h1 = layout2.getPrimaryHorizontal(off1);
            float h2 = layout2.getPrimaryHorizontal(off2);
            if (direction < 0) {
                if (h1 < h2) {
                    return off1;
                }
                return off2;
            }
            if (h1 > h2) {
                return off1;
            }
            return off2;
        }
        int line = layout2.getLineForOffset(off1);
        int textdir = layout2.getParagraphDirection(line);
        if (textdir == direction) {
            return Math.max(off1, off2);
        }
        return Math.min(off1, off2);
    }

    private static class END
    implements NoCopySpan {
        private END() {
        }
    }

    private static class START
    implements NoCopySpan {
        private START() {
        }
    }

    public static interface PositionIterator {
        public static final int DONE = -1;

        public int preceding(int var1);

        public int following(int var1);
    }
}

