/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.GLUtils;
import android.opengl.ManagedEGLContext;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Log;
import android.view.DisplayList;
import android.view.GLES20Canvas;
import android.view.GLES20DisplayList;
import android.view.GLES20RenderLayer;
import android.view.GLES20TextureLayer;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.google.android.gles_jni.EGLImpl;
import java.io.File;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;

public abstract class HardwareRenderer {
    static final String LOG_TAG = "HardwareRenderer";
    private static final String CACHE_PATH_SHADERS = "com.android.opengl.shaders_cache";
    public static final boolean RENDER_DIRTY_REGIONS = true;
    static final String RENDER_DIRTY_REGIONS_PROPERTY = "hwui.render_dirty_regions";
    static final String DISABLE_VSYNC_PROPERTY = "hwui.disable_vsync";
    static final String PRINT_CONFIG_PROPERTY = "hwui.print_config";
    private static final boolean DEBUG_DIRTY_REGION = false;
    public static boolean sRendererDisabled = false;
    public static boolean sSystemRendererDisabled = false;
    private boolean mEnabled;
    private boolean mRequested = true;

    public static void disable(boolean system) {
        sRendererDisabled = true;
        if (system) {
            sSystemRendererDisabled = true;
        }
    }

    public static boolean isAvailable() {
        return GLES20Canvas.isAvailable();
    }

    abstract void destroy(boolean var1);

    abstract boolean initialize(SurfaceHolder var1) throws Surface.OutOfResourcesException;

    abstract void updateSurface(SurfaceHolder var1) throws Surface.OutOfResourcesException;

    abstract void destroyLayers(View var1);

    abstract void destroyHardwareResources(View var1);

    abstract void invalidate(SurfaceHolder var1);

    abstract boolean validate();

    abstract void setup(int var1, int var2);

    abstract int getWidth();

    abstract int getHeight();

    abstract HardwareCanvas getCanvas();

    public static void setupDiskCache(File cacheDir) {
        HardwareRenderer.nSetupShadersDiskCache(new File(cacheDir, CACHE_PATH_SHADERS).getAbsolutePath());
    }

    private static void nSetupShadersDiskCache(String string2) {
        OverrideMethod.invokeV("android.view.HardwareRenderer#nSetupShadersDiskCache(Ljava/lang/String;)V", true, null);
    }

    abstract boolean draw(View var1, View.AttachInfo var2, HardwareDrawCallbacks var3, Rect var4);

    abstract DisplayList createDisplayList();

    abstract HardwareLayer createHardwareLayer(boolean var1);

    abstract HardwareLayer createHardwareLayer(int var1, int var2, boolean var3);

    abstract SurfaceTexture createSurfaceTexture(HardwareLayer var1);

    void initializeIfNeeded(int width, int height, View.AttachInfo attachInfo, SurfaceHolder holder) throws Surface.OutOfResourcesException {
        if (this.isRequested() && !this.isEnabled() && this.initialize(holder)) {
            this.setup(width, height);
        }
    }

    static HardwareRenderer createGlRenderer(int glVersion, boolean translucent) {
        switch (glVersion) {
            case 2: {
                return Gl20Renderer.create(translucent);
            }
        }
        throw new IllegalArgumentException("Unknown GL version: " + glVersion);
    }

    static void trimMemory(int level) {
        Gl20Renderer.trimMemory(level);
    }

    boolean isEnabled() {
        return this.mEnabled;
    }

    void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    boolean isRequested() {
        return this.mRequested;
    }

    void setRequested(boolean requested) {
        this.mRequested = requested;
    }

    static class Gl20Renderer
    extends GlRenderer {
        private GLES20Canvas mGlCanvas;
        private static EGLSurface sPbuffer;
        private static final Object[] sPbufferLock;

        Gl20Renderer(boolean translucent) {
            super(2, translucent);
        }

        GLES20Canvas createCanvas() {
            this.mGlCanvas = new GLES20Canvas(this.mTranslucent);
            return this.mGlCanvas;
        }

        int[] getConfig(boolean dirtyRegions) {
            return new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12339, 4 | (dirtyRegions ? 1024 : 0), 12344};
        }

        void initCaches() {
            GLES20Canvas.initCaches();
        }

        boolean canDraw() {
            return super.canDraw() && this.mGlCanvas != null;
        }

        void onPreDraw(Rect dirty) {
            this.mGlCanvas.onPreDraw(dirty);
        }

        void onPostDraw() {
            this.mGlCanvas.onPostDraw();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy(boolean full) {
            try {
                super.destroy(full);
            }
            finally {
                if (full && this.mGlCanvas != null) {
                    this.mGlCanvas = null;
                }
            }
        }

        void setup(int width, int height) {
            super.setup(width, height);
            if (this.mVsyncDisabled) {
                GLES20Canvas.disableVsync();
            }
        }

        DisplayList createDisplayList() {
            return new GLES20DisplayList();
        }

        HardwareLayer createHardwareLayer(boolean isOpaque) {
            return new GLES20TextureLayer(isOpaque);
        }

        HardwareLayer createHardwareLayer(int width, int height, boolean isOpaque) {
            return new GLES20RenderLayer(width, height, isOpaque);
        }

        SurfaceTexture createSurfaceTexture(HardwareLayer layer) {
            return ((GLES20TextureLayer)layer).getSurfaceTexture();
        }

        void destroyLayers(View view) {
            if (view != null && this.isEnabled() && this.checkCurrent() != 0) {
                Gl20Renderer.destroyHardwareLayer(view);
                GLES20Canvas.flushCaches(0);
            }
        }

        private static void destroyHardwareLayer(View view) {
            view.destroyLayer();
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                int count = group.getChildCount();
                for (int i = 0; i < count; ++i) {
                    Gl20Renderer.destroyHardwareLayer(group.getChildAt(i));
                }
            }
        }

        void destroyHardwareResources(View view) {
            if (view != null) {
                boolean needsContext = true;
                if (this.isEnabled() && this.checkCurrent() != 0) {
                    needsContext = false;
                }
                if (needsContext) {
                    Gl20RendererEglContext managedContext = (Gl20RendererEglContext)sEglContextStorage.get();
                    if (managedContext == null) {
                        return;
                    }
                    Gl20Renderer.usePbufferSurface(managedContext.getContext());
                }
                Gl20Renderer.destroyResources(view);
                GLES20Canvas.flushCaches(0);
            }
        }

        private static void destroyResources(View view) {
            view.destroyHardwareResources();
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                int count = group.getChildCount();
                for (int i = 0; i < count; ++i) {
                    Gl20Renderer.destroyResources(group.getChildAt(i));
                }
            }
        }

        static HardwareRenderer create(boolean translucent) {
            if (GLES20Canvas.isAvailable()) {
                return new Gl20Renderer(translucent);
            }
            return null;
        }

        static void trimMemory(int level) {
            if (sEgl == null || sEglConfig == null) {
                return;
            }
            Gl20RendererEglContext managedContext = (Gl20RendererEglContext)sEglContextStorage.get();
            if (managedContext == null) {
                return;
            }
            Gl20Renderer.usePbufferSurface(managedContext.getContext());
            switch (level) {
                case 20: 
                case 40: 
                case 60: {
                    GLES20Canvas.flushCaches(1);
                    break;
                }
                case 80: {
                    GLES20Canvas.flushCaches(2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void usePbufferSurface(EGLContext eglContext) {
            Object[] objectArray = sPbufferLock;
            synchronized (sPbufferLock) {
                if (sPbuffer == null) {
                    sPbuffer = sEgl.eglCreatePbufferSurface(sEglDisplay, sEglConfig, new int[]{12375, 1, 12374, 1, 12344});
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                sEgl.eglMakeCurrent(sEglDisplay, sPbuffer, sPbuffer, eglContext);
                return;
            }
        }

        static {
            sPbufferLock = new Object[0];
        }

        static class Gl20RendererEglContext
        extends ManagedEGLContext {
            final Handler mHandler = new Handler();

            public Gl20RendererEglContext(EGLContext context) {
                super(context);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTerminate(final EGLContext eglContext) {
                if (this.mHandler.getLooper() != Looper.myLooper()) {
                    this.mHandler.post(new Runnable(){

                        public void run() {
                            Gl20RendererEglContext.this.onTerminate(eglContext);
                        }
                    });
                    return;
                }
                Object[] objectArray = GlRenderer.sEglLock;
                synchronized (GlRenderer.sEglLock) {
                    if (GlRenderer.sEgl == null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    if (EGLImpl.getInitCount(GlRenderer.sEglDisplay) == 1) {
                        Gl20Renderer.usePbufferSurface(eglContext);
                        GLES20Canvas.terminateCaches();
                        GlRenderer.sEgl.eglDestroyContext(GlRenderer.sEglDisplay, eglContext);
                        GlRenderer.sEglContextStorage.remove();
                        GlRenderer.sEgl.eglDestroySurface(GlRenderer.sEglDisplay, sPbuffer);
                        GlRenderer.sEgl.eglMakeCurrent(GlRenderer.sEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                        GlRenderer.sEgl.eglReleaseThread();
                        GlRenderer.sEgl.eglTerminate(GlRenderer.sEglDisplay);
                        GlRenderer.sEgl = null;
                        GlRenderer.sEglDisplay = null;
                        GlRenderer.sEglConfig = null;
                        sPbuffer = null;
                        GlRenderer.sEglContextStorage.set(null);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    static abstract class GlRenderer
    extends HardwareRenderer {
        static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
        static final int EGL_OPENGL_ES2_BIT = 4;
        static final int EGL_SURFACE_TYPE = 12339;
        static final int EGL_SWAP_BEHAVIOR_PRESERVED_BIT = 1024;
        static final int SURFACE_STATE_ERROR = 0;
        static final int SURFACE_STATE_SUCCESS = 1;
        static final int SURFACE_STATE_UPDATED = 2;
        static EGL10 sEgl;
        static EGLDisplay sEglDisplay;
        static EGLConfig sEglConfig;
        static final Object[] sEglLock;
        int mWidth = -1;
        int mHeight = -1;
        static final ThreadLocal<Gl20Renderer.Gl20RendererEglContext> sEglContextStorage;
        EGLContext mEglContext;
        Thread mEglThread;
        EGLSurface mEglSurface;
        GL mGl;
        HardwareCanvas mCanvas;
        int mFrameCount;
        Paint mDebugPaint;
        static boolean sDirtyRegions;
        static final boolean sDirtyRegionsRequested;
        boolean mDirtyRegionsEnabled;
        final boolean mVsyncDisabled;
        final int mGlVersion;
        final boolean mTranslucent;
        private boolean mDestroyed;
        private final Rect mRedrawClip = new Rect();

        GlRenderer(int glVersion, boolean translucent) {
            this.mGlVersion = glVersion;
            this.mTranslucent = translucent;
            String vsyncProperty = SystemProperties.get(HardwareRenderer.DISABLE_VSYNC_PROPERTY, "false");
            this.mVsyncDisabled = "true".equalsIgnoreCase(vsyncProperty);
            if (this.mVsyncDisabled) {
                Log.d(HardwareRenderer.LOG_TAG, "Disabling v-sync");
            }
        }

        boolean hasDirtyRegions() {
            return this.mDirtyRegionsEnabled;
        }

        void checkEglErrors() {
            int error;
            if (this.isEnabled() && (error = sEgl.eglGetError()) != 12288) {
                Log.w(HardwareRenderer.LOG_TAG, "EGL error: " + GLUtils.getEGLErrorString(error));
                this.fallback(error != 12302);
            }
        }

        private void fallback(boolean fallback) {
            this.destroy(true);
            if (fallback) {
                this.setRequested(false);
                Log.w(HardwareRenderer.LOG_TAG, "Mountain View, we've had a problem here. Switching back to software rendering.");
            }
        }

        boolean initialize(SurfaceHolder holder) throws Surface.OutOfResourcesException {
            if (this.isRequested() && !this.isEnabled()) {
                this.initializeEgl();
                this.mGl = this.createEglSurface(holder);
                this.mDestroyed = false;
                if (this.mGl != null) {
                    int err = sEgl.eglGetError();
                    if (err != 12288) {
                        this.destroy(true);
                        this.setRequested(false);
                    } else {
                        if (this.mCanvas == null) {
                            this.mCanvas = this.createCanvas();
                        }
                        if (this.mCanvas != null) {
                            this.setEnabled(true);
                        } else {
                            Log.w(HardwareRenderer.LOG_TAG, "Hardware accelerated Canvas could not be created");
                        }
                    }
                    return this.mCanvas != null;
                }
            }
            return false;
        }

        void updateSurface(SurfaceHolder holder) throws Surface.OutOfResourcesException {
            if (this.isRequested() && this.isEnabled()) {
                this.createEglSurface(holder);
            }
        }

        abstract GLES20Canvas createCanvas();

        abstract int[] getConfig(boolean var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void initializeEgl() {
            Object[] objectArray = sEglLock;
            synchronized (sEglLock) {
                if (sEgl == null && sEglConfig == null) {
                    sEgl = (EGL10)EGLContext.getEGL();
                    sEglDisplay = sEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
                    if (sEglDisplay == EGL10.EGL_NO_DISPLAY) {
                        throw new RuntimeException("eglGetDisplay failed " + GLUtils.getEGLErrorString(sEgl.eglGetError()));
                    }
                    int[] version = new int[2];
                    if (!sEgl.eglInitialize(sEglDisplay, version)) {
                        throw new RuntimeException("eglInitialize failed " + GLUtils.getEGLErrorString(sEgl.eglGetError()));
                    }
                    sEglConfig = this.chooseEglConfig();
                    if (sEglConfig == null) {
                        if (sDirtyRegions) {
                            sDirtyRegions = false;
                            sEglConfig = this.chooseEglConfig();
                            if (sEglConfig == null) {
                                throw new RuntimeException("eglConfig not initialized");
                            }
                        } else {
                            throw new RuntimeException("eglConfig not initialized");
                        }
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                Gl20Renderer.Gl20RendererEglContext managedContext = sEglContextStorage.get();
                this.mEglContext = managedContext != null ? managedContext.getContext() : null;
                this.mEglThread = Thread.currentThread();
                if (this.mEglContext == null) {
                    this.mEglContext = this.createContext(sEgl, sEglDisplay, sEglConfig);
                    sEglContextStorage.set(new Gl20Renderer.Gl20RendererEglContext(this.mEglContext));
                }
                return;
            }
        }

        private EGLConfig chooseEglConfig() {
            EGLConfig[] configs = new EGLConfig[1];
            int[] configsCount = new int[1];
            int[] configSpec = this.getConfig(sDirtyRegions);
            String debug = SystemProperties.get(HardwareRenderer.PRINT_CONFIG_PROPERTY, "");
            if ("all".equalsIgnoreCase(debug)) {
                sEgl.eglChooseConfig(sEglDisplay, configSpec, null, 0, configsCount);
                EGLConfig[] debugConfigs = new EGLConfig[configsCount[0]];
                sEgl.eglChooseConfig(sEglDisplay, configSpec, debugConfigs, configsCount[0], configsCount);
                for (EGLConfig config : debugConfigs) {
                    this.printConfig(config);
                }
            }
            if (!sEgl.eglChooseConfig(sEglDisplay, configSpec, configs, 1, configsCount)) {
                throw new IllegalArgumentException("eglChooseConfig failed " + GLUtils.getEGLErrorString(sEgl.eglGetError()));
            }
            if (configsCount[0] > 0) {
                if ("choice".equalsIgnoreCase(debug)) {
                    this.printConfig(configs[0]);
                }
                return configs[0];
            }
            return null;
        }

        private void printConfig(EGLConfig config) {
            int[] value = new int[1];
            Log.d(HardwareRenderer.LOG_TAG, "EGL configuration " + config + ":");
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12324, value);
            Log.d(HardwareRenderer.LOG_TAG, "  RED_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12323, value);
            Log.d(HardwareRenderer.LOG_TAG, "  GREEN_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12322, value);
            Log.d(HardwareRenderer.LOG_TAG, "  BLUE_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12321, value);
            Log.d(HardwareRenderer.LOG_TAG, "  ALPHA_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12325, value);
            Log.d(HardwareRenderer.LOG_TAG, "  DEPTH_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12326, value);
            Log.d(HardwareRenderer.LOG_TAG, "  STENCIL_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12339, value);
            Log.d(HardwareRenderer.LOG_TAG, "  SURFACE_TYPE = 0x" + Integer.toHexString(value[0]));
        }

        GL createEglSurface(SurfaceHolder holder) throws Surface.OutOfResourcesException {
            if (sEgl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (sEglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (sEglConfig == null) {
                throw new RuntimeException("eglConfig not initialized");
            }
            if (Thread.currentThread() != this.mEglThread) {
                throw new IllegalStateException("HardwareRenderer cannot be used from multiple threads");
            }
            this.destroySurface();
            if (!this.createSurface(holder)) {
                return null;
            }
            if (!sEgl.eglMakeCurrent(sEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                throw new Surface.OutOfResourcesException("eglMakeCurrent failed " + GLUtils.getEGLErrorString(sEgl.eglGetError()));
            }
            this.initCaches();
            if (sDirtyRegions) {
                this.mDirtyRegionsEnabled = GLES20Canvas.preserveBackBuffer();
                if (!this.mDirtyRegionsEnabled) {
                    Log.w(HardwareRenderer.LOG_TAG, "Backbuffer cannot be preserved");
                }
            } else if (sDirtyRegionsRequested) {
                this.mDirtyRegionsEnabled = GLES20Canvas.isBackBufferPreserved();
            }
            return this.mEglContext.getGL();
        }

        abstract void initCaches();

        EGLContext createContext(EGL10 egl, EGLDisplay eglDisplay, EGLConfig eglConfig) {
            int[] attribs = new int[]{12440, this.mGlVersion, 12344};
            return egl.eglCreateContext(eglDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, (int[])(this.mGlVersion != 0 ? attribs : null));
        }

        void destroy(boolean full) {
            if (full && this.mCanvas != null) {
                this.mCanvas = null;
            }
            if (!this.isEnabled() || this.mDestroyed) {
                this.setEnabled(false);
                return;
            }
            this.destroySurface();
            this.setEnabled(false);
            this.mDestroyed = true;
            this.mGl = null;
        }

        void destroySurface() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                sEgl.eglMakeCurrent(sEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                sEgl.eglDestroySurface(sEglDisplay, this.mEglSurface);
                this.mEglSurface = null;
            }
        }

        void invalidate(SurfaceHolder holder) {
            sEgl.eglMakeCurrent(sEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                sEgl.eglDestroySurface(sEglDisplay, this.mEglSurface);
                this.mEglSurface = null;
                this.setEnabled(false);
            }
            if (holder.getSurface().isValid()) {
                if (!this.createSurface(holder)) {
                    return;
                }
                if (this.mCanvas != null) {
                    this.setEnabled(true);
                }
            }
        }

        private boolean createSurface(SurfaceHolder holder) {
            this.mEglSurface = sEgl.eglCreateWindowSurface(sEglDisplay, sEglConfig, holder, null);
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                int error = sEgl.eglGetError();
                if (error == 12299) {
                    Log.e(HardwareRenderer.LOG_TAG, "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                    return false;
                }
                throw new RuntimeException("createWindowSurface failed " + GLUtils.getEGLErrorString(error));
            }
            return true;
        }

        boolean validate() {
            return this.checkCurrent() != 0;
        }

        void setup(int width, int height) {
            if (this.validate()) {
                this.mCanvas.setViewport(width, height);
                this.mWidth = width;
                this.mHeight = height;
            }
        }

        int getWidth() {
            return this.mWidth;
        }

        int getHeight() {
            return this.mHeight;
        }

        HardwareCanvas getCanvas() {
            return this.mCanvas;
        }

        boolean canDraw() {
            return this.mGl != null && this.mCanvas != null;
        }

        void onPreDraw(Rect dirty) {
        }

        void onPostDraw() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean draw(View view, View.AttachInfo attachInfo, HardwareDrawCallbacks callbacks, Rect dirty) {
            if (this.canDraw()) {
                if (!this.hasDirtyRegions()) {
                    dirty = null;
                } else if (dirty != null) {
                    dirty.intersect(0, 0, this.mWidth, this.mHeight);
                }
                attachInfo.mIgnoreDirtyState = true;
                attachInfo.mDrawingTime = SystemClock.uptimeMillis();
                view.mPrivateFlags |= 0x20;
                int surfaceState = this.checkCurrent();
                if (surfaceState != 0) {
                    HardwareCanvas canvas;
                    if (surfaceState == 2) {
                        dirty = null;
                    }
                    this.onPreDraw(dirty);
                    attachInfo.mHardwareCanvas = canvas = this.mCanvas;
                    int saveCount = canvas.save();
                    callbacks.onHardwarePreDraw(canvas);
                    try {
                        view.mRecreateDisplayList = (view.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
                        view.mPrivateFlags &= Integer.MAX_VALUE;
                        DisplayList displayList = view.getDisplayList();
                        if (displayList != null) {
                            if (canvas.drawDisplayList(displayList, view.getWidth(), view.getHeight(), this.mRedrawClip)) {
                                if (this.mRedrawClip.isEmpty() || view.getParent() == null) {
                                    view.invalidate();
                                } else {
                                    view.getParent().invalidateChild(view, this.mRedrawClip);
                                }
                                this.mRedrawClip.setEmpty();
                            }
                        } else {
                            view.draw(canvas);
                        }
                    }
                    finally {
                        callbacks.onHardwarePostDraw(canvas);
                        canvas.restoreToCount(saveCount);
                        view.mRecreateDisplayList = false;
                    }
                    this.onPostDraw();
                    attachInfo.mIgnoreDirtyState = false;
                    sEgl.eglSwapBuffers(sEglDisplay, this.mEglSurface);
                    this.checkEglErrors();
                    return dirty == null;
                }
            }
            return false;
        }

        int checkCurrent() {
            if (this.mEglThread != Thread.currentThread()) {
                throw new IllegalStateException("Hardware acceleration can only be used with a single UI thread.\nOriginal thread: " + this.mEglThread + "\n" + "Current thread: " + Thread.currentThread());
            }
            if (!this.mEglContext.equals(sEgl.eglGetCurrentContext()) || !this.mEglSurface.equals(sEgl.eglGetCurrentSurface(12377))) {
                if (!sEgl.eglMakeCurrent(sEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                    Log.e(HardwareRenderer.LOG_TAG, "eglMakeCurrent failed " + GLUtils.getEGLErrorString(sEgl.eglGetError()));
                    this.fallback(true);
                    return 0;
                }
                return 2;
            }
            return 1;
        }

        static {
            sEglLock = new Object[0];
            sEglContextStorage = new ThreadLocal();
            String dirtyProperty = SystemProperties.get(HardwareRenderer.RENDER_DIRTY_REGIONS_PROPERTY, "true");
            sDirtyRegionsRequested = sDirtyRegions = "true".equalsIgnoreCase(dirtyProperty);
        }
    }

    static interface HardwareDrawCallbacks {
        public void onHardwarePreDraw(HardwareCanvas var1);

        public void onHardwarePostDraw(HardwareCanvas var1);
    }
}

