/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.util.FloatMath;
import android.util.Log;
import android.view.InputEventConsistencyVerifier;
import android.view.MotionEvent;
import android.view.ViewConfiguration;

public class ScaleGestureDetector {
    private static final String TAG = "ScaleGestureDetector";
    private static final float PRESSURE_THRESHOLD = 0.67f;
    private final Context mContext;
    private final OnScaleGestureListener mListener;
    private boolean mGestureInProgress;
    private MotionEvent mPrevEvent;
    private MotionEvent mCurrEvent;
    private float mFocusX;
    private float mFocusY;
    private float mPrevFingerDiffX;
    private float mPrevFingerDiffY;
    private float mCurrFingerDiffX;
    private float mCurrFingerDiffY;
    private float mCurrLen;
    private float mPrevLen;
    private float mScaleFactor;
    private float mCurrPressure;
    private float mPrevPressure;
    private long mTimeDelta;
    private final float mEdgeSlop;
    private float mRightSlopEdge;
    private float mBottomSlopEdge;
    private boolean mSloppyGesture;
    private boolean mInvalidGesture;
    private int mActiveId0;
    private int mActiveId1;
    private boolean mActive0MostRecent;
    private final InputEventConsistencyVerifier mInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;

    public ScaleGestureDetector(Context context, OnScaleGestureListener listener) {
        ViewConfiguration config = ViewConfiguration.get(context);
        this.mContext = context;
        this.mListener = listener;
        this.mEdgeSlop = config.getScaledEdgeSlop();
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(MotionEvent event) {
        block44: {
            block45: {
                block43: {
                    if (this.mInputEventConsistencyVerifier != null) {
                        this.mInputEventConsistencyVerifier.onTouchEvent(event, 0);
                    }
                    if ((action = event.getActionMasked()) == 0) {
                        this.reset();
                    }
                    handled = true;
                    if (!this.mInvalidGesture) break block43;
                    handled = false;
                    break block44;
                }
                if (this.mGestureInProgress) break block45;
                switch (action) {
                    case 0: {
                        this.mActiveId0 = event.getPointerId(0);
                        this.mActive0MostRecent = true;
                        break;
                    }
                    case 1: {
                        this.reset();
                        break;
                    }
                    case 5: {
                        metrics = this.mContext.getResources().getDisplayMetrics();
                        this.mRightSlopEdge = (float)metrics.widthPixels - this.mEdgeSlop;
                        this.mBottomSlopEdge = (float)metrics.heightPixels - this.mEdgeSlop;
                        if (this.mPrevEvent != null) {
                            this.mPrevEvent.recycle();
                        }
                        this.mPrevEvent = MotionEvent.obtain(event);
                        this.mTimeDelta = 0L;
                        index1 = event.getActionIndex();
                        index0 = event.findPointerIndex(this.mActiveId0);
                        this.mActiveId1 = event.getPointerId(index1);
                        if (index0 < 0 || index0 == index1) {
                            index0 = this.findNewActiveIndex(event, index0 == index1 ? -1 : this.mActiveId1, index0);
                            this.mActiveId0 = event.getPointerId(index0);
                        }
                        this.mActive0MostRecent = false;
                        this.setContext(event);
                        edgeSlop = this.mEdgeSlop;
                        rightSlop = this.mRightSlopEdge;
                        bottomSlop = this.mBottomSlopEdge;
                        x0 = ScaleGestureDetector.getRawX(event, index0);
                        y0 = ScaleGestureDetector.getRawY(event, index0);
                        x1 = ScaleGestureDetector.getRawX(event, index1);
                        y1 = ScaleGestureDetector.getRawY(event, index1);
                        p0sloppy = x0 < edgeSlop || y0 < edgeSlop || x0 > rightSlop || y0 > bottomSlop;
                        v0 = p1sloppy = x1 < edgeSlop || y1 < edgeSlop || x1 > rightSlop || y1 > bottomSlop;
                        if (p0sloppy && p1sloppy) {
                            this.mFocusX = -1.0f;
                            this.mFocusY = -1.0f;
                            this.mSloppyGesture = true;
                            break;
                        }
                        if (p0sloppy) {
                            this.mFocusX = event.getX(index1);
                            this.mFocusY = event.getY(index1);
                            this.mSloppyGesture = true;
                            break;
                        }
                        if (p1sloppy) {
                            this.mFocusX = event.getX(index0);
                            this.mFocusY = event.getY(index0);
                            this.mSloppyGesture = true;
                            break;
                        }
                        this.mSloppyGesture = false;
                        this.mGestureInProgress = this.mListener.onScaleBegin(this);
                        break;
                    }
                    case 2: {
                        if (!this.mSloppyGesture) break;
                        edgeSlop = this.mEdgeSlop;
                        rightSlop = this.mRightSlopEdge;
                        bottomSlop = this.mBottomSlopEdge;
                        index0 = event.findPointerIndex(this.mActiveId0);
                        index1 = event.findPointerIndex(this.mActiveId1);
                        x0 = ScaleGestureDetector.getRawX(event, index0);
                        y0 = ScaleGestureDetector.getRawY(event, index0);
                        x1 = ScaleGestureDetector.getRawX(event, index1);
                        y1 = ScaleGestureDetector.getRawY(event, index1);
                        p0sloppy = x0 < edgeSlop || y0 < edgeSlop || x0 > rightSlop || y0 > bottomSlop;
                        v1 = p1sloppy = x1 < edgeSlop || y1 < edgeSlop || x1 > rightSlop || y1 > bottomSlop;
                        if (p0sloppy && (index = this.findNewActiveIndex(event, this.mActiveId1, index0)) >= 0) {
                            index0 = index;
                            this.mActiveId0 = event.getPointerId(index);
                            x0 = ScaleGestureDetector.getRawX(event, index);
                            y0 = ScaleGestureDetector.getRawY(event, index);
                            p0sloppy = false;
                        }
                        if (p1sloppy && (index = this.findNewActiveIndex(event, this.mActiveId0, index1)) >= 0) {
                            index1 = index;
                            this.mActiveId1 = event.getPointerId(index);
                            x1 = ScaleGestureDetector.getRawX(event, index);
                            y1 = ScaleGestureDetector.getRawY(event, index);
                            p1sloppy = false;
                        }
                        if (p0sloppy && p1sloppy) {
                            this.mFocusX = -1.0f;
                            this.mFocusY = -1.0f;
                            break;
                        }
                        if (p0sloppy) {
                            this.mFocusX = event.getX(index1);
                            this.mFocusY = event.getY(index1);
                            break;
                        }
                        if (p1sloppy) {
                            this.mFocusX = event.getX(index0);
                            this.mFocusY = event.getY(index0);
                            break;
                        }
                        this.mSloppyGesture = false;
                        this.mGestureInProgress = this.mListener.onScaleBegin(this);
                        break;
                    }
                    case 6: {
                        if (!this.mSloppyGesture) break;
                        pointerCount = event.getPointerCount();
                        actionIndex = event.getActionIndex();
                        actionId = event.getPointerId(actionIndex);
                        if (pointerCount <= 2) ** GOTO lbl120
                        if (actionId == this.mActiveId0) {
                            newIndex = this.findNewActiveIndex(event, this.mActiveId1, actionIndex);
                            if (newIndex >= 0) {
                                this.mActiveId0 = event.getPointerId(newIndex);
                                break;
                            }
                        } else {
                            if (actionId != this.mActiveId1) break;
                            newIndex = this.findNewActiveIndex(event, this.mActiveId0, actionIndex);
                            if (newIndex >= 0) {
                                this.mActiveId1 = event.getPointerId(newIndex);
                                break;
                            }
                        }
                        break block44;
lbl120:
                        // 1 sources

                        index = event.findPointerIndex(actionId == this.mActiveId0 ? this.mActiveId1 : this.mActiveId0);
                        if (index < 0) {
                            this.mInvalidGesture = true;
                            Log.e("ScaleGestureDetector", "Invalid MotionEvent stream detected.", new Throwable());
                            if (this.mGestureInProgress) {
                                this.mListener.onScaleEnd(this);
                            }
                            return false;
                        }
                        this.mActiveId0 = event.getPointerId(index);
                        this.mActive0MostRecent = true;
                        this.mActiveId1 = -1;
                        this.mFocusX = event.getX(index);
                        this.mFocusY = event.getY(index);
                    }
                }
                break block44;
            }
            switch (action) {
                case 5: {
                    this.mListener.onScaleEnd(this);
                    oldActive0 = this.mActiveId0;
                    oldActive1 = this.mActiveId1;
                    this.reset();
                    this.mPrevEvent = MotionEvent.obtain(event);
                    this.mActiveId0 = this.mActive0MostRecent != false ? oldActive0 : oldActive1;
                    this.mActiveId1 = event.getPointerId(event.getActionIndex());
                    this.mActive0MostRecent = false;
                    index0 = event.findPointerIndex(this.mActiveId0);
                    if (index0 < 0 || this.mActiveId0 == this.mActiveId1) {
                        Log.e("ScaleGestureDetector", "Got " + MotionEvent.actionToString(action) + " with bad state while a gesture was in progress. " + "Did you forget to pass an event to " + "ScaleGestureDetector#onTouchEvent?");
                        index0 = this.findNewActiveIndex(event, this.mActiveId0 == this.mActiveId1 ? -1 : this.mActiveId1, index0);
                        this.mActiveId0 = event.getPointerId(index0);
                    }
                    this.setContext(event);
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                    break;
                }
                case 6: {
                    pointerCount = event.getPointerCount();
                    actionIndex = event.getActionIndex();
                    actionId = event.getPointerId(actionIndex);
                    gestureEnded = false;
                    if (pointerCount > 2) {
                        if (actionId == this.mActiveId0) {
                            newIndex = this.findNewActiveIndex(event, this.mActiveId1, actionIndex);
                            if (newIndex >= 0) {
                                this.mListener.onScaleEnd(this);
                                this.mActiveId0 = event.getPointerId(newIndex);
                                this.mActive0MostRecent = true;
                                this.mPrevEvent = MotionEvent.obtain(event);
                                this.setContext(event);
                                this.mGestureInProgress = this.mListener.onScaleBegin(this);
                            } else {
                                gestureEnded = true;
                            }
                        } else if (actionId == this.mActiveId1) {
                            newIndex = this.findNewActiveIndex(event, this.mActiveId0, actionIndex);
                            if (newIndex >= 0) {
                                this.mListener.onScaleEnd(this);
                                this.mActiveId1 = event.getPointerId(newIndex);
                                this.mActive0MostRecent = false;
                                this.mPrevEvent = MotionEvent.obtain(event);
                                this.setContext(event);
                                this.mGestureInProgress = this.mListener.onScaleBegin(this);
                            } else {
                                gestureEnded = true;
                            }
                        }
                        this.mPrevEvent.recycle();
                        this.mPrevEvent = MotionEvent.obtain(event);
                        this.setContext(event);
                    } else {
                        gestureEnded = true;
                    }
                    if (!gestureEnded) break;
                    this.setContext(event);
                    activeId = actionId == this.mActiveId0 ? this.mActiveId1 : this.mActiveId0;
                    index = event.findPointerIndex(activeId);
                    this.mFocusX = event.getX(index);
                    this.mFocusY = event.getY(index);
                    this.mListener.onScaleEnd(this);
                    this.reset();
                    this.mActiveId0 = activeId;
                    this.mActive0MostRecent = true;
                    break;
                }
                case 3: {
                    this.mListener.onScaleEnd(this);
                    this.reset();
                    break;
                }
                case 1: {
                    this.reset();
                    break;
                }
                case 2: {
                    this.setContext(event);
                    if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(updatePrevious = this.mListener.onScale(this))) break;
                    this.mPrevEvent.recycle();
                    this.mPrevEvent = MotionEvent.obtain(event);
                }
            }
        }
        if (!handled && this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 0);
        }
        return handled;
    }

    private int findNewActiveIndex(MotionEvent ev, int otherActiveId, int oldIndex) {
        int pointerCount = ev.getPointerCount();
        int otherActiveIndex = ev.findPointerIndex(otherActiveId);
        int newActiveIndex = -1;
        for (int i = 0; i < pointerCount; ++i) {
            if (i == oldIndex || i == otherActiveIndex) continue;
            float edgeSlop = this.mEdgeSlop;
            float rightSlop = this.mRightSlopEdge;
            float bottomSlop = this.mBottomSlopEdge;
            float x = ScaleGestureDetector.getRawX(ev, i);
            float y = ScaleGestureDetector.getRawY(ev, i);
            if (!(x >= edgeSlop) || !(y >= edgeSlop) || !(x <= rightSlop) || !(y <= bottomSlop)) continue;
            newActiveIndex = i;
            break;
        }
        return newActiveIndex;
    }

    private static float getRawX(MotionEvent event, int pointerIndex) {
        if (pointerIndex < 0) {
            return Float.MIN_VALUE;
        }
        if (pointerIndex == 0) {
            return event.getRawX();
        }
        float offset = event.getRawX() - event.getX();
        return event.getX(pointerIndex) + offset;
    }

    private static float getRawY(MotionEvent event, int pointerIndex) {
        if (pointerIndex < 0) {
            return Float.MIN_VALUE;
        }
        if (pointerIndex == 0) {
            return event.getRawY();
        }
        float offset = event.getRawY() - event.getY();
        return event.getY(pointerIndex) + offset;
    }

    private void setContext(MotionEvent curr) {
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
        }
        this.mCurrEvent = MotionEvent.obtain(curr);
        this.mCurrLen = -1.0f;
        this.mPrevLen = -1.0f;
        this.mScaleFactor = -1.0f;
        MotionEvent prev = this.mPrevEvent;
        int prevIndex0 = prev.findPointerIndex(this.mActiveId0);
        int prevIndex1 = prev.findPointerIndex(this.mActiveId1);
        int currIndex0 = curr.findPointerIndex(this.mActiveId0);
        int currIndex1 = curr.findPointerIndex(this.mActiveId1);
        if (prevIndex0 < 0 || prevIndex1 < 0 || currIndex0 < 0 || currIndex1 < 0) {
            this.mInvalidGesture = true;
            Log.e(TAG, "Invalid MotionEvent stream detected.", new Throwable());
            if (this.mGestureInProgress) {
                this.mListener.onScaleEnd(this);
            }
            return;
        }
        float px0 = prev.getX(prevIndex0);
        float py0 = prev.getY(prevIndex0);
        float px1 = prev.getX(prevIndex1);
        float py1 = prev.getY(prevIndex1);
        float cx0 = curr.getX(currIndex0);
        float cy0 = curr.getY(currIndex0);
        float cx1 = curr.getX(currIndex1);
        float cy1 = curr.getY(currIndex1);
        float pvx = px1 - px0;
        float pvy = py1 - py0;
        float cvx = cx1 - cx0;
        float cvy = cy1 - cy0;
        this.mPrevFingerDiffX = pvx;
        this.mPrevFingerDiffY = pvy;
        this.mCurrFingerDiffX = cvx;
        this.mCurrFingerDiffY = cvy;
        this.mFocusX = cx0 + cvx * 0.5f;
        this.mFocusY = cy0 + cvy * 0.5f;
        this.mTimeDelta = curr.getEventTime() - prev.getEventTime();
        this.mCurrPressure = curr.getPressure(currIndex0) + curr.getPressure(currIndex1);
        this.mPrevPressure = prev.getPressure(prevIndex0) + prev.getPressure(prevIndex1);
    }

    private void reset() {
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mSloppyGesture = false;
        this.mGestureInProgress = false;
        this.mActiveId0 = -1;
        this.mActiveId1 = -1;
        this.mInvalidGesture = false;
    }

    public boolean isInProgress() {
        return this.mGestureInProgress;
    }

    public float getFocusX() {
        return this.mFocusX;
    }

    public float getFocusY() {
        return this.mFocusY;
    }

    public float getCurrentSpan() {
        if (this.mCurrLen == -1.0f) {
            float cvx = this.mCurrFingerDiffX;
            float cvy = this.mCurrFingerDiffY;
            this.mCurrLen = FloatMath.sqrt(cvx * cvx + cvy * cvy);
        }
        return this.mCurrLen;
    }

    public float getCurrentSpanX() {
        return this.mCurrFingerDiffX;
    }

    public float getCurrentSpanY() {
        return this.mCurrFingerDiffY;
    }

    public float getPreviousSpan() {
        if (this.mPrevLen == -1.0f) {
            float pvx = this.mPrevFingerDiffX;
            float pvy = this.mPrevFingerDiffY;
            this.mPrevLen = FloatMath.sqrt(pvx * pvx + pvy * pvy);
        }
        return this.mPrevLen;
    }

    public float getPreviousSpanX() {
        return this.mPrevFingerDiffX;
    }

    public float getPreviousSpanY() {
        return this.mPrevFingerDiffY;
    }

    public float getScaleFactor() {
        if (this.mScaleFactor == -1.0f) {
            this.mScaleFactor = this.getCurrentSpan() / this.getPreviousSpan();
        }
        return this.mScaleFactor;
    }

    public long getTimeDelta() {
        return this.mTimeDelta;
    }

    public long getEventTime() {
        return this.mCurrEvent.getEventTime();
    }

    public static class SimpleOnScaleGestureListener
    implements OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector detector) {
            return false;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    }

    public static interface OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector var1);

        public boolean onScaleBegin(ScaleGestureDetector var1);

        public void onScaleEnd(ScaleGestureDetector var1);
    }
}

