/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.text.Editable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.QwertyKeyListener;
import android.util.AttributeSet;
import android.widget.AutoCompleteTextView;
import android.widget.Filter;

public class MultiAutoCompleteTextView
extends AutoCompleteTextView {
    private Tokenizer mTokenizer;

    public MultiAutoCompleteTextView(Context context) {
        this(context, null);
    }

    public MultiAutoCompleteTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842859);
    }

    public MultiAutoCompleteTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    void finishInit() {
    }

    public void setTokenizer(Tokenizer t) {
        this.mTokenizer = t;
    }

    protected void performFiltering(CharSequence text, int keyCode) {
        if (this.enoughToFilter()) {
            int end = this.getSelectionEnd();
            int start = this.mTokenizer.findTokenStart(text, end);
            this.performFiltering(text, start, end, keyCode);
        } else {
            this.dismissDropDown();
            Filter f = this.getFilter();
            if (f != null) {
                f.filter(null);
            }
        }
    }

    public boolean enoughToFilter() {
        Editable text = this.getText();
        int end = this.getSelectionEnd();
        if (end < 0 || this.mTokenizer == null) {
            return false;
        }
        int start = this.mTokenizer.findTokenStart(text, end);
        return end - start >= this.getThreshold();
    }

    public void performValidation() {
        AutoCompleteTextView.Validator v = this.getValidator();
        if (v == null || this.mTokenizer == null) {
            return;
        }
        Editable e = this.getText();
        int i = this.getText().length();
        while (i > 0) {
            int end;
            int start = this.mTokenizer.findTokenStart(e, i);
            CharSequence sub = e.subSequence(start, end = this.mTokenizer.findTokenEnd(e, start));
            if (TextUtils.isEmpty(sub)) {
                e.replace(start, i, "");
            } else if (!v.isValid(sub)) {
                e.replace(start, i, this.mTokenizer.terminateToken(v.fixText(sub)));
            }
            i = start;
        }
    }

    protected void performFiltering(CharSequence text, int start, int end, int keyCode) {
        this.getFilter().filter(text.subSequence(start, end), this);
    }

    protected void replaceText(CharSequence text) {
        this.clearComposingText();
        int end = this.getSelectionEnd();
        int start = this.mTokenizer.findTokenStart(this.getText(), end);
        Editable editable = this.getText();
        String original = TextUtils.substring(editable, start, end);
        QwertyKeyListener.markAsReplaced(editable, start, end, original);
        editable.replace(start, end, this.mTokenizer.terminateToken(text));
    }

    public static class CommaTokenizer
    implements Tokenizer {
        public int findTokenStart(CharSequence text, int cursor) {
            int i;
            for (i = cursor; i > 0 && text.charAt(i - 1) != ','; --i) {
            }
            while (i < cursor && text.charAt(i) == ' ') {
                ++i;
            }
            return i;
        }

        public int findTokenEnd(CharSequence text, int cursor) {
            int len = text.length();
            for (int i = cursor; i < len; ++i) {
                if (text.charAt(i) != ',') continue;
                return i;
            }
            return len;
        }

        public CharSequence terminateToken(CharSequence text) {
            int i;
            for (i = text.length(); i > 0 && text.charAt(i - 1) == ' '; --i) {
            }
            if (i > 0 && text.charAt(i - 1) == ',') {
                return text;
            }
            if (text instanceof Spanned) {
                SpannableString sp = new SpannableString(text + ", ");
                TextUtils.copySpansFrom((Spanned)text, 0, text.length(), Object.class, sp, 0);
                return sp;
            }
            return text + ", ";
        }
    }

    public static interface Tokenizer {
        public int findTokenStart(CharSequence var1, int var2);

        public int findTokenEnd(CharSequence var1, int var2);

        public CharSequence terminateToken(CharSequence var1);
    }
}

