/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.widget.RemoteViews;
import com.android.internal.widget.IRemoteViewsFactory;
import java.util.HashMap;

public abstract class RemoteViewsService
extends Service {
    private static final String LOG_TAG = "RemoteViewsService";
    private static final HashMap<Intent.FilterComparison, RemoteViewsFactory> sRemoteViewFactories = new HashMap();
    private static final Object sLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinder onBind(Intent intent) {
        Object object = sLock;
        synchronized (object) {
            Intent.FilterComparison fc = new Intent.FilterComparison(intent);
            RemoteViewsFactory factory = null;
            boolean isCreated = false;
            if (!sRemoteViewFactories.containsKey(fc)) {
                factory = this.onGetViewFactory(intent);
                sRemoteViewFactories.put(fc, factory);
                factory.onCreate();
                isCreated = false;
            } else {
                factory = sRemoteViewFactories.get(fc);
                isCreated = true;
            }
            return new RemoteViewsFactoryAdapter(factory, isCreated);
        }
    }

    public abstract RemoteViewsFactory onGetViewFactory(Intent var1);

    private static class RemoteViewsFactoryAdapter
    extends IRemoteViewsFactory.Stub {
        private RemoteViewsFactory mFactory;
        private boolean mIsCreated;

        public RemoteViewsFactoryAdapter(RemoteViewsFactory factory, boolean isCreated) {
            this.mFactory = factory;
            this.mIsCreated = isCreated;
        }

        public synchronized boolean isCreated() {
            return this.mIsCreated;
        }

        public synchronized void onDataSetChanged() {
            try {
                this.mFactory.onDataSetChanged();
            }
            catch (Exception ex) {
                Thread t = Thread.currentThread();
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, ex);
            }
        }

        public synchronized void onDataSetChangedAsync() {
            this.onDataSetChanged();
        }

        public synchronized int getCount() {
            int count = 0;
            try {
                count = this.mFactory.getCount();
            }
            catch (Exception ex) {
                Thread t = Thread.currentThread();
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, ex);
            }
            return count;
        }

        public synchronized RemoteViews getViewAt(int position) {
            RemoteViews rv = null;
            try {
                rv = this.mFactory.getViewAt(position);
                if (rv != null) {
                    rv.setIsWidgetCollectionChild(true);
                }
            }
            catch (Exception ex) {
                Thread t = Thread.currentThread();
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, ex);
            }
            return rv;
        }

        public synchronized RemoteViews getLoadingView() {
            RemoteViews rv = null;
            try {
                rv = this.mFactory.getLoadingView();
            }
            catch (Exception ex) {
                Thread t = Thread.currentThread();
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, ex);
            }
            return rv;
        }

        public synchronized int getViewTypeCount() {
            int count = 0;
            try {
                count = this.mFactory.getViewTypeCount();
            }
            catch (Exception ex) {
                Thread t = Thread.currentThread();
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, ex);
            }
            return count;
        }

        public synchronized long getItemId(int position) {
            long id2 = 0L;
            try {
                id2 = this.mFactory.getItemId(position);
            }
            catch (Exception ex) {
                Thread t = Thread.currentThread();
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, ex);
            }
            return id2;
        }

        public synchronized boolean hasStableIds() {
            boolean hasStableIds = false;
            try {
                hasStableIds = this.mFactory.hasStableIds();
            }
            catch (Exception ex) {
                Thread t = Thread.currentThread();
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, ex);
            }
            return hasStableIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDestroy(Intent intent) {
            Object object = sLock;
            synchronized (object) {
                Intent.FilterComparison fc = new Intent.FilterComparison(intent);
                if (sRemoteViewFactories.containsKey(fc)) {
                    RemoteViewsFactory factory = (RemoteViewsFactory)sRemoteViewFactories.get(fc);
                    try {
                        factory.onDestroy();
                    }
                    catch (Exception ex) {
                        Thread t = Thread.currentThread();
                        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, ex);
                    }
                    sRemoteViewFactories.remove(fc);
                }
            }
        }
    }

    public static interface RemoteViewsFactory {
        public void onCreate();

        public void onDataSetChanged();

        public void onDestroy();

        public int getCount();

        public RemoteViews getViewAt(int var1);

        public RemoteViews getLoadingView();

        public int getViewTypeCount();

        public long getItemId(int var1);

        public boolean hasStableIds();
    }
}

