/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import android.widget.ResourceCursorAdapter;
import android.widget.TextView;

public class SimpleCursorAdapter
extends ResourceCursorAdapter {
    protected int[] mFrom;
    protected int[] mTo;
    private int mStringConversionColumn = -1;
    private CursorToStringConverter mCursorToStringConverter;
    private ViewBinder mViewBinder;
    String[] mOriginalFrom;

    @Deprecated
    public SimpleCursorAdapter(Context context, int layout2, Cursor c, String[] from, int[] to) {
        super(context, layout2, c);
        this.mTo = to;
        this.mOriginalFrom = from;
        this.findColumns(from);
    }

    public SimpleCursorAdapter(Context context, int layout2, Cursor c, String[] from, int[] to, int flags) {
        super(context, layout2, c, flags);
        this.mTo = to;
        this.mOriginalFrom = from;
        this.findColumns(from);
    }

    public void bindView(View view, Context context, Cursor cursor) {
        ViewBinder binder = this.mViewBinder;
        int count = this.mTo.length;
        int[] from = this.mFrom;
        int[] to = this.mTo;
        for (int i = 0; i < count; ++i) {
            View v = view.findViewById(to[i]);
            if (v == null) continue;
            boolean bound = false;
            if (binder != null) {
                bound = binder.setViewValue(v, cursor, from[i]);
            }
            if (bound) continue;
            String text = cursor.getString(from[i]);
            if (text == null) {
                text = "";
            }
            if (v instanceof TextView) {
                this.setViewText((TextView)v, text);
                continue;
            }
            if (v instanceof ImageView) {
                this.setViewImage((ImageView)v, text);
                continue;
            }
            throw new IllegalStateException(v.getClass().getName() + " is not a " + " view that can be bounds by this SimpleCursorAdapter");
        }
    }

    public ViewBinder getViewBinder() {
        return this.mViewBinder;
    }

    public void setViewBinder(ViewBinder viewBinder) {
        this.mViewBinder = viewBinder;
    }

    public void setViewImage(ImageView v, String value) {
        try {
            v.setImageResource(Integer.parseInt(value));
        }
        catch (NumberFormatException nfe) {
            v.setImageURI(Uri.parse(value));
        }
    }

    public void setViewText(TextView v, String text) {
        v.setText(text);
    }

    public int getStringConversionColumn() {
        return this.mStringConversionColumn;
    }

    public void setStringConversionColumn(int stringConversionColumn) {
        this.mStringConversionColumn = stringConversionColumn;
    }

    public CursorToStringConverter getCursorToStringConverter() {
        return this.mCursorToStringConverter;
    }

    public void setCursorToStringConverter(CursorToStringConverter cursorToStringConverter) {
        this.mCursorToStringConverter = cursorToStringConverter;
    }

    public CharSequence convertToString(Cursor cursor) {
        if (this.mCursorToStringConverter != null) {
            return this.mCursorToStringConverter.convertToString(cursor);
        }
        if (this.mStringConversionColumn > -1) {
            return cursor.getString(this.mStringConversionColumn);
        }
        return super.convertToString(cursor);
    }

    private void findColumns(String[] from) {
        if (this.mCursor != null) {
            int count = from.length;
            if (this.mFrom == null || this.mFrom.length != count) {
                this.mFrom = new int[count];
            }
            for (int i = 0; i < count; ++i) {
                this.mFrom[i] = this.mCursor.getColumnIndexOrThrow(from[i]);
            }
        } else {
            this.mFrom = null;
        }
    }

    public Cursor swapCursor(Cursor c) {
        if (this.mFrom == null) {
            this.findColumns(this.mOriginalFrom);
        }
        Cursor res = super.swapCursor(c);
        this.findColumns(this.mOriginalFrom);
        return res;
    }

    public void changeCursorAndColumns(Cursor c, String[] from, int[] to) {
        this.mOriginalFrom = from;
        this.mTo = to;
        if (this.mFrom == null) {
            this.findColumns(this.mOriginalFrom);
        }
        super.changeCursor(c);
        this.findColumns(this.mOriginalFrom);
    }

    public static interface CursorToStringConverter {
        public CharSequence convertToString(Cursor var1);
    }

    public static interface ViewBinder {
        public boolean setViewValue(View var1, Cursor var2, int var3);
    }
}

