/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;

public class OperatorInfo
implements Parcelable {
    private String operatorAlphaLong;
    private String operatorAlphaShort;
    private String operatorNumeric;
    private State state = State.UNKNOWN;
    public static final Parcelable.Creator<OperatorInfo> CREATOR = new Parcelable.Creator<OperatorInfo>(){

        @Override
        public OperatorInfo createFromParcel(Parcel in) {
            OperatorInfo opInfo = new OperatorInfo(in.readString(), in.readString(), in.readString(), (State)((Object)in.readSerializable()));
            return opInfo;
        }

        public OperatorInfo[] newArray(int size) {
            return new OperatorInfo[size];
        }
    };

    public String getOperatorAlphaLong() {
        return this.operatorAlphaLong;
    }

    public String getOperatorAlphaShort() {
        return this.operatorAlphaShort;
    }

    public String getOperatorNumeric() {
        return this.operatorNumeric;
    }

    public State getState() {
        return this.state;
    }

    OperatorInfo(String operatorAlphaLong, String operatorAlphaShort, String operatorNumeric, State state) {
        this.operatorAlphaLong = operatorAlphaLong;
        this.operatorAlphaShort = operatorAlphaShort;
        this.operatorNumeric = operatorNumeric;
        this.state = state;
    }

    public OperatorInfo(String operatorAlphaLong, String operatorAlphaShort, String operatorNumeric, String stateString) {
        this(operatorAlphaLong, operatorAlphaShort, operatorNumeric, OperatorInfo.rilStateToState(stateString));
    }

    private static State rilStateToState(String s) {
        if (s.equals("unknown")) {
            return State.UNKNOWN;
        }
        if (s.equals("available")) {
            return State.AVAILABLE;
        }
        if (s.equals("current")) {
            return State.CURRENT;
        }
        if (s.equals("forbidden")) {
            return State.FORBIDDEN;
        }
        throw new RuntimeException("RIL impl error: Invalid network state '" + s + "'");
    }

    public String toString() {
        return "OperatorInfo " + this.operatorAlphaLong + "/" + this.operatorAlphaShort + "/" + this.operatorNumeric + "/" + (Object)((Object)this.state);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.operatorAlphaLong);
        dest.writeString(this.operatorAlphaShort);
        dest.writeString(this.operatorNumeric);
        dest.writeSerializable((Serializable)((Object)this.state));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNKNOWN,
        AVAILABLE,
        CURRENT,
        FORBIDDEN;

    }
}

