/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.IccException;
import com.android.internal.telephony.IccRecords;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.cdma.CDMAPhone;

public class RuimRecords
extends IccRecords {
    static final String LOG_TAG = "CDMA";
    private static final boolean DBG = true;
    private boolean m_ota_commited = false;
    private String mImsi;
    private String mMyMobileNumber;
    private String mMin2Min1;
    private String mPrlVersion;
    private static final int EVENT_RUIM_READY = 1;
    private static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 2;
    private static final int EVENT_GET_IMSI_DONE = 3;
    private static final int EVENT_GET_DEVICE_IDENTITY_DONE = 4;
    private static final int EVENT_GET_ICCID_DONE = 5;
    private static final int EVENT_GET_CDMA_SUBSCRIPTION_DONE = 10;
    private static final int EVENT_UPDATE_DONE = 14;
    private static final int EVENT_GET_SST_DONE = 17;
    private static final int EVENT_GET_ALL_SMS_DONE = 18;
    private static final int EVENT_MARK_SMS_READ_DONE = 19;
    private static final int EVENT_SMS_ON_RUIM = 21;
    private static final int EVENT_GET_SMS_DONE = 22;
    private static final int EVENT_RUIM_REFRESH = 31;

    RuimRecords(CDMAPhone p) {
        super(p);
        this.adnCache = new AdnRecordCache(this.phone);
        this.recordsRequested = false;
        this.recordsToLoad = 0;
        p.mCM.registerForRUIMReady(this, 1, null);
        p.mCM.registerForOffOrNotAvailable(this, 2, null);
        p.mCM.registerForIccRefresh(this, 31, null);
        this.onRadioOffOrNotAvailable();
    }

    public void dispose() {
        this.phone.mCM.unregisterForRUIMReady(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.phone.mCM.unregisterForIccRefresh(this);
    }

    protected void finalize() {
        Log.d(LOG_TAG, "RuimRecords finalized");
    }

    protected void onRadioOffOrNotAvailable() {
        this.countVoiceMessages = 0;
        this.mncLength = -1;
        this.iccid = null;
        this.adnCache.reset();
        this.recordsRequested = false;
    }

    public String getMdnNumber() {
        return this.mMyMobileNumber;
    }

    public String getCdmaMin() {
        return this.mMin2Min1;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    public void setVoiceMailNumber(String alphaTag, String voiceNumber, Message onComplete) {
        AsyncResult.forMessage((Message)onComplete).exception = new IccException("setVoiceMailNumber not implemented");
        onComplete.sendToTarget();
        Log.e(LOG_TAG, "method setVoiceMailNumber is not implemented");
    }

    public void onRefresh(boolean fileChanged, int[] fileList) {
        if (fileChanged) {
            this.fetchRuimRecords();
        }
    }

    public String getRUIMOperatorNumeric() {
        if (this.mImsi == null) {
            return null;
        }
        if (this.mncLength != -1 && this.mncLength != 0) {
            return this.mImsi.substring(0, 3 + this.mncLength);
        }
        int mcc = Integer.parseInt(this.mImsi.substring(0, 3));
        return this.mImsi.substring(0, 3 + MccTable.smallestDigitsMccForMnc(mcc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handleMessage(Message msg) {
        isRecordLoadResponse = false;
        try {
            try {
                switch (msg.what) {
                    case 1: {
                        this.onRuimReady();
                        ** break;
                    }
                    case 2: {
                        this.onRadioOffOrNotAvailable();
                        ** break;
                    }
                    case 4: {
                        Log.d("CDMA", "Event EVENT_GET_DEVICE_IDENTITY_DONE Received");
                        ** break;
                    }
                    case 3: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception != null) {
                            Log.e("CDMA", "Exception querying IMSI, Exception:" + ar.exception);
                            ** break;
                        }
                        this.mImsi = (String)ar.result;
                        if (this.mImsi != null && (this.mImsi.length() < 6 || this.mImsi.length() > 15)) {
                            Log.e("CDMA", "invalid IMSI " + this.mImsi);
                            this.mImsi = null;
                        }
                        Log.d("CDMA", "IMSI: " + this.mImsi.substring(0, 6) + "xxxxxxxxx");
                        operatorNumeric = this.getRUIMOperatorNumeric();
                        if (operatorNumeric == null || operatorNumeric.length() > 6) ** break;
                        MccTable.updateMccMncConfiguration(this.phone, operatorNumeric);
                        ** break;
                    }
                    case 10: {
                        ar = (AsyncResult)msg.obj;
                        localTemp = (String[])ar.result;
                        if (ar.exception != null) ** break;
                        this.mMyMobileNumber = localTemp[0];
                        this.mMin2Min1 = localTemp[3];
                        this.mPrlVersion = localTemp[4];
                        Log.d("CDMA", "MDN: " + this.mMyMobileNumber + " MIN: " + this.mMin2Min1);
                        ** break;
                    }
                    case 5: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        data = (byte[])ar.result;
                        if (ar.exception != null) ** break;
                        this.iccid = IccUtils.bcdToString(data, 0, data.length);
                        Log.d("CDMA", "iccid: " + this.iccid);
                        ** break;
                    }
                    case 14: {
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception == null) ** break;
                        Log.i("CDMA", "RuimRecords update failed", ar.exception);
                        ** break;
                    }
                    case 18: 
                    case 19: 
                    case 21: 
                    case 22: {
                        Log.w("CDMA", "Event not supported: " + msg.what);
                        ** break;
                    }
                    case 17: {
                        Log.d("CDMA", "Event EVENT_GET_SST_DONE Received");
                        ** break;
                    }
                    case 31: {
                        isRecordLoadResponse = false;
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception != null) ** break;
                        this.handleRuimRefresh((int[])ar.result);
                    }
                }
            }
            catch (RuntimeException exc) {
                Log.w("CDMA", "Exception parsing RUIM record", exc);
                var8_13 = null;
                if (isRecordLoadResponse) {
                    this.onRecordLoaded();
                }
            }
lbl79:
            // 17 sources

            var8_12 = null;
            if (isRecordLoadResponse) {
                this.onRecordLoaded();
            }
        }
        catch (Throwable var7_15) {
            var8_14 = null;
            if (isRecordLoadResponse) {
                this.onRecordLoaded();
            }
            throw var7_15;
        }
    }

    protected void onRecordLoaded() {
        --this.recordsToLoad;
        if (this.recordsToLoad == 0 && this.recordsRequested) {
            this.onAllRecordsLoaded();
        } else if (this.recordsToLoad < 0) {
            Log.e(LOG_TAG, "RuimRecords: recordsToLoad <0, programmer error suspected");
            this.recordsToLoad = 0;
        }
    }

    protected void onAllRecordsLoaded() {
        Log.d(LOG_TAG, "RuimRecords: record load complete");
        String operator = this.getRUIMOperatorNumeric();
        SystemProperties.set("gsm.sim.operator.numeric", operator);
        if (this.mImsi != null) {
            SystemProperties.set("gsm.sim.operator.iso-country", MccTable.countryCodeForMcc(Integer.parseInt(this.mImsi.substring(0, 3))));
        }
        this.recordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        this.phone.mIccCard.broadcastIccStateChangedIntent("LOADED", null);
    }

    private void onRuimReady() {
        this.phone.mIccCard.broadcastIccStateChangedIntent("READY", null);
        this.fetchRuimRecords();
        this.phone.mCM.getCDMASubscription(this.obtainMessage(10));
    }

    private void fetchRuimRecords() {
        this.recordsRequested = true;
        Log.v(LOG_TAG, "RuimRecords:fetchRuimRecords " + this.recordsToLoad);
        this.phone.mCM.getIMSI(this.obtainMessage(3));
        ++this.recordsToLoad;
        this.phone.getIccFileHandler().loadEFTransparent(12258, this.obtainMessage(5));
        ++this.recordsToLoad;
    }

    public int getDisplayRule(String plmn) {
        return 0;
    }

    public void setVoiceMessageWaiting(int line, int countWaiting) {
        if (line != 1) {
            return;
        }
        if (countWaiting < 0) {
            countWaiting = -1;
        } else if (countWaiting > 255) {
            countWaiting = 255;
        }
        this.countVoiceMessages = countWaiting;
        ((CDMAPhone)this.phone).notifyMessageWaitingIndicator();
    }

    private void handleRuimRefresh(int[] result) {
        if (result == null || result.length == 0) {
            this.log("handleRuimRefresh without input");
            return;
        }
        switch (result[0]) {
            case 0: {
                this.log("handleRuimRefresh with SIM_REFRESH_FILE_UPDATED");
                this.adnCache.reset();
                this.fetchRuimRecords();
                break;
            }
            case 1: {
                this.log("handleRuimRefresh with SIM_REFRESH_INIT");
                this.fetchRuimRecords();
                break;
            }
            case 2: {
                this.log("handleRuimRefresh with SIM_REFRESH_RESET");
                this.phone.mCM.setRadioPower(false, null);
                break;
            }
            default: {
                this.log("handleRuimRefresh with unknown operation");
            }
        }
    }

    protected void log(String s) {
        Log.d(LOG_TAG, "[RuimRecords] " + s);
    }

    protected void loge(String s) {
        Log.e(LOG_TAG, "[RuimRecords] " + s);
    }
}

