/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import dalvik.system.DexPathList;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDexClassLoader
extends ClassLoader {
    private final String originalPath;
    private final DexPathList pathList;

    public BaseDexClassLoader(String dexPath, File optimizedDirectory, String libraryPath, ClassLoader parent) {
        super(parent);
        this.originalPath = dexPath;
        this.pathList = new DexPathList(this, dexPath, libraryPath, optimizedDirectory);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz = this.pathList.findClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    @Override
    protected URL findResource(String name) {
        return this.pathList.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        return this.pathList.findResources(name);
    }

    @Override
    public String findLibrary(String name) {
        return this.pathList.findLibrary(name);
    }

    @Override
    protected synchronized Package getPackage(String name) {
        if (name != null && !name.isEmpty()) {
            Package pack = super.getPackage(name);
            if (pack == null) {
                pack = this.definePackage(name, "Unknown", "0.0", "Unknown", "Unknown", "0.0", "Unknown", null);
            }
            return pack;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.originalPath + "]";
    }
}

