/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.annotations.NonNull;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
class AsmVisitor {
    private static final int TYPE_COUNT = 16;
    private final Map<String, List<Detector.ClassScanner>> mMethodNameToChecks = new HashMap<String, List<Detector.ClassScanner>>();
    private final Map<String, List<Detector.ClassScanner>> mMethodOwnerToChecks = new HashMap<String, List<Detector.ClassScanner>>();
    private final List<Detector> mFullClassChecks = new ArrayList<Detector>();
    private final List<? extends Detector> mAllDetectors;
    private List<Detector.ClassScanner>[] mNodeTypeDetectors;

    AsmVisitor(@NonNull LintClient lintClient, @NonNull List<? extends Detector> list) {
        this.mAllDetectors = list;
        for (Detector detector : list) {
            Object object;
            Object object2;
            Object object3;
            Detector.ClassScanner classScanner = (Detector.ClassScanner)((Object)detector);
            boolean bl = true;
            List<String> list2 = classScanner.getApplicableCallNames();
            if (list2 != null) {
                bl = false;
                object3 = list2.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    object = this.mMethodNameToChecks.get(object2);
                    if (object == null) {
                        object = new ArrayList();
                        this.mMethodNameToChecks.put((String)object2, (List<Detector.ClassScanner>)object);
                    }
                    object.add(classScanner);
                }
            }
            if ((object3 = classScanner.getApplicableCallOwners()) != null) {
                bl = false;
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    List<Detector.ClassScanner> list3 = this.mMethodOwnerToChecks.get(object);
                    if (list3 == null) {
                        list3 = new ArrayList<Detector.ClassScanner>();
                        this.mMethodOwnerToChecks.put((String)object, list3);
                    }
                    list3.add(classScanner);
                }
            }
            if ((object2 = classScanner.getApplicableAsmNodeTypes()) != null) {
                bl = false;
                for (Object object4 : object2) {
                    List<Detector.ClassScanner> list4;
                    if (object4 < 0 || object4 >= 16) {
                        lintClient.log(null, "Out of range node type %1$d from detector %2$s", (int)object4, classScanner);
                        continue;
                    }
                    if (this.mNodeTypeDetectors == null) {
                        this.mNodeTypeDetectors = new List[16];
                    }
                    if ((list4 = this.mNodeTypeDetectors[object4]) == null) {
                        this.mNodeTypeDetectors[object4] = list4 = new ArrayList<Detector.ClassScanner>();
                    }
                    list4.add(classScanner);
                }
            }
            if (!bl) continue;
            this.mFullClassChecks.add(detector);
        }
    }

    void runClassDetectors(ClassContext classContext) {
        Detector.ClassScanner classScanner;
        ClassNode classNode = classContext.getClassNode();
        for (Detector object : this.mAllDetectors) {
            object.beforeCheckFile(classContext);
        }
        for (Detector detector : this.mFullClassChecks) {
            classScanner = (Detector.ClassScanner)((Object)detector);
            classScanner.checkClass(classContext, classNode);
            detector.afterCheckFile(classContext);
        }
        if (!this.mMethodNameToChecks.isEmpty() || !this.mMethodOwnerToChecks.isEmpty() || this.mNodeTypeDetectors != null && this.mNodeTypeDetectors.length > 0) {
            Iterator<? extends Detector> iterator = classNode.methods;
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                classScanner = iterator2.next();
                MethodNode methodNode = (MethodNode)classScanner;
                InsnList insnList = methodNode.instructions;
                int n = insnList.size();
                for (int i = 0; i < n; ++i) {
                    List<Detector.ClassScanner> list;
                    Object object;
                    Object object2;
                    AbstractInsnNode abstractInsnNode = insnList.get(i);
                    int n2 = abstractInsnNode.getType();
                    if (n2 == 5) {
                        Object object3;
                        object2 = (MethodInsnNode)abstractInsnNode;
                        object = ((MethodInsnNode)object2).owner;
                        list = this.mMethodOwnerToChecks.get(object);
                        if (list != null) {
                            object3 = list.iterator();
                            while (object3.hasNext()) {
                                Detector.ClassScanner classScanner2 = (Detector.ClassScanner)object3.next();
                                classScanner2.checkCall(classContext, classNode, methodNode, (MethodInsnNode)object2);
                            }
                        }
                        if ((list = this.mMethodNameToChecks.get(object3 = ((MethodInsnNode)object2).name)) != null) {
                            for (Detector.ClassScanner classScanner3 : list) {
                                classScanner3.checkCall(classContext, classNode, methodNode, (MethodInsnNode)object2);
                            }
                        }
                    }
                    if (this.mNodeTypeDetectors == null || n2 >= this.mNodeTypeDetectors.length || (object2 = this.mNodeTypeDetectors[n2]) == null) continue;
                    object = object2.iterator();
                    while (object.hasNext()) {
                        list = (Detector.ClassScanner)object.next();
                        list.checkInstruction(classContext, classNode, methodNode, abstractInsnNode);
                    }
                }
            }
        }
        for (Detector detector : this.mAllDetectors) {
            detector.afterCheckFile(classContext);
        }
    }
}

