/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Issue
implements Comparable<Issue> {
    private static final String HTTP_PREFIX = "http://";
    private final String mId;
    private final String mDescription;
    private final String mExplanation;
    private final Category mCategory;
    private final int mPriority;
    private final Severity mSeverity;
    private String mMoreInfoUrl;
    private boolean mEnabledByDefault = true;
    private final EnumSet<Scope> mScope;
    private List<EnumSet<Scope>> mAnalysisScopes;
    private final Class<? extends Detector> mClass;

    private Issue(@NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull Category category, int n, @NonNull Severity severity, @NonNull Class<? extends Detector> clazz, @NonNull EnumSet<Scope> enumSet) {
        this.mId = string;
        this.mDescription = string2;
        this.mExplanation = string3;
        this.mCategory = category;
        this.mPriority = n;
        this.mSeverity = severity;
        this.mClass = clazz;
        this.mScope = enumSet;
    }

    @NonNull
    public static Issue create(@NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull Category category, int n, @NonNull Severity severity, @NonNull Class<? extends Detector> clazz, @NonNull EnumSet<Scope> enumSet) {
        return new Issue(string, string2, string3, category, n, severity, clazz, enumSet);
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public String getDescription() {
        return this.mDescription;
    }

    @NonNull
    public String getExplanation() {
        return this.mExplanation;
    }

    @NonNull
    public String getExplanationAsHtml() {
        return Issue.convertMarkup(this.mExplanation, true);
    }

    @NonNull
    public String getExplanationAsSimpleText() {
        return Issue.convertMarkup(this.mExplanation, false);
    }

    @NonNull
    public Category getCategory() {
        return this.mCategory;
    }

    public int getPriority() {
        return this.mPriority;
    }

    @NonNull
    public Severity getDefaultSeverity() {
        return this.mSeverity;
    }

    @Nullable
    public String getMoreInfo() {
        return this.mMoreInfoUrl;
    }

    public boolean isEnabledByDefault() {
        return this.mEnabledByDefault;
    }

    @NonNull
    public EnumSet<Scope> getScope() {
        return this.mScope;
    }

    @Override
    public int compareTo(Issue issue) {
        return this.getId().compareTo(issue.getId());
    }

    @NonNull
    public Issue setMoreInfo(@NonNull String string) {
        this.mMoreInfoUrl = string;
        return this;
    }

    @NonNull
    public Issue setEnabledByDefault(boolean bl) {
        this.mEnabledByDefault = bl;
        return this;
    }

    @Nullable
    public Collection<EnumSet<Scope>> getAnalysisScopes() {
        return this.mAnalysisScopes;
    }

    @NonNull
    public Issue setAnalysisScopes(@Nullable List<EnumSet<Scope>> list) {
        this.mAnalysisScopes = list;
        return this;
    }

    public boolean isAdequate(@NonNull EnumSet<Scope> enumSet) {
        if (enumSet.containsAll(this.mScope)) {
            return true;
        }
        if (this.mAnalysisScopes != null) {
            for (EnumSet<Scope> enumSet2 : this.mAnalysisScopes) {
                if (!this.mScope.containsAll(enumSet2)) continue;
                return true;
            }
        }
        return this == IssueRegistry.LINT_ERROR || this == IssueRegistry.PARSER_ERROR;
    }

    public Issue addAnalysisScope(@Nullable EnumSet<Scope> enumSet) {
        if (this.mAnalysisScopes == null) {
            this.mAnalysisScopes = new ArrayList<EnumSet<Scope>>(2);
        }
        this.mAnalysisScopes.add(enumSet);
        return this;
    }

    @NonNull
    public Class<? extends Detector> getDetectorClass() {
        return this.mClass;
    }

    public String toString() {
        return this.mId;
    }

    @NonNull
    public static String convertMarkup(@NonNull String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(3 * string.length() / 2);
        char c = '\u0000';
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            int n3;
            char c2 = string.charAt(i);
            if (c2 == '*' || c2 == '`' && i < n2 - 1) {
                if (!(Character.isLetterOrDigit(c) || Character.isWhitespace(string.charAt(i + 1)) || (n3 = string.indexOf(c2, i + 1)) == -1 || n3 != n2 - 1 && Character.isLetter(string.charAt(n3 + 1)))) {
                    if (i > n) {
                        Issue.appendEscapedText(stringBuilder, string, bl, n, i);
                    }
                    if (bl) {
                        String string2 = c2 == '*' ? "b" : "code";
                        stringBuilder.append('<').append(string2).append('>');
                        Issue.appendEscapedText(stringBuilder, string, bl, i + 1, n3);
                        stringBuilder.append('<').append('/').append(string2).append('>');
                    } else {
                        Issue.appendEscapedText(stringBuilder, string, bl, i + 1, n3);
                    }
                    n = n3 + 1;
                    i = n - 1;
                }
            } else if (bl && c2 == 'h' && i < n2 - 1 && string.charAt(i + 1) == 't' && string.startsWith(HTTP_PREFIX, i) && !Character.isLetterOrDigit(c)) {
                char c3;
                for (n3 = i + HTTP_PREFIX.length(); n3 < n2 && !Character.isWhitespace(c3 = string.charAt(n3)); ++n3) {
                }
                char c4 = string.charAt(n3 - 1);
                if (c4 == '.' || c4 == ')' || c4 == '!') {
                    --n3;
                }
                if (n3 > i + HTTP_PREFIX.length()) {
                    if (i > n) {
                        Issue.appendEscapedText(stringBuilder, string, bl, n, i);
                    }
                    String string3 = string.substring(i, n3);
                    stringBuilder.append("<a href=\"");
                    stringBuilder.append(string3);
                    stringBuilder.append('\"').append('>');
                    stringBuilder.append(string3);
                    stringBuilder.append("</a>");
                    n = n3;
                    i = n - 1;
                }
            }
            c = c2;
        }
        if (n < n2) {
            Issue.appendEscapedText(stringBuilder, string, bl, n, n2);
        }
        return stringBuilder.toString();
    }

    private static void appendEscapedText(StringBuilder stringBuilder, String string, boolean bl, int n, int n2) {
        if (bl) {
            for (int i = n; i < n2; ++i) {
                char c = string.charAt(i);
                if (c == '<') {
                    stringBuilder.append("&lt;");
                    continue;
                }
                if (c == '&') {
                    stringBuilder.append("&amp;");
                    continue;
                }
                if (c == '\n') {
                    stringBuilder.append("<br/>\n");
                    continue;
                }
                if (c > '\u00ff') {
                    stringBuilder.append("&#");
                    stringBuilder.append(Integer.toString(c));
                    stringBuilder.append(';');
                    continue;
                }
                stringBuilder.append(c);
            }
        } else {
            for (int i = n; i < n2; ++i) {
                char c = string.charAt(i);
                stringBuilder.append(c);
            }
        }
    }
}

