#include "dimension.h"
#include "printer.h"
#include "parser.h"
#include "gfanapplication.h"

class KrullDimensionApplication : public GFanApplication
{
public:
  KrullDimensionApplication()
  {
    registerOptions();
  }
  char *name()
  {
    return "_krulldimension";
  }
  int main()
  {
    FileParser P(Stdin);
    PolynomialSet g=P.parsePolynomialSetWithRing();
    AsciiPrinter(Stdout).printInteger(krullDimension(g));
    AsciiPrinter(Stdout).printNewLine();
    return 0;
  }
  const char *helpText()
  {
    return "Takes a Groebner basis of an ideal $I$ and computes the Krull dimension of R/I where R is the polynomial ring.\n"
;
  }
};

static KrullDimensionApplication theApplication;
