#ifndef POLYNOMIALRING_H_INCLUDED
#define POLYNOMIALRING_H_INCLUDED

#include <string>
#include <vector>

#include "field.h"

using namespace std;
class PolynomialRingImplementation
{
 public:
  int refCount;
  Field theField;
  int n;
  vector<string> variableNames;
  PolynomialRingImplementation(Field const &f, int numberOfVariables, vector<string> const &variableNames_):
    theField(f),
    n(numberOfVariables),
    refCount(0),
    variableNames(variableNames_)
    {
    }
};


class PolynomialRing
{
  PolynomialRingImplementation *implementingObject;
 public:
  inline int getNumberOfVariables()const{return implementingObject->n;}
  inline Field const&getField()const{return implementingObject->theField;}
  PolynomialRing withVariablesAppended(string variableNames)const;
  int variableIndex(string const &name)const;//returns -1 if no match
  string const &getVariableName(int i)const;


  //construtors
  PolynomialRing(Field const &f, int numberOfVariables);
  PolynomialRing(Field const &f, vector<string> const &variables);
  ~PolynomialRing();
  PolynomialRing(PolynomialRing const &a);//copy constructor
  PolynomialRing& operator=(const PolynomialRing& a);//assignment
};


#endif
