#!/usr/bin/env sage
##################################################################
#
# example.sage -- an example SAGE script.
# 
# Example SAGE script.  You can use this example script in many
# different ways.
#
#  (*) sage example.sg
#  (*) ./example.sg  (assuming the SAGE directory is in your path)
#  (*) From within sage type
#                  load 'example.sg'
#  (*) From within sage type
#                  attach 'example.sg'
#      With attach, when you enter a blank line in SAGE, if 
#      example.sg has changed it is reloaded.
#
# As a tutorial and test of your install, you might want to
# try all these now. 
#
##################################################################
print "This is a simple SAGE example script."

print 5^10

print factor(2005)

def foo(n):
    return n^2

print [foo(i) for i in range(10)]

E = EllipticCurve('37a')

print E.gens()


def cond(E):
    """
    Return the conductor of an elliptic curve.
    
    EXAMPLES:
        sage: cond(EllipticCurve('37a'))
        37
        sage: cond(EllipticCurve([1, -1, 1, -29372, -1932937]))
        3006
    """
    return E.conductor()

print cond(E)

print "The following should be true:"
print int(gp('ellglobalred(ellinit([1, -1, 1, -29372, -1932937],0))[1]')) == 3006 

