/*
 * Decompiled with CFR 0.152.
 */
package jv.anim;

import java.util.Enumeration;
import java.util.Vector;
import jv.anim.PsAnimation;
import jv.anim.PsKey;
import jv.anim.PsKeyframeIf;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.object.PsDebug;
import jv.project.PgGeometry;

public class PsKeyframe
extends PgGeometry
implements PsKeyframeIf,
PsTimeListenerIf {
    protected double m_currentTime;
    protected PgGeometry m_inter;
    protected Vector m_list = new Vector();
    protected String m_className;
    protected boolean m_bShowKeysOnly;
    protected PsAnimation m_anim = null;
    private static /* synthetic */ Class class$jv$anim$PsKeyframe;

    public PgGeometry getObject(double time) {
        PsKey key = this.getKey(time);
        if (key == null) {
            return null;
        }
        return key.getObject();
    }

    public double getTimeOfLastKey() {
        return this.getKey(this.getNumOfKeys() - 1).getTime();
    }

    public int addKey(PgGeometry object, double time) {
        String objClassName = object.getClass().getName();
        if (this.getNumOfKeys() == 0) {
            if (this.m_inter == null || !this.m_inter.getClass().equals(objClassName)) {
                this.setDynamic((PgGeometry)object.clone());
            }
            if (this.m_inter == null) {
                PsDebug.warning("could not allocate class = " + objClassName);
                return -1;
            }
            this.m_inter.setName("Interpol of " + this.getName());
            PsKey key = new PsKey(time, object);
            this.m_list.addElement(key);
            this.m_className = objClassName;
            return 0;
        }
        if (!this.m_className.equals(objClassName)) {
            PsDebug.warning("try to add wrong class = " + objClassName + "\n\t current class type = " + this.m_className);
            return -1;
        }
        PsKey prevKey = this.getKey(time);
        if (prevKey != null && Math.abs(prevKey.getTime() - time) < 1.0E-10) {
            prevKey.setObject(object);
            prevKey.setTime(time);
        }
        PsKey key = new PsKey(time, object);
        if (prevKey == null) {
            this.m_list.insertElementAt(key, 0);
            return 0;
        }
        PsKey nextKey = this.getNextKey(time);
        if (nextKey == null) {
            this.m_list.addElement(key);
            return this.getNumOfKeys() - 1;
        }
        int ind = this.m_list.indexOf(nextKey);
        this.m_list.insertElementAt(key, ind);
        return ind;
    }

    public int getNumOfKeys() {
        if (this.m_list == null) {
            return 0;
        }
        return this.m_list.size();
    }

    public PsKeyframe() {
        if (this.getClass() == (class$jv$anim$PsKeyframe != null ? class$jv$anim$PsKeyframe : (class$jv$anim$PsKeyframe = PsKeyframe.class$("jv.anim.PsKeyframe")))) {
            this.init();
        }
    }

    public boolean isEnabledKeysOnly() {
        return this.m_bShowKeysOnly;
    }

    public boolean setTime(PsTimeEvent timeEvent) {
        double time = timeEvent.getTime();
        this.setTime(time);
        if (this.m_inter != null) {
            this.m_inter.update(this.m_inter);
        }
        return true;
    }

    public boolean setTime(double time) {
        if (this.getNumOfKeys() == 0) {
            PsDebug.notify("empty list of keys");
            return false;
        }
        if (Math.abs(this.m_currentTime - time) < 1.0E-10) {
            return true;
        }
        PsKey prev = this.getKey(time);
        if (prev != null && Math.abs(prev.getTime() - time) < 1.0E-10) {
            this.m_inter.copy(prev.getObject());
            this.m_currentTime = prev.getTime();
            return true;
        }
        PsKey next = this.getNextKey(time);
        if (prev == null) {
            this.m_inter.copy(next.getObject());
            this.m_currentTime = next.getTime();
            return true;
        }
        if (next == null) {
            this.m_inter.copy(prev.getObject());
            this.m_currentTime = prev.getTime();
            return true;
        }
        double dist = next.getTime() - prev.getTime();
        double tp = (next.getTime() - time) / dist;
        double tn = (time - prev.getTime()) / dist;
        if (!this.m_bShowKeysOnly) {
            this.m_inter.blend(tp, prev.getObject(), tn, next.getObject());
            this.m_currentTime = time;
        } else {
            int nextIndex = this.getIndexOfKey(next);
            if (tp * (double)(this.getNumOfKeys() - nextIndex) >= tn * (double)nextIndex) {
                this.m_inter.copy(prev.getObject());
                this.m_currentTime = prev.getTime();
            } else {
                this.m_inter.copy(next.getObject());
                this.m_currentTime = next.getTime();
            }
        }
        return true;
    }

    public PsAnimation getAnimation() {
        return this.m_anim;
    }

    public double getTimeOfFirstKey() {
        return this.getKey(0).getTime();
    }

    public void setAnimation(PsAnimation anAnimation) {
        this.m_anim = anAnimation;
    }

    protected PsKey getNextKey(double time) {
        Enumeration e = this.m_list.elements();
        while (e.hasMoreElements()) {
            PsKey key = (PsKey)e.nextElement();
            if (!(key.getTime() > time + 1.0E-10)) continue;
            return key;
        }
        return null;
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (this.m_inter != null && event == this.m_inter) {
            return true;
        }
        return super.update(event);
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public boolean hasAnimation() {
        return this.m_anim != null;
    }

    public void setName(String name) {
        super.setName(name);
        if (this.m_inter != null) {
            this.m_inter.setName("Interpol of " + name);
        }
    }

    public PgGeometry getNextObject(double time) {
        PsKey key = this.getNextKey(time);
        if (key == null) {
            return null;
        }
        return key.getObject();
    }

    protected int getIndexOfKey(PsKey key) {
        return this.m_list.indexOf(key);
    }

    public PgGeometry getDynamic() {
        return this.m_inter;
    }

    public void setDynamic(PgGeometry geom) {
        this.m_inter = geom;
        this.m_inter.setParent(this);
    }

    public double getTimeOfPreviousKey() {
        if (Math.abs(this.getKey(this.m_currentTime).getTime() - this.m_currentTime) < 1.0E-10 && this.getIndexOfKey(this.getKey(this.m_currentTime)) != 0) {
            return this.getKey(this.getIndexOfKey(this.getKey(this.m_currentTime)) - 1).getTime();
        }
        return this.getKey(this.m_currentTime).getTime();
    }

    public double getTimeOfNextKey() {
        if (this.getNextKey(this.m_currentTime) != null) {
            return this.getNextKey(this.m_currentTime).getTime();
        }
        return this.getTimeOfLastKey();
    }

    public void init() {
        super.init();
        this.m_list.setSize(0);
        this.m_currentTime = Double.POSITIVE_INFINITY;
        this.m_inter = null;
        this.m_className = null;
        this.m_bShowKeysOnly = false;
    }

    public void removeKey(double time) {
        PsKey key = this.getKey(time);
        if (Math.abs(key.getTime() - time) > 1.0E-10) {
            PsDebug.notify("no matching key found.");
            return;
        }
        this.m_list.removeElement(key);
    }

    public void removeKey(int ind) {
        this.m_list.removeElementAt(ind);
    }

    protected PsKey getKey(double time) {
        PsKey lastKey = null;
        Enumeration e = this.m_list.elements();
        while (e.hasMoreElements()) {
            PsKey key = (PsKey)e.nextElement();
            if (Math.abs(key.getTime() - time) < 1.0E-10) {
                return key;
            }
            if (key.getTime() < time) {
                lastKey = key;
                continue;
            }
            return lastKey;
        }
        return lastKey;
    }

    public void setEnabledKeysOnly(boolean flag) {
        this.m_bShowKeysOnly = flag;
    }

    protected PsKey getKey(int ind) {
        return (PsKey)this.m_list.elementAt(ind);
    }

    public PgGeometry getObject(int ind) {
        PsKey key = this.getKey(ind);
        if (key == null) {
            return null;
        }
        return key.getObject();
    }
}

