/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;
import jv.geom.PgPolygon;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuVectorGeom;

public class PgPointSet
extends PgGeometry {
    protected boolean m_bDefaultLabelEnabled;
    protected boolean m_bShowIndices;
    protected boolean m_bShowVertexLabels;
    protected int m_numVertices;
    protected int m_maxNumVertices;
    protected int m_dimOfColors;
    protected PgTexture m_texture;
    protected int m_dimOfTextures;
    protected boolean m_bShowVertexTexture;
    protected PdVector[] m_vertexTexture;
    protected PuDouble m_transparency;
    protected boolean m_bShowTransparency;
    protected PdVector[] m_vertex;
    protected Color[] m_vertexColor;
    protected PdVector[] m_vertexNormal;
    protected int m_dimOfVectors;
    protected int m_numVectorFields;
    protected Vector m_vectorField;
    protected boolean m_bShowVectorFields;
    protected boolean m_bShowVectorArrows;
    protected PdColor m_globalVectorColor;
    protected PuDouble m_globalVectorLength;
    protected PuDouble m_globalVectorSize;
    protected boolean m_bShowVectorColors;
    protected boolean m_bShowVertices;
    protected boolean m_bShowTaggedVertices;
    protected PuInteger m_globalVertexSize;
    protected boolean m_bShowVertexColors;
    protected PdColor m_globalVertexColor;
    protected PdColor m_globalVertexTagColor;
    protected boolean m_bShowVertexNormals;
    protected boolean m_bShowVertexNormalArrow;
    protected PuDouble m_globalVertexNormalLength;
    protected PuDouble m_globalVertexNormalSize;
    protected PdColor m_globalVertexNormalColor;
    private static /* synthetic */ Class class$jv$geom$PgPointSet;

    public Image getTextureImage() {
        if (this.m_texture == null) {
            return null;
        }
        return this.m_texture.getImage();
    }

    public void setTextureImage(Image image) {
        if (image == null) {
            PsDebug.warning("missing texture image");
            return;
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
        this.m_texture.setImage(image);
    }

    public void setState(int aKey, boolean aState) {
        switch (aKey) {
            case 50: {
                this.showVertices(aState);
                break;
            }
            default: {
                super.setState(aKey, aState);
            }
        }
    }

    public void computePlane(int numULines, int numVLines, double uMin, double vMin, double uMax, double vMax) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(numULines * numVLines);
        double uFac = (uMax - uMin) / (-1.0 + (double)numULines);
        double vFac = (vMax - vMin) / (-1.0 + (double)numVLines);
        int ind = 0;
        int i = 0;
        while (i < numULines) {
            double u = uFac * (double)i;
            int j = 0;
            while (j < numVLines) {
                double v = vFac * (double)j;
                if (this.m_dim > 2) {
                    this.m_vertex[ind].setConstant(0.0);
                }
                this.m_vertex[ind].m_data[0] = uMin + u;
                this.m_vertex[ind].m_data[1] = vMin + v;
                ++ind;
                ++j;
            }
            ++i;
        }
        if (this.m_dim == 3) {
            this.assureVertexNormals();
            PdVector.setConstant(this.m_vertexNormal, new PdVector(0.0, 0.0, 1.0));
        } else {
            this.setVertexNormals(null);
        }
    }

    public PvPickEvent intersectionWithLine(PdVector rayBase, PdVector rayDir) {
        int vertexInd = -1;
        double dist = Double.MAX_VALUE;
        double minDist = Double.MAX_VALUE;
        PdVector currVertex = new PdVector(3);
        rayDir.normalize();
        int i = 0;
        while (i < this.m_numVertices) {
            if (this.m_dim != 3) {
                currVertex.copyArray(this.m_vertex[i]);
            } else {
                currVertex = this.m_vertex[i];
            }
            dist = PuVectorGeom.distOfPointToLine(currVertex, rayBase, rayDir);
            if (!(dist >= minDist) && !(dist > 0.1)) {
                minDist = dist;
                vertexInd = i;
            }
            ++i;
        }
        if (vertexInd == -1) {
            return null;
        }
        PvPickEvent point = new PvPickEvent(this.m_dim);
        point.setVertex(this.m_vertex[vertexInd]);
        point.setDistance(minDist);
        point.setVertexInd(vertexInd);
        point.setViewBase(rayBase);
        point.setViewDir(rayDir);
        return point;
    }

    public boolean makeVertexNormals() {
        return false;
    }

    public boolean hasVertexNormals() {
        return this.m_vertexNormal != null && this.m_vertexNormal.length == this.m_maxNumVertices;
    }

    public Color getGlobalVectorColor() {
        return this.m_globalVectorColor.getColor();
    }

    public void setGlobalVectorColor(Color color) {
        this.m_globalVectorColor.setColor(color);
    }

    public void computeSphere(int numULines, int numVLines, double radius) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(numULines * numVLines);
        this.assureVertexNormals();
        double uFac = 0.0;
        double vFac = 0.0;
        if (numULines > 1) {
            uFac = Math.PI * 2 / (-1.0 + (double)numULines);
        }
        if (numVLines > 1) {
            vFac = Math.PI / (-1.0 + (double)numVLines);
        }
        int ind = 0;
        int i = 0;
        while (i < numULines) {
            double u = uFac * (double)i;
            double su = Math.sin(u);
            double cu = Math.cos(u);
            int j = 0;
            while (j < numVLines) {
                double v = -1.5707963267948966 + vFac * (double)j;
                double sv = Math.sin(v);
                double cv = Math.cos(v);
                this.m_vertex[ind].m_data[0] = radius * cu * cv;
                this.m_vertex[ind].m_data[1] = radius * su * cv;
                this.m_vertex[ind].m_data[2] = radius * sv;
                this.m_vertexNormal[ind].m_data[0] = cu * cv;
                this.m_vertexNormal[ind].m_data[1] = su * cv;
                this.m_vertexNormal[ind].m_data[2] = sv;
                ++ind;
                ++j;
            }
            ++i;
        }
    }

    public boolean hasTagVertex(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex >= this.m_numVertices) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        return this.m_vertex[anIndex].hasTag(aTag);
    }

    public int addVertex(PdVector aVertex) {
        this.setVertex(this.m_numVertices, aVertex);
        return this.m_numVertices - 1;
    }

    public Object clone() {
        PgPointSet clone = (PgPointSet)super.clone();
        if (clone == null) {
            return null;
        }
        clone.m_globalVertexSize = (PuInteger)this.m_globalVertexSize.clone();
        clone.m_globalVertexColor = (PdColor)this.m_globalVertexColor.clone();
        clone.m_globalVertexTagColor = (PdColor)this.m_globalVertexTagColor.clone();
        clone.m_globalVertexSize.setParent(clone);
        clone.m_globalVertexColor.setParent(clone);
        clone.m_globalVertexTagColor.setParent(clone);
        clone.m_globalVertexNormalLength = (PuDouble)this.m_globalVertexNormalLength.clone();
        clone.m_globalVertexNormalSize = (PuDouble)this.m_globalVertexNormalSize.clone();
        clone.m_globalVertexNormalColor = (PdColor)this.m_globalVertexNormalColor.clone();
        clone.m_globalVertexNormalLength.setParent(clone);
        clone.m_globalVertexNormalSize.setParent(clone);
        clone.m_globalVertexNormalColor.setParent(clone);
        clone.m_globalVectorSize = (PuDouble)this.m_globalVectorSize.clone();
        clone.m_globalVectorLength = (PuDouble)this.m_globalVectorLength.clone();
        clone.m_globalVectorColor = (PdColor)this.m_globalVectorColor.clone();
        clone.m_globalVectorSize.setParent(clone);
        clone.m_globalVectorLength.setParent(clone);
        clone.m_globalVectorColor.setParent(clone);
        clone.m_transparency = (PuDouble)this.m_transparency.clone();
        if (this.m_texture != null) {
            clone.m_texture = (PgTexture)this.m_texture.clone();
        }
        if (this.m_vertexTexture != null) {
            clone.m_vertexTexture = (PdVector[])P_Vector.clone(this.m_vertexTexture);
        }
        if (this.m_vertex != null) {
            clone.m_vertex = (PdVector[])P_Vector.clone(this.m_vertex);
        }
        if (this.m_vertexColor != null) {
            clone.m_vertexColor = (Color[])this.m_vertexColor.clone();
        }
        if (this.m_vertexNormal != null) {
            clone.m_vertexNormal = (PdVector[])P_Vector.clone(this.m_vertexNormal);
        }
        if (this.m_vectorField != null) {
            clone.m_vectorField = null;
            clone.m_numVectorFields = 0;
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField vf = (PgVectorField)enumeration.nextElement();
                if (vf != null) {
                    PgVectorField newVf = (PgVectorField)vf.clone();
                    clone.addVectorField(newVf);
                    newVf.setGeometry(clone);
                    continue;
                }
                PsDebug.warning("missing vector field encountered during cloneing.");
            }
        }
        return clone;
    }

    public int addVectorField(PgVectorField aVectorField) {
        if (aVectorField == null) {
            PsDebug.warning("missing argument");
            return -1;
        }
        if (this.m_vectorField == null) {
            this.m_vectorField = new Vector();
            this.m_numVectorFields = 0;
        }
        this.m_bShowVectorFields = true;
        if (this.m_vectorField.contains(aVectorField)) {
            return this.m_vectorField.indexOf(aVectorField);
        }
        this.m_vectorField.addElement(aVectorField);
        return this.m_numVectorFields++;
    }

    public final int getNumVertices() {
        return this.m_numVertices;
    }

    public boolean isShowingTaggedVertices() {
        return this.m_bShowTaggedVertices;
    }

    public void showTaggedVertices(boolean flag) {
        this.m_bShowTaggedVertices = flag;
    }

    public void setNumVertices(int aNumVertices) {
        if (aNumVertices > this.m_maxNumVertices) {
            this.setMaxNumVertices(aNumVertices);
        }
        this.m_numVertices = aNumVertices;
    }

    public void setDefaultLabelEnabled(boolean flag) {
        this.m_bDefaultLabelEnabled = flag;
    }

    public PdVector[] getAmbientBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] bndBox = super.getAmbientBounds();
        PdVector.min(bndBox[0], this.m_vertex, this.m_numVertices);
        PdVector.max(bndBox[1], this.m_vertex, this.m_numVertices);
        return bndBox;
    }

    public void computeSnail(int numULines, int numVLines, double numWindings) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(numULines * numVLines);
        double uFac = 0.0;
        double vFac = 0.0;
        if (numULines > 1) {
            uFac = (1.0 + numWindings * Math.PI) / (-1.0 + (double)numULines);
        }
        if (numVLines > 1) {
            vFac = Math.PI / (-1.0 + (double)numVLines);
        }
        int ind = 0;
        int i = 0;
        while (i < numULines) {
            double u = 2.141592653589793 + uFac * (double)i;
            double su = Math.sin(u);
            double cu = Math.cos(u);
            int j = 0;
            while (j < numVLines) {
                double v = vFac * (double)j;
                double sv = Math.sin(v);
                double cv = Math.cos(v);
                double r = Math.exp(u * Math.log(1.3)) * sv;
                this.m_vertex[ind].m_data[0] = r * cu * sv;
                this.m_vertex[ind].m_data[1] = r * su * sv;
                this.m_vertex[ind].m_data[2] = r * cv;
                ++ind;
                ++j;
            }
            ++i;
        }
    }

    public PgGeometry reflect(PdMatrix mat, boolean bOrient, boolean bVector) {
        if (mat == null || mat.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + mat);
            return null;
        }
        PgPointSet reflGeom = (PgPointSet)super.reflect(mat, bOrient, bVector);
        PdVector[] vertex = this.getVertices();
        PdVector[] reflVertex = reflGeom.getVertices();
        int i = 0;
        while (i < this.m_numVertices) {
            reflVertex[i].leftMultAffin(mat, vertex[i], true);
            ++i;
        }
        if (this.hasVertexNormals()) {
            PdVector[] normal = this.getVertexNormals();
            PdVector[] reflNormal = reflGeom.getVertexNormals();
            int i2 = 0;
            while (i2 < this.m_numVertices) {
                reflNormal[i2].leftMultAffin(mat, normal[i2], false);
                if (!bVector) {
                    reflNormal[i2].multScalar(-1.0);
                }
                reflNormal[i2].normalize();
                ++i2;
            }
        }
        return reflGeom;
    }

    public boolean hasVertexTextures() {
        return this.m_vertexTexture != null && this.m_vertexTexture.length == this.m_maxNumVertices;
    }

    public Color[] getVertexColors() {
        return this.m_vertexColor;
    }

    public void init() {
        super.init();
        this.m_dimOfColors = 3;
        this.m_vertexColor = null;
        this.m_bShowVertexColors = false;
        this.m_vertexNormal = null;
        this.m_vertexTexture = null;
        this.m_texture = null;
        this.m_bDefaultLabelEnabled = true;
        this.m_bShowIndices = false;
        this.m_bShowVertexLabels = false;
        this.setMaxNumVertices(0);
        this.m_bShowVertices = true;
        this.m_bShowTaggedVertices = true;
        this.m_globalVertexSize.setDefBounds(0, 50, 1, 5);
        this.m_globalVertexSize.setDefValue(2);
        this.m_globalVertexSize.init();
        this.m_globalVertexColor.setColor(Color.red);
        this.m_globalVertexTagColor.setColor(Color.magenta);
        this.m_bShowVertexNormals = false;
        this.m_bShowVertexNormalArrow = false;
        this.m_globalVertexNormalSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalVertexNormalSize.setDefValue(1.0);
        this.m_globalVertexNormalSize.init();
        this.m_globalVertexNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalVertexNormalLength.setDefValue(0.5);
        this.m_globalVertexNormalLength.init();
        this.m_globalVertexNormalColor.setColor(Color.yellow);
        this.m_transparency.setDefBounds(0.0, 1.0, 0.01, 0.05);
        this.m_transparency.setDefValue(0.0);
        this.m_transparency.init();
        this.m_bShowTransparency = false;
        this.m_numVectorFields = 0;
        this.m_vectorField = null;
        this.m_bShowVectorFields = false;
        this.m_bShowVectorArrows = false;
        this.m_globalVectorSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalVectorSize.setDefValue(1.0);
        this.m_globalVectorSize.init();
        this.m_globalVectorLength.setDefValue(1.0);
        this.m_globalVectorLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalVectorLength.init();
        this.m_globalVectorColor.setColor(Color.yellow);
        this.m_bShowVertexTexture = false;
        this.m_dimOfTextures = 2;
    }

    public boolean isShowingVertexColors() {
        return this.m_bShowVertexColors;
    }

    public void showVertexColors(boolean flag) {
        this.m_bShowVertexColors = flag;
    }

    public int getDimOfColors() {
        return this.m_dimOfColors;
    }

    public void setDimOfColors(int aSize) {
        if (aSize < 0 || aSize == this.m_dim) {
            return;
        }
        if (this.m_dimOfColors == aSize) {
            return;
        }
        this.m_dimOfColors = aSize;
    }

    public int getDimOfVectors() {
        return this.m_dimOfVectors;
    }

    public void setDimOfVectors(int aSize) {
        if (aSize < 0 || aSize == this.m_dim) {
            return;
        }
        this.m_dimOfVectors = aSize;
        if (this.m_vertexNormal != null) {
            int i = 0;
            while (i < this.m_maxNumVertices) {
                this.m_vertexNormal[i].setSize(aSize);
                ++i;
            }
        }
    }

    public void assureVertexColors() {
        if (this.m_vertexColor == null || this.m_vertexColor.length != this.m_maxNumVertices) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, this.m_maxNumVertices);
        }
    }

    public void setVertexColors(Color[] aVertexColorList) {
        if (aVertexColorList == null) {
            this.m_vertexColor = null;
            return;
        }
        if (aVertexColorList.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexColors();
        PdColor.copy(this.m_vertexColor, 0, aVertexColorList, 0, this.m_numVertices);
    }

    public boolean isShowingVertexTexture() {
        return this.m_bShowVertexTexture;
    }

    public PgTexture getTexture() {
        return this.m_texture;
    }

    public void setTexture(PgTexture texture) {
        if (texture == null) {
            this.m_texture = null;
            return;
        }
        if (this.m_texture == null) {
            this.m_texture = new PgTexture();
            this.m_texture.setName("Texture of " + this.getName());
            this.m_texture.setParent(this);
        }
        this.m_texture.copy(texture);
    }

    public void showVertexTexture(boolean flag) {
        this.m_bShowVertexTexture = flag;
    }

    public double getGlobalVectorSize() {
        return this.m_globalVectorSize.getValue();
    }

    public void setGlobalVectorSize(double size) {
        this.m_globalVectorSize.setValue(size);
    }

    public boolean isShowingVectorArrow() {
        return this.m_bShowVectorArrows;
    }

    public void showVectorFields(boolean flag) {
        this.m_bShowVectorFields = flag;
    }

    public void showVectorArrow(boolean flag) {
        this.m_bShowVectorArrows = flag;
    }

    public void removeAllVectorFields() {
        if (this.m_vectorField == null) {
            return;
        }
        this.m_vectorField.removeAllElements();
        this.m_vectorField = null;
        this.m_numVectorFields = 0;
        this.m_bShowVectorFields = false;
    }

    public boolean isDefaultLabelEnabled() {
        return this.m_bDefaultLabelEnabled;
    }

    public double getGlobalVertexNormalLength() {
        return this.m_globalVertexNormalLength.getValue();
    }

    public void setGlobalVertexNormalLength(double length) {
        this.m_globalVertexNormalLength.setValue(length);
    }

    public boolean makeColorFromVectorLength() {
        PgVectorField vf = this.getVectorField(0);
        if (vf == null) {
            PsDebug.warning("missing vector field.");
            return false;
        }
        PdVector[] vector = vf.getVectors();
        if (vector == null || vector.length < this.m_numVertices) {
            PsDebug.warning("missing vectors.");
            return false;
        }
        this.assureVertexColors();
        Color[] color = this.getVertexColors();
        PdVector len = new PdVector(this.m_numVertices);
        int i = 0;
        while (i < this.m_numVertices) {
            len.m_data[i] = vector[i].length();
            ++i;
        }
        float min = (float)len.min();
        float del = (float)len.max() - min;
        int i2 = 0;
        while (i2 < this.m_numVertices) {
            color[i2] = Color.getHSBColor(((float)len.m_data[i2] - min) / del, 1.0f, 1.0f);
            ++i2;
        }
        this.setVertexColors(color);
        return true;
    }

    public PdVector[] getVertexNormals() {
        return this.m_vertexNormal;
    }

    public boolean isShowingVertexNormals() {
        return this.m_bShowVertexNormals;
    }

    public void showVertexNormals(boolean flag) {
        this.m_bShowVertexNormals = flag;
    }

    public void assureVertexNormals() {
        if (this.m_vertexNormal == null || this.m_vertexNormal.length != this.m_maxNumVertices) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, this.m_maxNumVertices, this.m_dim);
        }
    }

    public void setVertexNormals(PdVector[] aVertexNormalList) {
        if (aVertexNormalList == null) {
            this.m_vertexNormal = null;
            return;
        }
        if (aVertexNormalList.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexNormals();
        PdVector.copy(this.m_vertexNormal, 0, aVertexNormalList, 0, this.m_numVertices);
    }

    public PgPointSet() {
        this(3);
    }

    public PgPointSet(int aVertexDim) {
        super(aVertexDim);
        this.setTag(4);
        this.setTag(5);
        this.m_dimOfSimplex = 0;
        this.m_dimOfVectors = aVertexDim;
        this.m_vertex = new PdVector[0];
        this.m_globalVertexSize = new PuInteger(PsConfig.getMessage("globalVertexSize"), this);
        this.m_globalVertexColor = new PdColor(PsConfig.getMessage("globalVertexColor"), this);
        this.m_globalVertexTagColor = new PdColor(PsConfig.getMessage("globalVertexTagColor"), this);
        this.m_globalVertexNormalLength = new PuDouble(PsConfig.getMessage("globalVertexNormalLength"), this);
        this.m_globalVertexNormalSize = new PuDouble(PsConfig.getMessage("globalVertexNormalSize"), this);
        this.m_globalVertexNormalColor = new PdColor(PsConfig.getMessage("globalVertexNormalColor"), this);
        this.m_globalVectorSize = new PuDouble(PsConfig.getMessage("globalVectorSize"), this);
        this.m_globalVectorLength = new PuDouble(PsConfig.getMessage("globalVectorLength"), this);
        this.m_globalVectorColor = new PdColor(PsConfig.getMessage("globalVectorColor"), this);
        this.m_transparency = new PuDouble(PsConfig.getMessage("cTransparency"), this);
        this.m_bShowVectorColors = false;
        if (this.getClass() == (class$jv$geom$PgPointSet != null ? class$jv$geom$PgPointSet : (class$jv$geom$PgPointSet = PgPointSet.class$("jv.geom.PgPointSet")))) {
            this.init();
        }
    }

    public Color getVertexColor(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexColor[anIndex];
    }

    public PdVector getVertex(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numVertices) {
            PsDebug.warning("index out of range");
            return null;
        }
        return this.m_vertex[anIndex];
    }

    public void paint(PvGeometryIf dc) {
        super.paint(dc);
        dc.setState(80, this.isShowingIndices());
        dc.setState(81, this.isShowingVertexLabels());
        dc.setState(85, this.isDefaultLabelEnabled());
        dc.setState(50, this.m_bShowVertices);
        dc.setState(51, this.m_bShowTaggedVertices);
        if (this.m_globalVertexSize != null) {
            dc.setGlobalVertexSize(this.m_globalVertexSize.getValue());
        }
        if (this.m_globalVertexColor != null) {
            dc.setGlobalVertexColor(this.m_globalVertexColor.getColor());
        }
        if (this.m_globalVertexTagColor != null) {
            dc.setGlobalVertexTagColor(this.m_globalVertexTagColor.getColor());
        }
        dc.setNumVertices(this.m_numVertices);
        dc.setVertices(this.m_vertex);
        dc.setState(90, this.m_bShowVertexColors);
        dc.setVertexColors(this.m_vertexColor);
        dc.setState(60, this.m_bShowVertexNormals);
        dc.setState(61, this.m_bShowVertexNormalArrow);
        dc.setVertexNormals(this.m_vertexNormal);
        if (this.m_globalVertexNormalSize != null) {
            dc.setGlobalVertexNormalSize(this.m_globalVertexNormalSize.getValue());
        }
        if (this.m_globalVertexNormalLength != null) {
            dc.setGlobalVertexNormalLength(this.m_globalVertexNormalLength.getValue());
        }
        if (this.m_globalVertexNormalColor != null) {
            dc.setGlobalVertexNormalColor(this.m_globalVertexNormalColor.getColor());
        }
        dc.setState(71, this.m_bShowVertexTexture);
        if (this.m_bShowVertexTexture) {
            if (this.m_texture != null) {
                dc.setTexture(PsImage.getPixels(this.m_texture.getImage(), this.m_texture.getUMin(), this.m_texture.getVMin(), this.m_texture.getWidth(), this.m_texture.getHeight(), null, 0, this.m_texture.getWidth()), this.m_texture.getWidth(), this.m_texture.getHeight());
            }
            dc.setVertexTextures(this.m_vertexTexture);
        }
        dc.setState(73, this.m_bShowTransparency);
        dc.setTransparency(this.m_transparency.getValue());
        dc.setNumVectorFields(this.m_numVectorFields);
        int i = 0;
        while (i < this.m_numVectorFields) {
            PgVectorField vf = this.getVectorField(i);
            vf.setIndex(i);
            vf.paint(dc);
            dc.showVectorField(i, this.m_bShowVectorFields);
            dc.showVectorArrows(i, this.m_bShowVectorArrows);
            dc.showVectorColors(i, this.m_bShowVectorColors);
            dc.setGlobalVectorColor(i, this.m_globalVectorColor.getColor());
            dc.setGlobalVectorLength(i, this.m_globalVectorLength.getValue());
            dc.setGlobalVectorSize(i, this.m_globalVectorSize.getValue());
            ++i;
        }
    }

    public void clearTagVertex(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex >= this.m_numVertices) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return;
        }
        this.m_vertex[anIndex].clearTag(aTag);
    }

    public void setTransparency(double alpha) {
        this.m_transparency.setValue(alpha);
    }

    public boolean isShowingVectorField() {
        return this.m_bShowVectorFields;
    }

    public void showVectorField(boolean flag) {
        this.m_bShowVectorFields = flag;
    }

    public boolean setVertex(int anIndex, PdVector aVertex) {
        if (anIndex < 0) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        if (aVertex == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (anIndex >= this.m_numVertices) {
            this.setNumVertices(anIndex + 1);
        }
        this.m_vertex[anIndex].copy(aVertex);
        return true;
    }

    public void setVertex(int anIndex, double x) {
        if (anIndex < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 1) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (anIndex >= this.m_numVertices) {
            PsDebug.warning("index=" + anIndex + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(anIndex + 1);
        }
        this.m_vertex[anIndex].set(x);
    }

    public void setVertex(int anIndex, double x, double y) {
        if (anIndex < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 2) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (anIndex >= this.m_numVertices) {
            PsDebug.warning("index=" + anIndex + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(anIndex + 1);
        }
        this.m_vertex[anIndex].set(x, y);
    }

    public void setVertex(int anIndex, double x, double y, double z) {
        if (anIndex < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 3) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (anIndex >= this.m_numVertices) {
            PsDebug.warning("index=" + anIndex + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(anIndex + 1);
        }
        this.m_vertex[anIndex].set(x, y, z);
    }

    public void setVertexColor(int anIndex, Color aVertex) {
        if (anIndex < 0 || aVertex == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexColor == null || anIndex >= this.m_vertexColor.length) {
            this.assureVertexColors();
        }
        this.m_vertexColor[anIndex] = aVertex;
    }

    public boolean isShowingVertexNormalArrow() {
        return this.m_bShowVertexNormalArrow;
    }

    public void showVertexNormalArrow(boolean flag) {
        this.m_bShowVertexNormalArrow = flag;
    }

    public int getIndexOfVectorField(PgVectorField aVectorField) {
        return this.m_vectorField.indexOf(aVectorField);
    }

    public PgVectorField getVectorField(String name) {
        if (this.m_vectorField != null) {
            Enumeration e = this.m_vectorField.elements();
            while (e.hasMoreElements()) {
                PgVectorField data = (PgVectorField)e.nextElement();
                if (!name.equals(data.getName())) continue;
                return data;
            }
        }
        PsDebug.notify("data = >>" + name + "<< not found");
        return null;
    }

    public PgVectorField getVectorField(int anInd) {
        if (this.m_vectorField == null || anInd >= this.m_numVectorFields) {
            return null;
        }
        return (PgVectorField)this.m_vectorField.elementAt(anInd);
    }

    public PdVector getVertexNormal(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexNormal[anIndex];
    }

    public void setVertexNormal(int anIndex, PdVector aVertex) {
        if (anIndex < 0 || aVertex == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexNormal == null || anIndex >= this.m_vertexNormal.length) {
            this.assureVertexNormals();
        }
        this.m_vertexNormal[anIndex].copy(aVertex);
    }

    protected Vector getVectorField() {
        return this.m_vectorField;
    }

    public boolean isShowingIndices() {
        return this.m_bShowIndices;
    }

    public void showIndices(boolean flag) {
        this.m_bShowIndices = flag;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc jvx = super.getJvx();
        jvx.setType(30);
        jvx.showIndices(this.isShowingIndices());
        jvx.showVertexLabels(this.isShowingVertexLabels());
        jvx.showVertices(this.isShowingVertices());
        jvx.setDimOfVertices(this.getDimOfVertices());
        jvx.setNumVertices(this.getNumVertices());
        jvx.setVertices(this.getVertices());
        jvx.setGlobalVertexColor(this.getGlobalVertexColor());
        jvx.setGlobalVertexTagColor(this.getGlobalVertexTagColor());
        jvx.setGlobalVertexSize(this.getGlobalVertexSize());
        if (this.hasVertexColors()) {
            jvx.showVertexColors(this.isShowingVertexColors());
            jvx.setVertexColors(this.getVertexColors());
        } else {
            jvx.showVertexColors(false);
        }
        if (this.hasVertexNormals()) {
            jvx.showVertexNormals(this.isShowingVertexNormals());
            jvx.setVertexNormals(this.getVertexNormals());
        } else {
            jvx.showVertexNormals(false);
        }
        jvx.showVertexNormalArrow(this.isShowingVertexNormalArrow());
        jvx.setGlobalVertexNormalColor(this.getGlobalVertexNormalColor());
        jvx.setGlobalVertexNormalLength(this.getGlobalVertexNormalLength());
        jvx.setGlobalVertexNormalSize(this.getGlobalVertexNormalSize());
        if (this.m_texture != null) {
            jvx.setTextureImage(this.m_texture.getImage());
            jvx.setTextureImageName(this.m_texture.getImageName());
        }
        if (this.hasVertexTextures()) {
            jvx.showVertexTexture(this.isShowingVertexTexture());
            jvx.setVertexTextures(this.getVertexTextures());
        } else {
            jvx.showVertexTexture(false);
        }
        if (this.getVectorField() != null) {
            int numFields = this.getNumVectorFields();
            jvx.setNumVectorFields(numFields);
            int j = 0;
            while (j < numFields) {
                PgVectorField vf = this.getVectorField(j);
                jvx.setVectorFieldName(j, vf.getName());
                if (vf.getBasedOn() == 0) {
                    jvx.setVectorElementBased(j, false);
                } else {
                    jvx.setVectorElementBased(j, true);
                }
                jvx.showVectorArrows(j, this.isShowingVectorArrows());
                jvx.setNumVectors(j, vf.getNumVectors(), vf.getDimOfVertices());
                jvx.setVectors(j, vf.getVectors());
                jvx.setVectorColors(j, vf.getVectorColors());
                jvx.setGlobalVectorSize(j, this.getGlobalVectorSize());
                jvx.setGlobalVectorLength(j, this.getGlobalVectorLength());
                jvx.setGlobalVectorColor(j, this.getGlobalVectorColor());
                ++j;
            }
        }
        return jvx;
    }

    public void setJvx(PgJvxSrc src) {
        super.setJvx(src);
        this.showIndices(src.isShowingIndices());
        this.showVertexLabels(src.isShowingVertexLabels());
        this.showVertices(src.isShowingVertices());
        this.setNumVertices(src.getNumVertices());
        this.setVertices(src.getVertices());
        if (src.getGlobalVertexColor() != null) {
            this.setGlobalVertexColor(src.getGlobalVertexColor());
        }
        if (src.getGlobalVertexTagColor() != null) {
            this.setGlobalVertexTagColor(src.getGlobalVertexTagColor());
        }
        this.setGlobalVertexSize((int)src.getGlobalVertexSize());
        this.setVertexColors(src.getVertexColors());
        this.showVertexColors(src.isShowingVertexColors());
        this.showVertexNormals(src.isShowingVertexNormals());
        this.showVertexNormalArrow(src.isShowingVertexNormalArrow());
        this.setVertexNormals(src.getVertexNormals());
        if (src.getGlobalVertexNormalColor() != null) {
            this.setGlobalVertexNormalColor(src.getGlobalVertexNormalColor());
        }
        if (src.getGlobalVertexNormalLength() != 0.0) {
            this.setGlobalVertexNormalLength(src.getGlobalVertexNormalLength());
        }
        if (src.getGlobalVertexNormalSize() != 0.0) {
            this.setGlobalVertexNormalSize(src.getGlobalVertexNormalSize());
        }
        if (src.getTextureImage() != null) {
            this.setTextureImage(src.getTextureImage());
        }
        if (src.getTextureImageName() != null) {
            this.setTextureImageName(src.getTextureImageName());
        }
        if (src.getVertexTextures() != null) {
            this.assureVertexTextures();
        }
        this.setVertexTextures(src.getVertexTextures());
        this.showVertexTexture(src.isShowingVertexTexture());
        if (src.getNumVectorFields() > 0) {
            this.removeAllVectorFields();
            int numFields = src.getNumVectorFields();
            int k = 0;
            while (k < numFields) {
                PdVector[] vector;
                if (!src.isVectorElementBased(k) && (vector = src.getVectors(k)) != null && vector.length != 0) {
                    int numVectors = vector.length;
                    PgVectorField vf = new PgVectorField(src.getDimOfVectors(k));
                    vf.setName(src.getVectorFieldName(k));
                    vf.setGeometry(this);
                    vf.setBasedOn(0);
                    vf.setNumVectors(numVectors);
                    if (vf.setVectors(vector)) {
                        this.addVectorField(vf);
                    }
                    this.showVectorArrows(src.isShowingVectorArrows(k));
                    if (src.getGlobalVectorSize(k) != 0.0) {
                        this.setGlobalVectorSize(src.getGlobalVectorSize(k));
                    }
                    if (src.getGlobalVectorLength(k) != 0.0) {
                        this.setGlobalVectorLength(src.getGlobalVectorLength(k));
                    }
                    if (src.getGlobalVectorColor(k) != null) {
                        this.setGlobalVectorColor(src.getGlobalVectorColor(k));
                    }
                }
                ++k;
            }
        }
    }

    public PdVector getCenterOfBndBox() {
        PdVector centerOfBndBox = new PdVector(this.m_dim);
        if (this.m_numVertices == 0) {
            return centerOfBndBox;
        }
        PdVector[] bndBox = this.getAmbientBounds();
        if (bndBox == null || bndBox.length < 2) {
            return centerOfBndBox;
        }
        centerOfBndBox.blend(0.5, bndBox[0], 0.5, bndBox[1]);
        return centerOfBndBox;
    }

    public void setCenterOfBndBox(PdVector center) {
        if (center == null) {
            PsDebug.warning("missing argument");
            return;
        }
        PdVector centerOfBndBox = this.getCenterOfBndBox();
        if (centerOfBndBox == null) {
            PsDebug.warning("missing current center");
            return;
        }
        PdVector diff = PdVector.subNew(center, centerOfBndBox);
        this.translate(diff);
    }

    public boolean makeVertexTextureFromBndBox(int ix, int iy) {
        if (this.m_dim < 2) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        int texDim = 2;
        if (ix >= this.m_dim) {
            ix = this.m_dim - 1;
        }
        if (iy >= this.m_dim) {
            iy = this.m_dim - 1;
        }
        int dim = Math.min(this.m_dim, texDim);
        dim = Math.min(this.m_dim, 3);
        this.assureVertexTextures();
        PdVector[] texCoord = this.getVertexTextures();
        PdVector[] bnd = this.getAmbientBounds();
        double[] diam = PdVector.subNew((PdVector)bnd[1], (PdVector)bnd[0]).m_data;
        PdVector vec = new PdVector(this.m_dim);
        int i = 0;
        while (i < this.m_numVertices) {
            vec.sub(this.m_vertex[i], bnd[0]);
            texCoord[i].m_data[0] = vec.m_data[ix] / diam[ix];
            texCoord[i].m_data[1] = vec.m_data[iy] / diam[iy];
            ++i;
        }
        return true;
    }

    public boolean isShowingVertexLabels() {
        return this.m_bShowVertexLabels;
    }

    public boolean isShowingVectorColors() {
        return this.m_bShowVectorColors;
    }

    public void showVertexLabels(boolean flag) {
        this.m_bShowVertexLabels = flag;
    }

    public void showVectorColors(boolean flag) {
        this.m_bShowVectorColors = flag;
    }

    public Color getGlobalVertexColor() {
        return this.m_globalVertexColor.getColor();
    }

    public Color getGlobalVertexNormalColor() {
        return this.m_globalVertexNormalColor.getColor();
    }

    public void setGlobalVertexColor(Color color) {
        this.m_globalVertexColor.setColor(color);
    }

    public void setGlobalVertexNormalColor(Color color) {
        this.m_globalVertexNormalColor.setColor(color);
    }

    public boolean removeVectorField(PgGeometryIf aVectorField) {
        if (this.m_vectorField == null) {
            return true;
        }
        if (this.m_vectorField.removeElement(aVectorField)) {
            if ((this.m_numVectorFields += -1) == 0) {
                this.m_vectorField = null;
                this.m_bShowVectorFields = false;
            }
            return true;
        }
        return false;
    }

    public PdVector[] getVertexTextures() {
        return this.m_vertexTexture;
    }

    public int getDimOfTextures() {
        return this.m_dimOfTextures;
    }

    public void setDimOfTextures(int dim) {
        if (dim == this.m_dimOfTextures) {
            return;
        }
        this.m_dimOfTextures = dim;
        this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_maxNumVertices, this.m_dimOfTextures);
    }

    public void assureVertexTextures() {
        if (this.m_vertexTexture == null || this.m_vertexTexture.length != this.m_maxNumVertices) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_maxNumVertices, this.m_dimOfTextures);
        }
    }

    public void setVertexTextures(PdVector[] aVertexTextureList) {
        if (aVertexTextureList == null) {
            this.m_vertexTexture = null;
            return;
        }
        if (aVertexTextureList.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexTextures();
        PdVector.copy(this.m_vertexTexture, 0, aVertexTextureList, 0, this.m_numVertices);
    }

    public int getNumVectorFields() {
        return this.m_numVectorFields;
    }

    public String toString() {
        int i;
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append(super.toString());
        strBuf.append("\t ******* PgPointSet ***********\n");
        strBuf.append("\t m_numVertices = " + this.m_numVertices + "\n");
        strBuf.append("\t ******* m_vertex *******\n");
        if (this.m_vertex != null && this.m_numVertices > 0) {
            i = 0;
            while (i < this.m_numVertices) {
                strBuf.append("\t [" + i + "] = " + this.m_vertex[i].toShortString());
                ++i;
            }
        } else {
            strBuf.append("\t m_vertex = null\n");
        }
        strBuf.append("\t ******* m_vertexNormal *******\n");
        if (this.m_vertexNormal != null && this.m_numVertices > 0) {
            i = 0;
            while (i < this.m_numVertices) {
                strBuf.append("\t [" + i + "] = " + this.m_vertexNormal[i].toShortString());
                ++i;
            }
        } else {
            strBuf.append("\t m_vertexNormal = null\n");
        }
        strBuf.append("\t ******* m_vertexTexture *******\n");
        if (this.m_vertexTexture != null && this.m_numVertices > 0) {
            i = 0;
            while (i < this.m_numVertices) {
                strBuf.append("\t [" + i + "] = " + this.m_vertexTexture[i].toShortString());
                ++i;
            }
        } else {
            strBuf.append("\t m_vertexTexture = null\n");
        }
        return strBuf.toString();
    }

    public void translate(PdVector diff) {
        int i = 0;
        while (i < this.m_numVertices) {
            this.m_vertex[i].add(diff);
            ++i;
        }
        if (this.m_center != null) {
            this.m_center.add(diff);
        }
    }

    public boolean isShowingVectorArrows() {
        return this.m_bShowVectorArrows;
    }

    public void showVectorArrows(boolean flag) {
        this.m_bShowVectorArrows = flag;
    }

    public void computeTorus(int numULines, int numVLines, double radius, double thick) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(numULines * numVLines);
        this.assureVertexNormals();
        double uFac = 0.0;
        double vFac = 0.0;
        if (numULines > 1) {
            uFac = Math.PI * 2 / (-1.0 + (double)numULines);
        }
        if (numVLines > 1) {
            vFac = Math.PI * 2 / (-1.0 + (double)numVLines);
        }
        int ind = 0;
        int i = 0;
        while (i < numULines) {
            double u = uFac * (double)i;
            double su = Math.sin(u);
            double cu = Math.cos(u);
            int j = 0;
            while (j < numVLines) {
                double v = Math.PI + vFac * (double)j;
                double sv = Math.sin(v);
                double cv = Math.cos(v);
                this.m_vertex[ind].m_data[0] = cu * (thick * cv + radius);
                this.m_vertex[ind].m_data[1] = su * (thick * cv + radius);
                this.m_vertex[ind].m_data[2] = thick * sv;
                this.m_vertexNormal[ind].m_data[0] = cu * cv;
                this.m_vertexNormal[ind].m_data[1] = su * cv;
                this.m_vertexNormal[ind].m_data[2] = sv;
                ++ind;
                ++j;
            }
            ++i;
        }
    }

    public String getTextureImageName() {
        if (this.m_texture == null) {
            return null;
        }
        return this.m_texture.getImageName();
    }

    public void setTextureImageName(String name) {
        if (name == null) {
            PsDebug.warning("missing texture file name");
            return;
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
        this.m_texture.setImageName(name);
    }

    public void copy(PgGeometry aGeom) {
        super.copy(aGeom);
        if (!(aGeom instanceof PgPointSet)) {
            return;
        }
        PgPointSet geom = (PgPointSet)aGeom;
        this.setNumVertices(geom.getNumVertices());
        if (this.m_dim == geom.getDimOfVertices()) {
            PdVector.copy(this.m_vertex, 0, geom.getVertices(), 0, this.m_numVertices);
        }
        if (geom.m_vertexColor != null) {
            this.assureVertexColors();
            PdColor.copy(this.m_vertexColor, 0, geom.getVertexColors(), 0, this.m_numVertices);
        } else {
            this.m_vertexColor = null;
        }
        if (geom.m_vertexNormal != null) {
            this.assureVertexNormals();
            PdVector.copy(this.m_vertexNormal, 0, geom.getVertexNormals(), 0, this.m_numVertices);
        } else {
            this.m_vertexNormal = null;
        }
        if (geom.m_vertexTexture != null) {
            this.assureVertexTextures();
            PdVector.copy(this.m_vertexTexture, 0, geom.getVertexTextures(), 0, this.m_numVertices);
        } else {
            this.m_vertexTexture = null;
        }
        this.setTexture(geom.m_texture);
        this.setDimOfVectors(geom.getDimOfVectors());
        this.removeAllVectorFields();
        int numvf = geom.getNumVectorFields();
        int i = 0;
        while (i < numvf) {
            PgVectorField vf = (PgVectorField)geom.getVectorField(i).clone();
            if (vf.getBasedOn() == 0) {
                vf.setGeometry(this);
            }
            this.addVectorField(vf);
            ++i;
        }
    }

    public void computeCylinder(int numULines, int numVLines, double radius, double length) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(numULines * numVLines);
        this.assureVertexNormals();
        double uFac = 0.0;
        double vFac = 0.0;
        if (numULines > 1) {
            uFac = Math.PI * 2 / (-1.0 + (double)numULines);
        }
        if (numVLines > 1) {
            vFac = length / (-1.0 + (double)numVLines);
        }
        int ind = 0;
        int i = 0;
        while (i < numULines) {
            double u = uFac * (double)i;
            double su = Math.sin(u);
            double cu = Math.cos(u);
            int j = 0;
            while (j < numVLines) {
                double v = -1.0 + vFac * (double)j;
                this.m_vertex[ind].m_data[0] = radius * cu;
                this.m_vertex[ind].m_data[1] = radius * su;
                this.m_vertex[ind].m_data[2] = radius * v;
                this.m_vertexNormal[ind].m_data[0] = cu;
                this.m_vertexNormal[ind].m_data[1] = su;
                this.m_vertexNormal[ind].m_data[2] = 0.0;
                ++ind;
                ++j;
            }
            ++i;
        }
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void flipOrientation() {
        if (this.m_vertexNormal != null) {
            int i = 0;
            while (i < this.m_numVertices) {
                this.m_vertexNormal[i].multScalar(-1.0);
                ++i;
            }
        }
    }

    public Color getGlobalVertexTagColor() {
        return this.m_globalVertexTagColor.getColor();
    }

    public void setGlobalVertexTagColor(Color color) {
        this.m_globalVertexTagColor.setColor(color);
    }

    public void projectToSphere(PdVector center, double radius) {
        if (center == null) {
            PsDebug.warning("missing center");
            return;
        }
        PdVector diff = new PdVector(this.m_dim);
        int i = 0;
        while (i < this.m_numVertices) {
            diff.sub(this.m_vertex[i], center);
            diff.setLength(radius);
            this.m_vertex[i].add(center, diff);
            ++i;
        }
    }

    public boolean merge(PgGeometryIf aGeom) {
        if (!super.merge(aGeom)) {
            return false;
        }
        if (!(aGeom instanceof PgPointSet)) {
            return false;
        }
        PgPointSet geom = (PgPointSet)aGeom;
        int oldNov = this.m_numVertices;
        int newNov = this.m_numVertices + geom.m_numVertices;
        this.setNumVertices(newNov);
        PdVector.copy(this.m_vertex, oldNov, geom.m_vertex, 0, geom.m_numVertices);
        if (geom.m_vertexColor != null) {
            if (this.m_vertexColor == null) {
                this.showVertexColors(geom.isShowingVertexColors());
                this.assureVertexColors();
                int globalColor = this.getGlobalVertexColor().getRGB();
                int i = 0;
                while (i < oldNov) {
                    this.setVertexColor(i, new Color(globalColor));
                    ++i;
                }
            } else {
                this.assureVertexColors();
            }
            PdColor.copy(this.m_vertexColor, oldNov, geom.m_vertexColor, 0, geom.m_numVertices);
        } else if (this.m_vertexColor != null) {
            int globalColor = geom.getGlobalVertexColor().getRGB();
            int i = oldNov;
            while (i < newNov) {
                this.setVertexColor(i, new Color(globalColor));
                ++i;
            }
        }
        if (geom.m_vertexNormal != null) {
            this.assureVertexNormals();
            PdVector.copy(this.m_vertexNormal, oldNov, geom.m_vertexNormal, 0, geom.m_numVertices);
        }
        if (geom.m_vertexTexture != null) {
            this.assureVertexTextures();
            PdVector.copy(this.m_vertexTexture, oldNov, geom.m_vertexTexture, 0, geom.m_numVertices);
        }
        return true;
    }

    public PdVector getCenterOfGravity() {
        if (this.m_dim < 0) {
            return null;
        }
        if (this.m_center == null) {
            this.m_center = new PdVector(this.m_dim);
        }
        this.m_center.setConstant(0.0);
        int i = 0;
        while (i < this.m_numVertices) {
            this.m_center.add(this.m_vertex[i]);
            ++i;
        }
        this.m_center.multScalar(1.0 / (double)this.m_numVertices);
        return this.m_center;
    }

    public void computeDisk(int numULines, int numVLines, double radius) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(numULines * numVLines);
        double uFac = radius / (-1.0 + (double)numULines);
        double vFac = Math.PI * 2 / (-1.0 + (double)numVLines);
        int ind = 0;
        int i = 0;
        while (i < numULines) {
            double u = uFac * (double)i;
            int j = 0;
            while (j < numVLines) {
                double v = vFac * (double)j;
                if (this.m_dim > 2) {
                    this.m_vertex[ind].setConstant(0.0);
                }
                this.m_vertex[ind].m_data[0] = u * Math.cos(v);
                this.m_vertex[ind].m_data[1] = u * Math.sin(v);
                ++ind;
                ++j;
            }
            ++i;
        }
        if (this.m_dim == 3) {
            this.assureVertexNormals();
            PdVector.setConstant(this.m_vertexNormal, new PdVector(0.0, 0.0, 1.0));
        } else {
            this.setVertexNormals(null);
        }
    }

    public double getGlobalVectorLength() {
        return this.m_globalVectorLength.getValue();
    }

    public void setGlobalVectorLength(double length) {
        this.m_globalVectorLength.setValue(length);
    }

    public boolean makeVertexTextureFromSphere(PdVector center) {
        if (this.m_dim < 3) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        if (center == null || center.getSize() != this.m_dim) {
            PsDebug.warning("Missing center or wrong dimension.");
            return false;
        }
        this.assureVertexTextures();
        PdVector[] texCoord = this.getVertexTextures();
        PdVector vec = new PdVector(this.m_dim);
        int i = 0;
        while (i < this.m_numVertices) {
            vec.sub(this.m_vertex[i], center);
            vec.normalize();
            double[] v = vec.m_data;
            double angleLat = 0.0;
            double angleMer = 0.0;
            if (v[0] > 1.0E-10) {
                angleLat = Math.atan(v[1] / v[0]);
            } else if (v[0] < -1.0E-10) {
                angleLat = Math.PI + Math.atan(v[1] / v[0]);
            } else if (v[1] > 1.0E-10) {
                angleLat = 1.5707963267948966;
            } else if (v[1] < -1.0E-10) {
                angleLat = -1.5707963267948966;
            }
            angleMer = Math.asin(v[2]);
            texCoord[i].set(0.25 + angleLat / 2.0 / Math.PI, 0.5 + angleMer / Math.PI);
            ++i;
        }
        return true;
    }

    protected void setDimOfVertices(int dim) {
        if (this.m_center != null) {
            this.m_center.setSize(dim);
        }
        int i = 0;
        while (i < this.m_maxNumVertices) {
            this.m_vertex[i].setSize(dim);
            ++i;
        }
        this.setDimOfVectors(dim);
        super.setDimOfVertices(dim);
    }

    public final int getMaxNumVertices() {
        return this.m_maxNumVertices;
    }

    public PdVector[] getVertices() {
        return this.m_vertex;
    }

    public boolean isShowingVertices() {
        return this.m_bShowVertices;
    }

    public void showVertices(boolean flag) {
        this.m_bShowVertices = flag;
    }

    protected void setMaxNumVertices(int aNumVertices) {
        if (this.m_maxNumVertices == aNumVertices) {
            return;
        }
        this.m_vertex = PdVector.realloc(this.m_vertex, aNumVertices, this.m_dim);
        int i = 0;
        while (i < aNumVertices) {
            this.m_vertex[i].clearTag(2);
            ++i;
        }
        if (this.m_vertexNormal != null) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, aNumVertices, this.m_dim);
        }
        if (this.m_vertexColor != null) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, aNumVertices);
        }
        if (this.m_vertexTexture != null) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, aNumVertices, this.m_dimOfTextures);
        }
        this.m_maxNumVertices = aNumVertices;
        if (this.m_maxNumVertices < this.m_numVertices) {
            this.m_numVertices = this.m_maxNumVertices;
        }
    }

    public void setVertices(PdVector[] aVertexList) {
        if (aVertexList == null || aVertexList.length == 0 || aVertexList.length < this.m_numVertices) {
            PsDebug.warning("void length of argument vertex array");
            return;
        }
        int dimSav = aVertexList[0].getSize();
        int i = 0;
        while (i < this.m_numVertices) {
            int dim = aVertexList[i].getSize();
            this.m_vertex[i].setSize(dim);
            if (dimSav != -1 && dim != dimSav) {
                dimSav = -1;
            }
            ++i;
        }
        this.m_dim = dimSav;
        PdVector.copy(this.m_vertex, 0, aVertexList, 0, this.m_numVertices);
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (event == null) {
            return super.update(null);
        }
        if (event == this.m_globalVertexSize) {
            PsDebug.notify("called with event=m_globalVertexSize");
            return super.update(null);
        }
        if (event == this.m_globalVertexColor) {
            PsDebug.notify("called with event=m_globalVertexColor");
            return super.update(null);
        }
        if (event == this.m_globalVertexTagColor) {
            PsDebug.notify("called with event=m_globalVertexTagColor");
            return super.update(null);
        }
        if (event == this.m_globalVertexNormalColor) {
            PsDebug.notify("called with event=m_globalVertexNormalColor");
            return super.update(null);
        }
        if (event == this.m_globalVertexNormalLength) {
            PsDebug.notify("called with event=m_globalVertexNormalLength");
            return super.update(null);
        }
        if (event == this.m_globalVertexNormalSize) {
            PsDebug.notify("called with event=m_globalVertexNormalSize");
            return super.update(null);
        }
        if (event == this.m_globalVectorColor) {
            PsDebug.notify("called with event=m_globalVectorColor");
            return super.update(null);
        }
        if (event == this.m_globalVectorLength) {
            PsDebug.notify("called with event=m_globalVectorLength");
            return super.update(null);
        }
        if (event == this.m_globalVectorSize) {
            PsDebug.notify("called with event=m_globalVectorSize");
            return super.update(null);
        }
        if (event == this.m_transparency) {
            PsDebug.notify("called with event=m_transparency");
            return super.update(null);
        }
        if (event == this.m_texture) {
            return super.update(null);
        }
        if (event == this) {
            PsDebug.notify("called with event=this");
            if (this.m_vectorField != null) {
                Enumeration e = this.m_vectorField.elements();
                while (e.hasMoreElements()) {
                    PgGeometryIf data = (PgGeometryIf)e.nextElement();
                    data.update(this);
                }
            }
            return super.update(this);
        }
        return super.update(event);
    }

    public int[] removeMarkedVertices() {
        int KEEP = 1;
        int DELETE = -1;
        int newnov = 0;
        int[] index = new int[this.m_numVertices];
        int i = 0;
        while (i < this.m_numVertices) {
            index[i] = this.m_vertex[i].hasTag(2) ? DELETE : KEEP;
            ++i;
        }
        newnov = 0;
        i = 0;
        while (i < this.m_numVertices) {
            if (index[i] == KEEP) {
                index[i] = newnov++;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numVertices) {
            if (index[i] != DELETE && index[i] < i) {
                this.m_vertex[index[i]].setSize(this.m_vertex[i].getSize());
                this.m_vertex[index[i]].copy(this.m_vertex[i]);
            }
            ++i;
        }
        if (this.m_vertexNormal != null) {
            i = 0;
            while (i < this.m_numVertices) {
                if (index[i] != DELETE && index[i] < i) {
                    this.m_vertexNormal[index[i]].setSize(this.m_vertexNormal[i].getSize());
                    this.m_vertexNormal[index[i]].copy(this.m_vertexNormal[i]);
                }
                ++i;
            }
        }
        if (this.m_vertexColor != null) {
            i = 0;
            while (i < this.m_numVertices) {
                if (index[i] != DELETE && index[i] < i) {
                    this.m_vertexColor[index[i]] = this.m_vertexColor[i];
                }
                ++i;
            }
        }
        if (this.m_vertexTexture != null) {
            i = 0;
            while (i < this.m_numVertices) {
                if (index[i] != DELETE && index[i] < i) {
                    this.m_vertexTexture[index[i]] = PdVector.copyNew(this.m_vertexTexture[i]);
                }
                ++i;
            }
        }
        int numVF = this.getNumVectorFields();
        i = 0;
        while (i < numVF) {
            PgVectorField vf = this.getVectorField(i);
            if (vf.getBasedOn() != 1) {
                int j = 0;
                while (j < this.m_numVertices) {
                    if (index[j] != DELETE && index[j] < j) {
                        vf.setVector(index[j], vf.getVector(j));
                    }
                    ++j;
                }
                vf.setNumVectors(newnov);
            }
            ++i;
        }
        PsDebug.notify("number of deleted vertexs = " + (this.m_numVertices - newnov));
        this.setNumVertices(newnov);
        this.setMaxNumVertices(newnov);
        return index;
    }

    public boolean makeVertexColorsFromXYZ() {
        this.assureVertexColors();
        Color[] color = this.getVertexColors();
        PdVector[] bnd = this.getAmbientBounds();
        int dim = Math.min(3, this.m_dim);
        float[] diag = new float[dim];
        int j = 0;
        while (j < dim) {
            diag[j] = (float)(bnd[1].m_data[j] - bnd[0].m_data[j]);
            ++j;
        }
        float[] vec = new float[dim];
        int i = 0;
        while (i < this.m_numVertices) {
            int j2 = 0;
            while (j2 < dim) {
                vec[j2] = (float)(this.m_vertex[i].m_data[j2] - bnd[0].m_data[j2]) / diag[j2];
                ++j2;
            }
            if (this.m_dim == 1) {
                color[i] = new Color(vec[0], 0.0f, 0.0f);
            } else if (this.m_dim == 2) {
                color[i] = new Color(vec[0], vec[1], 0.0f);
            } else if (this.m_dim >= 3) {
                color[i] = new Color(vec[0], vec[1], vec[2]);
            }
            ++i;
        }
        return true;
    }

    public PdVector[] getBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] bndBox = super.getBounds();
        PdVector.min(bndBox[0], this.m_vertex, this.m_numVertices);
        PdVector.max(bndBox[1], this.m_vertex, this.m_numVertices);
        int i = this.m_dim;
        while (i < 3) {
            bndBox[0].m_data[i] = 0.0;
            bndBox[1].m_data[i] = 0.0;
            ++i;
        }
        return bndBox;
    }

    public boolean hasVertexColors() {
        return this.m_vertexColor != null && this.m_vertexColor.length == this.m_maxNumVertices;
    }

    public boolean makeVertexColorsFromZ() {
        if (this.m_dim == 0) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        int dim = Math.min(2, this.m_dim - 1);
        this.assureVertexColors();
        Color[] color = this.getVertexColors();
        PdVector[] bnd = this.getAmbientBounds();
        float diag = (float)(bnd[1].m_data[dim] - bnd[0].m_data[dim]);
        float zMin = (float)bnd[0].getEntry(dim);
        int i = 0;
        while (i < this.m_numVertices) {
            float col = (float)(this.m_vertex[i].getEntry(dim) - (double)zMin) / diag;
            color[i] = new Color(1.0f - col, 0.0f, col);
            ++i;
        }
        return true;
    }

    public void scale(double factor) {
        if (this.m_center != null) {
            int i = 0;
            while (i < this.m_numVertices) {
                this.m_vertex[i].blend(1.0 - factor, this.m_center, factor, this.m_vertex[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_numVertices) {
                this.m_vertex[i].multScalar(factor);
                ++i;
            }
        }
    }

    public void scale(double factor, PdVector center) {
        if (center == null) {
            PsDebug.warning("missing center");
            return;
        }
        PdVector diff = new PdVector(this.m_dim);
        int i = 0;
        while (i < this.m_numVertices) {
            diff.sub(this.m_vertex[i], center);
            this.m_vertex[i].blendBase(center, factor, diff);
            ++i;
        }
    }

    public boolean makeVertexTextureFromCylinder(PdVector center, PdVector axis) {
        double z;
        if (this.m_dim < 3) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        if (center == null || center.getSize() != this.m_dim) {
            PsDebug.warning("Missing center or wrong dimension.");
            return false;
        }
        if (axis == null || axis.getSize() != this.m_dim) {
            PsDebug.warning("Missing axis or wrong dimension.");
            return false;
        }
        if (Math.abs(axis.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("Axis direction does not have unit length.");
            return false;
        }
        this.assureVertexTextures();
        PdVector[] texCoord = this.getVertexTextures();
        PdVector vec = new PdVector(this.m_dim);
        double zMin = Double.MAX_VALUE;
        double zMax = Double.MIN_VALUE;
        int i = 0;
        while (i < this.m_numVertices) {
            vec.sub(this.m_vertex[i], center);
            z = PdVector.dot(axis, vec);
            if (z < zMin) {
                zMin = z;
            }
            if (z > zMax) {
                zMax = z;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numVertices) {
            vec.sub(this.m_vertex[i], center);
            z = PdVector.dot(axis, vec);
            double[] v = vec.m_data;
            double angleLat = 0.0;
            if (v[0] > 1.0E-10) {
                angleLat = Math.atan(v[1] / v[0]);
            } else if (v[0] < -1.0E-10) {
                angleLat = Math.PI + Math.atan(v[1] / v[0]);
            } else if (v[1] > 1.0E-10) {
                angleLat = 1.5707963267948966;
            } else if (v[1] < -1.0E-10) {
                angleLat = -1.5707963267948966;
            }
            texCoord[i].set(0.25 + angleLat / 2.0 / Math.PI, (z - zMin) / (zMax - zMin));
            ++i;
        }
        return true;
    }

    public void computeRotation(PgPolygon meridian, int numULines) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        int numVLines = meridian.getNumVertices();
        this.setNumVertices(numULines * numVLines);
        this.assureVertexNormals();
        double uFac = 0.0;
        if (numULines > 1) {
            uFac = Math.PI * 2 / (-1.0 + (double)numULines);
        }
        int ind = 0;
        PdVector[] mer = meridian.getVertices();
        int i = 0;
        while (i < numULines) {
            double u = uFac * (double)i;
            double su = Math.sin(u);
            double cu = Math.cos(u);
            int j = 0;
            while (j < numVLines) {
                this.m_vertex[ind].m_data[0] = mer[j].m_data[0];
                this.m_vertex[ind].m_data[1] = cu * mer[j].m_data[1];
                this.m_vertex[ind].m_data[2] = su * mer[j].m_data[1];
                ++ind;
                ++j;
            }
            ++i;
        }
        if (meridian.hasVertexNormals()) {
            PdVector[] merNor = meridian.getVertexNormals();
            ind = 0;
            int i2 = 0;
            while (i2 < numULines) {
                double u = uFac * (double)i2;
                double su = Math.sin(u);
                double cu = Math.cos(u);
                int j = 0;
                while (j < numVLines) {
                    this.m_vertexNormal[ind].m_data[0] = merNor[j].m_data[0];
                    this.m_vertexNormal[ind].m_data[1] = cu * merNor[j].m_data[1];
                    this.m_vertexNormal[ind].m_data[2] = su * merNor[j].m_data[1];
                    ++ind;
                    ++j;
                }
                ++i2;
            }
        }
    }

    public boolean makeVertexColorsFromZHue() {
        if (this.m_dim == 0) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        int dim = Math.min(2, this.m_dim - 1);
        this.assureVertexColors();
        Color[] color = this.getVertexColors();
        PdVector[] bnd = this.getAmbientBounds();
        float diag = (float)(bnd[1].m_data[dim] - bnd[0].m_data[dim]);
        float zMin = (float)bnd[0].getEntry(dim);
        int i = 0;
        while (i < this.m_numVertices) {
            float col = (float)(this.m_vertex[i].getEntry(dim) - (double)zMin) / diag;
            color[i] = new Color(Color.HSBtoRGB(1.0f - col, 1.0f, 1.0f));
            ++i;
        }
        return true;
    }

    public boolean blend(double s, PgGeometry ag, double t, PgGeometry bg) {
        int i;
        if (!super.blend(s, ag, t, bg)) {
            return false;
        }
        if (!(ag instanceof PgPointSet)) {
            return false;
        }
        PgPointSet a = (PgPointSet)ag;
        PgPointSet b = (PgPointSet)bg;
        if (a.m_numVertices == 0) {
            PsDebug.warning("missing vertices of first argument");
            return false;
        }
        if (a.m_numVertices != b.m_numVertices) {
            PsDebug.warning("unequal number of vertices of a and b");
            return false;
        }
        this.m_dimOfVectors = a.m_dimOfVectors;
        this.m_dimOfColors = a.m_dimOfColors;
        this.m_dimOfTextures = a.m_dimOfTextures;
        this.setNumVertices(a.m_numVertices);
        if (a.m_vertex != null && b.m_vertex != null) {
            i = 0;
            while (i < this.m_numVertices) {
                this.m_vertex[i].blend(s, a.m_vertex[i], t, b.m_vertex[i]);
                ++i;
            }
        }
        if (a.m_vertexColor != null && b.m_vertexColor != null) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, this.m_numVertices);
            i = 0;
            while (i < this.m_numVertices) {
                this.m_vertexColor[i] = PdColor.blend(s, a.m_vertexColor[i], t, b.m_vertexColor[i]);
                ++i;
            }
        }
        if (a.m_vertexNormal != null && b.m_vertexNormal != null) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, this.m_numVertices, this.m_dim);
            i = 0;
            while (i < this.m_numVertices) {
                this.m_vertexNormal[i].blend(s, a.m_vertexNormal[i], t, b.m_vertexNormal[i]);
                this.m_vertexNormal[i].normalize();
                ++i;
            }
        }
        if (a.m_vertexTexture != null && b.m_vertexTexture != null) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_numVertices, this.m_dimOfTextures);
            i = 0;
            while (i < this.m_numVertices) {
                this.m_vertexTexture[i].blend(s, a.m_vertexTexture[i], t, b.m_vertexTexture[i]);
                ++i;
            }
        }
        return true;
    }

    public int getGlobalVertexSize() {
        return this.m_globalVertexSize.getValue();
    }

    public double getGlobalVertexNormalSize() {
        return this.m_globalVertexNormalSize.getValue();
    }

    public void setGlobalVertexSize(int size) {
        this.m_globalVertexSize.setValue(size);
    }

    public void setGlobalVertexNormalSize(double size) {
        this.m_globalVertexNormalSize.setValue(size);
    }

    public void setTagVertex(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex >= this.m_numVertices) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return;
        }
        this.m_vertex[anIndex].setTag(aTag);
    }

    public int hasVertex(PdVector aVertex, double eps) {
        int i = 0;
        while (i < this.m_numVertices) {
            if (this.m_vertex[i].equals(aVertex, eps)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int hasVertex(PdVector aVertex) {
        int i = 0;
        while (i < this.m_numVertices) {
            if (this.m_vertex[i].equals(aVertex)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] removeVertex(int ind) {
        this.m_vertex[ind].setTag(2);
        return this.removeMarkedVertices();
    }
}

